// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// AIEmployeeQuery is the builder for querying AIEmployee entities.
type AIEmployeeQuery struct {
	config
	ctx        *QueryContext
	order      []aiemployee.OrderOption
	inters     []Interceptor
	predicates []predicate.AIEmployee
	withAdmin  *AdminQuery
	withUser   *UserQuery
	modifiers  []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the AIEmployeeQuery builder.
func (aeq *AIEmployeeQuery) Where(ps ...predicate.AIEmployee) *AIEmployeeQuery {
	aeq.predicates = append(aeq.predicates, ps...)
	return aeq
}

// Limit the number of records to be returned by this query.
func (aeq *AIEmployeeQuery) Limit(limit int) *AIEmployeeQuery {
	aeq.ctx.Limit = &limit
	return aeq
}

// Offset to start from.
func (aeq *AIEmployeeQuery) Offset(offset int) *AIEmployeeQuery {
	aeq.ctx.Offset = &offset
	return aeq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (aeq *AIEmployeeQuery) Unique(unique bool) *AIEmployeeQuery {
	aeq.ctx.Unique = &unique
	return aeq
}

// Order specifies how the records should be ordered.
func (aeq *AIEmployeeQuery) Order(o ...aiemployee.OrderOption) *AIEmployeeQuery {
	aeq.order = append(aeq.order, o...)
	return aeq
}

// QueryAdmin chains the current query on the "admin" edge.
func (aeq *AIEmployeeQuery) QueryAdmin() *AdminQuery {
	query := (&AdminClient{config: aeq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := aeq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := aeq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(aiemployee.Table, aiemployee.FieldID, selector),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, aiemployee.AdminTable, aiemployee.AdminColumn),
		)
		fromU = sqlgraph.SetNeighbors(aeq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryUser chains the current query on the "user" edge.
func (aeq *AIEmployeeQuery) QueryUser() *UserQuery {
	query := (&UserClient{config: aeq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := aeq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := aeq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(aiemployee.Table, aiemployee.FieldID, selector),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, aiemployee.UserTable, aiemployee.UserColumn),
		)
		fromU = sqlgraph.SetNeighbors(aeq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first AIEmployee entity from the query.
// Returns a *NotFoundError when no AIEmployee was found.
func (aeq *AIEmployeeQuery) First(ctx context.Context) (*AIEmployee, error) {
	nodes, err := aeq.Limit(1).All(setContextOp(ctx, aeq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{aiemployee.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (aeq *AIEmployeeQuery) FirstX(ctx context.Context) *AIEmployee {
	node, err := aeq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first AIEmployee ID from the query.
// Returns a *NotFoundError when no AIEmployee ID was found.
func (aeq *AIEmployeeQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = aeq.Limit(1).IDs(setContextOp(ctx, aeq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{aiemployee.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (aeq *AIEmployeeQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := aeq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single AIEmployee entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one AIEmployee entity is found.
// Returns a *NotFoundError when no AIEmployee entities are found.
func (aeq *AIEmployeeQuery) Only(ctx context.Context) (*AIEmployee, error) {
	nodes, err := aeq.Limit(2).All(setContextOp(ctx, aeq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{aiemployee.Label}
	default:
		return nil, &NotSingularError{aiemployee.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (aeq *AIEmployeeQuery) OnlyX(ctx context.Context) *AIEmployee {
	node, err := aeq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only AIEmployee ID in the query.
// Returns a *NotSingularError when more than one AIEmployee ID is found.
// Returns a *NotFoundError when no entities are found.
func (aeq *AIEmployeeQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = aeq.Limit(2).IDs(setContextOp(ctx, aeq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{aiemployee.Label}
	default:
		err = &NotSingularError{aiemployee.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (aeq *AIEmployeeQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := aeq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of AIEmployees.
func (aeq *AIEmployeeQuery) All(ctx context.Context) ([]*AIEmployee, error) {
	ctx = setContextOp(ctx, aeq.ctx, ent.OpQueryAll)
	if err := aeq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*AIEmployee, *AIEmployeeQuery]()
	return withInterceptors[[]*AIEmployee](ctx, aeq, qr, aeq.inters)
}

// AllX is like All, but panics if an error occurs.
func (aeq *AIEmployeeQuery) AllX(ctx context.Context) []*AIEmployee {
	nodes, err := aeq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of AIEmployee IDs.
func (aeq *AIEmployeeQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if aeq.ctx.Unique == nil && aeq.path != nil {
		aeq.Unique(true)
	}
	ctx = setContextOp(ctx, aeq.ctx, ent.OpQueryIDs)
	if err = aeq.Select(aiemployee.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (aeq *AIEmployeeQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := aeq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (aeq *AIEmployeeQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, aeq.ctx, ent.OpQueryCount)
	if err := aeq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, aeq, querierCount[*AIEmployeeQuery](), aeq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (aeq *AIEmployeeQuery) CountX(ctx context.Context) int {
	count, err := aeq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (aeq *AIEmployeeQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, aeq.ctx, ent.OpQueryExist)
	switch _, err := aeq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (aeq *AIEmployeeQuery) ExistX(ctx context.Context) bool {
	exist, err := aeq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the AIEmployeeQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (aeq *AIEmployeeQuery) Clone() *AIEmployeeQuery {
	if aeq == nil {
		return nil
	}
	return &AIEmployeeQuery{
		config:     aeq.config,
		ctx:        aeq.ctx.Clone(),
		order:      append([]aiemployee.OrderOption{}, aeq.order...),
		inters:     append([]Interceptor{}, aeq.inters...),
		predicates: append([]predicate.AIEmployee{}, aeq.predicates...),
		withAdmin:  aeq.withAdmin.Clone(),
		withUser:   aeq.withUser.Clone(),
		// clone intermediate query.
		sql:       aeq.sql.Clone(),
		path:      aeq.path,
		modifiers: append([]func(*sql.Selector){}, aeq.modifiers...),
	}
}

// WithAdmin tells the query-builder to eager-load the nodes that are connected to
// the "admin" edge. The optional arguments are used to configure the query builder of the edge.
func (aeq *AIEmployeeQuery) WithAdmin(opts ...func(*AdminQuery)) *AIEmployeeQuery {
	query := (&AdminClient{config: aeq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	aeq.withAdmin = query
	return aeq
}

// WithUser tells the query-builder to eager-load the nodes that are connected to
// the "user" edge. The optional arguments are used to configure the query builder of the edge.
func (aeq *AIEmployeeQuery) WithUser(opts ...func(*UserQuery)) *AIEmployeeQuery {
	query := (&UserClient{config: aeq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	aeq.withUser = query
	return aeq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		AdminID uuid.UUID `json:"admin_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.AIEmployee.Query().
//		GroupBy(aiemployee.FieldAdminID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (aeq *AIEmployeeQuery) GroupBy(field string, fields ...string) *AIEmployeeGroupBy {
	aeq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &AIEmployeeGroupBy{build: aeq}
	grbuild.flds = &aeq.ctx.Fields
	grbuild.label = aiemployee.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		AdminID uuid.UUID `json:"admin_id,omitempty"`
//	}
//
//	client.AIEmployee.Query().
//		Select(aiemployee.FieldAdminID).
//		Scan(ctx, &v)
func (aeq *AIEmployeeQuery) Select(fields ...string) *AIEmployeeSelect {
	aeq.ctx.Fields = append(aeq.ctx.Fields, fields...)
	sbuild := &AIEmployeeSelect{AIEmployeeQuery: aeq}
	sbuild.label = aiemployee.Label
	sbuild.flds, sbuild.scan = &aeq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a AIEmployeeSelect configured with the given aggregations.
func (aeq *AIEmployeeQuery) Aggregate(fns ...AggregateFunc) *AIEmployeeSelect {
	return aeq.Select().Aggregate(fns...)
}

func (aeq *AIEmployeeQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range aeq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, aeq); err != nil {
				return err
			}
		}
	}
	for _, f := range aeq.ctx.Fields {
		if !aiemployee.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if aeq.path != nil {
		prev, err := aeq.path(ctx)
		if err != nil {
			return err
		}
		aeq.sql = prev
	}
	return nil
}

func (aeq *AIEmployeeQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*AIEmployee, error) {
	var (
		nodes       = []*AIEmployee{}
		_spec       = aeq.querySpec()
		loadedTypes = [2]bool{
			aeq.withAdmin != nil,
			aeq.withUser != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*AIEmployee).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &AIEmployee{config: aeq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(aeq.modifiers) > 0 {
		_spec.Modifiers = aeq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, aeq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := aeq.withAdmin; query != nil {
		if err := aeq.loadAdmin(ctx, query, nodes, nil,
			func(n *AIEmployee, e *Admin) { n.Edges.Admin = e }); err != nil {
			return nil, err
		}
	}
	if query := aeq.withUser; query != nil {
		if err := aeq.loadUser(ctx, query, nodes, nil,
			func(n *AIEmployee, e *User) { n.Edges.User = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (aeq *AIEmployeeQuery) loadAdmin(ctx context.Context, query *AdminQuery, nodes []*AIEmployee, init func(*AIEmployee), assign func(*AIEmployee, *Admin)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*AIEmployee)
	for i := range nodes {
		fk := nodes[i].AdminID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(admin.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "admin_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}
func (aeq *AIEmployeeQuery) loadUser(ctx context.Context, query *UserQuery, nodes []*AIEmployee, init func(*AIEmployee), assign func(*AIEmployee, *User)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*AIEmployee)
	for i := range nodes {
		fk := nodes[i].UserID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(user.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "user_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (aeq *AIEmployeeQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := aeq.querySpec()
	if len(aeq.modifiers) > 0 {
		_spec.Modifiers = aeq.modifiers
	}
	_spec.Node.Columns = aeq.ctx.Fields
	if len(aeq.ctx.Fields) > 0 {
		_spec.Unique = aeq.ctx.Unique != nil && *aeq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, aeq.driver, _spec)
}

func (aeq *AIEmployeeQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(aiemployee.Table, aiemployee.Columns, sqlgraph.NewFieldSpec(aiemployee.FieldID, field.TypeUUID))
	_spec.From = aeq.sql
	if unique := aeq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if aeq.path != nil {
		_spec.Unique = true
	}
	if fields := aeq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, aiemployee.FieldID)
		for i := range fields {
			if fields[i] != aiemployee.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if aeq.withAdmin != nil {
			_spec.Node.AddColumnOnce(aiemployee.FieldAdminID)
		}
		if aeq.withUser != nil {
			_spec.Node.AddColumnOnce(aiemployee.FieldUserID)
		}
	}
	if ps := aeq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := aeq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := aeq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := aeq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (aeq *AIEmployeeQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(aeq.driver.Dialect())
	t1 := builder.Table(aiemployee.Table)
	columns := aeq.ctx.Fields
	if len(columns) == 0 {
		columns = aiemployee.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if aeq.sql != nil {
		selector = aeq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if aeq.ctx.Unique != nil && *aeq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range aeq.modifiers {
		m(selector)
	}
	for _, p := range aeq.predicates {
		p(selector)
	}
	for _, p := range aeq.order {
		p(selector)
	}
	if offset := aeq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := aeq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (aeq *AIEmployeeQuery) ForUpdate(opts ...sql.LockOption) *AIEmployeeQuery {
	if aeq.driver.Dialect() == dialect.Postgres {
		aeq.Unique(false)
	}
	aeq.modifiers = append(aeq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return aeq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (aeq *AIEmployeeQuery) ForShare(opts ...sql.LockOption) *AIEmployeeQuery {
	if aeq.driver.Dialect() == dialect.Postgres {
		aeq.Unique(false)
	}
	aeq.modifiers = append(aeq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return aeq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (aeq *AIEmployeeQuery) Modify(modifiers ...func(s *sql.Selector)) *AIEmployeeSelect {
	aeq.modifiers = append(aeq.modifiers, modifiers...)
	return aeq.Select()
}

// AIEmployeeGroupBy is the group-by builder for AIEmployee entities.
type AIEmployeeGroupBy struct {
	selector
	build *AIEmployeeQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (aegb *AIEmployeeGroupBy) Aggregate(fns ...AggregateFunc) *AIEmployeeGroupBy {
	aegb.fns = append(aegb.fns, fns...)
	return aegb
}

// Scan applies the selector query and scans the result into the given value.
func (aegb *AIEmployeeGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, aegb.build.ctx, ent.OpQueryGroupBy)
	if err := aegb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AIEmployeeQuery, *AIEmployeeGroupBy](ctx, aegb.build, aegb, aegb.build.inters, v)
}

func (aegb *AIEmployeeGroupBy) sqlScan(ctx context.Context, root *AIEmployeeQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(aegb.fns))
	for _, fn := range aegb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*aegb.flds)+len(aegb.fns))
		for _, f := range *aegb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*aegb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := aegb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// AIEmployeeSelect is the builder for selecting fields of AIEmployee entities.
type AIEmployeeSelect struct {
	*AIEmployeeQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (aes *AIEmployeeSelect) Aggregate(fns ...AggregateFunc) *AIEmployeeSelect {
	aes.fns = append(aes.fns, fns...)
	return aes
}

// Scan applies the selector query and scans the result into the given value.
func (aes *AIEmployeeSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, aes.ctx, ent.OpQuerySelect)
	if err := aes.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AIEmployeeQuery, *AIEmployeeSelect](ctx, aes.AIEmployeeQuery, aes, aes.inters, v)
}

func (aes *AIEmployeeSelect) sqlScan(ctx context.Context, root *AIEmployeeQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(aes.fns))
	for _, fn := range aes.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*aes.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := aes.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (aes *AIEmployeeSelect) Modify(modifiers ...func(s *sql.Selector)) *AIEmployeeSelect {
	aes.modifiers = append(aes.modifiers, modifiers...)
	return aes
}
