// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// AIEmployeeDelete is the builder for deleting a AIEmployee entity.
type AIEmployeeDelete struct {
	config
	hooks    []Hook
	mutation *AIEmployeeMutation
}

// Where appends a list predicates to the AIEmployeeDelete builder.
func (aed *AIEmployeeDelete) Where(ps ...predicate.AIEmployee) *AIEmployeeDelete {
	aed.mutation.Where(ps...)
	return aed
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (aed *AIEmployeeDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, aed.sqlExec, aed.mutation, aed.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (aed *AIEmployeeDelete) ExecX(ctx context.Context) int {
	n, err := aed.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (aed *AIEmployeeDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(aiemployee.Table, sqlgraph.NewFieldSpec(aiemployee.FieldID, field.TypeUUID))
	if ps := aed.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, aed.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	aed.mutation.done = true
	return affected, err
}

// AIEmployeeDeleteOne is the builder for deleting a single AIEmployee entity.
type AIEmployeeDeleteOne struct {
	aed *AIEmployeeDelete
}

// Where appends a list predicates to the AIEmployeeDelete builder.
func (aedo *AIEmployeeDeleteOne) Where(ps ...predicate.AIEmployee) *AIEmployeeDeleteOne {
	aedo.aed.mutation.Where(ps...)
	return aedo
}

// Exec executes the deletion query.
func (aedo *AIEmployeeDeleteOne) Exec(ctx context.Context) error {
	n, err := aedo.aed.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{aiemployee.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (aedo *AIEmployeeDeleteOne) ExecX(ctx context.Context) {
	if err := aedo.Exec(ctx); err != nil {
		panic(err)
	}
}
