// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// AIEmployeeCreate is the builder for creating a AIEmployee entity.
type AIEmployeeCreate struct {
	config
	mutation *AIEmployeeMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetAdminID sets the "admin_id" field.
func (aec *AIEmployeeCreate) SetAdminID(u uuid.UUID) *AIEmployeeCreate {
	aec.mutation.SetAdminID(u)
	return aec
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (aec *AIEmployeeCreate) SetNillableAdminID(u *uuid.UUID) *AIEmployeeCreate {
	if u != nil {
		aec.SetAdminID(*u)
	}
	return aec
}

// SetUserID sets the "user_id" field.
func (aec *AIEmployeeCreate) SetUserID(u uuid.UUID) *AIEmployeeCreate {
	aec.mutation.SetUserID(u)
	return aec
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (aec *AIEmployeeCreate) SetNillableUserID(u *uuid.UUID) *AIEmployeeCreate {
	if u != nil {
		aec.SetUserID(*u)
	}
	return aec
}

// SetName sets the "name" field.
func (aec *AIEmployeeCreate) SetName(s string) *AIEmployeeCreate {
	aec.mutation.SetName(s)
	return aec
}

// SetPosition sets the "position" field.
func (aec *AIEmployeeCreate) SetPosition(cep consts.AIEmployeePosition) *AIEmployeeCreate {
	aec.mutation.SetPosition(cep)
	return aec
}

// SetRepositoryURL sets the "repository_url" field.
func (aec *AIEmployeeCreate) SetRepositoryURL(s string) *AIEmployeeCreate {
	aec.mutation.SetRepositoryURL(s)
	return aec
}

// SetRepositoryUser sets the "repository_user" field.
func (aec *AIEmployeeCreate) SetRepositoryUser(s string) *AIEmployeeCreate {
	aec.mutation.SetRepositoryUser(s)
	return aec
}

// SetPlatform sets the "platform" field.
func (aec *AIEmployeeCreate) SetPlatform(cp consts.RepoPlatform) *AIEmployeeCreate {
	aec.mutation.SetPlatform(cp)
	return aec
}

// SetToken sets the "token" field.
func (aec *AIEmployeeCreate) SetToken(s string) *AIEmployeeCreate {
	aec.mutation.SetToken(s)
	return aec
}

// SetWebhookSecret sets the "webhook_secret" field.
func (aec *AIEmployeeCreate) SetWebhookSecret(s string) *AIEmployeeCreate {
	aec.mutation.SetWebhookSecret(s)
	return aec
}

// SetWebhookURL sets the "webhook_url" field.
func (aec *AIEmployeeCreate) SetWebhookURL(s string) *AIEmployeeCreate {
	aec.mutation.SetWebhookURL(s)
	return aec
}

// SetCreatedBy sets the "created_by" field.
func (aec *AIEmployeeCreate) SetCreatedBy(cb consts.CreatedBy) *AIEmployeeCreate {
	aec.mutation.SetCreatedBy(cb)
	return aec
}

// SetParameters sets the "parameters" field.
func (aec *AIEmployeeCreate) SetParameters(tep *types.AIEmployeeParam) *AIEmployeeCreate {
	aec.mutation.SetParameters(tep)
	return aec
}

// SetCreatedAt sets the "created_at" field.
func (aec *AIEmployeeCreate) SetCreatedAt(t time.Time) *AIEmployeeCreate {
	aec.mutation.SetCreatedAt(t)
	return aec
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (aec *AIEmployeeCreate) SetNillableCreatedAt(t *time.Time) *AIEmployeeCreate {
	if t != nil {
		aec.SetCreatedAt(*t)
	}
	return aec
}

// SetUpdatedAt sets the "updated_at" field.
func (aec *AIEmployeeCreate) SetUpdatedAt(t time.Time) *AIEmployeeCreate {
	aec.mutation.SetUpdatedAt(t)
	return aec
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (aec *AIEmployeeCreate) SetNillableUpdatedAt(t *time.Time) *AIEmployeeCreate {
	if t != nil {
		aec.SetUpdatedAt(*t)
	}
	return aec
}

// SetID sets the "id" field.
func (aec *AIEmployeeCreate) SetID(u uuid.UUID) *AIEmployeeCreate {
	aec.mutation.SetID(u)
	return aec
}

// SetAdmin sets the "admin" edge to the Admin entity.
func (aec *AIEmployeeCreate) SetAdmin(a *Admin) *AIEmployeeCreate {
	return aec.SetAdminID(a.ID)
}

// SetUser sets the "user" edge to the User entity.
func (aec *AIEmployeeCreate) SetUser(u *User) *AIEmployeeCreate {
	return aec.SetUserID(u.ID)
}

// Mutation returns the AIEmployeeMutation object of the builder.
func (aec *AIEmployeeCreate) Mutation() *AIEmployeeMutation {
	return aec.mutation
}

// Save creates the AIEmployee in the database.
func (aec *AIEmployeeCreate) Save(ctx context.Context) (*AIEmployee, error) {
	aec.defaults()
	return withHooks(ctx, aec.sqlSave, aec.mutation, aec.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (aec *AIEmployeeCreate) SaveX(ctx context.Context) *AIEmployee {
	v, err := aec.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (aec *AIEmployeeCreate) Exec(ctx context.Context) error {
	_, err := aec.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aec *AIEmployeeCreate) ExecX(ctx context.Context) {
	if err := aec.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (aec *AIEmployeeCreate) defaults() {
	if _, ok := aec.mutation.CreatedAt(); !ok {
		v := aiemployee.DefaultCreatedAt()
		aec.mutation.SetCreatedAt(v)
	}
	if _, ok := aec.mutation.UpdatedAt(); !ok {
		v := aiemployee.DefaultUpdatedAt()
		aec.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (aec *AIEmployeeCreate) check() error {
	if _, ok := aec.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`db: missing required field "AIEmployee.name"`)}
	}
	if _, ok := aec.mutation.Position(); !ok {
		return &ValidationError{Name: "position", err: errors.New(`db: missing required field "AIEmployee.position"`)}
	}
	if _, ok := aec.mutation.RepositoryURL(); !ok {
		return &ValidationError{Name: "repository_url", err: errors.New(`db: missing required field "AIEmployee.repository_url"`)}
	}
	if _, ok := aec.mutation.RepositoryUser(); !ok {
		return &ValidationError{Name: "repository_user", err: errors.New(`db: missing required field "AIEmployee.repository_user"`)}
	}
	if _, ok := aec.mutation.Platform(); !ok {
		return &ValidationError{Name: "platform", err: errors.New(`db: missing required field "AIEmployee.platform"`)}
	}
	if _, ok := aec.mutation.Token(); !ok {
		return &ValidationError{Name: "token", err: errors.New(`db: missing required field "AIEmployee.token"`)}
	}
	if _, ok := aec.mutation.WebhookSecret(); !ok {
		return &ValidationError{Name: "webhook_secret", err: errors.New(`db: missing required field "AIEmployee.webhook_secret"`)}
	}
	if _, ok := aec.mutation.WebhookURL(); !ok {
		return &ValidationError{Name: "webhook_url", err: errors.New(`db: missing required field "AIEmployee.webhook_url"`)}
	}
	if _, ok := aec.mutation.CreatedBy(); !ok {
		return &ValidationError{Name: "created_by", err: errors.New(`db: missing required field "AIEmployee.created_by"`)}
	}
	if _, ok := aec.mutation.Parameters(); !ok {
		return &ValidationError{Name: "parameters", err: errors.New(`db: missing required field "AIEmployee.parameters"`)}
	}
	if _, ok := aec.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "AIEmployee.created_at"`)}
	}
	if _, ok := aec.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "AIEmployee.updated_at"`)}
	}
	return nil
}

func (aec *AIEmployeeCreate) sqlSave(ctx context.Context) (*AIEmployee, error) {
	if err := aec.check(); err != nil {
		return nil, err
	}
	_node, _spec := aec.createSpec()
	if err := sqlgraph.CreateNode(ctx, aec.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	aec.mutation.id = &_node.ID
	aec.mutation.done = true
	return _node, nil
}

func (aec *AIEmployeeCreate) createSpec() (*AIEmployee, *sqlgraph.CreateSpec) {
	var (
		_node = &AIEmployee{config: aec.config}
		_spec = sqlgraph.NewCreateSpec(aiemployee.Table, sqlgraph.NewFieldSpec(aiemployee.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = aec.conflict
	if id, ok := aec.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := aec.mutation.Name(); ok {
		_spec.SetField(aiemployee.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := aec.mutation.Position(); ok {
		_spec.SetField(aiemployee.FieldPosition, field.TypeString, value)
		_node.Position = value
	}
	if value, ok := aec.mutation.RepositoryURL(); ok {
		_spec.SetField(aiemployee.FieldRepositoryURL, field.TypeString, value)
		_node.RepositoryURL = value
	}
	if value, ok := aec.mutation.RepositoryUser(); ok {
		_spec.SetField(aiemployee.FieldRepositoryUser, field.TypeString, value)
		_node.RepositoryUser = value
	}
	if value, ok := aec.mutation.Platform(); ok {
		_spec.SetField(aiemployee.FieldPlatform, field.TypeString, value)
		_node.Platform = value
	}
	if value, ok := aec.mutation.Token(); ok {
		_spec.SetField(aiemployee.FieldToken, field.TypeString, value)
		_node.Token = value
	}
	if value, ok := aec.mutation.WebhookSecret(); ok {
		_spec.SetField(aiemployee.FieldWebhookSecret, field.TypeString, value)
		_node.WebhookSecret = value
	}
	if value, ok := aec.mutation.WebhookURL(); ok {
		_spec.SetField(aiemployee.FieldWebhookURL, field.TypeString, value)
		_node.WebhookURL = value
	}
	if value, ok := aec.mutation.CreatedBy(); ok {
		_spec.SetField(aiemployee.FieldCreatedBy, field.TypeString, value)
		_node.CreatedBy = value
	}
	if value, ok := aec.mutation.Parameters(); ok {
		_spec.SetField(aiemployee.FieldParameters, field.TypeJSON, value)
		_node.Parameters = value
	}
	if value, ok := aec.mutation.CreatedAt(); ok {
		_spec.SetField(aiemployee.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := aec.mutation.UpdatedAt(); ok {
		_spec.SetField(aiemployee.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := aec.mutation.AdminIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.AdminTable,
			Columns: []string{aiemployee.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.AdminID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := aec.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.UserTable,
			Columns: []string{aiemployee.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AIEmployee.Create().
//		SetAdminID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AIEmployeeUpsert) {
//			SetAdminID(v+v).
//		}).
//		Exec(ctx)
func (aec *AIEmployeeCreate) OnConflict(opts ...sql.ConflictOption) *AIEmployeeUpsertOne {
	aec.conflict = opts
	return &AIEmployeeUpsertOne{
		create: aec,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AIEmployee.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (aec *AIEmployeeCreate) OnConflictColumns(columns ...string) *AIEmployeeUpsertOne {
	aec.conflict = append(aec.conflict, sql.ConflictColumns(columns...))
	return &AIEmployeeUpsertOne{
		create: aec,
	}
}

type (
	// AIEmployeeUpsertOne is the builder for "upsert"-ing
	//  one AIEmployee node.
	AIEmployeeUpsertOne struct {
		create *AIEmployeeCreate
	}

	// AIEmployeeUpsert is the "OnConflict" setter.
	AIEmployeeUpsert struct {
		*sql.UpdateSet
	}
)

// SetAdminID sets the "admin_id" field.
func (u *AIEmployeeUpsert) SetAdminID(v uuid.UUID) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldAdminID, v)
	return u
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateAdminID() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldAdminID)
	return u
}

// ClearAdminID clears the value of the "admin_id" field.
func (u *AIEmployeeUpsert) ClearAdminID() *AIEmployeeUpsert {
	u.SetNull(aiemployee.FieldAdminID)
	return u
}

// SetUserID sets the "user_id" field.
func (u *AIEmployeeUpsert) SetUserID(v uuid.UUID) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateUserID() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldUserID)
	return u
}

// ClearUserID clears the value of the "user_id" field.
func (u *AIEmployeeUpsert) ClearUserID() *AIEmployeeUpsert {
	u.SetNull(aiemployee.FieldUserID)
	return u
}

// SetName sets the "name" field.
func (u *AIEmployeeUpsert) SetName(v string) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateName() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldName)
	return u
}

// SetPosition sets the "position" field.
func (u *AIEmployeeUpsert) SetPosition(v consts.AIEmployeePosition) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldPosition, v)
	return u
}

// UpdatePosition sets the "position" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdatePosition() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldPosition)
	return u
}

// SetRepositoryURL sets the "repository_url" field.
func (u *AIEmployeeUpsert) SetRepositoryURL(v string) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldRepositoryURL, v)
	return u
}

// UpdateRepositoryURL sets the "repository_url" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateRepositoryURL() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldRepositoryURL)
	return u
}

// SetRepositoryUser sets the "repository_user" field.
func (u *AIEmployeeUpsert) SetRepositoryUser(v string) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldRepositoryUser, v)
	return u
}

// UpdateRepositoryUser sets the "repository_user" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateRepositoryUser() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldRepositoryUser)
	return u
}

// SetPlatform sets the "platform" field.
func (u *AIEmployeeUpsert) SetPlatform(v consts.RepoPlatform) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldPlatform, v)
	return u
}

// UpdatePlatform sets the "platform" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdatePlatform() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldPlatform)
	return u
}

// SetToken sets the "token" field.
func (u *AIEmployeeUpsert) SetToken(v string) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldToken, v)
	return u
}

// UpdateToken sets the "token" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateToken() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldToken)
	return u
}

// SetWebhookSecret sets the "webhook_secret" field.
func (u *AIEmployeeUpsert) SetWebhookSecret(v string) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldWebhookSecret, v)
	return u
}

// UpdateWebhookSecret sets the "webhook_secret" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateWebhookSecret() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldWebhookSecret)
	return u
}

// SetWebhookURL sets the "webhook_url" field.
func (u *AIEmployeeUpsert) SetWebhookURL(v string) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldWebhookURL, v)
	return u
}

// UpdateWebhookURL sets the "webhook_url" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateWebhookURL() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldWebhookURL)
	return u
}

// SetCreatedBy sets the "created_by" field.
func (u *AIEmployeeUpsert) SetCreatedBy(v consts.CreatedBy) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldCreatedBy, v)
	return u
}

// UpdateCreatedBy sets the "created_by" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateCreatedBy() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldCreatedBy)
	return u
}

// SetParameters sets the "parameters" field.
func (u *AIEmployeeUpsert) SetParameters(v *types.AIEmployeeParam) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldParameters, v)
	return u
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateParameters() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldParameters)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *AIEmployeeUpsert) SetCreatedAt(v time.Time) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateCreatedAt() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AIEmployeeUpsert) SetUpdatedAt(v time.Time) *AIEmployeeUpsert {
	u.Set(aiemployee.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AIEmployeeUpsert) UpdateUpdatedAt() *AIEmployeeUpsert {
	u.SetExcluded(aiemployee.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.AIEmployee.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(aiemployee.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AIEmployeeUpsertOne) UpdateNewValues() *AIEmployeeUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(aiemployee.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AIEmployee.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *AIEmployeeUpsertOne) Ignore() *AIEmployeeUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AIEmployeeUpsertOne) DoNothing() *AIEmployeeUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AIEmployeeCreate.OnConflict
// documentation for more info.
func (u *AIEmployeeUpsertOne) Update(set func(*AIEmployeeUpsert)) *AIEmployeeUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AIEmployeeUpsert{UpdateSet: update})
	}))
	return u
}

// SetAdminID sets the "admin_id" field.
func (u *AIEmployeeUpsertOne) SetAdminID(v uuid.UUID) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetAdminID(v)
	})
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateAdminID() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateAdminID()
	})
}

// ClearAdminID clears the value of the "admin_id" field.
func (u *AIEmployeeUpsertOne) ClearAdminID() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.ClearAdminID()
	})
}

// SetUserID sets the "user_id" field.
func (u *AIEmployeeUpsertOne) SetUserID(v uuid.UUID) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateUserID() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *AIEmployeeUpsertOne) ClearUserID() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.ClearUserID()
	})
}

// SetName sets the "name" field.
func (u *AIEmployeeUpsertOne) SetName(v string) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateName() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateName()
	})
}

// SetPosition sets the "position" field.
func (u *AIEmployeeUpsertOne) SetPosition(v consts.AIEmployeePosition) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetPosition(v)
	})
}

// UpdatePosition sets the "position" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdatePosition() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdatePosition()
	})
}

// SetRepositoryURL sets the "repository_url" field.
func (u *AIEmployeeUpsertOne) SetRepositoryURL(v string) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetRepositoryURL(v)
	})
}

// UpdateRepositoryURL sets the "repository_url" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateRepositoryURL() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateRepositoryURL()
	})
}

// SetRepositoryUser sets the "repository_user" field.
func (u *AIEmployeeUpsertOne) SetRepositoryUser(v string) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetRepositoryUser(v)
	})
}

// UpdateRepositoryUser sets the "repository_user" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateRepositoryUser() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateRepositoryUser()
	})
}

// SetPlatform sets the "platform" field.
func (u *AIEmployeeUpsertOne) SetPlatform(v consts.RepoPlatform) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetPlatform(v)
	})
}

// UpdatePlatform sets the "platform" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdatePlatform() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdatePlatform()
	})
}

// SetToken sets the "token" field.
func (u *AIEmployeeUpsertOne) SetToken(v string) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetToken(v)
	})
}

// UpdateToken sets the "token" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateToken() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateToken()
	})
}

// SetWebhookSecret sets the "webhook_secret" field.
func (u *AIEmployeeUpsertOne) SetWebhookSecret(v string) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetWebhookSecret(v)
	})
}

// UpdateWebhookSecret sets the "webhook_secret" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateWebhookSecret() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateWebhookSecret()
	})
}

// SetWebhookURL sets the "webhook_url" field.
func (u *AIEmployeeUpsertOne) SetWebhookURL(v string) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetWebhookURL(v)
	})
}

// UpdateWebhookURL sets the "webhook_url" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateWebhookURL() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateWebhookURL()
	})
}

// SetCreatedBy sets the "created_by" field.
func (u *AIEmployeeUpsertOne) SetCreatedBy(v consts.CreatedBy) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetCreatedBy(v)
	})
}

// UpdateCreatedBy sets the "created_by" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateCreatedBy() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateCreatedBy()
	})
}

// SetParameters sets the "parameters" field.
func (u *AIEmployeeUpsertOne) SetParameters(v *types.AIEmployeeParam) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetParameters(v)
	})
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateParameters() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateParameters()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AIEmployeeUpsertOne) SetCreatedAt(v time.Time) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateCreatedAt() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AIEmployeeUpsertOne) SetUpdatedAt(v time.Time) *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AIEmployeeUpsertOne) UpdateUpdatedAt() *AIEmployeeUpsertOne {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *AIEmployeeUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AIEmployeeCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AIEmployeeUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *AIEmployeeUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: AIEmployeeUpsertOne.ID is not supported by MySQL driver. Use AIEmployeeUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *AIEmployeeUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// AIEmployeeCreateBulk is the builder for creating many AIEmployee entities in bulk.
type AIEmployeeCreateBulk struct {
	config
	err      error
	builders []*AIEmployeeCreate
	conflict []sql.ConflictOption
}

// Save creates the AIEmployee entities in the database.
func (aecb *AIEmployeeCreateBulk) Save(ctx context.Context) ([]*AIEmployee, error) {
	if aecb.err != nil {
		return nil, aecb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(aecb.builders))
	nodes := make([]*AIEmployee, len(aecb.builders))
	mutators := make([]Mutator, len(aecb.builders))
	for i := range aecb.builders {
		func(i int, root context.Context) {
			builder := aecb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*AIEmployeeMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, aecb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = aecb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, aecb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, aecb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (aecb *AIEmployeeCreateBulk) SaveX(ctx context.Context) []*AIEmployee {
	v, err := aecb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (aecb *AIEmployeeCreateBulk) Exec(ctx context.Context) error {
	_, err := aecb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aecb *AIEmployeeCreateBulk) ExecX(ctx context.Context) {
	if err := aecb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AIEmployee.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AIEmployeeUpsert) {
//			SetAdminID(v+v).
//		}).
//		Exec(ctx)
func (aecb *AIEmployeeCreateBulk) OnConflict(opts ...sql.ConflictOption) *AIEmployeeUpsertBulk {
	aecb.conflict = opts
	return &AIEmployeeUpsertBulk{
		create: aecb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AIEmployee.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (aecb *AIEmployeeCreateBulk) OnConflictColumns(columns ...string) *AIEmployeeUpsertBulk {
	aecb.conflict = append(aecb.conflict, sql.ConflictColumns(columns...))
	return &AIEmployeeUpsertBulk{
		create: aecb,
	}
}

// AIEmployeeUpsertBulk is the builder for "upsert"-ing
// a bulk of AIEmployee nodes.
type AIEmployeeUpsertBulk struct {
	create *AIEmployeeCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.AIEmployee.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(aiemployee.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AIEmployeeUpsertBulk) UpdateNewValues() *AIEmployeeUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(aiemployee.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AIEmployee.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *AIEmployeeUpsertBulk) Ignore() *AIEmployeeUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AIEmployeeUpsertBulk) DoNothing() *AIEmployeeUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AIEmployeeCreateBulk.OnConflict
// documentation for more info.
func (u *AIEmployeeUpsertBulk) Update(set func(*AIEmployeeUpsert)) *AIEmployeeUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AIEmployeeUpsert{UpdateSet: update})
	}))
	return u
}

// SetAdminID sets the "admin_id" field.
func (u *AIEmployeeUpsertBulk) SetAdminID(v uuid.UUID) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetAdminID(v)
	})
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateAdminID() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateAdminID()
	})
}

// ClearAdminID clears the value of the "admin_id" field.
func (u *AIEmployeeUpsertBulk) ClearAdminID() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.ClearAdminID()
	})
}

// SetUserID sets the "user_id" field.
func (u *AIEmployeeUpsertBulk) SetUserID(v uuid.UUID) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateUserID() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *AIEmployeeUpsertBulk) ClearUserID() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.ClearUserID()
	})
}

// SetName sets the "name" field.
func (u *AIEmployeeUpsertBulk) SetName(v string) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateName() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateName()
	})
}

// SetPosition sets the "position" field.
func (u *AIEmployeeUpsertBulk) SetPosition(v consts.AIEmployeePosition) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetPosition(v)
	})
}

// UpdatePosition sets the "position" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdatePosition() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdatePosition()
	})
}

// SetRepositoryURL sets the "repository_url" field.
func (u *AIEmployeeUpsertBulk) SetRepositoryURL(v string) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetRepositoryURL(v)
	})
}

// UpdateRepositoryURL sets the "repository_url" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateRepositoryURL() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateRepositoryURL()
	})
}

// SetRepositoryUser sets the "repository_user" field.
func (u *AIEmployeeUpsertBulk) SetRepositoryUser(v string) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetRepositoryUser(v)
	})
}

// UpdateRepositoryUser sets the "repository_user" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateRepositoryUser() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateRepositoryUser()
	})
}

// SetPlatform sets the "platform" field.
func (u *AIEmployeeUpsertBulk) SetPlatform(v consts.RepoPlatform) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetPlatform(v)
	})
}

// UpdatePlatform sets the "platform" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdatePlatform() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdatePlatform()
	})
}

// SetToken sets the "token" field.
func (u *AIEmployeeUpsertBulk) SetToken(v string) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetToken(v)
	})
}

// UpdateToken sets the "token" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateToken() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateToken()
	})
}

// SetWebhookSecret sets the "webhook_secret" field.
func (u *AIEmployeeUpsertBulk) SetWebhookSecret(v string) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetWebhookSecret(v)
	})
}

// UpdateWebhookSecret sets the "webhook_secret" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateWebhookSecret() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateWebhookSecret()
	})
}

// SetWebhookURL sets the "webhook_url" field.
func (u *AIEmployeeUpsertBulk) SetWebhookURL(v string) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetWebhookURL(v)
	})
}

// UpdateWebhookURL sets the "webhook_url" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateWebhookURL() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateWebhookURL()
	})
}

// SetCreatedBy sets the "created_by" field.
func (u *AIEmployeeUpsertBulk) SetCreatedBy(v consts.CreatedBy) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetCreatedBy(v)
	})
}

// UpdateCreatedBy sets the "created_by" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateCreatedBy() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateCreatedBy()
	})
}

// SetParameters sets the "parameters" field.
func (u *AIEmployeeUpsertBulk) SetParameters(v *types.AIEmployeeParam) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetParameters(v)
	})
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateParameters() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateParameters()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AIEmployeeUpsertBulk) SetCreatedAt(v time.Time) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateCreatedAt() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AIEmployeeUpsertBulk) SetUpdatedAt(v time.Time) *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AIEmployeeUpsertBulk) UpdateUpdatedAt() *AIEmployeeUpsertBulk {
	return u.Update(func(s *AIEmployeeUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *AIEmployeeUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the AIEmployeeCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AIEmployeeCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AIEmployeeUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
