// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// AIEmployee is the model entity for the AIEmployee schema.
type AIEmployee struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// AdminID holds the value of the "admin_id" field.
	AdminID uuid.UUID `json:"admin_id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// Position holds the value of the "position" field.
	Position consts.AIEmployeePosition `json:"position,omitempty"`
	// RepositoryURL holds the value of the "repository_url" field.
	RepositoryURL string `json:"repository_url,omitempty"`
	// RepositoryUser holds the value of the "repository_user" field.
	RepositoryUser string `json:"repository_user,omitempty"`
	// Platform holds the value of the "platform" field.
	Platform consts.RepoPlatform `json:"platform,omitempty"`
	// Token holds the value of the "token" field.
	Token string `json:"token,omitempty"`
	// WebhookSecret holds the value of the "webhook_secret" field.
	WebhookSecret string `json:"webhook_secret,omitempty"`
	// WebhookURL holds the value of the "webhook_url" field.
	WebhookURL string `json:"webhook_url,omitempty"`
	// CreatedBy holds the value of the "created_by" field.
	CreatedBy consts.CreatedBy `json:"created_by,omitempty"`
	// Parameters holds the value of the "parameters" field.
	Parameters *types.AIEmployeeParam `json:"parameters,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the AIEmployeeQuery when eager-loading is set.
	Edges        AIEmployeeEdges `json:"edges"`
	selectValues sql.SelectValues
}

// AIEmployeeEdges holds the relations/edges for other nodes in the graph.
type AIEmployeeEdges struct {
	// Admin holds the value of the admin edge.
	Admin *Admin `json:"admin,omitempty"`
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// AdminOrErr returns the Admin value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e AIEmployeeEdges) AdminOrErr() (*Admin, error) {
	if e.Admin != nil {
		return e.Admin, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: admin.Label}
	}
	return nil, &NotLoadedError{edge: "admin"}
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e AIEmployeeEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*AIEmployee) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case aiemployee.FieldParameters:
			values[i] = new([]byte)
		case aiemployee.FieldName, aiemployee.FieldPosition, aiemployee.FieldRepositoryURL, aiemployee.FieldRepositoryUser, aiemployee.FieldPlatform, aiemployee.FieldToken, aiemployee.FieldWebhookSecret, aiemployee.FieldWebhookURL, aiemployee.FieldCreatedBy:
			values[i] = new(sql.NullString)
		case aiemployee.FieldCreatedAt, aiemployee.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case aiemployee.FieldID, aiemployee.FieldAdminID, aiemployee.FieldUserID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the AIEmployee fields.
func (ae *AIEmployee) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case aiemployee.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ae.ID = *value
			}
		case aiemployee.FieldAdminID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field admin_id", values[i])
			} else if value != nil {
				ae.AdminID = *value
			}
		case aiemployee.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				ae.UserID = *value
			}
		case aiemployee.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				ae.Name = value.String
			}
		case aiemployee.FieldPosition:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field position", values[i])
			} else if value.Valid {
				ae.Position = consts.AIEmployeePosition(value.String)
			}
		case aiemployee.FieldRepositoryURL:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field repository_url", values[i])
			} else if value.Valid {
				ae.RepositoryURL = value.String
			}
		case aiemployee.FieldRepositoryUser:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field repository_user", values[i])
			} else if value.Valid {
				ae.RepositoryUser = value.String
			}
		case aiemployee.FieldPlatform:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field platform", values[i])
			} else if value.Valid {
				ae.Platform = consts.RepoPlatform(value.String)
			}
		case aiemployee.FieldToken:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field token", values[i])
			} else if value.Valid {
				ae.Token = value.String
			}
		case aiemployee.FieldWebhookSecret:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field webhook_secret", values[i])
			} else if value.Valid {
				ae.WebhookSecret = value.String
			}
		case aiemployee.FieldWebhookURL:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field webhook_url", values[i])
			} else if value.Valid {
				ae.WebhookURL = value.String
			}
		case aiemployee.FieldCreatedBy:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field created_by", values[i])
			} else if value.Valid {
				ae.CreatedBy = consts.CreatedBy(value.String)
			}
		case aiemployee.FieldParameters:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field parameters", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &ae.Parameters); err != nil {
					return fmt.Errorf("unmarshal field parameters: %w", err)
				}
			}
		case aiemployee.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ae.CreatedAt = value.Time
			}
		case aiemployee.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				ae.UpdatedAt = value.Time
			}
		default:
			ae.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the AIEmployee.
// This includes values selected through modifiers, order, etc.
func (ae *AIEmployee) Value(name string) (ent.Value, error) {
	return ae.selectValues.Get(name)
}

// QueryAdmin queries the "admin" edge of the AIEmployee entity.
func (ae *AIEmployee) QueryAdmin() *AdminQuery {
	return NewAIEmployeeClient(ae.config).QueryAdmin(ae)
}

// QueryUser queries the "user" edge of the AIEmployee entity.
func (ae *AIEmployee) QueryUser() *UserQuery {
	return NewAIEmployeeClient(ae.config).QueryUser(ae)
}

// Update returns a builder for updating this AIEmployee.
// Note that you need to call AIEmployee.Unwrap() before calling this method if this AIEmployee
// was returned from a transaction, and the transaction was committed or rolled back.
func (ae *AIEmployee) Update() *AIEmployeeUpdateOne {
	return NewAIEmployeeClient(ae.config).UpdateOne(ae)
}

// Unwrap unwraps the AIEmployee entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ae *AIEmployee) Unwrap() *AIEmployee {
	_tx, ok := ae.config.driver.(*txDriver)
	if !ok {
		panic("db: AIEmployee is not a transactional entity")
	}
	ae.config.driver = _tx.drv
	return ae
}

// String implements the fmt.Stringer.
func (ae *AIEmployee) String() string {
	var builder strings.Builder
	builder.WriteString("AIEmployee(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ae.ID))
	builder.WriteString("admin_id=")
	builder.WriteString(fmt.Sprintf("%v", ae.AdminID))
	builder.WriteString(", ")
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", ae.UserID))
	builder.WriteString(", ")
	builder.WriteString("name=")
	builder.WriteString(ae.Name)
	builder.WriteString(", ")
	builder.WriteString("position=")
	builder.WriteString(fmt.Sprintf("%v", ae.Position))
	builder.WriteString(", ")
	builder.WriteString("repository_url=")
	builder.WriteString(ae.RepositoryURL)
	builder.WriteString(", ")
	builder.WriteString("repository_user=")
	builder.WriteString(ae.RepositoryUser)
	builder.WriteString(", ")
	builder.WriteString("platform=")
	builder.WriteString(fmt.Sprintf("%v", ae.Platform))
	builder.WriteString(", ")
	builder.WriteString("token=")
	builder.WriteString(ae.Token)
	builder.WriteString(", ")
	builder.WriteString("webhook_secret=")
	builder.WriteString(ae.WebhookSecret)
	builder.WriteString(", ")
	builder.WriteString("webhook_url=")
	builder.WriteString(ae.WebhookURL)
	builder.WriteString(", ")
	builder.WriteString("created_by=")
	builder.WriteString(fmt.Sprintf("%v", ae.CreatedBy))
	builder.WriteString(", ")
	builder.WriteString("parameters=")
	builder.WriteString(fmt.Sprintf("%v", ae.Parameters))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ae.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(ae.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// AIEmployees is a parsable slice of AIEmployee.
type AIEmployees []*AIEmployee
