// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// AdminLoginHistoryUpdate is the builder for updating AdminLoginHistory entities.
type AdminLoginHistoryUpdate struct {
	config
	hooks     []Hook
	mutation  *AdminLoginHistoryMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the AdminLoginHistoryUpdate builder.
func (alhu *AdminLoginHistoryUpdate) Where(ps ...predicate.AdminLoginHistory) *AdminLoginHistoryUpdate {
	alhu.mutation.Where(ps...)
	return alhu
}

// SetAdminID sets the "admin_id" field.
func (alhu *AdminLoginHistoryUpdate) SetAdminID(u uuid.UUID) *AdminLoginHistoryUpdate {
	alhu.mutation.SetAdminID(u)
	return alhu
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableAdminID(u *uuid.UUID) *AdminLoginHistoryUpdate {
	if u != nil {
		alhu.SetAdminID(*u)
	}
	return alhu
}

// ClearAdminID clears the value of the "admin_id" field.
func (alhu *AdminLoginHistoryUpdate) ClearAdminID() *AdminLoginHistoryUpdate {
	alhu.mutation.ClearAdminID()
	return alhu
}

// SetIP sets the "ip" field.
func (alhu *AdminLoginHistoryUpdate) SetIP(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetIP(s)
	return alhu
}

// SetNillableIP sets the "ip" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableIP(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetIP(*s)
	}
	return alhu
}

// SetCountry sets the "country" field.
func (alhu *AdminLoginHistoryUpdate) SetCountry(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetCountry(s)
	return alhu
}

// SetNillableCountry sets the "country" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableCountry(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetCountry(*s)
	}
	return alhu
}

// SetProvince sets the "province" field.
func (alhu *AdminLoginHistoryUpdate) SetProvince(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetProvince(s)
	return alhu
}

// SetNillableProvince sets the "province" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableProvince(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetProvince(*s)
	}
	return alhu
}

// SetCity sets the "city" field.
func (alhu *AdminLoginHistoryUpdate) SetCity(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetCity(s)
	return alhu
}

// SetNillableCity sets the "city" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableCity(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetCity(*s)
	}
	return alhu
}

// SetIsp sets the "isp" field.
func (alhu *AdminLoginHistoryUpdate) SetIsp(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetIsp(s)
	return alhu
}

// SetNillableIsp sets the "isp" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableIsp(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetIsp(*s)
	}
	return alhu
}

// ClearIsp clears the value of the "isp" field.
func (alhu *AdminLoginHistoryUpdate) ClearIsp() *AdminLoginHistoryUpdate {
	alhu.mutation.ClearIsp()
	return alhu
}

// SetAsn sets the "asn" field.
func (alhu *AdminLoginHistoryUpdate) SetAsn(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetAsn(s)
	return alhu
}

// SetNillableAsn sets the "asn" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableAsn(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetAsn(*s)
	}
	return alhu
}

// ClearAsn clears the value of the "asn" field.
func (alhu *AdminLoginHistoryUpdate) ClearAsn() *AdminLoginHistoryUpdate {
	alhu.mutation.ClearAsn()
	return alhu
}

// SetClientVersion sets the "client_version" field.
func (alhu *AdminLoginHistoryUpdate) SetClientVersion(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetClientVersion(s)
	return alhu
}

// SetNillableClientVersion sets the "client_version" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableClientVersion(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetClientVersion(*s)
	}
	return alhu
}

// ClearClientVersion clears the value of the "client_version" field.
func (alhu *AdminLoginHistoryUpdate) ClearClientVersion() *AdminLoginHistoryUpdate {
	alhu.mutation.ClearClientVersion()
	return alhu
}

// SetDevice sets the "device" field.
func (alhu *AdminLoginHistoryUpdate) SetDevice(s string) *AdminLoginHistoryUpdate {
	alhu.mutation.SetDevice(s)
	return alhu
}

// SetNillableDevice sets the "device" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableDevice(s *string) *AdminLoginHistoryUpdate {
	if s != nil {
		alhu.SetDevice(*s)
	}
	return alhu
}

// ClearDevice clears the value of the "device" field.
func (alhu *AdminLoginHistoryUpdate) ClearDevice() *AdminLoginHistoryUpdate {
	alhu.mutation.ClearDevice()
	return alhu
}

// SetCreatedAt sets the "created_at" field.
func (alhu *AdminLoginHistoryUpdate) SetCreatedAt(t time.Time) *AdminLoginHistoryUpdate {
	alhu.mutation.SetCreatedAt(t)
	return alhu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableCreatedAt(t *time.Time) *AdminLoginHistoryUpdate {
	if t != nil {
		alhu.SetCreatedAt(*t)
	}
	return alhu
}

// SetOwnerID sets the "owner" edge to the Admin entity by ID.
func (alhu *AdminLoginHistoryUpdate) SetOwnerID(id uuid.UUID) *AdminLoginHistoryUpdate {
	alhu.mutation.SetOwnerID(id)
	return alhu
}

// SetNillableOwnerID sets the "owner" edge to the Admin entity by ID if the given value is not nil.
func (alhu *AdminLoginHistoryUpdate) SetNillableOwnerID(id *uuid.UUID) *AdminLoginHistoryUpdate {
	if id != nil {
		alhu = alhu.SetOwnerID(*id)
	}
	return alhu
}

// SetOwner sets the "owner" edge to the Admin entity.
func (alhu *AdminLoginHistoryUpdate) SetOwner(a *Admin) *AdminLoginHistoryUpdate {
	return alhu.SetOwnerID(a.ID)
}

// Mutation returns the AdminLoginHistoryMutation object of the builder.
func (alhu *AdminLoginHistoryUpdate) Mutation() *AdminLoginHistoryMutation {
	return alhu.mutation
}

// ClearOwner clears the "owner" edge to the Admin entity.
func (alhu *AdminLoginHistoryUpdate) ClearOwner() *AdminLoginHistoryUpdate {
	alhu.mutation.ClearOwner()
	return alhu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (alhu *AdminLoginHistoryUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, alhu.sqlSave, alhu.mutation, alhu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (alhu *AdminLoginHistoryUpdate) SaveX(ctx context.Context) int {
	affected, err := alhu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (alhu *AdminLoginHistoryUpdate) Exec(ctx context.Context) error {
	_, err := alhu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (alhu *AdminLoginHistoryUpdate) ExecX(ctx context.Context) {
	if err := alhu.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (alhu *AdminLoginHistoryUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AdminLoginHistoryUpdate {
	alhu.modifiers = append(alhu.modifiers, modifiers...)
	return alhu
}

func (alhu *AdminLoginHistoryUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(adminloginhistory.Table, adminloginhistory.Columns, sqlgraph.NewFieldSpec(adminloginhistory.FieldID, field.TypeUUID))
	if ps := alhu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := alhu.mutation.IP(); ok {
		_spec.SetField(adminloginhistory.FieldIP, field.TypeString, value)
	}
	if value, ok := alhu.mutation.Country(); ok {
		_spec.SetField(adminloginhistory.FieldCountry, field.TypeString, value)
	}
	if value, ok := alhu.mutation.Province(); ok {
		_spec.SetField(adminloginhistory.FieldProvince, field.TypeString, value)
	}
	if value, ok := alhu.mutation.City(); ok {
		_spec.SetField(adminloginhistory.FieldCity, field.TypeString, value)
	}
	if value, ok := alhu.mutation.Isp(); ok {
		_spec.SetField(adminloginhistory.FieldIsp, field.TypeString, value)
	}
	if alhu.mutation.IspCleared() {
		_spec.ClearField(adminloginhistory.FieldIsp, field.TypeString)
	}
	if value, ok := alhu.mutation.Asn(); ok {
		_spec.SetField(adminloginhistory.FieldAsn, field.TypeString, value)
	}
	if alhu.mutation.AsnCleared() {
		_spec.ClearField(adminloginhistory.FieldAsn, field.TypeString)
	}
	if value, ok := alhu.mutation.ClientVersion(); ok {
		_spec.SetField(adminloginhistory.FieldClientVersion, field.TypeString, value)
	}
	if alhu.mutation.ClientVersionCleared() {
		_spec.ClearField(adminloginhistory.FieldClientVersion, field.TypeString)
	}
	if value, ok := alhu.mutation.Device(); ok {
		_spec.SetField(adminloginhistory.FieldDevice, field.TypeString, value)
	}
	if alhu.mutation.DeviceCleared() {
		_spec.ClearField(adminloginhistory.FieldDevice, field.TypeString)
	}
	if value, ok := alhu.mutation.CreatedAt(); ok {
		_spec.SetField(adminloginhistory.FieldCreatedAt, field.TypeTime, value)
	}
	if alhu.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   adminloginhistory.OwnerTable,
			Columns: []string{adminloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := alhu.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   adminloginhistory.OwnerTable,
			Columns: []string{adminloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(alhu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, alhu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{adminloginhistory.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	alhu.mutation.done = true
	return n, nil
}

// AdminLoginHistoryUpdateOne is the builder for updating a single AdminLoginHistory entity.
type AdminLoginHistoryUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *AdminLoginHistoryMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetAdminID sets the "admin_id" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetAdminID(u uuid.UUID) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetAdminID(u)
	return alhuo
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableAdminID(u *uuid.UUID) *AdminLoginHistoryUpdateOne {
	if u != nil {
		alhuo.SetAdminID(*u)
	}
	return alhuo
}

// ClearAdminID clears the value of the "admin_id" field.
func (alhuo *AdminLoginHistoryUpdateOne) ClearAdminID() *AdminLoginHistoryUpdateOne {
	alhuo.mutation.ClearAdminID()
	return alhuo
}

// SetIP sets the "ip" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetIP(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetIP(s)
	return alhuo
}

// SetNillableIP sets the "ip" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableIP(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetIP(*s)
	}
	return alhuo
}

// SetCountry sets the "country" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetCountry(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetCountry(s)
	return alhuo
}

// SetNillableCountry sets the "country" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableCountry(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetCountry(*s)
	}
	return alhuo
}

// SetProvince sets the "province" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetProvince(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetProvince(s)
	return alhuo
}

// SetNillableProvince sets the "province" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableProvince(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetProvince(*s)
	}
	return alhuo
}

// SetCity sets the "city" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetCity(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetCity(s)
	return alhuo
}

// SetNillableCity sets the "city" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableCity(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetCity(*s)
	}
	return alhuo
}

// SetIsp sets the "isp" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetIsp(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetIsp(s)
	return alhuo
}

// SetNillableIsp sets the "isp" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableIsp(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetIsp(*s)
	}
	return alhuo
}

// ClearIsp clears the value of the "isp" field.
func (alhuo *AdminLoginHistoryUpdateOne) ClearIsp() *AdminLoginHistoryUpdateOne {
	alhuo.mutation.ClearIsp()
	return alhuo
}

// SetAsn sets the "asn" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetAsn(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetAsn(s)
	return alhuo
}

// SetNillableAsn sets the "asn" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableAsn(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetAsn(*s)
	}
	return alhuo
}

// ClearAsn clears the value of the "asn" field.
func (alhuo *AdminLoginHistoryUpdateOne) ClearAsn() *AdminLoginHistoryUpdateOne {
	alhuo.mutation.ClearAsn()
	return alhuo
}

// SetClientVersion sets the "client_version" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetClientVersion(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetClientVersion(s)
	return alhuo
}

// SetNillableClientVersion sets the "client_version" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableClientVersion(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetClientVersion(*s)
	}
	return alhuo
}

// ClearClientVersion clears the value of the "client_version" field.
func (alhuo *AdminLoginHistoryUpdateOne) ClearClientVersion() *AdminLoginHistoryUpdateOne {
	alhuo.mutation.ClearClientVersion()
	return alhuo
}

// SetDevice sets the "device" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetDevice(s string) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetDevice(s)
	return alhuo
}

// SetNillableDevice sets the "device" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableDevice(s *string) *AdminLoginHistoryUpdateOne {
	if s != nil {
		alhuo.SetDevice(*s)
	}
	return alhuo
}

// ClearDevice clears the value of the "device" field.
func (alhuo *AdminLoginHistoryUpdateOne) ClearDevice() *AdminLoginHistoryUpdateOne {
	alhuo.mutation.ClearDevice()
	return alhuo
}

// SetCreatedAt sets the "created_at" field.
func (alhuo *AdminLoginHistoryUpdateOne) SetCreatedAt(t time.Time) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetCreatedAt(t)
	return alhuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableCreatedAt(t *time.Time) *AdminLoginHistoryUpdateOne {
	if t != nil {
		alhuo.SetCreatedAt(*t)
	}
	return alhuo
}

// SetOwnerID sets the "owner" edge to the Admin entity by ID.
func (alhuo *AdminLoginHistoryUpdateOne) SetOwnerID(id uuid.UUID) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.SetOwnerID(id)
	return alhuo
}

// SetNillableOwnerID sets the "owner" edge to the Admin entity by ID if the given value is not nil.
func (alhuo *AdminLoginHistoryUpdateOne) SetNillableOwnerID(id *uuid.UUID) *AdminLoginHistoryUpdateOne {
	if id != nil {
		alhuo = alhuo.SetOwnerID(*id)
	}
	return alhuo
}

// SetOwner sets the "owner" edge to the Admin entity.
func (alhuo *AdminLoginHistoryUpdateOne) SetOwner(a *Admin) *AdminLoginHistoryUpdateOne {
	return alhuo.SetOwnerID(a.ID)
}

// Mutation returns the AdminLoginHistoryMutation object of the builder.
func (alhuo *AdminLoginHistoryUpdateOne) Mutation() *AdminLoginHistoryMutation {
	return alhuo.mutation
}

// ClearOwner clears the "owner" edge to the Admin entity.
func (alhuo *AdminLoginHistoryUpdateOne) ClearOwner() *AdminLoginHistoryUpdateOne {
	alhuo.mutation.ClearOwner()
	return alhuo
}

// Where appends a list predicates to the AdminLoginHistoryUpdate builder.
func (alhuo *AdminLoginHistoryUpdateOne) Where(ps ...predicate.AdminLoginHistory) *AdminLoginHistoryUpdateOne {
	alhuo.mutation.Where(ps...)
	return alhuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (alhuo *AdminLoginHistoryUpdateOne) Select(field string, fields ...string) *AdminLoginHistoryUpdateOne {
	alhuo.fields = append([]string{field}, fields...)
	return alhuo
}

// Save executes the query and returns the updated AdminLoginHistory entity.
func (alhuo *AdminLoginHistoryUpdateOne) Save(ctx context.Context) (*AdminLoginHistory, error) {
	return withHooks(ctx, alhuo.sqlSave, alhuo.mutation, alhuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (alhuo *AdminLoginHistoryUpdateOne) SaveX(ctx context.Context) *AdminLoginHistory {
	node, err := alhuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (alhuo *AdminLoginHistoryUpdateOne) Exec(ctx context.Context) error {
	_, err := alhuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (alhuo *AdminLoginHistoryUpdateOne) ExecX(ctx context.Context) {
	if err := alhuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (alhuo *AdminLoginHistoryUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AdminLoginHistoryUpdateOne {
	alhuo.modifiers = append(alhuo.modifiers, modifiers...)
	return alhuo
}

func (alhuo *AdminLoginHistoryUpdateOne) sqlSave(ctx context.Context) (_node *AdminLoginHistory, err error) {
	_spec := sqlgraph.NewUpdateSpec(adminloginhistory.Table, adminloginhistory.Columns, sqlgraph.NewFieldSpec(adminloginhistory.FieldID, field.TypeUUID))
	id, ok := alhuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "AdminLoginHistory.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := alhuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, adminloginhistory.FieldID)
		for _, f := range fields {
			if !adminloginhistory.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != adminloginhistory.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := alhuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := alhuo.mutation.IP(); ok {
		_spec.SetField(adminloginhistory.FieldIP, field.TypeString, value)
	}
	if value, ok := alhuo.mutation.Country(); ok {
		_spec.SetField(adminloginhistory.FieldCountry, field.TypeString, value)
	}
	if value, ok := alhuo.mutation.Province(); ok {
		_spec.SetField(adminloginhistory.FieldProvince, field.TypeString, value)
	}
	if value, ok := alhuo.mutation.City(); ok {
		_spec.SetField(adminloginhistory.FieldCity, field.TypeString, value)
	}
	if value, ok := alhuo.mutation.Isp(); ok {
		_spec.SetField(adminloginhistory.FieldIsp, field.TypeString, value)
	}
	if alhuo.mutation.IspCleared() {
		_spec.ClearField(adminloginhistory.FieldIsp, field.TypeString)
	}
	if value, ok := alhuo.mutation.Asn(); ok {
		_spec.SetField(adminloginhistory.FieldAsn, field.TypeString, value)
	}
	if alhuo.mutation.AsnCleared() {
		_spec.ClearField(adminloginhistory.FieldAsn, field.TypeString)
	}
	if value, ok := alhuo.mutation.ClientVersion(); ok {
		_spec.SetField(adminloginhistory.FieldClientVersion, field.TypeString, value)
	}
	if alhuo.mutation.ClientVersionCleared() {
		_spec.ClearField(adminloginhistory.FieldClientVersion, field.TypeString)
	}
	if value, ok := alhuo.mutation.Device(); ok {
		_spec.SetField(adminloginhistory.FieldDevice, field.TypeString, value)
	}
	if alhuo.mutation.DeviceCleared() {
		_spec.ClearField(adminloginhistory.FieldDevice, field.TypeString)
	}
	if value, ok := alhuo.mutation.CreatedAt(); ok {
		_spec.SetField(adminloginhistory.FieldCreatedAt, field.TypeTime, value)
	}
	if alhuo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   adminloginhistory.OwnerTable,
			Columns: []string{adminloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := alhuo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   adminloginhistory.OwnerTable,
			Columns: []string{adminloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(alhuo.modifiers...)
	_node = &AdminLoginHistory{config: alhuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, alhuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{adminloginhistory.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	alhuo.mutation.done = true
	return _node, nil
}
