// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// AdminLoginHistoryQuery is the builder for querying AdminLoginHistory entities.
type AdminLoginHistoryQuery struct {
	config
	ctx        *QueryContext
	order      []adminloginhistory.OrderOption
	inters     []Interceptor
	predicates []predicate.AdminLoginHistory
	withOwner  *AdminQuery
	modifiers  []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the AdminLoginHistoryQuery builder.
func (alhq *AdminLoginHistoryQuery) Where(ps ...predicate.AdminLoginHistory) *AdminLoginHistoryQuery {
	alhq.predicates = append(alhq.predicates, ps...)
	return alhq
}

// Limit the number of records to be returned by this query.
func (alhq *AdminLoginHistoryQuery) Limit(limit int) *AdminLoginHistoryQuery {
	alhq.ctx.Limit = &limit
	return alhq
}

// Offset to start from.
func (alhq *AdminLoginHistoryQuery) Offset(offset int) *AdminLoginHistoryQuery {
	alhq.ctx.Offset = &offset
	return alhq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (alhq *AdminLoginHistoryQuery) Unique(unique bool) *AdminLoginHistoryQuery {
	alhq.ctx.Unique = &unique
	return alhq
}

// Order specifies how the records should be ordered.
func (alhq *AdminLoginHistoryQuery) Order(o ...adminloginhistory.OrderOption) *AdminLoginHistoryQuery {
	alhq.order = append(alhq.order, o...)
	return alhq
}

// QueryOwner chains the current query on the "owner" edge.
func (alhq *AdminLoginHistoryQuery) QueryOwner() *AdminQuery {
	query := (&AdminClient{config: alhq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := alhq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := alhq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(adminloginhistory.Table, adminloginhistory.FieldID, selector),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, adminloginhistory.OwnerTable, adminloginhistory.OwnerColumn),
		)
		fromU = sqlgraph.SetNeighbors(alhq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first AdminLoginHistory entity from the query.
// Returns a *NotFoundError when no AdminLoginHistory was found.
func (alhq *AdminLoginHistoryQuery) First(ctx context.Context) (*AdminLoginHistory, error) {
	nodes, err := alhq.Limit(1).All(setContextOp(ctx, alhq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{adminloginhistory.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) FirstX(ctx context.Context) *AdminLoginHistory {
	node, err := alhq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first AdminLoginHistory ID from the query.
// Returns a *NotFoundError when no AdminLoginHistory ID was found.
func (alhq *AdminLoginHistoryQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = alhq.Limit(1).IDs(setContextOp(ctx, alhq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{adminloginhistory.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := alhq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single AdminLoginHistory entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one AdminLoginHistory entity is found.
// Returns a *NotFoundError when no AdminLoginHistory entities are found.
func (alhq *AdminLoginHistoryQuery) Only(ctx context.Context) (*AdminLoginHistory, error) {
	nodes, err := alhq.Limit(2).All(setContextOp(ctx, alhq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{adminloginhistory.Label}
	default:
		return nil, &NotSingularError{adminloginhistory.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) OnlyX(ctx context.Context) *AdminLoginHistory {
	node, err := alhq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only AdminLoginHistory ID in the query.
// Returns a *NotSingularError when more than one AdminLoginHistory ID is found.
// Returns a *NotFoundError when no entities are found.
func (alhq *AdminLoginHistoryQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = alhq.Limit(2).IDs(setContextOp(ctx, alhq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{adminloginhistory.Label}
	default:
		err = &NotSingularError{adminloginhistory.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := alhq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of AdminLoginHistories.
func (alhq *AdminLoginHistoryQuery) All(ctx context.Context) ([]*AdminLoginHistory, error) {
	ctx = setContextOp(ctx, alhq.ctx, ent.OpQueryAll)
	if err := alhq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*AdminLoginHistory, *AdminLoginHistoryQuery]()
	return withInterceptors[[]*AdminLoginHistory](ctx, alhq, qr, alhq.inters)
}

// AllX is like All, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) AllX(ctx context.Context) []*AdminLoginHistory {
	nodes, err := alhq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of AdminLoginHistory IDs.
func (alhq *AdminLoginHistoryQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if alhq.ctx.Unique == nil && alhq.path != nil {
		alhq.Unique(true)
	}
	ctx = setContextOp(ctx, alhq.ctx, ent.OpQueryIDs)
	if err = alhq.Select(adminloginhistory.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := alhq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (alhq *AdminLoginHistoryQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, alhq.ctx, ent.OpQueryCount)
	if err := alhq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, alhq, querierCount[*AdminLoginHistoryQuery](), alhq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) CountX(ctx context.Context) int {
	count, err := alhq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (alhq *AdminLoginHistoryQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, alhq.ctx, ent.OpQueryExist)
	switch _, err := alhq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (alhq *AdminLoginHistoryQuery) ExistX(ctx context.Context) bool {
	exist, err := alhq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the AdminLoginHistoryQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (alhq *AdminLoginHistoryQuery) Clone() *AdminLoginHistoryQuery {
	if alhq == nil {
		return nil
	}
	return &AdminLoginHistoryQuery{
		config:     alhq.config,
		ctx:        alhq.ctx.Clone(),
		order:      append([]adminloginhistory.OrderOption{}, alhq.order...),
		inters:     append([]Interceptor{}, alhq.inters...),
		predicates: append([]predicate.AdminLoginHistory{}, alhq.predicates...),
		withOwner:  alhq.withOwner.Clone(),
		// clone intermediate query.
		sql:       alhq.sql.Clone(),
		path:      alhq.path,
		modifiers: append([]func(*sql.Selector){}, alhq.modifiers...),
	}
}

// WithOwner tells the query-builder to eager-load the nodes that are connected to
// the "owner" edge. The optional arguments are used to configure the query builder of the edge.
func (alhq *AdminLoginHistoryQuery) WithOwner(opts ...func(*AdminQuery)) *AdminLoginHistoryQuery {
	query := (&AdminClient{config: alhq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	alhq.withOwner = query
	return alhq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		AdminID uuid.UUID `json:"admin_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.AdminLoginHistory.Query().
//		GroupBy(adminloginhistory.FieldAdminID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (alhq *AdminLoginHistoryQuery) GroupBy(field string, fields ...string) *AdminLoginHistoryGroupBy {
	alhq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &AdminLoginHistoryGroupBy{build: alhq}
	grbuild.flds = &alhq.ctx.Fields
	grbuild.label = adminloginhistory.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		AdminID uuid.UUID `json:"admin_id,omitempty"`
//	}
//
//	client.AdminLoginHistory.Query().
//		Select(adminloginhistory.FieldAdminID).
//		Scan(ctx, &v)
func (alhq *AdminLoginHistoryQuery) Select(fields ...string) *AdminLoginHistorySelect {
	alhq.ctx.Fields = append(alhq.ctx.Fields, fields...)
	sbuild := &AdminLoginHistorySelect{AdminLoginHistoryQuery: alhq}
	sbuild.label = adminloginhistory.Label
	sbuild.flds, sbuild.scan = &alhq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a AdminLoginHistorySelect configured with the given aggregations.
func (alhq *AdminLoginHistoryQuery) Aggregate(fns ...AggregateFunc) *AdminLoginHistorySelect {
	return alhq.Select().Aggregate(fns...)
}

func (alhq *AdminLoginHistoryQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range alhq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, alhq); err != nil {
				return err
			}
		}
	}
	for _, f := range alhq.ctx.Fields {
		if !adminloginhistory.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if alhq.path != nil {
		prev, err := alhq.path(ctx)
		if err != nil {
			return err
		}
		alhq.sql = prev
	}
	return nil
}

func (alhq *AdminLoginHistoryQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*AdminLoginHistory, error) {
	var (
		nodes       = []*AdminLoginHistory{}
		_spec       = alhq.querySpec()
		loadedTypes = [1]bool{
			alhq.withOwner != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*AdminLoginHistory).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &AdminLoginHistory{config: alhq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(alhq.modifiers) > 0 {
		_spec.Modifiers = alhq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, alhq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := alhq.withOwner; query != nil {
		if err := alhq.loadOwner(ctx, query, nodes, nil,
			func(n *AdminLoginHistory, e *Admin) { n.Edges.Owner = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (alhq *AdminLoginHistoryQuery) loadOwner(ctx context.Context, query *AdminQuery, nodes []*AdminLoginHistory, init func(*AdminLoginHistory), assign func(*AdminLoginHistory, *Admin)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*AdminLoginHistory)
	for i := range nodes {
		fk := nodes[i].AdminID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(admin.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "admin_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (alhq *AdminLoginHistoryQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := alhq.querySpec()
	if len(alhq.modifiers) > 0 {
		_spec.Modifiers = alhq.modifiers
	}
	_spec.Node.Columns = alhq.ctx.Fields
	if len(alhq.ctx.Fields) > 0 {
		_spec.Unique = alhq.ctx.Unique != nil && *alhq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, alhq.driver, _spec)
}

func (alhq *AdminLoginHistoryQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(adminloginhistory.Table, adminloginhistory.Columns, sqlgraph.NewFieldSpec(adminloginhistory.FieldID, field.TypeUUID))
	_spec.From = alhq.sql
	if unique := alhq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if alhq.path != nil {
		_spec.Unique = true
	}
	if fields := alhq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, adminloginhistory.FieldID)
		for i := range fields {
			if fields[i] != adminloginhistory.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if alhq.withOwner != nil {
			_spec.Node.AddColumnOnce(adminloginhistory.FieldAdminID)
		}
	}
	if ps := alhq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := alhq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := alhq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := alhq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (alhq *AdminLoginHistoryQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(alhq.driver.Dialect())
	t1 := builder.Table(adminloginhistory.Table)
	columns := alhq.ctx.Fields
	if len(columns) == 0 {
		columns = adminloginhistory.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if alhq.sql != nil {
		selector = alhq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if alhq.ctx.Unique != nil && *alhq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range alhq.modifiers {
		m(selector)
	}
	for _, p := range alhq.predicates {
		p(selector)
	}
	for _, p := range alhq.order {
		p(selector)
	}
	if offset := alhq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := alhq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (alhq *AdminLoginHistoryQuery) ForUpdate(opts ...sql.LockOption) *AdminLoginHistoryQuery {
	if alhq.driver.Dialect() == dialect.Postgres {
		alhq.Unique(false)
	}
	alhq.modifiers = append(alhq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return alhq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (alhq *AdminLoginHistoryQuery) ForShare(opts ...sql.LockOption) *AdminLoginHistoryQuery {
	if alhq.driver.Dialect() == dialect.Postgres {
		alhq.Unique(false)
	}
	alhq.modifiers = append(alhq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return alhq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (alhq *AdminLoginHistoryQuery) Modify(modifiers ...func(s *sql.Selector)) *AdminLoginHistorySelect {
	alhq.modifiers = append(alhq.modifiers, modifiers...)
	return alhq.Select()
}

// AdminLoginHistoryGroupBy is the group-by builder for AdminLoginHistory entities.
type AdminLoginHistoryGroupBy struct {
	selector
	build *AdminLoginHistoryQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (alhgb *AdminLoginHistoryGroupBy) Aggregate(fns ...AggregateFunc) *AdminLoginHistoryGroupBy {
	alhgb.fns = append(alhgb.fns, fns...)
	return alhgb
}

// Scan applies the selector query and scans the result into the given value.
func (alhgb *AdminLoginHistoryGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, alhgb.build.ctx, ent.OpQueryGroupBy)
	if err := alhgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AdminLoginHistoryQuery, *AdminLoginHistoryGroupBy](ctx, alhgb.build, alhgb, alhgb.build.inters, v)
}

func (alhgb *AdminLoginHistoryGroupBy) sqlScan(ctx context.Context, root *AdminLoginHistoryQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(alhgb.fns))
	for _, fn := range alhgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*alhgb.flds)+len(alhgb.fns))
		for _, f := range *alhgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*alhgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := alhgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// AdminLoginHistorySelect is the builder for selecting fields of AdminLoginHistory entities.
type AdminLoginHistorySelect struct {
	*AdminLoginHistoryQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (alhs *AdminLoginHistorySelect) Aggregate(fns ...AggregateFunc) *AdminLoginHistorySelect {
	alhs.fns = append(alhs.fns, fns...)
	return alhs
}

// Scan applies the selector query and scans the result into the given value.
func (alhs *AdminLoginHistorySelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, alhs.ctx, ent.OpQuerySelect)
	if err := alhs.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AdminLoginHistoryQuery, *AdminLoginHistorySelect](ctx, alhs.AdminLoginHistoryQuery, alhs, alhs.inters, v)
}

func (alhs *AdminLoginHistorySelect) sqlScan(ctx context.Context, root *AdminLoginHistoryQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(alhs.fns))
	for _, fn := range alhs.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*alhs.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := alhs.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (alhs *AdminLoginHistorySelect) Modify(modifiers ...func(s *sql.Selector)) *AdminLoginHistorySelect {
	alhs.modifiers = append(alhs.modifiers, modifiers...)
	return alhs
}
