// Code generated by ent, DO NOT EDIT.

package adminloginhistory

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the adminloginhistory type in the database.
	Label = "admin_login_history"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldAdminID holds the string denoting the admin_id field in the database.
	FieldAdminID = "admin_id"
	// FieldIP holds the string denoting the ip field in the database.
	FieldIP = "ip"
	// FieldCountry holds the string denoting the country field in the database.
	FieldCountry = "country"
	// FieldProvince holds the string denoting the province field in the database.
	FieldProvince = "province"
	// FieldCity holds the string denoting the city field in the database.
	FieldCity = "city"
	// FieldIsp holds the string denoting the isp field in the database.
	FieldIsp = "isp"
	// FieldAsn holds the string denoting the asn field in the database.
	FieldAsn = "asn"
	// FieldClientVersion holds the string denoting the client_version field in the database.
	FieldClientVersion = "client_version"
	// FieldDevice holds the string denoting the device field in the database.
	FieldDevice = "device"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// EdgeOwner holds the string denoting the owner edge name in mutations.
	EdgeOwner = "owner"
	// Table holds the table name of the adminloginhistory in the database.
	Table = "admin_login_histories"
	// OwnerTable is the table that holds the owner relation/edge.
	OwnerTable = "admin_login_histories"
	// OwnerInverseTable is the table name for the Admin entity.
	// It exists in this package in order to avoid circular dependency with the "admin" package.
	OwnerInverseTable = "admins"
	// OwnerColumn is the table column denoting the owner relation/edge.
	OwnerColumn = "admin_id"
)

// Columns holds all SQL columns for adminloginhistory fields.
var Columns = []string{
	FieldID,
	FieldAdminID,
	FieldIP,
	FieldCountry,
	FieldProvince,
	FieldCity,
	FieldIsp,
	FieldAsn,
	FieldClientVersion,
	FieldDevice,
	FieldCreatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
)

// OrderOption defines the ordering options for the AdminLoginHistory queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByAdminID orders the results by the admin_id field.
func ByAdminID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAdminID, opts...).ToFunc()
}

// ByIP orders the results by the ip field.
func ByIP(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIP, opts...).ToFunc()
}

// ByCountry orders the results by the country field.
func ByCountry(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCountry, opts...).ToFunc()
}

// ByProvince orders the results by the province field.
func ByProvince(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldProvince, opts...).ToFunc()
}

// ByCity orders the results by the city field.
func ByCity(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCity, opts...).ToFunc()
}

// ByIsp orders the results by the isp field.
func ByIsp(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIsp, opts...).ToFunc()
}

// ByAsn orders the results by the asn field.
func ByAsn(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAsn, opts...).ToFunc()
}

// ByClientVersion orders the results by the client_version field.
func ByClientVersion(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldClientVersion, opts...).ToFunc()
}

// ByDevice orders the results by the device field.
func ByDevice(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDevice, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByOwnerField orders the results by owner field.
func ByOwnerField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newOwnerStep(), sql.OrderByField(field, opts...))
	}
}
func newOwnerStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(OwnerInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
	)
}
