// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package main

import (
	"github.com/GoYoko/web"
	"github.com/chaitin/MonkeyCode/backend/config"
	"github.com/chaitin/MonkeyCode/backend/db"
	"github.com/chaitin/MonkeyCode/backend/domain"
	v1_5 "github.com/chaitin/MonkeyCode/backend/internal/billing/handler/http/v1"
	repo8 "github.com/chaitin/MonkeyCode/backend/internal/billing/repo"
	usecase7 "github.com/chaitin/MonkeyCode/backend/internal/billing/usecase"
	v1_7 "github.com/chaitin/MonkeyCode/backend/internal/codesnippet/handler/http/v1"
	repo10 "github.com/chaitin/MonkeyCode/backend/internal/codesnippet/repo"
	"github.com/chaitin/MonkeyCode/backend/internal/codesnippet/service"
	usecase9 "github.com/chaitin/MonkeyCode/backend/internal/codesnippet/usecase"
	v1_4 "github.com/chaitin/MonkeyCode/backend/internal/dashboard/handler/v1"
	repo7 "github.com/chaitin/MonkeyCode/backend/internal/dashboard/repo"
	usecase6 "github.com/chaitin/MonkeyCode/backend/internal/dashboard/usecase"
	repo5 "github.com/chaitin/MonkeyCode/backend/internal/extension/repo"
	usecase2 "github.com/chaitin/MonkeyCode/backend/internal/extension/usecase"
	"github.com/chaitin/MonkeyCode/backend/internal/middleware"
	v1_2 "github.com/chaitin/MonkeyCode/backend/internal/model/handler/http/v1"
	repo2 "github.com/chaitin/MonkeyCode/backend/internal/model/repo"
	usecase4 "github.com/chaitin/MonkeyCode/backend/internal/model/usecase"
	"github.com/chaitin/MonkeyCode/backend/internal/openai/handler/v1"
	repo4 "github.com/chaitin/MonkeyCode/backend/internal/openai/repo"
	"github.com/chaitin/MonkeyCode/backend/internal/openai/usecase"
	"github.com/chaitin/MonkeyCode/backend/internal/proxy"
	"github.com/chaitin/MonkeyCode/backend/internal/proxy/repo"
	"github.com/chaitin/MonkeyCode/backend/internal/proxy/usecase"
	repo11 "github.com/chaitin/MonkeyCode/backend/internal/report/repo"
	usecase10 "github.com/chaitin/MonkeyCode/backend/internal/report/usecase"
	v1_6 "github.com/chaitin/MonkeyCode/backend/internal/security/handler/http/v1"
	repo3 "github.com/chaitin/MonkeyCode/backend/internal/security/repo"
	usecase5 "github.com/chaitin/MonkeyCode/backend/internal/security/usecase"
	"github.com/chaitin/MonkeyCode/backend/internal/socket/handler"
	v1_3 "github.com/chaitin/MonkeyCode/backend/internal/user/handler/v1"
	repo6 "github.com/chaitin/MonkeyCode/backend/internal/user/repo"
	usecase3 "github.com/chaitin/MonkeyCode/backend/internal/user/usecase"
	repo9 "github.com/chaitin/MonkeyCode/backend/internal/workspace/repo"
	usecase8 "github.com/chaitin/MonkeyCode/backend/internal/workspace/usecase"
	"github.com/chaitin/MonkeyCode/backend/pkg"
	"github.com/chaitin/MonkeyCode/backend/pkg/ipdb"
	"github.com/chaitin/MonkeyCode/backend/pkg/logger"
	"github.com/chaitin/MonkeyCode/backend/pkg/report"
	"github.com/chaitin/MonkeyCode/backend/pkg/session"
	"github.com/chaitin/MonkeyCode/backend/pkg/store"
	"github.com/chaitin/MonkeyCode/backend/pkg/version"
	"log/slog"
)

// Injectors from wire.go:

func newServer() (*Server, error) {
	configConfig, err := config.Init()
	if err != nil {
		return nil, err
	}
	web := pkg.NewWeb(configConfig)
	loggerConfig := configConfig.Logger
	slogLogger := logger.NewLogger(loggerConfig)
	client, err := store.NewEntDB(configConfig, slogLogger)
	if err != nil {
		return nil, err
	}
	redisClient := store.NewRedisCli(configConfig)
	proxyRepo := repo.NewProxyRepo(client, redisClient)
	modelRepo := repo2.NewModelRepo(client)
	securityScanningRepo := repo3.NewSecurityScanningRepo(client)
	proxyUsecase := usecase.NewProxyUsecase(proxyRepo, modelRepo, securityScanningRepo, slogLogger, configConfig, redisClient)
	llmProxy := proxy.NewLLMProxy(slogLogger, configConfig, proxyUsecase)
	openAIRepo := repo4.NewOpenAIRepo(client)
	openAIUsecase := openai.NewOpenAIUsecase(configConfig, openAIRepo, modelRepo, slogLogger, redisClient)
	extensionRepo := repo5.NewExtensionRepo(client)
	extensionUsecase := usecase2.NewExtensionUsecase(extensionRepo, configConfig, slogLogger)
	ipdbIPDB, err := ipdb.NewIPDB(slogLogger)
	if err != nil {
		return nil, err
	}
	userRepo := repo6.NewUserRepo(client, ipdbIPDB, redisClient, configConfig)
	sessionSession := session.NewSession(configConfig)
	userUsecase := usecase3.NewUserUsecase(configConfig, redisClient, userRepo, slogLogger, sessionSession)
	proxyMiddleware := middleware.NewProxyMiddleware(proxyUsecase, redisClient, slogLogger)
	activeMiddleware := middleware.NewActiveMiddleware(redisClient, slogLogger)
	v1Handler := v1.NewV1Handler(slogLogger, web, llmProxy, proxyUsecase, openAIUsecase, extensionUsecase, userUsecase, proxyMiddleware, activeMiddleware, configConfig)
	modelUsecase := usecase4.NewModelUsecase(slogLogger, modelRepo, configConfig)
	authMiddleware := middleware.NewAuthMiddleware(userUsecase, sessionSession, slogLogger)
	readOnlyMiddleware := middleware.NewReadOnlyMiddleware(configConfig)
	modelHandler := v1_2.NewModelHandler(web, modelUsecase, authMiddleware, activeMiddleware, readOnlyMiddleware, slogLogger)
	securityScanningUsecase := usecase5.NewSecurityScanningUsecase(securityScanningRepo)
	dashboardRepo := repo7.NewDashboardRepo(client)
	dashboardUsecase := usecase6.NewDashboardUsecase(dashboardRepo)
	billingRepo := repo8.NewBillingRepo(client)
	billingUsecase := usecase7.NewBillingUsecase(billingRepo)
	userHandler := v1_3.NewUserHandler(web, userUsecase, extensionUsecase, securityScanningUsecase, dashboardUsecase, billingUsecase, authMiddleware, activeMiddleware, readOnlyMiddleware, sessionSession, slogLogger, configConfig)
	dashboardHandler := v1_4.NewDashboardHandler(web, dashboardUsecase, authMiddleware, activeMiddleware)
	billingHandler := v1_5.NewBillingHandler(web, billingUsecase, authMiddleware, activeMiddleware)
	workspaceFileRepo := repo9.NewWorkspaceFileRepo(client)
	workspaceRepo := repo9.NewWorkspaceRepo(client)
	workspaceUsecase := usecase8.NewWorkspaceUsecase(workspaceRepo, configConfig, slogLogger)
	codeSnippetRepo := repo10.NewCodeSnippetRepo(client, slogLogger)
	embeddingService := service.NewOpenAIEmbeddingService(configConfig)
	codeSnippetUsecase := usecase9.NewCodeSnippetUsecase(codeSnippetRepo, embeddingService, slogLogger)
	workspaceFileUsecase := usecase8.NewWorkspaceFileUsecase(workspaceFileRepo, workspaceUsecase, codeSnippetUsecase, configConfig, slogLogger)
	socketHandler, err := handler.NewSocketHandler(configConfig, slogLogger, workspaceFileUsecase, workspaceUsecase, userUsecase)
	if err != nil {
		return nil, err
	}
	versionInfo := version.NewVersionInfo()
	reporter := report.NewReport(slogLogger, configConfig, versionInfo)
	reportRepo := repo11.NewReportRepo(client)
	reportUsecase := usecase10.NewReportUsecase(reportRepo, slogLogger, reporter, redisClient)
	securityHandler := v1_6.NewSecurityHandler(web, securityScanningUsecase, authMiddleware, activeMiddleware)
	codeSnippetHandler := v1_7.NewCodeSnippetHandler(web, codeSnippetUsecase, embeddingService, authMiddleware, activeMiddleware, readOnlyMiddleware, proxyMiddleware, slogLogger)
	server := &Server{
		config:        configConfig,
		web:           web,
		ent:           client,
		logger:        slogLogger,
		openaiV1:      v1Handler,
		modelV1:       modelHandler,
		userV1:        userHandler,
		dashboardV1:   dashboardHandler,
		billingV1:     billingHandler,
		socketH:       socketHandler,
		version:       versionInfo,
		report:        reporter,
		reportuse:     reportUsecase,
		euse:          extensionUsecase,
		securityV1:    securityHandler,
		codeSnippetV1: codeSnippetHandler,
	}
	return server, nil
}

// wire.go:

type Server struct {
	config        *config.Config
	web           *web.Web
	ent           *db.Client
	logger        *slog.Logger
	openaiV1      *v1.V1Handler
	modelV1       *v1_2.ModelHandler
	userV1        *v1_3.UserHandler
	dashboardV1   *v1_4.DashboardHandler
	billingV1     *v1_5.BillingHandler
	socketH       *handler.SocketHandler
	version       *version.VersionInfo
	report        *report.Reporter
	reportuse     domain.ReportUsecase
	euse          domain.ExtensionUsecase
	securityV1    *v1_6.SecurityHandler
	codeSnippetV1 *v1_7.CodeSnippetHandler
}
