/* SPDX-License-Identifier: GPL-2.0 */

/* Copyright (c) 2018 Rockchip Electronics Co. Ltd. */

#ifndef __RK_CRYPTO_V2_REG_H__
#define __RK_CRYPTO_V2_REG_H__

#define _SBF(s, v)			((v) << (s))

#define CRYPTO_WRITE_MASK_SHIFT		(16)
#define CRYPTO_WRITE_MASK_ALL		((0xffffu << CRYPTO_WRITE_MASK_SHIFT))

#define WRITE_MASK			(16)

/* Crypto control registers*/
#define CRYPTO_CLK_CTL			0x0000
#define CRYPTO_AUTO_CLKGATE_EN		BIT(0)

#define CRYPTO_RST_CTL			0x0004
#define CRYPTO_SW_PKA_RESET		BIT(2)
#define CRYPTO_SW_RNG_RESET		BIT(1)
#define CRYPTO_SW_CC_RESET		BIT(0)

/* Crypto DMA control registers*/
#define CRYPTO_DMA_INT_EN		0x0008
#define CRYPTO_ZERO_ERR_INT_EN		BIT(6)
#define CRYPTO_LIST_ERR_INT_EN		BIT(5)
#define CRYPTO_SRC_ERR_INT_EN		BIT(4)
#define CRYPTO_DST_ERR_INT_EN		BIT(3)
#define CRYPTO_SRC_ITEM_INT_EN		BIT(2)
#define CRYPTO_DST_ITEM_DONE_INT_EN	BIT(1)
#define CRYPTO_LIST_DONE_INT_EN		BIT(0)

#define CRYPTO_DMA_INT_ST		0x000C
#define CRYPTO_LOCKSTEP_INT_ST		BIT(7)
#define CRYPTO_ZERO_LEN_INT_ST		BIT(6)
#define CRYPTO_LIST_ERR_INT_ST		BIT(5)
#define CRYPTO_SRC_ERR_INT_ST		BIT(4)
#define CRYPTO_DST_ERR_INT_ST		BIT(3)
#define CRYPTO_SRC_ITEM_DONE_INT_ST	BIT(2)
#define CRYPTO_DST_ITEM_DONE_INT_ST	BIT(1)
#define CRYPTO_LIST_DONE_INT_ST		BIT(0)

#define CRYPTO_LOCKSTEP_MASK		(~((u32)CRYPTO_LOCKSTEP_INT_ST))
#define CRYPTO_DMA_CTL			0x0010
#define CRYPTO_DMA_RESTART		BIT(1)
#define CRYPTO_DMA_START		BIT(0)

/* DMA LIST Start Address Register */
#define CRYPTO_DMA_LLI_ADDR		0x0014

#define CRYPTO_DMA_ST			0x0018
#define CRYPTO_DMA_BUSY			BIT(0)

#define CRYPTO_DMA_STATE		0x001C
#define CRYPTO_LLI_IDLE_STATE		_SBF(4, 0x00)
#define CRYPTO_LLI_FETCH_STATE		_SBF(4, 0x01)
#define CRYPTO_LLI_WORK_STATE		_SBF(4, 0x02)
#define CRYPTO_SRC_IDLE_STATE		_SBF(2, 0x00)
#define CRYPTO_SRC_LOAD_STATE		_SBF(2, 0x01)
#define CRYPTO_SRC_WORK_STATE		_SBF(2, 0x02)
#define CRYPTO_DST_IDLE_STATE		_SBF(0, 0x00)
#define CRYPTO_DST_LOAD_STATE		_SBF(0, 0x01)
#define CRYPTO_DST_WORK_STATE		_SBF(0, 0x02)

/* DMA LLI Read Address Register */
#define CRYPTO_DMA_LLI_RADDR		0x0020

/* DMA Source Data Read Address Register */
#define CRYPTO_DMA_SRC_RADDR		0x0024

/* DMA Destination Data Read Address Register */
#define CRYPTO_DMA_DST_RADDR		0x0028

#define CRYPTO_DMA_ITEM_ID		0x002C

#define CRYPTO_FIFO_CTL			0x0040
#define CRYPTO_DOUT_BYTESWAP		BIT(1)
#define CRYPTO_DOIN_BYTESWAP		BIT(0)

/* Block Cipher Control Register */
#define CRYPTO_BC_CTL			0x0044
#define CRYPTO_BC_AES			_SBF(8, 0x00)
#define CRYPTO_BC_SM4			_SBF(8, 0x01)
#define CRYPTO_BC_DES			_SBF(8, 0x02)
#define CRYPTO_BC_TDES			_SBF(8, 0x03)
#define CRYPTO_BC_ECB			_SBF(4, 0x00)
#define CRYPTO_BC_CBC			_SBF(4, 0x01)
#define CRYPTO_BC_CTS			_SBF(4, 0x02)
#define CRYPTO_BC_CTR			_SBF(4, 0x03)
#define CRYPTO_BC_CFB			_SBF(4, 0x04)
#define CRYPTO_BC_OFB			_SBF(4, 0x05)
#define CRYPTO_BC_XTS			_SBF(4, 0x06)
#define CRYPTO_BC_CCM			_SBF(4, 0x07)
#define CRYPTO_BC_GCM			_SBF(4, 0x08)
#define CRYPTO_BC_CMAC			_SBF(4, 0x09)
#define CRYPTO_BC_CBC_MAC		_SBF(4, 0x0A)
#define CRYPTO_BC_128_bit_key		_SBF(2, 0x00)
#define CRYPTO_BC_192_bit_key		_SBF(2, 0x01)
#define CRYPTO_BC_256_bit_key		_SBF(2, 0x02)
#define CRYPTO_BC_DECRYPT		BIT(1)
#define CRYPTO_BC_ENABLE		BIT(0)

/* Hash Control Register */
#define CRYPTO_HASH_CTL			0x0048
#define CRYPTO_SHA1			_SBF(4, 0x00)
#define CRYPTO_MD5			_SBF(4, 0x01)
#define CRYPTO_SHA256			_SBF(4, 0x02)
#define CRYPTO_SHA224			_SBF(4, 0x03)
#define CRYPTO_SM3			_SBF(4, 0x06)
#define CRYPTO_SHA512			_SBF(4, 0x08)
#define CRYPTO_SHA384			_SBF(4, 0x09)
#define CRYPTO_SHA512_224		_SBF(4, 0x0A)
#define CRYPTO_SHA512_256		_SBF(4, 0x0B)
#define CRYPTO_HMAC_ENABLE		BIT(3)
#define CRYPTO_HW_PAD_ENABLE		BIT(2)
#define CRYPTO_HASH_SRC_SEL		BIT(1)
#define CRYPTO_HASH_ENABLE		BIT(0)

/* Cipher Status Register */
#define CRYPTO_CIPHER_ST		0x004C
#define CRYPTO_OTP_KEY_VALID		BIT(2)
#define CRYPTO_HASH_BUSY		BIT(1)
#define CRYPTO_BLOCK_CIPHER_BUSY	BIT(0)

#define CRYPTO_CIPHER_STATE		0x0050
#define CRYPTO_HASH_IDLE_STATE		_SBF(10, 0x01)
#define CRYPTO_HASH_IPAD_STATE		_SBF(10, 0x02)
#define CRYPTO_HASH_TEXT_STATE		_SBF(10, 0x04)
#define CRYPTO_HASH_OPAD_STATE		_SBF(10, 0x08)
#define CRYPTO_HASH_OPAD_EXT_STATE	_SBF(10, 0x10)
#define CRYPTO_GCM_IDLE_STATE		_SBF(8, 0x00)
#define CRYPTO_GCM_PRE_STATE		_SBF(8, 0x01)
#define CRYPTO_GCM_NA_STATE		_SBF(8, 0x02)
#define CRYPTO_GCM_PC_STATE		_SBF(8, 0x03)
#define CRYPTO_CCM_IDLE_STATE		_SBF(6, 0x00)
#define CRYPTO_CCM_PRE_STATE		_SBF(6, 0x01)
#define CRYPTO_CCM_NA_STATE		_SBF(6, 0x02)
#define CRYPTO_CCM_PC_STATE		_SBF(6, 0x03)
#define CRYPTO_PARALLEL_IDLE_STATE	_SBF(4, 0x00)
#define CRYPTO_PARALLEL_PRE_STATE	_SBF(4, 0x01)
#define CRYPTO_PARALLEL_BULK_STATE	_SBF(4, 0x02)
#define CRYPTO_MAC_IDLE_STATE		_SBF(2, 0x00)
#define CRYPTO_MAC_PRE_STATE		_SBF(2, 0x01)
#define CRYPTO_MAC_BULK_STATE		_SBF(2, 0x02)
#define CRYPTO_SERIAL_IDLE_STATE	_SBF(0, 0x00)
#define CRYPTO_SERIAL_PRE_STATE		_SBF(0, 0x01)
#define CRYPTO_SERIAL_BULK_STATE	_SBF(0, 0x02)

#define CRYPTO_CH0_IV_0         0x0100
#define CRYPTO_CH0_IV_1         0x0104
#define CRYPTO_CH0_IV_2         0x0108
#define CRYPTO_CH0_IV_3         0x010c
#define CRYPTO_CH1_IV_0         0x0110
#define CRYPTO_CH1_IV_1         0x0114
#define CRYPTO_CH1_IV_2         0x0118
#define CRYPTO_CH1_IV_3         0x011c
#define CRYPTO_CH2_IV_0         0x0120
#define CRYPTO_CH2_IV_1         0x0124
#define CRYPTO_CH2_IV_2         0x0128
#define CRYPTO_CH2_IV_3         0x012c
#define CRYPTO_CH3_IV_0         0x0130
#define CRYPTO_CH3_IV_1         0x0134
#define CRYPTO_CH3_IV_2         0x0138
#define CRYPTO_CH3_IV_3         0x013c
#define CRYPTO_CH4_IV_0         0x0140
#define CRYPTO_CH4_IV_1         0x0144
#define CRYPTO_CH4_IV_2         0x0148
#define CRYPTO_CH4_IV_3         0x014c
#define CRYPTO_CH5_IV_0         0x0150
#define CRYPTO_CH5_IV_1         0x0154
#define CRYPTO_CH5_IV_2         0x0158
#define CRYPTO_CH5_IV_3         0x015c
#define CRYPTO_CH6_IV_0         0x0160
#define CRYPTO_CH6_IV_1         0x0164
#define CRYPTO_CH6_IV_2         0x0168
#define CRYPTO_CH6_IV_3         0x016c
#define CRYPTO_CH7_IV_0         0x0170
#define CRYPTO_CH7_IV_1         0x0174
#define CRYPTO_CH7_IV_2         0x0178
#define CRYPTO_CH7_IV_3         0x017c

#define CRYPTO_CH0_KEY_0        0x0180
#define CRYPTO_CH0_KEY_1        0x0184
#define CRYPTO_CH0_KEY_2        0x0188
#define CRYPTO_CH0_KEY_3        0x018c
#define CRYPTO_CH1_KEY_0        0x0190
#define CRYPTO_CH1_KEY_1        0x0194
#define CRYPTO_CH1_KEY_2        0x0198
#define CRYPTO_CH1_KEY_3        0x019c
#define CRYPTO_CH2_KEY_0        0x01a0
#define CRYPTO_CH2_KEY_1        0x01a4
#define CRYPTO_CH2_KEY_2        0x01a8
#define CRYPTO_CH2_KEY_3        0x01ac
#define CRYPTO_CH3_KEY_0        0x01b0
#define CRYPTO_CH3_KEY_1        0x01b4
#define CRYPTO_CH3_KEY_2        0x01b8
#define CRYPTO_CH3_KEY_3        0x01bc
#define CRYPTO_CH4_KEY_0        0x01c0
#define CRYPTO_CH4_KEY_1        0x01c4
#define CRYPTO_CH4_KEY_2        0x01c8
#define CRYPTO_CH4_KEY_3        0x01cc
#define CRYPTO_CH5_KEY_0        0x01d0
#define CRYPTO_CH5_KEY_1        0x01d4
#define CRYPTO_CH5_KEY_2        0x01d8
#define CRYPTO_CH5_KEY_3        0x01dc
#define CRYPTO_CH6_KEY_0        0x01e0
#define CRYPTO_CH6_KEY_1        0x01e4
#define CRYPTO_CH6_KEY_2        0x01e8
#define CRYPTO_CH6_KEY_3        0x01ec
#define CRYPTO_CH7_KEY_0        0x01f0
#define CRYPTO_CH7_KEY_1        0x01f4
#define CRYPTO_CH7_KEY_2        0x01f8
#define CRYPTO_CH7_KEY_3        0x01fc
#define CRYPTO_KEY_CHANNEL_NUM	8

#define	CRYPTO_CH0_PC_LEN_0	0x0280
#define	CRYPTO_CH0_PC_LEN_1	0x0284
#define	CRYPTO_CH1_PC_LEN_0	0x0288
#define	CRYPTO_CH1_PC_LEN_1	0x028c
#define	CRYPTO_CH2_PC_LEN_0	0x0290
#define	CRYPTO_CH2_PC_LEN_1	0x0294
#define	CRYPTO_CH3_PC_LEN_0	0x0298
#define	CRYPTO_CH3_PC_LEN_1	0x029c
#define	CRYPTO_CH4_PC_LEN_0	0x02a0
#define	CRYPTO_CH4_PC_LEN_1	0x02a4
#define	CRYPTO_CH5_PC_LEN_0	0x02a8
#define	CRYPTO_CH5_PC_LEN_1	0x02ac
#define	CRYPTO_CH6_PC_LEN_0	0x02b0
#define	CRYPTO_CH6_PC_LEN_1	0x02b4
#define	CRYPTO_CH7_PC_LEN_0	0x02b8
#define	CRYPTO_CH7_PC_LEN_1	0x02bc

#define	CRYPTO_CH0_AAD_LEN_0	0x02c0
#define	CRYPTO_CH0_AAD_LEN_1	0x02c4
#define	CRYPTO_CH1_AAD_LEN_0	0x02c8
#define	CRYPTO_CH1_AAD_LEN_1	0x02cc
#define	CRYPTO_CH2_AAD_LEN_0	0x02d0
#define	CRYPTO_CH2_AAD_LEN_1	0x02d4
#define	CRYPTO_CH3_AAD_LEN_0	0x02d8
#define	CRYPTO_CH3_AAD_LEN_1	0x02dc
#define	CRYPTO_CH4_AAD_LEN_0	0x02e0
#define	CRYPTO_CH4_AAD_LEN_1	0x02e4
#define	CRYPTO_CH5_AAD_LEN_0	0x02e8
#define	CRYPTO_CH5_AAD_LEN_1	0x02ec
#define	CRYPTO_CH6_AAD_LEN_0	0x02f0
#define	CRYPTO_CH6_AAD_LEN_1	0x02f4
#define	CRYPTO_CH7_AAD_LEN_0	0x02f8
#define	CRYPTO_CH7_AAD_LEN_1	0x02fc

#define CRYPTO_CH0_IV_LEN_0     0x0300
#define CRYPTO_CH1_IV_LEN_0     0x0304
#define CRYPTO_CH2_IV_LEN_0     0x0308
#define CRYPTO_CH3_IV_LEN_0     0x030c
#define CRYPTO_CH4_IV_LEN_0     0x0310
#define CRYPTO_CH5_IV_LEN_0     0x0314
#define CRYPTO_CH6_IV_LEN_0     0x0318
#define CRYPTO_CH7_IV_LEN_0     0x031c

#define CRYPTO_CH0_TAG_0        0x0320
#define CRYPTO_CH0_TAG_1        0x0324
#define CRYPTO_CH0_TAG_2        0x0328
#define CRYPTO_CH0_TAG_3        0x032c

#define CRYPTO_HASH_DOUT_0      0x03a0
#define CRYPTO_HASH_DOUT_1      0x03a4
#define CRYPTO_HASH_DOUT_2      0x03a8
#define CRYPTO_HASH_DOUT_3      0x03ac
#define CRYPTO_HASH_DOUT_4      0x03b0
#define CRYPTO_HASH_DOUT_5      0x03b4
#define CRYPTO_HASH_DOUT_6      0x03b8
#define CRYPTO_HASH_DOUT_7      0x03bc
#define CRYPTO_HASH_DOUT_8      0x03c0
#define CRYPTO_HASH_DOUT_9      0x03c4
#define CRYPTO_HASH_DOUT_10     0x03c8
#define CRYPTO_HASH_DOUT_11     0x03cc
#define CRYPTO_HASH_DOUT_12     0x03d0
#define CRYPTO_HASH_DOUT_13     0x03d4
#define CRYPTO_HASH_DOUT_14     0x03d8
#define CRYPTO_HASH_DOUT_15     0x03dc

#define CRYPTO_TAG_VALID        0x03e0
#define CRYPTO_CH0_TAG_VALID    BIT(0)

#define CRYPTO_HASH_VALID       0x03e4
#define CRYPTO_HASH_IS_VALID	BIT(0)

#define	LLI_DMA_CTRL_LAST	BIT(0)
#define	LLI_DMA_CTRL_PAUSE	BIT(1)
#define	LLI_DMA_CTRL_LIST_DONE	BIT(8)
#define	LLI_DMA_CTRL_DST_DONE	BIT(9)
#define	LLI_DMA_CTRL_SRC_DONE	BIT(10)

#define LLI_USER_CIPHER_START	BIT(0)
#define LLI_USER_STRING_START	BIT(1)
#define LLI_USER_STRING_LAST	BIT(2)
#define LLI_USER_STRING_AAD	BIT(3)
#define LLI_USER_PRIVACY_KEY	BIT(7)
#define LLI_USER_ROOT_KEY	BIT(8)

#define CRYPTO_PKA_BASE_OFFSET		0x0480

#define	CRYPTO_RAM_CTL			(0x0480 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_RAM_PKA_RDY		BIT(0)

#define	CRYPTO_RAM_ST			(0x0484 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_CLK_RAM_RDY		BIT(0)
#define	CRYPTO_CLK_RAM_RDY_MASK		BIT(0)

#define	CRYPTO_DEBUG_CTL		(0x04a0 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_DEBUG_MODE		BIT(0)

#define	CRYPTO_DEBUG_ST			(0x04a4 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_DEBUG_CLK_EN		BIT(0)

#define	CRYPTO_DEBUG_MONITOR		(0x04a8 - CRYPTO_PKA_BASE_OFFSET)

/* MAP0 ~ MAP31 */
#define	CRYPTO_MEMORY_MAP0		(0x00800 - CRYPTO_PKA_BASE_OFFSET)
#define CRYPTO_MAP_REG_NUM		32

#define	CRYPTO_OPCODE			(0x00880 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_OPCODE_TAG_SHIFT		0
#define	CRYPTO_OPCODE_R_SHIFT		6
#define CRYPTO_OPCODE_R_DIS_SHIFT	11
#define	CRYPTO_OPCODE_B_SHIFT		12
#define CRYPTO_OPCODE_B_IMMED_SHIFT	17
#define	CRYPTO_OPCODE_A_SHIFT		18
#define CRYPTO_OPCODE_A_IMMED_SHIFT	23
#define	CRYPTO_OPCODE_LEN_SHIFT		24
#define	CRYPTO_OPCODE_CODE_SHIFT	27

#define	CRYPTO_N_NP_T0_T1_ADDR		(0x00884 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_N_VIRTUAL_ADDR_SHIFT	0
#define	CRYPTO_N_VIRTUAL_ADDR_MASK	0x0000001f
#define	CRYPTO_NP_VIRTUAL_ADDR_SHIFT	5
#define	CRYPTO_NP_VIRTUAL_ADDR_MASK	0x000003e0
#define	CRYPTO_T0_VIRTUAL_ADDR_SHIFT	10
#define	CRYPTO_T0_VIRTUAL_ADDR_MASK	0x00007c00
#define	CRYPTO_T1_VIRTUAL_ADDR_SHIFT	15
#define	CRYPTO_T1_VIRTUAL_ADDR_MASK	0x000f8000

#define	CRYPTO_PKA_STATUS		(0x00888 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_PIPE_IS_RDY		BIT(0)
#define	CRYPTO_PKA_BUSY			BIT(1)
#define	CRYPTO_PKA_ALU_OUT_ZERO		BIT(2)
#define	CRYPTO_PKA_ALU_MODOVRFLW	BIT(3)
#define	CRYPTO_PKA_DIV_BY_ZERO		BIT(4)
#define	CRYPTO_PKA_ALU_CARRY		BIT(5)
#define	CRYPTO_PKA_ALU_SIGN_OUT		BIT(6)
#define	CRYPTO_PKA_MODINV_OF_ZERO	BIT(7)
#define	CRYPTO_PKA_CPU_BUSY		BIT(8)
#define	CRYPTO_PKA_OPCODE_STATUS_SHIFT	9
#define	CRYPTO_PKA_OPCODE_STATUS_MASK	0x00003e00
#define	CRYPTO_PKA_TAG_STATUS_SHIFT	14
#define	CRYPTO_PKA_TAG_STATUS_MASK	0x0003c000

#define	CRYPTO_PKA_SW_RESET		(0x0088C - CRYPTO_PKA_BASE_OFFSET)

/* PKA_L0 ~ PKA_L7 */
#define	CRYPTO_PKA_L0			(0x00890 - CRYPTO_PKA_BASE_OFFSET)
#define CRYPTO_LEN_REG_NUM		8

#define	CRYPTO_PKA_PIPE_RDY		(0x008B0 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_DONE			(0x008B4 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_MON_SELECT		(0x008B8 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_DEBUG_REG_EN		(0x008BC - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_DEBUG_CNT_ADDR		(0x008C0 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_DEBUG_EXT_ADDR		(0x008C4 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_DEBUG_HALT		(0x008C8 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_MON_READ		(0x008D0 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_INT_ENA		(0x008D4 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_PKA_INT_ST		(0x008D8 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_SRAM_BASE		(0x01000 - CRYPTO_PKA_BASE_OFFSET)
#define	CRYPTO_SRAM_SIZE		0x01000

#endif

