/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * rv1106_codec.h - Rockchip RV1106 SoC Codec Driver
 *
 * Copyright (C) 2022 Rockchip Electronics Co., Ltd.
 */

#ifndef __RV1106_CODEC_H__
#define __RV1106_CODEC_H__

#define ACODEC_RESET_CTL			0x00 /* REG 0x00 */
#define ACODEC_GLB_CON				ACODEC_RESET_CTL
#define ACODEC_MUTE_DA_DITHER_CTL		0x04 /* REG 0x01 */

/* ADC DIGITAL REGISTERS */
#define ACODEC_ADC_I2S_CTL0			0x08 /* REG 0x02 */
#define ACODEC_ADC_I2S_CTL1			0x0c /* REG 0x03 */
#define ACODEC_DAC_I2S_CTL0			0x10 /* REG 0x04 */
#define ACODEC_DAC_I2S_CTL1			0x14 /* REG 0x05 */
#define ACODEC_DAC_GAIN_SEL			0x18 /* REG 0x06 */
#define ACODEC_DAC_L_BIST_MODE_SEL		0x1c /* REG 0x07 */
#define ACODEC_ADC_L_DIG_VOL			0x20 /* REG 0x08 */
#define ACODEC_ADC_R_DIG_VOL			0x24 /* REG 0x09 */
#define ACODEC_ADC_HPF_PGA_CTL			0x28 /* REG 0x0a */
#define ACODEC_INIT_DELAY_CNT1			0x2c /* REG 0x0b */
#define ACODEC_INIT_DELAY_CNT2			0x30 /* REG 0x0c */
#define ACODEC_ADC_BIST_MODE_SEL		0x34 /* REG 0x0d */
#define ACODEC_DAC_CONFIG_OUTPUT		0x38 /* REG 0x0e */
#define ACODEC_LINEOUT_CTL			0x80 /* REG 0x20 */
#define ACODEC_CURRENT_CHARGE_CTL		0x84 /* REG 0x21 */

#define ACODEC_ADC_ANA_CTL0			0x88 /* REG 0x22 */
#define ACODEC_ADC_ANA_CTL1			0x8c /* REG 0x23 */
#define ACODEC_ADC_ANA_CTL2			0x90 /* REG 0x24 */
#define ACODEC_ADC_ANA_CTL3			0x94 /* REG 0x25 */
#define ACODEC_ADC_ANA_CTL4			0x98 /* REG 0x26 */
#define ACODEC_ADC_ANA_CTL5			0x9c /* REG 0x27 */
#define ACODEC_ADC_ANA_CTL6			0xa0 /* REG 0x28 */

#define ACODEC_DAC_ANA_CTL0			0xa4 /* REG 0x29 */
#define ACODEC_DAC_ANA_CTL1			0xa8 /* REG 0x2a */
#define ACODEC_DAC_ANA_CTL2			0xac /* REG 0x2b */
#define ACODEC_DAC_HPMIX_CTL			0xbc /* REG 0x2f */

/* The description of the agc register for the left channel */
#define ACODEC_ADC_PGA_AGC_L_CTL0		0x100 /* REG 0x40 */
#define ACODEC_ADC_PGA_AGC_L_CTL1		0x104 /* REG 0x41 */
#define ACODEC_ADC_PGA_AGC_L_CTL2		0x108 /* REG 0x42 */
#define ACODEC_ADC_PGA_AGC_L_CTL3		0x10c /* REG 0x43 */
#define ACODEC_ADC_PGA_AGC_L_CTL4		0x110 /* REG 0x44 */
#define ACODEC_ADC_PGA_AGC_L_CTL5		0x114 /* REG 0x45 */
#define ACODEC_ADC_PGA_AGC_L_CTL6		0x118 /* REG 0x46 */
#define ACODEC_ADC_PGA_AGC_L_CTL7		0x11c /* REG 0x47 */
#define ACODEC_ADC_PGA_AGC_L_CTL8		0x120 /* REG 0x48 */
#define ACODEC_ADC_PGA_AGC_L_CTL9		0x124 /* REG 0x49 */

/* The description of the agc register for the right channel */
#define ACODEC_ADC_PGA_AGC_R_CTL0		0x140 /* REG 0x50 */
#define ACODEC_ADC_PGA_AGC_R_CTL1		0x144 /* REG 0x51 */
#define ACODEC_ADC_PGA_AGC_R_CTL2		0x148 /* REG 0x52 */
#define ACODEC_ADC_PGA_AGC_R_CTL3		0x14c /* REG 0x53 */
#define ACODEC_ADC_PGA_AGC_R_CTL4		0x150 /* REG 0x54 */
#define ACODEC_ADC_PGA_AGC_R_CTL5		0x154 /* REG 0x55 */
#define ACODEC_ADC_PGA_AGC_R_CTL6		0x158 /* REG 0x56 */
#define ACODEC_ADC_PGA_AGC_R_CTL7		0x15c /* REG 0x57 */
#define ACODEC_ADC_PGA_AGC_R_CTL8		0x160 /* REG 0x58 */
#define ACODEC_ADC_PGA_AGC_R_CTL9		0x164 /* REG 0x59 */

#define ACODEC_REG_MAX				ACODEC_ADC_PGA_AGC_R_CTL9

/* ACODEC_RESET_CTL */
#define ACODEC_CODEC_BIST_MSK			(1 << 7)
#define ACODEC_CODEC_BIST_WORK			(1 << 7)
#define ACODEC_CODEC_BIST_RST			(0 << 7)
#define ACODEC_CODEC_CORE_RST_MSK		(1 << 1)
#define ACODEC_CODEC_CORE_WORK			(1 << 1)
#define ACODEC_CODEC_CORE_RST			(0 << 1)
#define ACODEC_CODEC_SYS_RST_MSK		(1 << 0)
#define ACODEC_CODEC_SYS_WORK			(1 << 0)
#define ACODEC_CODEC_SYS_RST			(0 << 0)

/* ACODEC_MUTE_DA_DITHER_CTL */
#define ACODEC_DAC_MUTE_MSK			(1 << 7)
#define ACODEC_DAC_MUTE_EN			(1 << 7)
#define ACODEC_DAC_MUTE_DIS			(0 << 7)
#define ACODEC_DITHER_LEVEL_SEL			(1 << 3)
#define ACODEC_DA_MSK				(1 << 2)
#define ACODEC_DA_EN				(1 << 2)
#define ACODEC_DA_DIS				(0 << 2)
#define ACODEC_DITHER_MSK			(1 << 1)
#define ACODEC_DITHER_EN			(1 << 1)
#define ACODEC_DITHER_DIS			(0 << 1)
#define ACODEC_DITHER_SIGN			(1 << 0)

/* ACODEC_ADC_I2S_CTL0 */
#define ACODEC_ADC_I2S_LRC_POL_MSK		(1 << 7)
#define ACODEC_ADC_I2S_LRC_POL_REVERSAL		(1 << 7)
#define ACODEC_ADC_I2S_LRC_POL_NORMAL		(0 << 7)
#define ACODEC_ADC_I2S_VALID_LEN_SFT		5
#define ACODEC_ADC_I2S_VALID_LEN_MSK		(0x3 << ACODEC_ADC_I2S_VALID_LEN_SFT)
#define ACODEC_ADC_I2S_VALID_LEN_32BITS		(0x3 << ACODEC_ADC_I2S_VALID_LEN_SFT)
#define ACODEC_ADC_I2S_VALID_LEN_24BITS		(0x2 << ACODEC_ADC_I2S_VALID_LEN_SFT)
#define ACODEC_ADC_I2S_VALID_LEN_20BITS		(0x1 << ACODEC_ADC_I2S_VALID_LEN_SFT)
#define ACODEC_ADC_I2S_VALID_LEN_16BITS		(0x0 << ACODEC_ADC_I2S_VALID_LEN_SFT)
#define ACODEC_ADC_I2S_MODE_SFT			3
#define ACODEC_ADC_I2S_MODE_MSK			(0x3 << ACODEC_ADC_I2S_MODE_SFT)
#define ACODEC_ADC_I2S_MODE_PCM			(0x3 << ACODEC_ADC_I2S_MODE_SFT)
#define ACODEC_ADC_I2S_MODE_I2S			(0x2 << ACODEC_ADC_I2S_MODE_SFT)
#define ACODEC_ADC_I2S_MODE_LJ			(0x1 << ACODEC_ADC_I2S_MODE_SFT)
#define ACODEC_ADC_I2S_MODE_RJ			(0x0 << ACODEC_ADC_I2S_MODE_SFT)
#define ACODEC_ADC_I2S_SEL_DATA_MSK		(1 << 2)
#define ACODEC_ADC_I2S_SEL_ADC_DATA		(1 << 2)
#define ACODEC_ADC_I2S_SEL_ADCL_DACL_DATA	(0 << 2)
#define ACODEC_ADC_I2S_DATA_SEL			0
#define ACODEC_ADC_I2S_DATA_SEL_MSK		(0x3 << ACODEC_ADC_I2S_DATA_SEL)
#define ACODEC_ADC_I2S_DATA_SWAP		(0x3 << ACODEC_ADC_I2S_DATA_SEL)
#define ACODEC_ADC_I2S_DATA_SEL_LEFT		(0x2 << ACODEC_ADC_I2S_DATA_SEL)
#define ACODEC_ADC_I2S_DATA_SEL_RIGHT		(0x1 << ACODEC_ADC_I2S_DATA_SEL)
#define ACODEC_ADC_I2S_DATA_SEL_NORMAL		(0x0 << ACODEC_ADC_I2S_DATA_SEL)

/* ACODEC_ADC_I2S_CTL1 */
#define ACODEC_DAC_IO_MODE_MSK			(0x1 << 7)
#define ACODEC_DAC_IO_MODE_MASTER		(0x1 << 7)
#define ACODEC_DAC_IO_MODE_SLAVE		(0x0 << 7)
#define ACODEC_DAC_MODE_MSK			(0x1 << 6)
#define ACODEC_DAC_MODE_MASTER			(0x1 << 6)
#define ACODEC_DAC_MODE_SLAVE			(0x0 << 6)
#define ACODEC_ADC_IO_MODE_MSK			(0x1 << 5)
#define ACODEC_ADC_IO_MODE_MASTER		(0x1 << 5)
#define ACODEC_ADC_IO_MODE_SLAVE		(0x0 << 5)
#define ACODEC_ADC_MODE_MSK			(0x1 << 4)
#define ACODEC_ADC_MODE_MASTER			(0x1 << 4)
#define ACODEC_ADC_MODE_SLAVE			(0x0 << 4)
#define ACODEC_ADC_I2S_FRAME_LEN_SFT		2
#define ACODEC_ADC_I2S_FRAME_LEN_MSK		(0x3 << ACODEC_ADC_I2S_FRAME_LEN_SFT)
#define ACODEC_ADC_I2S_FRAME_32BITS		(0x3 << ACODEC_ADC_I2S_FRAME_LEN_SFT)
#define ACODEC_ADC_I2S_FRAME_24BITS		(0x1 << ACODEC_ADC_I2S_FRAME_LEN_SFT)
#define ACODEC_ADC_I2S_MSK			(0x1 << 1)
#define ACODEC_ADC_I2S_WORK			(0x1 << 1)
#define ACODEC_ADC_I2S_RESET			(0x0 << 1)
#define ACODEC_ADC_I2S_BIT_CLK_POL_MSK		(0x1 << 0)
#define ACODEC_ADC_I2S_BIT_CLK_POL_REVERSAL	(0x1 << 0)
#define ACODEC_ADC_I2S_BIT_CLK_POL_NORMAL	(0x0 << 0)

/* ACODEC_DAC_I2S_CTL0 */
#define ACODEC_DAC_I2S_LRC_POL_MSK		(0x1 << 7)
#define ACODEC_DAC_I2S_LRC_POL_REVERSAL		(0x1 << 7)
#define ACODEC_DAC_I2S_LRC_POL_NORMAL		(0x0 << 7)
#define ACODEC_DAC_I2S_VALID_LEN_SFT		5
#define ACODEC_DAC_I2S_VALID_LEN_MSK		(0x3 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_I2S_VALID_LEN_32BITS		(0x3 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_I2S_VALID_LEN_24BITS		(0x2 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_I2S_VALID_LEN_20BITS		(0x1 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_I2S_VALID_LEN_16BITS		(0x0 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_I2S_MODE_SFT			3
#define ACODEC_DAC_I2S_MODE_MSK			(0x3 << ACODEC_DAC_I2S_MODE_SFT)
#define ACODEC_DAC_I2S_MODE_PCM			(0x3 << ACODEC_DAC_I2S_MODE_SFT)
#define ACODEC_DAC_I2S_MODE_I2S			(0x2 << ACODEC_DAC_I2S_MODE_SFT)
#define ACODEC_DAC_I2S_MODE_LJ			(0x1 << ACODEC_DAC_I2S_MODE_SFT)
#define ACODEC_DAC_I2S_MODE_RJ			(0x0 << ACODEC_DAC_I2S_MODE_SFT)
#define ACODEC_DAC_I2S_LR_MSK			(0x1 << 2)
#define ACODEC_DAC_I2S_LR_SWAP			(0x1 << 2)
#define ACODEC_DAC_I2S_LR_NORMAL		(0x0 << 2)

/* ACODEC_DAC_I2S_CTL1 */
#define ACODEC_DAC_DE_EMPHASIS_FILTER_SFT	4
#define ACODEC_DAC_DE_EMPHASIS_FILTER_MSK	(0x3 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_48_DE_EMPHASIS_FILTER	(0x3 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_441_DE_EMPHASIS_FILTER	(0x2 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_32_DE_EMPHASIS_FILTER	(0x1 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_NO_DE_EMPHASIS_FILTER	(0x0 << ACODEC_DAC_I2S_VALID_LEN_SFT)
#define ACODEC_DAC_I2S_FRAME_LEN_SFT		2
#define ACODEC_DAC_I2S_FRAME_LEN_MSK		(0x3 << ACODEC_DAC_I2S_FRAME_LEN_SFT)
#define ACODEC_DAC_I2S_FRAME_32BITS		(0x3 << ACODEC_DAC_I2S_FRAME_LEN_SFT)
#define ACODEC_DAC_I2S_FRAME_24BITS		(0x2 << ACODEC_DAC_I2S_FRAME_LEN_SFT)
#define ACODEC_DAC_I2S_FRAME_20BITS		(0x1 << ACODEC_DAC_I2S_FRAME_LEN_SFT)
#define ACODEC_DAC_I2S_FRAME_16BITS		(0x0 << ACODEC_DAC_I2S_FRAME_LEN_SFT)
#define ACODEC_DAC_I2S_MSK			(0x1 << 1)
#define ACODEC_DAC_I2S_WORK			(0x1 << 1)
#define ACODEC_DAC_I2S_RESET			(0x0 << 1)
#define ACODEC_DAC_I2S_BIT_CLK_POL_MSK		(0x1 << 0)
#define ACODEC_DAC_I2S_BIT_CLK_POL_REVERSAL	(0x1 << 0)
#define ACODEC_DAC_I2S_BIT_CLK_POL_NORMAL	(0x0 << 0)

/* ACODEC_DAC_GAIN_SEL */
#define ACODEC_DAC_DIG_GAIN_SFT			0
#define ACODEC_DAC_DIG_GAIN_MSK			(0xff << ACODEC_DAC_DIG_GAIN_SFT)
#define ACODEC_DAC_DIG_GAIN(x)			((x) & ACODEC_DAC_DIG_GAIN_MSK)
#define ACODEC_DAC_DIG_0DB			0xed

/* ACODEC_DAC_L_BIST_MODE_SEL */
#define ACODEC_DAC_L_CH_BIST_SFT		4
#define ACODEC_DAC_L_CH_BIST_MSK		(0x3 << ACODEC_DAC_L_CH_BIST_SFT)
#define ACODEC_DAC_L_CH_BIST_SINE		(0x1 << ACODEC_DAC_L_CH_BIST_SFT)
#define ACODEC_DAC_L_CH_BIST_LEFT		(0x0 << ACODEC_DAC_L_CH_BIST_SFT) /* normal mode */

/* ACODEC_ADC_L_DIG_VOL */
#define ACODEC_ADC_L_DIG_VOL_MAX		0xff
#define ACODEC_ADC_L_DIG_VOL_MIN		0
#define ACODEC_ADC_L_DIG_VOL_SFT		0
#define ACODEC_ADC_L_DIG_VOL_MUTE		0
#define ACODEC_ADC_L_DIG_VOL_0DB		0xc3

/* ACODEC_ADC_R_DIG_VOL */
#define ACODEC_ADC_R_DIG_VOL_MAX		0xff
#define ACODEC_ADC_R_DIG_VOL_MIN		0
#define ACODEC_ADC_R_DIG_VOL_SFT		0
#define ACODEC_ADC_R_DIG_VOL_MUTE		0
#define ACODEC_ADC_R_DIG_VOL_0DB		0xc3

/* ACODEC_ADC_HPF_PGA_CTL */
#define ACODEC_ADC_FILTER_MSK			(1 << 7)
#define ACODEC_ADC_FILTER_EN			(1 << 7)
#define ACODEC_ADC_FILTER_DIS			(0 << 7)
#define ACODEC_ADC_AGC_MSK			(1 << 6)
#define ACODEC_ADC_FILTER_OUTPUT		(1 << 6)
#define ACODEC_ADC_SINC_OUTPUT			(0 << 6)
#define ACODEC_ADC_L_PGA_MSK			(1 << 5)
#define ACODEC_ADC_PGA_ALCL_EN			(1 << 5)
#define ACODEC_ADC_PGA_ALCL_DIS			(0 << 5)
#define ACODEC_ADC_R_PGA_MSK			(1 << 4)
#define ACODEC_ADC_PGA_ALCR_EN			(1 << 4)
#define ACODEC_ADC_PGA_ALCR_DIS			(0 << 4)
#define ACODEC_ADC_HPF_SFT			2
#define ACODEC_ADC_HPF_MSK			(3 << ACODEC_ADC_HPF_SFT)
#define ACODEC_ADC_HPF_EN			(3 << ACODEC_ADC_HPF_SFT)
#define ACODEC_ADC_HPF_DIS			(0 << ACODEC_ADC_HPF_SFT)
#define ACODEC_ADC_R_DATA_POL_INV_MSK		(1 << 1)
#define ACODEC_ADC_R_DATA_POL_INV_EN		(1 << 1)
#define ACODEC_ADC_R_DATA_POL_INV_DIS		(0 << 1)
#define ACODEC_ADC_L_DATA_POL_INV_MSK		(1 << 0)
#define ACODEC_ADC_L_DATA_POL_INV_EN		(1 << 0)
#define ACODEC_ADC_L_DATA_POL_INV_DIS		(0 << 0)

/* ACODEC_ADC_BIST_MODE_SEL */
#define ACODEC_ADC_R_BIST_SFT			6
#define ACODEC_ADC_R_BIST_MSK			(0x3 << ACODEC_ADC_R_BIST_SFT)
#define ACODEC_ADC_R_BIST_SINE			(0x1 << ACODEC_ADC_R_BIST_SFT)
#define ACODEC_ADC_BIST_RIGHT			(0x0 << ACODEC_ADC_R_BIST_SFT) /* normal mode */
#define ACODEC_ADC_L_BIST_SFT			4
#define ACODEC_ADC_L_BIST_MSK			(0x3 << ACODEC_ADC_L_BIST_SFT)
#define ACODEC_ADC_L_BIST_SINE			(0x1 << ACODEC_ADC_L_BIST_SFT)
#define ACODEC_ADC_BIST_LEFT			(0x0 << ACODEC_ADC_L_BIST_SFT) /* normal mode */

/* ACODEC_LINEOUT_CTL */
#define ACODEC_DAC_LINEOUT_EN_SFT               7
#define ACODEC_DAC_LINEOUT_EN_WORK              (0x1 << ACODEC_DAC_LINEOUT_EN_SFT)
#define ACODEC_DAC_LINEOUT_EN_RST               (0x0 << ACODEC_DAC_LINEOUT_EN_SFT)
#define ACODEC_DAC_LINEOUT_INI_SFT		6
#define ACODEC_DAC_LINEOUT_INI_WORK		(0x1 << ACODEC_DAC_LINEOUT_INI_SFT)
#define ACODEC_DAC_LINEOUT_INI_RST		(0x0 << ACODEC_DAC_LINEOUT_INI_SFT)
#define ACODEC_DAC_IBIAS_SEL_SFT		0
#define ACODEC_DAC_IBIAS_SEL_MSK		(0xf << ACODEC_DAC_IBIAS_SEL_SFT)

/* ACODEC_CURRENT_CHARGE_CTL */
#define ACODEC_ADC_CURRENT_CHARGE_SFT		0
#define ACODEC_ADC_CURRENT_CHARGE_MSK		(0xff << ACODEC_ADC_CURRENT_CHARGE_SFT)
/*
 * 1: Choose the current I
 * 0: Don't choose the current I
 */
#define ACODEC_ADC_SEL_I(x)			(x & 0xff)

/* ACODEC_ADC_ANA_CTL0 */
#define ACODEC_ADC_REF_VOL_MSK			(0x1 << 5)
#define ACODEC_ADC_REF_VOL_EN			(0x1 << 5)
#define ACODEC_ADC_REF_VOL_DIS			(0x0 << 5)
#define ACODEC_ADC_IBIAS_MSK			(0x1 << 4)
#define ACODEC_ADC_IBIAS_EN			(0x1 << 4)
#define ACODEC_ADC_IBIAS_DIS			(0x0 << 4)
#define ACODEC_MICBIAS_SFT			3
#define ACODEC_MICBIAS_MSK			(0x1 << 3)
#define ACODEC_MICBIAS_WORK			(0x1 << 3)
#define ACODEC_MICBIAS_RST			(0x0 << 3)
#define ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT	0
#define ACODEC_ADC_LEVEL_RANGE_MICBIAS_MSK	(0x7 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_975		(0x7 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_95		(0x6 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_925		(0x5 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_9		(0x4 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_875		(0x3 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_85		(0x2 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_825		(0x1 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define ACODEC_ADC_MICBIAS_VOLT_0_8		(0x0 << ACODEC_ADC_LEVEL_RANGE_MICBIAS_SFT)

/* ACODEC_ADC_ANA_CTL1 */
#define ACODEC_ADC_L_MIC_MSK			(0x1 << 7)
#define ACODEC_ADC_L_MIC_WORK			(0x1 << 7)
#define ACODEC_ADC_L_MIC_MUTE			(0x0 << 7)
#define ACODEC_ADC_L_MIC_SIGNAL_MSK		(0x1 << 6)
#define ACODEC_ADC_L_MIC_SIGNAL_WORK		(0x1 << 6)
#define ACODEC_ADC_L_MIC_SIGNAL_INIT		(0x0 << 6)
#define ACODEC_ADC_L_REF_VOL_BUF_MSK		(0x1 << 5)
#define ACODEC_ADC_L_REF_VOL_BUF_EN		(0x1 << 5)
#define ACODEC_ADC_L_REF_VOL_BUF_DIS		(0x0 << 5)
#define ACODEC_ADC_L_ZERO_CROSS_DET_MSK		(0x1 << 4)
#define ACODEC_ADC_L_ZERO_CROSS_DET_EN		(0x1 << 4)
#define ACODEC_ADC_L_ZERO_CROSS_DET_DIS		(0x0 << 4)
#define ACODEC_ADC_R_MIC_MSK			(0x1 << 3)
#define ACODEC_ADC_R_MIC_WORK			(0x1 << 3)
#define ACODEC_ADC_R_MIC_MUTE			(0x0 << 3)
#define ACODEC_ADC_R_MIC_SIGNAL_MSK		(0x1 << 2)
#define ACODEC_ADC_R_MIC_SIGNAL_WORK		(0x1 << 2)
#define ACODEC_ADC_R_MIC_SIGNAL_INIT		(0x0 << 2)
#define ACODEC_ADC_R_REF_VOL_BUF_MSK		(0x1 << 1)
#define ACODEC_ADC_R_REF_VOL_BUF_EN		(0x1 << 1)
#define ACODEC_ADC_R_REF_VOL_BUF_DIS		(0x0 << 1)
#define ACODEC_ADC_R_ZERO_CROSS_DET_MSK		(0x1 << 0)
#define ACODEC_ADC_R_ZERO_CROSS_DET_EN		(0x1 << 0)
#define ACODEC_ADC_R_ZERO_CROSS_DET_DIS		(0x0 << 0)

/* ACODEC_ADC_ANA_CTL2 */
#define ACODEC_ADC_MIC_GAIN_MAX			0x3
#define ACODEC_ADC_MIC_GAIN_MIN			0x1
#define ACODEC_ADC_L_MIC_GAIN_SFT		6
#define ACODEC_ADC_L_MIC_GAIN_MSK		(0x3 << ACODEC_ADC_L_MIC_GAIN_SFT)
#define ACODEC_ADC_L_MIC_GAIN_12DB		(0x3 << ACODEC_ADC_L_MIC_GAIN_SFT)
#define ACODEC_ADC_L_MIC_GAIN_20DB		(0x2 << ACODEC_ADC_L_MIC_GAIN_SFT)
#define ACODEC_ADC_L_MIC_GAIN_0DB		(0x1 << ACODEC_ADC_L_MIC_GAIN_SFT)
#define ACODEC_ADC_R_MIC_GAIN_SFT		4
#define ACODEC_ADC_R_MIC_GAIN_MSK		(0x3 << ACODEC_ADC_R_MIC_GAIN_SFT)
#define ACODEC_ADC_R_MIC_GAIN_12DB		(0x3 << ACODEC_ADC_R_MIC_GAIN_SFT)
#define ACODEC_ADC_R_MIC_GAIN_20DB		(0x2 << ACODEC_ADC_R_MIC_GAIN_SFT)
#define ACODEC_ADC_R_MIC_GAIN_0DB		(0x1 << ACODEC_ADC_R_MIC_GAIN_SFT)
#define ACODEC_ADC_IBIAS_SEL_SFT		0
#define ACODEC_ADC_IBIAS_SEL_MSK		(0xf << ACODEC_ADC_IBIAS_SEL_SFT)

/* ACODEC_ADC_ANA_CTL3 */
#define ACODEC_ADC_L_MODE_SEL_SFT		6
#define ACODEC_ADC_L_MODE_SEL_MSK		(0x3 << ACODEC_ADC_L_MODE_SEL_SFT)
#define ACODEC_ADC_L_FULL_DIFFER2		(0x2 << ACODEC_ADC_L_MODE_SEL_SFT) /* Only used for rv1103 acodec */
#define ACODEC_ADC_L_SINGLE_END			(0x1 << ACODEC_ADC_L_MODE_SEL_SFT)
#define ACODEC_ADC_L_FULL_DIFFER		(0x0 << ACODEC_ADC_L_MODE_SEL_SFT)
#define ACODEC_ADC_L_MSK			(0x1 << 5)
#define ACODEC_ADC_L_EN				(0x1 << 5)
#define ACODEC_ADC_L_DIS			(0x0 << 5)
#define ACODEC_MIC_L_MSK			(0x1 << 4)
#define ACODEC_MIC_L_EN				(0x1 << 4)
#define ACODEC_MIC_L_DIS			(0x0 << 4)
#define ACODEC_ADC_R_MODE_SEL_SFT		2
#define ACODEC_ADC_R_MODE_SEL_MSK		(0x3 << ACODEC_ADC_R_MODE_SEL_SFT)
#define ACODEC_ADC_R_SINGLE_END			(0x1 << ACODEC_ADC_R_MODE_SEL_SFT)
#define ACODEC_ADC_R_FULL_DIFFER		(0x0 << ACODEC_ADC_R_MODE_SEL_SFT)
#define ACODEC_ADC_R_MSK			(0x1 << 1)
#define ACODEC_ADC_R_EN				(0x1 << 1)
#define ACODEC_ADC_R_DIS			(0x0 << 1)
#define ACODEC_MIC_R_MSK			(0x1 << 0)
#define ACODEC_MIC_R_EN				(0x1 << 0)
#define ACODEC_MIC_R_DIS			(0x0 << 0)

/* ACODEC_ADC_ANA_CTL4 */
#define ACODEC_ADC_L_ALC_GAIN_MAX		0x1f
#define ACODEC_ADC_L_ALC_GAIN_MIN		0
#define ACODEC_ADC_L_ALC_GAIN_SFT		0
#define ACODEC_ADC_L_ALC_GAIN_MSK		(0x1f << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_37_5		(0x1f << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_36		(0x1e << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_34_5		(0x1d << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_33		(0x1c << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_31_5		(0x1b << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_30		(0x1a << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_28_5		(0x19 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_27		(0x18 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_25_5		(0x17 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_24		(0x16 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_22_5		(0x15 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_21		(0x14 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_19_5		(0x13 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_18		(0x12 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_16_5		(0x11 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_15		(0x10 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_13_5		(0x0f << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_12		(0x0e << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_10_5		(0x0d << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_9		(0x0c << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_7_5		(0x0b << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_6		(0x0a << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_4_5		(0x09 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_3		(0x08 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_PDB_1_5		(0x07 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_0DB		(0x06 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_NDB_1_5		(0x05 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_NDB_3		(0x04 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_NDB_4_5		(0x03 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_NDB_6		(0x02 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_NDB_7_5		(0x01 << ACODEC_ADC_L_ALC_GAIN_SFT)
#define ACODEC_ADC_L_ALC_GAIN_NDB_9		(0x00 << ACODEC_ADC_L_ALC_GAIN_SFT)

/* ACODEC_ADC_ANA_CTL5 */
#define ACODEC_ADC_R_ALC_GAIN_MAX		0x1f
#define ACODEC_ADC_R_ALC_GAIN_MIN		0
#define ACODEC_ADC_R_ALC_GAIN_SFT		0
#define ACODEC_ADC_R_ALC_GAIN_MSK		(0x1f << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_37_5		(0x1f << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_36		(0x1e << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_34_5		(0x1d << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_33		(0x1c << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_31_5		(0x1b << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_30		(0x1a << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_28_5		(0x19 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_27		(0x18 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_25_5		(0x17 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_24		(0x16 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_22_5		(0x15 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_21		(0x14 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_19_5		(0x13 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_18		(0x12 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_16_5		(0x11 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_15		(0x10 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_13_5		(0x0f << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_12		(0x0e << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_10_5		(0x0d << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_9		(0x0c << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_7_5		(0x0b << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_6		(0x0a << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_4_5		(0x09 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_3		(0x08 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_PDB_1_5		(0x07 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_0DB		(0x06 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_NDB_1_5		(0x05 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_NDB_3		(0x04 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_NDB_4_5		(0x03 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_NDB_6		(0x02 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_NDB_7_5		(0x01 << ACODEC_ADC_R_ALC_GAIN_SFT)
#define ACODEC_ADC_R_ALC_GAIN_NDB_9		(0x00 << ACODEC_ADC_R_ALC_GAIN_SFT)

/* ACODEC_ADC_ANA_CTL6 */
#define ACODEC_ADC_L_ALC_MSK			(0x1 << 7)
#define ACODEC_ADC_L_ALC_WORK			(0x1 << 7)
#define ACODEC_ADC_L_ALC_INIT			(0x0 << 7)
#define ACODEC_ADC_L_CLK_MSK			(0x1 << 6)
#define ACODEC_ADC_L_CLK_WORK			(0x1 << 6)
#define ACODEC_ADC_L_CLK_RST			(0x0 << 6)
#define ACODEC_ADC_L_WORK			(0x1 << 5)
#define ACODEC_ADC_L_INIT			(0x0 << 5)
#define ACODEC_ADC_L_SIGNAL_EN			(0x1 << 4)
#define ACODEC_ADC_L_SIGNAL_DIS			(0x0 << 4)
#define ACODEC_ADC_R_ALC_MSK			(0x1 << 3)
#define ACODEC_ADC_R_ALC_WORK			(0x1 << 3)
#define ACODEC_ADC_R_ALC_INIT			(0x0 << 3)
#define ACODEC_ADC_R_CLK_MSK			(0x1 << 2)
#define ACODEC_ADC_R_CLK_WORK			(0x1 << 2)
#define ACODEC_ADC_R_CLK_RST			(0x0 << 2)
#define ACODEC_ADC_R_WORK			(0x1 << 1)
#define ACODEC_ADC_R_INIT			(0x0 << 1)
#define ACODEC_ADC_R_SIGNAL_EN			(0x1 << 0)
#define ACODEC_ADC_R_SIGNAL_DIS			(0x0 << 0)

/* ACODEC_DAC_ANA_CTL0 */
#define ACODEC_DAC_IBIAS_MSK			(0x1 << 7)
#define ACODEC_DAC_IBIAS_EN			(0x1 << 7)
#define ACODEC_DAC_IBIAS_DIS			(0x0 << 7)
#define ACODEC_DAC_L_REF_VOL_BUF_MSK		(0x1 << 6)
#define ACODEC_DAC_L_REF_VOL_BUF_EN		(0x1 << 6)
#define ACODEC_DAC_L_REF_VOL_BUF_DIS		(0x0 << 6)
#define ACODEC_DAC_L_REF_POP_SOUND_MSK		(0x3 << 4)
#define ACODEC_DAC_L_REF_POP_SOUND_WORK		(0x2 << 4)
#define ACODEC_DAC_L_REF_POP_SOUND_INIT		(0x1 << 4)
#define ACODEC_DAC_L_REF_POP_SOUND_DIS		(0x0 << 4)
#define ACODEC_DAC_L_REF_VOL_MSK		(0x1 << 3)
#define ACODEC_DAC_L_REF_VOL_EN			(0x1 << 3)
#define ACODEC_DAC_L_REF_VOL_DIS		(0x0 << 3)
#define ACODEC_DAC_L_CLK_MSK			(0x1 << 2)
#define ACODEC_DAC_L_CLK_EN			(0x1 << 2)
#define ACODEC_DAC_L_CLK_DIS			(0x0 << 2)
#define ACODEC_DAC_SRC_SIGNAL_MSK		(0x1 << 1)
#define ACODEC_DAC_SRC_SIGNAL_EN		(0x1 << 1)
#define ACODEC_DAC_SRC_SIGNAL_DIS		(0x0 << 1)
#define ACODEC_DAC_L_SIGNAL_MSK			(0x1 << 0)
#define ACODEC_DAC_L_SIGNAL_WORK		(0x1 << 0)
#define ACODEC_DAC_L_SIGNAL_INIT		(0x0 << 0)

/* ACODEC_DAC_ANA_CTL1 */
#define ACODEC_DAC_L_LINEOUT_MUTE_MSK		(0x1 << 6)
#define ACODEC_DAC_L_LINEOUT_MUTE		(0x0 << 6)
#define ACODEC_DAC_L_LINEOUT_WORK		(0x1 << 6)
#define ACODEC_DAC_L_LINEOUT_SIGNAL_MSK		(0x1 << 5)
#define ACODEC_DAC_L_LINEOUT_SIGNAL_WORK	(0x1 << 5)
#define ACODEC_DAC_L_LINEOUT_SIGNAL_INIT	(0x0 << 5)
#define ACODEC_DAC_L_LINEOUT_MSK		(0x1 << 4)
#define ACODEC_DAC_L_LINEOUT_EN			(0x1 << 4)
#define ACODEC_DAC_L_LINEOUT_DIS		(0x0 << 4)
#define ACODEC_DAC_DRV_STRENGTH_SFT		0
#define ACODEC_DAC_DRV_STRENGTH_MSK		(0xf << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_20_4		(0x8 << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_22_7		(0x7 << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_25_7		(0x6 << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_29_7		(0x5 << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_35_5		(0x4 << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_44_2		(0x3 << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_60_1		(0x2 << ACODEC_DAC_DRV_STRENGTH_SFT)
#define ACODEC_DAC_DRV_STRENGTH_100		(0x1 << ACODEC_DAC_DRV_STRENGTH_SFT)

/* ACODEC_DAC_ANA_CTL2 */
#define ACODEC_DAC_LINEOUT_GAIN_MAX		0x1e
#define ACODEC_DAC_LINEOUT_GAIN_MIN		0
#define ACODEC_DAC_LINEOUT_GAIN_SFT		0
#define ACODEC_DAC_LINEOUT_GAIN_MSK		(0x1f << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_PDB_6_0		(0x1f << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_PDB_6		(0x1e << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_PDB_4_5		(0x1d << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_PDB_3		(0x1c << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_PDB_1_5		(0x1b << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_0DB		(0x1a << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_1_5		(0x19 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_3		(0x18 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_4_5		(0x17 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_6		(0x16 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_7_5		(0x15 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_9		(0x14 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_10_5	(0x13 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_12		(0x12 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_13_5	(0x11 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_15		(0x10 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_16_5	(0x0f << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_18		(0x0e << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_19_5	(0x0d << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_21		(0x0c << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_22_5	(0x0b << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_24		(0x0a << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_25_5	(0x09 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_27		(0x08 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_28_5	(0x07 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_30		(0x06 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_31_5	(0x05 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_33		(0x04 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_34_5	(0x03 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_36		(0x02 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_37_5	(0x01 << ACODEC_DAC_LINEOUT_GAIN_SFT)
#define ACODEC_DAC_LINEOUT_GAIN_NDB_39		(0x00 << ACODEC_DAC_LINEOUT_GAIN_SFT)

/* ACODEC_DAC_HPMIX_CTL */
#define ACODEC_DAC_HPMIX_MSK                    (0x1 << 7)
#define ACODEC_DAC_HPMIX_EN                     (0x1 << 7)
#define ACODEC_DAC_HPMIX_DIS                    (0x0 << 7)
#define ACODEC_DAC_HPMIX_GAIN_SFT		5
#define ACODEC_DAC_HPMIX_GAIN_MAX		2
#define ACODEC_DAC_HPMIX_GAIN_MIN		1
#define ACODEC_DAC_HPMIX_GAIN_MSK		(0x3 << ACODEC_DAC_HPMIX_GAIN_SFT)
#define ACODEC_DAC_HPMIX_GAIN_6DB		(0x2 << ACODEC_DAC_HPMIX_GAIN_SFT)
#define ACODEC_DAC_HPMIX_GAIN_0DB		(0x1 << ACODEC_DAC_HPMIX_GAIN_SFT)
#define ACODEC_DAC_HPMIX_MDL_MSK		(0x1 << 4)
#define ACODEC_DAC_HPMIX_MDL_WORK		(0x1 << 4)
#define ACODEC_DAC_HPMIX_MDL_INIT		(0x0 << 4)
#define ACODEC_DAC_HPMIX_MUTE_MSK		(0x1 << 3)
#define ACODEC_DAC_HPMIX_WORK                   (0x1 << 3)
#define ACODEC_DAC_HPMIX_MUTE                   (0x0 << 3)
#define ACODEC_DAC_HPMIX_SEL_SFT		0
#define ACODEC_DAC_HPMIX_SEL_MSK		(0x7 << ACODEC_DAC_HPMIX_SEL_SFT)
#define ACODEC_DAC_HPMIX_ADCR                   (0x4 << ACODEC_DAC_HPMIX_SEL_SFT)
#define ACODEC_DAC_HPMIX_ADCL                   (0x2 << ACODEC_DAC_HPMIX_SEL_SFT)
#define ACODEC_DAC_HPMIX_I2S                    (0x1 << ACODEC_DAC_HPMIX_SEL_SFT)

/* ACODEC_ADC_PGA_AGC_L_CTL0 */
#define ACODEC_GAIN_ATTACK_MSK			(1 << 6)
#define ACODEC_GAIN_ATTACK_JACK			(1 << 6)
#define ACODEC_GAIN_ATTACK_NORMAL		(0 << 6)
#define ACODEC_CTRL_GEN_SFT			4
#define ACODEC_CTRL_GEN_MSK			(0x3 << ACODEC_ALC_CTRL_GEN_SFT)
#define ACODEC_CTRL_GEN_JACK3			(0x3 << ACODEC_ALC_CTRL_GEN_SFT)
#define ACODEC_CTRL_GEN_JACK2			(0x2 << ACODEC_ALC_CTRL_GEN_SFT)
#define ACODEC_CTRL_GEN_JACK1			(0x1 << ACODEC_ALC_CTRL_GEN_SFT)
#define ACODEC_CTRL_GEN_NORMAL			(0x0 << ACODEC_ALC_CTRL_GEN_SFT)
#define ACODEC_AGC_HOLD_TIME_SFT		0
#define ACODEC_AGC_HOLD_TIME_MSK		(0xf << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_1S			(0xa << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_512MS		(0x9 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_256MS		(0x8 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_128MS		(0x7 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_64MS		(0x6 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_32MS		(0x5 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_16MS		(0x4 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_8MS		(0x3 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_4MS		(0x2 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_2MS		(0x1 << ACODEC_AGC_HOLD_TIME_SFT)
#define ACODEC_AGC_HOLD_TIME_0MS		(0x0 << ACODEC_AGC_HOLD_TIME_SFT)

/* ACODEC_ADC_PGA_AGC_L_CTL1 */
#define ACODEC_AGC_DECAY_TIME_SFT		4
/* Normal mode (reg_agc_mode = 0) */
#define ACODEC_AGC_DECAY_NORMAL_MSK		(0xf << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_512MS		(0xa << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_256MS		(0x9 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_128MS		(0x8 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_64MS		(0x7 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_32MS		(0x6 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_16MS		(0x5 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_8MS		(0x4 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_4MS		(0x3 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_2MS		(0x2 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_1MS		(0x1 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_NORMAL_0MS		(0x0 << ACODEC_AGC_DECAY_TIME_SFT)
/* Limiter mode (reg_agc_mode = 1) */
#define ACODEC_AGC_DECAY_LIMITER_MSK		(0xf << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_128MS		(0xa << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_64MS		(0x9 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_32MS		(0x8 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_16MS		(0x7 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_8MS		(0x6 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_4MS		(0x5 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_2MS		(0x4 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_1MS		(0x3 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_500US		(0x2 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_250US		(0x1 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_DECAY_LIMITER_125US		(0x0 << ACODEC_AGC_DECAY_TIME_SFT)
#define ACODEC_AGC_ATTACK_TIME_SFT		0
/* Normal mode (reg_agc_mode = 0) */
#define ACODEC_AGC_ATTACK_NORMAL_MSK		(0xf << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_128MS		(0xa << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_64MS		(0x9 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_32MS		(0x8 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_16MS		(0x7 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_8MS		(0x6 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_4MS		(0x5 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_2MS		(0x4 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_1MS		(0x3 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_500US		(0x2 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_250US		(0x1 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_NORMAL_125US		(0x0 << ACODEC_AGC_ATTACK_TIME_SFT)
/* Limiter mode (reg_agc_mode = 1) */
#define ACODEC_AGC_ATTACK_LIMITER_MSK		(0xf << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_32MS		(0xa << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_16MS		(0x9 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_8MS		(0x8 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_4MS		(0x7 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_2MS		(0x6 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_1MS		(0x5 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_500US		(0x4 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_250US		(0x3 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_125US		(0x2 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_64US		(0x1 << ACODEC_AGC_ATTACK_TIME_SFT)
#define ACODEC_AGC_ATTACK_LIMITER_32US		(0x0 << ACODEC_AGC_ATTACK_TIME_SFT)

/* ACODEC_ADC_PGA_AGC_L_CTL2 */
#define ACODEC_AGC_MODE_LIMITER			(0x1 << 7)
#define ACODEC_AGC_MODE_NORMAL			(0x0 << 7)
#define ACODEC_AGC_ZERO_CRO_EN			(0x1 << 6)
#define ACODEC_AGC_ZERO_CRO_DIS			(0x0 << 6)
#define ACODEC_AGC_AMP_RECOVER_GAIN		(0x1 << 5)
#define ACODEC_AGC_AMP_RECOVER_LVOL		(0x0 << 5)
#define ACODEC_AGC_FAST_DEC_EN			(0x1 << 4)
#define ACODEC_AGC_FAST_DEC_DIS			(0x0 << 4)
#define ACODEC_AGC_NOISE_GATE_EN		(0x1 << 3)
#define ACODEC_AGC_NOISE_GATE_DIS		(0x0 << 3)
#define ACODEC_AGC_NOISE_GATE_THRESH_SFT	0
#define ACODEC_AGC_NOISE_GATE_THRESH_MSK	(0x7 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N81DB	(0x7 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N75DB	(0x6 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N69DB	(0x5 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N63DB	(0x4 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N57DB	(0x3 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N51DB	(0x2 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N45DB	(0x1 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)
#define ACODEC_AGC_NOISE_GATE_THRESH_N39DB	(0x0 << ACODEC_AGC_NOISE_GATE_THRESH_SFT)

/* ACODEC_ADC_PGA_AGC_L_CTL3 */
#define ACODEC_AGC_PGA_ZERO_CRO_EN		(0x1 << 5)
#define ACODEC_AGC_PGA_ZERO_CRO_DIS		(0x0 << 5)
#define ACODEC_AGC_PGA_GAIN_MAX			0x1f
#define ACODEC_AGC_PGA_GAIN_MIN			0
#define ACODEC_AGC_PGA_GAIN_SFT			0
#define ACODEC_AGC_PGA_GAIN_MSK			(0x1f << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_28_5		(0x1f << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_27		(0x1e << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_25_5		(0x1d << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_24		(0x1c << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_22_5		(0x1b << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_21		(0x1a << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_19_5		(0x19 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_18		(0x18 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_16_5		(0x17 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_15		(0x16 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_13_5		(0x15 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_12		(0x14 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_10_5		(0x13 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_9		(0x12 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_7_5		(0x11 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_6		(0x10 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_4_5		(0x0f << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_3		(0x0e << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_PDB_1_5		(0x0d << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_0DB			(0x0c << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_1_5		(0x0b << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_3		(0x0a << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_4_5		(0x09 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_6		(0x08 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_7_5		(0x07 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_9		(0x06 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_10_5		(0x05 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_12		(0x04 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_13_5		(0x03 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_15		(0x02 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_16_5		(0x01 << ACODEC_AGC_PGA_GAIN_SFT)
#define ACODEC_AGC_PGA_GAIN_NDB_18		(0x00 << ACODEC_AGC_PGA_GAIN_SFT)

/* ACODEC_ADC_PGA_AGC_L_CTL4 */
#define ACODEC_AGC_SLOW_CLK_EN			(0x1 << 3)
#define ACODEC_AGC_SLOW_CLK_DIS			(0x0 << 3)
#define ACODEC_AGC_APPROX_RATE_SFT		0
#define ACODEC_AGC_APPROX_RATE_MSK		(0x7 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_8K		(0x7 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_12K		(0x6 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_16K		(0x5 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_24K		(0x4 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_32K		(0x3 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_44_1K		(0x2 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_48K		(0x1 << ACODEC_AGC_APPROX_RATE_SFT)
#define ACODEC_AGC_APPROX_RATE_96K		(0x0 << ACODEC_AGC_APPROX_RATE_SFT)

/* ACODEC_ADC_PGA_AGC_L_CTL5 */
#define ACODEC_AGC_LO_8BITS_AGC_MAX_MSK		0xff

/* ACODEC_ADC_PGA_AGC_L_CTL6 */
#define ACODEC_AGC_HI_8BITS_AGC_MAX_MSK		0xff

/* ACODEC_ADC_PGA_AGC_L_CTL7 */
#define ACODEC_AGC_LO_8BITS_AGC_MIN_MSK		0xff

/* ACODEC_ADC_PGA_AGC_L_CTL8 */
#define ACODEC_AGC_HI_8BITS_AGC_MIN_MSK		0xff

/* ACODEC_ADC_PGA_AGC_L_CTL9 */
#define ACODEC_AGC_FUNC_SEL_MSK			(0x1 << 6)
#define ACODEC_AGC_FUNC_SEL_EN			(0x1 << 6)
#define ACODEC_AGC_FUNC_SEL_DIS			(0x0 << 6)
#define ACODEC_AGC_MAX_GAIN_PGA_MAX		0x7
#define ACODEC_AGC_MAX_GAIN_PGA_MIN		0
#define ACODEC_AGC_MAX_GAIN_PGA_SFT		3
#define ACODEC_AGC_MAX_GAIN_PGA_MSK		(0x7 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_PDB_28_5	(0x7 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_PDB_22_5	(0x6 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_PDB_16_5	(0x5 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_PDB_10_5	(0x4 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_PDB_4_5		(0x3 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_NDB_1_5		(0x2 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_NDB_7_5		(0x1 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MAX_GAIN_PGA_NDB_13_5	(0x0 << ACODEC_AGC_MAX_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_MAX		0x7
#define ACODEC_AGC_MIN_GAIN_PGA_MIN		0
#define ACODEC_AGC_MIN_GAIN_PGA_SFT		0
#define ACODEC_AGC_MIN_GAIN_PGA_MSK		(0x7 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_PDB_24		(0x7 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_PDB_18		(0x6 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_PDB_12		(0x5 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_PDB_6		(0x4 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_0DB		(0x3 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_NDB_6		(0x2 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_NDB_12		(0x1 << ACODEC_AGC_MIN_GAIN_PGA_SFT)
#define ACODEC_AGC_MIN_GAIN_PGA_NDB_18		(0x0 << ACODEC_AGC_MIN_GAIN_PGA_SFT)

#define ACODEC_HIFI				0x0

#endif /* __RV1106_CODEC_H__ */
