/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * rk730.h -- RK730 ALSA SoC Audio driver
 *
 * Copyright (C) 2022 Rockchip Electronics Co.,Ltd
 */

#ifndef _RK730_H
#define _RK730_H

/* RK730 Analog Registers Definition */
#define RK730_HK_TOP_0				0x00
#define RK730_HK_TOP_1				0x01
#define RK730_HK_TOP_2				0x02
#define RK730_HK_TRIM_0				0x03
#define RK730_HK_TRIM_1				0x04
#define RK730_ADC_0				0x05
#define RK730_ADC_1				0x06
#define RK730_ADC_2				0x07
#define RK730_DAC_0				0x08
#define RK730_DAC_1				0x09
#define RK730_DAC_2				0x0a
#define RK730_MIC_BOOST_0			0x0b
#define RK730_MIC_BOOST_1			0x0c
#define RK730_MIC_BOOST_2			0x0d
#define RK730_MIC_BOOST_3			0x0e
#define RK730_ADC_PGA_BLOCK_0			0x0f
#define RK730_ADC_PGA_BLOCK_1			0x10
#define RK730_SYSPLL_0				0x11
#define RK730_SYSPLL_1				0x12
#define RK730_SYSPLL_2				0x13
#define RK730_SYSPLL_3				0x14
#define RK730_SYSPLL_LOOP_0			0x15
#define RK730_SYSPLL_LOOP_1			0x16
#define RK730_SYSPLL_LOOP_2			0x17
#define RK730_SYSPLL_LOOP_3			0x18
#define RK730_SYSPLL_RVCO_0			0x19
#define RK730_SYSPLL_RVCO_1			0x1a
#define RK730_SYSPLL_RVCO_2			0x1b
#define RK730_SYSPLL_RVCO_3			0x1c
#define RK730_SYSPLL_FRACT_0			0x1d
#define RK730_SYSPLL_FRACT_1			0x1e
#define RK730_SYSPLL_FRACT_2			0x1f
#define RK730_LDO				0x20
#define RK730_MIC_BIAS				0x21
#define RK730_MUXER_0				0x22
#define RK730_MUXER_1				0x23
#define RK730_MIXER_0				0x24
#define RK730_MIXER_1				0x25
#define RK730_MIXER_2				0x26
#define RK730_CHARGE_PUMP			0x27
#define RK730_HP_0				0x28
#define RK730_HP_1				0x29
#define RK730_LINEOUT_0				0x2a
#define RK730_LINEOUT_1				0x2b

/* RK730 Digital Registers Definition */
#define RK730_DTOP_VUCTL			0x40
#define RK730_DTOP_VUCTIME			0x41
#define RK730_DTOP_LPT_SRST			0x42
#define RK730_DTOP_DIGEN_CLKE			0x43
#define RK730_DADC_VOLL				0x44
#define RK730_DADC_VOLR				0x45
#define RK730_DADC_SR_ACL			0x46
#define RK730_DADC_PR_0				0x47
#define RK730_DADC_PR_1				0x48
#define RK730_DADC_PR_2				0x49
#define RK730_DADC_PR_3				0x4a
#define RK730_DADC_NG_0				0x4b
#define RK730_DADC_NG_1				0x4c
#define RK730_DADC_NG_2				0x4d
#define RK730_DADC_NG_3				0x4e
#define RK730_DADC_CICCOMP			0x4f
#define RK730_DADC_HPF				0x50
#define RK730_DADC_RVOLL			0x51
#define RK730_DADC_RVOLR			0x52
#define RK730_DMIC_LMT_1			0x53
#define RK730_DMIC_LMT_2			0x54
#define RK730_DMIC_NG_1				0x55
#define RK730_DMIC_NG_2				0x56
#define RK730_DDAC_POPD_DACST			0x57
#define RK730_DDAC_VOLL				0x58
#define RK730_DDAC_VOLR				0x59
#define RK730_DDAC_SR_LMT			0x5a
#define RK730_DDAC_PR_0				0x5b
#define RK730_DDAC_PR_1				0x5c
#define RK730_DDAC_PR_2				0x5d
#define RK730_DDAC_PR_3				0x5e
#define RK730_DDAC_NG_0				0x5f
#define RK730_DDAC_NG_1				0x60
#define RK730_DDAC_NG_2				0x61
#define RK730_DDAC_NG_3				0x62
#define RK730_DDAC_MUTE_MIXCTL			0x63
#define RK730_DDAC_RVOLL			0x64
#define RK730_DDAC_RVOLR			0x65
#define RK730_DI2S_CKM				0x66
#define RK730_DI2S_RSD				0x67
#define RK730_DI2S_RXCR_1			0x68
#define RK730_DI2S_RXCR_2			0x69
#define RK730_DI2S_RXCMD_TSD			0x6a
#define RK730_DI2S_TXCR_1			0x6b
#define RK730_DI2S_TXCR_2			0x6c
#define RK730_DI2S_TXCR_3_TXCMD			0x6d
#define RK730_DAC_ATTN				0x6e

/* RK730_HK_TOP_1 */
#define RK730_HK_TOP_1_DAC_REF_BUF_CHOP_MASK	GENMASK(7, 6)
#define RK730_HK_TOP_1_DAC_REF_BUF_CHOP(x)	((x) << 6)
#define RK730_HK_TOP_1_IBIAS_STD_SEL_MASK	GENMASK(5, 4)
#define RK730_HK_TOP_1_IBIAS_STD_SEL_27_5UA	(3 << 4)
#define RK730_HK_TOP_1_IBIAS_STD_SEL_23_5UA	(2 << 4)
#define RK730_HK_TOP_1_IBIAS_STD_SEL_20UA	(1 << 4)
#define RK730_HK_TOP_1_IBIAS_STD_SEL_16_5UA	(0 << 4)
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_MASK	GENMASK(3, 0)
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_200	8
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_143	9
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_120	10
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_100	0
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_71_5	1
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_62_5	2
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_50	3
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_38_2	6
#define RK730_HK_TOP_1_IBIAS_GAIN_SEL_32	7

/* RK730_ADC_0 */
#define RK730_ADC_0_DEM_EN_MASK			BIT(3)
#define RK730_ADC_0_DEM_EN			BIT(3)
#define RK730_ADC_0_DEM_DIS			0

/* RK730_MIC_BOOST_3 */
#define RK730_MIC_BOOST_3_MIC_CHOP_MASK		GENMASK(7, 6)
#define RK730_MIC_BOOST_3_MIC_CHOP(x)		((x) << 6)

/* RK730_ADC_PGA_BLOCK_1 */
#define RK730_ADC_PGA_BLOCK_1_PGA_CHOP_MASK	GENMASK(7, 6)
#define RK730_ADC_PGA_BLOCK_1_PGA_CHOP(x)	((x) << 6)

/* RK730_MIC_BIAS */
#define RK730_MIC_BIAS_VOLT_MASK		GENMASK(3, 2)
#define RK730_MIC_BIAS_VOLT_2_8V		(3 << 2)
#define RK730_MIC_BIAS_VOLT_2_5V		(2 << 2)
#define RK730_MIC_BIAS_VOLT_2_2V		(1 << 2)
#define RK730_MIC_BIAS_VOLT_2_0V		(0 << 2)

/* RK730_MUXER_1 */
#define RK730_MUXER_1_MUX_OUT_CHOP_MASK		GENMASK(1, 0)
#define RK730_MUXER_1_MUX_OUT_CHOP(x)		((x) << 0)

/* RK730_MIXER_2 */
#define RK730_MIXER_2_MIX_CHOP_MASK		GENMASK(7, 6)
#define RK730_MIXER_2_MIX_CHOP(x)		((x) << 6)
#define RK730_MIXER_2_MIX_R_MODE_MASK		GENMASK(5, 4)
#define RK730_MIXER_2_MIX_R_MODE(x)		((x) << 4)
#define RK730_MIXER_2_MIX_L_MODE_MASK		GENMASK(2, 1)
#define RK730_MIXER_2_MIX_L_MODE(x)		((x) << 1)

/* RK730_HP_1 */
#define RK730_HP_1_HP_LO_CHOP_MASK		GENMASK(6, 5)
#define RK730_HP_1_HP_LO_CHOP(x)		((x) << 5)

/* RK730_DTOP_DIGEN_CLKE */
#define RK730_DTOP_DIGEN_CLKE_ADC_CKE_MASK	BIT(7)
#define RK730_DTOP_DIGEN_CLKE_ADC_CKE_EN	BIT(7)
#define RK730_DTOP_DIGEN_CLKE_ADC_CKE_DIS	0
#define RK730_DTOP_DIGEN_CLKE_I2STX_CKE_MASK	BIT(6)
#define RK730_DTOP_DIGEN_CLKE_I2STX_CKE_EN	BIT(6)
#define RK730_DTOP_DIGEN_CLKE_I2STX_CKE_DIS	0
#define RK730_DTOP_DIGEN_CLKE_ADC_EN_MASK	BIT(5)
#define RK730_DTOP_DIGEN_CLKE_ADC_EN		BIT(5)
#define RK730_DTOP_DIGEN_CLKE_ADC_DIS		0
#define RK730_DTOP_DIGEN_CLKE_I2STX_EN_MASK	BIT(4)
#define RK730_DTOP_DIGEN_CLKE_I2STX_EN		BIT(4)
#define RK730_DTOP_DIGEN_CLKE_I2STX_DIS		0
#define RK730_DTOP_DIGEN_CLKE_DAC_CKE_MASK	BIT(3)
#define RK730_DTOP_DIGEN_CLKE_DAC_CKE_EN	BIT(3)
#define RK730_DTOP_DIGEN_CLKE_DAC_CKE_DIS	0
#define RK730_DTOP_DIGEN_CLKE_I2SRX_CKE_MASK	BIT(2)
#define RK730_DTOP_DIGEN_CLKE_I2SRX_CKE_EN	BIT(2)
#define RK730_DTOP_DIGEN_CLKE_I2SRX_CKE_DIS	0
#define RK730_DTOP_DIGEN_CLKE_DAC_EN_MASK	BIT(1)
#define RK730_DTOP_DIGEN_CLKE_DAC_EN		BIT(1)
#define RK730_DTOP_DIGEN_CLKE_DAC_DIS		0
#define RK730_DTOP_DIGEN_CLKE_I2SRX_EN_MASK	BIT(0)
#define RK730_DTOP_DIGEN_CLKE_I2SRX_EN		BIT(0)
#define RK730_DTOP_DIGEN_CLKE_I2SRX_DIS		0

/* RK730_DADC_SR_ACL */
#define RK730_DADC_SR_ACL_VOLL_POL_MASK		BIT(5)
#define RK730_DADC_SR_ACL_VOLL_POS		BIT(5)
#define RK730_DADC_SR_ACL_VOLL_NEG		0
#define RK730_DADC_SR_ACL_VOLR_POL_MASK		BIT(4)
#define RK730_DADC_SR_ACL_VOLR_POS		BIT(4)
#define RK730_DADC_SR_ACL_VOLR_NEG		0
#define RK730_DADC_SR_ACL_SRT_MASK		GENMASK(2, 0)
#define RK730_DADC_SR_ACL_SRT(x)		(x)

/* RK730_DDAC_SR_LMT */
#define RK730_DDAC_SR_LMT_VOLL_POL_MASK		BIT(5)
#define RK730_DDAC_SR_LMT_VOLL_POS		BIT(5)
#define RK730_DDAC_SR_LMT_VOLL_NEG		0
#define RK730_DDAC_SR_LMT_VOLR_POL_MASK		BIT(4)
#define RK730_DDAC_SR_LMT_VOLR_POS		BIT(4)
#define RK730_DDAC_SR_LMT_VOLR_NEG		0
#define RK730_DDAC_SR_LMT_SRT_MASK		GENMASK(2, 0)
#define RK730_DDAC_SR_LMT_SRT(x)		(x)

/* RK730_DDAC_MUTE_MIXCTL */
#define RK730_DDAC_MUTE_MIXCTL_MUTE_MASK	BIT(0)
#define RK730_DDAC_MUTE_MIXCTL_MUTE		BIT(0)
#define RK730_DDAC_MUTE_MIXCTL_UNMUTE		0

/* RK730_DI2S_CKM */
#define RK730_DI2S_CKM_SCLK_DIV_MASK		GENMASK(7, 4)
#define RK730_DI2S_CKM_SCLK_DIV(x)		((x - 1) << 4)
#define RK730_DI2S_CKM_SCLK_EN_MASK		BIT(2)
#define RK730_DI2S_CKM_SCLK_EN			BIT(2)
#define RK730_DI2S_CKM_SCLK_DIS			0
#define RK730_DI2S_CKM_SCLK_POL_MASK		BIT(1)
#define RK730_DI2S_CKM_SCLK_INVERTED		BIT(1)
#define RK730_DI2S_CKM_SCLK_NORMAL		0
#define RK730_DI2S_CKM_MST_MASK			BIT(0)
#define RK730_DI2S_CKM_MST_MASTER		BIT(0)
#define RK730_DI2S_CKM_MST_SLAVE		0

/* RK730_DI2S_XCR2 */
#define RK730_DI2S_XCR2_VDW_MASK		GENMASK(4, 0)
#define RK730_DI2S_XCR2_VDW(x)			(x - 1)

/* RK730_DI2S_RXCMD_TSD */
#define RK730_DI2S_RXCMD_TSD_RXS_MASK		BIT(5)
#define RK730_DI2S_RXCMD_TSD_RXS_EN		BIT(5)
#define RK730_DI2S_RXCMD_TSD_RXS_DIS		0

/* RK730_DI2S_TXCR_3_TXCMD */
#define RK730_DI2S_TXCR_3_TXCMD_TXS_MASK	BIT(7)
#define RK730_DI2S_TXCR_3_TXCMD_TXS_EN		BIT(7)
#define RK730_DI2S_TXCR_3_TXCMD_TXS_DIS		0

#endif
