/*
 * rk3308_codec.h -- RK3308 ALSA Soc Audio Driver
 *
 * Copyright (c) 2018, Fuzhou Rockchip Electronics Co., Ltd All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __RK3308_CODEC_H__
#define __RK3308_CODEC_H__

#define ACODEC_RESET_CTL			0x00 /* REG 0x00 */

/* ADC DIGITAL REGISTERS */
#define ACODEC_ADC_I2S_CTL0			0x04 /* REG 0x01 */
#define ACODEC_ADC_I2S_CTL1			0x08 /* REG 0x02 */
#define ACODEC_ADC_BIST_MODE_SEL		0x0c /* REG 0x03 */
#define ACODEC_ADC_HPF_PATH			0x10 /* REG 0x04 */
#define ACODEC_S_ADC_DIG_VOL_CON_L		0x14 /* REG 0x05 */
#define ACODEC_S_ADC_DIG_VOL_CON_R		0x18 /* REG 0x06 */
#define ACODEC_ADC_DATA_PATH			0x1c /* REG 0x07 */
/* Resevred REG 0x08 ~ 0x0f */

/* REG 0x10 ~ 0x1c are used to configure AGC of Left channel (ALC1) */
#define ACODEC_ADC_PGA_AGC_L_CTL0		0x40 /* REG 0x10 */
#define ACODEC_ADC_PGA_AGC_L_CTL1		0x44 /* REG 0x11 */
#define ACODEC_ADC_PGA_AGC_L_CTL2		0x48 /* REG 0x12 */
#define ACODEC_ADC_PGA_AGC_L_CTL3		0x4c /* REG 0x13 */
#define ACODEC_ADC_PGA_AGC_L_CTL4		0x50 /* REG 0x14 */
#define ACODEC_ADC_PGA_AGC_L_LO_MAX		0x54 /* REG 0x15 */
#define ACODEC_ADC_PGA_AGC_L_HI_MAX		0x58 /* REG 0x16 */
#define ACODEC_ADC_PGA_AGC_L_LO_MIN		0x5c /* REG 0x17 */
#define ACODEC_ADC_PGA_AGC_L_HI_MIN		0x60 /* REG 0x18 */
#define ACODEC_ADC_PGA_AGC_L_CTL5		0x64 /* REG 0x19 */
/* Resevred REG 0x1a */
#define ACODEC_S_ADC_PEAK_DET_VALUE_DEC_RATE_L	0x6c /* REG 0x1b */
#define ACODEC_ADC_AGC_L_RO_GAIN		0x70 /* REG 0x1c */

/* REG 0x20 ~ 0x2c are used to configure AGC of Right channel (ALC2) */
#define ACODEC_ADC_PGA_AGC_R_CTL0		0x80 /* REG 0x20 */
#define ACODEC_ADC_PGA_AGC_R_CTL1		0x84 /* REG 0x21 */
#define ACODEC_ADC_PGA_AGC_R_CTL2		0x88 /* REG 0x22 */
#define ACODEC_ADC_PGA_AGC_R_CTL3		0x8c /* REG 0x23 */
#define ACODEC_ADC_PGA_AGC_R_CTL4		0x90 /* REG 0x24 */
#define ACODEC_ADC_PGA_AGC_R_LO_MAX		0x94 /* REG 0x25 */
#define ACODEC_ADC_PGA_AGC_R_HI_MAX		0x98 /* REG 0x26 */
#define ACODEC_ADC_PGA_AGC_R_LO_MIN		0x9c /* REG 0x27 */
#define ACODEC_ADC_PGA_AGC_R_HI_MIN		0xa0 /* REG 0x28 */
#define ACODEC_ADC_PGA_AGC_R_CTL5		0xa4 /* REG 0x29 */
/* Resevred REG 0x2a */
#define ACODEC_S_ADC_PEAK_DET_VALUE_DEC_RATE_R	0xac /* REG 0x2b */
#define ACODEC_ADC_AGC_R_RO_GAIN		0xb0 /* REG 0x2c */

/* DAC DIGITAL REGISTERS */
#define ACODEC_DAC_I2S_CTL0			0x04 /* REG 0x01 */
#define ACODEC_DAC_I2S_CTL1			0x08 /* REG 0x02 */
#define ACODEC_DAC_BIST_MODE_SEL		0x0c /* REG 0x03 */
#define ACODEC_DAC_DIGITAL_GAIN			0x10 /* REG 0x04 */
#define ACODEC_DAC_DATA_SEL			0x14 /* REG 0x05 */
/* Resevred REG 0x06 ~ 0x08 */
#define ACODEC_DAC_DATA_HI			0x28 /* REG 0x0a */
#define ACODEC_DAC_DATA_LO			0x2c /* REG 0x0b */

#define ACODEC_DAC_HPDET_DELAYTIME_HI		0x30 /* REG 0x0c */
#define ACODEC_DAC_HPDET_DELAYTIME_LO		0x34 /* REG 0x0d */
#define ACODEC_DAC_HPDET_STATUS			0x38 /* REG 0x0e, Read-only */

#define ACODEC_S_DAC_DATA_HI			0x24 /* REG 0x09 */
#define ACODEC_S_DAC_DATA_LO			0x28 /* REG 0x0a */
#define ACODEC_S_DAC_HPDET_DELAYTIME_HI		0x2c /* REG 0x0b */
#define ACODEC_S_DAC_HPDET_DELAYTIME_LO		0x30 /* REG 0x0c */
#define ACODEC_S_DAC_HPDET_STATUS		0x34 /* REG 0x0d, Read-only */

/* Resevred REG 0x0f */

/* ADC ANALOG REGISTERS */
#define ACODEC_ADC_ANA_MIC_CTL			0x00 /* REG 0x00 */
#define ACODEC_ADC_ANA_MIC_GAIN			0x04 /* REG 0x01 */
#define ACODEC_ADC_ANA_ALC_CTL			0x08 /* REG 0x02 */
#define ACODEC_ADC_ANA_ALC_GAIN1		0x0c /* REG 0x03 */
#define ACODEC_ADC_ANA_ALC_GAIN2		0x10 /* REG 0x04 */
#define ACODEC_ADC_ANA_CTL0			0x14 /* REG 0x05 */
#define ACODEC_ADC_ANA_CTL1			0x18 /* REG 0x06 */
#define ACODEC_ADC_ANA_CTL2			0x1c /* REG 0x07 */
#define ACODEC_ADC_ANA_CTL3			0x20 /* REG 0x08 */
#define ACODEC_S_ADC_ANA_CTL4			0x24 /* REG 0x09 */
#define ACODEC_ADC_ANA_CTL5			0x28 /* REG 0x0a */
#define ACODEC_ADC_ANA_ALC_PGA			0x2c /* REG 0x0b */
/* Resevred REG 0x0c ~ 0x0f */

/* DAC ANALOG REGISTERS */
#define ACODEC_DAC_ANA_CTL0			0x00 /* REG 0x00 */
#define ACODEC_DAC_ANA_POP_VOLT			0x04 /* REG 0x01 */
#define ACODEC_DAC_ANA_CTL1			0x08 /* REG 0x02 */
#define ACODEC_DAC_ANA_HPOUT			0x0c /* REG 0x03 */
#define ACODEC_DAC_ANA_LINEOUT			0x10 /* REG 0x04 */
#define ACODEC_DAC_ANA_L_HPOUT_GAIN		0x14 /* REG 0x05 */
#define ACODEC_DAC_ANA_R_HPOUT_GAIN		0x18 /* REG 0x06 */
#define ACODEC_DAC_ANA_DRV_HPOUT		0x1c /* REG 0x07 */
#define ACODEC_DAC_ANA_DRV_LINEOUT		0x20 /* REG 0x08 */
/* Resevred REG 0x07 ~ 0x0b */
#define ACODEC_DAC_ANA_HPMIX_CTL0		0x30 /* REG 0x0c */
#define ACODEC_DAC_ANA_HPMIX_CTL1		0x34 /* REG 0x0d */
#define ACODEC_DAC_ANA_LINEOUT_CTL0		0x38 /* REG 0x0e */
#define ACODEC_DAC_ANA_LINEOUT_CTL1		0x3c /* REG 0x0f */

/*
 * These registers are referenced by codec driver
 */

#define RK3308_GLB_CON				ACODEC_RESET_CTL

/* ADC DIGITAL REGISTERS */

/*
 * The ADC group are 0 ~ 3, that control:
 *
 * CH0: left_0(ADC1) and right_0(ADC2)
 * CH1: left_1(ADC3) and right_1(ADC4)
 * CH2: left_2(ADC5) and right_2(ADC6)
 * CH3: left_3(ADC7) and right_3(ADC8)
 */
#define RK3308_ADC_DIG_OFFSET(ch)		((ch & 0x3) * 0xc0 + 0x0)

#define RK3308_ADC_DIG_CON01(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_I2S_CTL0)
#define RK3308_ADC_DIG_CON02(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_I2S_CTL1)
#define RK3308_ADC_DIG_CON03(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_BIST_MODE_SEL)
#define RK3308_ADC_DIG_CON04(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_HPF_PATH)
#define RK3308BS_ADC_DIG_CON05(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_S_ADC_DIG_VOL_CON_L)
#define RK3308BS_ADC_DIG_CON06(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_S_ADC_DIG_VOL_CON_R)
#define RK3308_ADC_DIG_CON07(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_DATA_PATH) /* Removed from S */

#define RK3308_ALC_L_DIG_CON00(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_CTL0)
#define RK3308_ALC_L_DIG_CON01(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_CTL1)
#define RK3308_ALC_L_DIG_CON02(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_CTL2)
#define RK3308_ALC_L_DIG_CON03(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_CTL3)
#define RK3308_ALC_L_DIG_CON04(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_CTL4)
#define RK3308_ALC_L_DIG_CON05(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_LO_MAX)
#define RK3308_ALC_L_DIG_CON06(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_HI_MAX)
#define RK3308_ALC_L_DIG_CON07(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_LO_MIN)
#define RK3308_ALC_L_DIG_CON08(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_HI_MIN)
#define RK3308_ALC_L_DIG_CON09(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_L_CTL5)
#define RK3308BS_ALC_L_DIG_CON11(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_S_ADC_PEAK_DET_VALUE_DEC_RATE_L)
#define RK3308_ALC_L_DIG_CON12(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_AGC_L_RO_GAIN)

#define RK3308_ALC_R_DIG_CON00(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_CTL0)
#define RK3308_ALC_R_DIG_CON01(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_CTL1)
#define RK3308_ALC_R_DIG_CON02(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_CTL2)
#define RK3308_ALC_R_DIG_CON03(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_CTL3)
#define RK3308_ALC_R_DIG_CON04(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_CTL4)
#define RK3308_ALC_R_DIG_CON05(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_LO_MAX)
#define RK3308_ALC_R_DIG_CON06(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_HI_MAX)
#define RK3308_ALC_R_DIG_CON07(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_LO_MIN)
#define RK3308_ALC_R_DIG_CON08(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_HI_MIN)
#define RK3308_ALC_R_DIG_CON09(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_PGA_AGC_R_CTL5)
#define RK3308BS_ALC_R_DIG_CON11(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_S_ADC_PEAK_DET_VALUE_DEC_RATE_R)
#define RK3308_ALC_R_DIG_CON12(ch)		(RK3308_ADC_DIG_OFFSET(ch) + ACODEC_ADC_AGC_R_RO_GAIN)

/* DAC DIGITAL REGISTERS */
#define RK3308_DAC_DIG_OFFSET			0x300

#define RK3308_DAC_DIG_CON01			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_I2S_CTL0)
#define RK3308_DAC_DIG_CON02			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_I2S_CTL1)
#define RK3308_DAC_DIG_CON03			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_BIST_MODE_SEL)
#define RK3308_DAC_DIG_CON04			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_DIGITAL_GAIN)
#define RK3308BS_DAC_DIG_CON04			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_DIGITAL_GAIN)
#define RK3308_DAC_DIG_CON05			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_DATA_SEL)
#define RK3308BS_DAC_DIG_CON05			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_DATA_SEL)

#define RK3308_DAC_DIG_CON10			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_DATA_HI)
#define RK3308_DAC_DIG_CON11			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_DATA_LO)

#define RK3308_DAC_DIG_CON12			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_HPDET_DELAYTIME_HI)
#define RK3308_DAC_DIG_CON13			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_HPDET_DELAYTIME_LO)
#define RK3308_DAC_DIG_CON14			(RK3308_DAC_DIG_OFFSET + ACODEC_DAC_HPDET_STATUS)

#define RK3308BS_DAC_DIG_CON09			(RK3308_DAC_DIG_OFFSET + ACODEC_S_DAC_DATA_HI)
#define RK3308BS_DAC_DIG_CON10			(RK3308_DAC_DIG_OFFSET + ACODEC_S_DAC_DATA_LO)
#define RK3308BS_DAC_DIG_CON11			(RK3308_DAC_DIG_OFFSET + ACODEC_S_DAC_DELAY_TIME_DET_HI)
#define RK3308BS_DAC_DIG_CON12			(RK3308_DAC_DIG_OFFSET + ACODEC_S_DAC_DELAY_TIME_DET_LO)
#define RK3308BS_DAC_DIG_CON13			(RK3308_DAC_DIG_OFFSET + ACODEC_S_DAC_HPDET_STATUS)

#define RK3308_CODEC_HEADPHONE_CON		RK3308_DAC_DIG_CON14
#define RK3308BS_CODEC_HEADPHONE_CON		RK3308BS_DAC_DIG_CON13

/* ADC ANALOG REGISTERS */
/*
 * The ADC group are 0 ~ 3, that control:
 *
 * CH0: left_0(ADC1) and right_0(ADC2)
 * CH1: left_1(ADC3) and right_1(ADC4)
 * CH2: left_2(ADC5) and right_2(ADC6)
 * CH3: left_3(ADC7) and right_3(ADC8)
 */
#define RK3308_ADC_ANA_OFFSET(ch)		(((ch) & 0x3) * 0x40 + 0x340)

#define RK3308_ADC_ANA_CON00(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_MIC_CTL)
#define RK3308_ADC_ANA_CON01(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_MIC_GAIN)
#define RK3308_ADC_ANA_CON02(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_ALC_CTL)
#define RK3308_ADC_ANA_CON03(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_ALC_GAIN1)
#define RK3308_ADC_ANA_CON04(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_ALC_GAIN2)
#define RK3308_ADC_ANA_CON05(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_CTL0)
#define RK3308_ADC_ANA_CON06(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_CTL1)
#define RK3308_ADC_ANA_CON07(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_CTL2)
#define RK3308_ADC_ANA_CON08(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_CTL3)
#define RK3308BS_ADC_ANA_CON09(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_S_ADC_ANA_CTL4)
#define RK3308_ADC_ANA_CON10(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_CTL5)
#define RK3308_ADC_ANA_CON11(ch)		(RK3308_ADC_ANA_OFFSET(ch) + ACODEC_ADC_ANA_ALC_PGA)

/* DAC ANALOG REGISTERS */
#define RK3308_DAC_ANA_OFFSET			0x440
#define RK3308_DAC_ANA_CON00			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_CTL0)
#define RK3308_DAC_ANA_CON01			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_POP_VOLT)
#define RK3308_DAC_ANA_CON02			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_CTL1)
#define RK3308_DAC_ANA_CON03			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_HPOUT)
#define RK3308_DAC_ANA_CON04			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_LINEOUT)
#define RK3308_DAC_ANA_CON05			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_L_HPOUT_GAIN)
#define RK3308_DAC_ANA_CON06			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_R_HPOUT_GAIN)
#define RK3308_DAC_ANA_CON07			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_DRV_HPOUT)
#define RK3308_DAC_ANA_CON08			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_DRV_LINEOUT)
#define RK3308_DAC_ANA_CON12			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_HPMIX_CTL0)
#define RK3308_DAC_ANA_CON13			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_HPMIX_CTL1)
#define RK3308_DAC_ANA_CON14			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_LINEOUT_CTL0)
#define RK3308_DAC_ANA_CON15			(RK3308_DAC_ANA_OFFSET + ACODEC_DAC_ANA_LINEOUT_CTL1)

/*
 * These are the bits for registers
 */

/* RK3308_GLB_CON - REG: 0x0000 */
#define RK3308_ADC_BIST_WORK			(1 << 7)
#define RK3308_ADC_BIST_RESET			(0 << 7)
#define RK3308_DAC_BIST_WORK			(1 << 6)
#define RK3308_DAC_BIST_RESET			(0 << 6)
#define RK3308_ADC_MCLK_MSK			(1 << 5)
#define RK3308_ADC_MCLK_DIS			(1 << 5)
#define RK3308_ADC_MCLK_EN			(0 << 5)
#define RK3308_DAC_MCLK_MSK			(1 << 4)
#define RK3308_DAC_MCLK_DIS			(1 << 4)
#define RK3308_DAC_MCLK_EN			(0 << 4)
#define RK3308_CODEC_RST_MSK			(0x7 << 0)
#define RK3308_ADC_DIG_WORK			(1 << 2)
#define RK3308_ADC_DIG_RESET			(0 << 2)
#define RK3308_DAC_DIG_WORK			(1 << 1)
#define RK3308_DAC_DIG_RESET			(0 << 1)
#define RK3308_SYS_WORK				(1 << 0)
#define RK3308_SYS_RESET			(0 << 0)

/* RK3308_ADC_DIG_CON01 - REG: 0x0004 */
#define RK3308_ADC_I2S_LRC_POL_MSK		(1 << 0)
#define RK3308_ADC_I2S_LRC_POL_REVERSAL		(1 << 0)
#define RK3308_ADC_I2S_LRC_POL_NORMAL		(0 << 0)
#define RK3308_ADC_I2S_VALID_LEN_SFT		5
#define RK3308_ADC_I2S_VALID_LEN_MSK		(0x3 << RK3308_ADC_I2S_VALID_LEN_SFT)
#define RK3308_ADC_I2S_VALID_LEN_32BITS		(0x3 << RK3308_ADC_I2S_VALID_LEN_SFT)
#define RK3308_ADC_I2S_VALID_LEN_24BITS		(0x2 << RK3308_ADC_I2S_VALID_LEN_SFT)
#define RK3308_ADC_I2S_VALID_LEN_20BITS		(0x1 << RK3308_ADC_I2S_VALID_LEN_SFT)
#define RK3308_ADC_I2S_VALID_LEN_16BITS		(0x0 << RK3308_ADC_I2S_VALID_LEN_SFT)
#define RK3308_ADC_I2S_MODE_SFT			3
#define RK3308_ADC_I2S_MODE_MSK			(0x3 << RK3308_ADC_I2S_MODE_SFT)
#define RK3308_ADC_I2S_MODE_PCM			(0x3 << RK3308_ADC_I2S_MODE_SFT)
#define RK3308_ADC_I2S_MODE_I2S			(0x2 << RK3308_ADC_I2S_MODE_SFT)
#define RK3308_ADC_I2S_MODE_LJ			(0x1 << RK3308_ADC_I2S_MODE_SFT)
#define RK3308_ADC_I2S_MODE_RJ			(0x0 << RK3308_ADC_I2S_MODE_SFT)
#define RK3308_ADC_I2S_LR_MSK			(1 << 1)
#define RK3308_ADC_I2S_LR_SWAP			(1 << 1)
#define RK3308_ADC_I2S_LR_NORMAL		(0 << 1)
#define RK3308_ADC_I2S_TYPE_MSK			(1 << 0)
#define RK3308_ADC_I2S_MONO			(1 << 0)
#define RK3308_ADC_I2S_STEREO			(0 << 0)
#define RK3308BS_ADC_I2S_SWAP_SFT		0
#define RK3308BS_ADC_I2S_LR			(0 << RK3308BS_ADC_I2S_SWAP_SFT)
#define RK3308BS_ADC_I2S_LL			(1 << RK3308BS_ADC_I2S_SWAP_SFT)
#define RK3308BS_ADC_I2S_RR			(2 << RK3308BS_ADC_I2S_SWAP_SFT)
#define RK3308BS_ADC_I2S_RL			(3 << RK3308BS_ADC_I2S_SWAP_SFT)

/* RK3308_ADC_DIG_CON02 - REG: 0x0008 */
#define RK3308_ADC_IO_MODE_MSK			(1 << 5)
#define RK3308_ADC_IO_MODE_MASTER		(1 << 5)
#define RK3308_ADC_IO_MODE_SLAVE		(0 << 5)
#define RK3308_ADC_MODE_MSK			(1 << 4)
#define RK3308_ADC_MODE_MASTER			(1 << 4)
#define RK3308_ADC_MODE_SLAVE			(0 << 4)
#define RK3308_ADC_I2S_FRAME_LEN_SFT		2
#define RK3308_ADC_I2S_FRAME_LEN_MSK		(0x3 << RK3308_ADC_I2S_FRAME_LEN_SFT)
#define RK3308_ADC_I2S_FRAME_32BITS		(0x3 << RK3308_ADC_I2S_FRAME_LEN_SFT)
#define RK3308_ADC_I2S_FRAME_24BITS		(0x2 << RK3308_ADC_I2S_FRAME_LEN_SFT)
#define RK3308_ADC_I2S_FRAME_20BITS		(0x1 << RK3308_ADC_I2S_FRAME_LEN_SFT)
#define RK3308_ADC_I2S_FRAME_16BITS		(0x0 << RK3308_ADC_I2S_FRAME_LEN_SFT)
#define RK3308_ADC_I2S_MSK			(0x1 << 1)
#define RK3308_ADC_I2S_WORK			(0x1 << 1)
#define RK3308_ADC_I2S_RESET			(0x0 << 1)
#define RK3308_ADC_I2S_BIT_CLK_POL_MSK		(0x1 << 0)
#define RK3308_ADC_I2S_BIT_CLK_POL_REVERSAL	(0x1 << 0)
#define RK3308_ADC_I2S_BIT_CLK_POL_NORMAL	(0x0 << 0)

/* RK3308_ADC_DIG_CON03 - REG: 0x000c */
#define RK3308_ADC_L_CH_BIST_SFT		2
#define RK3308_ADC_L_CH_BIST_MSK		(0x3 << RK3308_ADC_L_CH_BIST_SFT)
#define RK3308_ADC_L_CH_NORMAL_RIGHT		(0x3 << RK3308_ADC_L_CH_BIST_SFT) /* normal mode */
#define RK3308_ADC_L_CH_BIST_CUBE		(0x2 << RK3308_ADC_L_CH_BIST_SFT)
#define RK3308_ADC_L_CH_BIST_SINE		(0x1 << RK3308_ADC_L_CH_BIST_SFT)
#define RK3308_ADC_L_CH_NORMAL_LEFT		(0x0 << RK3308_ADC_L_CH_BIST_SFT) /* normal mode */
#define RK3308_ADC_R_CH_BIST_SFT		0
#define RK3308_ADC_R_CH_BIST_MSK		(0x3 << RK3308_ADC_R_CH_BIST_SFT)
#define RK3308_ADC_R_CH_NORMAL_LEFT		(0x3 << RK3308_ADC_R_CH_BIST_SFT) /* normal mode */
#define RK3308_ADC_R_CH_BIST_CUBE		(0x2 << RK3308_ADC_R_CH_BIST_SFT)
#define RK3308_ADC_R_CH_BIST_SINE		(0x1 << RK3308_ADC_R_CH_BIST_SFT)
#define RK3308_ADC_R_CH_NORMAL_RIGHT		(0x0 << RK3308_ADC_R_CH_BIST_SFT) /* normal mode */

/* RK3308_ADC_DIG_CON04 - REG: 0x0010 */
#define RK3308_ADC_HPF_PATH_SFT			2
#define RK3308_ADC_HPF_PATH_MSK			(1 << RK3308_ADC_HPF_PATH_SFT)
#define RK3308_ADC_HPF_PATH_DIS			(1 << RK3308_ADC_HPF_PATH_SFT)
#define RK3308_ADC_HPF_PATH_EN			(0 << RK3308_ADC_HPF_PATH_SFT)
#define RK3308_ADC_HPF_CUTOFF_SFT		0
#define RK3308_ADC_HPF_CUTOFF_MSK		(0x3 << RK3308_ADC_HPF_CUTOFF_SFT)
#define RK3308_ADC_HPF_CUTOFF_612HZ		(0x2 << RK3308_ADC_HPF_CUTOFF_SFT)
#define RK3308_ADC_HPF_CUTOFF_245HZ		(0x1 << RK3308_ADC_HPF_CUTOFF_SFT)
#define RK3308_ADC_HPF_CUTOFF_20HZ		(0x0 << RK3308_ADC_HPF_CUTOFF_SFT)

/* RK3308BS_ADC_DIG_CON05 - REG: 0x0014 */
#define RK3308_ADC_DIG_VOL_CON_L_MSK		0xff
#define RK3308_ADC_DIG_VOL_CON_L(x)		((x) & RK3308_ADC_DIG_VOL_CON_L_MSK)
/* RK3308BS_ADC_DIG_CON06 - REG: 0x0018 */
#define RK3308_ADC_DIG_VOL_CON_R_MSK		0xff
#define RK3308_ADC_DIG_VOL_CON_R(x)		((x) & RK3308_ADC_DIG_VOL_CON_R_MSK)
#define RK3308_ADC_DIG_VOL_0DB			0xc2

/* RK3308_ADC_DIG_CON07 - REG: 0x001c */
#define RK3308_ADCL_DATA_SFT			4
#define RK3308_ADCL_DATA(x)			((x) << RK3308_ADCL_DATA_SFT)
#define RK3308_ADCR_DATA_SFT			2
#define RK3308_ADCR_DATA(x)			((x) << RK3308_ADCR_DATA_SFT)
#define RK3308_ADCL_DATA_SEL_ADCL		(0x1 << 1)
#define RK3308_ADCL_DATA_SEL_NORMAL		(0x0 << 1)
#define RK3308_ADCR_DATA_SEL_ADCR		(0x1 << 0)
#define RK3308_ADCR_DATA_SEL_NORMAL		(0x0 << 0)

/*
 * RK3308_ALC_L_DIG_CON00 - REG: 0x0040 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON00 - REG: 0x0080 + ch * 0xc0
 */
#define RK3308_GAIN_ATTACK_JACK			(0x1 << 6)
#define RK3308_GAIN_ATTACK_NORMAL		(0x0 << 6)
#define RK3308_CTRL_GEN_SFT			4
#define RK3308_CTRL_GEN_MSK			(0x3 << RK3308_ALC_CTRL_GEN_SFT)
#define RK3308_CTRL_GEN_JACK3			(0x3 << RK3308_ALC_CTRL_GEN_SFT)
#define RK3308_CTRL_GEN_JACK2			(0x2 << RK3308_ALC_CTRL_GEN_SFT)
#define RK3308_CTRL_GEN_JACK1			(0x1 << RK3308_ALC_CTRL_GEN_SFT)
#define RK3308_CTRL_GEN_NORMAL			(0x0 << RK3308_ALC_CTRL_GEN_SFT)
#define RK3308_AGC_HOLD_TIME_SFT		0
#define RK3308_AGC_HOLD_TIME_MSK		(0xf << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_1S			(0xa << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_512MS		(0x9 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_256MS		(0x8 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_128MS		(0x7 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_64MS		(0x6 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_32MS		(0x5 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_16MS		(0x4 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_8MS		(0x3 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_4MS		(0x2 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_2MS		(0x1 << RK3308_AGC_HOLD_TIME_SFT)
#define RK3308_AGC_HOLD_TIME_0MS		(0x0 << RK3308_AGC_HOLD_TIME_SFT)

/*
 * RK3308_ALC_L_DIG_CON01 - REG: 0x0044 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON01 - REG: 0x0084 + ch * 0xc0
 */
#define RK3308_AGC_DECAY_TIME_SFT		4
/* Normal mode (reg_agc_mode = 0) */
#define RK3308_AGC_DECAY_NORMAL_MSK		(0xf << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_512MS		(0xa << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_256MS		(0x9 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_128MS		(0x8 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_64MS		(0x7 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_32MS		(0x6 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_16MS		(0x5 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_8MS		(0x4 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_4MS		(0x3 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_2MS		(0x2 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_1MS		(0x1 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_NORMAL_0MS		(0x0 << RK3308_AGC_DECAY_TIME_SFT)
/* Limiter mode (reg_agc_mode = 1) */
#define RK3308_AGC_DECAY_LIMITER_MSK		(0xf << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_128MS		(0xa << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_64MS		(0x9 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_32MS		(0x8 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_16MS		(0x7 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_8MS		(0x6 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_4MS		(0x5 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_2MS		(0x4 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_1MS		(0x3 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_500US		(0x2 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_250US		(0x1 << RK3308_AGC_DECAY_TIME_SFT)
#define RK3308_AGC_DECAY_LIMITER_125US		(0x0 << RK3308_AGC_DECAY_TIME_SFT)

#define RK3308_AGC_ATTACK_TIME_SFT		0
/* Normal mode (reg_agc_mode = 0) */
#define RK3308_AGC_ATTACK_NORMAL_MSK		(0xf << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_128MS		(0xa << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_64MS		(0x9 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_32MS		(0x8 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_16MS		(0x7 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_8MS		(0x6 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_4MS		(0x5 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_2MS		(0x4 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_1MS		(0x3 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_500US		(0x2 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_250US		(0x1 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_NORMAL_125US		(0x0 << RK3308_AGC_ATTACK_TIME_SFT)
/* Limiter mode (reg_agc_mode = 1) */
#define RK3308_AGC_ATTACK_LIMITER_MSK		(0xf << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_32MS		(0xa << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_16MS		(0x9 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_8MS		(0x8 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_4MS		(0x7 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_2MS		(0x6 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_1MS		(0x5 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_500US		(0x4 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_250US		(0x3 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_125US		(0x2 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_64US		(0x1 << RK3308_AGC_ATTACK_TIME_SFT)
#define RK3308_AGC_ATTACK_LIMITER_32US		(0x0 << RK3308_AGC_ATTACK_TIME_SFT)

/*
 * RK3308_ALC_L_DIG_CON02 - REG: 0x0048 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON02 - REG: 0x0088 + ch * 0xc0
 */
#define RK3308_AGC_MODE_LIMITER			(0x1 << 7)
#define RK3308_AGC_MODE_NORMAL			(0x0 << 7)
#define RK3308_AGC_ZERO_CRO_EN			(0x1 << 6)
#define RK3308_AGC_ZERO_CRO_DIS			(0x0 << 6)
#define RK3308_AGC_AMP_RECOVER_GAIN		(0x1 << 5)
#define RK3308_AGC_AMP_RECOVER_LVOL		(0x0 << 5)
#define RK3308_AGC_FAST_DEC_EN			(0x1 << 4)
#define RK3308_AGC_FAST_DEC_DIS			(0x0 << 4)
#define RK3308_AGC_NOISE_GATE_EN		(0x1 << 3)
#define RK3308_AGC_NOISE_GATE_DIS		(0x0 << 3)
#define RK3308_AGC_NOISE_GATE_THRESH_SFT	0
#define RK3308_AGC_NOISE_GATE_THRESH_MSK	(0x7 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N81DB	(0x7 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N75DB	(0x6 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N69DB	(0x5 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N63DB	(0x4 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N57DB	(0x3 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N51DB	(0x2 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N45DB	(0x1 << RK3308_AGC_NOISE_GATE_THRESH_SFT)
#define RK3308_AGC_NOISE_GATE_THRESH_N39DB	(0x0 << RK3308_AGC_NOISE_GATE_THRESH_SFT)

/*
 * RK3308_ALC_L_DIG_CON03 - REG: 0x004c + ch * 0xc0
 * RK3308_ALC_R_DIG_CON03 - REG: 0x008c + ch * 0xc0
 */
#define RK3308_AGC_PGA_ZERO_CRO_EN		(0x1 << 5)
#define RK3308_AGC_PGA_ZERO_CRO_DIS		(0x0 << 5)
#define RK3308_AGC_PGA_GAIN_MAX			0x1f
#define RK3308_AGC_PGA_GAIN_MIN			0
#define RK3308_AGC_PGA_GAIN_SFT			0
#define RK3308_AGC_PGA_GAIN_MSK			(0x1f << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_28_5		(0x1f << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_27		(0x1e << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_25_5		(0x1d << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_24		(0x1c << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_22_5		(0x1b << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_21		(0x1a << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_19_5		(0x19 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_18		(0x18 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_16_5		(0x17 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_15		(0x16 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_13_5		(0x15 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_12		(0x14 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_10_5		(0x13 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_9		(0x12 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_7_5		(0x11 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_6		(0x10 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_4_5		(0x0f << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_3		(0x0e << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_PDB_1_5		(0x0d << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_0DB			(0x0c << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_1_5		(0x0b << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_3		(0x0a << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_4_5		(0x09 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_6		(0x08 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_7_5		(0x07 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_9		(0x06 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_10_5		(0x05 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_12		(0x04 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_13_5		(0x03 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_15		(0x02 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_16_5		(0x01 << RK3308_AGC_PGA_GAIN_SFT)
#define RK3308_AGC_PGA_GAIN_NDB_18		(0x00 << RK3308_AGC_PGA_GAIN_SFT)

/*
 * RK3308_ALC_L_DIG_CON04 - REG: 0x0050 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON04 - REG: 0x0090 + ch * 0xc0
 */
#define RK3308_AGC_SLOW_CLK_EN			(0x1 << 3)
#define RK3308_AGC_SLOW_CLK_DIS			(0x0 << 3)
#define RK3308_AGC_APPROX_RATE_SFT		0
#define RK3308_AGC_APPROX_RATE_MSK		(0x7 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_8K		(0x7 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_12K		(0x6 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_16K		(0x5 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_24K		(0x4 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_32K		(0x3 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_44_1K		(0x2 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_48K		(0x1 << RK3308_AGC_APPROX_RATE_SFT)
#define RK3308_AGC_APPROX_RATE_96K		(0x0 << RK3308_AGC_APPROX_RATE_SFT)

/*
 * RK3308_ALC_L_DIG_CON05 - REG: 0x0054 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON05 - REG: 0x0094 + ch * 0xc0
 */
#define RK3308_AGC_LO_8BITS_AGC_MAX_MSK		0xff

/*
 * RK3308_ALC_L_DIG_CON06 - REG: 0x0058 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON06 - REG: 0x0098 + ch * 0xc0
 */
#define RK3308_AGC_HI_8BITS_AGC_MAX_MSK		0xff

/*
 * RK3308_ALC_L_DIG_CON07 - REG: 0x005c + ch * 0xc0
 * RK3308_ALC_R_DIG_CON07 - REG: 0x009c + ch * 0xc0
 */
#define RK3308_AGC_LO_8BITS_AGC_MIN_MSK		0xff

/*
 * RK3308_ALC_L_DIG_CON08 - REG: 0x0060 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON08 - REG: 0x00a0 + ch * 0xc0
 */
#define RK3308_AGC_HI_8BITS_AGC_MIN_MSK		0xff

/*
 * RK3308_ALC_L_DIG_CON09 - REG: 0x0064 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON09 - REG: 0x00a4 + ch * 0xc0
 */
#define RK3308_AGC_FUNC_SEL_MSK			(0x1 << 6)
#define RK3308_AGC_FUNC_SEL_EN			(0x1 << 6)
#define RK3308_AGC_FUNC_SEL_DIS			(0x0 << 6)
#define RK3308_AGC_MAX_GAIN_PGA_MAX		0x7
#define RK3308_AGC_MAX_GAIN_PGA_MIN		0
#define RK3308_AGC_MAX_GAIN_PGA_SFT		3
#define RK3308_AGC_MAX_GAIN_PGA_MSK		(0x7 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_PDB_28_5	(0x7 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_PDB_22_5	(0x6 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_PDB_16_5	(0x5 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_PDB_10_5	(0x4 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_PDB_4_5		(0x3 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_NDB_1_5		(0x2 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_NDB_7_5		(0x1 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MAX_GAIN_PGA_NDB_13_5	(0x0 << RK3308_AGC_MAX_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_MAX		0x7
#define RK3308_AGC_MIN_GAIN_PGA_MIN		0
#define RK3308_AGC_MIN_GAIN_PGA_SFT		0
#define RK3308_AGC_MIN_GAIN_PGA_MSK		(0x7 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_PDB_24		(0x7 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_PDB_18		(0x6 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_PDB_12		(0x5 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_PDB_6		(0x4 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_0DB		(0x3 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_NDB_6		(0x2 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_NDB_12		(0x1 << RK3308_AGC_MIN_GAIN_PGA_SFT)
#define RK3308_AGC_MIN_GAIN_PGA_NDB_18		(0x0 << RK3308_AGC_MIN_GAIN_PGA_SFT)

/*
 * RK3308BS_ALC_L_DIG_CON11 - REG: 0x006c + ch * 0xc0
 * RK3308BS_ALC_R_DIG_CON11 - REG: 0x00ac + ch * 0xc0
 */
#define ACODEC_S_ADC_PEAK_DET_VALUE_DEC_RATE(x)	((x) & 0x1f)

/*
 * RK3308_ALC_L_DIG_CON12 - REG: 0x0070 + ch * 0xc0
 * RK3308_ALC_R_DIG_CON12 - REG: 0x00b0 + ch * 0xc0
 */
#define RK3308_AGC_GAIN_MSK			0x1f

/*
 * RK3308BS_ALC_L_DIG_CON12 - REG: 0x0070 + ch * 0xc0
 * RK3308BS_ALC_R_DIG_CON12 - REG: 0x00b0 + ch * 0xc0
 */

/*
 * RK3308BS_ALC_L_DIG_CON13 - REG: 0x0074 + ch * 0xc0
 * RK3308BS_ALC_R_DIG_CON13 - REG: 0x00b4 + ch * 0xc0
 */

/*
 * RK3308BS_ALC_L_DIG_CON14 - REG: 0x0078 + ch * 0xc0
 * RK3308BS_ALC_R_DIG_CON14 - REG: 0x00b8 + ch * 0xc0
 */
#define RK3308BS_AGC_GAIN_MSK			0x1f

/* RK3308_DAC_DIG_CON01 - REG: 0x0304 */
#define RK3308_DAC_I2S_LRC_POL_MSK		(0x1 << 7)
#define RK3308_DAC_I2S_LRC_POL_REVERSAL		(0x1 << 7)
#define RK3308_DAC_I2S_LRC_POL_NORMAL		(0x0 << 7)
#define RK3308_DAC_I2S_VALID_LEN_SFT		5
#define RK3308_DAC_I2S_VALID_LEN_MSK		(0x3 << RK3308_DAC_I2S_VALID_LEN_SFT)
#define RK3308_DAC_I2S_VALID_LEN_32BITS		(0x3 << RK3308_DAC_I2S_VALID_LEN_SFT)
#define RK3308_DAC_I2S_VALID_LEN_24BITS		(0x2 << RK3308_DAC_I2S_VALID_LEN_SFT)
#define RK3308_DAC_I2S_VALID_LEN_20BITS		(0x1 << RK3308_DAC_I2S_VALID_LEN_SFT)
#define RK3308_DAC_I2S_VALID_LEN_16BITS		(0x0 << RK3308_DAC_I2S_VALID_LEN_SFT)
#define RK3308_DAC_I2S_MODE_SFT			3
#define RK3308_DAC_I2S_MODE_MSK			(0x3 << RK3308_DAC_I2S_MODE_SFT)
#define RK3308_DAC_I2S_MODE_PCM			(0x3 << RK3308_DAC_I2S_MODE_SFT)
#define RK3308_DAC_I2S_MODE_I2S			(0x2 << RK3308_DAC_I2S_MODE_SFT)
#define RK3308_DAC_I2S_MODE_LJ			(0x1 << RK3308_DAC_I2S_MODE_SFT)
#define RK3308_DAC_I2S_MODE_RJ			(0x0 << RK3308_DAC_I2S_MODE_SFT)
#define RK3308_DAC_I2S_LR_MSK			(0x1 << 2)
#define RK3308_DAC_I2S_LR_SWAP			(0x1 << 2)
#define RK3308_DAC_I2S_LR_NORMAL		(0x0 << 2)
#define RK3308BS_DAC_I2S_BYPASS_MSK		(0x1 << 1)
#define RK3308BS_DAC_I2S_BYPASS_EN		(0x1 << 1)
#define RK3308BS_DAC_I2S_BYPASS_DIS		(0x0 << 1)

/* RK3308_DAC_DIG_CON02 - REG: 0x0308 */
#define RK3308BS_DAC_IO_MODE_MSK		(0x1 << 7)
#define RK3308BS_DAC_IO_MODE_MASTER		(0x1 << 7)
#define RK3308BS_DAC_IO_MODE_SLAVE		(0x0 << 7)
#define RK3308BS_DAC_MODE_MSK			(0x1 << 6)
#define RK3308BS_DAC_MODE_MASTER		(0x1 << 6)
#define RK3308BS_DAC_MODE_SLAVE			(0x0 << 6)
#define RK3308_DAC_IO_MODE_MSK			(0x1 << 5)
#define RK3308_DAC_IO_MODE_MASTER		(0x1 << 5)
#define RK3308_DAC_IO_MODE_SLAVE		(0x0 << 5)
#define RK3308_DAC_MODE_MSK			(0x1 << 4)
#define RK3308_DAC_MODE_MASTER			(0x1 << 4)
#define RK3308_DAC_MODE_SLAVE			(0x0 << 4)
#define RK3308_DAC_I2S_FRAME_LEN_SFT		2
#define RK3308_DAC_I2S_FRAME_LEN_MSK		(0x3 << RK3308_DAC_I2S_FRAME_LEN_SFT)
#define RK3308_DAC_I2S_FRAME_32BITS		(0x3 << RK3308_DAC_I2S_FRAME_LEN_SFT)
#define RK3308_DAC_I2S_FRAME_24BITS		(0x2 << RK3308_DAC_I2S_FRAME_LEN_SFT)
#define RK3308_DAC_I2S_FRAME_20BITS		(0x1 << RK3308_DAC_I2S_FRAME_LEN_SFT)
#define RK3308_DAC_I2S_FRAME_16BITS		(0x0 << RK3308_DAC_I2S_FRAME_LEN_SFT)
#define RK3308_DAC_I2S_MSK			(0x1 << 1)
#define RK3308_DAC_I2S_WORK			(0x1 << 1)
#define RK3308_DAC_I2S_RESET			(0x0 << 1)
#define RK3308_DAC_I2S_BIT_CLK_POL_MSK		(0x1 << 0)
#define RK3308_DAC_I2S_BIT_CLK_POL_REVERSAL	(0x1 << 0)
#define RK3308_DAC_I2S_BIT_CLK_POL_NORMAL	(0x0 << 0)

/* RK3308_DAC_DIG_CON03 - REG: 0x030C */
#define RK3308_DAC_L_CH_BIST_SFT		2
#define RK3308_DAC_L_CH_BIST_MSK		(0x3 << RK3308_DAC_L_CH_BIST_SFT)
#define RK3308_DAC_L_CH_BIST_LEFT		(0x3 << RK3308_DAC_L_CH_BIST_SFT) /* normal mode */
#define RK3308_DAC_L_CH_BIST_CUBE		(0x2 << RK3308_DAC_L_CH_BIST_SFT)
#define RK3308_DAC_L_CH_BIST_SINE		(0x1 << RK3308_DAC_L_CH_BIST_SFT)
#define RK3308_DAC_L_CH_BIST_RIGHT		(0x0 << RK3308_DAC_L_CH_BIST_SFT) /* normal mode */
#define RK3308_DAC_R_CH_BIST_SFT		0
#define RK3308_DAC_R_CH_BIST_MSK		(0x3 << RK3308_DAC_R_CH_BIST_SFT)
#define RK3308_DAC_R_CH_BIST_LEFT		(0x3 << RK3308_DAC_R_CH_BIST_SFT) /* normal mode */
#define RK3308_DAC_R_CH_BIST_CUBE		(0x2 << RK3308_DAC_R_CH_BIST_SFT)
#define RK3308_DAC_R_CH_BIST_SINE		(0x1 << RK3308_DAC_R_CH_BIST_SFT)
#define RK3308_DAC_R_CH_BIST_RIGHT		(0x0 << RK3308_DAC_R_CH_BIST_SFT) /* normal mode */

/* RK3308_DAC_DIG_CON04 - REG: 0x0310 */
#define RK3308_DAC_MODULATOR_GAIN_SFT		4
#define RK3308_DAC_MODULATOR_GAIN_MSK		(0x7 << RK3308_DAC_MODULATOR_GAIN_SFT)
#define RK3308_DAC_MODULATOR_GAIN_4_8DB		(0x5 << RK3308_DAC_MODULATOR_GAIN_SFT)
#define RK3308_DAC_MODULATOR_GAIN_4_2DB		(0x4 << RK3308_DAC_MODULATOR_GAIN_SFT)
#define RK3308_DAC_MODULATOR_GAIN_3_5DB		(0x3 << RK3308_DAC_MODULATOR_GAIN_SFT)
#define RK3308_DAC_MODULATOR_GAIN_2_8DB		(0x2 << RK3308_DAC_MODULATOR_GAIN_SFT)
#define RK3308_DAC_MODULATOR_GAIN_2DB		(0x1 << RK3308_DAC_MODULATOR_GAIN_SFT)
#define RK3308_DAC_MODULATOR_GAIN_0DB		(0x0 << RK3308_DAC_MODULATOR_GAIN_SFT)
#define RK3308_DAC_CIC_IF_GAIN_SFT		0
#define RK3308_DAC_CIC_IF_GAIN_MSK		(0x7 << RK3308_DAC_CIC_IF_GAIN_SFT)

/* RK3308BS_DAC_DIG_CON04 - REG: 0x0310 */
#define RK3308BS_DAC_DIG_GAIN_SFT		0
#define RK3308BS_DAC_DIG_GAIN_MSK		(0xff << RK3308BS_DAC_DIG_GAIN_SFT)
#define RK3308BS_DAC_DIG_GAIN(x)		((x) & RK3308BS_DAC_DIG_GAIN_MSK)
#define RK3308BS_DAC_DIG_0DB			0xed

/* RK3308_DAC_DIG_CON05 - REG: 0x0314 */
#define RK3308_DAC_L_DATA_SEL_INPUT		(0x1 << 2)
#define RK3308_DAC_L_DATA_SEL_NORMAL		(0x0 << 2)
#define RK3308_DAC_R_DATA_SEL_INPUT		(0x1 << 1)
#define RK3308_DAC_R_DATA_SEL_NORMAL		(0x0 << 1)

/* RK3308BS_DAC_DIG_CON05 - REG: 0x0314 */
#define RK3308BS_DAC_L_DATA_SEL_MUTE		(0x1 << 2)
#define RK3308BS_DAC_L_DATA_SEL_NORMAL		(0x0 << 2)
#define RK3308BS_DAC_R_DATA_SEL_MUTE		(0x1 << 1)
#define RK3308BS_DAC_R_DATA_SEL_NORMAL		(0x0 << 1)

/* RK3308_DAC_DIG_CON10 - REG: 0x0328 */
#define RK3308_DAC_DATA_HI4(x)			((x) & 0xf) /* Need to RK3308_DAC_x_REG_CTL_INDATA */

/* RK3308_DAC_DIG_CON11 - REG: 0x032c */
#define RK3308_DAC_DATA_LO8(x)			((x) & 0xff) /* Need to RK3308_DAC_x_REG_CTL_INDATA */

/* RK3308BS_DAC_DIG_CON09 - REG: 0x0324 */
#define RK3308BS_DAC_DATA_HI4(x)		((x) & 0xf) /* Need to RK3308_DAC_x_REG_CTL_INDATA */

/* RK3308BS_DAC_DIG_CON10 - REG: 0x0328 */
#define RK3308BS_DAC_DATA_LO8(x)		((x) & 0xff) /* Need to RK3308_DAC_x_REG_CTL_INDATA */

/* RK3308BS_DAC_DIG_CON11 - REG: 0x032c */
#define RK3308BS_DAC_DELAY_TIME_DETECT_HI2(x)	((x) & 0x3)

/* RK3308BS_DAC_DIG_CON12 - REG: 0x0330 */
#define RK3308BS_DAC_DELAY_TIME_DETECT_LO8(x)	((x) & 0xff)

/* RK3308_ADC_ANA_CON00 - REG: 0x0340 */
#define RK3308_ADC_CH1_CH2_MIC_ALL_MSK		(0xff << 0)
#define RK3308_ADC_CH1_CH2_MIC_ALL		0xff
#define RK3308_ADC_CH2_MIC_UNMUTE		(0x1 << 7)
#define RK3308_ADC_CH2_MIC_MUTE			(0x0 << 7)
#define RK3308_ADC_CH2_MIC_WORK			(0x1 << 6)
#define RK3308_ADC_CH2_MIC_INIT			(0x0 << 6)
#define RK3308_ADC_CH2_MIC_EN			(0x1 << 5)
#define RK3308_ADC_CH2_MIC_DIS			(0x0 << 5)
#define RK3308_ADC_CH2_BUF_REF_EN		(0x1 << 4)
#define RK3308_ADC_CH2_BUF_REF_DIS		(0x0 << 4)
#define RK3308_ADC_CH1_MIC_UNMUTE		(0x1 << 3)
#define RK3308_ADC_CH1_MIC_MUTE			(0x0 << 3)
#define RK3308_ADC_CH1_MIC_WORK			(0x1 << 2)
#define RK3308_ADC_CH1_MIC_INIT			(0x0 << 2)
#define RK3308_ADC_CH1_MIC_EN			(0x1 << 1)
#define RK3308_ADC_CH1_MIC_DIS			(0x0 << 1)
#define RK3308_ADC_CH1_BUF_REF_EN		(0x1 << 0)
#define RK3308_ADC_CH1_BUF_REF_DIS		(0x0 << 0)

/* RK3308_ADC_ANA_CON01 - REG: 0x0344
 *
 * The PGA of MIC-INs:
 * 0x0 - MIC1~MIC8 0dB
 * 0x1 - MIC1~MIC8 6.6dB
 * 0x2 - MIC1~MIC8 13dB
 * 0x3 - MIC1~MIC8 20dB
 */
#define RK3308_ADC_CH2_MIC_GAIN_MAX		0x3
#define RK3308_ADC_CH2_MIC_GAIN_MIN		0
#define RK3308_ADC_CH2_MIC_GAIN_SFT		4
#define RK3308_ADC_CH2_MIC_GAIN_MSK		(0x3 << RK3308_ADC_CH2_MIC_GAIN_SFT)
#define RK3308_ADC_CH2_MIC_GAIN_20DB		(0x3 << RK3308_ADC_CH2_MIC_GAIN_SFT)
#define RK3308_ADC_CH2_MIC_GAIN_13DB		(0x2 << RK3308_ADC_CH2_MIC_GAIN_SFT) /* TRM: only used for version B  */
#define RK3308_ADC_CH2_MIC_GAIN_6_6DB		(0x1 << RK3308_ADC_CH2_MIC_GAIN_SFT) /* TRM: only used for version B  */
#define RK3308_ADC_CH2_MIC_GAIN_0DB		(0x0 << RK3308_ADC_CH2_MIC_GAIN_SFT)

#define RK3308_ADC_CH1_MIC_GAIN_MAX		0x3
#define RK3308_ADC_CH1_MIC_GAIN_MIN		0
#define RK3308_ADC_CH1_MIC_GAIN_SFT		0
#define RK3308_ADC_CH1_MIC_GAIN_MSK		(0x3 << RK3308_ADC_CH1_MIC_GAIN_SFT)
#define RK3308_ADC_CH1_MIC_GAIN_20DB		(0x3 << RK3308_ADC_CH1_MIC_GAIN_SFT)
#define RK3308_ADC_CH1_MIC_GAIN_13DB		(0x2 << RK3308_ADC_CH1_MIC_GAIN_SFT) /* TRM: only used for version B  */
#define RK3308_ADC_CH1_MIC_GAIN_6_6DB		(0x1 << RK3308_ADC_CH1_MIC_GAIN_SFT) /* TRM: only used for version B  */
#define RK3308_ADC_CH1_MIC_GAIN_0DB		(0x0 << RK3308_ADC_CH1_MIC_GAIN_SFT)

/* RK3308_ADC_ANA_CON02 - REG: 0x0348 */
#define RK3308_ADC_CH2_ALC_ZC_MSK		(0x7 << 4)
#define RK3308_ADC_CH2_ZEROCROSS_DET_EN		(0x1 << 6)
#define RK3308_ADC_CH2_ZEROCROSS_DET_DIS	(0x0 << 6)
#define RK3308_ADC_CH2_ALC_WORK			(0x1 << 5)
#define RK3308_ADC_CH2_ALC_INIT			(0x0 << 5)
#define RK3308_ADC_CH2_ALC_EN			(0x1 << 4)
#define RK3308_ADC_CH2_ALC_DIS			(0x0 << 4)

#define RK3308_ADC_CH1_ALC_ZC_MSK		(0x7 << 0)
#define RK3308_ADC_CH1_ZEROCROSS_DET_EN		(0x1 << 2)
#define RK3308_ADC_CH1_ZEROCROSS_DET_DIS	(0x0 << 2)
#define RK3308_ADC_CH1_ALC_WORK			(0x1 << 1)
#define RK3308_ADC_CH1_ALC_INIT			(0x0 << 1)
#define RK3308_ADC_CH1_ALC_EN			(0x1 << 0)
#define RK3308_ADC_CH1_ALC_DIS			(0x0 << 0)

/* RK3308_ADC_ANA_CON03 - REG: 0x034c */
#define RK3308_ADC_CH1_ALC_GAIN_MAX		0x1f
#define RK3308_ADC_CH1_ALC_GAIN_MIN		0
#define RK3308_ADC_CH1_ALC_GAIN_SFT		0
#define RK3308_ADC_CH1_ALC_GAIN_MSK		(0x1f << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_28_5	(0x1f << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_27		(0x1e << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_25_5	(0x1d << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_24		(0x1c << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_22_5	(0x1b << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_21		(0x1a << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_19_5	(0x19 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_18		(0x18 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_16_5	(0x17 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_15		(0x16 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_13_5	(0x15 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_12		(0x14 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_10_5	(0x13 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_9		(0x12 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_7_5		(0x11 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_6		(0x10 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_4_5		(0x0f << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_3		(0x0e << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_PDB_1_5		(0x0d << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_0DB		(0x0c << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_1_5		(0x0b << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_3		(0x0a << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_4_5		(0x09 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_6		(0x08 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_7_5		(0x07 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_9		(0x06 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_10_5	(0x05 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_12		(0x04 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_13_5	(0x03 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_15		(0x02 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_16_5	(0x01 << RK3308_ADC_CH1_ALC_GAIN_SFT)
#define RK3308_ADC_CH1_ALC_GAIN_NDB_18		(0x00 << RK3308_ADC_CH1_ALC_GAIN_SFT)

/* RK3308_ADC_ANA_CON04 - REG: 0x0350 */
#define RK3308_ADC_CH2_ALC_GAIN_MAX		0x1f
#define RK3308_ADC_CH2_ALC_GAIN_MIN		0
#define RK3308_ADC_CH2_ALC_GAIN_SFT		0
#define RK3308_ADC_CH2_ALC_GAIN_MSK		(0x1f << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_28_5	(0x1f << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_27		(0x1e << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_25_5	(0x1d << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_24		(0x1c << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_22_5	(0x1b << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_21		(0x1a << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_19_5	(0x19 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_18		(0x18 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_16_5	(0x17 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_15		(0x16 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_13_5	(0x15 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_12		(0x14 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_10_5	(0x13 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_9		(0x12 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_7_5		(0x11 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_6		(0x10 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_4_5		(0x0f << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_3		(0x0e << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_PDB_1_5		(0x0d << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_0DB		(0x0c << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_1_5		(0x0b << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_3		(0x0a << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_4_5		(0x09 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_6		(0x08 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_7_5		(0x07 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_9		(0x06 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_10_5	(0x05 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_12		(0x04 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_13_5	(0x03 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_15		(0x02 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_16_5	(0x01 << RK3308_ADC_CH2_ALC_GAIN_SFT)
#define RK3308_ADC_CH2_ALC_GAIN_NDB_18		(0x00 << RK3308_ADC_CH2_ALC_GAIN_SFT)

/* RK3308_ADC_ANA_CON05 - REG: 0x0354 */
#define RK3308_ADC_CH2_ADC_CLK_MSK		(0x7 << 4)
#define RK3308_ADC_CH2_ADC_WORK			(0x1 << 6)
#define RK3308_ADC_CH2_ADC_INIT			(0x0 << 6)
#define RK3308_ADC_CH2_ADC_EN			(0x1 << 5)
#define RK3308_ADC_CH2_ADC_DIS			(0x0 << 5)
#define RK3308_ADC_CH2_CLK_EN			(0x1 << 4)
#define RK3308_ADC_CH2_CLK_DIS			(0x0 << 4)

#define RK3308_ADC_CH1_ADC_CLK_MSK		(0x7 << 0)
#define RK3308_ADC_CH1_ADC_WORK			(0x1 << 2)
#define RK3308_ADC_CH1_ADC_INIT			(0x0 << 2)
#define RK3308_ADC_CH1_ADC_EN			(0x1 << 1)
#define RK3308_ADC_CH1_ADC_DIS			(0x0 << 1)
#define RK3308_ADC_CH1_CLK_EN			(0x1 << 0)
#define RK3308_ADC_CH1_CLK_DIS			(0x0 << 0)

/* RK3308_ADC_ANA_CON06 - REG: 0x0358 */
#define RK3308_ADC_CURRENT_MSK			(0x1 << 0)
#define RK3308_ADC_CURRENT_EN			(0x1 << 0)
#define RK3308_ADC_CURRENT_DIS			(0x0 << 0)

/* RK3308_ADC_ANA_CON07 - REG: 0x035c */
/* Note: The register configuration is only valid for ADC2 */
#define RK3308_ADC_CH2_IN_SEL_SFT		6
#define RK3308_ADC_CH2_IN_SEL_MSK		(0x3 << RK3308_ADC_CH2_IN_SEL_SFT)
#define RK3308_ADC_CH2_IN_LINEIN_MIC		(0x3 << RK3308_ADC_CH2_IN_SEL_SFT)
#define RK3308_ADC_CH2_IN_LINEIN		(0x2 << RK3308_ADC_CH2_IN_SEL_SFT)
#define RK3308_ADC_CH2_IN_MIC			(0x1 << RK3308_ADC_CH2_IN_SEL_SFT)
#define RK3308_ADC_CH2_IN_NONE			(0x0 << RK3308_ADC_CH2_IN_SEL_SFT)
/* Note: The register configuration is only valid for ADC1 */
#define RK3308_ADC_CH1_IN_SEL_SFT		4
#define RK3308_ADC_CH1_IN_SEL_MSK		(0x3 << RK3308_ADC_CH1_IN_SEL_SFT)
#define RK3308_ADC_CH1_IN_LINEIN_MIC		(0x3 << RK3308_ADC_CH1_IN_SEL_SFT)
#define RK3308_ADC_CH1_IN_LINEIN		(0x2 << RK3308_ADC_CH1_IN_SEL_SFT)
#define RK3308_ADC_CH1_IN_MIC			(0x1 << RK3308_ADC_CH1_IN_SEL_SFT)
#define RK3308_ADC_CH1_IN_NONE			(0x0 << RK3308_ADC_CH1_IN_SEL_SFT)

#define RK3308_ADC_MIC_BIAS_BUF_SFT		3
#define RK3308_ADC_MIC_BIAS_BUF_EN		(0x1 << RK3308_ADC_MIC_BIAS_BUF_SFT)
#define RK3308_ADC_MIC_BIAS_BUF_DIS		(0x0 << RK3308_ADC_MIC_BIAS_BUF_SFT)
#define RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT	0
#define RK3308_ADC_LEVEL_RANGE_MICBIAS_MSK	(0x7 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
/*
 * The follow MICBIAS_VOLTs are based on the external reference voltage(Vref).
 * For example, the Vref == 3.3V, the MICBIAS_VOLT_0_85 is equal:
 * 3.3V * 0.85 = 2.805V.
 */
#define RK3308_ADC_MICBIAS_VOLT_0_85		(0x7 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define RK3308_ADC_MICBIAS_VOLT_0_8		(0x6 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define RK3308_ADC_MICBIAS_VOLT_0_75		(0x5 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define RK3308_ADC_MICBIAS_VOLT_0_7		(0x4 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define RK3308_ADC_MICBIAS_VOLT_0_65		(0x3 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define RK3308_ADC_MICBIAS_VOLT_0_6		(0x2 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define RK3308_ADC_MICBIAS_VOLT_0_55		(0x1 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)
#define RK3308_ADC_MICBIAS_VOLT_0_5		(0x0 << RK3308_ADC_LEVEL_RANGE_MICBIAS_SFT)

/* RK3308_ADC_ANA_CON08 - REG: 0x0360 */
#define RK3308_ADC_MICBIAS_CURRENT_MSK		(0x1 << 4)
#define RK3308_ADC_MICBIAS_CURRENT_EN		(0x1 << 4)
#define RK3308_ADC_MICBIAS_CURRENT_DIS		(0x0 << 4)
#define RK3308BS_ADC_MICBIAS_CURRENT_SEL(x)	((x) & 0xf)

/* RK3308BS_ADC_ANA_CON09 - REG: 0x0364 */
#define RK3308BS_ADC_MICBIAS_OPA_VBIAS(x)	(((x) & 0x7) << 4)
#define RK3308BS_ADC_VCM_SETUP_MIN_CURRENT_EN	(0x0 << 1)
#define RK3308BS_ADC_VCM_SETUP_MIN_CURRENT_DIS	(0x0 << 0)

/* RK3308_ADC_ANA_CON10 - REG: 0x0368 */
#define RK3308_ADC_REF_EN			(0x1 << 7)
#define RK3308_ADC_REF_DIS			(0x0 << 7)
#define RK3308_ADC_CURRENT_CHARGE_SFT		0
#define RK3308_ADC_CURRENT_CHARGE_MSK		(0x7f << RK3308_ADC_CURRENT_CHARGE_SFT)
/*
 * 1: Choose the current I
 * 0: Don't choose the current I
 */
#define RK3308_ADC_SEL_I(x)			((x) & 0x7f)

/* RK3308_ADC_ANA_CON11 - REG: 0x036c */
#define RK3308_ADC_ALCR_CON_GAIN_PGAR_MSK	(0x1 << 1)
#define RK3308_ADC_ALCR_CON_GAIN_PGAR_EN	(0x1 << 1)
#define RK3308_ADC_ALCR_CON_GAIN_PGAR_DIS	(0x0 << 1)
#define RK3308_ADC_ALCL_CON_GAIN_PGAL_MSK	(0x1 << 0)
#define RK3308_ADC_ALCL_CON_GAIN_PGAL_EN	(0x1 << 0)
#define RK3308_ADC_ALCL_CON_GAIN_PGAL_DIS	(0x0 << 0)

/* RK3308_DAC_ANA_CON00 - REG: 0x0440 */
#define RK3308_DAC_CURRENT_SEL_SFT		4
#define RK3308_DAC_CURRENT_SEL_MSK		(0xf << RK3308_DAC_CURRENT_SEL_SFT)
#define RK3308_DAC_CURRENT_SEL(x)		((x) & RK3308_DAC_CURRENT_SEL_MSK)
#define RK3308_DAC_HEADPHONE_DET_MSK		(0x1 << 1)
#define RK3308_DAC_HEADPHONE_DET_EN		(0x1 << 1)
#define RK3308_DAC_HEADPHONE_DET_DIS		(0x0 << 1)
#define RK3308_DAC_CURRENT_MSK			(0x1 << 0)
#define RK3308_DAC_CURRENT_EN			(0x1 << 0)
#define RK3308_DAC_CURRENT_DIS			(0x0 << 0)

/* RK3308_DAC_ANA_CON01 - REG: 0x0444 */
#define RK3308_DAC_BUF_REF_R_MSK		(0x1 << 6)
#define RK3308_DAC_BUF_REF_R_EN			(0x1 << 6)
#define RK3308_DAC_BUF_REF_R_DIS		(0x0 << 6)
#define RK3308_DAC_HPOUT_POP_SOUND_R_SFT	4
#define RK3308_DAC_HPOUT_POP_SOUND_R_MSK	(0x3 << RK3308_DAC_HPOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_HPOUT_POP_SOUND_R_WORK	(0x2 << RK3308_DAC_HPOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_HPOUT_POP_SOUND_R_INIT	(0x1 << RK3308_DAC_HPOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_HPOUT_POP_SOUND_R_DIS	(0x0 << RK3308_DAC_HPOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_BUF_REF_L_MSK		(0x1 << 2)
#define RK3308_DAC_BUF_REF_L_EN			(0x1 << 2)
#define RK3308_DAC_BUF_REF_L_DIS		(0x0 << 2)
#define RK3308_DAC_HPOUT_POP_SOUND_L_SFT	0
#define RK3308_DAC_HPOUT_POP_SOUND_L_MSK	(0x3 << RK3308_DAC_HPOUT_POP_SOUND_L_SFT)
#define RK3308_DAC_HPOUT_POP_SOUND_L_WORK	(0x2 << RK3308_DAC_HPOUT_POP_SOUND_L_SFT)
#define RK3308_DAC_HPOUT_POP_SOUND_L_INIT	(0x1 << RK3308_DAC_HPOUT_POP_SOUND_L_SFT)
#define RK3308_DAC_HPOUT_POP_SOUND_L_DIS	(0x0 << RK3308_DAC_HPOUT_POP_SOUND_L_SFT)

/* RK3308_DAC_ANA_CON02 - REG: 0x0448 */
#define RK3308_DAC_R_DAC_WORK			(0x1 << 7)
#define RK3308_DAC_R_DAC_INIT			(0x0 << 7)
#define RK3308_DAC_R_DAC_EN			(0x1 << 6)
#define RK3308_DAC_R_DAC_DIS			(0x0 << 6)
#define RK3308_DAC_R_CLK_EN			(0x1 << 5)
#define RK3308_DAC_R_CLK_DIS			(0x0 << 5)
#define RK3308_DAC_R_REF_EN			(0x1 << 4)
#define RK3308_DAC_R_REF_DIS			(0x0 << 4)
#define RK3308_DAC_L_DAC_WORK			(0x1 << 3)
#define RK3308_DAC_L_DAC_INIT			(0x0 << 3)
#define RK3308_DAC_L_DAC_EN			(0x1 << 2)
#define RK3308_DAC_L_DAC_DIS			(0x0 << 2)
#define RK3308_DAC_L_CLK_EN			(0x1 << 1)
#define RK3308_DAC_L_CLK_DIS			(0x0 << 1)
#define RK3308_DAC_L_REF_EN			(0x1 << 0)
#define RK3308_DAC_L_REF_DIS			(0x0 << 0)

/* RK3308_DAC_ANA_CON03 - REG: 0x044c */
#define RK3308_DAC_R_HPOUT_WORK			(0x1 << 6)
#define RK3308_DAC_R_HPOUT_INIT			(0x0 << 6)
#define RK3308_DAC_R_HPOUT_EN			(0x1 << 5)
#define RK3308_DAC_R_HPOUT_DIS			(0x0 << 5)
#define RK3308_DAC_R_HPOUT_UNMUTE		(0x1 << 4)
#define RK3308_DAC_R_HPOUT_MUTE			(0x0 << 4)
#define RK3308_DAC_L_HPOUT_WORK			(0x1 << 2)
#define RK3308_DAC_L_HPOUT_INIT			(0x0 << 2)
#define RK3308_DAC_L_HPOUT_EN			(0x1 << 1)
#define RK3308_DAC_L_HPOUT_DIS			(0x0 << 1)
#define RK3308_DAC_L_HPOUT_UNMUTE		(0x1 << 0)
#define RK3308_DAC_L_HPOUT_MUTE			(0x0 << 0)

/* RK3308_DAC_ANA_CON04 - REG: 0x0450 */
#define RK3308_DAC_R_LINEOUT_GAIN_MAX		0x3
#define RK3308_DAC_R_LINEOUT_GAIN_SFT		6
#define RK3308_DAC_R_LINEOUT_GAIN_MSK		(0x3 << RK3308_DAC_R_LINEOUT_GAIN_SFT)
#define RK3308_DAC_R_LINEOUT_GAIN_0DB		(0x3 << RK3308_DAC_R_LINEOUT_GAIN_SFT)
#define RK3308_DAC_R_LINEOUT_GAIN_NDB_1_5	(0x2 << RK3308_DAC_R_LINEOUT_GAIN_SFT)
#define RK3308_DAC_R_LINEOUT_GAIN_NDB_3		(0x1 << RK3308_DAC_R_LINEOUT_GAIN_SFT)
#define RK3308_DAC_R_LINEOUT_GAIN_NDB_6		(0x0 << RK3308_DAC_R_LINEOUT_GAIN_SFT)
#define RK3308_DAC_R_LINEOUT_UNMUTE		(0x1 << 5)
#define RK3308_DAC_R_LINEOUT_MUTE		(0x0 << 5)
#define RK3308_DAC_R_LINEOUT_EN			(0x1 << 4)
#define RK3308_DAC_R_LINEOUT_DIS		(0x0 << 4)
#define RK3308_DAC_L_LINEOUT_GAIN_MAX		0x3
#define RK3308_DAC_L_LINEOUT_GAIN_SFT		2
#define RK3308_DAC_L_LINEOUT_GAIN_MSK		(0x3 << RK3308_DAC_L_LINEOUT_GAIN_SFT)
#define RK3308_DAC_L_LINEOUT_GAIN_0DB		(0x3 << RK3308_DAC_L_LINEOUT_GAIN_SFT)
#define RK3308_DAC_L_LINEOUT_GAIN_NDB_1_5	(0x2 << RK3308_DAC_L_LINEOUT_GAIN_SFT)
#define RK3308_DAC_L_LINEOUT_GAIN_NDB_3		(0x1 << RK3308_DAC_L_LINEOUT_GAIN_SFT)
#define RK3308_DAC_L_LINEOUT_GAIN_NDB_6		(0x0 << RK3308_DAC_L_LINEOUT_GAIN_SFT)
#define RK3308_DAC_L_LINEOUT_UNMUTE		(0x1 << 1)
#define RK3308_DAC_L_LINEOUT_MUTE		(0x0 << 1)
#define RK3308_DAC_L_LINEOUT_EN			(0x1 << 0)
#define RK3308_DAC_L_LINEOUT_DIS		(0x0 << 0)

/* RK3308_DAC_ANA_CON05 - REG: 0x0454, step is 1.5db */
#define RK3308_DAC_L_HPOUT_GAIN_MAX		0x1e
#define RK3308_DAC_L_HPOUT_GAIN_SFT		0
#define RK3308_DAC_L_HPOUT_GAIN_MSK		(0x1f << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_PDB_6		(0x1e << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_PDB_4_5		(0x1d << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_PDB_3		(0x1c << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_PDB_1_5		(0x1b << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_0DB		(0x1a << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_1_5		(0x19 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_3		(0x18 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_4_5		(0x17 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_6		(0x16 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_7_5		(0x15 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_9		(0x14 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_10_5	(0x13 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_12		(0x12 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_13_5	(0x11 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_15		(0x10 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_16_5	(0x0f << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_18		(0x0e << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_19_5	(0x0d << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_21		(0x0c << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_22_5	(0x0b << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_24		(0x0a << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_25_5	(0x09 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_27		(0x08 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_28_5	(0x07 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_30		(0x06 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_31_5	(0x05 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_33		(0x04 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_34_5	(0x03 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_36		(0x02 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_37_5	(0x01 << RK3308_DAC_L_HPOUT_GAIN_SFT)
#define RK3308_DAC_L_HPOUT_GAIN_NDB_39		(0x00 << RK3308_DAC_L_HPOUT_GAIN_SFT)

/* RK3308_DAC_ANA_CON06 - REG: 0x0458, step is 1.5db */
#define RK3308_DAC_R_HPOUT_GAIN_MAX		0x1e
#define RK3308_DAC_R_HPOUT_GAIN_SFT		0
#define RK3308_DAC_R_HPOUT_GAIN_MSK		(0x1f << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_PDB_6		(0x1e << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_PDB_4_5		(0x1d << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_PDB_3		(0x1c << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_PDB_1_5		(0x1b << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_0DB		(0x1a << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_1_5		(0x19 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_3		(0x18 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_4_5		(0x17 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_6		(0x16 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_7_5		(0x15 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_9		(0x14 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_10_5	(0x13 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_12		(0x12 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_13_5	(0x11 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_15		(0x10 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_16_5	(0x0f << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_18		(0x0e << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_19_5	(0x0d << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_21		(0x0c << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_22_5	(0x0b << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_24		(0x0a << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_25_5	(0x09 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_27		(0x08 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_28_5	(0x07 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_30		(0x06 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_31_5	(0x05 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_33		(0x04 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_34_5	(0x03 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_36		(0x02 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_37_5	(0x01 << RK3308_DAC_R_HPOUT_GAIN_SFT)
#define RK3308_DAC_R_HPOUT_GAIN_NDB_39		(0x00 << RK3308_DAC_R_HPOUT_GAIN_SFT)

/* RK3308_DAC_ANA_CON07 - REG: 0x045c */
#define RK3308_DAC_R_HPOUT_DRV_SFT		4
#define RK3308_DAC_R_HPOUT_DRV_MSK		(0xf << RK3308_DAC_R_HPOUT_DRV_SFT)
#define RK3308_DAC_R_HPOUT_DRV(x)		(((x) << RK3308_DAC_R_HPOUT_DRV_SFT) & RK3308_DAC_R_HPOUT_DRV_MSK)
#define RK3308_DAC_L_HPOUT_DRV_SFT		0
#define RK3308_DAC_L_HPOUT_DRV_MSK		(0xf << RK3308_DAC_L_HPOUT_DRV_SFT)
#define RK3308_DAC_L_HPOUT_DRV(x)		(((x) << RK3308_DAC_L_HPOUT_DRV_SFT) & RK3308_DAC_L_HPOUT_DRV_MSK)

/* RK3308_DAC_ANA_CON08 - REG: 0x0460 */
#define RK3308_DAC_R_LINEOUT_DRV_SFT		4
#define RK3308_DAC_R_LINEOUT_DRV_MSK		(0xf << RK3308_DAC_R_LINEOUT_DRV_SFT)
#define RK3308_DAC_R_LINEOUT_DRV(x)		(((x) << RK3308_DAC_R_LINEOUT_DRV_SFT) & RK3308_DAC_R_LINEOUT_DRV_MSK)
#define RK3308_DAC_L_LINEOUT_DRV_SFT		0
#define RK3308_DAC_L_LINEOUT_DRV_MSK		(0xf << RK3308_DAC_L_LINEOUT_DRV_SFT)
#define RK3308_DAC_L_LINEOUT_DRV(x)		(((x) << RK3308_DAC_L_LINEOUT_DRV_SFT) & RK3308_DAC_L_LINEOUT_DRV_MSK)

/* RK3308_DAC_ANA_CON12 - REG: 0x0470 */
#define RK3308_DAC_R_HPMIX_SEL_SFT		6
#define RK3308_DAC_R_HPMIX_SEL_MSK		(0x3 << RK3308_DAC_R_HPMIX_SEL_SFT)
#define RK3308_DAC_R_HPMIX_LINEIN_I2S		(0x3 << RK3308_DAC_R_HPMIX_SEL_SFT)
#define RK3308_DAC_R_HPMIX_LINEIN		(0x2 << RK3308_DAC_R_HPMIX_SEL_SFT)
#define RK3308_DAC_R_HPMIX_I2S			(0x1 << RK3308_DAC_R_HPMIX_SEL_SFT)
#define RK3308_DAC_R_HPMIX_NONE			(0x0 << RK3308_DAC_R_HPMIX_SEL_SFT)
#define RK3308_DAC_R_HPMIX_GAIN_MIN		0x1
#define RK3308_DAC_R_HPMIX_GAIN_MAX		0x2
#define RK3308_DAC_R_HPMIX_GAIN_SFT		4
#define RK3308_DAC_R_HPMIX_GAIN_MSK		(0x3 << RK3308_DAC_R_HPMIX_GAIN_SFT)
#define RK3308_DAC_R_HPMIX_GAIN_0DB		(0x2 << RK3308_DAC_R_HPMIX_GAIN_SFT)
#define RK3308_DAC_R_HPMIX_GAIN_NDB_6		(0x1 << RK3308_DAC_R_HPMIX_GAIN_SFT)
#define RK3308_DAC_L_HPMIX_SEL_SFT		2
#define RK3308_DAC_L_HPMIX_SEL_MSK		(0x3 << RK3308_DAC_L_HPMIX_SEL_SFT)
#define RK3308_DAC_L_HPMIX_LINEIN_I2S		(0x3 << RK3308_DAC_L_HPMIX_SEL_SFT)
#define RK3308_DAC_L_HPMIX_LINEIN		(0x2 << RK3308_DAC_L_HPMIX_SEL_SFT)
#define RK3308_DAC_L_HPMIX_I2S			(0x1 << RK3308_DAC_L_HPMIX_SEL_SFT)
#define RK3308_DAC_L_HPMIX_NONE			(0x0 << RK3308_DAC_L_HPMIX_SEL_SFT)
#define RK3308_DAC_L_HPMIX_GAIN_MIN		0x1
#define RK3308_DAC_L_HPMIX_GAIN_MAX		0x2
#define RK3308_DAC_L_HPMIX_GAIN_SFT		0
#define RK3308_DAC_L_HPMIX_GAIN_MSK		(0x3 << RK3308_DAC_L_HPMIX_GAIN_SFT)
#define RK3308_DAC_L_HPMIX_GAIN_0DB		(0x2 << RK3308_DAC_L_HPMIX_GAIN_SFT)
#define RK3308_DAC_L_HPMIX_GAIN_NDB_6		(0x1 << RK3308_DAC_L_HPMIX_GAIN_SFT)

/* RK3308_DAC_ANA_CON13 - REG: 0x0474 */
#define RK3308_DAC_R_HPMIX_UNMUTE		(0x1 << 6)
#define RK3308_DAC_R_HPMIX_MUTE			(0x0 << 6)
#define RK3308_DAC_R_HPMIX_WORK			(0x1 << 5)
#define RK3308_DAC_R_HPMIX_INIT			(0x0 << 5)
#define RK3308_DAC_R_HPMIX_EN			(0x1 << 4)
#define RK3308_DAC_R_HPMIX_DIS			(0x0 << 4)
#define RK3308_DAC_L_HPMIX_UNMUTE		(0x1 << 2)
#define RK3308_DAC_L_HPMIX_MUTE			(0x0 << 2)
#define RK3308_DAC_L_HPMIX_WORK			(0x1 << 1)
#define RK3308_DAC_L_HPMIX_INIT			(0x0 << 1)
#define RK3308_DAC_L_HPMIX_EN			(0x1 << 0)
#define RK3308_DAC_L_HPMIX_DIS			(0x0 << 0)

/* RK3308_DAC_ANA_CON14 - REG: 0x0478 */
#define RK3308_DAC_VCM_LINEOUT_EN		(0x1 << 4)
#define RK3308_DAC_VCM_LINEOUT_DIS		(0x0 << 4)
#define RK3308_DAC_CURRENT_CHARGE_SFT		0
#define RK3308_DAC_CURRENT_CHARGE_MSK		(0xf << RK3308_DAC_CURRENT_CHARGE_SFT)

/*
 * 1: Choose the current I
 * 0: Don't choose the current I
 */
#define RK3308_DAC_SEL_I(x)			((x) & 0xf)

/* RK3308_DAC_ANA_CON15 - REG: 0x047C */
#define RK3308_DAC_LINEOUT_POP_SOUND_R_SFT	4
#define RK3308_DAC_LINEOUT_POP_SOUND_R_MSK	(0x3 << RK3308_DAC_LINEOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_R_SEL_DC_FROM_INTERNAL	(0x2 << RK3308_DAC_LINEOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_R_SEL_DC_FROM_VCM		(0x1 << RK3308_DAC_LINEOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_R_SEL_LINEOUT_FROM_INTERNAL	(0x0 << RK3308_DAC_LINEOUT_POP_SOUND_R_SFT)
#define RK3308_DAC_LINEOUT_POP_SOUND_L_SFT	0
#define RK3308_DAC_LINEOUT_POP_SOUND_L_MSK	(0x3 << RK3308_DAC_LINEOUT_POP_SOUND_L_SFT)
#define RK3308_DAC_L_SEL_DC_FROM_INTERNAL	(0x2 << RK3308_DAC_LINEOUT_POP_SOUND_L_SFT)
#define RK3308_DAC_L_SEL_DC_FROM_VCM		(0x1 << RK3308_DAC_LINEOUT_POP_SOUND_L_SFT)
#define RK3308_DAC_L_SEL_LINEOUT_FROM_INTERNAL	(0x0 << RK3308_DAC_LINEOUT_POP_SOUND_L_SFT)

#define RK3308_HIFI				0x0

#endif /* __RK3308_CODEC_H__ */
