/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * @Descripttion: Header file of AW87XXX_PID_5A_REG
 * @version: V1.4
 * @Author: zhaozhongbo
 * @Date: 2021-03-10
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-03-10
 */
#ifndef __AW87XXX_PID_5A_REG_H__
#define __AW87XXX_PID_5A_REG_H__

/* registers list */
#define AW87XXX_PID_5A_REG_ID_REG		(0x00)
#define AW87XXX_PID_5A_REG_SYSCTRL_REG	(0x01)
#define AW87XXX_PID_5A_REG_BATSAFE_REG	(0x02)
#define AW87XXX_PID_5A_REG_BSTOVR_REG	(0x03)
#define AW87XXX_PID_5A_REG_BSTCPR1_REG	(0x04)
#define AW87XXX_PID_5A_REG_BSTCPR2_REG	(0x05)
#define AW87XXX_PID_5A_REG_PAGR_REG		(0x06)
#define AW87XXX_PID_5A_REG_PAGC3OPR_REG	(0x07)
#define AW87XXX_PID_5A_REG_PAGC3PR_REG	(0x08)
#define AW87XXX_PID_5A_REG_PAGC2OPR_REG	(0x09)
#define AW87XXX_PID_5A_REG_PAGC2PR_REG	(0x0A)
#define AW87XXX_PID_5A_REG_PAGC1PR_REG	(0x0B)
#define AW87XXX_PID_5A_REG_ADP_MODE_REG	(0x0C)
#define AW87XXX_PID_5A_REG_ADPBST_TIME1_REG	(0x0D)
#define AW87XXX_PID_5A_REG_ADPBST_TIME2_REG	(0x0E)
#define AW87XXX_PID_5A_REG_ADPBST_VTH_REG	(0x0F)
#define AW87XXX_PID_5A_REG_BOOST_PAR_REG	(0x10)
#define AW87XXX_PID_5A_REG_BOOST_VOUT_DET_REG	(0x57)
#define AW87XXX_PID_5A_REG_SYSST_REG	(0x58)
#define AW87XXX_PID_5A_REG_SYSINT_REG	(0x59)
#define AW87XXX_PID_5A_REG_DFT1R_REG	(0x60)
#define AW87XXX_PID_5A_REG_DFT2R_REG	(0x61)
#define AW87XXX_PID_5A_REG_DFT3R_REG	(0x62)
#define AW87XXX_PID_5A_REG_DFT4R_REG	(0x63)
#define AW87XXX_PID_5A_REG_DFT5R_REG	(0x64)
#define AW87XXX_PID_5A_REG_DFT6R_REG	(0x65)
#define AW87XXX_PID_5A_REG_DFT7R_REG	(0x66)
#define AW87XXX_PID_5A_REG_DFT8R_REG	(0x67)
#define AW87XXX_PID_5A_REG_DFT9R_REG	(0x68)
#define AW87XXX_PID_5A_REG_DFTAR_REG	(0x69)
#define AW87XXX_PID_5A_REG_DFTBR_REG	(0x70)
#define AW87XXX_PID_5A_REG_DFTCR_REG	(0x71)
#define AW87XXX_PID_5A_REG_DFTDR_REG	(0x72)
#define AW87XXX_PID_5A_REG_DFTER_REG	(0x73)
#define AW87XXX_PID_5A_REG_DFTFR_REG	(0x74)
#define AW87XXX_PID_5A_REG_test1_REG	(0x75)
#define AW87XXX_PID_5A_REG_test2_REG	(0x76)
#define AW87XXX_PID_5A_REG_ENCR_REG	(0x77)

#define AW87XXX_PID_5A_DFT3R_DEFAULT	(0x02)

/********************************************
 * soft control info
 * If you need to update this file, add this information manually
 *******************************************/
unsigned char aw87xxx_pid_5a_softrst_access[2] = {0x00, 0xaa};

/********************************************
 * Register Access
 *******************************************/
#define AW87XXX_PID_5A_REG_MAX		(0x78)

#define REG_NONE_ACCESS					(0)
#define REG_RD_ACCESS					(1 << 0)
#define REG_WR_ACCESS					(1 << 1)

const unsigned char aw87xxx_pid_5a_reg_access[AW87XXX_PID_5A_REG_MAX] = {
	[AW87XXX_PID_5A_REG_ID_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_5A_REG_SYSCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_BATSAFE_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_BSTOVR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_BSTCPR1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_BSTCPR2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_PAGR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_PAGC3OPR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_PAGC3PR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_PAGC2OPR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_PAGC2PR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_PAGC1PR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_ADP_MODE_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_ADPBST_TIME1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_ADPBST_TIME2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_ADPBST_VTH_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_BOOST_PAR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_BOOST_VOUT_DET_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_5A_REG_SYSST_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_5A_REG_SYSINT_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_5A_REG_DFT1R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT2R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT3R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT4R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT5R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT6R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT7R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT8R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFT9R_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFTAR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFTBR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFTCR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFTDR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFTER_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_DFTFR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_test1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_test2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_5A_REG_ENCR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
};

/* detail information of registers begin */
/* ID (0x00) detail */
/* IDCODE bit 7:0 (ID 0x00) */
#define AW87XXX_PID_5A_REG_IDCODE_START_BIT	(0)
#define AW87XXX_PID_5A_REG_IDCODE_BITS_LEN	(8)
#define AW87XXX_PID_5A_REG_IDCODE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_IDCODE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_IDCODE_START_BIT))

#define AW87XXX_PID_5A_REG_IDCODE_DEFAULT_VALUE	(0x5A)
#define AW87XXX_PID_5A_REG_IDCODE_DEFAULT	\
	(AW87XXX_PID_5A_REG_IDCODE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_IDCODE_START_BIT)

/* default value of ID (0x00) */
/* #define AW87XXX_PID_5A_REG_ID_DEFAULT		(0x5A) */

/* SYSCTRL (0x01) detail */
/* EN_SW bit 6 (SYSCTRL 0x01) */
#define AW87XXX_PID_5A_REG_EN_SW_START_BIT	(6)
#define AW87XXX_PID_5A_REG_EN_SW_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_SW_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_SW_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_SW_START_BIT))

#define AW87XXX_PID_5A_REG_EN_SW_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_SW_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_SW_DISABLE << AW87XXX_PID_5A_REG_EN_SW_START_BIT)

#define AW87XXX_PID_5A_REG_EN_SW_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_SW_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_SW_ENABLE << AW87XXX_PID_5A_REG_EN_SW_START_BIT)

#define AW87XXX_PID_5A_REG_EN_SW_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_SW_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_SW_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_SW_START_BIT)

/* EN_CP bit 5 (SYSCTRL 0x01) */
#define AW87XXX_PID_5A_REG_EN_CP_START_BIT	(5)
#define AW87XXX_PID_5A_REG_EN_CP_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_CP_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_CP_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_CP_START_BIT))

#define AW87XXX_PID_5A_REG_EN_CP_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_CP_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_CP_DISABLE << AW87XXX_PID_5A_REG_EN_CP_START_BIT)

#define AW87XXX_PID_5A_REG_EN_CP_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_CP_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_CP_ENABLE << AW87XXX_PID_5A_REG_EN_CP_START_BIT)

#define AW87XXX_PID_5A_REG_EN_CP_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_EN_CP_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_CP_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_CP_START_BIT)

/* EN_BOOST bit 4 (SYSCTRL 0x01) */
#define AW87XXX_PID_5A_REG_EN_BOOST_START_BIT	(4)
#define AW87XXX_PID_5A_REG_EN_BOOST_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_BOOST_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_BOOST_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_BOOST_START_BIT))

#define AW87XXX_PID_5A_REG_EN_BOOST_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_BOOST_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BOOST_DISABLE << AW87XXX_PID_5A_REG_EN_BOOST_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BOOST_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_BOOST_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BOOST_ENABLE << AW87XXX_PID_5A_REG_EN_BOOST_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BOOST_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_EN_BOOST_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_BOOST_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_BOOST_START_BIT)

/* EN_PA bit 3 (SYSCTRL 0x01) */
#define AW87XXX_PID_5A_REG_EN_PA_START_BIT	(3)
#define AW87XXX_PID_5A_REG_EN_PA_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_PA_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_PA_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_PA_START_BIT))

#define AW87XXX_PID_5A_REG_EN_PA_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_PA_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_PA_DISABLE << AW87XXX_PID_5A_REG_EN_PA_START_BIT)

#define AW87XXX_PID_5A_REG_EN_PA_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_PA_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_PA_ENABLE << AW87XXX_PID_5A_REG_EN_PA_START_BIT)

#define AW87XXX_PID_5A_REG_EN_PA_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_EN_PA_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_PA_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_PA_START_BIT)

/* RCV_MODE bit 2 (SYSCTRL 0x01) */
#define AW87XXX_PID_5A_REG_RCV_MODE_START_BIT	(2)
#define AW87XXX_PID_5A_REG_RCV_MODE_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_RCV_MODE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_RCV_MODE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_RCV_MODE_START_BIT))

#define AW87XXX_PID_5A_REG_RCV_MODE_DISABLE	(0)
#define AW87XXX_PID_5A_REG_RCV_MODE_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_RCV_MODE_DISABLE << AW87XXX_PID_5A_REG_RCV_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_RCV_MODE_ENABLE	(1)
#define AW87XXX_PID_5A_REG_RCV_MODE_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_RCV_MODE_ENABLE << AW87XXX_PID_5A_REG_RCV_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_RCV_MODE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_RCV_MODE_DEFAULT	\
	(AW87XXX_PID_5A_REG_RCV_MODE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_RCV_MODE_START_BIT)

/* EN_OVERLOAD bit 1 (SYSCTRL 0x01) */
#define AW87XXX_PID_5A_REG_EN_OVERLOAD_START_BIT	(1)
#define AW87XXX_PID_5A_REG_EN_OVERLOAD_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_OVERLOAD_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_OVERLOAD_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_OVERLOAD_START_BIT))

#define AW87XXX_PID_5A_REG_EN_OVERLOAD_DISABL	(0)
#define AW87XXX_PID_5A_REG_EN_OVERLOAD_DISABL_VALUE	\
	(AW87XXX_PID_5A_REG_EN_OVERLOAD_DISABL << AW87XXX_PID_5A_REG_EN_OVERLOAD_START_BIT)

#define AW87XXX_PID_5A_REG_EN_OVERLOAD_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_OVERLOAD_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_OVERLOAD_ENABLE << AW87XXX_PID_5A_REG_EN_OVERLOAD_START_BIT)

#define AW87XXX_PID_5A_REG_EN_OVERLOAD_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_OVERLOAD_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_OVERLOAD_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_OVERLOAD_START_BIT)

/* EN_HVBAT bit 0 (SYSCTRL 0x01) */
#define AW87XXX_PID_5A_REG_EN_HVBAT_START_BIT	(0)
#define AW87XXX_PID_5A_REG_EN_HVBAT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_HVBAT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_HVBAT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_HVBAT_START_BIT))

#define AW87XXX_PID_5A_REG_EN_HVBAT_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_HVBAT_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_HVBAT_DISABLE << AW87XXX_PID_5A_REG_EN_HVBAT_START_BIT)

#define AW87XXX_PID_5A_REG_EN_HVBAT_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_HVBAT_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_HVBAT_ENABLE << AW87XXX_PID_5A_REG_EN_HVBAT_START_BIT)

#define AW87XXX_PID_5A_REG_EN_HVBAT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_HVBAT_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_HVBAT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_HVBAT_START_BIT)

/* default value of SYSCTRL (0x01) */
/* #define AW87XXX_PID_5A_REG_SYSCTRL_DEFAULT		(0x38) */

/* BATSAFE (0x02) detail */
/* BAT_SFGD_DEGLITCH bit 6:5 (BATSAFE 0x02) */
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_START_BIT	(5)
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_START_BIT))

#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_1MS	(0)
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_1MS_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_1MS << AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_500US	(1)
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_500US_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_500US << AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_200US	(2)
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_200US_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_200US << AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_DISABLE	(3)
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_DISABLE << AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BAT_SFGD_DEGLITCH_START_BIT)

/* BAT_SFGD_VTH bit 4:3 (BATSAFE 0x02) */
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BAT_SFGD_VTH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BAT_SFGD_VTH_START_BIT))

#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P3V	(0)
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P3V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P3V << AW87XXX_PID_5A_REG_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P4V	(1)
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P4V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P4V << AW87XXX_PID_5A_REG_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P5V	(2)
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P5V << AW87XXX_PID_5A_REG_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P6V	(3)
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P6V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_VTH_3P6V << AW87XXX_PID_5A_REG_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BAT_SFGD_VTH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_VTH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BAT_SFGD_VTH_START_BIT)

/* EN_BAT_SFGD bit 2 (BATSAFE 0x02) */
#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_START_BIT	(2)
#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_BAT_SFGD_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_BAT_SFGD_START_BIT))

#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BAT_SFGD_DISABLE << AW87XXX_PID_5A_REG_EN_BAT_SFGD_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BAT_SFGD_ENABLE << AW87XXX_PID_5A_REG_EN_BAT_SFGD_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_BAT_SFGD_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_BAT_SFGD_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_BAT_SFGD_START_BIT)

/* BAT_SFGD_LEVEL bit 1:0 (BATSAFE 0x02) */
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_START_BIT))

#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_5V	(0)
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_5V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_5V << AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_5P5V	(1)
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_5P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_5P5V << AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_6V	(2)
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_6V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_6V << AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_6P5V	(3)
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_6P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_6P5V << AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_DEFAULT_VALUE	(0x01)
#define AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_DEFAULT	\
	(AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BAT_SFGD_LEVEL_START_BIT)

/* default value of BATSAFE (0x02) */
/* #define AW87XXX_PID_5A_REG_BATSAFE_DEFAULT		(0x09) */

/* BSTOVR (0x03) detail */
/* BST_VOUT bit 4:0 (BSTOVR 0x03) */
#define AW87XXX_PID_5A_REG_BST_VOUT_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_VOUT_BITS_LEN	(5)
#define AW87XXX_PID_5A_REG_BST_VOUT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_VOUT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT))

#define AW87XXX_PID_5A_REG_BST_VOUT_6P5V	(0)
#define AW87XXX_PID_5A_REG_BST_VOUT_6P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_6P5V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_6P75V	(1)
#define AW87XXX_PID_5A_REG_BST_VOUT_6P75V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_6P75V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_7P0V	(2)
#define AW87XXX_PID_5A_REG_BST_VOUT_7P0V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_7P0V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_7P25V	(3)
#define AW87XXX_PID_5A_REG_BST_VOUT_7P25V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_7P25V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_7P5V	(4)
#define AW87XXX_PID_5A_REG_BST_VOUT_7P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_7P5V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_7P75V	(5)
#define AW87XXX_PID_5A_REG_BST_VOUT_7P75V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_7P75V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_8P0V	(6)
#define AW87XXX_PID_5A_REG_BST_VOUT_8P0V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_8P0V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_8P25V	(7)
#define AW87XXX_PID_5A_REG_BST_VOUT_8P25V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_8P25V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_8P5V	(8)
#define AW87XXX_PID_5A_REG_BST_VOUT_8P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_8P5V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_8P75V	(9)
#define AW87XXX_PID_5A_REG_BST_VOUT_8P75V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_8P75V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_9P0V	(10)
#define AW87XXX_PID_5A_REG_BST_VOUT_9P0V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_9P0V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_9P25V	(11)
#define AW87XXX_PID_5A_REG_BST_VOUT_9P25V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_9P25V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_9P5V	(12)
#define AW87XXX_PID_5A_REG_BST_VOUT_9P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_9P5V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_9P75V	(13)
#define AW87XXX_PID_5A_REG_BST_VOUT_9P75V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_9P75V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_10P0V	(14)
#define AW87XXX_PID_5A_REG_BST_VOUT_10P0V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_10P0V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_10P25V	(15)
#define AW87XXX_PID_5A_REG_BST_VOUT_10P25V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_10P25V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_10P5V	(16)
#define AW87XXX_PID_5A_REG_BST_VOUT_10P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_10P5V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_10P75V	(17)
#define AW87XXX_PID_5A_REG_BST_VOUT_10P75V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_10P75V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_11P0V	(18)
#define AW87XXX_PID_5A_REG_BST_VOUT_11P0V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_11P0V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_11P25V	(19)
#define AW87XXX_PID_5A_REG_BST_VOUT_11P25V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_11P25V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_11P5V	(20)
#define AW87XXX_PID_5A_REG_BST_VOUT_11P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_11P5V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_11P75V	(21)
#define AW87XXX_PID_5A_REG_BST_VOUT_11P75V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_11P75V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_12P0V	(22)
#define AW87XXX_PID_5A_REG_BST_VOUT_12P0V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_12P0V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_12P25V	(23)
#define AW87XXX_PID_5A_REG_BST_VOUT_12P25V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_12P25V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_12P5V	(24)
#define AW87XXX_PID_5A_REG_BST_VOUT_12P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_VOUT_12P5V << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_VOUT_DEFAULT_VALUE	(0x0C)
#define AW87XXX_PID_5A_REG_BST_VOUT_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_VOUT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_VOUT_START_BIT)

/* default value of BSTOVR (0x03) */
/* #define AW87XXX_PID_5A_REG_BSTOVR_DEFAULT		(0x0C) */

/* BSTCPR1 (0x04) detail */
/* BURST_HYS_SELA bit 7 (BSTCPR1 0x04) */
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_START_BIT	(7)
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BURST_HYS_SELA_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BURST_HYS_SELA_START_BIT))

#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_3P3MV	(0)
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_3P3MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SELA_3P3MV << AW87XXX_PID_5A_REG_BURST_HYS_SELA_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_5MV	(1)
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_5MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SELA_5MV << AW87XXX_PID_5A_REG_BURST_HYS_SELA_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_8P3MV	(2)
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_8P3MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SELA_8P3MV << AW87XXX_PID_5A_REG_BURST_HYS_SELA_START_BIT)
/*
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_8P3MV	(3)
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_8P3MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SELA_8P3MV << AW87XXX_PID_5A_REG_BURST_HYS_SELA_START_BIT)
*/
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_DEFAULT_VALUE	(0)
#define AW87XXX_PID_5A_REG_BURST_HYS_SELA_DEFAULT	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SELA_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BURST_HYS_SELA_START_BIT)

/* BST_IPEAK_SS bit 6:5 (BSTCPR1 0x04) */
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_START_BIT	(5)
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_IPEAK_SS_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_IPEAK_SS_START_BIT))

#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_0P8A	(0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_0P8A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_SS_0P8A << AW87XXX_PID_5A_REG_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_1A	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_1A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_SS_1A << AW87XXX_PID_5A_REG_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_1P5A	(2)
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_1P5A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_SS_1P5A << AW87XXX_PID_5A_REG_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_2A	(3)
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_2A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_SS_2A << AW87XXX_PID_5A_REG_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_SS_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_SS_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_IPEAK_SS_START_BIT)

/* BST_IPEAK_ADJ bit 4 (BSTCPR1 0x04) */
#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_START_BIT))

#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_IPEAK	(0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_IPEAK_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_IPEAK << AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_IPEAK0P5A	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_IPEAK0P5A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_IPEAK0P5A << AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_IPEAK_ADJ_START_BIT)

/* BST_IPEAK_LOWBAT_EN bit 3 (BSTCPR1 0x04) */
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_START_BIT))

#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_DISABLE	(0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_DISABLE << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_ENABLE	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_ENABLE << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_EN_START_BIT)

/* BST_IPEAK_LOWBAT bit 2 (BSTCPR1 0x04) */
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_START_BIT	(2)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_START_BIT))

#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_2P5A	(0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_2P5A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_2P5A << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_2P75A	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_2P75A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_2P75A << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_IPEAK_LOWBAT_START_BIT)

/* BURST_HYS_SEL bit 1 (BSTCPR1 0x04) */
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_START_BIT	(1)
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BURST_HYS_SEL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BURST_HYS_SEL_START_BIT))

#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_3P3MV	(0)
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_3P3MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SEL_3P3MV << AW87XXX_PID_5A_REG_BURST_HYS_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_5MV	(1)
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_5MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SEL_5MV << AW87XXX_PID_5A_REG_BURST_HYS_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_8P3MV	(2)
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_8P3MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SEL_8P3MV << AW87XXX_PID_5A_REG_BURST_HYS_SEL_START_BIT)
/*
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_8P3MV	(3)
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_8P3MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SEL_8P3MV << AW87XXX_PID_5A_REG_BURST_HYS_SEL_START_BIT)
*/
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BURST_HYS_SEL_DEFAULT	\
	(AW87XXX_PID_5A_REG_BURST_HYS_SEL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BURST_HYS_SEL_START_BIT)

/* BURST_MODE bit 0 (BSTCPR1 0x04) */
#define AW87XXX_PID_5A_REG_BURST_MODE_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BURST_MODE_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BURST_MODE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BURST_MODE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BURST_MODE_START_BIT))

#define AW87XXX_PID_5A_REG_BURST_MODE_PVDD_DECIDE	(0)
#define AW87XXX_PID_5A_REG_BURST_MODE_PVDD_DECIDE_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_MODE_PVDD_DECIDE << AW87XXX_PID_5A_REG_BURST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_MODE_BUEST_PEAK_DECIDE	(1)
#define AW87XXX_PID_5A_REG_BURST_MODE_BUEST_PEAK_DECIDE_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_MODE_BUEST_PEAK_DECIDE << AW87XXX_PID_5A_REG_BURST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_MODE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BURST_MODE_DEFAULT	\
	(AW87XXX_PID_5A_REG_BURST_MODE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BURST_MODE_START_BIT)

/* default value of BSTCPR1 (0x04) */
/* #define AW87XXX_PID_5A_REG_BSTCPR1_DEFAULT		(0x00) */

/* BSTCPR2 (0x05) detail */
/* BURST_PEAK bit 5:4 (BSTCPR2 0x05) */
#define AW87XXX_PID_5A_REG_BURST_PEAK_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BURST_PEAK_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BURST_PEAK_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BURST_PEAK_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BURST_PEAK_START_BIT))

#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_660MV_HYS_800MV	(0)
#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_660MV_HYS_800MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_660MV_HYS_800MV << AW87XXX_PID_5A_REG_BURST_PEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_730MV_HYS_890MV	(1)
#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_730MV_HYS_890MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_730MV_HYS_890MV << AW87XXX_PID_5A_REG_BURST_PEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_780MV_HYS_930MV	(2)
#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_780MV_HYS_930MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_780MV_HYS_930MV << AW87XXX_PID_5A_REG_BURST_PEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_810MV_HYS_970MV	(3)
#define AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_810MV_HYS_970MV_VALUE	\
	(AW87XXX_PID_5A_REG_BURST_PEAK_CLAMP_810MV_HYS_970MV << AW87XXX_PID_5A_REG_BURST_PEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BURST_PEAK_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BURST_PEAK_DEFAULT	\
	(AW87XXX_PID_5A_REG_BURST_PEAK_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BURST_PEAK_START_BIT)

/* BST_IPEAK bit 3:0 (BSTCPR2 0x05) */
#define AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_BST_IPEAK_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_IPEAK_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT))

#define AW87XXX_PID_5A_REG_BST_IPEAK_1P5A	(0)
#define AW87XXX_PID_5A_REG_BST_IPEAK_1P5A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_1P5A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_1P75A	(1)
#define AW87XXX_PID_5A_REG_BST_IPEAK_1P75A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_1P75A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_2A	(2)
#define AW87XXX_PID_5A_REG_BST_IPEAK_2A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_2A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_2P25A	(3)
#define AW87XXX_PID_5A_REG_BST_IPEAK_2P25A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_2P25A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_2P5A	(4)
#define AW87XXX_PID_5A_REG_BST_IPEAK_2P5A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_2P5A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_2P75A	(5)
#define AW87XXX_PID_5A_REG_BST_IPEAK_2P75A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_2P75A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_3A	(6)
#define AW87XXX_PID_5A_REG_BST_IPEAK_3A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_3A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_3P25	(7)
#define AW87XXX_PID_5A_REG_BST_IPEAK_3P25_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_3P25 << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_3P5A	(8)
#define AW87XXX_PID_5A_REG_BST_IPEAK_3P5A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_3P5A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_3P75A	(9)
#define AW87XXX_PID_5A_REG_BST_IPEAK_3P75A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_3P75A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_4A	(10)
#define AW87XXX_PID_5A_REG_BST_IPEAK_4A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_4A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_4P25A	(11)
#define AW87XXX_PID_5A_REG_BST_IPEAK_4P25A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_4P25A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_4P5A	(12)
#define AW87XXX_PID_5A_REG_BST_IPEAK_4P5A_VALUE	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_4P5A << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_BST_IPEAK_DEFAULT_VALUE	(0x8)
#define AW87XXX_PID_5A_REG_BST_IPEAK_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_IPEAK_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_IPEAK_START_BIT)

/* default value of BSTCPR2 (0x05) */
/* #define AW87XXX_PID_5A_REG_BSTCPR2_DEFAULT		(0x08) */

/* PAGR (0x06) detail */
/* PA_GAIN bit 4:0 (PAGR 0x06) */
#define AW87XXX_PID_5A_REG_PA_GAIN_START_BIT	(0)
#define AW87XXX_PID_5A_REG_PA_GAIN_BITS_LEN	(5)
#define AW87XXX_PID_5A_REG_PA_GAIN_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_GAIN_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT))

#define AW87XXX_PID_5A_REG_PA_GAIN_0DB	(0)
#define AW87XXX_PID_5A_REG_PA_GAIN_0DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_0DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_1P5DB	(1)
#define AW87XXX_PID_5A_REG_PA_GAIN_1P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_1P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_3DB	(2)
#define AW87XXX_PID_5A_REG_PA_GAIN_3DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_3DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_4P5DB	(3)
#define AW87XXX_PID_5A_REG_PA_GAIN_4P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_4P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_6DB	(4)
#define AW87XXX_PID_5A_REG_PA_GAIN_6DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_6DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_7P5DB	(5)
#define AW87XXX_PID_5A_REG_PA_GAIN_7P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_7P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_9DB	(6)
#define AW87XXX_PID_5A_REG_PA_GAIN_9DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_9DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_10P5DB	(7)
#define AW87XXX_PID_5A_REG_PA_GAIN_10P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_10P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_12DB	(8)
#define AW87XXX_PID_5A_REG_PA_GAIN_12DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_12DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_13P5DB	(9)
#define AW87XXX_PID_5A_REG_PA_GAIN_13P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_13P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_15DB	(10)
#define AW87XXX_PID_5A_REG_PA_GAIN_15DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_15DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_16P5DB	(11)
#define AW87XXX_PID_5A_REG_PA_GAIN_16P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_16P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_18DB	(12)
#define AW87XXX_PID_5A_REG_PA_GAIN_18DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_18DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_19P5DB	(13)
#define AW87XXX_PID_5A_REG_PA_GAIN_19P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_19P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_21DB	(14)
#define AW87XXX_PID_5A_REG_PA_GAIN_21DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_21DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_22P5DB	(15)
#define AW87XXX_PID_5A_REG_PA_GAIN_22P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_22P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_24DB	(16)
#define AW87XXX_PID_5A_REG_PA_GAIN_24DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_24DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_25P5DB	(17)
#define AW87XXX_PID_5A_REG_PA_GAIN_25P5DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_25P5DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_27DB	(18)
#define AW87XXX_PID_5A_REG_PA_GAIN_27DB_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GAIN_27DB << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GAIN_DEFAULT_VALUE	(0x10)
#define AW87XXX_PID_5A_REG_PA_GAIN_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_GAIN_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_GAIN_START_BIT)

/* default value of PAGR (0x06) */
/* #define AW87XXX_PID_5A_REG_PAGR_DEFAULT		(0x10) */

/* PAGC3OPR (0x07) detail */
/* PAVG_ADJ bit 7:5 (PAGC3OPR 0x07) */
#define AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT	(5)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PAVG_ADJ_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT))

#define AW87XXX_PID_5A_REG_PAVG_ADJ_0P94PO	(0)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_0P94PO_VALUE	\
	(AW87XXX_PID_5A_REG_PAVG_ADJ_0P94PO << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_PAVG_ADJ_0P97PO	(1)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_0P97PO_VALUE	\
	(AW87XXX_PID_5A_REG_PAVG_ADJ_0P97PO << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P0PO	(2)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P0PO_VALUE	\
	(AW87XXX_PID_5A_REG_PAVG_ADJ_1P0PO << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P03PO	(3)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P03PO_VALUE	\
	(AW87XXX_PID_5A_REG_PAVG_ADJ_1P03PO << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P06PO	(4)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P06PO_VALUE	\
	(AW87XXX_PID_5A_REG_PAVG_ADJ_1P06PO << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P09PO	(5)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_1P09PO_VALUE	\
	(AW87XXX_PID_5A_REG_PAVG_ADJ_1P09PO << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_PAVG_ADJ_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_PAVG_ADJ_DEFAULT	\
	(AW87XXX_PID_5A_REG_PAVG_ADJ_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PAVG_ADJ_START_BIT)

/* PD_AGC3 bit 4 (PAGC3OPR 0x07) */
#define AW87XXX_PID_5A_REG_PD_AGC3_START_BIT	(4)
#define AW87XXX_PID_5A_REG_PD_AGC3_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PD_AGC3_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PD_AGC3_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PD_AGC3_START_BIT))

#define AW87XXX_PID_5A_REG_PD_AGC3_ENABLE	(0)
#define AW87XXX_PID_5A_REG_PD_AGC3_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PD_AGC3_ENABLE << AW87XXX_PID_5A_REG_PD_AGC3_START_BIT)

#define AW87XXX_PID_5A_REG_PD_AGC3_DISABLE	(1)
#define AW87XXX_PID_5A_REG_PD_AGC3_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PD_AGC3_DISABLE << AW87XXX_PID_5A_REG_PD_AGC3_START_BIT)

#define AW87XXX_PID_5A_REG_PD_AGC3_DEFAULT_VALUE	(0)
#define AW87XXX_PID_5A_REG_PD_AGC3_DEFAULT	\
	(AW87XXX_PID_5A_REG_PD_AGC3_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PD_AGC3_START_BIT)

/* AGC3_OUTPUT_POWER bit 3:0 (PAGC3OPR 0x07) */
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT	(0)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT))

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P5W8_OHM	(0)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P5W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P5W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P6W8_OHM	(1)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P6W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P6W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P7W8_OHM	(2)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P7W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P7W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P8W8_OHM	(3)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P8W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P8W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P9W8_OHM	(4)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P9W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_0P9W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P0W8_OHM	(5)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P0W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P0W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P1W8_OHM	(6)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P1W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P1W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P2W8_OHM	(7)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P2W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P2W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P3W8_OHM	(8)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P3W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P3W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P4W8_OHM	(9)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P4W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P4W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P5W8_OHM	(10)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P5W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P5W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P6W8_OHM	(11)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P6W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P6W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P7W8_OHM	(12)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P7W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P7W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P8W8_OHM	(13)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P8W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P8W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P9W8_OHM	(14)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P9W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_1P9W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_2P0W8_OHM	(15)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_2P0W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_2P0W8_OHM << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC3_OUTPUT_POWER_START_BIT)

/* default value of PAGC3OPR (0x07) */
/* #define AW87XXX_PID_5A_REG_PAGC3OPR_DEFAULT		(0x43) */

/* PAGC3PR (0x08) detail */
/* AGC3_REL_TIME bit 7:5 (PAGC3PR 0x08) */
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT	(5)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC3_REL_TIME_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT))

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_5P12MSDB	(0)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_5P12MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_5P12MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_10P24MSDB	(1)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_10P24MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_10P24MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_20P48MSDB	(2)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_20P48MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_20P48MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_40P96MSDB	(3)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_40P96MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_40P96MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_81P92MSDB	(4)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_81P92MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_81P92MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_163P84MSDB	(5)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_163P84MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_163P84MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_327P68MSDB	(6)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_327P68MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_327P68MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_655P36MSDB	(7)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_655P36MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_655P36MSDB << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_AGC3_REL_TIME_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC3_REL_TIME_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC3_REL_TIME_START_BIT)

/* AGC3_ATT_TIME bit 4:2 (PAGC3PR 0x08) */
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT	(2)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC3_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT))

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_1P28MSDB	(0)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_1P28MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_1P28MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_2P56MSDB	(1)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_2P56MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_2P56MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_10P24MSDB	(2)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_10P24MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_10P24MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_40P96MSDB	(3)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_40P96MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_40P96MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_82MSDB	(4)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_82MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_82MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_164MSDB	(5)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_164MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_164MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_328MSDB	(6)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_328MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_328MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_656MSDB	(7)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_656MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_656MSDB << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_5A_REG_AGC3_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC3_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC3_ATT_TIME_START_BIT)

/* AGC3_FIRST_ATT_TIME bit 1:0 (PAGC3PR 0x08) */
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_START_BIT	(0)
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_START_BIT))

#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_5P12MS	(0)
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_5P12MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_5P12MS << AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_10P24MS	(1)
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_10P24MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_10P24MS << AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_20P48MS	(2)
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_20P48MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_20P48MS << AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_41MS	(3)
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_41MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_41MS << AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC3_FIRST_ATT_TIME_START_BIT)

/* default value of PAGC3PR (0x08) */
/* #define AW87XXX_PID_5A_REG_PAGC3PR_DEFAULT		(0x4E) */

/* PAGC2OPR (0x09) detail */
/* AGC2_OUTPUT_POWER bit 3:0 (PAGC2OPR 0x09) */
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT	(0)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT))

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P0W8_OHM	(0)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P0W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P0W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P2W8_OHM	(1)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P2W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P2W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P4W8_OHM	(2)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P4W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P4W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P6W8_OHM	(3)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P6W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P6W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P8W8_OHM	(4)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P8W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_1P8W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P0W8_OHM	(5)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P0W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P0W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P2W8_OHM	(6)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P2W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P2W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P4W8_OHM	(7)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P4W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P4W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P6W8_OHM	(8)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P6W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P6W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P8W8_OHM	(9)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P8W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_2P8W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_3P0W8_OHM	(10)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_3P0W8_OHM_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_3P0W8_OHM << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_AGC2_OFF	(11)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_AGC2_OFF_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_AGC2_OFF << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC2_OUTPUT_POWER_START_BIT)

/* default value of PAGC2OPR (0x09) */
/* #define AW87XXX_PID_5A_REG_PAGC2OPR_DEFAULT		(0x03) */

/* PAGC2PR (0x0A) detail */
/* AGC2_ATT_TIME bit 4:2 (PAGC2PR 0x0A) */
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT	(2)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC2_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT))

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P16MSDB	(0)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P16MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P16MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P32MSDB	(1)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P32MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P32MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P64MSDB	(2)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P64MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_0P64MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_2P56MSDB	(3)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_2P56MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_2P56MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_10P24MSDB	(4)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_10P24MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_10P24MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_40P96MSDB	(5)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_40P96MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_40P96MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_82MSDB	(6)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_82MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_82MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_164MSDB	(7)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_164MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_164MSDB << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_AGC2_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC2_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC2_ATT_TIME_START_BIT)

/* AGC2_FIRST_ATT_TIME bit 1:0 (PAGC2PR 0x0A) */
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_START_BIT	(0)
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_START_BIT))

#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_0P08MS	(0)
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_0P08MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_0P08MS << AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_0P32MS	(1)
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_0P32MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_0P32MS << AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_1P28MS	(2)
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_1P28MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_1P28MS << AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_5P12MS	(3)
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_5P12MS_VALUE	\
	(AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_5P12MS << AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC2_FIRST_ATT_TIME_START_BIT)

/* default value of PAGC2PR (0x0A) */
/* #define AW87XXX_PID_5A_REG_PAGC2PR_DEFAULT		(0x08) */

/* PAGC1PR (0x0B) detail */
/* AGC1_OUTPUT_LEVEL bit 6:3 (PAGC1PR 0x0B) */
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT	(3)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT))

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5V	(0)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P2V	(1)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P2V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P2V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P4V	(2)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P4V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P4V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P6V	(3)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P6V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P6V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P8V	(4)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P8V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_5P8V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P0V	(5)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P0V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P0V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P2V	(6)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P2V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P2V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P4V	(7)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P4V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P4V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P6V	(8)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P6V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P6V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P8V	(9)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P8V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_6P8V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7V	(10)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P2V	(11)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P2V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P2V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P4V	(12)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P4V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P4V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P6V	(13)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P6V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P6V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P8V	(14)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P8V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_7P8V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_8V	(15)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_8V_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_8V << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_DEFAULT_VALUE	(0x9)
#define AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC1_OUTPUT_LEVEL_START_BIT)

/* AGC1_ATT_TIME bit 2:1 (PAGC1PR 0x0B) */
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT	(1)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC1_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT))

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P04MSDB	(0)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P04MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P04MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P08MSDB	(1)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P08MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P08MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P16MSDB	(2)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P16MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P16MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P32MSDB	(3)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P32MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P32MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P02MSDB	(4)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P02MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P02MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P01MSDB	(5)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P01MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P01MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P005MSDB	(6)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P005MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P005MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)
/*
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P005MSDB	(7)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P005MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_0P005MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)
*/
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC1_ATT_TIME_START_BIT)

/* PD_AGC1 bit 0 (PAGC1PR 0x0B) */
#define AW87XXX_PID_5A_REG_PD_AGC1_START_BIT	(0)
#define AW87XXX_PID_5A_REG_PD_AGC1_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PD_AGC1_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PD_AGC1_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PD_AGC1_START_BIT))

#define AW87XXX_PID_5A_REG_PD_AGC1_ENABLE	(0)
#define AW87XXX_PID_5A_REG_PD_AGC1_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PD_AGC1_ENABLE << AW87XXX_PID_5A_REG_PD_AGC1_START_BIT)

#define AW87XXX_PID_5A_REG_PD_AGC1_DISABLE	(1)
#define AW87XXX_PID_5A_REG_PD_AGC1_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PD_AGC1_DISABLE << AW87XXX_PID_5A_REG_PD_AGC1_START_BIT)

#define AW87XXX_PID_5A_REG_PD_AGC1_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PD_AGC1_DEFAULT	\
	(AW87XXX_PID_5A_REG_PD_AGC1_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PD_AGC1_START_BIT)

/* default value of PAGC1PR (0x0B) */
/* #define AW87XXX_PID_5A_REG_PAGC1PR_DEFAULT		(0x4A) */

/* ADP_MODE (0x0C) detail */
/* AGC1_ATT_TIMEA bit 3 (ADP_MODE 0x0C) */
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT	(3)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT))

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P04MSDB	(0)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P04MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P04MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P08MSDB	(1)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P08MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P08MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P16MSDB	(2)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P16MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P16MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P32MSDB	(3)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P32MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P32MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P02MSDB	(4)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P02MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P02MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P01MSDB	(5)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P01MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P01MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P005MSDB	(6)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P005MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P005MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)
/*
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P005MSDB	(7)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P005MSDB_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_0P005MSDB << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)
*/
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_DEFAULT_VALUE	(0)
#define AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC1_ATT_TIMEA_START_BIT)

/* ADPBOOST_MODE bit 2:0 (ADP_MODE 0x0C) */
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT	(0)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_ADPBOOST_MODE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT))

#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_PASS_THROUGH	(0)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_PASS_THROUGH_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_PASS_THROUGH << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_FORCE_BOOST	(1)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_FORCE_BOOST_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_FORCE_BOOST << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD1	(2)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD1_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD1 << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD2	(3)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD2_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD2 << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD3	(4)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD3_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD3 << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD4	(5)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD4_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD4 << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD5	(6)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD5_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD5 << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)
/*
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD2	(7)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD2_VALUE	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_MD2 << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)
*/
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_5A_REG_ADPBOOST_MODE_DEFAULT	\
	(AW87XXX_PID_5A_REG_ADPBOOST_MODE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_ADPBOOST_MODE_START_BIT)

/* default value of ADP_MODE (0x0C) */
/* #define AW87XXX_PID_5A_REG_ADP_MODE_DEFAULT		(0x03) */

/* ADPBST_TIME1 (0x0D) detail */
/* ADP_BST_TIME_2W bit 7:4 (ADPBST_TIME1 0x0D) */
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT	(4)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_BITS_LEN)-1) << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT))

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_1P25MS	(0)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_1P25MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_1P25MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_2P5MS	(1)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_2P5MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_2P5MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_5MS	(2)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_5MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_5MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_10MS	(3)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_10MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_10MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_15MS	(4)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_15MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_15MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_20MS	(5)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_20MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_20MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_30MS	(6)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_30MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_30MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_40MS	(7)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_40MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_40MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_65MS	(8)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_65MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_65MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_80MS	(9)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_80MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_80MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_100MS	(10)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_100MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_100MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_120MS	(11)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_120MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_120MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_140MS	(12)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_140MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_140MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_160MS	(13)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_160MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_160MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_320MS	(14)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_320MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_320MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_480MS	(15)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_480MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_480MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_DEFAULT_VALUE	(0xD)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_DEFAULT	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_DEFAULT_VALUE << AW87XXX_PID_5A_REG_ADP_BST_TIME_2W_START_BIT)

/* ADP_BST_TIME_0P4W bit 3:0 (ADPBST_TIME1 0x0D) */
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT	(0)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_BITS_LEN)-1) << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT))

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_1P25MS	(0)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_1P25MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_1P25MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_2P5MS	(1)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_2P5MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_2P5MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_5MS	(2)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_5MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_5MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_10MS	(3)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_10MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_10MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_15MS	(4)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_15MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_15MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_20MS	(5)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_20MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_20MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_30MS	(6)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_30MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_30MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_40MS	(7)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_40MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_40MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_65MS	(8)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_65MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_65MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_80MS	(9)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_80MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_80MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_100MS	(10)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_100MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_100MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_120MS	(11)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_120MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_120MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_140MS	(12)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_140MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_140MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_160MS	(13)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_160MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_160MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_320MS	(14)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_320MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_320MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_480MS	(15)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_480MS_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_480MS << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_DEFAULT_VALUE	(0xD)
#define AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_DEFAULT	\
	(AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_DEFAULT_VALUE << AW87XXX_PID_5A_REG_ADP_BST_TIME_0P4W_START_BIT)

/* default value of ADPBST_TIME1 (0x0D) */
/* #define AW87XXX_PID_5A_REG_ADPBST_TIME1_DEFAULT		(0xDD) */

/* ADPBST_TIME2 (0x0E) detail */
/* BST_UP_DT bit 7:4 (ADPBST_TIME2 0x0E) */
#define AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_UP_DT_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_BST_UP_DT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_UP_DT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT))

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P005MS	(0)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P005MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P005MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P01MS	(1)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P01MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P01MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P015MS	(2)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P015MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P015MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P02MS	(3)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P02MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P02MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P03MS	(4)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P03MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P03MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P04MS	(5)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P04MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P04MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P05MS	(6)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P05MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P05MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P06MS	(7)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P06MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P06MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P07MS	(8)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P07MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P07MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P08MS	(9)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P08MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P08MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P10MS	(10)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P10MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P10MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P16MS	(11)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P16MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P16MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P20MS	(12)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P20MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P20MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P32MS	(13)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P32MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P32MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_0P64MS	(14)
#define AW87XXX_PID_5A_REG_BST_UP_DT_0P64MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_0P64MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_1P28MS	(15)
#define AW87XXX_PID_5A_REG_BST_UP_DT_1P28MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_1P28MS << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_UP_DT_DEFAULT_VALUE	(0x7)
#define AW87XXX_PID_5A_REG_BST_UP_DT_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_UP_DT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_UP_DT_START_BIT)

/* BST_DOWN_TD bit 3:0 (ADPBST_TIME2 0x0E) */
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_BITS_LEN	(4)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_DOWN_TD_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT))

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P01MS	(0)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P01MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P01MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P02MS	(1)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P02MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P02MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P04MS	(2)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P04MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P04MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P08MS	(3)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P08MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P08MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P12MS	(4)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P12MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P12MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P16MS	(5)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P16MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P16MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P24MS	(6)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P24MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P24MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P32MS	(7)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P32MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P32MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P64MS	(8)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P64MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P64MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P96MS	(9)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_0P96MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_0P96MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_1P28MS	(10)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_1P28MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_1P28MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_1P60MS	(11)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_1P60MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_1P60MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_1P92MS	(12)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_1P92MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_1P92MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_2P56MS	(13)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_2P56MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_2P56MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_5P12MS	(14)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_5P12MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_5P12MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_10P24MS	(15)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_10P24MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_10P24MS << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DOWN_TD_DEFAULT_VALUE	(0xA)
#define AW87XXX_PID_5A_REG_BST_DOWN_TD_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_DOWN_TD_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_DOWN_TD_START_BIT)

/* default value of ADPBST_TIME2 (0x0E) */
/* #define AW87XXX_PID_5A_REG_ADPBST_TIME2_DEFAULT		(0x7A) */

/* ADPBST_VTH (0x0F) detail */
/* ADP_LOW_STEP bit 7:6 (ADPBST_VTH 0x0F) */
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_START_BIT	(6)
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_ADP_LOW_STEP_BITS_LEN)-1) << AW87XXX_PID_5A_REG_ADP_LOW_STEP_START_BIT))

#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00000	(0)
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00000_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00000 << AW87XXX_PID_5A_REG_ADP_LOW_STEP_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00001	(1)
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00001_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00001 << AW87XXX_PID_5A_REG_ADP_LOW_STEP_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00010	(2)
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00010_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00010 << AW87XXX_PID_5A_REG_ADP_LOW_STEP_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00011	(3)
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00011_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_LOW_STEP_1ST_BST_OUT00011 << AW87XXX_PID_5A_REG_ADP_LOW_STEP_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_ADP_LOW_STEP_DEFAULT	\
	(AW87XXX_PID_5A_REG_ADP_LOW_STEP_DEFAULT_VALUE << AW87XXX_PID_5A_REG_ADP_LOW_STEP_START_BIT)

/* SET_BOOST_VTH2 bit 5:3 (ADPBST_VTH 0x0F) */
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT	(3)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_SET_BOOST_VTH2_BITS_LEN)-1) << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT))

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P2W	(0)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P2W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P2W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P4W	(1)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P4W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P4W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P6W	(2)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P6W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P6W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P8W	(3)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P8W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_1P8W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P0W	(4)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P0W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P0W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P2W	(5)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P2W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P2W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P4W	(6)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P4W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P4W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)
/*
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P4W	(7)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P4W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_2P4W << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)
*/
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH2_DEFAULT	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH2_DEFAULT_VALUE << AW87XXX_PID_5A_REG_SET_BOOST_VTH2_START_BIT)

/* SET_BOOST_VTH1 bit 2:0 (ADPBST_VTH 0x0F) */
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT	(0)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_SET_BOOST_VTH1_BITS_LEN)-1) << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT))

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P1W	(0)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P1W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P1W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P2W	(1)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P2W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P2W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P3W	(2)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P3W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P3W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P4W	(3)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P4W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P4W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P5W	(4)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P5W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P5W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W	(5)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)
/*
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W	(6)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W	(7)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W_VALUE	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_0P6W << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)
*/
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_5A_REG_SET_BOOST_VTH1_DEFAULT	\
	(AW87XXX_PID_5A_REG_SET_BOOST_VTH1_DEFAULT_VALUE << AW87XXX_PID_5A_REG_SET_BOOST_VTH1_START_BIT)

/* default value of ADPBST_VTH (0x0F) */
/* #define AW87XXX_PID_5A_REG_ADPBST_VTH_DEFAULT		(0x23) */

/* BOOST_PAR (0x10) detail */
/* CLKDLY_SELECT bit 7 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_START_BIT	(7)
#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CLKDLY_SELECT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CLKDLY_SELECT_START_BIT))

#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_DELAY_CLK_CHOOSE_CLK_DLY	(0)
#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_DELAY_CLK_CHOOSE_CLK_DLY_VALUE	\
	(AW87XXX_PID_5A_REG_CLKDLY_SELECT_DELAY_CLK_CHOOSE_CLK_DLY << AW87XXX_PID_5A_REG_CLKDLY_SELECT_START_BIT)

#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_DELAY_CLK_CHOOSE_MAXIM_DUTY	(1)
#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_DELAY_CLK_CHOOSE_MAXIM_DUTY_VALUE	\
	(AW87XXX_PID_5A_REG_CLKDLY_SELECT_DELAY_CLK_CHOOSE_MAXIM_DUTY << AW87XXX_PID_5A_REG_CLKDLY_SELECT_START_BIT)

#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_CLKDLY_SELECT_DEFAULT	\
	(AW87XXX_PID_5A_REG_CLKDLY_SELECT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CLKDLY_SELECT_START_BIT)

/* CPOK_VBGOK bit 6 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_CPOK_VBGOK_START_BIT	(6)
#define AW87XXX_PID_5A_REG_CPOK_VBGOK_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_CPOK_VBGOK_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CPOK_VBGOK_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CPOK_VBGOK_START_BIT))

#define AW87XXX_PID_5A_REG_CPOK_VBGOK_ENABLE_CPOK	(0)
#define AW87XXX_PID_5A_REG_CPOK_VBGOK_ENABLE_CPOK_VALUE	\
	(AW87XXX_PID_5A_REG_CPOK_VBGOK_ENABLE_CPOK << AW87XXX_PID_5A_REG_CPOK_VBGOK_START_BIT)

#define AW87XXX_PID_5A_REG_CPOK_VBGOK_ENABLE_VBGOK	(1)
#define AW87XXX_PID_5A_REG_CPOK_VBGOK_ENABLE_VBGOK_VALUE	\
	(AW87XXX_PID_5A_REG_CPOK_VBGOK_ENABLE_VBGOK << AW87XXX_PID_5A_REG_CPOK_VBGOK_START_BIT)

#define AW87XXX_PID_5A_REG_CPOK_VBGOK_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_CPOK_VBGOK_DEFAULT	\
	(AW87XXX_PID_5A_REG_CPOK_VBGOK_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CPOK_VBGOK_START_BIT)

/* EN_LOWBAT_ADJ bit 5 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_START_BIT	(5)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_START_BIT))

#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_DISABLE << AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_ENABLE << AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_START_BIT)

#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_LOWBAT_ADJ_START_BIT)

/* EN_ADP_MODE1_DEGLITCH bit 4 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_START_BIT	(4)
#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_START_BIT))

#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_DISABLE << AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_START_BIT)

#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_ENABLE << AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_START_BIT)

#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_ADP_MODE1_DEGLITCH_START_BIT)

/* EN_VCLAMP_MIN_VTH bit 3 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_START_BIT	(3)
#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_START_BIT))

#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_DISABLE << AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_ENABLE << AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_VCLAMP_MIN_VTH_START_BIT)

/* SS_ADP_BIAS bit 2 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_START_BIT	(2)
#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_SS_ADP_BIAS_BITS_LEN)-1) << AW87XXX_PID_5A_REG_SS_ADP_BIAS_START_BIT))

#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_SS_ADP_BIAS_4UA	(0)
#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_SS_ADP_BIAS_4UA_VALUE	\
	(AW87XXX_PID_5A_REG_SS_ADP_BIAS_SS_ADP_BIAS_4UA << AW87XXX_PID_5A_REG_SS_ADP_BIAS_START_BIT)

#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_SS_ADP_BIAS_8UA	(1)
#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_SS_ADP_BIAS_8UA_VALUE	\
	(AW87XXX_PID_5A_REG_SS_ADP_BIAS_SS_ADP_BIAS_8UA << AW87XXX_PID_5A_REG_SS_ADP_BIAS_START_BIT)

#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_SS_ADP_BIAS_DEFAULT	\
	(AW87XXX_PID_5A_REG_SS_ADP_BIAS_DEFAULT_VALUE << AW87XXX_PID_5A_REG_SS_ADP_BIAS_START_BIT)

/* BOOST_VTH1_0P1W_0P2W bit 1 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_START_BIT	(1)
#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_START_BIT))

#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BOOST_VTH1_0P1W	(0)
#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BOOST_VTH1_0P1W_VALUE	\
	(AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BOOST_VTH1_0P1W << AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_START_BIT)

#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BOOST_VTH1_0P2W	(1)
#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BOOST_VTH1_0P2W_VALUE	\
	(AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_BOOST_VTH1_0P2W << AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_START_BIT)

#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_DEFAULT	\
	(AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BOOST_VTH1_0P1W_0P2W_START_BIT)

/* EN_LOWBAT_BOOST_VTH1 bit 0 (BOOST_PAR 0x10) */
#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_START_BIT	(0)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_START_BIT))

#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_DISABLE << AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_ENABLE << AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_LOWBAT_BOOST_VTH1_START_BIT)

/* default value of BOOST_PAR (0x10) */
/* #define AW87XXX_PID_5A_REG_BOOST_PAR_DEFAULT		(0x08) */

/* BOOST_VOUT_DET (0x57) detail */
/* ADP_BOOST_VOUT bit 4:0 (BOOST_VOUT_DET 0x57) */
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT	(0)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_BITS_LEN	(5)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT))

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_6P5V	(0)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_6P5V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_6P5V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_6P75V	(1)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_6P75V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_6P75V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P0V	(2)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P0V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P0V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P25V	(3)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P25V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P25V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P5V	(4)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P5V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P5V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P75V	(5)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P75V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_7P75V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P0V	(6)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P0V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P0V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P25V	(7)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P25V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P25V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P5V	(8)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P5V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P5V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P75V	(9)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P75V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_8P75V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P0V	(10)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P0V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P0V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P25V	(11)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P25V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P25V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P5V	(12)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P5V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P5V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P75V	(13)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P75V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_9P75V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P0V	(14)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P0V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P0V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P25V	(15)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P25V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P25V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P5V	(16)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P5V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P5V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P75V	(17)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P75V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_10P75V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P0V	(18)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P0V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P0V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P25V	(19)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P25V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P25V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P5V	(20)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P5V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P5V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P75V	(21)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P75V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_11P75V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P0V	(22)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P0V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P0V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P25V	(23)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P25V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P25V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P5V	(24)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P5V_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_12P5V << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_DEFAULT_VALUE	(0x0C)
#define AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_DEFAULT	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_ADP_BOOST_VOUT_START_BIT)

/* default value of BOOST_VOUT_DET (0x57) */
/* #define AW87XXX_PID_5A_REG_BOOST_VOUT_DET_DEFAULT		(0x0C) */

/* SYSST (0x58) detail */
/* UVLO_S bit 7 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_UVLO_S_START_BIT	(7)
#define AW87XXX_PID_5A_REG_UVLO_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_UVLO_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_UVLO_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_UVLO_S_START_BIT))

#define AW87XXX_PID_5A_REG_UVLO_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_UVLO_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_S_NORMAL_OPERATION << AW87XXX_PID_5A_REG_UVLO_S_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_S_VBAT_UNDER_VOLTAGE	(1)
#define AW87XXX_PID_5A_REG_UVLO_S_VBAT_UNDER_VOLTAGE_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_S_VBAT_UNDER_VOLTAGE << AW87XXX_PID_5A_REG_UVLO_S_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_UVLO_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_UVLO_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_UVLO_S_START_BIT)

/* LOW_BATT_S bit 6 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_LOW_BATT_S_START_BIT	(6)
#define AW87XXX_PID_5A_REG_LOW_BATT_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_LOW_BATT_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_LOW_BATT_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_LOW_BATT_S_START_BIT))

#define AW87XXX_PID_5A_REG_LOW_BATT_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_LOW_BATT_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_LOW_BATT_S_NORMAL_OPERATION << AW87XXX_PID_5A_REG_LOW_BATT_S_START_BIT)

#define AW87XXX_PID_5A_REG_LOW_BATT_S_LOW_VBAT_DETECTED	(1)
#define AW87XXX_PID_5A_REG_LOW_BATT_S_LOW_VBAT_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_LOW_BATT_S_LOW_VBAT_DETECTED << AW87XXX_PID_5A_REG_LOW_BATT_S_START_BIT)

#define AW87XXX_PID_5A_REG_LOW_BATT_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_LOW_BATT_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_LOW_BATT_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_LOW_BATT_S_START_BIT)

/* BST_OVP_S bit 5 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_BST_OVP_S_START_BIT	(5)
#define AW87XXX_PID_5A_REG_BST_OVP_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_OVP_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP_S_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_BST_OVP_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP_S_NORMAL_OPERATION << AW87XXX_PID_5A_REG_BST_OVP_S_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP_S_BOOST_OVER_VOLTAGE_PROTECTION	(1)
#define AW87XXX_PID_5A_REG_BST_OVP_S_BOOST_OVER_VOLTAGE_PROTECTION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP_S_BOOST_OVER_VOLTAGE_PROTECTION << AW87XXX_PID_5A_REG_BST_OVP_S_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_OVP_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP_S_START_BIT)

/* BST_OVP2_S bit 4 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_BST_OVP2_S_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_OVP2_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP2_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP2_S_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP2_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_BST_OVP2_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_S_NORMAL_OPERATION << AW87XXX_PID_5A_REG_BST_OVP2_S_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_S_BOOST_HEAVY_LOAD_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_S_BOOST_HEAVY_LOAD_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_S_BOOST_HEAVY_LOAD_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_BST_OVP2_S_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_OVP2_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP2_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP2_S_START_BIT)

/* BST_SCP_S bit 3 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_BST_SCP_S_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_SCP_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_SCP_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_SCP_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_SCP_S_START_BIT))

#define AW87XXX_PID_5A_REG_BST_SCP_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_BST_SCP_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SCP_S_NORMAL_OPERATION << AW87XXX_PID_5A_REG_BST_SCP_S_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SCP_S_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_BST_SCP_S_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SCP_S_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_BST_SCP_S_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SCP_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_SCP_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_SCP_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_SCP_S_START_BIT)

/* PA_OC_S bit 2 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_PA_OC_S_START_BIT	(2)
#define AW87XXX_PID_5A_REG_PA_OC_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PA_OC_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_OC_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_OC_S_START_BIT))

#define AW87XXX_PID_5A_REG_PA_OC_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_PA_OC_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_S_NORMAL_OPERATION << AW87XXX_PID_5A_REG_PA_OC_S_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_S_PA_OVER_CURRENT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_PA_OC_S_PA_OVER_CURRENT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_S_PA_OVER_CURRENT_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_PA_OC_S_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_PA_OC_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_OC_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_OC_S_START_BIT)

/* OT160_S bit 1 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_OT160_S_START_BIT	(1)
#define AW87XXX_PID_5A_REG_OT160_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_OT160_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_OT160_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_OT160_S_START_BIT))

#define AW87XXX_PID_5A_REG_OT160_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_OT160_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_OT160_S_NORMAL_OPERATION << AW87XXX_PID_5A_REG_OT160_S_START_BIT)

#define AW87XXX_PID_5A_REG_OT160_S_PA_OVER_TEMPRETURE_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_OT160_S_PA_OVER_TEMPRETURE_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_OT160_S_PA_OVER_TEMPRETURE_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_OT160_S_START_BIT)

#define AW87XXX_PID_5A_REG_OT160_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_OT160_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_OT160_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_OT160_S_START_BIT)

/* ADP_BOOST_S bit 0 (SYSST 0x58) */
#define AW87XXX_PID_5A_REG_ADP_BOOST_S_START_BIT	(0)
#define AW87XXX_PID_5A_REG_ADP_BOOST_S_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_ADP_BOOST_S_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_ADP_BOOST_S_BITS_LEN)-1) << AW87XXX_PID_5A_REG_ADP_BOOST_S_START_BIT))

#define AW87XXX_PID_5A_REG_ADP_BOOST_S_DIRECT_MODE	(0)
#define AW87XXX_PID_5A_REG_ADP_BOOST_S_DIRECT_MODE_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_S_DIRECT_MODE << AW87XXX_PID_5A_REG_ADP_BOOST_S_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_S_BOOST_MODE	(1)
#define AW87XXX_PID_5A_REG_ADP_BOOST_S_BOOST_MODE_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_S_BOOST_MODE << AW87XXX_PID_5A_REG_ADP_BOOST_S_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_ADP_BOOST_S_DEFAULT	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_S_DEFAULT_VALUE << AW87XXX_PID_5A_REG_ADP_BOOST_S_START_BIT)

/* default value of SYSST (0x58) */
/* #define AW87XXX_PID_5A_REG_SYSST_DEFAULT		(0xFF) */

/* SYSINT (0x59) detail */
/* UVLO_I bit 7 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_UVLO_I_START_BIT	(7)
#define AW87XXX_PID_5A_REG_UVLO_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_UVLO_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_UVLO_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_UVLO_I_START_BIT))

#define AW87XXX_PID_5A_REG_UVLO_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_UVLO_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_I_NORMAL_OPERATION << AW87XXX_PID_5A_REG_UVLO_I_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_I_VBAT_UNDER_VOLTAGE	(1)
#define AW87XXX_PID_5A_REG_UVLO_I_VBAT_UNDER_VOLTAGE_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_I_VBAT_UNDER_VOLTAGE << AW87XXX_PID_5A_REG_UVLO_I_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_UVLO_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_UVLO_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_UVLO_I_START_BIT)

/* LOW_BATT_I bit 6 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_LOW_BATT_I_START_BIT	(6)
#define AW87XXX_PID_5A_REG_LOW_BATT_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_LOW_BATT_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_LOW_BATT_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_LOW_BATT_I_START_BIT))

#define AW87XXX_PID_5A_REG_LOW_BATT_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_LOW_BATT_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_LOW_BATT_I_NORMAL_OPERATION << AW87XXX_PID_5A_REG_LOW_BATT_I_START_BIT)

#define AW87XXX_PID_5A_REG_LOW_BATT_I_LOW_VBAT_DETECTED	(1)
#define AW87XXX_PID_5A_REG_LOW_BATT_I_LOW_VBAT_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_LOW_BATT_I_LOW_VBAT_DETECTED << AW87XXX_PID_5A_REG_LOW_BATT_I_START_BIT)

#define AW87XXX_PID_5A_REG_LOW_BATT_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_LOW_BATT_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_LOW_BATT_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_LOW_BATT_I_START_BIT)

/* BST_OVP_I bit 5 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_BST_OVP_I_START_BIT	(5)
#define AW87XXX_PID_5A_REG_BST_OVP_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_OVP_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP_I_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_BST_OVP_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP_I_NORMAL_OPERATION << AW87XXX_PID_5A_REG_BST_OVP_I_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP_I_BOOST_OVER_VOLTAGE_PROTECTION	(1)
#define AW87XXX_PID_5A_REG_BST_OVP_I_BOOST_OVER_VOLTAGE_PROTECTION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP_I_BOOST_OVER_VOLTAGE_PROTECTION << AW87XXX_PID_5A_REG_BST_OVP_I_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_OVP_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP_I_START_BIT)

/* BST_OVP2_I bit 4 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_BST_OVP2_I_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_OVP2_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP2_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP2_I_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP2_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_BST_OVP2_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_I_NORMAL_OPERATION << AW87XXX_PID_5A_REG_BST_OVP2_I_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_I_BOOST_HEAVY_LOAD_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_I_BOOST_HEAVY_LOAD_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_I_BOOST_HEAVY_LOAD_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_BST_OVP2_I_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_OVP2_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP2_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP2_I_START_BIT)

/* BST_SCP_I bit 3 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_BST_SCP_I_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_SCP_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_SCP_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_SCP_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_SCP_I_START_BIT))

#define AW87XXX_PID_5A_REG_BST_SCP_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_BST_SCP_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SCP_I_NORMAL_OPERATION << AW87XXX_PID_5A_REG_BST_SCP_I_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SCP_I_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_BST_SCP_I_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SCP_I_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_BST_SCP_I_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SCP_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_SCP_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_SCP_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_SCP_I_START_BIT)

/* PA_OC_I bit 2 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_PA_OC_I_START_BIT	(2)
#define AW87XXX_PID_5A_REG_PA_OC_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PA_OC_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_OC_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_OC_I_START_BIT))

#define AW87XXX_PID_5A_REG_PA_OC_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_PA_OC_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_I_NORMAL_OPERATION << AW87XXX_PID_5A_REG_PA_OC_I_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_I_PA_OVER_CURRENT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_PA_OC_I_PA_OVER_CURRENT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_I_PA_OVER_CURRENT_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_PA_OC_I_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_PA_OC_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_OC_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_OC_I_START_BIT)

/* OT160_I bit 1 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_OT160_I_START_BIT	(1)
#define AW87XXX_PID_5A_REG_OT160_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_OT160_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_OT160_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_OT160_I_START_BIT))

#define AW87XXX_PID_5A_REG_OT160_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_5A_REG_OT160_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_5A_REG_OT160_I_NORMAL_OPERATION << AW87XXX_PID_5A_REG_OT160_I_START_BIT)

#define AW87XXX_PID_5A_REG_OT160_I_PA_OVER_TEMPRETURE_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_5A_REG_OT160_I_PA_OVER_TEMPRETURE_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_5A_REG_OT160_I_PA_OVER_TEMPRETURE_PROTECTION_DETECTED << AW87XXX_PID_5A_REG_OT160_I_START_BIT)

#define AW87XXX_PID_5A_REG_OT160_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_OT160_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_OT160_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_OT160_I_START_BIT)

/* ADP_BOOST_I bit 0 (SYSINT 0x59) */
#define AW87XXX_PID_5A_REG_ADP_BOOST_I_START_BIT	(0)
#define AW87XXX_PID_5A_REG_ADP_BOOST_I_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_ADP_BOOST_I_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_ADP_BOOST_I_BITS_LEN)-1) << AW87XXX_PID_5A_REG_ADP_BOOST_I_START_BIT))

#define AW87XXX_PID_5A_REG_ADP_BOOST_I_DIRECT_MODE	(0)
#define AW87XXX_PID_5A_REG_ADP_BOOST_I_DIRECT_MODE_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_I_DIRECT_MODE << AW87XXX_PID_5A_REG_ADP_BOOST_I_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_I_BOOST_MODE	(1)
#define AW87XXX_PID_5A_REG_ADP_BOOST_I_BOOST_MODE_VALUE	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_I_BOOST_MODE << AW87XXX_PID_5A_REG_ADP_BOOST_I_START_BIT)

#define AW87XXX_PID_5A_REG_ADP_BOOST_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_ADP_BOOST_I_DEFAULT	\
	(AW87XXX_PID_5A_REG_ADP_BOOST_I_DEFAULT_VALUE << AW87XXX_PID_5A_REG_ADP_BOOST_I_START_BIT)

/* default value of SYSINT (0x59) */
/* #define AW87XXX_PID_5A_REG_SYSINT_DEFAULT		(0xFF) */

/* DFT1R (0x60) detail */
/* CP_FREQ bit 7:6 (DFT1R 0x60) */
#define AW87XXX_PID_5A_REG_CP_FREQ_START_BIT	(6)
#define AW87XXX_PID_5A_REG_CP_FREQ_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_CP_FREQ_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CP_FREQ_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CP_FREQ_START_BIT))

#define AW87XXX_PID_5A_REG_CP_FREQ_4P8MHZ	(0)
#define AW87XXX_PID_5A_REG_CP_FREQ_4P8MHZ_VALUE	\
	(AW87XXX_PID_5A_REG_CP_FREQ_4P8MHZ << AW87XXX_PID_5A_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_5A_REG_CP_FREQ_6P4MHZ	(1)
#define AW87XXX_PID_5A_REG_CP_FREQ_6P4MHZ_VALUE	\
	(AW87XXX_PID_5A_REG_CP_FREQ_6P4MHZ << AW87XXX_PID_5A_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_5A_REG_CP_FREQ_8P0MHZ	(2)
#define AW87XXX_PID_5A_REG_CP_FREQ_8P0MHZ_VALUE	\
	(AW87XXX_PID_5A_REG_CP_FREQ_8P0MHZ << AW87XXX_PID_5A_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_5A_REG_CP_FREQ_9P6MHZ	(3)
#define AW87XXX_PID_5A_REG_CP_FREQ_9P6MHZ_VALUE	\
	(AW87XXX_PID_5A_REG_CP_FREQ_9P6MHZ << AW87XXX_PID_5A_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_5A_REG_CP_FREQ_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_CP_FREQ_DEFAULT	\
	(AW87XXX_PID_5A_REG_CP_FREQ_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CP_FREQ_START_BIT)

/* CP_LDO bit 5:4 (DFT1R 0x60) */
#define AW87XXX_PID_5A_REG_CP_LDO_START_BIT	(4)
#define AW87XXX_PID_5A_REG_CP_LDO_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_CP_LDO_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CP_LDO_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CP_LDO_START_BIT))

#define AW87XXX_PID_5A_REG_CP_LDO_4P75V	(0)
#define AW87XXX_PID_5A_REG_CP_LDO_4P75V_VALUE	\
	(AW87XXX_PID_5A_REG_CP_LDO_4P75V << AW87XXX_PID_5A_REG_CP_LDO_START_BIT)

#define AW87XXX_PID_5A_REG_CP_LDO_5V	(1)
#define AW87XXX_PID_5A_REG_CP_LDO_5V_VALUE	\
	(AW87XXX_PID_5A_REG_CP_LDO_5V << AW87XXX_PID_5A_REG_CP_LDO_START_BIT)

#define AW87XXX_PID_5A_REG_CP_LDO_5P25V	(2)
#define AW87XXX_PID_5A_REG_CP_LDO_5P25V_VALUE	\
	(AW87XXX_PID_5A_REG_CP_LDO_5P25V << AW87XXX_PID_5A_REG_CP_LDO_START_BIT)

#define AW87XXX_PID_5A_REG_CP_LDO_5P5V	(3)
#define AW87XXX_PID_5A_REG_CP_LDO_5P5V_VALUE	\
	(AW87XXX_PID_5A_REG_CP_LDO_5P5V << AW87XXX_PID_5A_REG_CP_LDO_START_BIT)

#define AW87XXX_PID_5A_REG_CP_LDO_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_CP_LDO_DEFAULT	\
	(AW87XXX_PID_5A_REG_CP_LDO_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CP_LDO_START_BIT)

/* CP_VOS bit 3:2 (DFT1R 0x60) */
#define AW87XXX_PID_5A_REG_CP_VOS_START_BIT	(2)
#define AW87XXX_PID_5A_REG_CP_VOS_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_CP_VOS_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CP_VOS_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CP_VOS_START_BIT))

#define AW87XXX_PID_5A_REG_CP_VOS_0MV	(0)
#define AW87XXX_PID_5A_REG_CP_VOS_0MV_VALUE	\
	(AW87XXX_PID_5A_REG_CP_VOS_0MV << AW87XXX_PID_5A_REG_CP_VOS_START_BIT)

#define AW87XXX_PID_5A_REG_CP_VOS_50MV	(1)
#define AW87XXX_PID_5A_REG_CP_VOS_50MV_VALUE	\
	(AW87XXX_PID_5A_REG_CP_VOS_50MV << AW87XXX_PID_5A_REG_CP_VOS_START_BIT)

#define AW87XXX_PID_5A_REG_CP_VOS_100MV	(2)
#define AW87XXX_PID_5A_REG_CP_VOS_100MV_VALUE	\
	(AW87XXX_PID_5A_REG_CP_VOS_100MV << AW87XXX_PID_5A_REG_CP_VOS_START_BIT)

#define AW87XXX_PID_5A_REG_CP_VOS_150MV	(3)
#define AW87XXX_PID_5A_REG_CP_VOS_150MV_VALUE	\
	(AW87XXX_PID_5A_REG_CP_VOS_150MV << AW87XXX_PID_5A_REG_CP_VOS_START_BIT)

#define AW87XXX_PID_5A_REG_CP_VOS_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_CP_VOS_DEFAULT	\
	(AW87XXX_PID_5A_REG_CP_VOS_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CP_VOS_START_BIT)

/* CPOK_TM bit 1 (DFT1R 0x60) */
#define AW87XXX_PID_5A_REG_CPOK_TM_START_BIT	(1)
#define AW87XXX_PID_5A_REG_CPOK_TM_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_CPOK_TM_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CPOK_TM_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CPOK_TM_START_BIT))

#define AW87XXX_PID_5A_REG_CPOK_TM_0P6MS	(0)
#define AW87XXX_PID_5A_REG_CPOK_TM_0P6MS_VALUE	\
	(AW87XXX_PID_5A_REG_CPOK_TM_0P6MS << AW87XXX_PID_5A_REG_CPOK_TM_START_BIT)

#define AW87XXX_PID_5A_REG_CPOK_TM_1MS	(1)
#define AW87XXX_PID_5A_REG_CPOK_TM_1MS_VALUE	\
	(AW87XXX_PID_5A_REG_CPOK_TM_1MS << AW87XXX_PID_5A_REG_CPOK_TM_START_BIT)

#define AW87XXX_PID_5A_REG_CPOK_TM_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_CPOK_TM_DEFAULT	\
	(AW87XXX_PID_5A_REG_CPOK_TM_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CPOK_TM_START_BIT)

/* CP_DDT bit 0 (DFT1R 0x60) */
#define AW87XXX_PID_5A_REG_CP_DDT_START_BIT	(0)
#define AW87XXX_PID_5A_REG_CP_DDT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_CP_DDT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CP_DDT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CP_DDT_START_BIT))

#define AW87XXX_PID_5A_REG_CP_DDT_0NS	(0)
#define AW87XXX_PID_5A_REG_CP_DDT_0NS_VALUE	\
	(AW87XXX_PID_5A_REG_CP_DDT_0NS << AW87XXX_PID_5A_REG_CP_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_CP_DDT_10NS	(1)
#define AW87XXX_PID_5A_REG_CP_DDT_10NS_VALUE	\
	(AW87XXX_PID_5A_REG_CP_DDT_10NS << AW87XXX_PID_5A_REG_CP_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_CP_DDT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_CP_DDT_DEFAULT	\
	(AW87XXX_PID_5A_REG_CP_DDT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CP_DDT_START_BIT)

/* default value of DFT1R (0x60) */
/* #define AW87XXX_PID_5A_REG_DFT1R_DEFAULT		(0x66) */

/* DFT2R (0x61) detail */
/* BOOST_VCLAMP_SS bit 7:6 (DFT2R 0x61) */
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_START_BIT	(6)
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_START_BIT))

#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_680MV840MV	(0)
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_680MV840MV_VALUE	\
	(AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_680MV840MV << AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_780MV930MV	(1)
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_780MV930MV_VALUE	\
	(AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_780MV930MV << AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_1070MV1225MV	(2)
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_1070MV1225MV_VALUE	\
	(AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_1070MV1225MV << AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_1350MV1500MV	(3)
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_1350MV1500MV_VALUE	\
	(AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_CLAMP_1350MV1500MV << AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_START_BIT)

#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_DEFAULT	\
	(AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BOOST_VCLAMP_SS_START_BIT)

/* BST_KICK_ITH bit 5:4 (DFT2R 0x61) */
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_KICK_ITH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_KICK_ITH_START_BIT))

#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P5KOHM	(0)
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P5KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P5KOHM << AW87XXX_PID_5A_REG_BST_KICK_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P25KOHM	(1)
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P25KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P25KOHM << AW87XXX_PID_5A_REG_BST_KICK_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P167KOHM	(2)
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P167KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P167KOHM << AW87XXX_PID_5A_REG_BST_KICK_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P125KOHM	(3)
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P125KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_KICK_ITH_PVDD0P125KOHM << AW87XXX_PID_5A_REG_BST_KICK_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_KICK_ITH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_KICK_ITH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_KICK_ITH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_KICK_ITH_START_BIT)

/* BST_EA_CUR bit 3 (DFT2R 0x61) */
#define AW87XXX_PID_5A_REG_BST_EA_CUR_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_EA_CUR_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_EA_CUR_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_EA_CUR_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_EA_CUR_START_BIT))

#define AW87XXX_PID_5A_REG_BST_EA_CUR_1UA	(0)
#define AW87XXX_PID_5A_REG_BST_EA_CUR_1UA_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EA_CUR_1UA << AW87XXX_PID_5A_REG_BST_EA_CUR_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EA_CUR_4UA	(1)
#define AW87XXX_PID_5A_REG_BST_EA_CUR_4UA_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EA_CUR_4UA << AW87XXX_PID_5A_REG_BST_EA_CUR_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EA_CUR_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_EA_CUR_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_EA_CUR_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_EA_CUR_START_BIT)

/* BST_CK_MODE bit 2 (DFT2R 0x61) */
#define AW87XXX_PID_5A_REG_BST_CK_MODE_START_BIT	(2)
#define AW87XXX_PID_5A_REG_BST_CK_MODE_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_CK_MODE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_CK_MODE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_CK_MODE_START_BIT))

#define AW87XXX_PID_5A_REG_BST_CK_MODE_1P6MHZ	(0)
#define AW87XXX_PID_5A_REG_BST_CK_MODE_1P6MHZ_VALUE	\
	(AW87XXX_PID_5A_REG_BST_CK_MODE_1P6MHZ << AW87XXX_PID_5A_REG_BST_CK_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_BST_CK_MODE_2P0MHZ	(1)
#define AW87XXX_PID_5A_REG_BST_CK_MODE_2P0MHZ_VALUE	\
	(AW87XXX_PID_5A_REG_BST_CK_MODE_2P0MHZ << AW87XXX_PID_5A_REG_BST_CK_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_BST_CK_MODE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_CK_MODE_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_CK_MODE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_CK_MODE_START_BIT)

/* BST_COMPMAX bit 1:0 (DFT2R 0x61) */
#define AW87XXX_PID_5A_REG_BST_COMPMAX_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_COMPMAX_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_COMPMAX_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_COMPMAX_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_COMPMAX_START_BIT))

#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P2V	(0)
#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P2V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_COMPMAX_2P2V << AW87XXX_PID_5A_REG_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P4V	(1)
#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P4V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_COMPMAX_2P4V << AW87XXX_PID_5A_REG_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P6V	(2)
#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P6V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_COMPMAX_2P6V << AW87XXX_PID_5A_REG_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P8V	(3)
#define AW87XXX_PID_5A_REG_BST_COMPMAX_2P8V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_COMPMAX_2P8V << AW87XXX_PID_5A_REG_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_5A_REG_BST_COMPMAX_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_COMPMAX_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_COMPMAX_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_COMPMAX_START_BIT)

/* default value of DFT2R (0x61) */
/* #define AW87XXX_PID_5A_REG_DFT2R_DEFAULT		(0x18) */

/* DFT3R (0x62) detail */
/* BST_PWM_SHORT bit 7 (DFT3R 0x62) */
#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_START_BIT	(7)
#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_PWM_SHORT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_PWM_SHORT_START_BIT))

#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_VBSTBELOWVDD	(0)
#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_VBSTBELOWVDD_VALUE	\
	(AW87XXX_PID_5A_REG_BST_PWM_SHORT_VBSTBELOWVDD << AW87XXX_PID_5A_REG_BST_PWM_SHORT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_VBSTBELOWVDDMINUS_VTH	(1)
#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_VBSTBELOWVDDMINUS_VTH_VALUE	\
	(AW87XXX_PID_5A_REG_BST_PWM_SHORT_VBSTBELOWVDDMINUS_VTH << AW87XXX_PID_5A_REG_BST_PWM_SHORT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_PWM_SHORT_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_PWM_SHORT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_PWM_SHORT_START_BIT)

/* BST_SLOPE bit 6:5 (DFT3R 0x62) */
#define AW87XXX_PID_5A_REG_BST_SLOPE_START_BIT	(5)
#define AW87XXX_PID_5A_REG_BST_SLOPE_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_SLOPE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_SLOPE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_SLOPE_START_BIT))

#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE	(0)
#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P25	(1)
#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P25_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P25 << AW87XXX_PID_5A_REG_BST_SLOPE_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P5	(2)
#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P5_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P5 << AW87XXX_PID_5A_REG_BST_SLOPE_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P75	(3)
#define AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P75_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_ISLOPE1P75 << AW87XXX_PID_5A_REG_BST_SLOPE_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_SLOPE_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_SLOPE_START_BIT)

/* BST_LOOPC bit 4 (DFT3R 0x62) */
#define AW87XXX_PID_5A_REG_BST_LOOPC_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_LOOPC_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_LOOPC_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_LOOPC_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_LOOPC_START_BIT))

#define AW87XXX_PID_5A_REG_BST_LOOPC_28PF	(0)
#define AW87XXX_PID_5A_REG_BST_LOOPC_28PF_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LOOPC_28PF << AW87XXX_PID_5A_REG_BST_LOOPC_START_BIT)

#define AW87XXX_PID_5A_REG_BST_LOOPC_50PF	(1)
#define AW87XXX_PID_5A_REG_BST_LOOPC_50PF_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LOOPC_50PF << AW87XXX_PID_5A_REG_BST_LOOPC_START_BIT)

#define AW87XXX_PID_5A_REG_BST_LOOPC_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_LOOPC_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_LOOPC_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_LOOPC_START_BIT)

/* BST_OS_WIDTH bit 3:2 (DFT3R 0x62) */
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_START_BIT	(2)
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OS_WIDTH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OS_WIDTH_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_40NS	(0)
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_40NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OS_WIDTH_40NS << AW87XXX_PID_5A_REG_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_30NS	(1)
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_30NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OS_WIDTH_30NS << AW87XXX_PID_5A_REG_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_50NS	(2)
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_50NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OS_WIDTH_50NS << AW87XXX_PID_5A_REG_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_60NS	(3)
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_60NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OS_WIDTH_60NS << AW87XXX_PID_5A_REG_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_OS_WIDTH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OS_WIDTH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OS_WIDTH_START_BIT)

/* BST_LOOPR bit 1:0 (DFT3R 0x62) */
#define AW87XXX_PID_5A_REG_BST_LOOPR_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_LOOPR_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_LOOPR_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_LOOPR_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_LOOPR_START_BIT))

#define AW87XXX_PID_5A_REG_BST_LOOPR_320K	(0)
#define AW87XXX_PID_5A_REG_BST_LOOPR_320K_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LOOPR_320K << AW87XXX_PID_5A_REG_BST_LOOPR_START_BIT)

#define AW87XXX_PID_5A_REG_BST_LOOPR_160K	(1)
#define AW87XXX_PID_5A_REG_BST_LOOPR_160K_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LOOPR_160K << AW87XXX_PID_5A_REG_BST_LOOPR_START_BIT)

#define AW87XXX_PID_5A_REG_BST_LOOPR_480K	(2)
#define AW87XXX_PID_5A_REG_BST_LOOPR_480K_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LOOPR_480K << AW87XXX_PID_5A_REG_BST_LOOPR_START_BIT)
/*
#define AW87XXX_PID_5A_REG_BST_LOOPR_320K	(3)
#define AW87XXX_PID_5A_REG_BST_LOOPR_320K_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LOOPR_320K << AW87XXX_PID_5A_REG_BST_LOOPR_START_BIT)
*/
#define AW87XXX_PID_5A_REG_BST_LOOPR_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_BST_LOOPR_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_LOOPR_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_LOOPR_START_BIT)

/* default value of DFT3R (0x62) */
/* #define AW87XXX_PID_5A_REG_DFT3R_DEFAULT		(0x02) */

/* DFT4R (0x63) detail */
/* BST_BURST_IN_DELAY bit 7:6 (DFT4R 0x63) */
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_START_BIT	(6)
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_8US	(0)
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_8US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_8US << AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_12US	(1)
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_12US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_12US << AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_4US	(2)
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_4US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_4US << AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_2US	(3)
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_2US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_2US << AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_BURST_IN_DELAY_START_BIT)

/* BST_BURST_OUT_DELAY bit 5:4 (DFT4R 0x63) */
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_2US	(0)
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_2US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_2US << AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_4US	(1)
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_4US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_4US << AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_1P3US	(2)
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_1P3US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_1P3US << AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_1P0US	(3)
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_1P0US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_1P0US << AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_BURST_OUT_DELAY_START_BIT)

/* BST_EN_DELAY bit 3:2 (DFT4R 0x63) */
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_START_BIT	(2)
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_EN_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_EN_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_BST_EN_DELAY_8NS	(0)
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_8NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EN_DELAY_8NS << AW87XXX_PID_5A_REG_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EN_DELAY_80NS	(1)
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_80NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EN_DELAY_80NS << AW87XXX_PID_5A_REG_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EN_DELAY_130NS	(2)
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_130NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EN_DELAY_130NS << AW87XXX_PID_5A_REG_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EN_DELAY_200NS	(3)
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_200NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EN_DELAY_200NS << AW87XXX_PID_5A_REG_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EN_DELAY_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_BST_EN_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_EN_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_EN_DELAY_START_BIT)

/* BST_GD_DELAY bit 1:0 (DFT4R 0x63) */
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_GD_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_GD_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_1P2NS_LS_1P2NS	(0)
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_1P2NS_LS_1P2NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_1P2NS_LS_1P2NS << AW87XXX_PID_5A_REG_BST_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_1P2NS_LS_2P5NS	(1)
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_1P2NS_LS_2P5NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_1P2NS_LS_2P5NS << AW87XXX_PID_5A_REG_BST_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_2P5NS_LS_1P2NS	(2)
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_2P5NS_LS_1P2NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_2P5NS_LS_1P2NS << AW87XXX_PID_5A_REG_BST_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_2P5NS_LS_2P5NS	(3)
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_2P5NS_LS_2P5NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_GD_DELAY_HS_2P5NS_LS_2P5NS << AW87XXX_PID_5A_REG_BST_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_GD_DELAY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_GD_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_GD_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_GD_DELAY_START_BIT)

/* default value of DFT4R (0x63) */
/* #define AW87XXX_PID_5A_REG_DFT4R_DEFAULT		(0x08) */

/* DFT5R (0x64) detail */
/* PA_FLT_SR bit 7 (DFT5R 0x64) */
#define AW87XXX_PID_5A_REG_PA_FLT_SR_START_BIT	(7)
#define AW87XXX_PID_5A_REG_PA_FLT_SR_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PA_FLT_SR_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_FLT_SR_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_FLT_SR_START_BIT))

#define AW87XXX_PID_5A_REG_PA_FLT_SR_ENABLE	(0)
#define AW87XXX_PID_5A_REG_PA_FLT_SR_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PA_FLT_SR_ENABLE << AW87XXX_PID_5A_REG_PA_FLT_SR_START_BIT)

#define AW87XXX_PID_5A_REG_PA_FLT_SR_DISABLE	(1)
#define AW87XXX_PID_5A_REG_PA_FLT_SR_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PA_FLT_SR_DISABLE << AW87XXX_PID_5A_REG_PA_FLT_SR_START_BIT)

#define AW87XXX_PID_5A_REG_PA_FLT_SR_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PA_FLT_SR_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_FLT_SR_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_FLT_SR_START_BIT)

/* AGC1_VTH_SEL bit 6:5 (DFT5R 0x64) */
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_START_BIT	(5)
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_AGC1_VTH_SEL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_AGC1_VTH_SEL_START_BIT))

#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN	(0)
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN << AW87XXX_PID_5A_REG_AGC1_VTH_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_THGEN	(1)
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_THGEN_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_VTH_SEL_THGEN << AW87XXX_PID_5A_REG_AGC1_VTH_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN_AND_THGEN	(2)
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN_AND_THGEN_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN_AND_THGEN << AW87XXX_PID_5A_REG_AGC1_VTH_SEL_START_BIT)
/*
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN_AND_THGEN	(3)
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN_AND_THGEN_VALUE	\
	(AW87XXX_PID_5A_REG_AGC1_VTH_SEL_RAMP_GEN_AND_THGEN << AW87XXX_PID_5A_REG_AGC1_VTH_SEL_START_BIT)
*/
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_AGC1_VTH_SEL_DEFAULT	\
	(AW87XXX_PID_5A_REG_AGC1_VTH_SEL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_AGC1_VTH_SEL_START_BIT)

/* BST_OVP2_EN bit 4 (DFT5R 0x64) */
#define AW87XXX_PID_5A_REG_BST_OVP2_EN_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_OVP2_EN_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_EN_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP2_EN_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP2_EN_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP2_EN_DISABLE	(0)
#define AW87XXX_PID_5A_REG_BST_OVP2_EN_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_EN_DISABLE << AW87XXX_PID_5A_REG_BST_OVP2_EN_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_EN_ENABLE	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_EN_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_EN_ENABLE << AW87XXX_PID_5A_REG_BST_OVP2_EN_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_EN_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_OVP2_EN_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP2_EN_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP2_EN_START_BIT)

/* BST_OVP2_ITH bit 3:2 (DFT5R 0x64) */
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_START_BIT	(2)
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP2_ITH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP2_ITH_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P5KOHM	(0)
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P5KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P5KOHM << AW87XXX_PID_5A_REG_BST_OVP2_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P25KOHM	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P25KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P25KOHM << AW87XXX_PID_5A_REG_BST_OVP2_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P167KOHM	(2)
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P167KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P167KOHM << AW87XXX_PID_5A_REG_BST_OVP2_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P125KOHM	(3)
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P125KOHM_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_ITH_PVDD0P125KOHM << AW87XXX_PID_5A_REG_BST_OVP2_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_OVP2_ITH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP2_ITH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP2_ITH_START_BIT)

/* BST_OVP2_VTH bit 1:0 (DFT5R 0x64) */
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP2_VTH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP2_VTH_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_13V_9V	(0)
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_13V_9V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_VTH_13V_9V << AW87XXX_PID_5A_REG_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_13P5V_9P5V	(1)
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_13P5V_9P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_VTH_13P5V_9P5V << AW87XXX_PID_5A_REG_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_14V_10V	(2)
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_14V_10V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_VTH_14V_10V << AW87XXX_PID_5A_REG_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_14P5V_10P5V	(3)
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_14P5V_10P5V_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP2_VTH_14P5V_10P5V << AW87XXX_PID_5A_REG_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_OVP2_VTH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP2_VTH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP2_VTH_START_BIT)

/* default value of DFT5R (0x64) */
/* #define AW87XXX_PID_5A_REG_DFT5R_DEFAULT		(0x45) */

/* DFT6R (0x65) detail */
/* POWER_SAVE_DLY_SELECT bit 7 (DFT6R 0x65) */
#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_START_BIT	(7)
#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_START_BIT))

#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_HIGH_VOLTAGE_TRIGGER	(0)
#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_HIGH_VOLTAGE_TRIGGER_VALUE	\
	(AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_HIGH_VOLTAGE_TRIGGER << AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_START_BIT)

#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_CLK_RISING_EDGE_TRIGGER	(1)
#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_CLK_RISING_EDGE_TRIGGER_VALUE	\
	(AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_CLK_RISING_EDGE_TRIGGER << AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_START_BIT)

#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_DEFAULT	\
	(AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_POWER_SAVE_DLY_SELECT_START_BIT)

/* PA_OPD bit 6 (DFT6R 0x65) */
#define AW87XXX_PID_5A_REG_PA_OPD_START_BIT	(6)
#define AW87XXX_PID_5A_REG_PA_OPD_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PA_OPD_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_OPD_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_OPD_START_BIT))

#define AW87XXX_PID_5A_REG_PA_OPD_OUTPUT_FLOATING	(0)
#define AW87XXX_PID_5A_REG_PA_OPD_OUTPUT_FLOATING_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OPD_OUTPUT_FLOATING << AW87XXX_PID_5A_REG_PA_OPD_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OPD_OUTPUT_TIED_TO_GND	(1)
#define AW87XXX_PID_5A_REG_PA_OPD_OUTPUT_TIED_TO_GND_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OPD_OUTPUT_TIED_TO_GND << AW87XXX_PID_5A_REG_PA_OPD_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OPD_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_PA_OPD_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_OPD_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_OPD_START_BIT)

/* CLK_OCP_SEL bit 5 (DFT6R 0x65) */
#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_START_BIT	(5)
#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_CLK_OCP_SEL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_CLK_OCP_SEL_START_BIT))

#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_160MS	(0)
#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_160MS_VALUE	\
	(AW87XXX_PID_5A_REG_CLK_OCP_SEL_160MS << AW87XXX_PID_5A_REG_CLK_OCP_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_640MS	(1)
#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_640MS_VALUE	\
	(AW87XXX_PID_5A_REG_CLK_OCP_SEL_640MS << AW87XXX_PID_5A_REG_CLK_OCP_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_CLK_OCP_SEL_DEFAULT	\
	(AW87XXX_PID_5A_REG_CLK_OCP_SEL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_CLK_OCP_SEL_START_BIT)

/* BST_SKIP_EN bit 4 (DFT6R 0x65) */
#define AW87XXX_PID_5A_REG_BST_SKIP_EN_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_SKIP_EN_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_SKIP_EN_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_SKIP_EN_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_SKIP_EN_START_BIT))

#define AW87XXX_PID_5A_REG_BST_SKIP_EN_DISABLE	(0)
#define AW87XXX_PID_5A_REG_BST_SKIP_EN_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SKIP_EN_DISABLE << AW87XXX_PID_5A_REG_BST_SKIP_EN_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SKIP_EN_ENABLE	(1)
#define AW87XXX_PID_5A_REG_BST_SKIP_EN_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SKIP_EN_ENABLE << AW87XXX_PID_5A_REG_BST_SKIP_EN_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SKIP_EN_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_SKIP_EN_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_SKIP_EN_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_SKIP_EN_START_BIT)

/* BST_OVP_DEGLITCH_SEL bit 3 (DFT6R 0x65) */
#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_START_BIT))

#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_NO_DEGLITCH	(0)
#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_NO_DEGLITCH_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_NO_DEGLITCH << AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_DEGLITCH_300NS	(1)
#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_DEGLITCH_300NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_DEGLITCH_300NS << AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_OVP_DEGLITCH_SEL_START_BIT)

/* BST_NCD_ITH bit 2:1 (DFT6R 0x65) */
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_START_BIT	(1)
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_NCD_ITH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_NCD_ITH_START_BIT))

#define AW87XXX_PID_5A_REG_BST_NCD_ITH_150MA	(0)
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_150MA_VALUE	\
	(AW87XXX_PID_5A_REG_BST_NCD_ITH_150MA << AW87XXX_PID_5A_REG_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_NCD_ITH_200MA	(1)
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_200MA_VALUE	\
	(AW87XXX_PID_5A_REG_BST_NCD_ITH_200MA << AW87XXX_PID_5A_REG_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_NCD_ITH_250MA	(2)
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_250MA_VALUE	\
	(AW87XXX_PID_5A_REG_BST_NCD_ITH_250MA << AW87XXX_PID_5A_REG_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_NCD_ITH_300MA	(3)
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_300MA_VALUE	\
	(AW87XXX_PID_5A_REG_BST_NCD_ITH_300MA << AW87XXX_PID_5A_REG_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_NCD_ITH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_NCD_ITH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_NCD_ITH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_NCD_ITH_START_BIT)

/* BST_LMD_VTH bit 0 (DFT6R 0x65) */
#define AW87XXX_PID_5A_REG_BST_LMD_VTH_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_LMD_VTH_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_LMD_VTH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_LMD_VTH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_LMD_VTH_START_BIT))

#define AW87XXX_PID_5A_REG_BST_LMD_VTH_HIGH_SIDE_VDD	(0)
#define AW87XXX_PID_5A_REG_BST_LMD_VTH_HIGH_SIDE_VDD_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LMD_VTH_HIGH_SIDE_VDD << AW87XXX_PID_5A_REG_BST_LMD_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_LMD_VTH_LOW_SIDE_VDD	(1)
#define AW87XXX_PID_5A_REG_BST_LMD_VTH_LOW_SIDE_VDD_VALUE	\
	(AW87XXX_PID_5A_REG_BST_LMD_VTH_LOW_SIDE_VDD << AW87XXX_PID_5A_REG_BST_LMD_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_BST_LMD_VTH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_LMD_VTH_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_LMD_VTH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_LMD_VTH_START_BIT)

/* default value of DFT6R (0x65) */
/* #define AW87XXX_PID_5A_REG_DFT6R_DEFAULT		(0x53) */

/* DFT7R (0x66) detail */

/* PA_OC_DT bit 4:3 (DFT7R 0x66) */
#define AW87XXX_PID_5A_REG_PA_OC_DT_START_BIT	(3)
#define AW87XXX_PID_5A_REG_PA_OC_DT_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_PA_OC_DT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_OC_DT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_OC_DT_START_BIT))

#define AW87XXX_PID_5A_REG_PA_OC_DT_80NS	(0)
#define AW87XXX_PID_5A_REG_PA_OC_DT_80NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_DT_80NS << AW87XXX_PID_5A_REG_PA_OC_DT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_DT_150NS	(1)
#define AW87XXX_PID_5A_REG_PA_OC_DT_150NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_DT_150NS << AW87XXX_PID_5A_REG_PA_OC_DT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_DT_210NS	(2)
#define AW87XXX_PID_5A_REG_PA_OC_DT_210NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_DT_210NS << AW87XXX_PID_5A_REG_PA_OC_DT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_DT_240NS	(3)
#define AW87XXX_PID_5A_REG_PA_OC_DT_240NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OC_DT_240NS << AW87XXX_PID_5A_REG_PA_OC_DT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OC_DT_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_PA_OC_DT_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_OC_DT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_OC_DT_START_BIT)

/* PA_RAMP_AGC1 bit 2:1 (DFT7R 0x66) */
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_START_BIT	(1)
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_RAMP_AGC1_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_RAMP_AGC1_START_BIT))

#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P8VDD	(0)
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P8VDD_VALUE	\
	(AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P8VDD << AW87XXX_PID_5A_REG_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P825VDD	(1)
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P825VDD_VALUE	\
	(AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P825VDD << AW87XXX_PID_5A_REG_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P85VDD	(2)
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P85VDD_VALUE	\
	(AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P85VDD << AW87XXX_PID_5A_REG_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P875VDD	(3)
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P875VDD_VALUE	\
	(AW87XXX_PID_5A_REG_PA_RAMP_AGC1_0P875VDD << AW87XXX_PID_5A_REG_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PA_RAMP_AGC1_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_RAMP_AGC1_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_RAMP_AGC1_START_BIT)

/* PA_OCSWD bit 0 (DFT7R 0x66) */
#define AW87XXX_PID_5A_REG_PA_OCSWD_START_BIT	(0)
#define AW87XXX_PID_5A_REG_PA_OCSWD_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PA_OCSWD_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_OCSWD_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_OCSWD_START_BIT))

#define AW87XXX_PID_5A_REG_PA_OCSWD_THROUGH_GATEDRIVER	(0)
#define AW87XXX_PID_5A_REG_PA_OCSWD_THROUGH_GATEDRIVER_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OCSWD_THROUGH_GATEDRIVER << AW87XXX_PID_5A_REG_PA_OCSWD_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OCSWD_THROUGH_SWITCH_MOS	(1)
#define AW87XXX_PID_5A_REG_PA_OCSWD_THROUGH_SWITCH_MOS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_OCSWD_THROUGH_SWITCH_MOS << AW87XXX_PID_5A_REG_PA_OCSWD_START_BIT)

#define AW87XXX_PID_5A_REG_PA_OCSWD_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PA_OCSWD_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_OCSWD_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_OCSWD_START_BIT)

/* default value of DFT7R (0x66) */
/* #define AW87XXX_PID_5A_REG_DFT7R_DEFAULT		(0x70) */

/* DFT8R (0x67) detail */
/* PA_GD_DELAY bit 7:6 (DFT8R 0x67) */
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_START_BIT	(6)
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_GD_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_GD_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_1P2NS_LS_1P2NS	(0)
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_1P2NS_LS_1P2NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_1P2NS_LS_1P2NS << AW87XXX_PID_5A_REG_PA_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_1P2NS_LS_2P5NS	(1)
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_1P2NS_LS_2P5NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_1P2NS_LS_2P5NS << AW87XXX_PID_5A_REG_PA_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_2P5NS_LS_1P2NS	(2)
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_2P5NS_LS_1P2NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_2P5NS_LS_1P2NS << AW87XXX_PID_5A_REG_PA_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_2P5NS_LS_2P5NS	(3)
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_2P5NS_LS_2P5NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GD_DELAY_HS_2P5NS_LS_2P5NS << AW87XXX_PID_5A_REG_PA_GD_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GD_DELAY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PA_GD_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_GD_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_GD_DELAY_START_BIT)

/* PA_GD_DGT bit 5 (DFT8R 0x67) */
#define AW87XXX_PID_5A_REG_PA_GD_DGT_START_BIT	(5)
#define AW87XXX_PID_5A_REG_PA_GD_DGT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PA_GD_DGT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_GD_DGT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_GD_DGT_START_BIT))

#define AW87XXX_PID_5A_REG_PA_GD_DGT_4NS	(0)
#define AW87XXX_PID_5A_REG_PA_GD_DGT_4NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GD_DGT_4NS << AW87XXX_PID_5A_REG_PA_GD_DGT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GD_DGT_5P5NS	(1)
#define AW87XXX_PID_5A_REG_PA_GD_DGT_5P5NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GD_DGT_5P5NS << AW87XXX_PID_5A_REG_PA_GD_DGT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GD_DGT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PA_GD_DGT_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_GD_DGT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_GD_DGT_START_BIT)

/* PA_PORT bit 4:3 (DFT8R 0x67) */
#define AW87XXX_PID_5A_REG_PA_PORT_START_BIT	(3)
#define AW87XXX_PID_5A_REG_PA_PORT_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_PA_PORT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_PORT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_PORT_START_BIT))

#define AW87XXX_PID_5A_REG_PA_PORT_80MS	(0)
#define AW87XXX_PID_5A_REG_PA_PORT_80MS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_PORT_80MS << AW87XXX_PID_5A_REG_PA_PORT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_PORT_40MS	(1)
#define AW87XXX_PID_5A_REG_PA_PORT_40MS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_PORT_40MS << AW87XXX_PID_5A_REG_PA_PORT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_PORT_20MS	(2)
#define AW87XXX_PID_5A_REG_PA_PORT_20MS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_PORT_20MS << AW87XXX_PID_5A_REG_PA_PORT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_PORT_10MS	(3)
#define AW87XXX_PID_5A_REG_PA_PORT_10MS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_PORT_10MS << AW87XXX_PID_5A_REG_PA_PORT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_PORT_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_PA_PORT_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_PORT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_PORT_START_BIT)

/* EN_AGC1_ADP bit 2 (DFT8R 0x67) */
#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_START_BIT	(2)
#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_AGC1_ADP_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_AGC1_ADP_START_BIT))

#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_AGC_CROSSZERO_AS_BEFORE	(0)
#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_AGC_CROSSZERO_AS_BEFORE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_AGC1_ADP_AGC_CROSSZERO_AS_BEFORE << AW87XXX_PID_5A_REG_EN_AGC1_ADP_START_BIT)

#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_AGC_CROSSZERO_ADAPTIVELY	(1)
#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_AGC_CROSSZERO_ADAPTIVELY_VALUE	\
	(AW87XXX_PID_5A_REG_EN_AGC1_ADP_AGC_CROSSZERO_ADAPTIVELY << AW87XXX_PID_5A_REG_EN_AGC1_ADP_START_BIT)

#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_AGC1_ADP_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_AGC1_ADP_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_AGC1_ADP_START_BIT)

/* PD_CROSSZERO bit 1:0 (DFT8R 0x67) */
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_START_BIT	(0)
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PD_CROSSZERO_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PD_CROSSZERO_START_BIT))

#define AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC1AGC2_AND_AGC3_CROSS_ZERO	(0)
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC1AGC2_AND_AGC3_CROSS_ZERO_VALUE	\
	(AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC1AGC2_AND_AGC3_CROSS_ZERO << AW87XXX_PID_5A_REG_PD_CROSSZERO_START_BIT)

#define AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC2AGC3_CROSS_ZERO_DISABLE_AGC1_CROSS_ZERO	(1)
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC2AGC3_CROSS_ZERO_DISABLE_AGC1_CROSS_ZERO_VALUE	\
	(AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC2AGC3_CROSS_ZERO_DISABLE_AGC1_CROSS_ZERO << AW87XXX_PID_5A_REG_PD_CROSSZERO_START_BIT)

#define AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC3_CROSS_ZERO_DISABLE_AGC1AGC2_CROSS_ZERO	(2)
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC3_CROSS_ZERO_DISABLE_AGC1AGC2_CROSS_ZERO_VALUE	\
	(AW87XXX_PID_5A_REG_PD_CROSSZERO_ENABLE_AGC3_CROSS_ZERO_DISABLE_AGC1AGC2_CROSS_ZERO << AW87XXX_PID_5A_REG_PD_CROSSZERO_START_BIT)

#define AW87XXX_PID_5A_REG_PD_CROSSZERO_DISABLE_AGC1AGC2_AND_AGC3_CROSS_ZERO	(3)
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_DISABLE_AGC1AGC2_AND_AGC3_CROSS_ZERO_VALUE	\
	(AW87XXX_PID_5A_REG_PD_CROSSZERO_DISABLE_AGC1AGC2_AND_AGC3_CROSS_ZERO << AW87XXX_PID_5A_REG_PD_CROSSZERO_START_BIT)

#define AW87XXX_PID_5A_REG_PD_CROSSZERO_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PD_CROSSZERO_DEFAULT	\
	(AW87XXX_PID_5A_REG_PD_CROSSZERO_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PD_CROSSZERO_START_BIT)

/* default value of DFT8R (0x67) */
/* #define AW87XXX_PID_5A_REG_DFT8R_DEFAULT		(0x08) */

/* DFT9R (0x68) detail */
/* EN_BOOST_VCLAMP_SS bit 7 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_START_BIT	(7)
#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_START_BIT))

#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_DISABLE << AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_ENABLE << AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_BOOST_VCLAMP_SS_START_BIT)

/* EN_BOOST_PLDO bit 6 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_START_BIT	(6)
#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_BOOST_PLDO_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_BOOST_PLDO_START_BIT))

#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_SET_VDD	(0)
#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_SET_VDD_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BOOST_PLDO_SET_VDD << AW87XXX_PID_5A_REG_EN_BOOST_PLDO_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_SET_PVLDO	(1)
#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_SET_PVLDO_VALUE	\
	(AW87XXX_PID_5A_REG_EN_BOOST_PLDO_SET_PVLDO << AW87XXX_PID_5A_REG_EN_BOOST_PLDO_START_BIT)

#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_BOOST_PLDO_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_BOOST_PLDO_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_BOOST_PLDO_START_BIT)

/* EN_CLAMP bit 5 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_EN_CLAMP_START_BIT	(5)
#define AW87XXX_PID_5A_REG_EN_CLAMP_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_CLAMP_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_CLAMP_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_CLAMP_START_BIT))

#define AW87XXX_PID_5A_REG_EN_CLAMP_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_CLAMP_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_CLAMP_DISABLE << AW87XXX_PID_5A_REG_EN_CLAMP_START_BIT)

#define AW87XXX_PID_5A_REG_EN_CLAMP_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_CLAMP_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_CLAMP_ENABLE << AW87XXX_PID_5A_REG_EN_CLAMP_START_BIT)

#define AW87XXX_PID_5A_REG_EN_CLAMP_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_EN_CLAMP_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_CLAMP_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_CLAMP_START_BIT)

/* EN_VBG_PASS bit 4 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_EN_VBG_PASS_START_BIT	(4)
#define AW87XXX_PID_5A_REG_EN_VBG_PASS_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_VBG_PASS_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_VBG_PASS_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_VBG_PASS_START_BIT))

#define AW87XXX_PID_5A_REG_EN_VBG_PASS_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_VBG_PASS_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_VBG_PASS_DISABLE << AW87XXX_PID_5A_REG_EN_VBG_PASS_START_BIT)

#define AW87XXX_PID_5A_REG_EN_VBG_PASS_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_VBG_PASS_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_VBG_PASS_ENABLE << AW87XXX_PID_5A_REG_EN_VBG_PASS_START_BIT)

#define AW87XXX_PID_5A_REG_EN_VBG_PASS_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_VBG_PASS_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_VBG_PASS_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_VBG_PASS_START_BIT)

/* SS_SOFT_IPEAK_ADP bit 3 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_START_BIT	(3)
#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_BITS_LEN)-1) << AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_START_BIT))

#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_DISABLE	(0)
#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_DISABLE << AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_START_BIT)

#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_ENABLE	(1)
#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_ENABLE << AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_START_BIT)

#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_DEFAULT	\
	(AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_DEFAULT_VALUE << AW87XXX_PID_5A_REG_SS_SOFT_IPEAK_ADP_START_BIT)

/* EN_ADP_IPEAK bit 2 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_START_BIT	(2)
#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_ADP_IPEAK_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_ADP_IPEAK_START_BIT))

#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_ADP_IPEAK_DISABLE << AW87XXX_PID_5A_REG_EN_ADP_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_ADP_IPEAK_ENABLE << AW87XXX_PID_5A_REG_EN_ADP_IPEAK_START_BIT)

#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_ADP_IPEAK_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_ADP_IPEAK_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_ADP_IPEAK_START_BIT)

/* SEL_FINISH_ID bit 1 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_START_BIT	(1)
#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_SEL_FINISH_ID_BITS_LEN)-1) << AW87XXX_PID_5A_REG_SEL_FINISH_ID_START_BIT))

#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_MODE1_DELAY	(0)
#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_MODE1_DELAY_VALUE	\
	(AW87XXX_PID_5A_REG_SEL_FINISH_ID_MODE1_DELAY << AW87XXX_PID_5A_REG_SEL_FINISH_ID_START_BIT)

#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_LIMIT_SS_FINISH	(1)
#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_LIMIT_SS_FINISH_VALUE	\
	(AW87XXX_PID_5A_REG_SEL_FINISH_ID_LIMIT_SS_FINISH << AW87XXX_PID_5A_REG_SEL_FINISH_ID_START_BIT)

#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_SEL_FINISH_ID_DEFAULT	\
	(AW87XXX_PID_5A_REG_SEL_FINISH_ID_DEFAULT_VALUE << AW87XXX_PID_5A_REG_SEL_FINISH_ID_START_BIT)

/* SS_FINISH_SELECTED bit 0 (DFT9R 0x68) */
#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_START_BIT	(0)
#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_BITS_LEN)-1) << AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_START_BIT))

#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_3US	(0)
#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_3US_VALUE	\
	(AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_3US << AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_START_BIT)

#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_0US	(1)
#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_0US_VALUE	\
	(AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_0US << AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_START_BIT)

#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_DEFAULT	\
	(AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_DEFAULT_VALUE << AW87XXX_PID_5A_REG_SS_FINISH_SELECTED_START_BIT)

/* default value of DFT9R (0x68) */
/* #define AW87XXX_PID_5A_REG_DFT9R_DEFAULT		(0x21) */

/* DFTAR (0x69) detail */
/* HWM_DELAY_INITIAL bit 7:6 (DFTAR 0x69) */
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_START_BIT	(6)
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_START_BIT))

#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_104NS	(0)
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_104NS_VALUE	\
	(AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_104NS << AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_START_BIT)

#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_63NS	(1)
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_63NS_VALUE	\
	(AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_63NS << AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_START_BIT)

#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_56NS	(2)
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_56NS_VALUE	\
	(AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_56NS << AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_START_BIT)

#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_42NS	(3)
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_42NS_VALUE	\
	(AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_42NS << AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_START_BIT)

#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_DEFAULT	\
	(AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_HWM_DELAY_INITIAL_START_BIT)

/* BST_DFPWM bit 5:3 (DFTAR 0x69) */
#define AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_DFPWM_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_BST_DFPWM_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_DFPWM_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT))

#define AW87XXX_PID_5A_REG_BST_DFPWM_2P5US	(0)
#define AW87XXX_PID_5A_REG_BST_DFPWM_2P5US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_2P5US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_5US	(1)
#define AW87XXX_PID_5A_REG_BST_DFPWM_5US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_5US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_10US	(2)
#define AW87XXX_PID_5A_REG_BST_DFPWM_10US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_10US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_20US	(3)
#define AW87XXX_PID_5A_REG_BST_DFPWM_20US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_20US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_40US	(4)
#define AW87XXX_PID_5A_REG_BST_DFPWM_40US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_40US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_80US	(5)
#define AW87XXX_PID_5A_REG_BST_DFPWM_80US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_80US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_160US	(6)
#define AW87XXX_PID_5A_REG_BST_DFPWM_160US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_160US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_320US	(7)
#define AW87XXX_PID_5A_REG_BST_DFPWM_320US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_320US << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

#define AW87XXX_PID_5A_REG_BST_DFPWM_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_5A_REG_BST_DFPWM_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_DFPWM_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_DFPWM_START_BIT)

/* BST_SOFT_DELAY bit 2:0 (DFTAR 0x69) */
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_SOFT_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_40US	(0)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_40US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_40US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_80US	(1)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_80US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_80US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_160US	(2)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_160US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_160US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_320US	(3)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_320US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_320US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_1280US	(4)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_1280US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_1280US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_2560US	(5)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_2560US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_2560US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_5120US	(6)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_5120US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_5120US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_10240US	(7)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_10240US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_10240US << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_5A_REG_BST_SOFT_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_SOFT_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_SOFT_DELAY_START_BIT)

/* default value of DFTAR (0x69) */
/* #define AW87XXX_PID_5A_REG_DFTAR_DEFAULT		(0xA4) */

/* DFTBR (0x70) detail */
/* BST_CLK_DIV bit 4 (DFTBR 0x70) */
#define AW87XXX_PID_5A_REG_BST_CLK_DIV_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_CLK_DIV_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_CLK_DIV_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_CLK_DIV_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_CLK_DIV_START_BIT))

#define AW87XXX_PID_5A_REG_BST_CLK_DIV_DIV_BY_4	(0)
#define AW87XXX_PID_5A_REG_BST_CLK_DIV_DIV_BY_4_VALUE	\
	(AW87XXX_PID_5A_REG_BST_CLK_DIV_DIV_BY_4 << AW87XXX_PID_5A_REG_BST_CLK_DIV_START_BIT)

#define AW87XXX_PID_5A_REG_BST_CLK_DIV_DIV_BY_2	(1)
#define AW87XXX_PID_5A_REG_BST_CLK_DIV_DIV_BY_2_VALUE	\
	(AW87XXX_PID_5A_REG_BST_CLK_DIV_DIV_BY_2 << AW87XXX_PID_5A_REG_BST_CLK_DIV_START_BIT)

#define AW87XXX_PID_5A_REG_BST_CLK_DIV_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_CLK_DIV_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_CLK_DIV_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_CLK_DIV_START_BIT)

/* RAMP_1SPW_VC bit 3:2 (DFTBR 0x70) */
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_START_BIT	(2)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_RAMP_1SPW_VC_BITS_LEN)-1) << AW87XXX_PID_5A_REG_RAMP_1SPW_VC_START_BIT))

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P37VDD	(0)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P37VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P37VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P39VDD	(1)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P39VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P39VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P33VDD	(2)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P33VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P33VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P35VDD	(3)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P35VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VC_VC0P35VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VC_DEFAULT	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VC_DEFAULT_VALUE << AW87XXX_PID_5A_REG_RAMP_1SPW_VC_START_BIT)

/* RAMP_1SPW_VL bit 1:0 (DFTBR 0x70) */
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_START_BIT	(0)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_RAMP_1SPW_VL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_RAMP_1SPW_VL_START_BIT))

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P16VDD	(0)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P16VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P16VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P18VDD	(1)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P18VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P18VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P20VDD	(2)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P20VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P20VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P14VDD	(3)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P14VDD_VALUE	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VL_VC0P14VDD << AW87XXX_PID_5A_REG_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_RAMP_1SPW_VL_DEFAULT	\
	(AW87XXX_PID_5A_REG_RAMP_1SPW_VL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_RAMP_1SPW_VL_START_BIT)

/* default value of DFTBR (0x70) */
/* #define AW87XXX_PID_5A_REG_DFTBR_DEFAULT		(0x1C) */

/* DFTCR (0x71) detail */
/* DT_EN bit 7 (DFTCR 0x71) */
#define AW87XXX_PID_5A_REG_DT_EN_START_BIT	(7)
#define AW87XXX_PID_5A_REG_DT_EN_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_DT_EN_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_DT_EN_BITS_LEN)-1) << AW87XXX_PID_5A_REG_DT_EN_START_BIT))

#define AW87XXX_PID_5A_REG_DT_EN_DISABLE	(0)
#define AW87XXX_PID_5A_REG_DT_EN_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_DT_EN_DISABLE << AW87XXX_PID_5A_REG_DT_EN_START_BIT)

#define AW87XXX_PID_5A_REG_DT_EN_ENABLE	(1)
#define AW87XXX_PID_5A_REG_DT_EN_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_DT_EN_ENABLE << AW87XXX_PID_5A_REG_DT_EN_START_BIT)

#define AW87XXX_PID_5A_REG_DT_EN_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_DT_EN_DEFAULT	\
	(AW87XXX_PID_5A_REG_DT_EN_DEFAULT_VALUE << AW87XXX_PID_5A_REG_DT_EN_START_BIT)

/* BST_TD bit 6:4 (DFTCR 0x71) */
#define AW87XXX_PID_5A_REG_BST_TD_START_BIT	(4)
#define AW87XXX_PID_5A_REG_BST_TD_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_BST_TD_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_TD_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_TD_START_BIT))

#define AW87XXX_PID_5A_REG_BST_TD_0P08MS	(0)
#define AW87XXX_PID_5A_REG_BST_TD_0P08MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_0P08MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_0P16MS	(1)
#define AW87XXX_PID_5A_REG_BST_TD_0P16MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_0P16MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_0P32MS	(2)
#define AW87XXX_PID_5A_REG_BST_TD_0P32MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_0P32MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_0P64MS	(3)
#define AW87XXX_PID_5A_REG_BST_TD_0P64MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_0P64MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_1P28MS	(4)
#define AW87XXX_PID_5A_REG_BST_TD_1P28MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_1P28MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_2P56MS	(5)
#define AW87XXX_PID_5A_REG_BST_TD_2P56MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_2P56MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_5P12MS	(6)
#define AW87XXX_PID_5A_REG_BST_TD_5P12MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_5P12MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_10P24MS	(7)
#define AW87XXX_PID_5A_REG_BST_TD_10P24MS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_TD_10P24MS << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

#define AW87XXX_PID_5A_REG_BST_TD_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_TD_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_TD_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_TD_START_BIT)

/* BST_GTDR_DDT bit 3 (DFTCR 0x71) */
#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_GTDR_DDT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_GTDR_DDT_START_BIT))

#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_3NS	(0)
#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_3NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_GTDR_DDT_3NS << AW87XXX_PID_5A_REG_BST_GTDR_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_6NS	(1)
#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_6NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_GTDR_DDT_6NS << AW87XXX_PID_5A_REG_BST_GTDR_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_GTDR_DDT_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_GTDR_DDT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_GTDR_DDT_START_BIT)

/* BST_EN_RSQN_DLY bit 2 (DFTCR 0x71) */
#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_START_BIT	(2)
#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_START_BIT))

#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_DISABLE	(0)
#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_DISABLE << AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_ENABLE	(1)
#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_ENABLE << AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_EN_RSQN_DLY_START_BIT)

/* BST_RSQN_DLY bit 1:0 (DFTCR 0x71) */
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_START_BIT	(0)
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_RSQN_DLY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_RSQN_DLY_START_BIT))

#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_15NS	(0)
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_15NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_RSQN_DLY_15NS << AW87XXX_PID_5A_REG_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_25NS	(1)
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_25NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_RSQN_DLY_25NS << AW87XXX_PID_5A_REG_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_35NS	(2)
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_35NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_RSQN_DLY_35NS << AW87XXX_PID_5A_REG_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_45NS	(3)
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_45NS_VALUE	\
	(AW87XXX_PID_5A_REG_BST_RSQN_DLY_45NS << AW87XXX_PID_5A_REG_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_BST_RSQN_DLY_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_RSQN_DLY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_RSQN_DLY_START_BIT)

/* default value of DFTCR (0x71) */
/* #define AW87XXX_PID_5A_REG_DFTCR_DEFAULT		(0x10) */

/* DFTDR (0x72) detail */
/* DLY_EN bit 7 (DFTDR 0x72) */
#define AW87XXX_PID_5A_REG_DLY_EN_START_BIT	(7)
#define AW87XXX_PID_5A_REG_DLY_EN_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_DLY_EN_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_DLY_EN_BITS_LEN)-1) << AW87XXX_PID_5A_REG_DLY_EN_START_BIT))

#define AW87XXX_PID_5A_REG_DLY_EN_NO_DELAY	(0)
#define AW87XXX_PID_5A_REG_DLY_EN_NO_DELAY_VALUE	\
	(AW87XXX_PID_5A_REG_DLY_EN_NO_DELAY << AW87XXX_PID_5A_REG_DLY_EN_START_BIT)

#define AW87XXX_PID_5A_REG_DLY_EN_DELAY_TWO_CLOCK	(1)
#define AW87XXX_PID_5A_REG_DLY_EN_DELAY_TWO_CLOCK_VALUE	\
	(AW87XXX_PID_5A_REG_DLY_EN_DELAY_TWO_CLOCK << AW87XXX_PID_5A_REG_DLY_EN_START_BIT)

#define AW87XXX_PID_5A_REG_DLY_EN_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_DLY_EN_DEFAULT	\
	(AW87XXX_PID_5A_REG_DLY_EN_DEFAULT_VALUE << AW87XXX_PID_5A_REG_DLY_EN_START_BIT)

/* DOWNSIGNAL_SEL bit 6 (DFTDR 0x72) */
#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_START_BIT	(6)
#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_START_BIT))

#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_SET_160MS	(0)
#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_SET_160MS_VALUE	\
	(AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_SET_160MS << AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_SET_640MS	(1)
#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_SET_640MS_VALUE	\
	(AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_SET_640MS << AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_START_BIT)

#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_DEFAULT	\
	(AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_DOWNSIGNAL_SEL_START_BIT)

/* BST_SLOPE_LIMIT bit 5:3 (DFTDR 0x72) */
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT	(3)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_BITS_LEN	(3)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT))

#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0SLOPE	(0)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P25SLOPE	(1)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P25SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P25SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P5SLOPE	(2)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P5SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P5SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P25SLOPE	(3)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P25SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P25SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)
/*
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P5SLOPE	(4)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P5SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P5SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)
*/
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P75SLOPE	(5)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P75SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_0P75SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)
/*
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P25SLOPE	(6)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P25SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P25SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)
*/
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P75SLOPE	(7)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P75SLOPE_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_1P75SLOPE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_SLOPE_LIMIT_START_BIT)

/* MODEL_START_DELAY bit 2:1 (DFTDR 0x72) */
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_START_BIT	(1)
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_MODEL_START_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_MODEL_START_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_20US	(0)
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_20US_VALUE	\
	(AW87XXX_PID_5A_REG_MODEL_START_DELAY_20US << AW87XXX_PID_5A_REG_MODEL_START_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_0US	(1)
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_0US_VALUE	\
	(AW87XXX_PID_5A_REG_MODEL_START_DELAY_0US << AW87XXX_PID_5A_REG_MODEL_START_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_5US	(2)
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_5US_VALUE	\
	(AW87XXX_PID_5A_REG_MODEL_START_DELAY_5US << AW87XXX_PID_5A_REG_MODEL_START_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_2P5US	(3)
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_2P5US_VALUE	\
	(AW87XXX_PID_5A_REG_MODEL_START_DELAY_2P5US << AW87XXX_PID_5A_REG_MODEL_START_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_MODEL_START_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_MODEL_START_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_MODEL_START_DELAY_START_BIT)

/* PEAK_LIMIT_SS_CAP bit 0 (DFTDR 0x72) */
#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_START_BIT	(0)
#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_START_BIT))

#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_350FF	(0)
#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_350FF_VALUE	\
	(AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_350FF << AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_START_BIT)

#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_0FF	(1)
#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_0FF_VALUE	\
	(AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_0FF << AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_START_BIT)

#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_DEFAULT	\
	(AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PEAK_LIMIT_SS_CAP_START_BIT)

/* default value of DFTDR (0x72) */
/* #define AW87XXX_PID_5A_REG_DFTDR_DEFAULT		(0xA0) */

/* DFTER (0x73) detail */
/* BST_SS_TIME bit 7:6 (DFTER 0x73) */
#define AW87XXX_PID_5A_REG_BST_SS_TIME_START_BIT	(6)
#define AW87XXX_PID_5A_REG_BST_SS_TIME_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_BST_SS_TIME_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_BST_SS_TIME_BITS_LEN)-1) << AW87XXX_PID_5A_REG_BST_SS_TIME_START_BIT))

#define AW87XXX_PID_5A_REG_BST_SS_TIME_35US	(0)
#define AW87XXX_PID_5A_REG_BST_SS_TIME_35US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SS_TIME_35US << AW87XXX_PID_5A_REG_BST_SS_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SS_TIME_56US	(1)
#define AW87XXX_PID_5A_REG_BST_SS_TIME_56US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SS_TIME_56US << AW87XXX_PID_5A_REG_BST_SS_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SS_TIME_76US	(2)
#define AW87XXX_PID_5A_REG_BST_SS_TIME_76US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SS_TIME_76US << AW87XXX_PID_5A_REG_BST_SS_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SS_TIME_107US	(3)
#define AW87XXX_PID_5A_REG_BST_SS_TIME_107US_VALUE	\
	(AW87XXX_PID_5A_REG_BST_SS_TIME_107US << AW87XXX_PID_5A_REG_BST_SS_TIME_START_BIT)

#define AW87XXX_PID_5A_REG_BST_SS_TIME_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_BST_SS_TIME_DEFAULT	\
	(AW87XXX_PID_5A_REG_BST_SS_TIME_DEFAULT_VALUE << AW87XXX_PID_5A_REG_BST_SS_TIME_START_BIT)

/* PD_UVLO bit 5 (DFTER 0x73) */
#define AW87XXX_PID_5A_REG_PD_UVLO_START_BIT	(5)
#define AW87XXX_PID_5A_REG_PD_UVLO_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PD_UVLO_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PD_UVLO_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PD_UVLO_START_BIT))

#define AW87XXX_PID_5A_REG_PD_UVLO_ENABLE	(0)
#define AW87XXX_PID_5A_REG_PD_UVLO_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PD_UVLO_ENABLE << AW87XXX_PID_5A_REG_PD_UVLO_START_BIT)

#define AW87XXX_PID_5A_REG_PD_UVLO_DISABLE	(1)
#define AW87XXX_PID_5A_REG_PD_UVLO_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PD_UVLO_DISABLE << AW87XXX_PID_5A_REG_PD_UVLO_START_BIT)

#define AW87XXX_PID_5A_REG_PD_UVLO_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PD_UVLO_DEFAULT	\
	(AW87XXX_PID_5A_REG_PD_UVLO_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PD_UVLO_START_BIT)

/* UVLO_VTH bit 4:3 (DFTER 0x73) */
#define AW87XXX_PID_5A_REG_UVLO_VTH_START_BIT	(3)
#define AW87XXX_PID_5A_REG_UVLO_VTH_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_UVLO_VTH_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_UVLO_VTH_BITS_LEN)-1) << AW87XXX_PID_5A_REG_UVLO_VTH_START_BIT))

#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P6V_VL2P5V	(0)
#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P6V_VL2P5V_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_VTH_VH2P6V_VL2P5V << AW87XXX_PID_5A_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P7V_VL2P6V	(1)
#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P7V_VL2P6V_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_VTH_VH2P7V_VL2P6V << AW87XXX_PID_5A_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P8V_VL2P7V	(2)
#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P8V_VL2P7V_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_VTH_VH2P8V_VL2P7V << AW87XXX_PID_5A_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P9V_VL2P8V	(3)
#define AW87XXX_PID_5A_REG_UVLO_VTH_VH2P9V_VL2P8V_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_VTH_VH2P9V_VL2P8V << AW87XXX_PID_5A_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_VTH_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_5A_REG_UVLO_VTH_DEFAULT	\
	(AW87XXX_PID_5A_REG_UVLO_VTH_DEFAULT_VALUE << AW87XXX_PID_5A_REG_UVLO_VTH_START_BIT)

/* UVLO_DT bit 2 (DFTER 0x73) */
#define AW87XXX_PID_5A_REG_UVLO_DT_START_BIT	(2)
#define AW87XXX_PID_5A_REG_UVLO_DT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_UVLO_DT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_UVLO_DT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_UVLO_DT_START_BIT))

#define AW87XXX_PID_5A_REG_UVLO_DT_3US	(0)
#define AW87XXX_PID_5A_REG_UVLO_DT_3US_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_DT_3US << AW87XXX_PID_5A_REG_UVLO_DT_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_DT_10US	(1)
#define AW87XXX_PID_5A_REG_UVLO_DT_10US_VALUE	\
	(AW87XXX_PID_5A_REG_UVLO_DT_10US << AW87XXX_PID_5A_REG_UVLO_DT_START_BIT)

#define AW87XXX_PID_5A_REG_UVLO_DT_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_5A_REG_UVLO_DT_DEFAULT	\
	(AW87XXX_PID_5A_REG_UVLO_DT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_UVLO_DT_START_BIT)

/* OC_DISABLE bit 1 (DFTER 0x73) */
#define AW87XXX_PID_5A_REG_OC_DISABLE_START_BIT	(1)
#define AW87XXX_PID_5A_REG_OC_DISABLE_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_OC_DISABLE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_OC_DISABLE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_OC_DISABLE_START_BIT))

#define AW87XXX_PID_5A_REG_OC_DISABLE_ENABLE	(0)
#define AW87XXX_PID_5A_REG_OC_DISABLE_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_OC_DISABLE_ENABLE << AW87XXX_PID_5A_REG_OC_DISABLE_START_BIT)

#define AW87XXX_PID_5A_REG_OC_DISABLE_SHUTDOWN	(1)
#define AW87XXX_PID_5A_REG_OC_DISABLE_SHUTDOWN_VALUE	\
	(AW87XXX_PID_5A_REG_OC_DISABLE_SHUTDOWN << AW87XXX_PID_5A_REG_OC_DISABLE_START_BIT)

#define AW87XXX_PID_5A_REG_OC_DISABLE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_OC_DISABLE_DEFAULT	\
	(AW87XXX_PID_5A_REG_OC_DISABLE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_OC_DISABLE_START_BIT)

/* PD_OT bit 0 (DFTER 0x73) */
#define AW87XXX_PID_5A_REG_PD_OT_START_BIT	(0)
#define AW87XXX_PID_5A_REG_PD_OT_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_PD_OT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PD_OT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PD_OT_START_BIT))

#define AW87XXX_PID_5A_REG_PD_OT_ENABLE	(0)
#define AW87XXX_PID_5A_REG_PD_OT_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_PD_OT_ENABLE << AW87XXX_PID_5A_REG_PD_OT_START_BIT)

#define AW87XXX_PID_5A_REG_PD_OT_SHUTDOWN	(1)
#define AW87XXX_PID_5A_REG_PD_OT_SHUTDOWN_VALUE	\
	(AW87XXX_PID_5A_REG_PD_OT_SHUTDOWN << AW87XXX_PID_5A_REG_PD_OT_START_BIT)

#define AW87XXX_PID_5A_REG_PD_OT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PD_OT_DEFAULT	\
	(AW87XXX_PID_5A_REG_PD_OT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PD_OT_START_BIT)

/* default value of DFTER (0x73) */
/* #define AW87XXX_PID_5A_REG_DFTER_DEFAULT		(0x54) */

/* DFTFR (0x74) detail */
/* EN_SWF bit 6 (DFTFR 0x74) */
#define AW87XXX_PID_5A_REG_EN_SWF_START_BIT	(6)
#define AW87XXX_PID_5A_REG_EN_SWF_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_SWF_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_SWF_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_SWF_START_BIT))

#define AW87XXX_PID_5A_REG_EN_SWF_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_SWF_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_SWF_DISABLE << AW87XXX_PID_5A_REG_EN_SWF_START_BIT)

#define AW87XXX_PID_5A_REG_EN_SWF_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_SWF_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_SWF_ENABLE << AW87XXX_PID_5A_REG_EN_SWF_START_BIT)

#define AW87XXX_PID_5A_REG_EN_SWF_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_SWF_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_SWF_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_SWF_START_BIT)

/* SS_CONTROL bit 5:4 (DFTFR 0x74) */
#define AW87XXX_PID_5A_REG_SS_CONTROL_START_BIT	(4)
#define AW87XXX_PID_5A_REG_SS_CONTROL_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_SS_CONTROL_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_SS_CONTROL_BITS_LEN)-1) << AW87XXX_PID_5A_REG_SS_CONTROL_START_BIT))

#define AW87XXX_PID_5A_REG_SS_CONTROL_SPREAD_SPECTRUM	(0)
#define AW87XXX_PID_5A_REG_SS_CONTROL_SPREAD_SPECTRUM_VALUE	\
	(AW87XXX_PID_5A_REG_SS_CONTROL_SPREAD_SPECTRUM << AW87XXX_PID_5A_REG_SS_CONTROL_START_BIT)

#define AW87XXX_PID_5A_REG_SS_CONTROL_SW20111	(1)
#define AW87XXX_PID_5A_REG_SS_CONTROL_SW20111_VALUE	\
	(AW87XXX_PID_5A_REG_SS_CONTROL_SW20111 << AW87XXX_PID_5A_REG_SS_CONTROL_START_BIT)

#define AW87XXX_PID_5A_REG_SS_CONTROL_SW20000	(2)
#define AW87XXX_PID_5A_REG_SS_CONTROL_SW20000_VALUE	\
	(AW87XXX_PID_5A_REG_SS_CONTROL_SW20000 << AW87XXX_PID_5A_REG_SS_CONTROL_START_BIT)
/*
#define AW87XXX_PID_5A_REG_SS_CONTROL_SW20111	(3)
#define AW87XXX_PID_5A_REG_SS_CONTROL_SW20111_VALUE	\
	(AW87XXX_PID_5A_REG_SS_CONTROL_SW20111 << AW87XXX_PID_5A_REG_SS_CONTROL_START_BIT)
*/
#define AW87XXX_PID_5A_REG_SS_CONTROL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_SS_CONTROL_DEFAULT	\
	(AW87XXX_PID_5A_REG_SS_CONTROL_DEFAULT_VALUE << AW87XXX_PID_5A_REG_SS_CONTROL_START_BIT)

/* PA_GTDR_DDT bit 3:2 (DFTFR 0x74) */
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_START_BIT	(2)
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_BITS_LEN	(2)
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_PA_GTDR_DDT_BITS_LEN)-1) << AW87XXX_PID_5A_REG_PA_GTDR_DDT_START_BIT))

#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_12NS	(0)
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_12NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GTDR_DDT_12NS << AW87XXX_PID_5A_REG_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_13NS	(1)
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_13NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GTDR_DDT_13NS << AW87XXX_PID_5A_REG_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_14NS	(2)
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_14NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GTDR_DDT_14NS << AW87XXX_PID_5A_REG_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_15NS	(3)
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_15NS_VALUE	\
	(AW87XXX_PID_5A_REG_PA_GTDR_DDT_15NS << AW87XXX_PID_5A_REG_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_PA_GTDR_DDT_DEFAULT	\
	(AW87XXX_PID_5A_REG_PA_GTDR_DDT_DEFAULT_VALUE << AW87XXX_PID_5A_REG_PA_GTDR_DDT_START_BIT)

/* EN_HWM_DELAY bit 1 (DFTFR 0x74) */
#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_START_BIT	(1)
#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_HWM_DELAY_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_HWM_DELAY_START_BIT))

#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_HWM_DELAY_DISABLE << AW87XXX_PID_5A_REG_EN_HWM_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_HWM_DELAY_ENABLE << AW87XXX_PID_5A_REG_EN_HWM_DELAY_START_BIT)

#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_HWM_DELAY_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_HWM_DELAY_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_HWM_DELAY_START_BIT)

/* EN_HW_MODE bit 0 (DFTFR 0x74) */
#define AW87XXX_PID_5A_REG_EN_HW_MODE_START_BIT	(0)
#define AW87XXX_PID_5A_REG_EN_HW_MODE_BITS_LEN	(1)
#define AW87XXX_PID_5A_REG_EN_HW_MODE_MASK	\
	(~(((1<<AW87XXX_PID_5A_REG_EN_HW_MODE_BITS_LEN)-1) << AW87XXX_PID_5A_REG_EN_HW_MODE_START_BIT))

#define AW87XXX_PID_5A_REG_EN_HW_MODE_DISABLE	(0)
#define AW87XXX_PID_5A_REG_EN_HW_MODE_DISABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_HW_MODE_DISABLE << AW87XXX_PID_5A_REG_EN_HW_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_EN_HW_MODE_ENABLE	(1)
#define AW87XXX_PID_5A_REG_EN_HW_MODE_ENABLE_VALUE	\
	(AW87XXX_PID_5A_REG_EN_HW_MODE_ENABLE << AW87XXX_PID_5A_REG_EN_HW_MODE_START_BIT)

#define AW87XXX_PID_5A_REG_EN_HW_MODE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_5A_REG_EN_HW_MODE_DEFAULT	\
	(AW87XXX_PID_5A_REG_EN_HW_MODE_DEFAULT_VALUE << AW87XXX_PID_5A_REG_EN_HW_MODE_START_BIT)

/* default value of DFTFR (0x74) */
/* #define AW87XXX_PID_5A_REG_DFTFR_DEFAULT		(0x00) */

/* detail information of registers end */

#endif  /* #ifndef  __AW87XXX_PID_5A_REG_H__ */