/* SPDX-License-Identifier: GPL-2.0+ */

#ifndef __AW87XXX_PID_18_REG_H__
#define __AW87XXX_PID_18_REG_H__

/* registers list */
#define AW87XXX_PID_18_CHIPID_REG		(0x00)
#define AW87XXX_PID_18_SYSST_REG		(0x01)
#define AW87XXX_PID_18_SYSINT_REG		(0x02)
#define AW87XXX_PID_18_SYSCTRL_REG		(0x03)
#define AW87XXX_PID_18_CPOC_REG			(0x04)
#define AW87XXX_PID_18_CLASSD_REG		(0x05)
#define AW87XXX_PID_18_MADPVTH_REG		(0x06)
#define AW87XXX_PID_18_A3PARAM_REG		(0x07)
#define AW87XXX_PID_18_A3A2PO_REG		(0x08)
#define AW87XXX_PID_18_A2PARAM_REG		(0x09)
#define AW87XXX_PID_18_A1PARAM_REG		(0x0A)
#define AW87XXX_PID_18_POPCLK_REG		(0x0B)
#define AW87XXX_PID_18_GTDRCPSS_REG		(0x0C)
#define AW87XXX_PID_18_MULTI_REG		(0x0D)
#define AW87XXX_PID_18_DFT1_REG			(0x61)
#define AW87XXX_PID_18_DFT2_REG			(0x62)
#define AW87XXX_PID_18_DFT3_REG			(0x63)
#define AW87XXX_PID_18_DFT4_REG			(0x64)
#define AW87XXX_PID_18_DFT5_REG			(0x65)
#define AW87XXX_PID_18_DFT6_REG			(0x66)

#define AW87XXX_PID_18_CLASSD_DEFAULT		(0x10)

/********************************************
 * soft control info
 * If you need to update this file, add this information manually
 *******************************************/
unsigned char aw87xxx_pid_18_softrst_access[2] = {0x00, 0xaa};

/********************************************
 * Register Access
 *******************************************/
#define AW87XXX_PID_18_REG_MAX			(0x67)

#define REG_NONE_ACCESS					(0)
#define REG_RD_ACCESS					(1 << 0)
#define REG_WR_ACCESS					(1 << 1)

const unsigned char aw87xxx_pid_18_reg_access[AW87XXX_PID_18_REG_MAX] = {
	[AW87XXX_PID_18_CHIPID_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_18_SYSST_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_18_SYSINT_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_18_SYSCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_CPOC_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_CLASSD_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_MADPVTH_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_A3PARAM_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_A3A2PO_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_A2PARAM_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_A1PARAM_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_POPCLK_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_GTDRCPSS_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_MULTI_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_DFT1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_DFT2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_DFT3_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_DFT4_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_DFT5_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_18_DFT6_REG]	= (REG_RD_ACCESS),
};

/* detail information of registers begin */
/* CHIPID (0x00) detail */
/* IDCODE bit 7:0 (CHIPID 0x00) */
#define AW87XXX_PID_18_IDCODE_START_BIT	(0)
#define AW87XXX_PID_18_IDCODE_BITS_LEN	(8)
#define AW87XXX_PID_18_IDCODE_MASK		\
	(~(((1<<AW87XXX_PID_18_IDCODE_BITS_LEN)-1) << AW87XXX_PID_18_IDCODE_START_BIT))

#define AW87XXX_PID_18_IDCODE_DEFAULT_VALUE	(0x18)
#define AW87XXX_PID_18_IDCODE_DEFAULT	\
	(AW87XXX_PID_18_IDCODE_DEFAULT_VALUE << AW87XXX_PID_18_IDCODE_START_BIT)

/* default value of CHIPID (0x00) */
/* #define AW87XXX_PID_18_CHIPID_DEFAULT		(0x18) */

/* SYSST (0x01) detail */
/* UVLOS bit 7 (SYSST 0x01) */
#define AW87XXX_PID_18_UVLOS_START_BIT	(7)
#define AW87XXX_PID_18_UVLOS_BITS_LEN	(1)
#define AW87XXX_PID_18_UVLOS_MASK		\
	(~(((1<<AW87XXX_PID_18_UVLOS_BITS_LEN)-1) << AW87XXX_PID_18_UVLOS_START_BIT))

#define AW87XXX_PID_18_UVLOS_NORMAL_OPERATION	(0)
#define AW87XXX_PID_18_UVLOS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_18_UVLOS_NORMAL_OPERATION << AW87XXX_PID_18_UVLOS_START_BIT)

#define AW87XXX_PID_18_UVLOS_VBAT_UNDER_VOLTAGE	(1)
#define AW87XXX_PID_18_UVLOS_VBAT_UNDER_VOLTAGE_VALUE	\
	(AW87XXX_PID_18_UVLOS_VBAT_UNDER_VOLTAGE << AW87XXX_PID_18_UVLOS_START_BIT)

#define AW87XXX_PID_18_UVLOS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_UVLOS_DEFAULT	\
	(AW87XXX_PID_18_UVLOS_DEFAULT_VALUE << AW87XXX_PID_18_UVLOS_START_BIT)

/* OTNS bit 6 (SYSST 0x01) */
#define AW87XXX_PID_18_OTNS_START_BIT	(6)
#define AW87XXX_PID_18_OTNS_BITS_LEN	(1)
#define AW87XXX_PID_18_OTNS_MASK		\
	(~(((1<<AW87XXX_PID_18_OTNS_BITS_LEN)-1) << AW87XXX_PID_18_OTNS_START_BIT))

#define AW87XXX_PID_18_OTNS_PA_OVER_TEMPRETURE_PROTECTION_DETECTED	(0)
#define AW87XXX_PID_18_OTNS_PA_OVER_TEMPRETURE_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_18_OTNS_PA_OVER_TEMPRETURE_PROTECTION_DETECTED << AW87XXX_PID_18_OTNS_START_BIT)

#define AW87XXX_PID_18_OTNS_NORMAL_OPERATION	(1)
#define AW87XXX_PID_18_OTNS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_18_OTNS_NORMAL_OPERATION << AW87XXX_PID_18_OTNS_START_BIT)

#define AW87XXX_PID_18_OTNS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_OTNS_DEFAULT		\
	(AW87XXX_PID_18_OTNS_DEFAULT_VALUE << AW87XXX_PID_18_OTNS_START_BIT)

/* OC_FLAGS bit 5 (SYSST 0x01) */
#define AW87XXX_PID_18_OC_FLAGS_START_BIT	(5)
#define AW87XXX_PID_18_OC_FLAGS_BITS_LEN	(1)
#define AW87XXX_PID_18_OC_FLAGS_MASK	\
	(~(((1<<AW87XXX_PID_18_OC_FLAGS_BITS_LEN)-1) << AW87XXX_PID_18_OC_FLAGS_START_BIT))

#define AW87XXX_PID_18_OC_FLAGS_NORMAL_OPERATION	(0)
#define AW87XXX_PID_18_OC_FLAGS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_18_OC_FLAGS_NORMAL_OPERATION << AW87XXX_PID_18_OC_FLAGS_START_BIT)

#define AW87XXX_PID_18_OC_FLAGS_PA_OVER_CURRENT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_18_OC_FLAGS_PA_OVER_CURRENT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_18_OC_FLAGS_PA_OVER_CURRENT_PROTECTION_DETECTED << AW87XXX_PID_18_OC_FLAGS_START_BIT)

#define AW87XXX_PID_18_OC_FLAGS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_OC_FLAGS_DEFAULT	\
	(AW87XXX_PID_18_OC_FLAGS_DEFAULT_VALUE << AW87XXX_PID_18_OC_FLAGS_START_BIT)

/* VOUTDECTS bit 4 (SYSST 0x01) */
#define AW87XXX_PID_18_VOUTDECTS_START_BIT	(4)
#define AW87XXX_PID_18_VOUTDECTS_BITS_LEN	(1)
#define AW87XXX_PID_18_VOUTDECTS_MASK	\
	(~(((1<<AW87XXX_PID_18_VOUTDECTS_BITS_LEN)-1) << AW87XXX_PID_18_VOUTDECTS_START_BIT))

#define AW87XXX_PID_18_VOUTDECTS_PVDDBELOWVDD	(0)
#define AW87XXX_PID_18_VOUTDECTS_PVDDBELOWVDD_VALUE	\
	(AW87XXX_PID_18_VOUTDECTS_PVDDBELOWVDD << AW87XXX_PID_18_VOUTDECTS_START_BIT)

#define AW87XXX_PID_18_VOUTDECTS_PVDDABOVEVDD	(1)
#define AW87XXX_PID_18_VOUTDECTS_PVDDABOVEVDD_VALUE	\
	(AW87XXX_PID_18_VOUTDECTS_PVDDABOVEVDD << AW87XXX_PID_18_VOUTDECTS_START_BIT)

#define AW87XXX_PID_18_VOUTDECTS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_VOUTDECTS_DEFAULT	\
	(AW87XXX_PID_18_VOUTDECTS_DEFAULT_VALUE << AW87XXX_PID_18_VOUTDECTS_START_BIT)

/* STARTOKS bit 3 (SYSST 0x01) */
#define AW87XXX_PID_18_STARTOKS_START_BIT	(3)
#define AW87XXX_PID_18_STARTOKS_BITS_LEN	(1)
#define AW87XXX_PID_18_STARTOKS_MASK	\
	(~(((1<<AW87XXX_PID_18_STARTOKS_BITS_LEN)-1) << AW87XXX_PID_18_STARTOKS_START_BIT))

#define AW87XXX_PID_18_STARTOKS_CP_START_FAIL_DECTECTED	(0)
#define AW87XXX_PID_18_STARTOKS_CP_START_FAIL_DECTECTED_VALUE	\
	(AW87XXX_PID_18_STARTOKS_CP_START_FAIL_DECTECTED << AW87XXX_PID_18_STARTOKS_START_BIT)

#define AW87XXX_PID_18_STARTOKS_NORMAL_OPERATION	(1)
#define AW87XXX_PID_18_STARTOKS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_18_STARTOKS_NORMAL_OPERATION << AW87XXX_PID_18_STARTOKS_START_BIT)

#define AW87XXX_PID_18_STARTOKS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_STARTOKS_DEFAULT	\
	(AW87XXX_PID_18_STARTOKS_DEFAULT_VALUE << AW87XXX_PID_18_STARTOKS_START_BIT)

/* VBGOKN1S bit 2 (SYSST 0x01) */
#define AW87XXX_PID_18_VBGOKN1S_START_BIT	(2)
#define AW87XXX_PID_18_VBGOKN1S_BITS_LEN	(1)
#define AW87XXX_PID_18_VBGOKN1S_MASK	\
	(~(((1<<AW87XXX_PID_18_VBGOKN1S_BITS_LEN)-1) << AW87XXX_PID_18_VBGOKN1S_START_BIT))

#define AW87XXX_PID_18_VBGOKN1S_NORMAL_WORKS	(0)
#define AW87XXX_PID_18_VBGOKN1S_NORMAL_WORKS_VALUE	\
	(AW87XXX_PID_18_VBGOKN1S_NORMAL_WORKS << AW87XXX_PID_18_VBGOKN1S_START_BIT)

#define AW87XXX_PID_18_VBGOKN1S_ABNORMAL_WORKS	(1)
#define AW87XXX_PID_18_VBGOKN1S_ABNORMAL_WORKS_VALUE	\
	(AW87XXX_PID_18_VBGOKN1S_ABNORMAL_WORKS << AW87XXX_PID_18_VBGOKN1S_START_BIT)

#define AW87XXX_PID_18_VBGOKN1S_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_VBGOKN1S_DEFAULT	\
	(AW87XXX_PID_18_VBGOKN1S_DEFAULT_VALUE << AW87XXX_PID_18_VBGOKN1S_START_BIT)

/* OVPS bit 1 (SYSST 0x01) */
#define AW87XXX_PID_18_OVPS_START_BIT	(1)
#define AW87XXX_PID_18_OVPS_BITS_LEN	(1)
#define AW87XXX_PID_18_OVPS_MASK		\
	(~(((1<<AW87XXX_PID_18_OVPS_BITS_LEN)-1) << AW87XXX_PID_18_OVPS_START_BIT))

#define AW87XXX_PID_18_OVPS_NORMAL_OPERATION	(0)
#define AW87XXX_PID_18_OVPS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_18_OVPS_NORMAL_OPERATION << AW87XXX_PID_18_OVPS_START_BIT)

#define AW87XXX_PID_18_OVPS_CP_OVP_DETECTED	(1)
#define AW87XXX_PID_18_OVPS_CP_OVP_DETECTED_VALUE	\
	(AW87XXX_PID_18_OVPS_CP_OVP_DETECTED << AW87XXX_PID_18_OVPS_START_BIT)

#define AW87XXX_PID_18_OVPS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_OVPS_DEFAULT		\
	(AW87XXX_PID_18_OVPS_DEFAULT_VALUE << AW87XXX_PID_18_OVPS_START_BIT)

/* CP_2PS bit 0 (SYSST 0x01) */
#define AW87XXX_PID_18_CP_2PS_START_BIT	(0)
#define AW87XXX_PID_18_CP_2PS_BITS_LEN	(1)
#define AW87XXX_PID_18_CP_2PS_MASK		\
	(~(((1<<AW87XXX_PID_18_CP_2PS_BITS_LEN)-1) << AW87XXX_PID_18_CP_2PS_START_BIT))

#define AW87XXX_PID_18_CP_2PS_WEAK_SIGNAL	(0)
#define AW87XXX_PID_18_CP_2PS_WEAK_SIGNAL_VALUE	\
	(AW87XXX_PID_18_CP_2PS_WEAK_SIGNAL << AW87XXX_PID_18_CP_2PS_START_BIT)

#define AW87XXX_PID_18_CP_2PS_STRONG_SIGNAL	(1)
#define AW87XXX_PID_18_CP_2PS_STRONG_SIGNAL_VALUE	\
	(AW87XXX_PID_18_CP_2PS_STRONG_SIGNAL << AW87XXX_PID_18_CP_2PS_START_BIT)

#define AW87XXX_PID_18_CP_2PS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_CP_2PS_DEFAULT	\
	(AW87XXX_PID_18_CP_2PS_DEFAULT_VALUE << AW87XXX_PID_18_CP_2PS_START_BIT)

/* default value of SYSST (0x01) */
/* #define AW87XXX_PID_18_SYSST_DEFAULT		(0x00) */

/* SYSINT (0x02) detail */
/* UVLOI bit 7 (SYSINT 0x02) */
#define AW87XXX_PID_18_UVLOI_START_BIT	(7)
#define AW87XXX_PID_18_UVLOI_BITS_LEN	(1)
#define AW87XXX_PID_18_UVLOI_MASK		\
	(~(((1<<AW87XXX_PID_18_UVLOI_BITS_LEN)-1) << AW87XXX_PID_18_UVLOI_START_BIT))

#define AW87XXX_PID_18_UVLOI_SIGNAL_STATUS_DO_NOT_CHANGE	(0)
#define AW87XXX_PID_18_UVLOI_SIGNAL_STATUS_DO_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_18_UVLOI_SIGNAL_STATUS_DO_NOT_CHANGE << AW87XXX_PID_18_UVLOI_START_BIT)

#define AW87XXX_PID_18_UVLOI_UNDER_VOLTAGE_LOCK_OUT_DETECTED	(1)
#define AW87XXX_PID_18_UVLOI_UNDER_VOLTAGE_LOCK_OUT_DETECTED_VALUE	\
	(AW87XXX_PID_18_UVLOI_UNDER_VOLTAGE_LOCK_OUT_DETECTED << AW87XXX_PID_18_UVLOI_START_BIT)

#define AW87XXX_PID_18_UVLOI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_UVLOI_DEFAULT	\
	(AW87XXX_PID_18_UVLOI_DEFAULT_VALUE << AW87XXX_PID_18_UVLOI_START_BIT)

/* OTNI bit 6 (SYSINT 0x02) */
#define AW87XXX_PID_18_OTNI_START_BIT	(6)
#define AW87XXX_PID_18_OTNI_BITS_LEN	(1)
#define AW87XXX_PID_18_OTNI_MASK		\
	(~(((1<<AW87XXX_PID_18_OTNI_BITS_LEN)-1) << AW87XXX_PID_18_OTNI_START_BIT))

#define AW87XXX_PID_18_OTNI_SIGNAL_STATUS_DO_NOT_CHANGE	(0)
#define AW87XXX_PID_18_OTNI_SIGNAL_STATUS_DO_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_18_OTNI_SIGNAL_STATUS_DO_NOT_CHANGE << AW87XXX_PID_18_OTNI_START_BIT)

#define AW87XXX_PID_18_OTNI_OVER_TEMPRETURE_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_18_OTNI_OVER_TEMPRETURE_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_18_OTNI_OVER_TEMPRETURE_PROTECTION_DETECTED << AW87XXX_PID_18_OTNI_START_BIT)

#define AW87XXX_PID_18_OTNI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_OTNI_DEFAULT		\
	(AW87XXX_PID_18_OTNI_DEFAULT_VALUE << AW87XXX_PID_18_OTNI_START_BIT)

/* OC_FLAGI bit 5 (SYSINT 0x02) */
#define AW87XXX_PID_18_OC_FLAGI_START_BIT	(5)
#define AW87XXX_PID_18_OC_FLAGI_BITS_LEN	(1)
#define AW87XXX_PID_18_OC_FLAGI_MASK	\
	(~(((1<<AW87XXX_PID_18_OC_FLAGI_BITS_LEN)-1) << AW87XXX_PID_18_OC_FLAGI_START_BIT))

#define AW87XXX_PID_18_OC_FLAGI_SIGNAL_STATUS_DO_NOT_CHANGE	(0)
#define AW87XXX_PID_18_OC_FLAGI_SIGNAL_STATUS_DO_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_18_OC_FLAGI_SIGNAL_STATUS_DO_NOT_CHANGE << AW87XXX_PID_18_OC_FLAGI_START_BIT)

#define AW87XXX_PID_18_OC_FLAGI_PA_OVER_CURRENT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_18_OC_FLAGI_PA_OVER_CURRENT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_18_OC_FLAGI_PA_OVER_CURRENT_PROTECTION_DETECTED << AW87XXX_PID_18_OC_FLAGI_START_BIT)

#define AW87XXX_PID_18_OC_FLAGI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_OC_FLAGI_DEFAULT	\
	(AW87XXX_PID_18_OC_FLAGI_DEFAULT_VALUE << AW87XXX_PID_18_OC_FLAGI_START_BIT)

/* VOUTDECTI bit 4 (SYSINT 0x02) */
#define AW87XXX_PID_18_VOUTDECTI_START_BIT	(4)
#define AW87XXX_PID_18_VOUTDECTI_BITS_LEN	(1)
#define AW87XXX_PID_18_VOUTDECTI_MASK	\
	(~(((1<<AW87XXX_PID_18_VOUTDECTI_BITS_LEN)-1) << AW87XXX_PID_18_VOUTDECTI_START_BIT))

#define AW87XXX_PID_18_VOUTDECTI_PVDDBELOWVDD	(0)
#define AW87XXX_PID_18_VOUTDECTI_PVDDBELOWVDD_VALUE	\
	(AW87XXX_PID_18_VOUTDECTI_PVDDBELOWVDD << AW87XXX_PID_18_VOUTDECTI_START_BIT)

#define AW87XXX_PID_18_VOUTDECTI_PVDDABOVEVDD	(1)
#define AW87XXX_PID_18_VOUTDECTI_PVDDABOVEVDD_VALUE	\
	(AW87XXX_PID_18_VOUTDECTI_PVDDABOVEVDD << AW87XXX_PID_18_VOUTDECTI_START_BIT)

#define AW87XXX_PID_18_VOUTDECTI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_VOUTDECTI_DEFAULT	\
	(AW87XXX_PID_18_VOUTDECTI_DEFAULT_VALUE << AW87XXX_PID_18_VOUTDECTI_START_BIT)

/* STARTOKI bit 3 (SYSINT 0x02) */
#define AW87XXX_PID_18_STARTOKI_START_BIT	(3)
#define AW87XXX_PID_18_STARTOKI_BITS_LEN	(1)
#define AW87XXX_PID_18_STARTOKI_MASK	\
	(~(((1<<AW87XXX_PID_18_STARTOKI_BITS_LEN)-1) << AW87XXX_PID_18_STARTOKI_START_BIT))

#define AW87XXX_PID_18_STARTOKI_SIGNAL_STATUS_DO_NOT_CHANGE	(0)
#define AW87XXX_PID_18_STARTOKI_SIGNAL_STATUS_DO_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_18_STARTOKI_SIGNAL_STATUS_DO_NOT_CHANGE << AW87XXX_PID_18_STARTOKI_START_BIT)

#define AW87XXX_PID_18_STARTOKI_CHARGEPUMB_START_UP_OK_DECTECTED	(1)
#define AW87XXX_PID_18_STARTOKI_CHARGEPUMB_START_UP_OK_DECTECTED_VALUE	\
	(AW87XXX_PID_18_STARTOKI_CHARGEPUMB_START_UP_OK_DECTECTED << AW87XXX_PID_18_STARTOKI_START_BIT)

#define AW87XXX_PID_18_STARTOKI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_STARTOKI_DEFAULT	\
	(AW87XXX_PID_18_STARTOKI_DEFAULT_VALUE << AW87XXX_PID_18_STARTOKI_START_BIT)

/* VBGOKN1I bit 2 (SYSINT 0x02) */
#define AW87XXX_PID_18_VBGOKN1I_START_BIT	(2)
#define AW87XXX_PID_18_VBGOKN1I_BITS_LEN	(1)
#define AW87XXX_PID_18_VBGOKN1I_MASK	\
	(~(((1<<AW87XXX_PID_18_VBGOKN1I_BITS_LEN)-1) << AW87XXX_PID_18_VBGOKN1I_START_BIT))

#define AW87XXX_PID_18_VBGOKN1I_NORMAL_WORKS	(0)
#define AW87XXX_PID_18_VBGOKN1I_NORMAL_WORKS_VALUE	\
	(AW87XXX_PID_18_VBGOKN1I_NORMAL_WORKS << AW87XXX_PID_18_VBGOKN1I_START_BIT)

#define AW87XXX_PID_18_VBGOKN1I_ABNORMAL_WORKS	(1)
#define AW87XXX_PID_18_VBGOKN1I_ABNORMAL_WORKS_VALUE	\
	(AW87XXX_PID_18_VBGOKN1I_ABNORMAL_WORKS << AW87XXX_PID_18_VBGOKN1I_START_BIT)

#define AW87XXX_PID_18_VBGOKN1I_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_VBGOKN1I_DEFAULT	\
	(AW87XXX_PID_18_VBGOKN1I_DEFAULT_VALUE << AW87XXX_PID_18_VBGOKN1I_START_BIT)

/* OVPI bit 1 (SYSINT 0x02) */
#define AW87XXX_PID_18_OVPI_START_BIT	(1)
#define AW87XXX_PID_18_OVPI_BITS_LEN	(1)
#define AW87XXX_PID_18_OVPI_MASK		\
	(~(((1<<AW87XXX_PID_18_OVPI_BITS_LEN)-1) << AW87XXX_PID_18_OVPI_START_BIT))

#define AW87XXX_PID_18_OVPI_NORMAL_OPERATION	(0)
#define AW87XXX_PID_18_OVPI_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_18_OVPI_NORMAL_OPERATION << AW87XXX_PID_18_OVPI_START_BIT)

#define AW87XXX_PID_18_OVPI_CP_OVP_DETECTED	(1)
#define AW87XXX_PID_18_OVPI_CP_OVP_DETECTED_VALUE	\
	(AW87XXX_PID_18_OVPI_CP_OVP_DETECTED << AW87XXX_PID_18_OVPI_START_BIT)

#define AW87XXX_PID_18_OVPI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_OVPI_DEFAULT		\
	(AW87XXX_PID_18_OVPI_DEFAULT_VALUE << AW87XXX_PID_18_OVPI_START_BIT)

/* CP_2PI bit 0 (SYSINT 0x02) */
#define AW87XXX_PID_18_CP_2PI_START_BIT	(0)
#define AW87XXX_PID_18_CP_2PI_BITS_LEN	(1)
#define AW87XXX_PID_18_CP_2PI_MASK		\
	(~(((1<<AW87XXX_PID_18_CP_2PI_BITS_LEN)-1) << AW87XXX_PID_18_CP_2PI_START_BIT))

#define AW87XXX_PID_18_CP_2PI_WEAK_SIGNAL	(0)
#define AW87XXX_PID_18_CP_2PI_WEAK_SIGNAL_VALUE	\
	(AW87XXX_PID_18_CP_2PI_WEAK_SIGNAL << AW87XXX_PID_18_CP_2PI_START_BIT)

#define AW87XXX_PID_18_CP_2PI_STRONG_SIGNAL	(1)
#define AW87XXX_PID_18_CP_2PI_STRONG_SIGNAL_VALUE	\
	(AW87XXX_PID_18_CP_2PI_STRONG_SIGNAL << AW87XXX_PID_18_CP_2PI_START_BIT)

#define AW87XXX_PID_18_CP_2PI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_CP_2PI_DEFAULT	\
	(AW87XXX_PID_18_CP_2PI_DEFAULT_VALUE << AW87XXX_PID_18_CP_2PI_START_BIT)

/* default value of SYSINT (0x02) */
/* #define AW87XXX_PID_18_SYSINT_DEFAULT		(0x00) */

/* SYSCTRL (0x03) detail */
/* EN_SS bit 7 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_EN_SS_START_BIT	(7)
#define AW87XXX_PID_18_EN_SS_BITS_LEN	(1)
#define AW87XXX_PID_18_EN_SS_MASK		\
	(~(((1<<AW87XXX_PID_18_EN_SS_BITS_LEN)-1) << AW87XXX_PID_18_EN_SS_START_BIT))

#define AW87XXX_PID_18_EN_SS_DISABLE_REG_FSS11001P6MHZ	(0)
#define AW87XXX_PID_18_EN_SS_DISABLE_REG_FSS11001P6MHZ_VALUE	\
	(AW87XXX_PID_18_EN_SS_DISABLE_REG_FSS11001P6MHZ << AW87XXX_PID_18_EN_SS_START_BIT)

#define AW87XXX_PID_18_EN_SS_ENABLE		(1)
#define AW87XXX_PID_18_EN_SS_ENABLE_VALUE	\
	(AW87XXX_PID_18_EN_SS_ENABLE << AW87XXX_PID_18_EN_SS_START_BIT)

#define AW87XXX_PID_18_EN_SS_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_EN_SS_DEFAULT	\
	(AW87XXX_PID_18_EN_SS_DEFAULT_VALUE << AW87XXX_PID_18_EN_SS_START_BIT)

/* REG_EN_SW bit 6 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_REG_EN_SW_START_BIT	(6)
#define AW87XXX_PID_18_REG_EN_SW_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_SW_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_SW_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_SW_START_BIT))

#define AW87XXX_PID_18_REG_EN_SW_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_SW_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_SW_DISABLE << AW87XXX_PID_18_REG_EN_SW_START_BIT)

#define AW87XXX_PID_18_REG_EN_SW_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_SW_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_SW_ENABLE << AW87XXX_PID_18_REG_EN_SW_START_BIT)

#define AW87XXX_PID_18_REG_EN_SW_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_EN_SW_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_SW_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_SW_START_BIT)

/* REG_EN_PA bit 5 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_REG_EN_PA_START_BIT	(5)
#define AW87XXX_PID_18_REG_EN_PA_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_PA_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_PA_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_PA_START_BIT))

#define AW87XXX_PID_18_REG_EN_PA_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_PA_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_PA_DISABLE << AW87XXX_PID_18_REG_EN_PA_START_BIT)

#define AW87XXX_PID_18_REG_EN_PA_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_PA_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_PA_ENABLE << AW87XXX_PID_18_REG_EN_PA_START_BIT)

#define AW87XXX_PID_18_REG_EN_PA_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_EN_PA_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_PA_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_PA_START_BIT)

/* REG_EN_ADAP bit 4 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_REG_EN_ADAP_START_BIT	(4)
#define AW87XXX_PID_18_REG_EN_ADAP_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_ADAP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_ADAP_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_ADAP_START_BIT))

#define AW87XXX_PID_18_REG_EN_ADAP_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_ADAP_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_ADAP_DISABLE << AW87XXX_PID_18_REG_EN_ADAP_START_BIT)

#define AW87XXX_PID_18_REG_EN_ADAP_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_ADAP_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_ADAP_ENABLE << AW87XXX_PID_18_REG_EN_ADAP_START_BIT)

#define AW87XXX_PID_18_REG_EN_ADAP_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EN_ADAP_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_ADAP_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_ADAP_START_BIT)

/* REG_EN_MPD bit 3 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_REG_EN_MPD_START_BIT	(3)
#define AW87XXX_PID_18_REG_EN_MPD_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_MPD_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_MPD_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_MPD_START_BIT))

#define AW87XXX_PID_18_REG_EN_MPD_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_MPD_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_MPD_DISABLE << AW87XXX_PID_18_REG_EN_MPD_START_BIT)

#define AW87XXX_PID_18_REG_EN_MPD_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_MPD_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_MPD_ENABLE << AW87XXX_PID_18_REG_EN_MPD_START_BIT)

#define AW87XXX_PID_18_REG_EN_MPD_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EN_MPD_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_MPD_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_MPD_START_BIT)

/* REG_EN_CP bit 2 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_REG_EN_CP_START_BIT	(2)
#define AW87XXX_PID_18_REG_EN_CP_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_CP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_CP_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_CP_START_BIT))

#define AW87XXX_PID_18_REG_EN_CP_DISABLE_PVDDVBAT_DIRECT_TROUGH_MODE	(0)
#define AW87XXX_PID_18_REG_EN_CP_DISABLE_PVDDVBAT_DIRECT_TROUGH_MODE_VALUE	\
	(AW87XXX_PID_18_REG_EN_CP_DISABLE_PVDDVBAT_DIRECT_TROUGH_MODE << AW87XXX_PID_18_REG_EN_CP_START_BIT)

#define AW87XXX_PID_18_REG_EN_CP_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_CP_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_CP_ENABLE << AW87XXX_PID_18_REG_EN_CP_START_BIT)

#define AW87XXX_PID_18_REG_EN_CP_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_EN_CP_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_CP_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_CP_START_BIT)

/* REG_REC_MODE bit 1 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_REG_REC_MODE_START_BIT	(1)
#define AW87XXX_PID_18_REG_REC_MODE_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_REC_MODE_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_REC_MODE_BITS_LEN)-1) << AW87XXX_PID_18_REG_REC_MODE_START_BIT))

#define AW87XXX_PID_18_REG_REC_MODE_DISABLE	(0)
#define AW87XXX_PID_18_REG_REC_MODE_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_REC_MODE_DISABLE << AW87XXX_PID_18_REG_REC_MODE_START_BIT)

#define AW87XXX_PID_18_REG_REC_MODE_ENABLE	(1)
#define AW87XXX_PID_18_REG_REC_MODE_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_REC_MODE_ENABLE << AW87XXX_PID_18_REG_REC_MODE_START_BIT)

#define AW87XXX_PID_18_REG_REC_MODE_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_REC_MODE_DEFAULT	\
	(AW87XXX_PID_18_REG_REC_MODE_DEFAULT_VALUE << AW87XXX_PID_18_REG_REC_MODE_START_BIT)

/* REG_FORCE_2X bit 0 (SYSCTRL 0x03) */
#define AW87XXX_PID_18_REG_FORCE_2X_START_BIT	(0)
#define AW87XXX_PID_18_REG_FORCE_2X_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_FORCE_2X_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_FORCE_2X_BITS_LEN)-1) << AW87XXX_PID_18_REG_FORCE_2X_START_BIT))

#define AW87XXX_PID_18_REG_FORCE_2X_DISABLE_CPS_WORKING_STATUS_DEPENDS_ON_THE_SYSTEM	(0)
#define AW87XXX_PID_18_REG_FORCE_2X_DISABLE_CPS_WORKING_STATUS_DEPENDS_ON_THE_SYSTEM_VALUE	\
	(AW87XXX_PID_18_REG_FORCE_2X_DISABLE_CPS_WORKING_STATUS_DEPENDS_ON_THE_SYSTEM << AW87XXX_PID_18_REG_FORCE_2X_START_BIT)

#define AW87XXX_PID_18_REG_FORCE_2X_ENABLE_FORCE_THE_CP_WORKS_IN_X2_MODE	(1)
#define AW87XXX_PID_18_REG_FORCE_2X_ENABLE_FORCE_THE_CP_WORKS_IN_X2_MODE_VALUE	\
	(AW87XXX_PID_18_REG_FORCE_2X_ENABLE_FORCE_THE_CP_WORKS_IN_X2_MODE << AW87XXX_PID_18_REG_FORCE_2X_START_BIT)

#define AW87XXX_PID_18_REG_FORCE_2X_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_FORCE_2X_DEFAULT	\
	(AW87XXX_PID_18_REG_FORCE_2X_DEFAULT_VALUE << AW87XXX_PID_18_REG_FORCE_2X_START_BIT)

/* default value of SYSCTRL (0x03) */
/* #define AW87XXX_PID_18_SYSCTRL_DEFAULT		(0xE5) */

/* CPOC (0x04) detail */
/* REG_CP_OVP bit 5:2 (CPOC 0x04) */
#define AW87XXX_PID_18_REG_CP_OVP_START_BIT	(2)
#define AW87XXX_PID_18_REG_CP_OVP_BITS_LEN	(4)
#define AW87XXX_PID_18_REG_CP_OVP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CP_OVP_BITS_LEN)-1) << AW87XXX_PID_18_REG_CP_OVP_START_BIT))

#define AW87XXX_PID_18_REG_CP_OVP_8P5V	(8)
#define AW87XXX_PID_18_REG_CP_OVP_8P5V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_8P5V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_8P25V	(7)
#define AW87XXX_PID_18_REG_CP_OVP_8P25V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_8P25V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_8V	(6)
#define AW87XXX_PID_18_REG_CP_OVP_8V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_8V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_7P75V	(5)
#define AW87XXX_PID_18_REG_CP_OVP_7P75V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_7P75V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_7P5V	(4)
#define AW87XXX_PID_18_REG_CP_OVP_7P5V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_7P5V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_7P25V	(3)
#define AW87XXX_PID_18_REG_CP_OVP_7P25V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_7P25V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_7V	(2)
#define AW87XXX_PID_18_REG_CP_OVP_7V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_7V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_6P75V	(1)
#define AW87XXX_PID_18_REG_CP_OVP_6P75V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_6P75V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_6P5V	(0)
#define AW87XXX_PID_18_REG_CP_OVP_6P5V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_6P5V << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_DEFAULT_VALUE	(0x6)
#define AW87XXX_PID_18_REG_CP_OVP_DEFAULT	\
	(AW87XXX_PID_18_REG_CP_OVP_DEFAULT_VALUE << AW87XXX_PID_18_REG_CP_OVP_START_BIT)

/* REG_OC_DELAY bit 1:0 (CPOC 0x04) */
#define AW87XXX_PID_18_REG_OC_DELAY_START_BIT	(0)
#define AW87XXX_PID_18_REG_OC_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_OC_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_OC_DELAY_BITS_LEN)-1) << AW87XXX_PID_18_REG_OC_DELAY_START_BIT))

#define AW87XXX_PID_18_REG_OC_DELAY_60NS	(0)
#define AW87XXX_PID_18_REG_OC_DELAY_60NS_VALUE	\
	(AW87XXX_PID_18_REG_OC_DELAY_60NS << AW87XXX_PID_18_REG_OC_DELAY_START_BIT)

#define AW87XXX_PID_18_REG_OC_DELAY_80NS	(1)
#define AW87XXX_PID_18_REG_OC_DELAY_80NS_VALUE	\
	(AW87XXX_PID_18_REG_OC_DELAY_80NS << AW87XXX_PID_18_REG_OC_DELAY_START_BIT)

#define AW87XXX_PID_18_REG_OC_DELAY_90NS	(2)
#define AW87XXX_PID_18_REG_OC_DELAY_90NS_VALUE	\
	(AW87XXX_PID_18_REG_OC_DELAY_90NS << AW87XXX_PID_18_REG_OC_DELAY_START_BIT)

#define AW87XXX_PID_18_REG_OC_DELAY_110NS	(3)
#define AW87XXX_PID_18_REG_OC_DELAY_110NS_VALUE	\
	(AW87XXX_PID_18_REG_OC_DELAY_110NS << AW87XXX_PID_18_REG_OC_DELAY_START_BIT)

#define AW87XXX_PID_18_REG_OC_DELAY_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_OC_DELAY_DEFAULT	\
	(AW87XXX_PID_18_REG_OC_DELAY_DEFAULT_VALUE << AW87XXX_PID_18_REG_OC_DELAY_START_BIT)

/* default value of CPOC (0x04) */
/* #define AW87XXX_PID_18_CPOC_DEFAULT		(0x18) */

/* CLASSD (0x05) detail */
/* REG_BK1 bit 7 (CLASSD 0x05) */
#define AW87XXX_PID_18_REG_BK1_START_BIT	(7)
#define AW87XXX_PID_18_REG_BK1_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_BK1_MASK		\
	(~(((1<<AW87XXX_PID_18_REG_BK1_BITS_LEN)-1) << AW87XXX_PID_18_REG_BK1_START_BIT))

#define AW87XXX_PID_18_REG_BK1_22MV		(0)
#define AW87XXX_PID_18_REG_BK1_22MV_VALUE	\
	(AW87XXX_PID_18_REG_BK1_22MV << AW87XXX_PID_18_REG_BK1_START_BIT)

#define AW87XXX_PID_18_REG_BK1_15MV		(1)
#define AW87XXX_PID_18_REG_BK1_15MV_VALUE	\
	(AW87XXX_PID_18_REG_BK1_15MV << AW87XXX_PID_18_REG_BK1_START_BIT)

#define AW87XXX_PID_18_REG_BK1_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_BK1_DEFAULT	\
	(AW87XXX_PID_18_REG_BK1_DEFAULT_VALUE << AW87XXX_PID_18_REG_BK1_START_BIT)

/* REG_BK2 bit 6 (CLASSD 0x05) */
#define AW87XXX_PID_18_REG_BK2_START_BIT	(6)
#define AW87XXX_PID_18_REG_BK2_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_BK2_MASK		\
	(~(((1<<AW87XXX_PID_18_REG_BK2_BITS_LEN)-1) << AW87XXX_PID_18_REG_BK2_START_BIT))

#define AW87XXX_PID_18_REG_BK2_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_BK2_DEFAULT	\
	(AW87XXX_PID_18_REG_BK2_DEFAULT_VALUE << AW87XXX_PID_18_REG_BK2_START_BIT)

/* REG_BK3 bit 5 (CLASSD 0x05) */
#define AW87XXX_PID_18_REG_BK3_START_BIT	(5)
#define AW87XXX_PID_18_REG_BK3_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_BK3_MASK		\
	(~(((1<<AW87XXX_PID_18_REG_BK3_BITS_LEN)-1) << AW87XXX_PID_18_REG_BK3_START_BIT))

#define AW87XXX_PID_18_REG_BK3_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_BK3_DEFAULT	\
	(AW87XXX_PID_18_REG_BK3_DEFAULT_VALUE << AW87XXX_PID_18_REG_BK3_START_BIT)

/* REG_D_GAIN bit 4:0 (CLASSD 0x05) */
#define AW87XXX_PID_18_REG_D_GAIN_START_BIT	(0)
#define AW87XXX_PID_18_REG_D_GAIN_BITS_LEN	(5)
#define AW87XXX_PID_18_REG_D_GAIN_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_D_GAIN_BITS_LEN)-1) << AW87XXX_PID_18_REG_D_GAIN_START_BIT))

#define AW87XXX_PID_18_REG_D_GAIN_0DB	(0)
#define AW87XXX_PID_18_REG_D_GAIN_0DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_0DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_1P5DB	(1)
#define AW87XXX_PID_18_REG_D_GAIN_1P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_1P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_3DB	(2)
#define AW87XXX_PID_18_REG_D_GAIN_3DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_3DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_4P5DB	(3)
#define AW87XXX_PID_18_REG_D_GAIN_4P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_4P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_6DB	(4)
#define AW87XXX_PID_18_REG_D_GAIN_6DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_6DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_7P5DB	(5)
#define AW87XXX_PID_18_REG_D_GAIN_7P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_7P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_9DB	(6)
#define AW87XXX_PID_18_REG_D_GAIN_9DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_9DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_10P5DB	(7)
#define AW87XXX_PID_18_REG_D_GAIN_10P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_10P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_12DB	(8)
#define AW87XXX_PID_18_REG_D_GAIN_12DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_12DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_13P5DB	(9)
#define AW87XXX_PID_18_REG_D_GAIN_13P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_13P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_15DB	(10)
#define AW87XXX_PID_18_REG_D_GAIN_15DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_15DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_16P5DB	(11)
#define AW87XXX_PID_18_REG_D_GAIN_16P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_16P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_18DB	(12)
#define AW87XXX_PID_18_REG_D_GAIN_18DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_18DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_19P5DB	(13)
#define AW87XXX_PID_18_REG_D_GAIN_19P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_19P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_21DB	(14)
#define AW87XXX_PID_18_REG_D_GAIN_21DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_21DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_22P5DB	(15)
#define AW87XXX_PID_18_REG_D_GAIN_22P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_22P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_24DB	(16)
#define AW87XXX_PID_18_REG_D_GAIN_24DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_24DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_25P5DB	(17)
#define AW87XXX_PID_18_REG_D_GAIN_25P5DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_25P5DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_27DB	(18)
#define AW87XXX_PID_18_REG_D_GAIN_27DB_VALUE	\
	(AW87XXX_PID_18_REG_D_GAIN_27DB << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

#define AW87XXX_PID_18_REG_D_GAIN_DEFAULT_VALUE	(0x10)
#define AW87XXX_PID_18_REG_D_GAIN_DEFAULT	\
	(AW87XXX_PID_18_REG_D_GAIN_DEFAULT_VALUE << AW87XXX_PID_18_REG_D_GAIN_START_BIT)

/* default value of CLASSD (0x05) */
/* #define AW87XXX_PID_18_CLASSD_DEFAULT		(0x10) */

/* MADPVTH (0x06) detail */
/* REG_ADAP_VTH bit 3:2 (MADPVTH 0x06) */
#define AW87XXX_PID_18_REG_ADAP_VTH_START_BIT	(2)
#define AW87XXX_PID_18_REG_ADAP_VTH_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_ADAP_VTH_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_ADAP_VTH_BITS_LEN)-1) << AW87XXX_PID_18_REG_ADAP_VTH_START_BIT))

#define AW87XXX_PID_18_REG_ADAP_VTH_0P1W0P05W	(0)
#define AW87XXX_PID_18_REG_ADAP_VTH_0P1W0P05W_VALUE	\
	(AW87XXX_PID_18_REG_ADAP_VTH_0P1W0P05W << AW87XXX_PID_18_REG_ADAP_VTH_START_BIT)

#define AW87XXX_PID_18_REG_ADAP_VTH_0P2W0P15W	(1)
#define AW87XXX_PID_18_REG_ADAP_VTH_0P2W0P15W_VALUE	\
	(AW87XXX_PID_18_REG_ADAP_VTH_0P2W0P15W << AW87XXX_PID_18_REG_ADAP_VTH_START_BIT)

#define AW87XXX_PID_18_REG_ADAP_VTH_0P3W0P25W	(2)
#define AW87XXX_PID_18_REG_ADAP_VTH_0P3W0P25W_VALUE	\
	(AW87XXX_PID_18_REG_ADAP_VTH_0P3W0P25W << AW87XXX_PID_18_REG_ADAP_VTH_START_BIT)

#define AW87XXX_PID_18_REG_ADAP_VTH_0P4W0P35W	(3)
#define AW87XXX_PID_18_REG_ADAP_VTH_0P4W0P35W_VALUE	\
	(AW87XXX_PID_18_REG_ADAP_VTH_0P4W0P35W << AW87XXX_PID_18_REG_ADAP_VTH_START_BIT)

#define AW87XXX_PID_18_REG_ADAP_VTH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_ADAP_VTH_DEFAULT	\
	(AW87XXX_PID_18_REG_ADAP_VTH_DEFAULT_VALUE << AW87XXX_PID_18_REG_ADAP_VTH_START_BIT)

/* REG_MPD_VTH bit 1:0 (MADPVTH 0x06) */
#define AW87XXX_PID_18_REG_MPD_VTH_START_BIT	(0)
#define AW87XXX_PID_18_REG_MPD_VTH_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_MPD_VTH_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_MPD_VTH_BITS_LEN)-1) << AW87XXX_PID_18_REG_MPD_VTH_START_BIT))

#define AW87XXX_PID_18_REG_MPD_VTH_8P1MW3P6MW	(0)
#define AW87XXX_PID_18_REG_MPD_VTH_8P1MW3P6MW_VALUE	\
	(AW87XXX_PID_18_REG_MPD_VTH_8P1MW3P6MW << AW87XXX_PID_18_REG_MPD_VTH_START_BIT)

#define AW87XXX_PID_18_REG_MPD_VTH_11MW5P6MW	(1)
#define AW87XXX_PID_18_REG_MPD_VTH_11MW5P6MW_VALUE	\
	(AW87XXX_PID_18_REG_MPD_VTH_11MW5P6MW << AW87XXX_PID_18_REG_MPD_VTH_START_BIT)

#define AW87XXX_PID_18_REG_MPD_VTH_14P4MW8P1MW	(2)
#define AW87XXX_PID_18_REG_MPD_VTH_14P4MW8P1MW_VALUE	\
	(AW87XXX_PID_18_REG_MPD_VTH_14P4MW8P1MW << AW87XXX_PID_18_REG_MPD_VTH_START_BIT)

#define AW87XXX_PID_18_REG_MPD_VTH_18P2MW11W	(3)
#define AW87XXX_PID_18_REG_MPD_VTH_18P2MW11W_VALUE	\
	(AW87XXX_PID_18_REG_MPD_VTH_18P2MW11W << AW87XXX_PID_18_REG_MPD_VTH_START_BIT)

#define AW87XXX_PID_18_REG_MPD_VTH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_MPD_VTH_DEFAULT	\
	(AW87XXX_PID_18_REG_MPD_VTH_DEFAULT_VALUE << AW87XXX_PID_18_REG_MPD_VTH_START_BIT)

/* default value of MADPVTH (0x06) */
/* #define AW87XXX_PID_18_MADPVTH_DEFAULT		(0x05) */

/* A3PARAM (0x07) detail */
/* REG_AGC3_RT bit 7:5 (A3PARAM 0x07) */
#define AW87XXX_PID_18_REG_AGC3_RT_START_BIT	(5)
#define AW87XXX_PID_18_REG_AGC3_RT_BITS_LEN	(3)
#define AW87XXX_PID_18_REG_AGC3_RT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC3_RT_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC3_RT_START_BIT))

#define AW87XXX_PID_18_REG_AGC3_RT_69P12MS	(0)
#define AW87XXX_PID_18_REG_AGC3_RT_69P12MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_RT_69P12MS << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_RT_138P24MS	(1)
#define AW87XXX_PID_18_REG_AGC3_RT_138P24MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_RT_138P24MS << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_RT_276P48MS	(2)
#define AW87XXX_PID_18_REG_AGC3_RT_276P48MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_RT_276P48MS << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_RT_552P96MS	(3)
#define AW87XXX_PID_18_REG_AGC3_RT_552P96MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_RT_552P96MS << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_RT_1107MS	(4)
#define AW87XXX_PID_18_REG_AGC3_RT_1107MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_RT_1107MS << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_RT_2160MS	(5)
#define AW87XXX_PID_18_REG_AGC3_RT_2160MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_RT_2160MS << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_RT_4320MS	(6)
#define AW87XXX_PID_18_REG_AGC3_RT_4320MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_RT_4320MS << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_RT_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_18_REG_AGC3_RT_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC3_RT_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC3_RT_START_BIT)

/* REG_AGC3_AT bit 4:2 (A3PARAM 0x07) */
#define AW87XXX_PID_18_REG_AGC3_AT_START_BIT	(2)
#define AW87XXX_PID_18_REG_AGC3_AT_BITS_LEN	(3)
#define AW87XXX_PID_18_REG_AGC3_AT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC3_AT_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC3_AT_START_BIT))

#define AW87XXX_PID_18_REG_AGC3_AT_5P76MS_0P32MSSTEP	(0)
#define AW87XXX_PID_18_REG_AGC3_AT_5P76MS_0P32MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_5P76MS_0P32MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_11P52MS_0P64MSSTEP	(1)
#define AW87XXX_PID_18_REG_AGC3_AT_11P52MS_0P64MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_11P52MS_0P64MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_23P04MS_1P28MSSTEP	(2)
#define AW87XXX_PID_18_REG_AGC3_AT_23P04MS_1P28MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_23P04MS_1P28MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_92P16MS_5P12MSSTEP	(3)
#define AW87XXX_PID_18_REG_AGC3_AT_92P16MS_5P12MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_92P16MS_5P12MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_368P64MS_20P48MSSTEP	(4)
#define AW87XXX_PID_18_REG_AGC3_AT_368P64MS_20P48MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_368P64MS_20P48MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_738MS_41MSSTEP	(5)
#define AW87XXX_PID_18_REG_AGC3_AT_738MS_41MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_738MS_41MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_1476MS_82MSSTEP	(6)
#define AW87XXX_PID_18_REG_AGC3_AT_1476MS_82MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_1476MS_82MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_2952MS_164MSSTEP	(7)
#define AW87XXX_PID_18_REG_AGC3_AT_2952MS_164MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_AT_2952MS_164MSSTEP << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_AT_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_18_REG_AGC3_AT_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC3_AT_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC3_AT_START_BIT)

/* REG_AGC3_1ST_AT bit 1:0 (A3PARAM 0x07) */
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_START_BIT	(0)
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC3_1ST_AT_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC3_1ST_AT_START_BIT))

#define AW87XXX_PID_18_REG_AGC3_1ST_AT_5P12MS	(0)
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_5P12MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_1ST_AT_5P12MS << AW87XXX_PID_18_REG_AGC3_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_1ST_AT_10P24MS	(1)
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_10P24MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_1ST_AT_10P24MS << AW87XXX_PID_18_REG_AGC3_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_1ST_AT_20P48MS	(2)
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_20P48MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_1ST_AT_20P48MS << AW87XXX_PID_18_REG_AGC3_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_1ST_AT_41MS	(3)
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_41MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_1ST_AT_41MS << AW87XXX_PID_18_REG_AGC3_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_1ST_AT_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_18_REG_AGC3_1ST_AT_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC3_1ST_AT_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC3_1ST_AT_START_BIT)

/* default value of A3PARAM (0x07) */
/* #define AW87XXX_PID_18_A3PARAM_DEFAULT		(0x52) */

/* A3A2PO (0x08) detail */
/* REG_AGC3_PO bit 7:4 (A3A2PO 0x08) */
#define AW87XXX_PID_18_REG_AGC3_PO_START_BIT	(4)
#define AW87XXX_PID_18_REG_AGC3_PO_BITS_LEN	(4)
#define AW87XXX_PID_18_REG_AGC3_PO_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC3_PO_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC3_PO_START_BIT))

#define AW87XXX_PID_18_REG_AGC3_PO_0P2W8_OHM_0P27W6_OHM_0P05W32_OHM	(0)
#define AW87XXX_PID_18_REG_AGC3_PO_0P2W8_OHM_0P27W6_OHM_0P05W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P2W8_OHM_0P27W6_OHM_0P05W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_0P3W8_OHM_0P4W6_OHM_0P075W32_OHM	(1)
#define AW87XXX_PID_18_REG_AGC3_PO_0P3W8_OHM_0P4W6_OHM_0P075W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P3W8_OHM_0P4W6_OHM_0P075W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_0P4W8_OHM_0P53W6_OHM_0P1W32_OHM	(2)
#define AW87XXX_PID_18_REG_AGC3_PO_0P4W8_OHM_0P53W6_OHM_0P1W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P4W8_OHM_0P53W6_OHM_0P1W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_0P5W8_OHM_0P67W6_OHM_0P125W32_OHM	(3)
#define AW87XXX_PID_18_REG_AGC3_PO_0P5W8_OHM_0P67W6_OHM_0P125W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P5W8_OHM_0P67W6_OHM_0P125W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_0P6W8_OHM_0P8W6_OHM_0P15W32_OHM	(4)
#define AW87XXX_PID_18_REG_AGC3_PO_0P6W8_OHM_0P8W6_OHM_0P15W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P6W8_OHM_0P8W6_OHM_0P15W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_0P7W8_OHM_0P93W6_OHM_0P175W32_OHM	(5)
#define AW87XXX_PID_18_REG_AGC3_PO_0P7W8_OHM_0P93W6_OHM_0P175W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P7W8_OHM_0P93W6_OHM_0P175W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_0P8W8_OHM_1P06W6_OHM_0P2W32_OHM	(6)
#define AW87XXX_PID_18_REG_AGC3_PO_0P8W8_OHM_1P06W6_OHM_0P2W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P8W8_OHM_1P06W6_OHM_0P2W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_0P9W8_OHM_1P2W6_OHM_0P225W32_OHM	(7)
#define AW87XXX_PID_18_REG_AGC3_PO_0P9W8_OHM_1P2W6_OHM_0P225W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_0P9W8_OHM_1P2W6_OHM_0P225W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_1P0W8_OHM_1P33W6_OHM_0P25W32_OHM	(8)
#define AW87XXX_PID_18_REG_AGC3_PO_1P0W8_OHM_1P33W6_OHM_0P25W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_1P0W8_OHM_1P33W6_OHM_0P25W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_1P1W8_OHM_1P46W6_OHM_0P275W32_OHM	(9)
#define AW87XXX_PID_18_REG_AGC3_PO_1P1W8_OHM_1P46W6_OHM_0P275W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_1P1W8_OHM_1P46W6_OHM_0P275W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_1P2W8_OHM_1P6W6_OHM_0P30W32_OHM	(10)
#define AW87XXX_PID_18_REG_AGC3_PO_1P2W8_OHM_1P6W6_OHM_0P30W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_1P2W8_OHM_1P6W6_OHM_0P30W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_1P3W8_OHM_1P73W6_OHM_0P325W32_OHM	(11)
#define AW87XXX_PID_18_REG_AGC3_PO_1P3W8_OHM_1P73W6_OHM_0P325W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_1P3W8_OHM_1P73W6_OHM_0P325W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_1P4W8_OHM_1P86W6_OHM_0P35W32_OHM	(12)
#define AW87XXX_PID_18_REG_AGC3_PO_1P4W8_OHM_1P86W6_OHM_0P35W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_1P4W8_OHM_1P86W6_OHM_0P35W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_1P5W8_OHM_2W6_OHM_0P375W32_OHM	(13)
#define AW87XXX_PID_18_REG_AGC3_PO_1P5W8_OHM_2W6_OHM_0P375W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_1P5W8_OHM_2W6_OHM_0P375W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_1P6W8_OHM_2P13W6_OHM_0P4W32_OHM	(14)
#define AW87XXX_PID_18_REG_AGC3_PO_1P6W8_OHM_2P13W6_OHM_0P4W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_1P6W8_OHM_2P13W6_OHM_0P4W32_OHM << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_AGC3_OFF	(15)
#define AW87XXX_PID_18_REG_AGC3_PO_AGC3_OFF_VALUE	\
	(AW87XXX_PID_18_REG_AGC3_PO_AGC3_OFF << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC3_PO_DEFAULT_VALUE	(0xA)
#define AW87XXX_PID_18_REG_AGC3_PO_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC3_PO_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC3_PO_START_BIT)

/* REG_AGC2_PO bit 3:0 (A3A2PO 0x08) */
#define AW87XXX_PID_18_REG_AGC2_PO_START_BIT	(0)
#define AW87XXX_PID_18_REG_AGC2_PO_BITS_LEN	(4)
#define AW87XXX_PID_18_REG_AGC2_PO_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC2_PO_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC2_PO_START_BIT))

#define AW87XXX_PID_18_REG_AGC2_PO_0P4W8_OHM_0P53W6_OHM_0P1W32_OHM	(0)
#define AW87XXX_PID_18_REG_AGC2_PO_0P4W8_OHM_0P53W6_OHM_0P1W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_0P4W8_OHM_0P53W6_OHM_0P1W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_0P6W8_OHM_0P8W6_OHM_0P15W32_OHM	(1)
#define AW87XXX_PID_18_REG_AGC2_PO_0P6W8_OHM_0P8W6_OHM_0P15W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_0P6W8_OHM_0P8W6_OHM_0P15W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_0P8W8_OHM_1P06W6_OHM_0P2W32_OHM	(2)
#define AW87XXX_PID_18_REG_AGC2_PO_0P8W8_OHM_1P06W6_OHM_0P2W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_0P8W8_OHM_1P06W6_OHM_0P2W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_1P0W8_OHM_1P33W6_OHM_0P25W32_OHM	(3)
#define AW87XXX_PID_18_REG_AGC2_PO_1P0W8_OHM_1P33W6_OHM_0P25W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_1P0W8_OHM_1P33W6_OHM_0P25W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_1P2W8_OHM_1P6W6_OHM_0P3W32_OHM	(4)
#define AW87XXX_PID_18_REG_AGC2_PO_1P2W8_OHM_1P6W6_OHM_0P3W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_1P2W8_OHM_1P6W6_OHM_0P3W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_1P4W8_OHM_1P86W6_OHM_0P35W32_OHM	(5)
#define AW87XXX_PID_18_REG_AGC2_PO_1P4W8_OHM_1P86W6_OHM_0P35W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_1P4W8_OHM_1P86W6_OHM_0P35W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_1P6W8_OHM_2P13W6_OHM_0P4W32_OHM	(6)
#define AW87XXX_PID_18_REG_AGC2_PO_1P6W8_OHM_2P13W6_OHM_0P4W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_1P6W8_OHM_2P13W6_OHM_0P4W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_1P8W8_OHM_2P4W6_OHM_0P45W32_OHM	(7)
#define AW87XXX_PID_18_REG_AGC2_PO_1P8W8_OHM_2P4W6_OHM_0P45W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_1P8W8_OHM_2P4W6_OHM_0P45W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_2P0W8_OHM_2P66W6_OHM_0P5W32_OHM	(8)
#define AW87XXX_PID_18_REG_AGC2_PO_2P0W8_OHM_2P66W6_OHM_0P5W32_OHM_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_2P0W8_OHM_2P66W6_OHM_0P5W32_OHM << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_AGC2_OFF	(9)
#define AW87XXX_PID_18_REG_AGC2_PO_AGC2_OFF_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_PO_AGC2_OFF << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_PO_DEFAULT_VALUE	(0x6)
#define AW87XXX_PID_18_REG_AGC2_PO_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC2_PO_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC2_PO_START_BIT)

/* default value of A3A2PO (0x08) */
/* #define AW87XXX_PID_18_A3A2PO_DEFAULT		(0xA6) */

/* A2PARAM (0x09) detail */
/* REG_TEDGE bit 5 (A2PARAM 0x09) */
#define AW87XXX_PID_18_REG_TEDGE_START_BIT	(5)
#define AW87XXX_PID_18_REG_TEDGE_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_TEDGE_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_TEDGE_BITS_LEN)-1) << AW87XXX_PID_18_REG_TEDGE_START_BIT))

#define AW87XXX_PID_18_REG_TEDGE_4NS	(0)
#define AW87XXX_PID_18_REG_TEDGE_4NS_VALUE	\
	(AW87XXX_PID_18_REG_TEDGE_4NS << AW87XXX_PID_18_REG_TEDGE_START_BIT)

#define AW87XXX_PID_18_REG_TEDGE_12NS	(1)
#define AW87XXX_PID_18_REG_TEDGE_12NS_VALUE	\
	(AW87XXX_PID_18_REG_TEDGE_12NS << AW87XXX_PID_18_REG_TEDGE_START_BIT)

#define AW87XXX_PID_18_REG_TEDGE_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_TEDGE_DEFAULT	\
	(AW87XXX_PID_18_REG_TEDGE_DEFAULT_VALUE << AW87XXX_PID_18_REG_TEDGE_START_BIT)

/* REG_AGC2_AT bit 4:2 (A2PARAM 0x09) */
#define AW87XXX_PID_18_REG_AGC2_AT_START_BIT	(2)
#define AW87XXX_PID_18_REG_AGC2_AT_BITS_LEN	(3)
#define AW87XXX_PID_18_REG_AGC2_AT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC2_AT_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC2_AT_START_BIT))

#define AW87XXX_PID_18_REG_AGC2_AT_1P44MS_0P08MSSTEP	(0)
#define AW87XXX_PID_18_REG_AGC2_AT_1P44MS_0P08MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_1P44MS_0P08MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_2P88MS_0P16MSSTEP	(1)
#define AW87XXX_PID_18_REG_AGC2_AT_2P88MS_0P16MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_2P88MS_0P16MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_5P76MS_0P32MSSTEP	(2)
#define AW87XXX_PID_18_REG_AGC2_AT_5P76MS_0P32MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_5P76MS_0P32MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_23P04MS_1P28MSSTEP	(3)
#define AW87XXX_PID_18_REG_AGC2_AT_23P04MS_1P28MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_23P04MS_1P28MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_92P16MS_5P12MSSTEP	(4)
#define AW87XXX_PID_18_REG_AGC2_AT_92P16MS_5P12MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_92P16MS_5P12MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_368P64MS_20P48MSSTEP	(5)
#define AW87XXX_PID_18_REG_AGC2_AT_368P64MS_20P48MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_368P64MS_20P48MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_737P28MS_41MSSTEP	(6)
#define AW87XXX_PID_18_REG_AGC2_AT_737P28MS_41MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_737P28MS_41MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_1474P56MS_82MSSTEP	(7)
#define AW87XXX_PID_18_REG_AGC2_AT_1474P56MS_82MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_AT_1474P56MS_82MSSTEP << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_AT_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_18_REG_AGC2_AT_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC2_AT_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC2_AT_START_BIT)

/* REG_AGC2_1ST_AT bit 1:0 (A2PARAM 0x09) */
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_START_BIT	(0)
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC2_1ST_AT_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC2_1ST_AT_START_BIT))

#define AW87XXX_PID_18_REG_AGC2_1ST_AT_0P08MS	(0)
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_0P08MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_1ST_AT_0P08MS << AW87XXX_PID_18_REG_AGC2_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_1ST_AT_0P32MS	(1)
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_0P32MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_1ST_AT_0P32MS << AW87XXX_PID_18_REG_AGC2_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_1ST_AT_1P28MS	(2)
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_1P28MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_1ST_AT_1P28MS << AW87XXX_PID_18_REG_AGC2_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_1ST_AT_5P12MS	(3)
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_5P12MS_VALUE	\
	(AW87XXX_PID_18_REG_AGC2_1ST_AT_5P12MS << AW87XXX_PID_18_REG_AGC2_1ST_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC2_1ST_AT_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_AGC2_1ST_AT_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC2_1ST_AT_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC2_1ST_AT_START_BIT)

/* default value of A2PARAM (0x09) */
/* #define AW87XXX_PID_18_A2PARAM_DEFAULT		(0x08) */

/* A1PARAM (0x0A) detail */
/* REG_AGC1_PO bit 6:3 (A1PARAM 0x0A) */
#define AW87XXX_PID_18_REG_AGC1_PO_START_BIT	(3)
#define AW87XXX_PID_18_REG_AGC1_PO_BITS_LEN	(4)
#define AW87XXX_PID_18_REG_AGC1_PO_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC1_PO_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC1_PO_START_BIT))

#define AW87XXX_PID_18_REG_AGC1_PO_5V	(0)
#define AW87XXX_PID_18_REG_AGC1_PO_5V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_5V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_5P2V	(1)
#define AW87XXX_PID_18_REG_AGC1_PO_5P2V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_5P2V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_5P4V	(2)
#define AW87XXX_PID_18_REG_AGC1_PO_5P4V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_5P4V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_5P6V	(3)
#define AW87XXX_PID_18_REG_AGC1_PO_5P6V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_5P6V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_5P8V	(4)
#define AW87XXX_PID_18_REG_AGC1_PO_5P8V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_5P8V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_6P0V	(5)
#define AW87XXX_PID_18_REG_AGC1_PO_6P0V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_6P0V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_6P2V	(6)
#define AW87XXX_PID_18_REG_AGC1_PO_6P2V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_6P2V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_6P4V	(7)
#define AW87XXX_PID_18_REG_AGC1_PO_6P4V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_6P4V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_6P6V	(8)
#define AW87XXX_PID_18_REG_AGC1_PO_6P6V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_6P6V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_6P8V	(9)
#define AW87XXX_PID_18_REG_AGC1_PO_6P8V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_6P8V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_7V	(10)
#define AW87XXX_PID_18_REG_AGC1_PO_7V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_7V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_7P2V	(11)
#define AW87XXX_PID_18_REG_AGC1_PO_7P2V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_7P2V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_7P4V	(12)
#define AW87XXX_PID_18_REG_AGC1_PO_7P4V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_7P4V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_7P6V	(13)
#define AW87XXX_PID_18_REG_AGC1_PO_7P6V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_7P6V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_7P8V	(14)
#define AW87XXX_PID_18_REG_AGC1_PO_7P8V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_7P8V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_8V	(15)
#define AW87XXX_PID_18_REG_AGC1_PO_8V_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_PO_8V << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_PO_DEFAULT_VALUE	(0x9)
#define AW87XXX_PID_18_REG_AGC1_PO_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC1_PO_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC1_PO_START_BIT)

/* REG_AGC1_AT bit 2:1 (A1PARAM 0x0A) */
#define AW87XXX_PID_18_REG_AGC1_AT_START_BIT	(1)
#define AW87XXX_PID_18_REG_AGC1_AT_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_AGC1_AT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC1_AT_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC1_AT_START_BIT))

#define AW87XXX_PID_18_REG_AGC1_AT_0P48MS_0P02MSSTEP	(0)
#define AW87XXX_PID_18_REG_AGC1_AT_0P48MS_0P02MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_AT_0P48MS_0P02MSSTEP << AW87XXX_PID_18_REG_AGC1_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_AT_0P96MS_0P04MSSTEP	(1)
#define AW87XXX_PID_18_REG_AGC1_AT_0P96MS_0P04MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_AT_0P96MS_0P04MSSTEP << AW87XXX_PID_18_REG_AGC1_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_AT_1P92MS_0P08MSSTEP	(2)
#define AW87XXX_PID_18_REG_AGC1_AT_1P92MS_0P08MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_AT_1P92MS_0P08MSSTEP << AW87XXX_PID_18_REG_AGC1_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_AT_3P84MS_0P16MSSTEP	(3)
#define AW87XXX_PID_18_REG_AGC1_AT_3P84MS_0P16MSSTEP_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_AT_3P84MS_0P16MSSTEP << AW87XXX_PID_18_REG_AGC1_AT_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_AT_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_AGC1_AT_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC1_AT_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC1_AT_START_BIT)

/* REG_PD_AGC1 bit 0 (A1PARAM 0x0A) */
#define AW87XXX_PID_18_REG_PD_AGC1_START_BIT	(0)
#define AW87XXX_PID_18_REG_PD_AGC1_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_PD_AGC1_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_PD_AGC1_BITS_LEN)-1) << AW87XXX_PID_18_REG_PD_AGC1_START_BIT))

#define AW87XXX_PID_18_REG_PD_AGC1_ENABLE_FASTEST_LEVEL_AGC	(0)
#define AW87XXX_PID_18_REG_PD_AGC1_ENABLE_FASTEST_LEVEL_AGC_VALUE	\
	(AW87XXX_PID_18_REG_PD_AGC1_ENABLE_FASTEST_LEVEL_AGC << AW87XXX_PID_18_REG_PD_AGC1_START_BIT)

#define AW87XXX_PID_18_REG_PD_AGC1_DISABLE_FASTEST_LEVEL_AGC	(1)
#define AW87XXX_PID_18_REG_PD_AGC1_DISABLE_FASTEST_LEVEL_AGC_VALUE	\
	(AW87XXX_PID_18_REG_PD_AGC1_DISABLE_FASTEST_LEVEL_AGC << AW87XXX_PID_18_REG_PD_AGC1_START_BIT)

#define AW87XXX_PID_18_REG_PD_AGC1_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_PD_AGC1_DEFAULT	\
	(AW87XXX_PID_18_REG_PD_AGC1_DEFAULT_VALUE << AW87XXX_PID_18_REG_PD_AGC1_START_BIT)

/* default value of A1PARAM (0x0A) */
/* #define AW87XXX_PID_18_A1PARAM_DEFAULT		(0x4A) */

/* POPCLK (0x0B) detail */
/* REG_DCLK_L bit 7 (POPCLK 0x0B) */
#define AW87XXX_PID_18_REG_DCLK_L_START_BIT	(7)
#define AW87XXX_PID_18_REG_DCLK_L_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_DCLK_L_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_DCLK_L_BITS_LEN)-1) << AW87XXX_PID_18_REG_DCLK_L_START_BIT))

#define AW87XXX_PID_18_REG_DCLK_L_30NS	(0)
#define AW87XXX_PID_18_REG_DCLK_L_30NS_VALUE	\
	(AW87XXX_PID_18_REG_DCLK_L_30NS << AW87XXX_PID_18_REG_DCLK_L_START_BIT)

#define AW87XXX_PID_18_REG_DCLK_L_45NS	(1)
#define AW87XXX_PID_18_REG_DCLK_L_45NS_VALUE	\
	(AW87XXX_PID_18_REG_DCLK_L_45NS << AW87XXX_PID_18_REG_DCLK_L_START_BIT)

#define AW87XXX_PID_18_REG_DCLK_L_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_DCLK_L_DEFAULT	\
	(AW87XXX_PID_18_REG_DCLK_L_DEFAULT_VALUE << AW87XXX_PID_18_REG_DCLK_L_START_BIT)

/* REG_CLK_MAPD bit 6:5 (POPCLK 0x0B) */
#define AW87XXX_PID_18_REG_CLK_MAPD_START_BIT	(5)
#define AW87XXX_PID_18_REG_CLK_MAPD_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_CLK_MAPD_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CLK_MAPD_BITS_LEN)-1) << AW87XXX_PID_18_REG_CLK_MAPD_START_BIT))

#define AW87XXX_PID_18_REG_CLK_MAPD_40MS	(0)
#define AW87XXX_PID_18_REG_CLK_MAPD_40MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_MAPD_40MS << AW87XXX_PID_18_REG_CLK_MAPD_START_BIT)

#define AW87XXX_PID_18_REG_CLK_MAPD_80MS	(1)
#define AW87XXX_PID_18_REG_CLK_MAPD_80MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_MAPD_80MS << AW87XXX_PID_18_REG_CLK_MAPD_START_BIT)

#define AW87XXX_PID_18_REG_CLK_MAPD_160MS	(2)
#define AW87XXX_PID_18_REG_CLK_MAPD_160MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_MAPD_160MS << AW87XXX_PID_18_REG_CLK_MAPD_START_BIT)

#define AW87XXX_PID_18_REG_CLK_MAPD_320MS	(3)
#define AW87XXX_PID_18_REG_CLK_MAPD_320MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_MAPD_320MS << AW87XXX_PID_18_REG_CLK_MAPD_START_BIT)

#define AW87XXX_PID_18_REG_CLK_MAPD_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_CLK_MAPD_DEFAULT	\
	(AW87XXX_PID_18_REG_CLK_MAPD_DEFAULT_VALUE << AW87XXX_PID_18_REG_CLK_MAPD_START_BIT)

/* REG_CLK_POP bit 4:3 (POPCLK 0x0B) */
#define AW87XXX_PID_18_REG_CLK_POP_START_BIT	(3)
#define AW87XXX_PID_18_REG_CLK_POP_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_CLK_POP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CLK_POP_BITS_LEN)-1) << AW87XXX_PID_18_REG_CLK_POP_START_BIT))

#define AW87XXX_PID_18_REG_CLK_POP_40MS	(0)
#define AW87XXX_PID_18_REG_CLK_POP_40MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_POP_40MS << AW87XXX_PID_18_REG_CLK_POP_START_BIT)

#define AW87XXX_PID_18_REG_CLK_POP_10MS	(1)
#define AW87XXX_PID_18_REG_CLK_POP_10MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_POP_10MS << AW87XXX_PID_18_REG_CLK_POP_START_BIT)

#define AW87XXX_PID_18_REG_CLK_POP_5MS	(2)
#define AW87XXX_PID_18_REG_CLK_POP_5MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_POP_5MS << AW87XXX_PID_18_REG_CLK_POP_START_BIT)

#define AW87XXX_PID_18_REG_CLK_POP_2P5MS	(3)
#define AW87XXX_PID_18_REG_CLK_POP_2P5MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_POP_2P5MS << AW87XXX_PID_18_REG_CLK_POP_START_BIT)

#define AW87XXX_PID_18_REG_CLK_POP_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_CLK_POP_DEFAULT	\
	(AW87XXX_PID_18_REG_CLK_POP_DEFAULT_VALUE << AW87XXX_PID_18_REG_CLK_POP_START_BIT)

/* REG_CLK_OC bit 2:1 (POPCLK 0x0B) */
#define AW87XXX_PID_18_REG_CLK_OC_START_BIT	(1)
#define AW87XXX_PID_18_REG_CLK_OC_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_CLK_OC_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CLK_OC_BITS_LEN)-1) << AW87XXX_PID_18_REG_CLK_OC_START_BIT))

#define AW87XXX_PID_18_REG_CLK_OC_160MS	(0)
#define AW87XXX_PID_18_REG_CLK_OC_160MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_OC_160MS << AW87XXX_PID_18_REG_CLK_OC_START_BIT)

#define AW87XXX_PID_18_REG_CLK_OC_640MS	(1)
#define AW87XXX_PID_18_REG_CLK_OC_640MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_OC_640MS << AW87XXX_PID_18_REG_CLK_OC_START_BIT)

#define AW87XXX_PID_18_REG_CLK_OC_1280MS	(2)
#define AW87XXX_PID_18_REG_CLK_OC_1280MS_VALUE	\
	(AW87XXX_PID_18_REG_CLK_OC_1280MS << AW87XXX_PID_18_REG_CLK_OC_START_BIT)

#define AW87XXX_PID_18_REG_CLK_OC_SHUTDOWN_OUTPUT	(3)
#define AW87XXX_PID_18_REG_CLK_OC_SHUTDOWN_OUTPUT_VALUE	\
	(AW87XXX_PID_18_REG_CLK_OC_SHUTDOWN_OUTPUT << AW87XXX_PID_18_REG_CLK_OC_START_BIT)

#define AW87XXX_PID_18_REG_CLK_OC_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_CLK_OC_DEFAULT	\
	(AW87XXX_PID_18_REG_CLK_OC_DEFAULT_VALUE << AW87XXX_PID_18_REG_CLK_OC_START_BIT)

/* REG_AGC1_VTH bit 0 (POPCLK 0x0B) */
#define AW87XXX_PID_18_REG_AGC1_VTH_START_BIT	(0)
#define AW87XXX_PID_18_REG_AGC1_VTH_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_AGC1_VTH_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_AGC1_VTH_BITS_LEN)-1) << AW87XXX_PID_18_REG_AGC1_VTH_START_BIT))

#define AW87XXX_PID_18_REG_AGC1_VTH_AGC1_VTH_SELECT_ONLY_FROM_RAMP_GEN	(0)
#define AW87XXX_PID_18_REG_AGC1_VTH_AGC1_VTH_SELECT_ONLY_FROM_RAMP_GEN_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_VTH_AGC1_VTH_SELECT_ONLY_FROM_RAMP_GEN << AW87XXX_PID_18_REG_AGC1_VTH_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_VTH_AGC1_VTH_ADAPTIVELY_SELECT_FROM_RAMP_GEN_AND_THGEN	(1)
#define AW87XXX_PID_18_REG_AGC1_VTH_AGC1_VTH_ADAPTIVELY_SELECT_FROM_RAMP_GEN_AND_THGEN_VALUE	\
	(AW87XXX_PID_18_REG_AGC1_VTH_AGC1_VTH_ADAPTIVELY_SELECT_FROM_RAMP_GEN_AND_THGEN << AW87XXX_PID_18_REG_AGC1_VTH_START_BIT)

#define AW87XXX_PID_18_REG_AGC1_VTH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_AGC1_VTH_DEFAULT	\
	(AW87XXX_PID_18_REG_AGC1_VTH_DEFAULT_VALUE << AW87XXX_PID_18_REG_AGC1_VTH_START_BIT)

/* default value of POPCLK (0x0B) */
/* #define AW87XXX_PID_18_POPCLK_DEFAULT		(0x21) */

/* GTDRCPSS (0x0C) detail */
/* REG_TDEAD bit 5 (GTDRCPSS 0x0C) */
#define AW87XXX_PID_18_REG_TDEAD_START_BIT	(5)
#define AW87XXX_PID_18_REG_TDEAD_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_TDEAD_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_TDEAD_BITS_LEN)-1) << AW87XXX_PID_18_REG_TDEAD_START_BIT))

#define AW87XXX_PID_18_REG_TDEAD_17NS	(0)
#define AW87XXX_PID_18_REG_TDEAD_17NS_VALUE	\
	(AW87XXX_PID_18_REG_TDEAD_17NS << AW87XXX_PID_18_REG_TDEAD_START_BIT)

#define AW87XXX_PID_18_REG_TDEAD_25NS	(1)
#define AW87XXX_PID_18_REG_TDEAD_25NS_VALUE	\
	(AW87XXX_PID_18_REG_TDEAD_25NS << AW87XXX_PID_18_REG_TDEAD_START_BIT)

#define AW87XXX_PID_18_REG_TDEAD_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_TDEAD_DEFAULT	\
	(AW87XXX_PID_18_REG_TDEAD_DEFAULT_VALUE << AW87XXX_PID_18_REG_TDEAD_START_BIT)

/* REG_CZ_35MV bit 4 (GTDRCPSS 0x0C) */
#define AW87XXX_PID_18_REG_CZ_35MV_START_BIT	(4)
#define AW87XXX_PID_18_REG_CZ_35MV_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_CZ_35MV_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CZ_35MV_BITS_LEN)-1) << AW87XXX_PID_18_REG_CZ_35MV_START_BIT))

#define AW87XXX_PID_18_REG_CZ_35MV_25MV	(0)
#define AW87XXX_PID_18_REG_CZ_35MV_25MV_VALUE	\
	(AW87XXX_PID_18_REG_CZ_35MV_25MV << AW87XXX_PID_18_REG_CZ_35MV_START_BIT)

#define AW87XXX_PID_18_REG_CZ_35MV_35MV	(1)
#define AW87XXX_PID_18_REG_CZ_35MV_35MV_VALUE	\
	(AW87XXX_PID_18_REG_CZ_35MV_35MV << AW87XXX_PID_18_REG_CZ_35MV_START_BIT)

#define AW87XXX_PID_18_REG_CZ_35MV_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_CZ_35MV_DEFAULT	\
	(AW87XXX_PID_18_REG_CZ_35MV_DEFAULT_VALUE << AW87XXX_PID_18_REG_CZ_35MV_START_BIT)

/* BIT_CTRL bit 3 (GTDRCPSS 0x0C) */
#define AW87XXX_PID_18_BIT_CTRL_START_BIT	(3)
#define AW87XXX_PID_18_BIT_CTRL_BITS_LEN	(1)
#define AW87XXX_PID_18_BIT_CTRL_MASK	\
	(~(((1<<AW87XXX_PID_18_BIT_CTRL_BITS_LEN)-1) << AW87XXX_PID_18_BIT_CTRL_START_BIT))

#define AW87XXX_PID_18_BIT_CTRL_32_STEP_SPREAD_SPECTRUM	(0)
#define AW87XXX_PID_18_BIT_CTRL_32_STEP_SPREAD_SPECTRUM_VALUE	\
	(AW87XXX_PID_18_BIT_CTRL_32_STEP_SPREAD_SPECTRUM << AW87XXX_PID_18_BIT_CTRL_START_BIT)

#define AW87XXX_PID_18_BIT_CTRL_14_STEP_SPREAD_SPECTRUM	(1)
#define AW87XXX_PID_18_BIT_CTRL_14_STEP_SPREAD_SPECTRUM_VALUE	\
	(AW87XXX_PID_18_BIT_CTRL_14_STEP_SPREAD_SPECTRUM << AW87XXX_PID_18_BIT_CTRL_START_BIT)

#define AW87XXX_PID_18_BIT_CTRL_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_BIT_CTRL_DEFAULT	\
	(AW87XXX_PID_18_BIT_CTRL_DEFAULT_VALUE << AW87XXX_PID_18_BIT_CTRL_START_BIT)

/* SS_EXCH bit 2 (GTDRCPSS 0x0C) */
#define AW87XXX_PID_18_SS_EXCH_START_BIT	(2)
#define AW87XXX_PID_18_SS_EXCH_BITS_LEN	(1)
#define AW87XXX_PID_18_SS_EXCH_MASK		\
	(~(((1<<AW87XXX_PID_18_SS_EXCH_BITS_LEN)-1) << AW87XXX_PID_18_SS_EXCH_START_BIT))

#define AW87XXX_PID_18_SS_EXCH_12_RANGE	(0)
#define AW87XXX_PID_18_SS_EXCH_12_RANGE_VALUE	\
	(AW87XXX_PID_18_SS_EXCH_12_RANGE << AW87XXX_PID_18_SS_EXCH_START_BIT)

#define AW87XXX_PID_18_SS_EXCH_6_RANGE	(1)
#define AW87XXX_PID_18_SS_EXCH_6_RANGE_VALUE	\
	(AW87XXX_PID_18_SS_EXCH_6_RANGE << AW87XXX_PID_18_SS_EXCH_START_BIT)

#define AW87XXX_PID_18_SS_EXCH_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_SS_EXCH_DEFAULT	\
	(AW87XXX_PID_18_SS_EXCH_DEFAULT_VALUE << AW87XXX_PID_18_SS_EXCH_START_BIT)

/* REG_ISTART bit 1 (GTDRCPSS 0x0C) */
#define AW87XXX_PID_18_REG_ISTART_START_BIT	(1)
#define AW87XXX_PID_18_REG_ISTART_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_ISTART_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_ISTART_BITS_LEN)-1) << AW87XXX_PID_18_REG_ISTART_START_BIT))

#define AW87XXX_PID_18_REG_ISTART_IBIAS_WI_46P8NA	(0)
#define AW87XXX_PID_18_REG_ISTART_IBIAS_WI_46P8NA_VALUE	\
	(AW87XXX_PID_18_REG_ISTART_IBIAS_WI_46P8NA << AW87XXX_PID_18_REG_ISTART_START_BIT)

#define AW87XXX_PID_18_REG_ISTART_IBIAS_WI_62P5NA	(1)
#define AW87XXX_PID_18_REG_ISTART_IBIAS_WI_62P5NA_VALUE	\
	(AW87XXX_PID_18_REG_ISTART_IBIAS_WI_62P5NA << AW87XXX_PID_18_REG_ISTART_START_BIT)

#define AW87XXX_PID_18_REG_ISTART_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_ISTART_DEFAULT	\
	(AW87XXX_PID_18_REG_ISTART_DEFAULT_VALUE << AW87XXX_PID_18_REG_ISTART_START_BIT)

/* REG_PD_OVPICTRL bit 0 (GTDRCPSS 0x0C) */
#define AW87XXX_PID_18_REG_PD_OVPICTRL_START_BIT	(0)
#define AW87XXX_PID_18_REG_PD_OVPICTRL_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_PD_OVPICTRL_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_PD_OVPICTRL_BITS_LEN)-1) << AW87XXX_PID_18_REG_PD_OVPICTRL_START_BIT))

#define AW87XXX_PID_18_REG_PD_OVPICTRL_DISABLE	(0)
#define AW87XXX_PID_18_REG_PD_OVPICTRL_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_OVPICTRL_DISABLE << AW87XXX_PID_18_REG_PD_OVPICTRL_START_BIT)

#define AW87XXX_PID_18_REG_PD_OVPICTRL_ENABLE	(1)
#define AW87XXX_PID_18_REG_PD_OVPICTRL_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_OVPICTRL_ENABLE << AW87XXX_PID_18_REG_PD_OVPICTRL_START_BIT)

#define AW87XXX_PID_18_REG_PD_OVPICTRL_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_PD_OVPICTRL_DEFAULT	\
	(AW87XXX_PID_18_REG_PD_OVPICTRL_DEFAULT_VALUE << AW87XXX_PID_18_REG_PD_OVPICTRL_START_BIT)

/* default value of GTDRCPSS (0x0C) */
/* #define AW87XXX_PID_18_GTDRCPSS_DEFAULT		(0x08) */

/* MULTI (0x0D) detail */
/* REG_CP_FREQ bit 7:6 (MULTI 0x0D) */
#define AW87XXX_PID_18_REG_CP_FREQ_START_BIT	(6)
#define AW87XXX_PID_18_REG_CP_FREQ_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_CP_FREQ_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CP_FREQ_BITS_LEN)-1) << AW87XXX_PID_18_REG_CP_FREQ_START_BIT))

#define AW87XXX_PID_18_REG_CP_FREQ_1P8MHZ	(0)
#define AW87XXX_PID_18_REG_CP_FREQ_1P8MHZ_VALUE	\
	(AW87XXX_PID_18_REG_CP_FREQ_1P8MHZ << AW87XXX_PID_18_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_18_REG_CP_FREQ_1P6MHZ	(1)
#define AW87XXX_PID_18_REG_CP_FREQ_1P6MHZ_VALUE	\
	(AW87XXX_PID_18_REG_CP_FREQ_1P6MHZ << AW87XXX_PID_18_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_18_REG_CP_FREQ_1P4MHZ	(2)
#define AW87XXX_PID_18_REG_CP_FREQ_1P4MHZ_VALUE	\
	(AW87XXX_PID_18_REG_CP_FREQ_1P4MHZ << AW87XXX_PID_18_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_18_REG_CP_FREQ_2P1MHZ	(3)
#define AW87XXX_PID_18_REG_CP_FREQ_2P1MHZ_VALUE	\
	(AW87XXX_PID_18_REG_CP_FREQ_2P1MHZ << AW87XXX_PID_18_REG_CP_FREQ_START_BIT)

#define AW87XXX_PID_18_REG_CP_FREQ_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_CP_FREQ_DEFAULT	\
	(AW87XXX_PID_18_REG_CP_FREQ_DEFAULT_VALUE << AW87XXX_PID_18_REG_CP_FREQ_START_BIT)

/* REG_EN_OT150 bit 5 (MULTI 0x0D) */
#define AW87XXX_PID_18_REG_EN_OT150_START_BIT	(5)
#define AW87XXX_PID_18_REG_EN_OT150_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_OT150_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_OT150_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_OT150_START_BIT))

#define AW87XXX_PID_18_REG_EN_OT150_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_OT150_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_OT150_DISABLE << AW87XXX_PID_18_REG_EN_OT150_START_BIT)

#define AW87XXX_PID_18_REG_EN_OT150_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_OT150_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_OT150_ENABLE << AW87XXX_PID_18_REG_EN_OT150_START_BIT)

#define AW87XXX_PID_18_REG_EN_OT150_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_EN_OT150_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_OT150_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_OT150_START_BIT)

/* REG_EN_TEST bit 4 (MULTI 0x0D) */
#define AW87XXX_PID_18_REG_EN_TEST_START_BIT	(4)
#define AW87XXX_PID_18_REG_EN_TEST_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_TEST_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_TEST_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_TEST_START_BIT))

#define AW87XXX_PID_18_REG_EN_TEST_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_TEST_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_TEST_DISABLE << AW87XXX_PID_18_REG_EN_TEST_START_BIT)

#define AW87XXX_PID_18_REG_EN_TEST_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_TEST_ENABLE << AW87XXX_PID_18_REG_EN_TEST_START_BIT)

#define AW87XXX_PID_18_REG_EN_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EN_TEST_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_TEST_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_TEST_START_BIT)

/* REG_EN_CLASSD bit 3 (MULTI 0x0D) */
#define AW87XXX_PID_18_REG_EN_CLASSD_START_BIT	(3)
#define AW87XXX_PID_18_REG_EN_CLASSD_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_CLASSD_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_CLASSD_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_CLASSD_START_BIT))

#define AW87XXX_PID_18_REG_EN_CLASSD_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_CLASSD_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_CLASSD_DISABLE << AW87XXX_PID_18_REG_EN_CLASSD_START_BIT)

#define AW87XXX_PID_18_REG_EN_CLASSD_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_CLASSD_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_CLASSD_ENABLE << AW87XXX_PID_18_REG_EN_CLASSD_START_BIT)

#define AW87XXX_PID_18_REG_EN_CLASSD_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_EN_CLASSD_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_CLASSD_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_CLASSD_START_BIT)

/* REG_EN_DEFAULT bit 2 (MULTI 0x0D) */
#define AW87XXX_PID_18_REG_EN_DEFAULT_START_BIT	(2)
#define AW87XXX_PID_18_REG_EN_DEFAULT_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_DEFAULT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_DEFAULT_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_DEFAULT_START_BIT))

#define AW87XXX_PID_18_REG_EN_DEFAULT_SELF_DEFINE_THE_SETTINGS	(0)
#define AW87XXX_PID_18_REG_EN_DEFAULT_SELF_DEFINE_THE_SETTINGS_VALUE	\
	(AW87XXX_PID_18_REG_EN_DEFAULT_SELF_DEFINE_THE_SETTINGS << AW87XXX_PID_18_REG_EN_DEFAULT_START_BIT)

#define AW87XXX_PID_18_REG_EN_DEFAULT_USE_THE_DEFAULT_SETTING_IN_THE_SYSCTRL_BLOCK	(1)
#define AW87XXX_PID_18_REG_EN_DEFAULT_USE_THE_DEFAULT_SETTING_IN_THE_SYSCTRL_BLOCK_VALUE	\
	(AW87XXX_PID_18_REG_EN_DEFAULT_USE_THE_DEFAULT_SETTING_IN_THE_SYSCTRL_BLOCK << AW87XXX_PID_18_REG_EN_DEFAULT_START_BIT)

#define AW87XXX_PID_18_REG_EN_DEFAULT_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EN_DEFAULT_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_DEFAULT_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_DEFAULT_START_BIT)

/* REG_EN_ESD bit 1 (MULTI 0x0D) */
#define AW87XXX_PID_18_REG_EN_ESD_START_BIT	(1)
#define AW87XXX_PID_18_REG_EN_ESD_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_ESD_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_ESD_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_ESD_START_BIT))

#define AW87XXX_PID_18_REG_EN_ESD_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_ESD_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_ESD_DISABLE << AW87XXX_PID_18_REG_EN_ESD_START_BIT)

#define AW87XXX_PID_18_REG_EN_ESD_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_ESD_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_ESD_ENABLE << AW87XXX_PID_18_REG_EN_ESD_START_BIT)

#define AW87XXX_PID_18_REG_EN_ESD_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EN_ESD_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_ESD_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_ESD_START_BIT)

/* REG_EN_MT bit 0 (MULTI 0x0D) */
#define AW87XXX_PID_18_REG_EN_MT_START_BIT	(0)
#define AW87XXX_PID_18_REG_EN_MT_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_MT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_MT_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_MT_START_BIT))

#define AW87XXX_PID_18_REG_EN_MT_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_MT_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_MT_DISABLE << AW87XXX_PID_18_REG_EN_MT_START_BIT)

#define AW87XXX_PID_18_REG_EN_MT_ENBLAE	(1)
#define AW87XXX_PID_18_REG_EN_MT_ENBLAE_VALUE	\
	(AW87XXX_PID_18_REG_EN_MT_ENBLAE << AW87XXX_PID_18_REG_EN_MT_START_BIT)

#define AW87XXX_PID_18_REG_EN_MT_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EN_MT_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_MT_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_MT_START_BIT)

/* default value of MULTI (0x0D) */
/* #define AW87XXX_PID_18_MULTI_DEFAULT		(0x68) */

/* DFT1 (0x61) detail */
/* REG_SET_R2 bit 7 (DFT1 0x61) */
#define AW87XXX_PID_18_REG_SET_R2_START_BIT	(7)
#define AW87XXX_PID_18_REG_SET_R2_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_SET_R2_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_SET_R2_BITS_LEN)-1) << AW87XXX_PID_18_REG_SET_R2_START_BIT))

#define AW87XXX_PID_18_REG_SET_R2_NOT_LIMIT_THE_HIGH_LEVEL_VTH	(0)
#define AW87XXX_PID_18_REG_SET_R2_NOT_LIMIT_THE_HIGH_LEVEL_VTH_VALUE	\
	(AW87XXX_PID_18_REG_SET_R2_NOT_LIMIT_THE_HIGH_LEVEL_VTH << AW87XXX_PID_18_REG_SET_R2_START_BIT)

#define AW87XXX_PID_18_REG_SET_R2_LIMIT_THE_HIGH_LEVEL_VTH	(1)
#define AW87XXX_PID_18_REG_SET_R2_LIMIT_THE_HIGH_LEVEL_VTH_VALUE	\
	(AW87XXX_PID_18_REG_SET_R2_LIMIT_THE_HIGH_LEVEL_VTH << AW87XXX_PID_18_REG_SET_R2_START_BIT)

#define AW87XXX_PID_18_REG_SET_R2_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_SET_R2_DEFAULT	\
	(AW87XXX_PID_18_REG_SET_R2_DEFAULT_VALUE << AW87XXX_PID_18_REG_SET_R2_START_BIT)

/* REG_CP_ISOFT bit 6:5 (DFT1 0x61) */
#define AW87XXX_PID_18_REG_CP_ISOFT_START_BIT	(5)
#define AW87XXX_PID_18_REG_CP_ISOFT_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_CP_ISOFT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CP_ISOFT_BITS_LEN)-1) << AW87XXX_PID_18_REG_CP_ISOFT_START_BIT))

#define AW87XXX_PID_18_REG_CP_ISOFT_0P2A	(0)
#define AW87XXX_PID_18_REG_CP_ISOFT_0P2A_VALUE	\
	(AW87XXX_PID_18_REG_CP_ISOFT_0P2A << AW87XXX_PID_18_REG_CP_ISOFT_START_BIT)

#define AW87XXX_PID_18_REG_CP_ISOFT_0P3A	(1)
#define AW87XXX_PID_18_REG_CP_ISOFT_0P3A_VALUE	\
	(AW87XXX_PID_18_REG_CP_ISOFT_0P3A << AW87XXX_PID_18_REG_CP_ISOFT_START_BIT)

#define AW87XXX_PID_18_REG_CP_ISOFT_0P4A	(2)
#define AW87XXX_PID_18_REG_CP_ISOFT_0P4A_VALUE	\
	(AW87XXX_PID_18_REG_CP_ISOFT_0P4A << AW87XXX_PID_18_REG_CP_ISOFT_START_BIT)

#define AW87XXX_PID_18_REG_CP_ISOFT_0P5A	(3)
#define AW87XXX_PID_18_REG_CP_ISOFT_0P5A_VALUE	\
	(AW87XXX_PID_18_REG_CP_ISOFT_0P5A << AW87XXX_PID_18_REG_CP_ISOFT_START_BIT)

#define AW87XXX_PID_18_REG_CP_ISOFT_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_CP_ISOFT_DEFAULT	\
	(AW87XXX_PID_18_REG_CP_ISOFT_DEFAULT_VALUE << AW87XXX_PID_18_REG_CP_ISOFT_START_BIT)

/* REG_CP_IPEAK bit 4:2 (DFT1 0x61) */
#define AW87XXX_PID_18_REG_CP_IPEAK_START_BIT	(2)
#define AW87XXX_PID_18_REG_CP_IPEAK_BITS_LEN	(3)
#define AW87XXX_PID_18_REG_CP_IPEAK_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CP_IPEAK_BITS_LEN)-1) << AW87XXX_PID_18_REG_CP_IPEAK_START_BIT))

#define AW87XXX_PID_18_REG_CP_IPEAK_2A	(0)
#define AW87XXX_PID_18_REG_CP_IPEAK_2A_VALUE	\
	(AW87XXX_PID_18_REG_CP_IPEAK_2A << AW87XXX_PID_18_REG_CP_IPEAK_START_BIT)

#define AW87XXX_PID_18_REG_CP_IPEAK_2P5A	(1)
#define AW87XXX_PID_18_REG_CP_IPEAK_2P5A_VALUE	\
	(AW87XXX_PID_18_REG_CP_IPEAK_2P5A << AW87XXX_PID_18_REG_CP_IPEAK_START_BIT)

#define AW87XXX_PID_18_REG_CP_IPEAK_3A	(2)
#define AW87XXX_PID_18_REG_CP_IPEAK_3A_VALUE	\
	(AW87XXX_PID_18_REG_CP_IPEAK_3A << AW87XXX_PID_18_REG_CP_IPEAK_START_BIT)

#define AW87XXX_PID_18_REG_CP_IPEAK_3P5A	(3)
#define AW87XXX_PID_18_REG_CP_IPEAK_3P5A_VALUE	\
	(AW87XXX_PID_18_REG_CP_IPEAK_3P5A << AW87XXX_PID_18_REG_CP_IPEAK_START_BIT)

#define AW87XXX_PID_18_REG_CP_IPEAK_4A	(4)
#define AW87XXX_PID_18_REG_CP_IPEAK_4A_VALUE	\
	(AW87XXX_PID_18_REG_CP_IPEAK_4A << AW87XXX_PID_18_REG_CP_IPEAK_START_BIT)

#define AW87XXX_PID_18_REG_CP_IPEAK_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_CP_IPEAK_DEFAULT	\
	(AW87XXX_PID_18_REG_CP_IPEAK_DEFAULT_VALUE << AW87XXX_PID_18_REG_CP_IPEAK_START_BIT)

/* REG_SET_OCDT bit 1:0 (DFT1 0x61) */
#define AW87XXX_PID_18_REG_SET_OCDT_START_BIT	(0)
#define AW87XXX_PID_18_REG_SET_OCDT_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_SET_OCDT_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_SET_OCDT_BITS_LEN)-1) << AW87XXX_PID_18_REG_SET_OCDT_START_BIT))

#define AW87XXX_PID_18_REG_SET_OCDT_4P1A	(0)
#define AW87XXX_PID_18_REG_SET_OCDT_4P1A_VALUE	\
	(AW87XXX_PID_18_REG_SET_OCDT_4P1A << AW87XXX_PID_18_REG_SET_OCDT_START_BIT)

#define AW87XXX_PID_18_REG_SET_OCDT_4P5A	(1)
#define AW87XXX_PID_18_REG_SET_OCDT_4P5A_VALUE	\
	(AW87XXX_PID_18_REG_SET_OCDT_4P5A << AW87XXX_PID_18_REG_SET_OCDT_START_BIT)

#define AW87XXX_PID_18_REG_SET_OCDT_4P9A	(2)
#define AW87XXX_PID_18_REG_SET_OCDT_4P9A_VALUE	\
	(AW87XXX_PID_18_REG_SET_OCDT_4P9A << AW87XXX_PID_18_REG_SET_OCDT_START_BIT)

#define AW87XXX_PID_18_REG_SET_OCDT_5P3A	(3)
#define AW87XXX_PID_18_REG_SET_OCDT_5P3A_VALUE	\
	(AW87XXX_PID_18_REG_SET_OCDT_5P3A << AW87XXX_PID_18_REG_SET_OCDT_START_BIT)

#define AW87XXX_PID_18_REG_SET_OCDT_DEFAULT_VALUE	(0X2)
#define AW87XXX_PID_18_REG_SET_OCDT_DEFAULT	\
	(AW87XXX_PID_18_REG_SET_OCDT_DEFAULT_VALUE << AW87XXX_PID_18_REG_SET_OCDT_START_BIT)

/* default value of DFT1 (0x61) */
/* #define AW87XXX_PID_18_DFT1_DEFAULT		(0xA6) */

/* DFT2 (0x62) detail */
/* REG_CP_TEST bit 7 (DFT2 0x62) */
#define AW87XXX_PID_18_REG_CP_TEST_START_BIT	(7)
#define AW87XXX_PID_18_REG_CP_TEST_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_CP_TEST_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CP_TEST_BITS_LEN)-1) << AW87XXX_PID_18_REG_CP_TEST_START_BIT))

#define AW87XXX_PID_18_REG_CP_TEST_DISABLE	(0)
#define AW87XXX_PID_18_REG_CP_TEST_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_CP_TEST_DISABLE << AW87XXX_PID_18_REG_CP_TEST_START_BIT)

#define AW87XXX_PID_18_REG_CP_TEST_ENABLE	(1)
#define AW87XXX_PID_18_REG_CP_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_CP_TEST_ENABLE << AW87XXX_PID_18_REG_CP_TEST_START_BIT)

#define AW87XXX_PID_18_REG_CP_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_CP_TEST_DEFAULT	\
	(AW87XXX_PID_18_REG_CP_TEST_DEFAULT_VALUE << AW87XXX_PID_18_REG_CP_TEST_START_BIT)

/* REG_VFAGC bit 6:4 (DFT2 0x62) */
#define AW87XXX_PID_18_REG_VFAGC_START_BIT	(4)
#define AW87XXX_PID_18_REG_VFAGC_BITS_LEN	(3)
#define AW87XXX_PID_18_REG_VFAGC_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_VFAGC_BITS_LEN)-1) << AW87XXX_PID_18_REG_VFAGC_START_BIT))

#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P775VDDVREF_FAGC_VHYS0P7VDD	(0)
#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P775VDDVREF_FAGC_VHYS0P7VDD_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P775VDDVREF_FAGC_VHYS0P7VDD << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P8VDDVREF_FAGC_VHYS0P725VDD	(1)
#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P8VDDVREF_FAGC_VHYS0P725VDD_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P8VDDVREF_FAGC_VHYS0P725VDD << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P825VDDVREF_FAGC_VHYS0P75VDD	(2)
#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P825VDDVREF_FAGC_VHYS0P75VDD_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P825VDDVREF_FAGC_VHYS0P75VDD << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P85VDDVREF_FAGC_VHYS0P775VDD	(3)
#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P85VDDVREF_FAGC_VHYS0P775VDD_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P85VDDVREF_FAGC_VHYS0P775VDD << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P875VDDVREF_FAGC_VHYS0P8VDD	(4)
#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P875VDDVREF_FAGC_VHYS0P8VDD_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P875VDDVREF_FAGC_VHYS0P8VDD << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P9VDDVREF_FAGC_VHYS0P825VDD	(5)
#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P9VDDVREF_FAGC_VHYS0P825VDD_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P9VDDVREF_FAGC_VHYS0P825VDD << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P925VDDVREF_FAGC_VHYS0P85VDD	(6)
#define AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P925VDDVREF_FAGC_VHYS0P85VDD_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_VREF_FAGC0P925VDDVREF_FAGC_VHYS0P85VDD << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_001	(7)
#define AW87XXX_PID_18_REG_VFAGC_001_VALUE	\
	(AW87XXX_PID_18_REG_VFAGC_001 << AW87XXX_PID_18_REG_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_VFAGC_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_VFAGC_DEFAULT	\
	(AW87XXX_PID_18_REG_VFAGC_DEFAULT_VALUE << AW87XXX_PID_18_REG_VFAGC_START_BIT)

/* REG_CP_OVP_TEST bit 3:2 (DFT2 0x62) */
#define AW87XXX_PID_18_REG_CP_OVP_TEST_START_BIT	(2)
#define AW87XXX_PID_18_REG_CP_OVP_TEST_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_CP_OVP_TEST_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_CP_OVP_TEST_BITS_LEN)-1) << AW87XXX_PID_18_REG_CP_OVP_TEST_START_BIT))

#define AW87XXX_PID_18_REG_CP_OVP_TEST_8P7V	(0)
#define AW87XXX_PID_18_REG_CP_OVP_TEST_8P7V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_TEST_8P7V << AW87XXX_PID_18_REG_CP_OVP_TEST_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_TEST_9P0V	(1)
#define AW87XXX_PID_18_REG_CP_OVP_TEST_9P0V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_TEST_9P0V << AW87XXX_PID_18_REG_CP_OVP_TEST_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_TEST_9P20V	(2)
#define AW87XXX_PID_18_REG_CP_OVP_TEST_9P20V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_TEST_9P20V << AW87XXX_PID_18_REG_CP_OVP_TEST_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_TEST_9P5V	(3)
#define AW87XXX_PID_18_REG_CP_OVP_TEST_9P5V_VALUE	\
	(AW87XXX_PID_18_REG_CP_OVP_TEST_9P5V << AW87XXX_PID_18_REG_CP_OVP_TEST_START_BIT)

#define AW87XXX_PID_18_REG_CP_OVP_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_CP_OVP_TEST_DEFAULT	\
	(AW87XXX_PID_18_REG_CP_OVP_TEST_DEFAULT_VALUE << AW87XXX_PID_18_REG_CP_OVP_TEST_START_BIT)

/* REG_PAVG bit 1:0 (DFT2 0x62) */
#define AW87XXX_PID_18_REG_PAVG_START_BIT	(0)
#define AW87XXX_PID_18_REG_PAVG_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_PAVG_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_PAVG_BITS_LEN)-1) << AW87XXX_PID_18_REG_PAVG_START_BIT))

#define AW87XXX_PID_18_REG_PAVG_PO0P94	(0)
#define AW87XXX_PID_18_REG_PAVG_PO0P94_VALUE	\
	(AW87XXX_PID_18_REG_PAVG_PO0P94 << AW87XXX_PID_18_REG_PAVG_START_BIT)

#define AW87XXX_PID_18_REG_PAVG_PO1		(1)
#define AW87XXX_PID_18_REG_PAVG_PO1_VALUE	\
	(AW87XXX_PID_18_REG_PAVG_PO1 << AW87XXX_PID_18_REG_PAVG_START_BIT)

#define AW87XXX_PID_18_REG_PAVG_PO1P06	(2)
#define AW87XXX_PID_18_REG_PAVG_PO1P06_VALUE	\
	(AW87XXX_PID_18_REG_PAVG_PO1P06 << AW87XXX_PID_18_REG_PAVG_START_BIT)

#define AW87XXX_PID_18_REG_PAVG_TURN_TO_10	(3)
#define AW87XXX_PID_18_REG_PAVG_TURN_TO_10_VALUE	\
	(AW87XXX_PID_18_REG_PAVG_TURN_TO_10 << AW87XXX_PID_18_REG_PAVG_START_BIT)

#define AW87XXX_PID_18_REG_PAVG_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_PAVG_DEFAULT	\
	(AW87XXX_PID_18_REG_PAVG_DEFAULT_VALUE << AW87XXX_PID_18_REG_PAVG_START_BIT)

/* default value of DFT2 (0x62) */
/* #define AW87XXX_PID_18_DFT2_DEFAULT		(0x11) */

/* DFT3 (0x63) detail */
/* REG_TDEAD_CP bit 7 (DFT3 0x63) */
#define AW87XXX_PID_18_REG_TDEAD_CP_START_BIT	(7)
#define AW87XXX_PID_18_REG_TDEAD_CP_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_TDEAD_CP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_TDEAD_CP_BITS_LEN)-1) << AW87XXX_PID_18_REG_TDEAD_CP_START_BIT))

#define AW87XXX_PID_18_REG_TDEAD_CP_DEFAULT_SETTIG	(0)
#define AW87XXX_PID_18_REG_TDEAD_CP_DEFAULT_SETTIG_VALUE	\
	(AW87XXX_PID_18_REG_TDEAD_CP_DEFAULT_SETTIG << AW87XXX_PID_18_REG_TDEAD_CP_START_BIT)

#define AW87XXX_PID_18_REG_TDEAD_CP_ENLARGE_THE_DEAD_TIME	(1)
#define AW87XXX_PID_18_REG_TDEAD_CP_ENLARGE_THE_DEAD_TIME_VALUE	\
	(AW87XXX_PID_18_REG_TDEAD_CP_ENLARGE_THE_DEAD_TIME << AW87XXX_PID_18_REG_TDEAD_CP_START_BIT)

#define AW87XXX_PID_18_REG_TDEAD_CP_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_TDEAD_CP_DEFAULT	\
	(AW87XXX_PID_18_REG_TDEAD_CP_DEFAULT_VALUE << AW87XXX_PID_18_REG_TDEAD_CP_START_BIT)

/* REG_EN_EXPVDD bit 6 (DFT3 0x63) */
#define AW87XXX_PID_18_REG_EN_EXPVDD_START_BIT	(6)
#define AW87XXX_PID_18_REG_EN_EXPVDD_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_EXPVDD_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_EXPVDD_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_EXPVDD_START_BIT))

#define AW87XXX_PID_18_REG_EN_EXPVDD_DISABLE	(0)
#define AW87XXX_PID_18_REG_EN_EXPVDD_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_EXPVDD_DISABLE << AW87XXX_PID_18_REG_EN_EXPVDD_START_BIT)

#define AW87XXX_PID_18_REG_EN_EXPVDD_ENABLE	(1)
#define AW87XXX_PID_18_REG_EN_EXPVDD_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_EN_EXPVDD_ENABLE << AW87XXX_PID_18_REG_EN_EXPVDD_START_BIT)

#define AW87XXX_PID_18_REG_EN_EXPVDD_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EN_EXPVDD_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_EXPVDD_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_EXPVDD_START_BIT)

/* REG_TM_MADP bit 5 (DFT3 0x63) */
#define AW87XXX_PID_18_REG_TM_MADP_START_BIT	(5)
#define AW87XXX_PID_18_REG_TM_MADP_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_TM_MADP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_TM_MADP_BITS_LEN)-1) << AW87XXX_PID_18_REG_TM_MADP_START_BIT))

#define AW87XXX_PID_18_REG_TM_MADP_DISABLE	(0)
#define AW87XXX_PID_18_REG_TM_MADP_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_TM_MADP_DISABLE << AW87XXX_PID_18_REG_TM_MADP_START_BIT)

#define AW87XXX_PID_18_REG_TM_MADP_ENABLE	(1)
#define AW87XXX_PID_18_REG_TM_MADP_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_TM_MADP_ENABLE << AW87XXX_PID_18_REG_TM_MADP_START_BIT)

#define AW87XXX_PID_18_REG_TM_MADP_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_TM_MADP_DEFAULT	\
	(AW87XXX_PID_18_REG_TM_MADP_DEFAULT_VALUE << AW87XXX_PID_18_REG_TM_MADP_START_BIT)

/* REG_PD_UVLO bit 4 (DFT3 0x63) */
#define AW87XXX_PID_18_REG_PD_UVLO_START_BIT	(4)
#define AW87XXX_PID_18_REG_PD_UVLO_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_PD_UVLO_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_PD_UVLO_BITS_LEN)-1) << AW87XXX_PID_18_REG_PD_UVLO_START_BIT))

#define AW87XXX_PID_18_REG_PD_UVLO_ENABLE	(0)
#define AW87XXX_PID_18_REG_PD_UVLO_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_UVLO_ENABLE << AW87XXX_PID_18_REG_PD_UVLO_START_BIT)

#define AW87XXX_PID_18_REG_PD_UVLO_DISABLE	(1)
#define AW87XXX_PID_18_REG_PD_UVLO_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_UVLO_DISABLE << AW87XXX_PID_18_REG_PD_UVLO_START_BIT)

#define AW87XXX_PID_18_REG_PD_UVLO_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_PD_UVLO_DEFAULT	\
	(AW87XXX_PID_18_REG_PD_UVLO_DEFAULT_VALUE << AW87XXX_PID_18_REG_PD_UVLO_START_BIT)

/* REG_UVLO_VTH bit 3:2 (DFT3 0x63) */
#define AW87XXX_PID_18_REG_UVLO_VTH_START_BIT	(2)
#define AW87XXX_PID_18_REG_UVLO_VTH_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_UVLO_VTH_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_UVLO_VTH_BITS_LEN)-1) << AW87XXX_PID_18_REG_UVLO_VTH_START_BIT))

#define AW87XXX_PID_18_REG_UVLO_VTH_2P6V2P5V	(0)
#define AW87XXX_PID_18_REG_UVLO_VTH_2P6V2P5V_VALUE	\
	(AW87XXX_PID_18_REG_UVLO_VTH_2P6V2P5V << AW87XXX_PID_18_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_18_REG_UVLO_VTH_2P7V2P6V	(1)
#define AW87XXX_PID_18_REG_UVLO_VTH_2P7V2P6V_VALUE	\
	(AW87XXX_PID_18_REG_UVLO_VTH_2P7V2P6V << AW87XXX_PID_18_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_18_REG_UVLO_VTH_2P5V2P4V	(2)
#define AW87XXX_PID_18_REG_UVLO_VTH_2P5V2P4V_VALUE	\
	(AW87XXX_PID_18_REG_UVLO_VTH_2P5V2P4V << AW87XXX_PID_18_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_18_REG_UVLO_VTH_TURN_TO_00	(3)
#define AW87XXX_PID_18_REG_UVLO_VTH_TURN_TO_00_VALUE	\
	(AW87XXX_PID_18_REG_UVLO_VTH_TURN_TO_00 << AW87XXX_PID_18_REG_UVLO_VTH_START_BIT)

#define AW87XXX_PID_18_REG_UVLO_VTH_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_UVLO_VTH_DEFAULT	\
	(AW87XXX_PID_18_REG_UVLO_VTH_DEFAULT_VALUE << AW87XXX_PID_18_REG_UVLO_VTH_START_BIT)

/* REG_PD_CRS0 bit 1:0 (DFT3 0x63) */
#define AW87XXX_PID_18_REG_PD_CRS0_START_BIT	(0)
#define AW87XXX_PID_18_REG_PD_CRS0_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_PD_CRS0_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_PD_CRS0_BITS_LEN)-1) << AW87XXX_PID_18_REG_PD_CRS0_START_BIT))

#define AW87XXX_PID_18_REG_PD_CRS0_ALL_OF_AGC1_AGC2_AND_AGC3_CROSS_ZERO_ENABLE	(0)
#define AW87XXX_PID_18_REG_PD_CRS0_ALL_OF_AGC1_AGC2_AND_AGC3_CROSS_ZERO_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_CRS0_ALL_OF_AGC1_AGC2_AND_AGC3_CROSS_ZERO_ENABLE << AW87XXX_PID_18_REG_PD_CRS0_START_BIT)

#define AW87XXX_PID_18_REG_PD_CRS0_BOTH_AGC2_AND_AGC3_CROSS_ZERO_ENABLE_AGC1_CROSS_ZERO_DISABLE	(1)
#define AW87XXX_PID_18_REG_PD_CRS0_BOTH_AGC2_AND_AGC3_CROSS_ZERO_ENABLE_AGC1_CROSS_ZERO_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_CRS0_BOTH_AGC2_AND_AGC3_CROSS_ZERO_ENABLE_AGC1_CROSS_ZERO_DISABLE << AW87XXX_PID_18_REG_PD_CRS0_START_BIT)

#define AW87XXX_PID_18_REG_PD_CRS0_ONLY_AGC3_CROSS_ZERO_ENABLE_AGC1_AND_AGC2_CROSS_ZERO_DISABLE	(2)
#define AW87XXX_PID_18_REG_PD_CRS0_ONLY_AGC3_CROSS_ZERO_ENABLE_AGC1_AND_AGC2_CROSS_ZERO_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_CRS0_ONLY_AGC3_CROSS_ZERO_ENABLE_AGC1_AND_AGC2_CROSS_ZERO_DISABLE << AW87XXX_PID_18_REG_PD_CRS0_START_BIT)

#define AW87XXX_PID_18_REG_PD_CRS0_ALL_OF_AGC1_AGC2_AND_AGC3_CROSS_ZERO_DISABLE	(3)
#define AW87XXX_PID_18_REG_PD_CRS0_ALL_OF_AGC1_AGC2_AND_AGC3_CROSS_ZERO_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_PD_CRS0_ALL_OF_AGC1_AGC2_AND_AGC3_CROSS_ZERO_DISABLE << AW87XXX_PID_18_REG_PD_CRS0_START_BIT)

#define AW87XXX_PID_18_REG_PD_CRS0_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_PD_CRS0_DEFAULT	\
	(AW87XXX_PID_18_REG_PD_CRS0_DEFAULT_VALUE << AW87XXX_PID_18_REG_PD_CRS0_START_BIT)

/* default value of DFT3 (0x63) */
/* #define AW87XXX_PID_18_DFT3_DEFAULT		(0x00) */

/* DFT4 (0x64) detail */
/* REG_DEGLITCH_CP bit 7:6 (DFT4 0x64) */
#define AW87XXX_PID_18_REG_DEGLITCH_CP_START_BIT	(6)
#define AW87XXX_PID_18_REG_DEGLITCH_CP_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_DEGLITCH_CP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_DEGLITCH_CP_BITS_LEN)-1) << AW87XXX_PID_18_REG_DEGLITCH_CP_START_BIT))

#define AW87XXX_PID_18_REG_DEGLITCH_CP_3NS	(0)
#define AW87XXX_PID_18_REG_DEGLITCH_CP_3NS_VALUE	\
	(AW87XXX_PID_18_REG_DEGLITCH_CP_3NS << AW87XXX_PID_18_REG_DEGLITCH_CP_START_BIT)

#define AW87XXX_PID_18_REG_DEGLITCH_CP_5NS	(1)
#define AW87XXX_PID_18_REG_DEGLITCH_CP_5NS_VALUE	\
	(AW87XXX_PID_18_REG_DEGLITCH_CP_5NS << AW87XXX_PID_18_REG_DEGLITCH_CP_START_BIT)

#define AW87XXX_PID_18_REG_DEGLITCH_CP_1NS	(2)
#define AW87XXX_PID_18_REG_DEGLITCH_CP_1NS_VALUE	\
	(AW87XXX_PID_18_REG_DEGLITCH_CP_1NS << AW87XXX_PID_18_REG_DEGLITCH_CP_START_BIT)

#define AW87XXX_PID_18_REG_DEGLITCH_CP_0NS	(3)
#define AW87XXX_PID_18_REG_DEGLITCH_CP_0NS_VALUE	\
	(AW87XXX_PID_18_REG_DEGLITCH_CP_0NS << AW87XXX_PID_18_REG_DEGLITCH_CP_START_BIT)

#define AW87XXX_PID_18_REG_DEGLITCH_CP_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_DEGLITCH_CP_DEFAULT	\
	(AW87XXX_PID_18_REG_DEGLITCH_CP_DEFAULT_VALUE << AW87XXX_PID_18_REG_DEGLITCH_CP_START_BIT)

/* REG_EDGE_CP bit 5:4 (DFT4 0x64) */
#define AW87XXX_PID_18_REG_EDGE_CP_START_BIT	(4)
#define AW87XXX_PID_18_REG_EDGE_CP_BITS_LEN	(2)
#define AW87XXX_PID_18_REG_EDGE_CP_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EDGE_CP_BITS_LEN)-1) << AW87XXX_PID_18_REG_EDGE_CP_START_BIT))

#define AW87XXX_PID_18_REG_EDGE_CP_DEFAULT_14P8NS	(0)
#define AW87XXX_PID_18_REG_EDGE_CP_DEFAULT_14P8NS_VALUE	\
	(AW87XXX_PID_18_REG_EDGE_CP_DEFAULT_14P8NS << AW87XXX_PID_18_REG_EDGE_CP_START_BIT)

#define AW87XXX_PID_18_REG_EDGE_CP_MODERATE_13P5NS	(1)
#define AW87XXX_PID_18_REG_EDGE_CP_MODERATE_13P5NS_VALUE	\
	(AW87XXX_PID_18_REG_EDGE_CP_MODERATE_13P5NS << AW87XXX_PID_18_REG_EDGE_CP_START_BIT)

#define AW87XXX_PID_18_REG_EDGE_CP_SLOWEST_19P3NS	(2)
#define AW87XXX_PID_18_REG_EDGE_CP_SLOWEST_19P3NS_VALUE	\
	(AW87XXX_PID_18_REG_EDGE_CP_SLOWEST_19P3NS << AW87XXX_PID_18_REG_EDGE_CP_START_BIT)

#define AW87XXX_PID_18_REG_EDGE_CP_FASTEST_4P6NS00	(3)
#define AW87XXX_PID_18_REG_EDGE_CP_FASTEST_4P6NS00_VALUE	\
	(AW87XXX_PID_18_REG_EDGE_CP_FASTEST_4P6NS00 << AW87XXX_PID_18_REG_EDGE_CP_START_BIT)

#define AW87XXX_PID_18_REG_EDGE_CP_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_EDGE_CP_DEFAULT	\
	(AW87XXX_PID_18_REG_EDGE_CP_DEFAULT_VALUE << AW87XXX_PID_18_REG_EDGE_CP_START_BIT)

/* REG_TESTSEL bit 3:0 (DFT4 0x64) */
#define AW87XXX_PID_18_REG_TESTSEL_START_BIT	(0)
#define AW87XXX_PID_18_REG_TESTSEL_BITS_LEN	(4)
#define AW87XXX_PID_18_REG_TESTSEL_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_TESTSEL_BITS_LEN)-1) << AW87XXX_PID_18_REG_TESTSEL_START_BIT))

#define AW87XXX_PID_18_REG_TESTSEL_VBG_FROM_BIAS	(0)
#define AW87XXX_PID_18_REG_TESTSEL_VBG_FROM_BIAS_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_VBG_FROM_BIAS << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_VCOM1_FROM_PREAMP	(1)
#define AW87XXX_PID_18_REG_TESTSEL_VCOM1_FROM_PREAMP_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_VCOM1_FROM_PREAMP << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_VREF_AGC_FROM_RAMP	(2)
#define AW87XXX_PID_18_REG_TESTSEL_VREF_AGC_FROM_RAMP_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_VREF_AGC_FROM_RAMP << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_VREF_ADP_FROM_THGEN	(3)
#define AW87XXX_PID_18_REG_TESTSEL_VREF_ADP_FROM_THGEN_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_VREF_ADP_FROM_THGEN << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_OC	(4)
#define AW87XXX_PID_18_REG_TESTSEL_OC_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_OC << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_OT160	(5)
#define AW87XXX_PID_18_REG_TESTSEL_OT160_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_OT160 << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_UVLO	(6)
#define AW87XXX_PID_18_REG_TESTSEL_UVLO_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_UVLO << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_GT_P_TEST_FROM_GATEDRIVER	(7)
#define AW87XXX_PID_18_REG_TESTSEL_GT_P_TEST_FROM_GATEDRIVER_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_GT_P_TEST_FROM_GATEDRIVER << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_GT_N_TEST_FROM_GATEDRIVER	(8)
#define AW87XXX_PID_18_REG_TESTSEL_GT_N_TEST_FROM_GATEDRIVER_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_GT_N_TEST_FROM_GATEDRIVER << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_GT1_P_TEST_FROM_GATEDRIVER	(9)
#define AW87XXX_PID_18_REG_TESTSEL_GT1_P_TEST_FROM_GATEDRIVER_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_GT1_P_TEST_FROM_GATEDRIVER << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_GT1_N_TEST_FROM_GATEDRIVER	(10)
#define AW87XXX_PID_18_REG_TESTSEL_GT1_N_TEST_FROM_GATEDRIVER_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_GT1_N_TEST_FROM_GATEDRIVER << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_OVP0_TEST_FROM_OVP	(11)
#define AW87XXX_PID_18_REG_TESTSEL_OVP0_TEST_FROM_OVP_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_OVP0_TEST_FROM_OVP << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_OVP1_TEST_FROM_OVP	(12)
#define AW87XXX_PID_18_REG_TESTSEL_OVP1_TEST_FROM_OVP_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_OVP1_TEST_FROM_OVP << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_PORN_TEST_FROM_PORN	(13)
#define AW87XXX_PID_18_REG_TESTSEL_PORN_TEST_FROM_PORN_VALUE	\
	(AW87XXX_PID_18_REG_TESTSEL_PORN_TEST_FROM_PORN << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

#define AW87XXX_PID_18_REG_TESTSEL_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_TESTSEL_DEFAULT	\
	(AW87XXX_PID_18_REG_TESTSEL_DEFAULT_VALUE << AW87XXX_PID_18_REG_TESTSEL_START_BIT)

/* default value of DFT4 (0x64) */
/* #define AW87XXX_PID_18_DFT4_DEFAULT		(0x00) */

/* DFT5 (0x65) detail */
/* FCLK_CS bit 5 (DFT5 0x65) */
#define AW87XXX_PID_18_FCLK_CS_START_BIT	(5)
#define AW87XXX_PID_18_FCLK_CS_BITS_LEN	(1)
#define AW87XXX_PID_18_FCLK_CS_MASK		\
	(~(((1<<AW87XXX_PID_18_FCLK_CS_BITS_LEN)-1) << AW87XXX_PID_18_FCLK_CS_START_BIT))

#define AW87XXX_PID_18_FCLK_CS_CHOOSE_THE_CLOCK_SIGNALCLK_PA_FROM_THE_ANALOG_PART	(0)
#define AW87XXX_PID_18_FCLK_CS_CHOOSE_THE_CLOCK_SIGNALCLK_PA_FROM_THE_ANALOG_PART_VALUE	\
	(AW87XXX_PID_18_FCLK_CS_CHOOSE_THE_CLOCK_SIGNALCLK_PA_FROM_THE_ANALOG_PART << AW87XXX_PID_18_FCLK_CS_START_BIT)

#define AW87XXX_PID_18_FCLK_CS_CHOOSE_THE_CLOCK_SIGNAL_GENERATED_BY_DIGITAL_PART_THEN_WRITE_0XA5_TO_THE_0X66_REGISTORGENERATE_A_PULSE_AFTER_EACH_WRITING	(1)
#define AW87XXX_PID_18_FCLK_CS_CHOOSE_THE_CLOCK_SIGNAL_GENERATED_BY_DIGITAL_PART_THEN_WRITE_0XA5_TO_THE_0X66_REGISTORGENERATE_A_PULSE_AFTER_EACH_WRITING_VALUE	\
	(AW87XXX_PID_18_FCLK_CS_CHOOSE_THE_CLOCK_SIGNAL_GENERATED_BY_DIGITAL_PART_THEN_WRITE_0XA5_TO_THE_0X66_REGISTORGENERATE_A_PULSE_AFTER_EACH_WRITING << AW87XXX_PID_18_FCLK_CS_START_BIT)

#define AW87XXX_PID_18_FCLK_CS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_FCLK_CS_DEFAULT	\
	(AW87XXX_PID_18_FCLK_CS_DEFAULT_VALUE << AW87XXX_PID_18_FCLK_CS_START_BIT)

/* REG_OT_TEST bit 4 (DFT5 0x65) */
#define AW87XXX_PID_18_REG_OT_TEST_START_BIT	(4)
#define AW87XXX_PID_18_REG_OT_TEST_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_OT_TEST_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_OT_TEST_BITS_LEN)-1) << AW87XXX_PID_18_REG_OT_TEST_START_BIT))

#define AW87XXX_PID_18_REG_OT_TEST_DISABLE_NOT_TO_TRANSFER_THE_OTN_TO_THE_TEST_BLOCK	(0)
#define AW87XXX_PID_18_REG_OT_TEST_DISABLE_NOT_TO_TRANSFER_THE_OTN_TO_THE_TEST_BLOCK_VALUE	\
	(AW87XXX_PID_18_REG_OT_TEST_DISABLE_NOT_TO_TRANSFER_THE_OTN_TO_THE_TEST_BLOCK << AW87XXX_PID_18_REG_OT_TEST_START_BIT)

#define AW87XXX_PID_18_REG_OT_TEST_ENABLE_TO_TRANSFER_THE_OTN_TO_THE_TEST_BLOCK	(1)
#define AW87XXX_PID_18_REG_OT_TEST_ENABLE_TO_TRANSFER_THE_OTN_TO_THE_TEST_BLOCK_VALUE	\
	(AW87XXX_PID_18_REG_OT_TEST_ENABLE_TO_TRANSFER_THE_OTN_TO_THE_TEST_BLOCK << AW87XXX_PID_18_REG_OT_TEST_START_BIT)

#define AW87XXX_PID_18_REG_OT_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_OT_TEST_DEFAULT	\
	(AW87XXX_PID_18_REG_OT_TEST_DEFAULT_VALUE << AW87XXX_PID_18_REG_OT_TEST_START_BIT)

/* REG_EN_OC bit 3 (DFT5 0x65) */
#define AW87XXX_PID_18_REG_EN_OC_START_BIT	(3)
#define AW87XXX_PID_18_REG_EN_OC_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_EN_OC_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_EN_OC_BITS_LEN)-1) << AW87XXX_PID_18_REG_EN_OC_START_BIT))

#define AW87XXX_PID_18_REG_EN_OC_TURN_OFF_THE_OC_BLOCK_FORCE_0C0	(0)
#define AW87XXX_PID_18_REG_EN_OC_TURN_OFF_THE_OC_BLOCK_FORCE_0C0_VALUE	\
	(AW87XXX_PID_18_REG_EN_OC_TURN_OFF_THE_OC_BLOCK_FORCE_0C0 << AW87XXX_PID_18_REG_EN_OC_START_BIT)

#define AW87XXX_PID_18_REG_EN_OC_TURN_ON_THE_OC_BLOCK_FUNCTION	(1)
#define AW87XXX_PID_18_REG_EN_OC_TURN_ON_THE_OC_BLOCK_FUNCTION_VALUE	\
	(AW87XXX_PID_18_REG_EN_OC_TURN_ON_THE_OC_BLOCK_FUNCTION << AW87XXX_PID_18_REG_EN_OC_START_BIT)

#define AW87XXX_PID_18_REG_EN_OC_DEFAULT_VALUE	(1)
#define AW87XXX_PID_18_REG_EN_OC_DEFAULT	\
	(AW87XXX_PID_18_REG_EN_OC_DEFAULT_VALUE << AW87XXX_PID_18_REG_EN_OC_START_BIT)

/* EN_RD bit 2 (DFT5 0x65) */
#define AW87XXX_PID_18_EN_RD_START_BIT	(2)
#define AW87XXX_PID_18_EN_RD_BITS_LEN	(1)
#define AW87XXX_PID_18_EN_RD_MASK		\
	(~(((1<<AW87XXX_PID_18_EN_RD_BITS_LEN)-1) << AW87XXX_PID_18_EN_RD_START_BIT))

#define AW87XXX_PID_18_EN_RD_DISABLE	(0)
#define AW87XXX_PID_18_EN_RD_DISABLE_VALUE	\
	(AW87XXX_PID_18_EN_RD_DISABLE << AW87XXX_PID_18_EN_RD_START_BIT)

#define AW87XXX_PID_18_EN_RD_ENABLE		(1)
#define AW87XXX_PID_18_EN_RD_ENABLE_VALUE	\
	(AW87XXX_PID_18_EN_RD_ENABLE << AW87XXX_PID_18_EN_RD_START_BIT)

#define AW87XXX_PID_18_EN_RD_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_EN_RD_DEFAULT	\
	(AW87XXX_PID_18_EN_RD_DEFAULT_VALUE << AW87XXX_PID_18_EN_RD_START_BIT)

/* REG_FAST_VFAGC bit 1 (DFT5 0x65) */
#define AW87XXX_PID_18_REG_FAST_VFAGC_START_BIT	(1)
#define AW87XXX_PID_18_REG_FAST_VFAGC_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_FAST_VFAGC_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_FAST_VFAGC_BITS_LEN)-1) << AW87XXX_PID_18_REG_FAST_VFAGC_START_BIT))

#define AW87XXX_PID_18_REG_FAST_VFAGC_DISABLE	(0)
#define AW87XXX_PID_18_REG_FAST_VFAGC_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_FAST_VFAGC_DISABLE << AW87XXX_PID_18_REG_FAST_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_FAST_VFAGC_ENABLE	(1)
#define AW87XXX_PID_18_REG_FAST_VFAGC_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_FAST_VFAGC_ENABLE << AW87XXX_PID_18_REG_FAST_VFAGC_START_BIT)

#define AW87XXX_PID_18_REG_FAST_VFAGC_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_FAST_VFAGC_DEFAULT	\
	(AW87XXX_PID_18_REG_FAST_VFAGC_DEFAULT_VALUE << AW87XXX_PID_18_REG_FAST_VFAGC_START_BIT)

/* REG_FAST_HVDD bit 0 (DFT5 0x65) */
#define AW87XXX_PID_18_REG_FAST_HVDD_START_BIT	(0)
#define AW87XXX_PID_18_REG_FAST_HVDD_BITS_LEN	(1)
#define AW87XXX_PID_18_REG_FAST_HVDD_MASK	\
	(~(((1<<AW87XXX_PID_18_REG_FAST_HVDD_BITS_LEN)-1) << AW87XXX_PID_18_REG_FAST_HVDD_START_BIT))

#define AW87XXX_PID_18_REG_FAST_HVDD_DISABLE	(0)
#define AW87XXX_PID_18_REG_FAST_HVDD_DISABLE_VALUE	\
	(AW87XXX_PID_18_REG_FAST_HVDD_DISABLE << AW87XXX_PID_18_REG_FAST_HVDD_START_BIT)

#define AW87XXX_PID_18_REG_FAST_HVDD_ENABLE	(1)
#define AW87XXX_PID_18_REG_FAST_HVDD_ENABLE_VALUE	\
	(AW87XXX_PID_18_REG_FAST_HVDD_ENABLE << AW87XXX_PID_18_REG_FAST_HVDD_START_BIT)

#define AW87XXX_PID_18_REG_FAST_HVDD_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_REG_FAST_HVDD_DEFAULT	\
	(AW87XXX_PID_18_REG_FAST_HVDD_DEFAULT_VALUE << AW87XXX_PID_18_REG_FAST_HVDD_START_BIT)

/* default value of DFT5 (0x65) */
/* #define AW87XXX_PID_18_DFT5_DEFAULT		(0x08) */

/* DFT6 (0x66) detail */
/* Q_SHDN bit 7:4 (DFT6 0x66) */
#define AW87XXX_PID_18_Q_SHDN_START_BIT	(4)
#define AW87XXX_PID_18_Q_SHDN_BITS_LEN	(4)
#define AW87XXX_PID_18_Q_SHDN_MASK		\
	(~(((1<<AW87XXX_PID_18_Q_SHDN_BITS_LEN)-1) << AW87XXX_PID_18_Q_SHDN_START_BIT))

#define AW87XXX_PID_18_Q_SHDN_MODE1		(0)
#define AW87XXX_PID_18_Q_SHDN_MODE1_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE1 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE2		(1)
#define AW87XXX_PID_18_Q_SHDN_MODE2_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE2 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE3		(2)
#define AW87XXX_PID_18_Q_SHDN_MODE3_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE3 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE4		(3)
#define AW87XXX_PID_18_Q_SHDN_MODE4_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE4 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE5		(4)
#define AW87XXX_PID_18_Q_SHDN_MODE5_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE5 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE6		(5)
#define AW87XXX_PID_18_Q_SHDN_MODE6_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE6 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE7		(6)
#define AW87XXX_PID_18_Q_SHDN_MODE7_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE7 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE8		(7)
#define AW87XXX_PID_18_Q_SHDN_MODE8_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE8 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE9		(8)
#define AW87XXX_PID_18_Q_SHDN_MODE9_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE9 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_MODE10	(9)
#define AW87XXX_PID_18_Q_SHDN_MODE10_VALUE	\
	(AW87XXX_PID_18_Q_SHDN_MODE10 << AW87XXX_PID_18_Q_SHDN_START_BIT)

#define AW87XXX_PID_18_Q_SHDN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_18_Q_SHDN_DEFAULT	\
	(AW87XXX_PID_18_Q_SHDN_DEFAULT_VALUE << AW87XXX_PID_18_Q_SHDN_START_BIT)

/* REG_FSS bit 3:0 (DFT6 0x66) */
#define AW87XXX_PID_18_REG_FSS_START_BIT	(0)
#define AW87XXX_PID_18_REG_FSS_BITS_LEN	(4)
#define AW87XXX_PID_18_REG_FSS_MASK		\
	(~(((1<<AW87XXX_PID_18_REG_FSS_BITS_LEN)-1) << AW87XXX_PID_18_REG_FSS_START_BIT))

#define AW87XXX_PID_18_REG_FSS_1P408MHZ	(0)
#define AW87XXX_PID_18_REG_FSS_1P408MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P408MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P432MHZ	(1)
#define AW87XXX_PID_18_REG_FSS_1P432MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P432MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P456MHZ	(3)
#define AW87XXX_PID_18_REG_FSS_1P456MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P456MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P48MHZ	(2)
#define AW87XXX_PID_18_REG_FSS_1P48MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P48MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P504MHZ	(6)
#define AW87XXX_PID_18_REG_FSS_1P504MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P504MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P528MHZ	(7)
#define AW87XXX_PID_18_REG_FSS_1P528MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P528MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P552MHZ	(5)
#define AW87XXX_PID_18_REG_FSS_1P552MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P552MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P576MHZ	(4)
#define AW87XXX_PID_18_REG_FSS_1P576MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P576MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P6MHZ	(12)
#define AW87XXX_PID_18_REG_FSS_1P6MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P6MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P627MHZ	(13)
#define AW87XXX_PID_18_REG_FSS_1P627MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P627MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P655MHZ	(15)
#define AW87XXX_PID_18_REG_FSS_1P655MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P655MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P682MHZ	(14)
#define AW87XXX_PID_18_REG_FSS_1P682MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P682MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P71MHZ	(10)
#define AW87XXX_PID_18_REG_FSS_1P71MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P71MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P737MHZ	(11)
#define AW87XXX_PID_18_REG_FSS_1P737MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P737MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P765MHZ	(9)
#define AW87XXX_PID_18_REG_FSS_1P765MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P765MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_1P792MHZ	(8)
#define AW87XXX_PID_18_REG_FSS_1P792MHZ_VALUE	\
	(AW87XXX_PID_18_REG_FSS_1P792MHZ << AW87XXX_PID_18_REG_FSS_START_BIT)

#define AW87XXX_PID_18_REG_FSS_DEFAULT_VALUE	(0x0C)
#define AW87XXX_PID_18_REG_FSS_DEFAULT	\
	(AW87XXX_PID_18_REG_FSS_DEFAULT_VALUE << AW87XXX_PID_18_REG_FSS_START_BIT)

/* default value of DFT6 (0x66) */
/* #define AW87XXX_PID_18_DFT6_DEFAULT		(0x0C) */

/* detail information of registers end */

#endif  /* #ifndef  __AW87XXX_PID_18_REG_H__ */