/* SPDX-License-Identifier: GPL-2.0 */
/******************************************************************************
 *
 * Copyright(c) 2016 - 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef _HALMAC_FW_INFO_H_
#define _HALMAC_FW_INFO_H_

#define H2C_FORMAT_VERSION				15

/* FW bin information */
#define WLAN_FW_HDR_SIZE				64
#define WLAN_FW_HDR_CHKSUM_SIZE			8

#define WLAN_FW_HDR_VERSION				4
#define WLAN_FW_HDR_SUBVERSION			6
#define WLAN_FW_HDR_SUBINDEX			7
#define WLAN_FW_HDR_MONTH				16
#define WLAN_FW_HDR_DATE				17
#define WLAN_FW_HDR_HOUR				18
#define WLAN_FW_HDR_MIN					19
#define WLAN_FW_HDR_YEAR				20
#define WLAN_FW_HDR_MEM_USAGE			24
#define WLAN_FW_HDR_H2C_FMT_VER			28
#define WLAN_FW_HDR_DMEM_ADDR			32
#define WLAN_FW_HDR_DMEM_SIZE			36
#define WLAN_FW_HDR_IMEM_SIZE			48
#define WLAN_FW_HDR_EMEM_SIZE			52
#define WLAN_FW_HDR_EMEM_ADDR			56
#define WLAN_FW_HDR_IMEM_ADDR			60

#define H2C_ACK_HDR_CONTENT_LENGTH			8
#define CFG_PARAMETER_ACK_CONTENT_LENGTH	16
#define CH_SWITCH_ACK_CONTENT_LENGTH		16
#define SCAN_STATUS_RPT_CONTENT_LENGTH		4
#define SCAN_STATUS_RPT_CONTENT_LENGTH_V2	12
#define SCAN_CH_NOTIFY_CONTENT_LENGTH		12
#define C2H_DBG_HDR_LEN						4
#define C2H_DBG_CONTENT_MAX_LENGTH			228
#define C2H_DBG_CONTENT_SEQ_OFFSET			1

/* Rename from FW SysHalCom_Debug_RAM.h */
#define FW_REG_H2CPKT_DONE_SEQ				0x1C8
#define FW_REG_WOW_REASON					0x1C7

enum halmac_data_type {
	HALMAC_DATA_TYPE_MAC_REG = 0x00,
	HALMAC_DATA_TYPE_BB_REG = 0x01,
	HALMAC_DATA_TYPE_RADIO_A = 0x02,
	HALMAC_DATA_TYPE_RADIO_B = 0x03,
	HALMAC_DATA_TYPE_RADIO_C = 0x04,
	HALMAC_DATA_TYPE_RADIO_D = 0x05,

	HALMAC_DATA_TYPE_DRV_DEFINE_0 = 0x80,
	HALMAC_DATA_TYPE_DRV_DEFINE_1 = 0x81,
	HALMAC_DATA_TYPE_DRV_DEFINE_2 = 0x82,
	HALMAC_DATA_TYPE_DRV_DEFINE_3 = 0x83,
	HALMAC_DATA_TYPE_UNDEFINE = 0x7FFFFFFF,
};

enum halmac_packet_id {
	HALMAC_PACKET_PROBE_REQ = 0x00,
	HALMAC_PACKET_SYNC_BCN = 0x01,
	HALMAC_PACKET_DISCOVERY_BCN = 0x02,
	HALMAC_PACKET_PROBE_REQ_NLO = 0xF0,
	HALMAC_PACKET_SYNC_BCN_NLO = 0xF1,
	HALMAC_PACKET_DISCOVERY_BCN_NLO = 0xF2,
	HALMAC_PACKET_UNDEFINE = 0x7FFFFFFF,
};

enum halmac_cs_action_id {
	HALMAC_CS_ACTION_NONE = 0x00,
	HALMAC_CS_ACTIVE_SCAN = 0x01,
	HALMAC_CS_NAN_NONMASTER_DW = 0x02,
	HALMAC_CS_NAN_NONMASTER_NONDW = 0x03,
	HALMAC_CS_NAN_MASTER_NONDW = 0x04,
	HALMAC_CS_NAN_MASTER_DW = 0x05,
	HALMAC_CS_ACTION_UNDEFINE = 0x7FFFFFFF,
};

enum halmac_cs_extra_action_id {
	HALMAC_CS_EXTRA_ACTION_NONE = 0x00,
	HALMAC_CS_EXTRA_UPDATE_PROBE = 0x01,
	HALMAC_CS_EXTRA_UPDATE_BEACON = 0x02,
	HALMAC_CS_EXTRA_ACTION_SCAN = 0x03,
	HALMAC_CS_EXTRA_ACTION_UNDEFINE = 0x7FFFFFFF,
};

enum halmac_h2c_return_code {
	HALMAC_H2C_RETURN_SUCCESS = 0x00,
	HALMAC_H2C_RETURN_CFG_ERR_LEN = 0x01,
	HALMAC_H2C_RETURN_CFG_ERR_CMD = 0x02,
	HALMAC_H2C_RETURN_EFUSE_ERR_DUMP = 0x03,
	HALMAC_H2C_RETURN_DATAPACK_ERR_FULL = 0x04,
	HALMAC_H2C_RETURN_DATAPACK_ERR_ID = 0x05,
	HALMAC_H2C_RETURN_RUN_ERR_EMPTY = 0x06,
	HALMAC_H2C_RETURN_RUN_ERR_LEN = 0x07,
	HALMAC_H2C_RETURN_RUN_ERR_CMD = 0x08,
	HALMAC_H2C_RETURN_RUN_ERR_ID = 0x09,
	HALMAC_H2C_RETURN_PACKET_ERR_FULL = 0x0A,
	HALMAC_H2C_RETURN_PACKET_ERR_ID = 0x0B,
	HALMAC_H2C_RETURN_SCAN_ERR_FULL = 0x0C,
	HALMAC_H2C_RETURN_SCAN_ERR_PHYDM = 0x0D,
	HALMAC_H2C_RETURN_ORIG_ERR_ID = 0x0E,
	HALMAC_H2C_RETURN_SCAN_PKT_FULL = 0x0F,
	HALMAC_H2C_RETURN_SCAN_PKT_BUF_BUSY = 0x10,
	HALMAC_H2C_RETURN_SCAN_PKT_IDX_REUSE = 0x11,
	HALMAC_H2C_RETURN_EFUSE_BUF_BUSY = 0x12,
	HALMAC_H2C_RETURN_UNDEFINE = 0x7FFFFFFF,
};

enum halmac_scan_report_code {
	HALMAC_SCAN_REPORT_DONE	= 0x00,
	HALMAC_SCAN_REPORT_ERR_PHYDM = 0x01,
	HALMAC_SCAN_REPORT_ERR_ID = 0x02,
	HALMAC_SCAN_REPORT_ERR_TX = 0x03,
	HALMAC_SCAN_REPORT_UNDEFINE = 0x7FFFFFFF,
};

enum halmac_scan_notify_id {
	HALMAC_SCAN_NOTIFY_ID_PRESWITCH = 0x00,
	HALMAC_SCAN_NOTIFY_ID_POSTSWITCH = 0x01,
	HALMAC_SCAN_NOTIFY_ID_PROBE_PRETX = 0x02,
	HALMAC_SCAN_NOTIFY_ID_PROBE_POSTTX = 0x03,
	HALMAC_SCAN_NOTIFY_ID_ACTION_PRETX = 0x04,
	HALMAC_SCAN_NOTIFY_ID_ACTION_POSTTX = 0x05,
	HALMAC_SCAN_NOTIFY_ID_DWELLEXT = 0x06,
	HALMAC_SCAN_NOTIFY_ID_UNDEFINE = 0x7F,
};

enum halmac_scan_notify_status {
	HALMAC_SCAN_NOTIFY_STATUS_NONE = 0x00,
	HALMAC_SCAN_NOTIFY_STATUS_PHYDM_OK = 0x01,
	HALMAC_SCAN_NOTIFY_STATUS_PHYDM_ERR = 0x02,
	HALMAC_SCAN_NOTIFY_STATUS_NO_PROBE = 0x03,
	HALMAC_SCAN_NOTIFY_STATUS_TX_PROBE_OK = 0x04,
	HALMAC_SCAN_NOTIFY_STATUS_TX_PROBE_FAIL = 0x05,
	HALMAC_SCAN_NOTIFY_STATUS_INVALID_ACTION_IDX = 0x06,
	HALMAC_SCAN_NOTIFY_STATUS_TX_ACTION_OK = 0x07,
	HALMAC_SCAN_NOTIFY_STATUS_TX_ACTION_FAIL = 0x08,
	HALMAC_SCAN_NOTIFY_STATUS_UNDEFINE = 0x7F,
};

#endif
