// SPDX-License-Identifier: GPL-2.0
/*
 * ov50c40 driver
 *
 * Copyright (C) 2020 Fuzhou Rockchip Electronics Co., Ltd.
 *
 * V0.0X01.0X00 first version.
 * V0.0X01.0X01 support conversion gain switch.
 * V0.0X01.0X02 add debug interface for conversion gain switch.
 * V0.0X01.0X03 support enum sensor fmt
 * V0.0X01.0X04 add quick stream on/off
 * V0.0X01.0X05 support get dcg ratio from sensor
 * V0.0X01.0X06
 * 1. fix 8K@12 mipi freq index.
 * 2. fix set_fmt & ioctl get mode unmatched issue.
 * 3. add debug info.
 * V0.0X01.0X07 correct bayer pattern to match register setting
 * V0.0X01.0X08 adjust some config for cts.
 * 1. only enable 8K@12fps & 4K@30fps setting for use, other for debug.
 */
//#define DEBUG
#include <linux/clk.h>
#include <linux/device.h>
#include <linux/delay.h>
#include <linux/gpio/consumer.h>
#include <linux/i2c.h>
#include <linux/module.h>
#include <linux/pm_runtime.h>
#include <linux/regulator/consumer.h>
#include <linux/sysfs.h>
#include <linux/slab.h>
#include <linux/version.h>
#include <linux/rk-camera-module.h>
#include <media/media-entity.h>
#include <media/v4l2-async.h>
#include <media/v4l2-ctrls.h>
#include <media/v4l2-subdev.h>
#include <media/v4l2-fwnode.h>
#include <linux/pinctrl/consumer.h>
#include <linux/rk-preisp.h>
#include "../platform/rockchip/isp/rkisp_tb_helper.h"
#include <linux/of_graph.h>
#include "otp_eeprom.h"

#define DRIVER_VERSION			KERNEL_VERSION(0, 0x01, 0x08)

#ifndef V4L2_CID_DIGITAL_GAIN
#define V4L2_CID_DIGITAL_GAIN		V4L2_CID_GAIN
#endif

#define MIPI_FREQ_356M			356000000
#define MIPI_FREQ_384M			384000000
#define MIPI_FREQ_750M			750000000
#define MIPI_FREQ_1250M			1250000000

#define PIXEL_RATE_WITH_1250M		(MIPI_FREQ_1250M / 10 * 4 * 2)

#define OF_CAMERA_HDR_MODE		"rockchip,camera-hdr-mode"

#define OV50C40_XVCLK_FREQ		24000000

#define CHIP_ID				0x565043
#define OV50C40_REG_CHIP_ID		0x300a

#define OV50C40_REG_CTRL_MODE		0x0100
#define OV50C40_MODE_SW_STANDBY		0x0
#define OV50C40_MODE_STREAMING		BIT(0)

#define	OV50C40_EXPOSURE_MIN		8
#define	OV50C40_EXPOSURE_STEP		1
#define OV50C40_VTS_MAX			0xffff

#define OV50C40_REG_EXP_LONG_H		0x3500

#define OV50C40_REG_AGAIN_LONG_H	0x3508
#define OV50C40_REG_DGAIN_LONG_H	0x350A
#define OV50C40_GAIN_MIN		0x80
#define OV50C40_GAIN_MAX		0x7C00
#define OV50C40_GAIN_STEP		1
#define OV50C40_GAIN_DEFAULT		0x80

#define OV50C40_GROUP_UPDATE_ADDRESS	0x3208
#define OV50C40_GROUP_UPDATE_START_DATA	0x00
#define OV50C40_GROUP_UPDATE_END_DATA	0x10
#define OV50C40_GROUP_UPDATE_END_LAUNCH	0xA0

#define OV50C40_SOFTWARE_RESET_REG	0x0103

#define OV50C40_FETCH_MSB_BYTE_EXP(VAL)	(((VAL) >> 8) & 0xFF)	/* 8 Bits */
#define OV50C40_FETCH_LSB_BYTE_EXP(VAL)	((VAL) & 0xFF)	/* 8 Bits */

#define OV50C40_FETCH_LSB_GAIN(VAL)	(((VAL) << 4) & 0xf0)
#define OV50C40_FETCH_MSB_GAIN(VAL)	(((VAL) >> 4) & 0x1f)

#define OV50C40_REG_TEST_PATTERN	0x5081
#define OV50C40_TEST_PATTERN_ENABLE	0x01
#define OV50C40_TEST_PATTERN_DISABLE	0x0

#define OV50C40_REG_VTS			0x380e

#define REG_NULL			0xFFFF

#define OV50C40_REG_VALUE_08BIT		1
#define OV50C40_REG_VALUE_16BIT		2
#define OV50C40_REG_VALUE_24BIT		3

#define OV50C40_LANES			4

#define OF_CAMERA_PINCTRL_STATE_DEFAULT	"rockchip,camera_default"
#define OF_CAMERA_PINCTRL_STATE_SLEEP	"rockchip,camera_sleep"

#define OV50C40_NAME			"ov50c40"

static const char * const ov50c40_supply_names[] = {
	"avdd",		/* Analog power */
	"dovdd",	/* Digital I/O power */
	"dvdd",		/* Digital core power */
};

#define OV50C40_NUM_SUPPLIES ARRAY_SIZE(ov50c40_supply_names)

#define OV50C40_FLIP_REG		0x3820
#define OV50C40_MIRROR_REG		0x3821
#define FLIP_BIT_MASK			BIT(2)

struct regval {
	u16 addr;
	u8 val;
};

struct other_data {
	u32 width;
	u32 height;
	u32 bus_fmt;
	u32 data_type;
	u32 data_bit;
};

struct ov50c40_mode {
	u32 bus_fmt;
	u32 width;
	u32 height;
	struct v4l2_fract max_fps;
	u32 hts_def;
	u32 vts_def;
	u32 exp_def;
	u32 mipi_freq_idx;
	u32 bpp;
	const struct regval *reg_list;
	u32 hdr_mode;
	const struct other_data *spd;
	u32 vc[PAD_MAX];
};

struct ov50c40 {
	struct i2c_client	*client;
	struct clk		*xvclk;
	struct gpio_desc	*reset_gpio;
	struct gpio_desc	*pwdn_gpio;
	struct regulator_bulk_data supplies[OV50C40_NUM_SUPPLIES];

	struct pinctrl		*pinctrl;
	struct pinctrl_state	*pins_default;
	struct pinctrl_state	*pins_sleep;

	struct v4l2_subdev	subdev;
	struct media_pad	pad;
	struct v4l2_ctrl_handler ctrl_handler;
	struct v4l2_ctrl	*exposure;
	struct v4l2_ctrl	*anal_gain;
	struct v4l2_ctrl	*digi_gain;
	struct v4l2_ctrl	*hblank;
	struct v4l2_ctrl	*vblank;
	struct v4l2_ctrl	*test_pattern;
	struct v4l2_ctrl	*pixel_rate;
	struct v4l2_ctrl	*link_freq;
	struct v4l2_ctrl	*h_flip;
	struct v4l2_ctrl	*v_flip;
	struct mutex		mutex;
	bool			streaming;
	bool			power_on;
	const struct ov50c40_mode *cur_mode;
	const struct ov50c40_mode *support_modes;
	u32			cfg_num;
	u32			module_index;
	const char		*module_facing;
	const char		*module_name;
	const char		*len_name;
	struct v4l2_fwnode_endpoint bus_cfg;
	bool			is_thunderboot;
	bool			is_thunderboot_ng;
	bool			is_first_streamoff;
	struct otp_info		*otp;
	u32			spd_id;
};

#define to_ov50c40(sd) container_of(sd, struct ov50c40, subdev)
#ifdef DEBUG
static const struct regval ov50c40_10bit_4096x3072_dphy_regs[] = {
	{0x0103, 0x01},
	{0x0301, 0xc8},
	{0x0304, 0x01},
	{0x0305, 0x80},
	{0x0306, 0x04},
	{0x0307, 0x01},
	{0x0324, 0x02},
	{0x0325, 0x58},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x032a, 0x0a},
	{0x0344, 0x01},
	{0x0345, 0x4a},
	{0x0350, 0x00},
	{0x0360, 0x09},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x41},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x00},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x02},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x00},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0x16},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x01},
	{0x3608, 0xda},
	{0x360c, 0x03},
	{0x360e, 0x1d},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x03},
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3699, 0x1f},
	{0x369b, 0x10},
	{0x369c, 0x19},
	{0x369d, 0x40},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x2f},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x60},
	{0x370b, 0x5d},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x03},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x3c},
	{0x373d, 0x40},
	{0x3754, 0xee},
	{0x375f, 0x80},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x32},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x36},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x10},
	{0x3809, 0x00},
	{0x380a, 0x0c},
	{0x380b, 0x00},
	{0x380c, 0x08},
	{0x380d, 0x34},
	{0x380e, 0x0c},
	{0x380f, 0x66},
	{0x3810, 0x00},
	{0x3811, 0x08},
	{0x3812, 0x00},
	{0x3813, 0x04},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x06},
	{0x3822, 0x10},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x83},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x08},
	{0x3845, 0x04},
	{0x3846, 0x1a},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x20},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x01},
	{0x3903, 0x08},
	{0x3905, 0x05},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x02},
	{0x399c, 0x03},
	{0x39aa, 0x05},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x2f},
	{0x39bc, 0x2f},
	{0x39be, 0x2f},
	{0x39c0, 0x2f},
	{0x39c2, 0x5d},
	{0x39c4, 0x5d},
	{0x39c6, 0x5d},
	{0x39c8, 0x5d},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x38},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x00},
	{0x401f, 0xd0},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x00},
	{0x4032, 0x00},
	{0x4033, 0x04},
	{0x4034, 0x00},
	{0x4035, 0x04},
	{0x4036, 0x00},
	{0x4037, 0x04},
	{0x4040, 0x00},
	{0x4041, 0x00},
	{0x4042, 0x00},
	{0x4043, 0x00},
	{0x4044, 0x00},
	{0x4045, 0x00},
	{0x4046, 0x00},
	{0x4047, 0x00},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x07},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x55},
	{0x4517, 0x55},
	{0x4518, 0x55},
	{0x4519, 0x55},
	{0x451a, 0x11},
	{0x451b, 0xbb},
	{0x451c, 0x11},
	{0x451d, 0xbb},
	{0x451e, 0x11},
	{0x451f, 0xbb},
	{0x4520, 0x11},
	{0x4521, 0xbb},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x7f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0a},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0a},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0a},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x00},
	{0x4721, 0x00},
	{0x4723, 0x00},
	{0x4724, 0x00},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x00},
	{0x4731, 0x0f},
	{0x4732, 0x0f},
	{0x4733, 0x0a},
	{0x4734, 0x0a},
	{0x4735, 0x07},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0a},
	{0x4739, 0x0a},
	{0x473a, 0x07},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0f},
	{0x473e, 0x0a},
	{0x473f, 0x0a},
	{0x4740, 0x07},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x04},
	{0x4802, 0x00},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x04},
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x2b},
	{0x4837, 0x14},
	{0x484b, 0x27},
	{0x4850, 0x4f},
	{0x4851, 0xaa},
	{0x4854, 0x06},
	{0x4860, 0x00},
	{0x4861, 0xec},
	{0x4862, 0x04},
	{0x4883, 0x00},
	{0x4888, 0x10},
	{0x4d00, 0x04},
	{0x4d01, 0xf7},
	{0x4d02, 0xb8},
	{0x4d03, 0x78},
	{0x4d04, 0x6d},
	{0x4d05, 0x36},
	{0x5000, 0x8b},
	{0x5001, 0x23},
	{0x5002, 0x9d},
	{0x5003, 0xca},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x5051, 0x14},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x63},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x02},
	{0x5c45, 0x0a},
	{0x5c46, 0x00},
	{0x5c47, 0x07},
	{0x5c48, 0x0f},
	{0x5c49, 0x01},
	{0x5c4a, 0x00},
	{0x5c4b, 0x09},
	{0x5c4c, 0x06},
	{0x5c4d, 0x0e},
	{0x5c4e, 0x00},
	{0x5c4f, 0x00},
	{0x5c50, 0x00},
	{0x5c51, 0x00},
	{0x5c52, 0x00},
	{0x5c53, 0x00},
	{0x5c54, 0x10},
	{0x5c55, 0x08},
	{0x5c56, 0x04},
	{0x5c57, 0x04},
	{0x5c58, 0x0c},
	{0x5c59, 0x0c},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x01},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};

static const struct regval ov50c40_10bit_8192x6144_dphy_regs[] = {
	{0x0103, 0x01},
	{0x0301, 0xc8},
	{0x0304, 0x01},
	{0x0305, 0x80},
	{0x0306, 0x04},
	{0x0307, 0x01},
	{0x0323, 0x06},
	{0x0324, 0x01},
	{0x0325, 0x2c},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x0329, 0x01},
	{0x032a, 0x0a},
	{0x0343, 0x06},
	{0x0344, 0x00},
	{0x0345, 0xa5},
	{0x034a, 0x05},
	{0x0350, 0x00},
	{0x0360, 0x09},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x41},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x00},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x02},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x00},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0x73},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x01},
	{0x3608, 0xda},
	{0x360c, 0x03},
	{0x360e, 0x1d},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x03},
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3699, 0x1f},
	{0x369b, 0x10},
	{0x369c, 0x19},
	{0x369d, 0x40},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x2f},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x60},
	{0x370b, 0x5d},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x03},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x3c},
	{0x373d, 0x40},
	{0x3754, 0xee},
	{0x375f, 0x80},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x32},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x36},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x20},
	{0x3809, 0x00},
	{0x380a, 0x18},
	{0x380b, 0x00},
	{0x380c, 0x09},
	{0x380d, 0xf6},
	{0x380e, 0x0c},
	{0x380f, 0xc3},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x08},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x06},
	{0x3822, 0x12},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x83},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x10},
	{0x3845, 0x09},
	{0x3846, 0xf6},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x20},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x01},
	{0x3903, 0x08},
	{0x3905, 0x05},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x02},
	{0x399c, 0x03},
	{0x39aa, 0x05},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x2f},
	{0x39bc, 0x2f},
	{0x39be, 0x2f},
	{0x39c0, 0x2f},
	{0x39c2, 0x5d},
	{0x39c4, 0x5d},
	{0x39c6, 0x5d},
	{0x39c8, 0x5d},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x28},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x00},
	{0x401f, 0xd0},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x10},
	{0x4032, 0x00},
	{0x4033, 0x10},
	{0x4034, 0x08},
	{0x4035, 0x10},
	{0x4036, 0x08},
	{0x4037, 0x10},
	{0x4040, 0x08},
	{0x4041, 0x10},
	{0x4042, 0x08},
	{0x4043, 0x10},
	{0x4044, 0x00},
	{0x4045, 0x10},
	{0x4046, 0x00},
	{0x4047, 0x10},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x07},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x55},
	{0x4517, 0x55},
	{0x4518, 0x55},
	{0x4519, 0x55},
	{0x451a, 0x11},
	{0x451b, 0xbb},
	{0x451c, 0x11},
	{0x451d, 0xbb},
	{0x451e, 0x11},
	{0x451f, 0xbb},
	{0x4520, 0x11},
	{0x4521, 0xbb},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x7f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0a},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0a},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0a},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x00},
	{0x4721, 0x00},
	{0x4723, 0x00},
	{0x4724, 0x00},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x00},
	{0x4731, 0x0f},
	{0x4732, 0x0f},
	{0x4733, 0x0a},
	{0x4734, 0x0a},
	{0x4735, 0x07},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0a},
	{0x4739, 0x0a},
	{0x473a, 0x07},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0f},
	{0x473e, 0x0a},
	{0x473f, 0x0a},
	{0x4740, 0x07},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x04},
	{0x4802, 0x00},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x04},//0x04
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x2b},
	{0x4837, 0x14},
	{0x484b, 0x27},
	{0x4850, 0x43},
	{0x4851, 0xaa},
	{0x4854, 0x06},
	{0x4860, 0x00},
	{0x4861, 0xec},
	{0x4862, 0x04},
	{0x4883, 0x00},
	{0x4888, 0x10},
	{0x4d00, 0x04},
	{0x4d01, 0xf7},
	{0x4d02, 0xb8},
	{0x4d03, 0x78},
	{0x4d04, 0x6d},
	{0x4d05, 0x36},
	{0x5000, 0x8b},
	{0x5001, 0x63},
	{0x5002, 0x9d},
	{0x5003, 0xca},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x5051, 0x14},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x63},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x02},
	{0x5c45, 0x0a},
	{0x5c46, 0x00},
	{0x5c47, 0x07},
	{0x5c48, 0x0f},
	{0x5c49, 0x01},
	{0x5c4a, 0x00},
	{0x5c4b, 0x09},
	{0x5c4c, 0x06},
	{0x5c4d, 0x0e},
	{0x5c4e, 0x00},
	{0x5c4f, 0x00},
	{0x5c50, 0x00},
	{0x5c51, 0x00},
	{0x5c52, 0x00},
	{0x5c53, 0x00},
	{0x5c54, 0x10},
	{0x5c55, 0x08},
	{0x5c56, 0x04},
	{0x5c57, 0x04},
	{0x5c58, 0x0c},
	{0x5c59, 0x0c},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x01},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};
static const struct regval ov50c40_10bit_4096x3072_dphy_30fps_nopd_regs[] = {
	{0x0103, 0x01},
	{0x5900, 0x40},
	{0x5901, 0x40},
	{0x5902, 0x40},
	{0x5903, 0x40},
	{0x5904, 0x40},
	{0x5905, 0x40},
	{0x5906, 0x40},
	{0x5907, 0x40},
	{0x5908, 0x40},
	{0x5909, 0x40},
	{0x590a, 0x40},
	{0x590b, 0x40},
	{0x590c, 0x40},
	{0x590d, 0x40},
	{0x590e, 0x40},
	{0x590f, 0x40},
	{0x5910, 0x40},
	{0x5911, 0x40},
	{0x5912, 0x40},
	{0x5913, 0x40},
	{0x5914, 0x40},
	{0x5915, 0x40},
	{0x5916, 0x40},
	{0x5917, 0x40},
	{0x5918, 0x40},
	{0x5919, 0x40},
	{0x591a, 0x40},
	{0x591b, 0x40},
	{0x591c, 0x40},
	{0x591d, 0x40},
	{0x591e, 0x40},
	{0x591f, 0x40},
	{0x5920, 0x40},
	{0x5921, 0x40},
	{0x5922, 0x40},
	{0x5923, 0x40},
	{0x5924, 0x40},
	{0x5925, 0x40},
	{0x5926, 0x40},
	{0x5927, 0x40},
	{0x5928, 0x40},
	{0x5929, 0x40},
	{0x592a, 0x40},
	{0x592b, 0x40},
	{0x592c, 0x40},
	{0x592d, 0x40},
	{0x592e, 0x40},
	{0x592f, 0x40},
	{0x5930, 0x40},
	{0x5931, 0x40},
	{0x5932, 0x40},
	{0x5933, 0x40},
	{0x5934, 0x40},
	{0x5935, 0x40},
	{0x5936, 0x40},
	{0x5937, 0x40},
	{0x5938, 0x40},
	{0x5939, 0x40},
	{0x593a, 0x40},
	{0x593b, 0x40},
	{0x593c, 0x40},
	{0x593d, 0x40},
	{0x593e, 0x40},
	{0x593f, 0x40},
	{0x5940, 0x40},
	{0x5941, 0x40},
	{0x5942, 0x40},
	{0x5943, 0x40},
	{0x5944, 0x40},
	{0x5945, 0x40},
	{0x5946, 0x40},
	{0x5947, 0x40},
	{0x5948, 0x40},
	{0x5949, 0x40},
	{0x594a, 0x40},
	{0x594b, 0x40},
	{0x594c, 0x40},
	{0x594d, 0x40},
	{0x594e, 0x40},
	{0x594f, 0x40},
	{0x5950, 0x40},
	{0x5951, 0x40},
	{0x5952, 0x40},
	{0x5953, 0x40},
	{0x5954, 0x40},
	{0x5955, 0x40},
	{0x5956, 0x40},
	{0x5957, 0x40},
	{0x5958, 0x40},
	{0x5959, 0x40},
	{0x595a, 0x40},
	{0x595b, 0x40},
	{0x595c, 0x40},
	{0x595d, 0x40},
	{0x595e, 0x40},
	{0x595f, 0x40},
	{0x5960, 0x40},
	{0x5961, 0x40},
	{0x5962, 0x40},
	{0x5963, 0x40},
	{0x5964, 0x40},
	{0x5965, 0x40},
	{0x5966, 0x40},
	{0x5967, 0x40},
	{0x5968, 0x40},
	{0x5969, 0x40},
	{0x596a, 0x40},
	{0x596b, 0x40},
	{0x596c, 0x40},
	{0x596d, 0x40},
	{0x596e, 0x40},
	{0x596f, 0x40},
	{0x5970, 0x40},
	{0x5971, 0x40},
	{0x5972, 0x40},
	{0x5973, 0x40},
	{0x5974, 0x40},
	{0x5975, 0x40},
	{0x5976, 0x40},
	{0x5977, 0x40},
	{0x5978, 0x40},
	{0x5979, 0x40},
	{0x597a, 0x40},
	{0x597b, 0x40},
	{0x597c, 0x40},
	{0x597d, 0x40},
	{0x597e, 0x40},
	{0x597f, 0x40},
	{0x5980, 0x40},
	{0x5981, 0x40},
	{0x5982, 0x40},
	{0x5983, 0x40},
	{0x5984, 0x40},
	{0x5985, 0x40},
	{0x5986, 0x40},
	{0x5987, 0x40},
	{0x5988, 0x40},
	{0x5989, 0x40},
	{0x598a, 0x40},
	{0x598b, 0x40},
	{0x598c, 0x40},
	{0x598d, 0x40},
	{0x598e, 0x40},
	{0x598f, 0x40},
	{0x5990, 0x40},
	{0x5991, 0x40},
	{0x5992, 0x40},
	{0x5993, 0x40},
	{0x5994, 0x40},
	{0x5995, 0x40},
	{0x5996, 0x40},
	{0x5997, 0x40},
	{0x5998, 0x40},
	{0x5999, 0x40},
	{0x599a, 0x40},
	{0x599b, 0x40},
	{0x599c, 0x40},
	{0x599d, 0x40},
	{0x599e, 0x40},
	{0x599f, 0x40},
	{0x59a0, 0x40},
	{0x59a1, 0x40},
	{0x59a2, 0x40},
	{0x59a3, 0x40},
	{0x59a4, 0x40},
	{0x59a5, 0x40},
	{0x59a6, 0x40},
	{0x59a7, 0x40},
	{0x59a8, 0x40},
	{0x59a9, 0x40},
	{0x59aa, 0x40},
	{0x59ab, 0x40},
	{0x59ac, 0x40},
	{0x59ad, 0x40},
	{0x59ae, 0x40},
	{0x59af, 0x40},
	{0x59b0, 0x40},
	{0x59b1, 0x40},
	{0x59b2, 0x40},
	{0x59b3, 0x40},
	{0x59b4, 0xcd},
	{0x59b5, 0xcd},
	{0x59b6, 0xcd},
	{0x59b7, 0xcd},
	{0x59b8, 0xcd},
	{0x59b9, 0xcd},
	{0x59ba, 0xcd},
	{0x59bb, 0xcd},
	{0x59bc, 0xcd},
	{0x59bd, 0xcd},
	{0x59be, 0xcd},
	{0x59bf, 0xcd},
	{0x59c0, 0xcd},
	{0x59c1, 0xcd},
	{0x59c2, 0xcd},
	{0x59c3, 0xcd},
	{0x59c4, 0xcd},
	{0x59c5, 0xcd},
	{0x59c6, 0xcd},
	{0x59c7, 0xcd},
	{0x59c8, 0xcd},
	{0x59c9, 0xcd},
	{0x59ca, 0xcd},
	{0x59cb, 0xcd},
	{0x59cc, 0xcd},
	{0x59cd, 0xcd},
	{0x59ce, 0xcd},
	{0x59cf, 0xcd},
	{0x59d0, 0xcd},
	{0x59d1, 0xcd},
	{0x59d2, 0xcd},
	{0x59d3, 0xcd},
	{0x59d4, 0xcd},
	{0x59d5, 0xcd},
	{0x59d6, 0xcd},
	{0x59d7, 0xcd},
	{0x59d8, 0xcd},
	{0x59d9, 0xcd},
	{0x59da, 0xcd},
	{0x59db, 0xcd},
	{0x59dc, 0xcd},
	{0x59dd, 0xcd},
	{0x59de, 0xcd},
	{0x59df, 0xcd},
	{0x59e0, 0xcd},
	{0x59e1, 0xcd},
	{0x59e2, 0xcd},
	{0x59e3, 0xcd},
	{0x59e4, 0xcd},
	{0x59e5, 0xcd},
	{0x59e6, 0xcd},
	{0x59e7, 0xcd},
	{0x59e8, 0xcd},
	{0x59e9, 0xcd},
	{0x59ea, 0xcd},
	{0x59eb, 0xcd},
	{0x59ec, 0xcd},
	{0x59ed, 0xcd},
	{0x59ee, 0xcd},
	{0x59ef, 0xcd},
	{0x59f0, 0xcd},
	{0x59f1, 0xcd},
	{0x59f2, 0xcd},
	{0x59f3, 0xcd},
	{0x59f4, 0xcd},
	{0x59f5, 0xcd},
	{0x59f6, 0xcd},
	{0x59f7, 0xcd},
	{0x59f8, 0xcd},
	{0x59f9, 0xcd},
	{0x59fa, 0xcd},
	{0x59fb, 0xcd},
	{0x59fc, 0xcd},
	{0x59fd, 0xcd},
	{0x59fe, 0xcd},
	{0x59ff, 0xcd},
	{0x5a00, 0xcd},
	{0x5a01, 0xcd},
	{0x5a02, 0xcd},
	{0x5a03, 0xcd},
	{0x5a04, 0xcd},
	{0x5a05, 0xcd},
	{0x5a06, 0xcd},
	{0x5a07, 0xcd},
	{0x5a08, 0xcd},
	{0x5a09, 0xcd},
	{0x5a0a, 0xcd},
	{0x5a0b, 0xcd},
	{0x5a0c, 0xcd},
	{0x5a0d, 0xcd},
	{0x5a0e, 0xcd},
	{0x5a0f, 0xcd},
	{0x5a10, 0xcd},
	{0x5a11, 0xcd},
	{0x5a12, 0xcd},
	{0x5a13, 0xcd},
	{0x5a14, 0xcd},
	{0x5a15, 0xcd},
	{0x5a16, 0xcd},
	{0x5a17, 0xcd},
	{0x5a18, 0xcd},
	{0x5a19, 0xcd},
	{0x5a1a, 0xcd},
	{0x5a1b, 0xcd},
	{0x5a1c, 0xcd},
	{0x5a1d, 0xcd},
	{0x5a1e, 0xcd},
	{0x5a1f, 0xcd},
	{0x5a20, 0xcd},
	{0x5a21, 0xcd},
	{0x5a22, 0xcd},
	{0x5a23, 0xcd},
	{0x5a24, 0xcd},
	{0x5a25, 0xcd},
	{0x5a26, 0xcd},
	{0x5a27, 0xcd},
	{0x5a28, 0xcd},
	{0x5a29, 0xcd},
	{0x5a2a, 0xcd},
	{0x5a2b, 0xcd},
	{0x5a2c, 0xcd},
	{0x5a2d, 0xcd},
	{0x5a2e, 0xcd},
	{0x5a2f, 0xcd},
	{0x5a30, 0xcd},
	{0x5a31, 0xcd},
	{0x5a32, 0xcd},
	{0x5a33, 0xcd},
	{0x5a34, 0xcd},
	{0x5a35, 0xcd},
	{0x5a36, 0xcd},
	{0x5a37, 0xcd},
	{0x5a38, 0xcd},
	{0x5a39, 0xcd},
	{0x5a3a, 0xcd},
	{0x5a3b, 0xcd},
	{0x5a3c, 0xcd},
	{0x5a3d, 0xcd},
	{0x5a3e, 0xcd},
	{0x5a3f, 0xcd},
	{0x5a40, 0xcd},
	{0x5a41, 0xcd},
	{0x5a42, 0xcd},
	{0x5a43, 0xcd},
	{0x5a44, 0xcd},
	{0x5a45, 0xcd},
	{0x5a46, 0xcd},
	{0x5a47, 0xcd},
	{0x5a48, 0xcd},
	{0x5a49, 0xcd},
	{0x5a4a, 0xcd},
	{0x5a4b, 0xcd},
	{0x5a4c, 0xcd},
	{0x5a4d, 0xcd},
	{0x5a4e, 0xcd},
	{0x5a4f, 0xcd},
	{0x5a50, 0xcd},
	{0x5a51, 0xcd},
	{0x5a52, 0xcd},
	{0x5a53, 0xcd},
	{0x5a54, 0xcd},
	{0x5a55, 0xcd},
	{0x5a56, 0xcd},
	{0x5a57, 0xcd},
	{0x5a58, 0xcd},
	{0x5a59, 0xcd},
	{0x5a5a, 0xcd},
	{0x5a5b, 0xcd},
	{0x5a5c, 0xcd},
	{0x5a5d, 0xcd},
	{0x5a5e, 0xcd},
	{0x5a5f, 0xcd},
	{0x5a60, 0xcd},
	{0x5a61, 0xcd},
	{0x5a62, 0xcd},
	{0x5a63, 0xcd},
	{0x5a64, 0xcd},
	{0x5a65, 0xcd},
	{0x5a66, 0xcd},
	{0x5a67, 0xcd},
	{0x5a68, 0xcd},
	{0x5a69, 0xcd},
	{0x5a6a, 0xcd},
	{0x5a6b, 0xcd},
	{0x5a6c, 0xcd},
	{0x5a6d, 0xcd},
	{0x5a6e, 0xcd},
	{0x5a6f, 0xcd},
	{0x5a70, 0xcd},
	{0x5a71, 0xcd},
	{0x5a72, 0xcd},
	{0x5a73, 0xcd},
	{0x5a74, 0xcd},
	{0x5a75, 0xcd},
	{0x5a76, 0xcd},
	{0x5a77, 0xcd},
	{0x5a78, 0xcd},
	{0x5a79, 0xcd},
	{0x5a7a, 0xcd},
	{0x5a7b, 0xcd},
	{0x5a7c, 0xcd},
	{0x5a7d, 0xcd},
	{0x5a7e, 0xcd},
	{0x5a7f, 0xcd},
	{0x5a80, 0xcd},
	{0x5a81, 0xcd},
	{0x5a82, 0xcd},
	{0x5a83, 0xcd},
	{0x5a84, 0xcd},
	{0x5a85, 0xcd},
	{0x5a86, 0xcd},
	{0x5a87, 0xcd},
	{0x5a88, 0xcd},
	{0x5a89, 0xcd},
	{0x5a8a, 0xcd},
	{0x5a8b, 0xcd},
	{0x5a8c, 0xcd},
	{0x5a8d, 0xcd},
	{0x5a8e, 0xcd},
	{0x5a8f, 0xcd},
	{0x5a90, 0xcd},
	{0x5a91, 0xcd},
	{0x5a92, 0xcd},
	{0x5a93, 0xcd},
	{0x5a94, 0xcd},
	{0x5a95, 0xcd},
	{0x5a96, 0xcd},
	{0x5a97, 0xcd},
	{0x5a98, 0xcd},
	{0x5a99, 0xcd},
	{0x5a9a, 0xcd},
	{0x5a9b, 0xcd},
	{0x5a9c, 0xcd},//0x04
	{0x5a9d, 0xcd},
	{0x5a9e, 0xcd},
	{0x5a9f, 0xcd},
	{0x5aa0, 0xcd},
	{0x5aa1, 0xcd},
	{0x5aa2, 0xcd},
	{0x5aa3, 0xcd},
	{0x5aa4, 0xcd},
	{0x5aa5, 0xcd},
	{0x5aa6, 0xcd},
	{0x5aa7, 0xcd},
	{0x5aa8, 0xcd},
	{0x5aa9, 0xcd},
	{0x5aaa, 0xcd},
	{0x5aab, 0xcd},
	{0x5aac, 0xcd},
	{0x5aad, 0xcd},
	{0x5aae, 0xcd},
	{0x5aaf, 0xcd},
	{0x5ab0, 0xcd},
	{0x5ab1, 0xcd},
	{0x5ab2, 0xcd},
	{0x5ab3, 0xcd},
	{0x5ab4, 0xcd},
	{0x5ab5, 0xcd},
	{0x5ab6, 0xcd},
	{0x5ab7, 0xcd},
	{0x5ab8, 0xcd},
	{0x5ab9, 0xcd},
	{0x5aba, 0xcd},
	{0x5abb, 0xcd},
	{0x5abc, 0xcd},
	{0x5abd, 0xcd},
	{0x5abe, 0xcd},
	{0x5abf, 0xcd},
	{0x5ac0, 0xcd},
	{0x5ac1, 0xcd},
	{0x5ac2, 0xcd},
	{0x5ac3, 0xcd},
	{0x5ac4, 0xcd},
	{0x5ac5, 0xcd},
	{0x5ac6, 0xcd},
	{0x5ac7, 0xcd},
	{0x5ac8, 0xcd},
	{0x5ac9, 0xcd},
	{0x5aca, 0xcd},
	{0x5acb, 0xcd},
	{0x5acc, 0xcd},
	{0x5acd, 0xcd},
	{0x5ace, 0xcd},
	{0x5acf, 0xcd},
	{0x5ad0, 0xcd},
	{0x5ad1, 0xcd},
	{0x5ad2, 0xcd},
	{0x5ad3, 0xcd},
	{0x5ad4, 0xcd},
	{0x5ad5, 0xcd},
	{0x5ad6, 0xcd},
	{0x5ad7, 0xcd},
	{0x5ad8, 0xcd},
	{0x5ad9, 0xcd},
	{0x5ada, 0xcd},
	{0x5adb, 0xcd},
	{0x5adc, 0xcd},
	{0x5add, 0xcd},
	{0x5ade, 0xcd},
	{0x5adf, 0xcd},
	{0x5ae0, 0xcd},
	{0x5ae1, 0xcd},
	{0x5ae2, 0xcd},
	{0x5ae3, 0xcd},
	{0x5ae4, 0xcd},
	{0x5ae5, 0xcd},
	{0x5ae6, 0xcd},
	{0x5ae7, 0xcd},
	{0x5ae8, 0xcd},
	{0x5ae9, 0xcd},
	{0x5aea, 0xcd},
	{0x5aeb, 0xcd},
	{0x5aec, 0xcd},
	{0x5aed, 0xcd},
	{0x5aee, 0xcd},
	{0x5aef, 0xcd},
	{0x5af0, 0xcd},
	{0x5af1, 0xcd},
	{0x5af2, 0xcd},
	{0x5af3, 0xcd},
	{0x5af4, 0xcd},
	{0x5af5, 0xcd},
	{0x5af6, 0xcd},
	{0x5af7, 0xcd},
	{0x5af8, 0xcd},
	{0x5af9, 0xcd},
	{0x5afa, 0xcd},
	{0x5afb, 0xcd},
	{0x5afc, 0xcd},
	{0x5afd, 0xcd},
	{0x5afe, 0xcd},
	{0x5aff, 0xcd},
	{0x5b00, 0xcd},
	{0x5b01, 0xcd},
	{0x5b02, 0xcd},
	{0x5b03, 0xcd},
	{0x5b04, 0xcd},
	{0x5b05, 0xcd},
	{0x5b06, 0xcd},
	{0x5b07, 0xcd},
	{0x5b08, 0xcd},
	{0x5b09, 0xcd},
	{0x5b0a, 0xcd},
	{0x5b0b, 0xcd},
	{0x5b0c, 0xcd},
	{0x5b0d, 0xcd},
	{0x5b0e, 0xcd},
	{0x5b0f, 0xcd},
	{0x5b10, 0xcd},
	{0x5b11, 0xcd},
	{0x5b12, 0xcd},
	{0x5b13, 0xcd},
	{0x5b14, 0xcd},
	{0x5b15, 0xcd},
	{0x5b16, 0xcd},
	{0x5b17, 0xcd},
	{0x5b18, 0xcd},
	{0x5b19, 0xcd},
	{0x5b1a, 0xcd},
	{0x5b1b, 0xcd},
	{0x5b1c, 0xcd},
	{0x5b1d, 0xcd},
	{0x5b1e, 0xcd},
	{0x5b1f, 0xcd},
	{0x5b20, 0xcd},
	{0x5b21, 0xcd},
	{0x5b22, 0xcd},
	{0x5b23, 0xcd},
	{0x5b24, 0xcd},
	{0x5b25, 0xcd},
	{0x5b26, 0xcd},
	{0x5b27, 0xcd},
	{0x5b28, 0xcd},
	{0x5b29, 0xcd},
	{0x5b2a, 0xcd},
	{0x5b2b, 0xcd},
	{0x5b2c, 0xcd},
	{0x5b2d, 0xcd},
	{0x5b2e, 0xcd},
	{0x5b2f, 0xcd},
	{0x5b30, 0xcd},
	{0x5b31, 0xcd},
	{0x5b32, 0xcd},
	{0x5b33, 0xcd},
	{0x5b34, 0xcd},
	{0x5b35, 0xcd},
	{0x5b36, 0xcd},
	{0x5b37, 0xcd},
	{0x5b38, 0xcd},
	{0x5b39, 0xcd},
	{0x5b3a, 0xcd},
	{0x5b3b, 0xcd},
	{0x5b3c, 0xcd},
	{0x5b3d, 0xcd},
	{0x5b3e, 0xcd},
	{0x5b3f, 0xcd},
	{0x5b40, 0xcd},
	{0x5b41, 0xcd},
	{0x5b42, 0xcd},
	{0x5b43, 0xcd},
	{0x5b44, 0xcd},
	{0x5b45, 0xcd},
	{0x5b46, 0xcd},
	{0x5b47, 0xcd},
	{0x5b48, 0xcd},
	{0x5b49, 0xcd},
	{0x5b4a, 0xcd},
	{0x5b4b, 0xcd},
	{0x5b4c, 0xcd},
	{0x5b4d, 0xcd},
	{0x5b4e, 0xcd},
	{0x5b4f, 0xcd},
	{0x5b50, 0xcd},
	{0x5b51, 0xcd},
	{0x5b52, 0xcd},
	{0x5b53, 0xcd},
	{0x5b54, 0xcd},
	{0x5b55, 0xcd},
	{0x5b56, 0xcd},
	{0x5b57, 0xcd},
	{0x5b58, 0xcd},
	{0x5b59, 0xcd},
	{0x5b5a, 0xcd},
	{0x5b5b, 0xcd},
	{0x5b5c, 0xcd},
	{0x5b5d, 0xcd},
	{0x5b5e, 0xcd},
	{0x5b5f, 0xcd},
	{0x5b60, 0xcd},
	{0x5b61, 0xcd},
	{0x5b62, 0xcd},
	{0x5b63, 0xcd},
	{0x5b64, 0xcd},
	{0x5b65, 0xcd},
	{0x5b66, 0xcd},
	{0x5b67, 0xcd},
	{0x5b68, 0xcd},
	{0x5b69, 0xcd},
	{0x5b6a, 0xcd},
	{0x5b6b, 0xcd},
	{0x5b6c, 0xcd},
	{0x5b6d, 0xcd},
	{0x5b6e, 0xcd},
	{0x5b6f, 0xcd},
	{0x5b70, 0xcd},
	{0x5b71, 0xcd},
	{0x5b72, 0xcd},
	{0x5b73, 0xcd},
	{0x5b74, 0xcd},
	{0x5b75, 0xcd},
	{0x5b76, 0xcd},
	{0x5b77, 0xcd},
	{0x5b78, 0xcd},
	{0x5b79, 0xcd},
	{0x5b7a, 0xcd},
	{0x5b7b, 0xcd},
	{0x5b7c, 0xcd},
	{0x5b7d, 0xcd},
	{0x5b7e, 0xcd},
	{0x5b7f, 0xcd},
	{0x5b80, 0xcd},
	{0x5b81, 0xcd},
	{0x5b82, 0xcd},
	{0x5b83, 0xcd},
	{0x5b84, 0xcd},
	{0x5b85, 0xcd},
	{0x5b86, 0xcd},
	{0x5b87, 0xcd},
	{0x5b88, 0xcd},
	{0x5b89, 0xcd},
	{0x5b8a, 0xcd},
	{0x5b8b, 0xcd},
	{0x5b8c, 0xcd},
	{0x5b8d, 0xcd},
	{0x5b8e, 0xcd},
	{0x5b8f, 0xcd},
	{0x5b90, 0xcd},
	{0x5b91, 0xcd},
	{0x5b92, 0xcd},
	{0x5b93, 0xcd},
	{0x5b94, 0xcd},
	{0x5b95, 0xcd},
	{0x5b96, 0xcd},
	{0x5b97, 0xcd},
	{0x5b98, 0xcd},
	{0x5b99, 0xcd},
	{0x5b9a, 0xcd},
	{0x5b9b, 0xcd},
	{0x5b9c, 0xcd},
	{0x5b9d, 0xcd},
	{0x5b9e, 0xcd},
	{0x5b9f, 0xcd},
	{0x5ba0, 0xcd},
	{0x5ba1, 0xcd},
	{0x5ba2, 0xcd},
	{0x5ba3, 0xcd},
	{0x5ba4, 0xcd},
	{0x5ba5, 0xcd},
	{0x5ba6, 0xcd},
	{0x5ba7, 0xcd},
	{0x5ba8, 0xcd},
	{0x5ba9, 0xcd},
	{0x5baa, 0xcd},
	{0x5bab, 0xcd},
	{0x5bac, 0xcd},
	{0x5bad, 0xcd},
	{0x5bae, 0xcd},
	{0x5baf, 0xcd},
	{0x5bb0, 0xcd},
	{0x5bb1, 0xcd},
	{0x5bb2, 0xcd},
	{0x5bb3, 0xcd},
	{0x5bb4, 0xcd},
	{0x5bb5, 0xcd},
	{0x5bb6, 0xcd},
	{0x5bb7, 0xcd},
	{0x5bb8, 0xcd},
	{0x5bb9, 0xcd},
	{0x5bba, 0xcd},
	{0x5bbb, 0xcd},
	{0x5bbc, 0xcd},
	{0x5bbd, 0xcd},
	{0x5bbe, 0xcd},
	{0x5bbf, 0xcd},
	{0x5bc0, 0xcd},
	{0x5bc1, 0xcd},
	{0x5bc2, 0xcd},
	{0x5bc3, 0xcd},
	{0x5bc4, 0xcd},
	{0x5bc5, 0xcd},
	{0x5bc6, 0xcd},
	{0x5bc7, 0xcd},
	{0x5bc8, 0xcd},
	{0x5bc9, 0xcd},
	{0x5bca, 0xcd},
	{0x5bcb, 0xcd},
	{0x5bcc, 0xcd},
	{0x5bcd, 0xcd},
	{0x5bce, 0xcd},
	{0x5bcf, 0xcd},
	{0x0301, 0xc8},
	{0x0304, 0x02},
	{0x0305, 0x71},
	{0x0306, 0x04},
	{0x0324, 0x02},
	{0x0325, 0x58},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x032a, 0x0a},
	{0x0344, 0x01},
	{0x0345, 0x4a},
	{0x0350, 0x00},
	{0x0360, 0x09},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x41},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x10},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x03},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x11},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0xb5},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x00},
	{0x3608, 0xb2},
	{0x360c, 0x0b},
	{0x360e, 0x1e},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x00},
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3697, 0x80},
	{0x3699, 0x1f},
	{0x369b, 0x80},
	{0x369c, 0x13},
	{0x369d, 0x00},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x26},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x69},
	{0x370b, 0x56},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x01},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x2a},
	{0x373d, 0x2e},
	{0x3741, 0x3c},
	{0x3754, 0xee},
	{0x375f, 0x00},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x32},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x36},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x10},
	{0x3809, 0x00},
	{0x380a, 0x0c},
	{0x380b, 0x00},
	{0x380c, 0x03},
	{0x380d, 0xe8},
	{0x380e, 0x0d},
	{0x380f, 0x05},
	{0x3810, 0x00},
	{0x3811, 0x08},
	{0x3812, 0x00},
	{0x3813, 0x04},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x14},
	{0x3822, 0x00},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x81},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x08},
	{0x3845, 0x01},
	{0x3846, 0xf4},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x10},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x02},
	{0x3903, 0x00},
	{0x3905, 0x28},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x00},
	{0x399c, 0x00},
	{0x39aa, 0x55},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x26},
	{0x39bc, 0x26},
	{0x39be, 0x26},
	{0x39c0, 0x26},
	{0x39c2, 0x56},
	{0x39c4, 0x56},
	{0x39c6, 0x56},
	{0x39c8, 0x56},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d86, 0x00},
	{0x3d87, 0x12},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f01, 0x13},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x38},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x01},
	{0x401f, 0x00},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x02},
	{0x4032, 0x00},
	{0x4033, 0x02},
	{0x4034, 0x00},
	{0x4035, 0x02},
	{0x4036, 0x00},
	{0x4037, 0x02},
	{0x4040, 0x00},
	{0x4041, 0x00},
	{0x4042, 0x00},
	{0x4043, 0x00},
	{0x4044, 0x00},
	{0x4045, 0x00},
	{0x4046, 0x00},
	{0x4047, 0x00},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x00},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x00},
	{0x4517, 0x00},
	{0x4518, 0x00},
	{0x4519, 0x00},
	{0x451a, 0x00},
	{0x451b, 0x00},
	{0x451c, 0x00},
	{0x451d, 0x00},
	{0x451e, 0x00},
	{0x451f, 0x00},
	{0x4520, 0x00},
	{0x4521, 0x00},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x1f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4648, 0x0a},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0c},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0c},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0c},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x44},
	{0x4721, 0x42},
	{0x4723, 0x00},
	{0x4724, 0x03},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x03},
	{0x4731, 0x0d},
	{0x4732, 0x0d},
	{0x4733, 0x0f},
	{0x4734, 0x0f},
	{0x4735, 0x0c},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0f},
	{0x4739, 0x0f},
	{0x473a, 0x0c},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0d},
	{0x473e, 0x0f},
	{0x473f, 0x0f},
	{0x4740, 0x0c},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x64},
	{0x4802, 0x00},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x00},
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x3c},
	{0x481f, 0x32},
	{0x4837, 0x06},
	{0x484b, 0x27},
	{0x4850, 0x43},
	{0x4851, 0xaa},
	{0x4853, 0x4a},
	{0x4854, 0x06},
	{0x4860, 0x00},
	{0x4861, 0xec},
	{0x4862, 0x04},
	{0x4883, 0x00},
	{0x4888, 0x10},
	{0x4d00, 0x05},
	{0x4d01, 0x0e},
	{0x4d02, 0xb7},
	{0x4d03, 0x39},
	{0x4d04, 0xcd},
	{0x4d05, 0x4e},
	{0x5000, 0x89},
	{0x5001, 0x03},
	{0x5002, 0x8d},
	{0x5003, 0xfa},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x504c, 0x12},
	{0x504d, 0x12},
	{0x504e, 0x12},
	{0x504f, 0x12},
	{0x5050, 0x12},
	{0x5051, 0x14},
	{0x5055, 0x12},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x61},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x01},
	{0x5c45, 0x02},
	{0x5c46, 0x03},
	{0x5c47, 0x04},
	{0x5c48, 0x05},
	{0x5c49, 0x06},
	{0x5c4a, 0x07},
	{0x5c4b, 0x08},
	{0x5c4c, 0x09},
	{0x5c4d, 0x0a},
	{0x5c4e, 0x0b},
	{0x5c4f, 0x0c},
	{0x5c50, 0x0d},
	{0x5c51, 0x0e},
	{0x5c52, 0x0f},
	{0x5c53, 0x10},
	{0x5c54, 0x08},
	{0x5c55, 0x08},
	{0x5c56, 0x02},
	{0x5c57, 0x02},
	{0x5c58, 0x06},
	{0x5c59, 0x06},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x00},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};
#endif

static const struct regval ov50c40_10bit_4096x3072_dphy_30fps_regs[] = {
	{0x0103, 0x01},
	{0x0301, 0xc8},
	{0x0304, 0x02},
	{0x0305, 0x71},
	{0x0306, 0x04},
	{0x0324, 0x02},
	{0x0325, 0x58},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x032a, 0x0a},
	{0x0344, 0x01},
	{0x0345, 0x4a},
	{0x0350, 0x00},
	{0x0360, 0x09},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x41},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x10},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x03},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x11},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0x16},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x01},
	{0x3608, 0xda},
	{0x360c, 0x03},
	{0x360e, 0x1d},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x03},//0x03
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3697, 0x80},
	{0x3699, 0x1f},
	{0x369b, 0x10},
	{0x369c, 0x19},
	{0x369d, 0x40},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x2f},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x69},
	{0x370b, 0x5d},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x03},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x3c},
	{0x373d, 0x40},
	{0x3741, 0x41},
	{0x3754, 0xee},
	{0x375f, 0x80},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x37},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x3b},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x10},
	{0x3809, 0x00},
	{0x380a, 0x0c},
	{0x380b, 0x00},
	{0x380c, 0x04},
	{0x380d, 0x1a},
	{0x380e, 0x0c},
	{0x380f, 0x66},
	{0x3810, 0x00},
	{0x3811, 0x08},
	{0x3812, 0x00},
	{0x3813, 0x04},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x06},
	{0x3822, 0x10},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x81},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x08},
	{0x3845, 0x04},
	{0x3846, 0x1a},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x20},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x01},
	{0x3903, 0x08},
	{0x3905, 0x05},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x02},
	{0x399c, 0x03},
	{0x39aa, 0x05},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x2f},
	{0x39bc, 0x2f},
	{0x39be, 0x2f},
	{0x39c0, 0x2f},
	{0x39c2, 0x5d},
	{0x39c4, 0x5d},
	{0x39c6, 0x5d},
	{0x39c8, 0x5d},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d86, 0x00},
	{0x3d87, 0x12},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f01, 0x13},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x38},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x00},
	{0x401f, 0xd0},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x00},
	{0x4032, 0x00},
	{0x4033, 0x04},
	{0x4034, 0x00},
	{0x4035, 0x04},
	{0x4036, 0x00},
	{0x4037, 0x04},
	{0x4040, 0x00},
	{0x4041, 0x00},
	{0x4042, 0x00},
	{0x4043, 0x00},
	{0x4044, 0x00},
	{0x4045, 0x00},
	{0x4046, 0x00},
	{0x4047, 0x00},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x07},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x55},
	{0x4517, 0x55},
	{0x4518, 0x55},
	{0x4519, 0x55},
	{0x451a, 0x11},
	{0x451b, 0xbb},
	{0x451c, 0x11},
	{0x451d, 0xbb},
	{0x451e, 0x11},
	{0x451f, 0xbb},
	{0x4520, 0x11},
	{0x4521, 0xbb},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x7f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4648, 0x0a},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0c},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0c},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0c},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x00},
	{0x4721, 0x00},
	{0x4723, 0x00},
	{0x4724, 0x00},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x00},
	{0x4731, 0x0d},
	{0x4732, 0x0d},
	{0x4733, 0x0f},
	{0x4734, 0x0f},
	{0x4735, 0x0c},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0f},
	{0x4739, 0x0f},
	{0x473a, 0x0c},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0d},
	{0x473e, 0x0f},
	{0x473f, 0x0f},
	{0x4740, 0x0c},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x64},
	{0x4802, 0x00},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x04},//0x04
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x3c},
	{0x481f, 0x32},
	{0x4837, 0x06},
	{0x484b, 0x27},
	{0x4850, 0x43},
	{0x4851, 0xaa},
	{0x4853, 0x4a},
	{0x4854, 0x06},
	{0x4860, 0x00},
	{0x4861, 0xec},
	{0x4862, 0x04},
	{0x4883, 0x00},
	{0x4888, 0x10},
	{0x4d00, 0x05},
	{0x4d01, 0x0e},
	{0x4d02, 0xb7},
	{0x4d03, 0x39},
	{0x4d04, 0xcd},
	{0x4d05, 0x4e},
	{0x5000, 0x8b},
	{0x5001, 0x23},
	{0x5002, 0x9d},
	{0x5003, 0xca},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x504c, 0x12},
	{0x504d, 0x12},
	{0x504e, 0x12},
	{0x504f, 0x12},
	{0x5050, 0x12},
	{0x5051, 0x14},
	{0x5055, 0x12},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x63},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x02},
	{0x5c45, 0x0a},
	{0x5c46, 0x00},
	{0x5c47, 0x07},
	{0x5c48, 0x0f},
	{0x5c49, 0x01},
	{0x5c4a, 0x00},
	{0x5c4b, 0x09},
	{0x5c4c, 0x06},
	{0x5c4d, 0x0e},
	{0x5c4e, 0x00},
	{0x5c4f, 0x00},
	{0x5c50, 0x00},
	{0x5c51, 0x00},
	{0x5c52, 0x00},
	{0x5c53, 0x00},
	{0x5c54, 0x10},
	{0x5c55, 0x08},
	{0x5c56, 0x04},
	{0x5c57, 0x04},
	{0x5c58, 0x0c},
	{0x5c59, 0x0c},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x01},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};

static const struct regval ov50c40_10bit_8192x6144_dphy_12fps_regs[] = {
	{0x0103, 0x01},
	{0x0301, 0xc8},
	{0x0304, 0x02},
	{0x0305, 0x71},
	{0x0306, 0x04},
	{0x0324, 0x02},
	{0x0325, 0x58},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x032a, 0x0a},
	{0x0344, 0x01},
	{0x0345, 0x4a},
	{0x0350, 0x00},
	{0x0360, 0x09},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x41},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x10},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x03},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x11},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0x73},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x01},
	{0x3608, 0xda},
	{0x360c, 0x03},
	{0x360e, 0x1d},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x03},
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3697, 0x80},
	{0x3699, 0x1f},
	{0x369b, 0x10},
	{0x369c, 0x19},
	{0x369d, 0x40},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x2f},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x60},
	{0x370b, 0x5d},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x03},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x3c},
	{0x373d, 0x40},
	{0x3741, 0x41},
	{0x3754, 0xee},
	{0x375f, 0x80},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x37},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x3b},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x20},
	{0x3809, 0x00},
	{0x380a, 0x18},
	{0x380b, 0x00},
	{0x380c, 0x09},
	{0x380d, 0xf6},
	{0x380e, 0x0c},
	{0x380f, 0xc3},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x08},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x06},
	{0x3822, 0x12},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x81},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x10},
	{0x3845, 0x09},
	{0x3846, 0xf6},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x20},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x01},
	{0x3903, 0x08},
	{0x3905, 0x05},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x02},
	{0x399c, 0x03},
	{0x39aa, 0x05},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x2f},
	{0x39bc, 0x2f},
	{0x39be, 0x2f},
	{0x39c0, 0x2f},
	{0x39c2, 0x5d},
	{0x39c4, 0x5d},
	{0x39c6, 0x5d},
	{0x39c8, 0x5d},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d86, 0x00},
	{0x3d87, 0x12},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f01, 0x13},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x28},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x00},
	{0x401f, 0xd0},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x10},
	{0x4032, 0x00},
	{0x4033, 0x10},
	{0x4034, 0x08},
	{0x4035, 0x10},
	{0x4036, 0x08},
	{0x4037, 0x10},
	{0x4040, 0x08},
	{0x4041, 0x10},
	{0x4042, 0x08},
	{0x4043, 0x10},
	{0x4044, 0x00},
	{0x4045, 0x10},
	{0x4046, 0x00},
	{0x4047, 0x10},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x07},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x55},
	{0x4517, 0x55},
	{0x4518, 0x55},
	{0x4519, 0x55},
	{0x451a, 0x11},
	{0x451b, 0xbb},
	{0x451c, 0x11},
	{0x451d, 0xbb},
	{0x451e, 0x11},
	{0x451f, 0xbb},
	{0x4520, 0x11},
	{0x4521, 0xbb},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x7f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4648, 0x0a},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0c},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0c},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0c},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x00},
	{0x4721, 0x00},
	{0x4723, 0x00},
	{0x4724, 0x00},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x00},
	{0x4731, 0x0d},
	{0x4732, 0x0d},
	{0x4733, 0x0f},
	{0x4734, 0x0f},
	{0x4735, 0x0c},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0f},
	{0x4739, 0x0f},
	{0x473a, 0x0c},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0d},
	{0x473e, 0x0f},
	{0x473f, 0x0f},
	{0x4740, 0x0c},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x64},
	{0x4802, 0x00},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x04},
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x3c},
	{0x481f, 0x32},
	{0x4837, 0x06},
	{0x484b, 0x27},
	{0x4850, 0x43},
	{0x4851, 0xaa},
	{0x4853, 0x4a},
	{0x4854, 0x06},
	{0x4860, 0x00},
	{0x4861, 0xec},
	{0x4862, 0x04},
	{0x4883, 0x00},
	{0x4888, 0x10},
	{0x4d00, 0x05},
	{0x4d01, 0x0e},
	{0x4d02, 0xb7},
	{0x4d03, 0x39},
	{0x4d04, 0xcd},
	{0x4d05, 0x4e},
	{0x5000, 0x8b},
	{0x5001, 0x63},
	{0x5002, 0x9d},
	{0x5003, 0xca},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x504c, 0x12},
	{0x504d, 0x12},
	{0x504e, 0x12},
	{0x504f, 0x12},
	{0x5050, 0x12},
	{0x5051, 0x14},
	{0x5055, 0x12},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x63},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x02},
	{0x5c45, 0x0a},
	{0x5c46, 0x00},
	{0x5c47, 0x07},
	{0x5c48, 0x0f},
	{0x5c49, 0x01},
	{0x5c4a, 0x00},
	{0x5c4b, 0x09},
	{0x5c4c, 0x06},
	{0x5c4d, 0x0e},
	{0x5c4e, 0x00},
	{0x5c4f, 0x00},
	{0x5c50, 0x00},
	{0x5c51, 0x00},
	{0x5c52, 0x00},
	{0x5c53, 0x00},
	{0x5c54, 0x10},
	{0x5c55, 0x08},
	{0x5c56, 0x04},
	{0x5c57, 0x04},
	{0x5c58, 0x0c},
	{0x5c59, 0x0c},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x01},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};

static const struct regval ov50c40_10bit_4096x3072_cphy_regs[] = {
	{0x0103, 0x01},
	{0x0301, 0xc0},
	{0x0304, 0x01},
	{0x0305, 0x64},
	{0x0306, 0x03},
	{0x0307, 0x01},
	{0x0324, 0x02},
	{0x0325, 0x58},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x032a, 0x0a},
	{0x0344, 0x01},
	{0x0345, 0x4a},
	{0x0350, 0x00},
	{0x0360, 0x01},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x31},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x00},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x02},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x00},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0x16},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x01},
	{0x3608, 0xda},
	{0x360c, 0x03},
	{0x360e, 0x1d},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x03},
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3699, 0x1f},
	{0x369b, 0x10},
	{0x369c, 0x19},
	{0x369d, 0x40},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x2f},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x60},
	{0x370b, 0x5d},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x03},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x3c},
	{0x373d, 0x40},
	{0x3754, 0xee},
	{0x375f, 0x80},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x32},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x36},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x10},
	{0x3809, 0x00},
	{0x380a, 0x0c},
	{0x380b, 0x00},
	{0x380c, 0x08},
	{0x380d, 0x34},
	{0x380e, 0x0c},
	{0x380f, 0x66},
	{0x3810, 0x00},
	{0x3811, 0x08},
	{0x3812, 0x00},
	{0x3813, 0x04},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x06},
	{0x3822, 0x10},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x83},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x08},
	{0x3845, 0x04},
	{0x3846, 0x1a},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x20},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x01},
	{0x3903, 0x08},
	{0x3905, 0x05},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x02},
	{0x399c, 0x03},
	{0x39aa, 0x05},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x2f},
	{0x39bc, 0x2f},
	{0x39be, 0x2f},
	{0x39c0, 0x2f},
	{0x39c2, 0x5d},
	{0x39c4, 0x5d},
	{0x39c6, 0x5d},
	{0x39c8, 0x5d},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x38},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x00},
	{0x401f, 0xd0},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x00},
	{0x4032, 0x00},
	{0x4033, 0x04},
	{0x4034, 0x00},
	{0x4035, 0x04},
	{0x4036, 0x00},
	{0x4037, 0x04},
	{0x4040, 0x00},
	{0x4041, 0x00},
	{0x4042, 0x00},
	{0x4043, 0x00},
	{0x4044, 0x00},
	{0x4045, 0x00},
	{0x4046, 0x00},
	{0x4047, 0x00},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x07},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x55},
	{0x4517, 0x55},
	{0x4518, 0x55},
	{0x4519, 0x55},
	{0x451a, 0x11},
	{0x451b, 0xbb},
	{0x451c, 0x11},
	{0x451d, 0xbb},
	{0x451e, 0x11},
	{0x451f, 0xbb},
	{0x4520, 0x11},
	{0x4521, 0xbb},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x7f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0a},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0a},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0a},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x00},
	{0x4721, 0x00},
	{0x4723, 0x00},
	{0x4724, 0x00},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x00},
	{0x4731, 0x0f},
	{0x4732, 0x0f},
	{0x4733, 0x0a},
	{0x4734, 0x0a},
	{0x4735, 0x07},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0a},
	{0x4739, 0x0a},
	{0x473a, 0x07},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0f},
	{0x473e, 0x0a},
	{0x473f, 0x0a},
	{0x4740, 0x07},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x04},
	{0x4802, 0x02},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x04},
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x35},
	{0x4837, 0x13},
	{0x484b, 0x27},
	{0x4850, 0x42},
	{0x4851, 0xaa},
	{0x4854, 0x05},
	{0x4860, 0x01},
	{0x4861, 0xef},
	{0x4862, 0x29},
	{0x4883, 0x24},
	{0x4888, 0x00},
	{0x4d00, 0x04},
	{0x4d01, 0xf7},
	{0x4d02, 0xb8},
	{0x4d03, 0x78},
	{0x4d04, 0x6d},
	{0x4d05, 0x36},
	{0x5000, 0x8b},
	{0x5001, 0x23},
	{0x5002, 0x9d},
	{0x5003, 0xca},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x5051, 0x14},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x63},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x02},
	{0x5c45, 0x0a},
	{0x5c46, 0x00},
	{0x5c47, 0x07},
	{0x5c48, 0x0f},
	{0x5c49, 0x01},
	{0x5c4a, 0x00},
	{0x5c4b, 0x09},
	{0x5c4c, 0x06},
	{0x5c4d, 0x0e},
	{0x5c4e, 0x00},
	{0x5c4f, 0x00},
	{0x5c50, 0x00},
	{0x5c51, 0x00},
	{0x5c52, 0x00},
	{0x5c53, 0x00},
	{0x5c54, 0x10},
	{0x5c55, 0x08},
	{0x5c56, 0x04},
	{0x5c57, 0x04},
	{0x5c58, 0x0c},
	{0x5c59, 0x0c},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x01},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};

static const struct regval ov50c40_10bit_4096x3072_cphy_30fps_regs[] = {
	{0x0103, 0x01},
	{0x0301, 0xc0},
	{0x0304, 0x01},
	{0x0305, 0x77},
	{0x0306, 0x03},
	{0x0324, 0x02},
	{0x0325, 0x58},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x032a, 0x0a},
	{0x0344, 0x01},
	{0x0345, 0x4a},
	{0x0350, 0x00},
	{0x0360, 0x01},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x31},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x10},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x03},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x11},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0x16},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x01},
	{0x3608, 0xda},
	{0x360c, 0x03},
	{0x360e, 0x1d},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x03},
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3697, 0x80},
	{0x3699, 0x1f},
	{0x369b, 0x10},
	{0x369c, 0x19},
	{0x369d, 0x40},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x2f},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x69},
	{0x370b, 0x5d},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x03},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x3c},
	{0x373d, 0x40},
	{0x3741, 0x41},
	{0x3754, 0xee},
	{0x375f, 0x80},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x37},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x3b},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x10},
	{0x3809, 0x00},
	{0x380a, 0x0c},
	{0x380b, 0x00},
	{0x380c, 0x04},
	{0x380d, 0x1a},
	{0x380e, 0x0c},
	{0x380f, 0x66},
	{0x3810, 0x00},
	{0x3811, 0x08},
	{0x3812, 0x00},
	{0x3813, 0x04},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x06},
	{0x3822, 0x10},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x81},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x08},
	{0x3845, 0x04},
	{0x3846, 0x1a},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x20},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x01},
	{0x3903, 0x08},
	{0x3905, 0x05},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x02},
	{0x399c, 0x03},
	{0x39aa, 0x05},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x2f},
	{0x39bc, 0x2f},
	{0x39be, 0x2f},
	{0x39c0, 0x2f},
	{0x39c2, 0x5d},
	{0x39c4, 0x5d},
	{0x39c6, 0x5d},
	{0x39c8, 0x5d},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d86, 0x00},
	{0x3d87, 0x12},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f01, 0x13},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x38},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x00},
	{0x401f, 0xd0},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x00},
	{0x4032, 0x00},
	{0x4033, 0x04},
	{0x4034, 0x00},
	{0x4035, 0x04},
	{0x4036, 0x00},
	{0x4037, 0x04},
	{0x4040, 0x00},
	{0x4041, 0x00},
	{0x4042, 0x00},
	{0x4043, 0x00},
	{0x4044, 0x00},
	{0x4045, 0x00},
	{0x4046, 0x00},
	{0x4047, 0x00},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x07},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x55},
	{0x4517, 0x55},
	{0x4518, 0x55},
	{0x4519, 0x55},
	{0x451a, 0x11},
	{0x451b, 0xbb},
	{0x451c, 0x11},
	{0x451d, 0xbb},
	{0x451e, 0x11},
	{0x451f, 0xbb},
	{0x4520, 0x11},
	{0x4521, 0xbb},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x7f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4648, 0x0a},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0c},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0c},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0c},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x00},
	{0x4721, 0x00},
	{0x4723, 0x00},
	{0x4724, 0x00},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x00},
	{0x4731, 0x0d},
	{0x4732, 0x0d},
	{0x4733, 0x0f},
	{0x4734, 0x0f},
	{0x4735, 0x0c},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0f},
	{0x4739, 0x0f},
	{0x473a, 0x0c},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0d},
	{0x473e, 0x0f},
	{0x473f, 0x0f},
	{0x4740, 0x0c},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x64},
	{0x4802, 0x02},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x04},
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x18},//90ns
	{0x481f, 0x32},
	{0x4837, 0x09},
	{0x484b, 0x27},
	{0x4850, 0x42},
	{0x4851, 0xaa},
	{0x4853, 0x4a},
	{0x4854, 0x05},
	{0x4860, 0x01},
	{0x4861, 0xef},
	{0x4862, 0x20},
	{0x4883, 0x24},
	{0x4888, 0x00},
	{0x4d00, 0x05},
	{0x4d01, 0x0e},
	{0x4d02, 0xb7},
	{0x4d03, 0x39},
	{0x4d04, 0xcd},
	{0x4d05, 0x4e},
	{0x5000, 0x8b},
	{0x5001, 0x23},
	{0x5002, 0x9d},
	{0x5003, 0xca},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x504c, 0x12},
	{0x504d, 0x12},
	{0x504e, 0x12},
	{0x504f, 0x12},
	{0x5050, 0x12},
	{0x5051, 0x14},
	{0x5055, 0x12},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x63},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x02},
	{0x5c45, 0x0a},
	{0x5c46, 0x00},
	{0x5c47, 0x07},
	{0x5c48, 0x0f},
	{0x5c49, 0x01},
	{0x5c4a, 0x00},
	{0x5c4b, 0x09},
	{0x5c4c, 0x06},
	{0x5c4d, 0x0e},
	{0x5c4e, 0x00},
	{0x5c4f, 0x00},
	{0x5c50, 0x00},
	{0x5c51, 0x00},
	{0x5c52, 0x00},
	{0x5c53, 0x00},
	{0x5c54, 0x10},
	{0x5c55, 0x08},
	{0x5c56, 0x04},
	{0x5c57, 0x04},
	{0x5c58, 0x0c},
	{0x5c59, 0x0c},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x01},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};

static const struct regval ov50c40_10bit_8192x6144_cphy_12fps_regs[] = {
	{0x0103, 0x01},
	{0x0301, 0xc0},
	{0x0304, 0x01},
	{0x0305, 0x77},
	{0x0306, 0x03},
	{0x0324, 0x02},
	{0x0325, 0x58},
	{0x0326, 0xcb},
	{0x0327, 0x05},
	{0x0328, 0x07},
	{0x032a, 0x0a},
	{0x0344, 0x01},
	{0x0345, 0x4a},
	{0x0350, 0x00},
	{0x0360, 0x01},
	{0x3002, 0x00},
	{0x3009, 0x04},
	{0x3012, 0x31},
	{0x3019, 0xc2},
	{0x301c, 0x81},
	{0x3025, 0x03},
	{0x3026, 0x10},
	{0x3027, 0x00},
	{0x3107, 0x48},
	{0x3400, 0x0c},
	{0x3409, 0x03},
	{0x340c, 0x10},
	{0x340d, 0x00},
	{0x3420, 0x11},
	{0x3421, 0x08},
	{0x3423, 0x15},
	{0x3424, 0x40},
	{0x3425, 0x10},
	{0x3426, 0x40},
	{0x3500, 0x00},
	{0x3501, 0x0c},
	{0x3502, 0x73},
	{0x3504, 0x28},
	{0x3507, 0x00},
	{0x3508, 0x01},
	{0x3509, 0x00},
	{0x350a, 0x01},
	{0x350b, 0x00},
	{0x350c, 0x00},
	{0x350e, 0x00},
	{0x3540, 0x00},
	{0x3541, 0x00},
	{0x3542, 0x00},
	{0x3548, 0x01},
	{0x3549, 0x00},
	{0x354a, 0x01},
	{0x354b, 0x00},
	{0x354c, 0x00},
	{0x3607, 0x01},
	{0x3608, 0xda},
	{0x360c, 0x03},
	{0x360e, 0x1d},
	{0x3618, 0x80},
	{0x361b, 0x80},
	{0x3622, 0x88},
	{0x3623, 0x33},
	{0x3624, 0x95},
	{0x3627, 0xcc},
	{0x3628, 0xaa},
	{0x362b, 0x08},
	{0x362d, 0x08},
	{0x363b, 0x80},
	{0x363d, 0x0c},
	{0x3680, 0xc0},
	{0x3684, 0x03},
	{0x368d, 0x00},
	{0x368e, 0x01},
	{0x3690, 0x10},
	{0x3697, 0x80},
	{0x3699, 0x1f},
	{0x369b, 0x10},
	{0x369c, 0x19},
	{0x369d, 0x40},
	{0x369e, 0x00},
	{0x36a1, 0x00},
	{0x3700, 0x28},
	{0x3701, 0x05},
	{0x3702, 0x4b},
	{0x3703, 0x27},
	{0x3704, 0x07},
	{0x3706, 0x2f},
	{0x3707, 0x08},
	{0x3708, 0x32},
	{0x3709, 0x60},
	{0x370b, 0x5d},
	{0x370c, 0x0f},
	{0x3711, 0x00},
	{0x3712, 0x50},
	{0x3714, 0x67},
	{0x3715, 0x00},
	{0x3717, 0x03},
	{0x371c, 0x04},
	{0x371d, 0x1e},
	{0x371e, 0x13},
	{0x371f, 0x0a},
	{0x3720, 0x08},
	{0x3721, 0x15},
	{0x3725, 0x32},
	{0x3727, 0x22},
	{0x3729, 0x01},
	{0x3731, 0x05},
	{0x3736, 0x02},
	{0x3737, 0x05},
	{0x3738, 0x02},
	{0x3739, 0x05},
	{0x373b, 0x3c},
	{0x373d, 0x40},
	{0x3741, 0x41},
	{0x3754, 0xee},
	{0x375f, 0x80},
	{0x3760, 0x08},
	{0x3761, 0x10},
	{0x3762, 0x08},
	{0x3763, 0x08},
	{0x3764, 0x08},
	{0x3765, 0x10},
	{0x3766, 0x18},
	{0x3767, 0x28},
	{0x3768, 0x00},
	{0x3769, 0x08},
	{0x376c, 0x00},
	{0x376f, 0x02},
	{0x3770, 0x3b},
	{0x379e, 0x3b},
	{0x379f, 0x3b},
	{0x37b0, 0x37},
	{0x37b1, 0x37},
	{0x37b2, 0x37},
	{0x37b3, 0x3b},
	{0x37b4, 0x3a},
	{0x37b5, 0x3a},
	{0x37ce, 0x02},
	{0x37cf, 0x05},
	{0x37d6, 0x00},
	{0x37d9, 0x00},
	{0x37dc, 0x43},
	{0x37ed, 0x02},
	{0x37ee, 0x05},
	{0x37f0, 0x02},
	{0x37f1, 0x05},
	{0x37f2, 0x02},
	{0x37f3, 0x05},
	{0x37f4, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x08},
	{0x3804, 0x20},
	{0x3805, 0x1f},
	{0x3806, 0x18},
	{0x3807, 0x17},
	{0x3808, 0x20},
	{0x3809, 0x00},
	{0x380a, 0x18},
	{0x380b, 0x00},
	{0x380c, 0x09},
	{0x380d, 0xf6},
	{0x380e, 0x0c},
	{0x380f, 0xc3},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x08},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x381a, 0x00},
	{0x381b, 0x00},
	{0x381e, 0x00},
	{0x381f, 0x00},
	{0x3820, 0x02},
	{0x3821, 0x06},
	{0x3822, 0x12},
	{0x3824, 0x00},
	{0x3825, 0x00},
	{0x3826, 0x00},
	{0x3827, 0x00},
	{0x3828, 0x07},
	{0x382a, 0x81},
	{0x382c, 0x00},
	{0x382d, 0x00},
	{0x3835, 0x00},
	{0x3836, 0x00},
	{0x383c, 0x00},
	{0x383d, 0x10},
	{0x3845, 0x09},
	{0x3846, 0xf6},
	{0x3847, 0x00},
	{0x3848, 0x00},
	{0x3849, 0x00},
	{0x384b, 0x8e},
	{0x384f, 0x00},
	{0x3856, 0x20},
	{0x3857, 0x10},
	{0x3858, 0x40},
	{0x3859, 0x20},
	{0x3865, 0x00},
	{0x3869, 0x00},
	{0x3902, 0x01},
	{0x3903, 0x08},
	{0x3905, 0x05},
	{0x3906, 0x00},
	{0x3909, 0x00},
	{0x390c, 0x00},
	{0x390f, 0x00},
	{0x3912, 0x00},
	{0x3915, 0x04},
	{0x3918, 0x04},
	{0x391b, 0x00},
	{0x391d, 0x02},
	{0x391e, 0x00},
	{0x3924, 0x02},
	{0x3927, 0x02},
	{0x392a, 0x02},
	{0x392d, 0x02},
	{0x3930, 0x02},
	{0x3933, 0x02},
	{0x3936, 0x02},
	{0x3939, 0x02},
	{0x393c, 0x02},
	{0x393f, 0x02},
	{0x3942, 0x02},
	{0x3945, 0x02},
	{0x3980, 0x37},
	{0x3981, 0x3a},
	{0x3982, 0x0c},
	{0x3983, 0x3b},
	{0x3990, 0x01},
	{0x399b, 0x02},
	{0x399c, 0x03},
	{0x39aa, 0x05},
	{0x39b1, 0x05},
	{0x39b3, 0x78},
	{0x39b6, 0x40},
	{0x39b7, 0x10},
	{0x39ba, 0x2f},
	{0x39bc, 0x2f},
	{0x39be, 0x2f},
	{0x39c0, 0x2f},
	{0x39c2, 0x5d},
	{0x39c4, 0x5d},
	{0x39c6, 0x5d},
	{0x39c8, 0x5d},
	{0x39c9, 0x01},
	{0x39cf, 0x00},
	{0x39d2, 0x00},
	{0x3a01, 0x1e},
	{0x3a12, 0x00},
	{0x3a13, 0x00},
	{0x3a14, 0x00},
	{0x3a18, 0x04},
	{0x3a36, 0x20},
	{0x3d85, 0x0b},
	{0x3d86, 0x00},
	{0x3d87, 0x12},
	{0x3d8c, 0x73},
	{0x3d8d, 0xd8},
	{0x3daa, 0x00},
	{0x3dab, 0x00},
	{0x3dac, 0x00},
	{0x3dad, 0x00},
	{0x3dae, 0x00},
	{0x3daf, 0x00},
	{0x3f01, 0x13},
	{0x3f9e, 0x03},
	{0x3f9f, 0x04},
	{0x4009, 0x01},
	{0x4010, 0x28},
	{0x4011, 0x01},
	{0x4012, 0x0d},
	{0x4015, 0x00},
	{0x4016, 0x0f},
	{0x4017, 0x00},
	{0x4018, 0x03},
	{0x401a, 0x40},
	{0x401b, 0x04},
	{0x401e, 0x00},
	{0x401f, 0xd0},
	{0x4020, 0x04},
	{0x4021, 0x00},
	{0x4022, 0x04},
	{0x4023, 0x00},
	{0x4024, 0x04},
	{0x4025, 0x00},
	{0x4026, 0x04},
	{0x4027, 0x00},
	{0x4030, 0x00},
	{0x4031, 0x10},
	{0x4032, 0x00},
	{0x4033, 0x10},
	{0x4034, 0x08},
	{0x4035, 0x10},
	{0x4036, 0x08},
	{0x4037, 0x10},
	{0x4040, 0x08},
	{0x4041, 0x10},
	{0x4042, 0x08},
	{0x4043, 0x10},
	{0x4044, 0x00},
	{0x4045, 0x10},
	{0x4046, 0x00},
	{0x4047, 0x10},
	{0x4056, 0x25},
	{0x4100, 0x00},
	{0x4103, 0x00},
	{0x4104, 0x00},
	{0x4300, 0x00},
	{0x4301, 0x00},
	{0x4302, 0x00},
	{0x4303, 0x00},
	{0x4304, 0x00},
	{0x4305, 0x00},
	{0x4306, 0x00},
	{0x4307, 0x00},
	{0x4308, 0x00},
	{0x430b, 0xff},
	{0x430c, 0xff},
	{0x430d, 0x00},
	{0x430e, 0x00},
	{0x4500, 0x04},
	{0x4503, 0x0f},
	{0x4507, 0x00},
	{0x4508, 0x00},
	{0x4510, 0x07},
	{0x4512, 0x00},
	{0x4513, 0x00},
	{0x4514, 0x00},
	{0x4515, 0x00},
	{0x4516, 0x55},
	{0x4517, 0x55},
	{0x4518, 0x55},
	{0x4519, 0x55},
	{0x451a, 0x11},
	{0x451b, 0xbb},
	{0x451c, 0x11},
	{0x451d, 0xbb},
	{0x451e, 0x11},
	{0x451f, 0xbb},
	{0x4520, 0x11},
	{0x4521, 0xbb},
	{0x460b, 0x01},
	{0x4640, 0x00},
	{0x4641, 0x7f},
	{0x4642, 0x42},
	{0x4643, 0x0c},
	{0x4648, 0x0a},
	{0x4649, 0x05},
	{0x4700, 0x0a},
	{0x4701, 0x0c},
	{0x4702, 0x0a},
	{0x4703, 0x0a},
	{0x4704, 0x12},
	{0x4705, 0x0a},
	{0x4706, 0x0c},
	{0x4707, 0x0a},
	{0x4708, 0x0a},
	{0x4709, 0x12},
	{0x470a, 0x0a},
	{0x470b, 0x0c},
	{0x470c, 0x0a},
	{0x470d, 0x0a},
	{0x470e, 0x12},
	{0x4720, 0x00},
	{0x4721, 0x00},
	{0x4723, 0x00},
	{0x4724, 0x00},
	{0x4725, 0x01},
	{0x4726, 0x01},
	{0x4748, 0x00},
	{0x4731, 0x0d},
	{0x4732, 0x0d},
	{0x4733, 0x0f},
	{0x4734, 0x0f},
	{0x4735, 0x0c},
	{0x4736, 0x04},
	{0x4737, 0x00},
	{0x4738, 0x0f},
	{0x4739, 0x0f},
	{0x473a, 0x0c},
	{0x473b, 0x04},
	{0x473c, 0x00},
	{0x473d, 0x0d},
	{0x473e, 0x0f},
	{0x473f, 0x0f},
	{0x4740, 0x0c},
	{0x4741, 0x04},
	{0x4742, 0x00},
	{0x4743, 0x0f},
	{0x4744, 0x55},
	{0x4745, 0xff},
	{0x4747, 0x00},
	{0x474e, 0x80},
	{0x4750, 0x01},
	{0x4753, 0x80},
	{0x4755, 0x01},
	{0x4757, 0x0b},
	{0x4759, 0x0b},
	{0x475b, 0x06},
	{0x475d, 0x03},
	{0x475f, 0x02},
	{0x4761, 0x07},
	{0x4763, 0x07},
	{0x4765, 0x04},
	{0x4767, 0x02},
	{0x4769, 0x01},
	{0x4800, 0x64},
	{0x4802, 0x02},
	{0x480b, 0x10},
	{0x480c, 0x80},
	{0x480e, 0x04},
	{0x480f, 0x32},
	{0x4815, 0x19},
	{0x481b, 0x14},
	{0x481f, 0x32},
	{0x4837, 0x09},
	{0x484b, 0x27},
	{0x4850, 0x42},
	{0x4851, 0xaa},
	{0x4853, 0x4a},
	{0x4854, 0x05},
	{0x4860, 0x01},
	{0x4861, 0xef},
	{0x4862, 0x20},
	{0x4883, 0x24},
	{0x4888, 0x00},
	{0x4d00, 0x05},
	{0x4d01, 0x0e},
	{0x4d02, 0xb7},
	{0x4d03, 0x39},
	{0x4d04, 0xcd},
	{0x4d05, 0x4e},
	{0x5000, 0x8b},
	{0x5001, 0x63},
	{0x5002, 0x9d},
	{0x5003, 0xca},
	{0x5005, 0x00},
	{0x5006, 0x00},
	{0x5016, 0x00},
	{0x5017, 0x00},
	{0x5035, 0x18},
	{0x5037, 0x14},
	{0x5038, 0x0f},
	{0x5039, 0xe0},
	{0x503a, 0x0b},
	{0x503b, 0xe0},
	{0x504c, 0x12},
	{0x504d, 0x12},
	{0x504e, 0x12},
	{0x504f, 0x12},
	{0x5050, 0x12},
	{0x5051, 0x14},
	{0x5055, 0x12},
	{0x5081, 0x00},
	{0x5180, 0x70},
	{0x5181, 0x10},
	{0x5182, 0x00},
	{0x5183, 0x7f},
	{0x5184, 0x40},
	{0x5185, 0x2b},
	{0x5187, 0x88},
	{0x518c, 0x01},
	{0x518d, 0x01},
	{0x518e, 0x01},
	{0x518f, 0x01},
	{0x5190, 0x00},
	{0x5191, 0x00},
	{0x5192, 0x10},
	{0x5193, 0x0f},
	{0x5194, 0x00},
	{0x5195, 0x04},
	{0x5880, 0xc1},
	{0x588a, 0x04},
	{0x5c00, 0x63},
	{0x5c01, 0x04},
	{0x5c02, 0x00},
	{0x5c03, 0x3f},
	{0x5c04, 0x00},
	{0x5c05, 0x54},
	{0x5c0e, 0x01},
	{0x5c0f, 0x00},
	{0x5c10, 0x01},
	{0x5c11, 0x00},
	{0x5c12, 0x01},
	{0x5c13, 0x00},
	{0x5c14, 0x01},
	{0x5c15, 0x00},
	{0x5c16, 0x00},
	{0x5c17, 0x50},
	{0x5c18, 0x00},
	{0x5c19, 0x50},
	{0x5c1a, 0x00},
	{0x5c1b, 0x50},
	{0x5c1c, 0x00},
	{0x5c1d, 0x50},
	{0x5c1e, 0x00},
	{0x5c1f, 0x50},
	{0x5c20, 0x00},
	{0x5c21, 0x50},
	{0x5c22, 0x00},
	{0x5c23, 0x50},
	{0x5c24, 0x00},
	{0x5c25, 0x50},
	{0x5c26, 0x00},
	{0x5c27, 0x50},
	{0x5c28, 0x00},
	{0x5c29, 0x50},
	{0x5c2a, 0x00},
	{0x5c2b, 0x50},
	{0x5c2c, 0x00},
	{0x5c2d, 0x50},
	{0x5c44, 0x02},
	{0x5c45, 0x0a},
	{0x5c46, 0x00},
	{0x5c47, 0x07},
	{0x5c48, 0x0f},
	{0x5c49, 0x01},
	{0x5c4a, 0x00},
	{0x5c4b, 0x09},
	{0x5c4c, 0x06},
	{0x5c4d, 0x0e},
	{0x5c4e, 0x00},
	{0x5c4f, 0x00},
	{0x5c50, 0x00},
	{0x5c51, 0x00},
	{0x5c52, 0x00},
	{0x5c53, 0x00},
	{0x5c54, 0x10},
	{0x5c55, 0x08},
	{0x5c56, 0x04},
	{0x5c57, 0x04},
	{0x5c58, 0x0c},
	{0x5c59, 0x0c},
	{0x5c5a, 0x02},
	{0x5c5b, 0x02},
	{0x5c5c, 0x06},
	{0x5c5d, 0x06},
	{0x5c5e, 0x01},
	{0x5c5f, 0x00},
	{0x5c60, 0x00},
	{0x5c61, 0x30},
	{0x5c62, 0x00},
	{0x5c63, 0x30},
	{0x5c64, 0x1f},
	{0x5c65, 0xc0},
	{0x5c66, 0x17},
	{0x5c67, 0xc0},
	{0x5c68, 0x02},
	{0x5c69, 0x02},
	{0x5c6a, 0x02},
	{0x5c6b, 0x02},
	{0x5c90, 0x01},
	{0x5d00, 0xc2},
	{0x5d01, 0x68},
	{0x5d02, 0xff},
	{0x5d03, 0x1c},
	{0x5d05, 0x02},
	{0x5d06, 0x04},
	{0x5d07, 0x11},
	{0x5d08, 0x08},
	{0x5d09, 0x08},
	{0x5d0a, 0x02},
	{0x5d0b, 0x02},
	{0x5d0c, 0x06},
	{0x5d0d, 0x06},
	{0x5d0e, 0x02},
	{0x5d0f, 0x02},
	{0x5d10, 0x06},
	{0x5d11, 0x06},
	{0x5d12, 0x00},
	{0x5d13, 0x00},
	{0x5d14, 0xff},
	{0x5d15, 0x10},
	{0x5d16, 0x10},
	{0x5d17, 0x10},
	{0x5d18, 0x10},
	{0x5d19, 0xff},
	{0x5d1a, 0x10},
	{0x5d1b, 0x10},
	{0x5d1c, 0x10},
	{0x5d1d, 0x10},
	{0x5d1e, 0x01},
	{0x5d1f, 0x02},
	{0x5d20, 0x04},
	{0x5d21, 0xaa},
	{0x5d34, 0x00},
	{0x5d35, 0x30},
	{0x5d36, 0x00},
	{0x5d37, 0x30},
	{0x5d38, 0x1f},
	{0x5d39, 0xc0},
	{0x5d3a, 0x17},
	{0x5d3b, 0xc0},
	{0x5d3d, 0x08},
	{0x5d40, 0x00},
	{0x5d41, 0x00},
	{0x5d45, 0x05},
	{REG_NULL, 0x00},
};

static const struct other_data ov50c40_spd = {
	.width = 1016,
	.height = 760,
	.bus_fmt = MEDIA_BUS_FMT_SPD_2X8,
	.data_type = 0x19,
	.data_bit = 10,
};

/*
 * The width and height must be configured to be
 * the same as the current output resolution of the sensor.
 * The input width of the isp needs to be 16 aligned.
 * The input height of the isp needs to be 8 aligned.
 * If the width or height does not meet the alignment rules,
 * you can configure the cropping parameters with the following function to
 * crop out the appropriate resolution.
 * struct v4l2_subdev_pad_ops {
 *	.get_selection
 * }
 */
static const struct ov50c40_mode supported_modes_dphy[] = {
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 4096,
		.height = 3072,
		.max_fps = {
			.numerator = 10000,
			.denominator = 300000,
		},
		.exp_def = 0x0840,
		.hts_def = 0x41a * 4,
		.vts_def = 0x0c66,
		.mipi_freq_idx = 2,
		.bpp = 10,
		.reg_list = ov50c40_10bit_4096x3072_dphy_30fps_regs,
		.hdr_mode = NO_HDR,
		.spd = &ov50c40_spd,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 8192,
		.height = 6144,
		.max_fps = {
			.numerator = 10000,
			.denominator = 120000,
		},
		.exp_def = 0x0240,
		.hts_def = 0x9f6 * 4,
		.vts_def = 0x0cc3 * 2,
		.mipi_freq_idx = 3,
		.bpp = 10,
		.reg_list = ov50c40_10bit_8192x6144_dphy_12fps_regs,
		.hdr_mode = NO_HDR,
		.spd = &ov50c40_spd,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
#ifdef DEBUG
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 4096,
		.height = 3072,
		.max_fps = {
			.numerator = 10000,
			.denominator = 150000,
		},
		.exp_def = 0x0240,
		.hts_def = 0x0834 * 4,
		.vts_def = 0x0c66,
		.mipi_freq_idx = 1,
		.bpp = 10,
		.reg_list = ov50c40_10bit_4096x3072_dphy_regs,
		.hdr_mode = NO_HDR,
		.spd = &ov50c40_spd,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 8192,
		.height = 6144,
		.max_fps = {
			.numerator = 10000,
			.denominator = 30000,
		},
		.exp_def = 0x0240,
		.hts_def = 0x09f6 * 4,
		.vts_def = 0x0cc3 * 2,
		.mipi_freq_idx = 1,
		.bpp = 10,
		.reg_list = ov50c40_10bit_8192x6144_dphy_regs,
		.hdr_mode = NO_HDR,
		.spd = &ov50c40_spd,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 4096,
		.height = 3072,
		.max_fps = {
			.numerator = 10000,
			.denominator = 300000,
		},
		.exp_def = 0x0840,
		.hts_def = 0x3e8 * 8,
		.vts_def = 0x0d05,
		.mipi_freq_idx = 2,
		.bpp = 10,
		.reg_list = ov50c40_10bit_4096x3072_dphy_30fps_nopd_regs,
		.hdr_mode = NO_HDR,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
#endif
};

static const struct ov50c40_mode supported_modes_cphy[] = {
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 4096,
		.height = 3072,
		.max_fps = {
			.numerator = 10000,
			.denominator = 150000,
		},
		.exp_def = 0x0240,
		.hts_def = 0x0834 * 4,
		.vts_def = 0x0c66,
		.mipi_freq_idx = 0,
		.bpp = 10,
		.reg_list = ov50c40_10bit_4096x3072_cphy_regs,
		.hdr_mode = NO_HDR,
		.spd = &ov50c40_spd,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 4096,
		.height = 3072,
		.max_fps = {
			.numerator = 10000,
			.denominator = 300000,
		},
		.exp_def = 0x0240,
		.hts_def = 0x041a * 4,
		.vts_def = 0x0c66,
		.mipi_freq_idx = 2,
		.bpp = 10,
		.reg_list = ov50c40_10bit_4096x3072_cphy_30fps_regs,
		.hdr_mode = NO_HDR,
		.spd = &ov50c40_spd,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SGBRG10_1X10,
		.width = 8192,
		.height = 6144,
		.max_fps = {
			.numerator = 10000,
			.denominator = 120000,
		},
		.exp_def = 0x0240,
		.hts_def = 0x09f6 * 4,
		.vts_def = 0x0cc3 * 2,
		.mipi_freq_idx = 3,
		.bpp = 10,
		.reg_list = ov50c40_10bit_8192x6144_cphy_12fps_regs,
		.hdr_mode = NO_HDR,
		.spd = &ov50c40_spd,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
};

static const s64 link_freq_items[] = {
	MIPI_FREQ_356M,
	MIPI_FREQ_384M,
	MIPI_FREQ_750M,
	MIPI_FREQ_1250M,
};

static const char * const ov50c40_test_pattern_menu[] = {
	"Disabled",
	"Vertical Color Bar Type 1",
	"Vertical Color Bar Type 2",
	"Vertical Color Bar Type 3",
	"Vertical Color Bar Type 4"
};

static int __ov50c40_power_on(struct ov50c40 *ov50c40);

/* Write registers up to 4 at a time */
static int ov50c40_write_reg(struct i2c_client *client, u16 reg,
			    u32 len, u32 val)
{
	u32 buf_i, val_i;
	u8 buf[6];
	u8 *val_p;
	__be32 val_be;

	if (len > 4)
		return -EINVAL;

	buf[0] = reg >> 8;
	buf[1] = reg & 0xff;

	val_be = cpu_to_be32(val);
	val_p = (u8 *)&val_be;
	buf_i = 2;
	val_i = 4 - len;

	while (val_i < 4)
		buf[buf_i++] = val_p[val_i++];

	if (i2c_master_send(client, buf, len + 2) != len + 2) {
		dev_err(&client->dev, "Failed to write 0x%04x,0x%x\n", reg, val);
		return -EIO;
	}
	return 0;
}

static int ov50c40_write_array(struct i2c_client *client,
			       const struct regval *regs)
{
	u32 i;
	int ret = 0;

	for (i = 0; ret == 0 && regs[i].addr != REG_NULL; i++) {
		ret |= ov50c40_write_reg(client, regs[i].addr,
			OV50C40_REG_VALUE_08BIT, regs[i].val);
	}
	return ret;
}

/* Read registers up to 4 at a time */
static int ov50c40_read_reg(struct i2c_client *client,
			    u16 reg,
			    unsigned int len,
			    u32 *val)
{
	struct i2c_msg msgs[2];
	u8 *data_be_p;
	__be32 data_be = 0;
	__be16 reg_addr_be = cpu_to_be16(reg);
	int ret;

	if (len > 4 || !len)
		return -EINVAL;

	data_be_p = (u8 *)&data_be;
	/* Write register address */
	msgs[0].addr = client->addr;
	msgs[0].flags = 0;
	msgs[0].len = 2;
	msgs[0].buf = (u8 *)&reg_addr_be;

	/* Read data from register */
	msgs[1].addr = client->addr;
	msgs[1].flags = I2C_M_RD;
	msgs[1].len = len;
	msgs[1].buf = &data_be_p[4 - len];

	ret = i2c_transfer(client->adapter, msgs, ARRAY_SIZE(msgs));
	if (ret != ARRAY_SIZE(msgs))
		return -EIO;

	*val = be32_to_cpu(data_be);

	return 0;
}

static int ov50c40_get_reso_dist(const struct ov50c40_mode *mode,
				struct v4l2_mbus_framefmt *framefmt)
{
	return abs(mode->width - framefmt->width) +
	       abs(mode->height - framefmt->height);
}

static const struct ov50c40_mode *
ov50c40_find_best_fit(struct ov50c40 *ov50c40, struct v4l2_subdev_format *fmt)
{
	struct v4l2_mbus_framefmt *framefmt = &fmt->format;
	int dist;
	int cur_best_fit = 0;
	int cur_best_fit_dist = -1;
	unsigned int i;

	for (i = 0; i < ov50c40->cfg_num; i++) {
		dist = ov50c40_get_reso_dist(&ov50c40->support_modes[i], framefmt);
		if ((cur_best_fit_dist == -1 || dist < cur_best_fit_dist) &&
			(ov50c40->support_modes[i].bus_fmt == framefmt->code)) {
			cur_best_fit_dist = dist;
			cur_best_fit = i;
		}
	}
	dev_info(&ov50c40->client->dev, "%s: cur_best_fit(%d)",
		 __func__, cur_best_fit);
	return &ov50c40->support_modes[cur_best_fit];
}

static int ov50c40_set_fmt(struct v4l2_subdev *sd,
			  struct v4l2_subdev_pad_config *cfg,
			  struct v4l2_subdev_format *fmt)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	const struct ov50c40_mode *mode;
	s64 h_blank, vblank_def;
	u64 pixel_rate = 0;
	u32 lane_num = ov50c40->bus_cfg.bus.mipi_csi2.num_data_lanes;

	mutex_lock(&ov50c40->mutex);

	mode = ov50c40_find_best_fit(ov50c40, fmt);
	fmt->format.code = mode->bus_fmt;
	fmt->format.width = mode->width;
	fmt->format.height = mode->height;
	fmt->format.field = V4L2_FIELD_NONE;
	if (fmt->which == V4L2_SUBDEV_FORMAT_TRY) {
#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
		*v4l2_subdev_get_try_format(sd, cfg, fmt->pad) = fmt->format;
#else
		mutex_unlock(&ov50c40->mutex);
		return -ENOTTY;
#endif
	} else {
		ov50c40->cur_mode = mode;
		h_blank = mode->hts_def - mode->width;
		__v4l2_ctrl_modify_range(ov50c40->hblank, h_blank,
					 h_blank, 1, h_blank);
		vblank_def = mode->vts_def - mode->height;
		__v4l2_ctrl_modify_range(ov50c40->vblank, vblank_def,
					 OV50C40_VTS_MAX - mode->height,
					 1, vblank_def);
		__v4l2_ctrl_s_ctrl(ov50c40->vblank, vblank_def);
		pixel_rate = (u32)link_freq_items[mode->mipi_freq_idx] / mode->bpp * 2 * lane_num;
		__v4l2_ctrl_s_ctrl_int64(ov50c40->pixel_rate,
					 pixel_rate);
		__v4l2_ctrl_s_ctrl(ov50c40->link_freq,
				   mode->mipi_freq_idx);
	}
	dev_info(&ov50c40->client->dev, "%s: mode->mipi_freq_idx(%d)",
		 __func__, mode->mipi_freq_idx);

	mutex_unlock(&ov50c40->mutex);

	return 0;
}

static int ov50c40_get_fmt(struct v4l2_subdev *sd,
			  struct v4l2_subdev_pad_config *cfg,
			  struct v4l2_subdev_format *fmt)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	const struct ov50c40_mode *mode = ov50c40->cur_mode;

	mutex_lock(&ov50c40->mutex);
	if (fmt->which == V4L2_SUBDEV_FORMAT_TRY) {
#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
		fmt->format = *v4l2_subdev_get_try_format(sd, cfg, fmt->pad);
#else
		mutex_unlock(&ov50c40->mutex);
		return -ENOTTY;
#endif
	} else {
		fmt->format.width = mode->width;
		fmt->format.height = mode->height;
		fmt->format.code = mode->bus_fmt;
		fmt->format.field = V4L2_FIELD_NONE;
	}
	mutex_unlock(&ov50c40->mutex);

	return 0;
}

static int ov50c40_enum_mbus_code(struct v4l2_subdev *sd,
				 struct v4l2_subdev_pad_config *cfg,
				 struct v4l2_subdev_mbus_code_enum *code)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);

	if (code->index != 0)
		return -EINVAL;
	code->code = ov50c40->cur_mode->bus_fmt;

	return 0;
}

static int ov50c40_enum_frame_sizes(struct v4l2_subdev *sd,
				   struct v4l2_subdev_pad_config *cfg,
				   struct v4l2_subdev_frame_size_enum *fse)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);

	if (fse->index >= ov50c40->cfg_num)
		return -EINVAL;

	if (fse->code != ov50c40->support_modes[fse->index].bus_fmt)
		return -EINVAL;

	fse->min_width  = ov50c40->support_modes[fse->index].width;
	fse->max_width  = ov50c40->support_modes[fse->index].width;
	fse->max_height = ov50c40->support_modes[fse->index].height;
	fse->min_height = ov50c40->support_modes[fse->index].height;

	return 0;
}

static int ov50c40_enable_test_pattern(struct ov50c40 *ov50c40, u32 pattern)
{
	u32 val;
	int ret = 0;

	if (pattern)
		val = ((pattern - 1) << 4) | OV50C40_TEST_PATTERN_ENABLE;
	else
		val = OV50C40_TEST_PATTERN_DISABLE;
	ret = ov50c40_write_reg(ov50c40->client, OV50C40_REG_TEST_PATTERN,
				OV50C40_REG_VALUE_08BIT, val);
	return ret;
}

static int ov50c40_g_frame_interval(struct v4l2_subdev *sd,
				   struct v4l2_subdev_frame_interval *fi)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	const struct ov50c40_mode *mode = ov50c40->cur_mode;

	mutex_lock(&ov50c40->mutex);
	fi->interval = mode->max_fps;
	mutex_unlock(&ov50c40->mutex);

	return 0;
}

static int ov50c40_g_mbus_config(struct v4l2_subdev *sd, unsigned int pad_id,
				struct v4l2_mbus_config *config)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	u32 lane_num = ov50c40->bus_cfg.bus.mipi_csi2.num_data_lanes;
	u32 val = 0;

	val = 1 << (lane_num - 1) |
		V4L2_MBUS_CSI2_CHANNEL_0 |
		V4L2_MBUS_CSI2_CONTINUOUS_CLOCK;

	config->type = ov50c40->bus_cfg.bus_type;
	config->flags = val;

	return 0;
}

static void ov50c40_get_otp(struct otp_info *otp,
			       struct rkmodule_inf *inf)
{
	u32 i, j;
	u32 w, h;

	/* awb */
	if (otp->awb_data.flag) {
		inf->awb.flag = 1;
		inf->awb.r_value = otp->awb_data.r_ratio;
		inf->awb.b_value = otp->awb_data.b_ratio;
		inf->awb.gr_value = otp->awb_data.g_ratio;
		inf->awb.gb_value = 0x0;

		inf->awb.golden_r_value = otp->awb_data.r_golden;
		inf->awb.golden_b_value = otp->awb_data.b_golden;
		inf->awb.golden_gr_value = otp->awb_data.g_golden;
		inf->awb.golden_gb_value = 0x0;
	}

	/* lsc */
	if (otp->lsc_data.flag) {
		inf->lsc.flag = 1;
		inf->lsc.width = otp->basic_data.size.width;
		inf->lsc.height = otp->basic_data.size.height;
		inf->lsc.table_size = otp->lsc_data.table_size;

		for (i = 0; i < 289; i++) {
			inf->lsc.lsc_r[i] = (otp->lsc_data.data[i * 2] << 8) |
					     otp->lsc_data.data[i * 2 + 1];
			inf->lsc.lsc_gr[i] = (otp->lsc_data.data[i * 2 + 578] << 8) |
					      otp->lsc_data.data[i * 2 + 579];
			inf->lsc.lsc_gb[i] = (otp->lsc_data.data[i * 2 + 1156] << 8) |
					      otp->lsc_data.data[i * 2 + 1157];
			inf->lsc.lsc_b[i] = (otp->lsc_data.data[i * 2 + 1734] << 8) |
					     otp->lsc_data.data[i * 2 + 1735];
		}
	}

	/* pdaf */
	if (otp->pdaf_data.flag) {
		inf->pdaf.flag = 1;
		inf->pdaf.gainmap_width = otp->pdaf_data.gainmap_width;
		inf->pdaf.gainmap_height = otp->pdaf_data.gainmap_height;
		inf->pdaf.dcc_mode = otp->pdaf_data.dcc_mode;
		inf->pdaf.dcc_dir = otp->pdaf_data.dcc_dir;
		inf->pdaf.dccmap_width = otp->pdaf_data.dccmap_width;
		inf->pdaf.dccmap_height = otp->pdaf_data.dccmap_height;
		w = otp->pdaf_data.gainmap_width;
		h = otp->pdaf_data.gainmap_height;
		for (i = 0; i < h; i++) {
			for (j = 0; j < w; j++) {
				inf->pdaf.gainmap[i * w + j] =
					(otp->pdaf_data.gainmap[(i * w + j) * 2] << 8) |
					otp->pdaf_data.gainmap[(i * w + j) * 2 + 1];
			}
		}
		w = otp->pdaf_data.dccmap_width;
		h = otp->pdaf_data.dccmap_height;
		for (i = 0; i < h; i++) {
			for (j = 0; j < w; j++) {
				inf->pdaf.dccmap[i * w + j] =
					(otp->pdaf_data.dccmap[(i * w + j) * 2] << 8) |
					otp->pdaf_data.dccmap[(i * w + j) * 2 + 1];
			}
		}
	}

	/* af */
	if (otp->af_data.flag) {
		inf->af.flag = 1;
		inf->af.dir_cnt = 1;
		inf->af.af_otp[0].vcm_start = otp->af_data.af_inf;
		inf->af.af_otp[0].vcm_end = otp->af_data.af_macro;
		inf->af.af_otp[0].vcm_dir = 0;
	}

}

static void ov50c40_get_module_inf(struct ov50c40 *ov50c40,
				  struct rkmodule_inf *inf)
{
	struct otp_info *otp = ov50c40->otp;

	memset(inf, 0, sizeof(*inf));
	strscpy(inf->base.sensor, OV50C40_NAME, sizeof(inf->base.sensor));
	strscpy(inf->base.module, ov50c40->module_name,
		sizeof(inf->base.module));
	strscpy(inf->base.lens, ov50c40->len_name, sizeof(inf->base.lens));
	if (otp)
		ov50c40_get_otp(otp, inf);
}

static int ov50c40_get_channel_info(struct ov50c40 *ov50c40, struct rkmodule_channel_info *ch_info)
{
	const struct ov50c40_mode *mode = ov50c40->cur_mode;

	if (ch_info->index < PAD0 || ch_info->index >= PAD_MAX)
		return -EINVAL;

	if (ch_info->index == ov50c40->spd_id && mode->spd) {
		ch_info->vc = V4L2_MBUS_CSI2_CHANNEL_1;
		ch_info->width = mode->spd->width;
		ch_info->height = mode->spd->height;
		ch_info->bus_fmt = mode->spd->bus_fmt;
		ch_info->data_type = mode->spd->data_type;
		ch_info->data_bit = mode->spd->data_bit;
	} else {
		ch_info->vc = ov50c40->cur_mode->vc[ch_info->index];
		ch_info->width = ov50c40->cur_mode->width;
		ch_info->height = ov50c40->cur_mode->height;
		ch_info->bus_fmt = ov50c40->cur_mode->bus_fmt;
	}
	return 0;
}

static long ov50c40_ioctl(struct v4l2_subdev *sd, unsigned int cmd, void *arg)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	struct rkmodule_hdr_cfg *hdr_cfg;
	struct rkmodule_channel_info *ch_info;
	long ret = 0;
	u32 i, h, w;
	u32 stream = 0;

	switch (cmd) {
	case RKMODULE_SET_HDR_CFG:
		hdr_cfg = (struct rkmodule_hdr_cfg *)arg;
		w = ov50c40->cur_mode->width;
		h = ov50c40->cur_mode->height;
		for (i = 0; i < ov50c40->cfg_num; i++) {
			if (w == ov50c40->support_modes[i].width &&
			h == ov50c40->support_modes[i].height &&
			ov50c40->support_modes[i].hdr_mode == hdr_cfg->hdr_mode) {
				ov50c40->cur_mode = &ov50c40->support_modes[i];
				break;
			}
		}
		if (i == ov50c40->cfg_num) {
			dev_err(&ov50c40->client->dev,
				"not find hdr mode:%d %dx%d config\n",
				hdr_cfg->hdr_mode, w, h);
			ret = -EINVAL;
		} else {
			w = ov50c40->cur_mode->hts_def - ov50c40->cur_mode->width;
			h = ov50c40->cur_mode->vts_def - ov50c40->cur_mode->height;
			__v4l2_ctrl_modify_range(ov50c40->hblank, w, w, 1, w);
			__v4l2_ctrl_modify_range(ov50c40->vblank, h,
				OV50C40_VTS_MAX - ov50c40->cur_mode->height,
				1, h);
			dev_info(&ov50c40->client->dev,
				"sensor mode: %d\n",
				ov50c40->cur_mode->hdr_mode);
		}
		dev_info(&ov50c40->client->dev, "%s: matched mode index(%d)",
			 __func__, i);
		break;
	case RKMODULE_GET_MODULE_INFO:
		ov50c40_get_module_inf(ov50c40, (struct rkmodule_inf *)arg);
		break;
	case RKMODULE_GET_HDR_CFG:
		hdr_cfg = (struct rkmodule_hdr_cfg *)arg;
		hdr_cfg->esp.mode = HDR_NORMAL_VC;
		hdr_cfg->hdr_mode = ov50c40->cur_mode->hdr_mode;
		break;
	case RKMODULE_SET_QUICK_STREAM:

		stream = *((u32 *)arg);

		if (stream)
			ret = ov50c40_write_reg(ov50c40->client, OV50C40_REG_CTRL_MODE,
				OV50C40_REG_VALUE_08BIT, OV50C40_MODE_STREAMING);
		else
			ret = ov50c40_write_reg(ov50c40->client, OV50C40_REG_CTRL_MODE,
				OV50C40_REG_VALUE_08BIT, OV50C40_MODE_SW_STANDBY);
		break;
	case RKMODULE_GET_CHANNEL_INFO:
		ch_info = (struct rkmodule_channel_info *)arg;
		ret = ov50c40_get_channel_info(ov50c40, ch_info);
		break;
	default:
		ret = -ENOIOCTLCMD;
		break;
	}

	return ret;
}

#ifdef CONFIG_COMPAT
static long ov50c40_compat_ioctl32(struct v4l2_subdev *sd,
				  unsigned int cmd, unsigned long arg)
{
	void __user *up = compat_ptr(arg);
	struct rkmodule_inf *inf;
	struct rkmodule_awb_cfg *cfg;
	struct rkmodule_hdr_cfg *hdr;
	struct rkmodule_channel_info *ch_info;
	long ret;
	u32 stream = 0;

	switch (cmd) {
	case RKMODULE_GET_MODULE_INFO:
		inf = kzalloc(sizeof(*inf), GFP_KERNEL);
		if (!inf) {
			ret = -ENOMEM;
			return ret;
		}

		ret = ov50c40_ioctl(sd, cmd, inf);
		if (!ret) {
			ret = copy_to_user(up, inf, sizeof(*inf));
			if (ret)
				ret = -EFAULT;
		}
		kfree(inf);
		break;
	case RKMODULE_AWB_CFG:
		cfg = kzalloc(sizeof(*cfg), GFP_KERNEL);
		if (!cfg) {
			ret = -ENOMEM;
			return ret;
		}

		ret = copy_from_user(cfg, up, sizeof(*cfg));
		if (!ret)
			ret = ov50c40_ioctl(sd, cmd, cfg);
		else
			ret = -EFAULT;
		kfree(cfg);
		break;
	case RKMODULE_GET_HDR_CFG:
		hdr = kzalloc(sizeof(*hdr), GFP_KERNEL);
		if (!hdr) {
			ret = -ENOMEM;
			return ret;
		}

		ret = ov50c40_ioctl(sd, cmd, hdr);
		if (!ret) {
			ret = copy_to_user(up, hdr, sizeof(*hdr));
			if (ret)
				ret = -EFAULT;
		}
		kfree(hdr);
		break;
	case RKMODULE_SET_HDR_CFG:
		hdr = kzalloc(sizeof(*hdr), GFP_KERNEL);
		if (!hdr) {
			ret = -ENOMEM;
			return ret;
		}

		ret = copy_from_user(hdr, up, sizeof(*hdr));
		if (!ret)
			ret = ov50c40_ioctl(sd, cmd, hdr);
		else
			ret = -EFAULT;
		kfree(hdr);
		break;
	case RKMODULE_SET_QUICK_STREAM:
		ret = copy_from_user(&stream, up, sizeof(u32));
		if (!ret)
			ret = ov50c40_ioctl(sd, cmd, &stream);
		else
			ret = -EFAULT;
		break;
	case RKMODULE_GET_CHANNEL_INFO:
		ch_info = kzalloc(sizeof(*ch_info), GFP_KERNEL);
		if (!ch_info) {
			ret = -ENOMEM;
			return ret;
		}

		ret = copy_from_user(ch_info, up, sizeof(*ch_info));
		if (ret) {
			ret = -EFAULT;
			return ret;
		}

		ret = ov50c40_ioctl(sd, cmd, ch_info);
		if (!ret) {
			ret = copy_to_user(up, ch_info, sizeof(*ch_info));
			if (ret)
				ret = -EFAULT;
		}
		kfree(ch_info);
		break;
	default:
		ret = -ENOIOCTLCMD;
		break;
	}

	return ret;
}
#endif

static int __ov50c40_start_stream(struct ov50c40 *ov50c40)
{
	int ret;

	if (!ov50c40->is_thunderboot) {
		ret = ov50c40_write_array(ov50c40->client, ov50c40->cur_mode->reg_list);
		if (ret)
			return ret;
	}

	/* In case these controls are set before streaming */
	ret = __v4l2_ctrl_handler_setup(&ov50c40->ctrl_handler);
	if (ret)
		return ret;

	return ov50c40_write_reg(ov50c40->client, OV50C40_REG_CTRL_MODE,
		OV50C40_REG_VALUE_08BIT, OV50C40_MODE_STREAMING);
}

static int __ov50c40_stop_stream(struct ov50c40 *ov50c40)
{
	if (ov50c40->is_thunderboot)
		ov50c40->is_first_streamoff = true;
	return ov50c40_write_reg(ov50c40->client, OV50C40_REG_CTRL_MODE,
		OV50C40_REG_VALUE_08BIT, OV50C40_MODE_SW_STANDBY);
}

static int ov50c40_s_stream(struct v4l2_subdev *sd, int on)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	struct i2c_client *client = ov50c40->client;
	int ret = 0;

	dev_info(&client->dev, "%s: on: %d, %dx%d@%d\n", __func__, on,
				ov50c40->cur_mode->width,
				ov50c40->cur_mode->height,
		DIV_ROUND_CLOSEST(ov50c40->cur_mode->max_fps.denominator,
				  ov50c40->cur_mode->max_fps.numerator));

	mutex_lock(&ov50c40->mutex);
	on = !!on;
	if (on == ov50c40->streaming)
		goto unlock_and_return;

	if (on) {
		if (ov50c40->is_thunderboot && rkisp_tb_get_state() == RKISP_TB_NG) {
			ov50c40->is_thunderboot = false;
			__ov50c40_power_on(ov50c40);
		}
		ret = pm_runtime_get_sync(&client->dev);
		if (ret < 0) {
			pm_runtime_put_noidle(&client->dev);
			goto unlock_and_return;
		}

		ret = __ov50c40_start_stream(ov50c40);
		if (ret) {
			v4l2_err(sd, "start stream failed while write regs\n");
			pm_runtime_put(&client->dev);
			goto unlock_and_return;
		}
	} else {
		__ov50c40_stop_stream(ov50c40);
		pm_runtime_put(&client->dev);
	}

	ov50c40->streaming = on;

unlock_and_return:
	mutex_unlock(&ov50c40->mutex);

	return ret;
}

static int ov50c40_s_power(struct v4l2_subdev *sd, int on)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	struct i2c_client *client = ov50c40->client;
	int ret = 0;

	mutex_lock(&ov50c40->mutex);

	/* If the power state is not modified - no work to do. */
	if (ov50c40->power_on == !!on)
		goto unlock_and_return;

	if (on) {
		ret = pm_runtime_get_sync(&client->dev);
		if (ret < 0) {
			pm_runtime_put_noidle(&client->dev);
			goto unlock_and_return;
		}

		if (!ov50c40->is_thunderboot) {
			ret |= ov50c40_write_reg(ov50c40->client,
						 OV50C40_SOFTWARE_RESET_REG,
						 OV50C40_REG_VALUE_08BIT,
						 0x01);
			usleep_range(100, 200);
		}

		ov50c40->power_on = true;
	} else {
		pm_runtime_put(&client->dev);
		ov50c40->power_on = false;
	}

unlock_and_return:
	mutex_unlock(&ov50c40->mutex);

	return ret;
}

/* Calculate the delay in us by clock rate and clock cycles */
static inline u32 ov50c40_cal_delay(u32 cycles)
{
	return DIV_ROUND_UP(cycles, OV50C40_XVCLK_FREQ / 1000 / 1000);
}

static int __ov50c40_power_on(struct ov50c40 *ov50c40)
{
	int ret;
	u32 delay_us;
	struct device *dev = &ov50c40->client->dev;

	if (ov50c40->is_thunderboot)
		return 0;

	if (!IS_ERR_OR_NULL(ov50c40->pins_default)) {
		ret = pinctrl_select_state(ov50c40->pinctrl,
					   ov50c40->pins_default);
		if (ret < 0)
			dev_err(dev, "could not set pins\n");
	}
	ret = clk_set_rate(ov50c40->xvclk, OV50C40_XVCLK_FREQ);
	if (ret < 0)
		dev_warn(dev, "Failed to set xvclk rate (24MHz)\n");
	if (clk_get_rate(ov50c40->xvclk) != OV50C40_XVCLK_FREQ)
		dev_warn(dev, "xvclk mismatched, modes are based on 24MHz\n");
	ret = clk_prepare_enable(ov50c40->xvclk);
	if (ret < 0) {
		dev_err(dev, "Failed to enable xvclk\n");
		return ret;
	}
	if (!IS_ERR(ov50c40->reset_gpio))
		gpiod_direction_output(ov50c40->reset_gpio, 1);

	ret = regulator_bulk_enable(OV50C40_NUM_SUPPLIES, ov50c40->supplies);
	if (ret < 0) {
		dev_err(dev, "Failed to enable regulators\n");
		goto disable_clk;
	}

	if (!IS_ERR(ov50c40->reset_gpio))
		gpiod_direction_output(ov50c40->reset_gpio, 0);

	usleep_range(500, 1000);
	if (!IS_ERR(ov50c40->pwdn_gpio))
		gpiod_direction_output(ov50c40->pwdn_gpio, 0);
	/*
	 * There is no need to wait for the delay of RC circuit
	 * if the reset signal is directly controlled by GPIO.
	 */
	if (!IS_ERR(ov50c40->reset_gpio))
		usleep_range(8000, 10000);
	else
		usleep_range(12000, 16000);

	/* 8192 cycles prior to first SCCB transaction */
	delay_us = ov50c40_cal_delay(8192);
	usleep_range(delay_us, delay_us * 2);

	return 0;

disable_clk:
	clk_disable_unprepare(ov50c40->xvclk);

	return ret;
}

static void __ov50c40_power_off(struct ov50c40 *ov50c40)
{
	int ret;
	struct device *dev = &ov50c40->client->dev;

	if (ov50c40->is_thunderboot) {
		if (ov50c40->is_first_streamoff) {
			ov50c40->is_thunderboot = false;
			ov50c40->is_first_streamoff = false;
		} else {
			return;
		}
	}

	if (!IS_ERR(ov50c40->pwdn_gpio))
		gpiod_direction_output(ov50c40->pwdn_gpio, 1);

	clk_disable_unprepare(ov50c40->xvclk);

	if (!IS_ERR(ov50c40->reset_gpio))
		gpiod_direction_output(ov50c40->reset_gpio, 1);
	if (!IS_ERR_OR_NULL(ov50c40->pins_sleep)) {
		ret = pinctrl_select_state(ov50c40->pinctrl,
					   ov50c40->pins_sleep);
		if (ret < 0)
			dev_dbg(dev, "could not set pins\n");
	}

	if (ov50c40->is_thunderboot_ng) {
		ov50c40->is_thunderboot_ng = false;
	}
	regulator_bulk_disable(OV50C40_NUM_SUPPLIES, ov50c40->supplies);
}

static int ov50c40_runtime_resume(struct device *dev)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct v4l2_subdev *sd = i2c_get_clientdata(client);
	struct ov50c40 *ov50c40 = to_ov50c40(sd);

	return __ov50c40_power_on(ov50c40);
}

static int ov50c40_runtime_suspend(struct device *dev)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct v4l2_subdev *sd = i2c_get_clientdata(client);
	struct ov50c40 *ov50c40 = to_ov50c40(sd);

	__ov50c40_power_off(ov50c40);

	return 0;
}

#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
static int ov50c40_open(struct v4l2_subdev *sd, struct v4l2_subdev_fh *fh)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);
	struct v4l2_mbus_framefmt *try_fmt =
				v4l2_subdev_get_try_format(sd, fh->pad, 0);
	const struct ov50c40_mode *def_mode = &ov50c40->support_modes[0];

	mutex_lock(&ov50c40->mutex);
	/* Initialize try_fmt */
	try_fmt->width = def_mode->width;
	try_fmt->height = def_mode->height;
	try_fmt->code = def_mode->bus_fmt;
	try_fmt->field = V4L2_FIELD_NONE;

	mutex_unlock(&ov50c40->mutex);
	/* No crop or compose */

	return 0;
}
#endif

static int ov50c40_enum_frame_interval(struct v4l2_subdev *sd,
				       struct v4l2_subdev_pad_config *cfg,
				       struct v4l2_subdev_frame_interval_enum *fie)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);

	if (fie->index >= ov50c40->cfg_num)
		return -EINVAL;

	fie->code = ov50c40->support_modes[fie->index].bus_fmt;
	fie->width = ov50c40->support_modes[fie->index].width;
	fie->height = ov50c40->support_modes[fie->index].height;
	fie->interval = ov50c40->support_modes[fie->index].max_fps;
	fie->reserved[0] = ov50c40->support_modes[fie->index].hdr_mode;
	return 0;
}
//#define RK356X_TEST
#ifdef RK356X_TEST
#define CROP_START(SRC, DST) (((SRC) - (DST)) / 2 / 4 * 4)
#define DST_WIDTH 4096
#define DST_HEIGHT 2304
static int ov50c40_get_selection(struct v4l2_subdev *sd,
				struct v4l2_subdev_pad_config *cfg,
				struct v4l2_subdev_selection *sel)
{
	struct ov50c40 *ov50c40 = to_ov50c40(sd);

	if (sel->target == V4L2_SEL_TGT_CROP_BOUNDS) {
		sel->r.left = CROP_START(ov50c40->cur_mode->width, DST_WIDTH);
		sel->r.width = DST_WIDTH;
		sel->r.top = CROP_START(ov50c40->cur_mode->height, DST_HEIGHT);
		sel->r.height = DST_HEIGHT;
		return 0;
	}
	return -EINVAL;
}
#endif

static const struct dev_pm_ops ov50c40_pm_ops = {
	SET_RUNTIME_PM_OPS(ov50c40_runtime_suspend,
			   ov50c40_runtime_resume, NULL)
};

#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
static const struct v4l2_subdev_internal_ops ov50c40_internal_ops = {
	.open = ov50c40_open,
};
#endif

static const struct v4l2_subdev_core_ops ov50c40_core_ops = {
	.s_power = ov50c40_s_power,
	.ioctl = ov50c40_ioctl,
#ifdef CONFIG_COMPAT
	.compat_ioctl32 = ov50c40_compat_ioctl32,
#endif
};

static const struct v4l2_subdev_video_ops ov50c40_video_ops = {
	.s_stream = ov50c40_s_stream,
	.g_frame_interval = ov50c40_g_frame_interval,
};

static const struct v4l2_subdev_pad_ops ov50c40_pad_ops = {
	.enum_mbus_code = ov50c40_enum_mbus_code,
	.enum_frame_size = ov50c40_enum_frame_sizes,
	.enum_frame_interval = ov50c40_enum_frame_interval,
	.get_fmt = ov50c40_get_fmt,
	.set_fmt = ov50c40_set_fmt,
#ifdef RK356X_TEST
	.get_selection = ov50c40_get_selection,
#endif
	.get_mbus_config = ov50c40_g_mbus_config,
};

static const struct v4l2_subdev_ops ov50c40_subdev_ops = {
	.core	= &ov50c40_core_ops,
	.video	= &ov50c40_video_ops,
	.pad	= &ov50c40_pad_ops,
};

static int ov50c40_set_ctrl(struct v4l2_ctrl *ctrl)
{
	struct ov50c40 *ov50c40 = container_of(ctrl->handler,
					     struct ov50c40, ctrl_handler);
	struct i2c_client *client = ov50c40->client;
	s64 max;
	int ret = 0;
	u32 again, dgain;
	u32 val = 0;
	u32 vts = 0;
	u32 exp = 0;

	/* Propagate change of current control to all related controls */
	switch (ctrl->id) {
	case V4L2_CID_VBLANK:
		/* Update max exposure while meeting expected vblanking */
		if (ov50c40->cur_mode->height == 6144)
			max = ov50c40->cur_mode->height + ctrl->val - 44;
		else
			max = ov50c40->cur_mode->height + ctrl->val - 22;
		__v4l2_ctrl_modify_range(ov50c40->exposure,
					 ov50c40->exposure->minimum, max,
					 ov50c40->exposure->step,
					 ov50c40->exposure->default_value);
		break;
	}

	if (!pm_runtime_get_if_in_use(&client->dev))
		return 0;

	switch (ctrl->id) {
	case V4L2_CID_EXPOSURE:
		if (ov50c40->cur_mode->height == 6144)
			exp = ctrl->val / 2;
		else
			exp = ctrl->val;
		ret = ov50c40_write_reg(ov50c40->client,
					OV50C40_REG_EXP_LONG_H,
					OV50C40_REG_VALUE_24BIT,
					exp);
		dev_dbg(&client->dev, "set exposure 0x%x\n",
			ctrl->val);
		break;
	case V4L2_CID_ANALOGUE_GAIN:
		if (ctrl->val > 1984) {
			dgain = ctrl->val * 1024 / 1984;
			again = 1984;
		} else {
			dgain = 1024;
			again = ctrl->val;
		}
		ret = ov50c40_write_reg(ov50c40->client,
					OV50C40_REG_AGAIN_LONG_H,
					OV50C40_REG_VALUE_16BIT,
					(again << 1) & 0x7ffe);
		ret |= ov50c40_write_reg(ov50c40->client,
					OV50C40_REG_DGAIN_LONG_H,
					OV50C40_REG_VALUE_24BIT,
					(dgain << 6) & 0xfffc0);
		dev_dbg(&client->dev, "set analog gain 0x%x\n",
			ctrl->val);
		break;
	case V4L2_CID_VBLANK:
		vts = ctrl->val + ov50c40->cur_mode->height;
		if (ov50c40->cur_mode->height == 6144)
			vts /= 2;
		ret = ov50c40_write_reg(ov50c40->client, OV50C40_REG_VTS,
					OV50C40_REG_VALUE_16BIT,
					vts);
		dev_dbg(&client->dev, "set vblank 0x%x\n",
			ctrl->val);
		break;
	case V4L2_CID_TEST_PATTERN:
		ret = ov50c40_enable_test_pattern(ov50c40, ctrl->val);
		break;
	case V4L2_CID_HFLIP:
		ret = ov50c40_read_reg(ov50c40->client, OV50C40_MIRROR_REG,
				       OV50C40_REG_VALUE_08BIT,
				       &val);
		if (ctrl->val)
			val |= FLIP_BIT_MASK;
		else
			val &= ~FLIP_BIT_MASK;
		ret = ov50c40_write_reg(ov50c40->client, OV50C40_MIRROR_REG,
					OV50C40_REG_VALUE_08BIT,
					val);
		break;
	case V4L2_CID_VFLIP:
		ret = ov50c40_read_reg(ov50c40->client, OV50C40_FLIP_REG,
				       OV50C40_REG_VALUE_08BIT,
				       &val);
		if (ctrl->val)
			val |= FLIP_BIT_MASK;
		else
			val &= ~FLIP_BIT_MASK;
		ret = ov50c40_write_reg(ov50c40->client, OV50C40_FLIP_REG,
					OV50C40_REG_VALUE_08BIT,
					val);
		break;
	default:
		dev_warn(&client->dev, "%s Unhandled id:0x%x, val:0x%x\n",
			 __func__, ctrl->id, ctrl->val);
		break;
	}

	pm_runtime_put(&client->dev);

	return ret;
}

static const struct v4l2_ctrl_ops ov50c40_ctrl_ops = {
	.s_ctrl = ov50c40_set_ctrl,
};

static int ov50c40_initialize_controls(struct ov50c40 *ov50c40)
{
	const struct ov50c40_mode *mode;
	struct v4l2_ctrl_handler *handler;
	s64 exposure_max, vblank_def;
	u32 h_blank;
	int ret;
	u64 dst_pixel_rate = 0;
	u32 lane_num = ov50c40->bus_cfg.bus.mipi_csi2.num_data_lanes;

	handler = &ov50c40->ctrl_handler;
	mode = ov50c40->cur_mode;
	ret = v4l2_ctrl_handler_init(handler, 9);
	if (ret)
		return ret;
	handler->lock = &ov50c40->mutex;

	ov50c40->link_freq = v4l2_ctrl_new_int_menu(handler, NULL,
			V4L2_CID_LINK_FREQ,
			3, 0, link_freq_items);

	dst_pixel_rate = (u32)link_freq_items[mode->mipi_freq_idx] / mode->bpp * 2 * lane_num;
	/* pixel rate = link frequency * 2 * lanes / BITS_PER_SAMPLE */
	ov50c40->pixel_rate = v4l2_ctrl_new_std(handler, NULL,
			V4L2_CID_PIXEL_RATE,
			0, PIXEL_RATE_WITH_1250M,
			1, dst_pixel_rate);

	__v4l2_ctrl_s_ctrl(ov50c40->link_freq,
			   mode->mipi_freq_idx);

	h_blank = mode->hts_def - mode->width;
	ov50c40->hblank = v4l2_ctrl_new_std(handler, NULL, V4L2_CID_HBLANK,
				h_blank, h_blank, 1, h_blank);
	if (ov50c40->hblank)
		ov50c40->hblank->flags |= V4L2_CTRL_FLAG_READ_ONLY;

	vblank_def = mode->vts_def - mode->height;
	ov50c40->vblank = v4l2_ctrl_new_std(handler, &ov50c40_ctrl_ops,
				V4L2_CID_VBLANK, vblank_def,
				OV50C40_VTS_MAX - mode->height,
				1, vblank_def);
	if (mode->height == 6144)
		exposure_max = mode->vts_def - 44;
	else
		exposure_max = mode->vts_def - 22;
	ov50c40->exposure = v4l2_ctrl_new_std(handler, &ov50c40_ctrl_ops,
				V4L2_CID_EXPOSURE, OV50C40_EXPOSURE_MIN,
				exposure_max, OV50C40_EXPOSURE_STEP,
				mode->exp_def);

	ov50c40->anal_gain = v4l2_ctrl_new_std(handler, &ov50c40_ctrl_ops,
				V4L2_CID_ANALOGUE_GAIN, OV50C40_GAIN_MIN,
				OV50C40_GAIN_MAX, OV50C40_GAIN_STEP,
				OV50C40_GAIN_DEFAULT);

	ov50c40->test_pattern = v4l2_ctrl_new_std_menu_items(handler,
				&ov50c40_ctrl_ops, V4L2_CID_TEST_PATTERN,
				ARRAY_SIZE(ov50c40_test_pattern_menu) - 1,
				0, 0, ov50c40_test_pattern_menu);

	ov50c40->h_flip = v4l2_ctrl_new_std(handler, &ov50c40_ctrl_ops,
				V4L2_CID_HFLIP, 0, 1, 1, 0);

	ov50c40->v_flip = v4l2_ctrl_new_std(handler, &ov50c40_ctrl_ops,
				V4L2_CID_VFLIP, 0, 1, 1, 0);
	if (handler->error) {
		ret = handler->error;
		dev_err(&ov50c40->client->dev,
			"Failed to init controls(%d)\n", ret);
		goto err_free_handler;
	}

	ov50c40->subdev.ctrl_handler = handler;

	return 0;

err_free_handler:
	v4l2_ctrl_handler_free(handler);

	return ret;
}

static int ov50c40_check_sensor_id(struct ov50c40 *ov50c40,
				  struct i2c_client *client)
{
	struct device *dev = &ov50c40->client->dev;
	u32 id = 0;
	int ret;

	if (ov50c40->is_thunderboot) {
		dev_info(dev, "Enable thunderboot mode, skip sensor id check\n");
		return 0;
	}

	ret = ov50c40_read_reg(client, OV50C40_REG_CHIP_ID,
			       OV50C40_REG_VALUE_24BIT, &id);
	if (id != CHIP_ID) {
		dev_err(dev, "Unexpected sensor id(%06x), ret(%d)\n", id, ret);
		return -ENODEV;
	}

	dev_info(dev, "Detected OV%06x sensor\n", CHIP_ID);

	return 0;
}

static int ov50c40_configure_regulators(struct ov50c40 *ov50c40)
{
	unsigned int i;

	for (i = 0; i < OV50C40_NUM_SUPPLIES; i++)
		ov50c40->supplies[i].supply = ov50c40_supply_names[i];

	return devm_regulator_bulk_get(&ov50c40->client->dev,
				       OV50C40_NUM_SUPPLIES,
				       ov50c40->supplies);
}

static int ov50c40_probe(struct i2c_client *client,
			const struct i2c_device_id *id)
{
	struct device *dev = &client->dev;
	struct device_node *node = dev->of_node;
	struct ov50c40 *ov50c40;
	struct v4l2_subdev *sd;
	char facing[2];
	int ret;
	struct device_node *endpoint;
	struct device_node *eeprom_ctrl_node;
	struct i2c_client *eeprom_ctrl_client;
	struct v4l2_subdev *eeprom_ctrl;
	struct otp_info *otp_ptr;

	dev_info(dev, "driver version: %02x.%02x.%02x",
		DRIVER_VERSION >> 16,
		(DRIVER_VERSION & 0xff00) >> 8,
		DRIVER_VERSION & 0x00ff);

	ov50c40 = devm_kzalloc(dev, sizeof(*ov50c40), GFP_KERNEL);
	if (!ov50c40)
		return -ENOMEM;

	ret = of_property_read_u32(node, RKMODULE_CAMERA_MODULE_INDEX,
				   &ov50c40->module_index);
	ret |= of_property_read_string(node, RKMODULE_CAMERA_MODULE_FACING,
				       &ov50c40->module_facing);
	ret |= of_property_read_string(node, RKMODULE_CAMERA_MODULE_NAME,
				       &ov50c40->module_name);
	ret |= of_property_read_string(node, RKMODULE_CAMERA_LENS_NAME,
				       &ov50c40->len_name);
	if (ret) {
		dev_err(dev, "could not get module information!\n");
		return -EINVAL;
	}

	ov50c40->is_thunderboot = IS_ENABLED(CONFIG_VIDEO_ROCKCHIP_THUNDER_BOOT_ISP);

	endpoint = of_graph_get_next_endpoint(dev->of_node, NULL);
	if (!endpoint) {
		dev_err(dev, "Failed to get endpoint\n");
		return -EINVAL;
	}
	ret = v4l2_fwnode_endpoint_parse(of_fwnode_handle(endpoint),
					 &ov50c40->bus_cfg);
	if (ov50c40->bus_cfg.bus_type == V4L2_MBUS_CSI2_DPHY) {
		ov50c40->support_modes = supported_modes_dphy;
		ov50c40->cfg_num = ARRAY_SIZE(supported_modes_dphy);
	} else {
		ov50c40->support_modes = supported_modes_cphy;
		ov50c40->cfg_num = ARRAY_SIZE(supported_modes_cphy);
	}

	ov50c40->client = client;
	ov50c40->cur_mode = &ov50c40->support_modes[0];

	ov50c40->xvclk = devm_clk_get(dev, "xvclk");
	if (IS_ERR(ov50c40->xvclk)) {
		dev_err(dev, "Failed to get xvclk\n");
		return -EINVAL;
	}

	ov50c40->reset_gpio = devm_gpiod_get(dev, "reset", GPIOD_ASIS);
	if (IS_ERR(ov50c40->reset_gpio))
		dev_warn(dev, "Failed to get reset-gpios\n");

	ov50c40->pwdn_gpio = devm_gpiod_get(dev, "pwdn", GPIOD_ASIS);
	if (IS_ERR(ov50c40->pwdn_gpio))
		dev_warn(dev, "Failed to get pwdn-gpios\n");

	ret = of_property_read_u32(node,
				   "rockchip,spd-id",
				   &ov50c40->spd_id);
	if (ret != 0) {
		ov50c40->spd_id = PAD_MAX;
		dev_err(dev,
			"failed get spd_id, will not to use spd\n");
	}

	ov50c40->pinctrl = devm_pinctrl_get(dev);
	if (!IS_ERR(ov50c40->pinctrl)) {
		ov50c40->pins_default =
			pinctrl_lookup_state(ov50c40->pinctrl,
					     OF_CAMERA_PINCTRL_STATE_DEFAULT);
		if (IS_ERR(ov50c40->pins_default))
			dev_err(dev, "could not get default pinstate\n");

		ov50c40->pins_sleep =
			pinctrl_lookup_state(ov50c40->pinctrl,
					     OF_CAMERA_PINCTRL_STATE_SLEEP);
		if (IS_ERR(ov50c40->pins_sleep))
			dev_err(dev, "could not get sleep pinstate\n");
	} else {
		dev_err(dev, "no pinctrl\n");
	}

	ret = ov50c40_configure_regulators(ov50c40);
	if (ret) {
		dev_err(dev, "Failed to get power regulators\n");
		return ret;
	}

	mutex_init(&ov50c40->mutex);

	sd = &ov50c40->subdev;
	v4l2_i2c_subdev_init(sd, client, &ov50c40_subdev_ops);
	ret = ov50c40_initialize_controls(ov50c40);
	if (ret)
		goto err_destroy_mutex;
	ret = __ov50c40_power_on(ov50c40);
	if (ret)
		goto err_free_handler;

	ret = ov50c40_check_sensor_id(ov50c40, client);
	if (ret)
		goto err_power_off;
	eeprom_ctrl_node = of_parse_phandle(node, "eeprom-ctrl", 0);
	if (eeprom_ctrl_node) {
		eeprom_ctrl_client =
			of_find_i2c_device_by_node(eeprom_ctrl_node);
		of_node_put(eeprom_ctrl_node);
		if (IS_ERR_OR_NULL(eeprom_ctrl_client)) {
			dev_err(dev, "can not get node\n");
			goto continue_probe;
		}
		eeprom_ctrl = i2c_get_clientdata(eeprom_ctrl_client);
		if (IS_ERR_OR_NULL(eeprom_ctrl)) {
			dev_err(dev, "can not get eeprom i2c client\n");
		} else {
			otp_ptr = devm_kzalloc(dev, sizeof(*otp_ptr), GFP_KERNEL);
			if (!otp_ptr)
				return -ENOMEM;
			ret = v4l2_subdev_call(eeprom_ctrl,
				core, ioctl, 0, otp_ptr);
			if (!ret) {
				ov50c40->otp = otp_ptr;
			} else {
				ov50c40->otp = NULL;
				devm_kfree(dev, otp_ptr);
			}
		}
	}
continue_probe:

#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
	sd->internal_ops = &ov50c40_internal_ops;
	sd->flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;
#endif
#if defined(CONFIG_MEDIA_CONTROLLER)
	ov50c40->pad.flags = MEDIA_PAD_FL_SOURCE;
	sd->entity.function = MEDIA_ENT_F_CAM_SENSOR;
	ret = media_entity_pads_init(&sd->entity, 1, &ov50c40->pad);
	if (ret < 0)
		goto err_power_off;
#endif

	memset(facing, 0, sizeof(facing));
	if (strcmp(ov50c40->module_facing, "back") == 0)
		facing[0] = 'b';
	else
		facing[0] = 'f';

	snprintf(sd->name, sizeof(sd->name), "m%02d_%s_%s %s",
		 ov50c40->module_index, facing,
		 OV50C40_NAME, dev_name(sd->dev));
	ret = v4l2_async_register_subdev_sensor_common(sd);
	if (ret) {
		dev_err(dev, "v4l2 async register subdev failed\n");
		goto err_clean_entity;
	}

	pm_runtime_set_active(dev);
	pm_runtime_enable(dev);
	pm_runtime_idle(dev);
	return 0;

err_clean_entity:
#if defined(CONFIG_MEDIA_CONTROLLER)
	media_entity_cleanup(&sd->entity);
#endif
err_power_off:
	__ov50c40_power_off(ov50c40);
err_free_handler:
	v4l2_ctrl_handler_free(&ov50c40->ctrl_handler);
err_destroy_mutex:
	mutex_destroy(&ov50c40->mutex);

	return ret;
}

static int ov50c40_remove(struct i2c_client *client)
{
	struct v4l2_subdev *sd = i2c_get_clientdata(client);
	struct ov50c40 *ov50c40 = to_ov50c40(sd);

	v4l2_async_unregister_subdev(sd);
#if defined(CONFIG_MEDIA_CONTROLLER)
	media_entity_cleanup(&sd->entity);
#endif
	v4l2_ctrl_handler_free(&ov50c40->ctrl_handler);
	mutex_destroy(&ov50c40->mutex);

	pm_runtime_disable(&client->dev);
	if (!pm_runtime_status_suspended(&client->dev))
		__ov50c40_power_off(ov50c40);
	pm_runtime_set_suspended(&client->dev);

	return 0;
}

#if IS_ENABLED(CONFIG_OF)
static const struct of_device_id ov50c40_of_match[] = {
	{ .compatible = "ovti,ov50c40" },
	{},
};
MODULE_DEVICE_TABLE(of, ov50c40_of_match);
#endif

static const struct i2c_device_id ov50c40_match_id[] = {
	{ "ovti,ov50c40", 0 },
	{ },
};

static struct i2c_driver ov50c40_i2c_driver = {
	.driver = {
		.name = OV50C40_NAME,
		.pm = &ov50c40_pm_ops,
		.of_match_table = of_match_ptr(ov50c40_of_match),
	},
	.probe		= &ov50c40_probe,
	.remove		= &ov50c40_remove,
	.id_table	= ov50c40_match_id,
};

#ifdef CONFIG_ROCKCHIP_THUNDER_BOOT
module_i2c_driver(ov50c40_i2c_driver);
#else
static int __init sensor_mod_init(void)
{
	return i2c_add_driver(&ov50c40_i2c_driver);
}

static void __exit sensor_mod_exit(void)
{
	i2c_del_driver(&ov50c40_i2c_driver);
}

device_initcall_sync(sensor_mod_init);
module_exit(sensor_mod_exit);
#endif

MODULE_DESCRIPTION("OmniVision ov50c40 sensor driver");
MODULE_LICENSE("GPL v2");
