/* SPDX-License-Identifier: GPL-2.0 */

/* Copyright (c) 2022 Rockchip Electronics Co. Ltd. */

#ifndef __RK_CRYPTO_V3_REG_H__
#define __RK_CRYPTO_V3_REG_H__

#include "rk_crypto_v2_reg.h"

#define CRYPTO_UNEQUAL_ERR_INT_EN	BIT(9)
#define CRYPTO_ZERO_LEN_INT_EN		BIT(6)

/* DMA Destination Data Read Address Register */
#define CRYPTO_DMA_DST_WADDR		0x0028

#define CRYPTO_BC_MID_IV_0		0x0060
#define CRYPTO_BC_MID_WORD_SIZE		6

#define CRYPTO_MID_VALID		0x03e8
#define CRYPTO_BC_MID_IS_VALID		BIT(0)
#define CRYPTO_HASH_MID_IS_VALID	BIT(1)

#define CRYPTO_KEY_SEL			0x0610

#define CRYPTO_MID_VALID_SWITCH		0x0630
#define CRYPTO_MID_VALID_ENABLE		BIT(0)

#define CRYPTO_AES_VERSION		0x0680
#define CRYPTO_DES_VERSION		0x0684
#define CRYPTO_SM4_VERSION		0x0688

#define CRYPTO_ECB_FLAG			BIT(0)
#define CRYPTO_CBC_FLAG			BIT(1)
#define CRYPTO_CTS_FLAG			BIT(2)
#define CRYPTO_CTR_FLAG			BIT(3)
#define CRYPTO_CFB_FLAG			BIT(4)
#define CRYPTO_OFB_FLAG			BIT(5)
#define CRYPTO_XTS_FLAG			BIT(6)
#define CRYPTO_CCM_FLAG			BIT(7)
#define CRYPTO_GCM_FLAG			BIT(8)
#define CRYPTO_CMAC_FLAG		BIT(9)
#define CRYPTO_CBCMAC_FLAG		BIT(10)

#define CRYPTO_AES128_FLAG		BIT(16)
#define CRYPTO_AES192_FLAG		BIT(17)
#define CRYPTO_AES256_FLAG		BIT(18)

#define CRYPTO_TDES_FLAG		BIT(16)

#define CRYPTO_LOCKSEP_FLAG		BIT(20)
#define CRYPTO_SECURE_FLAG		BIT(21)
#define CRYPTO_MULTI_CHN_FLAG		BIT(22)

#define CRYPTO_HASH_VERSION		0x068C
#define CRYPTO_HASH_SHA1_FLAG		BIT(0)
#define CRYPTO_HASH_SHA224_FLAG		BIT(1)
#define CRYPTO_HASH_SHA256_FLAG		BIT(2)
#define CRYPTO_HASH_SHA384_FLAG		BIT(3)
#define CRYPTO_HASH_SHA512_FLAG		BIT(4)
#define CRYPTO_HASH_SHA512_224_FLAG	BIT(5)
#define CRYPTO_HASH_SHA512_256_FLAG	BIT(6)
#define CRYPTO_HASH_MD5_FLAG		BIT(7)
#define CRYPTO_HASH_SM3_FLAG		BIT(8)

#define CRYPTO_HMAC_VERSION		0x0690
#define CRYPTO_HMAC_SHA1_FLAG		BIT(0)
#define CRYPTO_HMAC_SHA256_FLAG		BIT(1)
#define CRYPTO_HMAC_SHA512_FLAG		BIT(2)
#define CRYPTO_HMAC_MD5_FLAG		BIT(3)
#define CRYPTO_HMAC_SM3_FLAG		BIT(4)

#define CRYPTO_RNG_VERSION		0x0694
#define CRYPTO_PKA_VERSION		0x0698
#define CRYPTO_CRYPTO_VERSION		0x06F0

#define CRYPTO_HASH_MID_DATA_0		0x0700
#define CRYPTO_HASH_MID_WORD_SIZE	26

#endif

