/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.util.file_system_manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.exception.FilesTotalOutOfLimitException;
import kohgylw.kiftd.server.exception.FoldersTotalOutOfLimitException;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.ExtendStores;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileNodeUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.util.file_system_manager.pojo.Folder;
import kohgylw.kiftd.util.file_system_manager.pojo.FolderView;

public class FileSystemManager {
    public static final String BOTH = "BOTH";
    public static final String COVER = "COVER";
    private static FileSystemManager fsm;
    private static final int BUFFER_SIZE = 4096;
    public static final int MAX_FOLDERS_OR_FILES_LIMIT = Integer.MAX_VALUE;
    public static int per;
    public static String message;
    private boolean gono;
    private PreparedStatement selectFolderById;
    private PreparedStatement selectNodeById;
    private PreparedStatement selectNodesByFolderId;
    private PreparedStatement selectFoldersByParentFolderId;
    private PreparedStatement insertNode;
    private PreparedStatement insertFolder;
    private PreparedStatement deleteNodeById;
    private PreparedStatement deleteFolderById;
    private PreparedStatement updateFolderById;
    private PreparedStatement countNodesByFolderId;
    private PreparedStatement countFoldersByParentFolderId;
    private PreparedStatement selectNodesByPathExcludeById;
    private PreparedStatement countNodesByExtendStoreIndex;
    private PreparedStatement selectNodesByExtendStoreIndex;

    private FileSystemManager() {
        FileNodeUtil.initNodeTableToDataBase();
        Connection c = FileNodeUtil.getNodeDBConnection();
        try {
            this.selectFolderById = c.prepareStatement("SELECT * FROM FOLDER WHERE folder_id = ?");
            this.selectNodeById = c.prepareStatement("SELECT * FROM FILE WHERE file_id = ?");
            this.selectNodesByPathExcludeById = c.prepareStatement("SELECT * FROM FILE WHERE file_path = ? AND file_id <> ? LIMIT 0,2147483647");
            this.selectNodesByFolderId = c.prepareStatement("SELECT * FROM FILE WHERE file_parent_folder = ? LIMIT 0,2147483647");
            this.selectFoldersByParentFolderId = c.prepareStatement("SELECT * FROM FOLDER WHERE folder_parent = ? LIMIT 0,2147483647");
            this.insertNode = c.prepareStatement("INSERT INTO FILE VALUES(?,?,?,?,?,?,?)");
            this.insertFolder = c.prepareStatement("INSERT INTO FOLDER VALUES(?,?,?,?,?,?)");
            this.deleteNodeById = c.prepareStatement("DELETE FROM FILE WHERE file_id = ?");
            this.deleteFolderById = c.prepareStatement("DELETE FROM FOLDER WHERE folder_id = ?");
            this.updateFolderById = c.prepareStatement("UPDATE FOLDER SET folder_name= ? , folder_creation_date = ? , folder_creator = ? , folder_parent = ? , folder_constraint = ? WHERE folder_id = ?");
            this.countNodesByFolderId = c.prepareStatement("SELECT count(file_id) FROM FILE WHERE file_parent_folder = ?");
            this.countFoldersByParentFolderId = c.prepareStatement("SELECT count(folder_id) FROM FOLDER WHERE folder_parent = ?");
            this.countNodesByExtendStoreIndex = c.prepareStatement("SELECT count(file_id) FROM FILE WHERE file_path LIKE ?");
            this.selectNodesByExtendStoreIndex = c.prepareStatement("SELECT * FROM FILE WHERE file_path LIKE ?");
        }
        catch (SQLException e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u6587\u4ef6\u7cfb\u7edf\u89e3\u6790\u5931\u8d25\uff0c\u65e0\u6cd5\u6d4f\u89c8\u6587\u4ef6\u3002");
        }
    }

    public static FileSystemManager getInstance() {
        if (fsm == null) {
            fsm = new FileSystemManager();
        }
        return fsm;
    }

    public FolderView getFolderView(String folderId) throws SQLException {
        Folder target = this.selectFolderById(folderId);
        if (target != null) {
            FolderView fv = new FolderView();
            fv.setCurrent(target);
            fv.setFiles(this.selectNodesByFolderId(folderId));
            fv.setFolders(this.getFoldersByParentId(folderId));
            return fv;
        }
        throw new SQLException();
    }

    public boolean delete(String[] foldersId, String[] filesId) throws Exception {
        int i;
        this.gono = true;
        for (i = 0; i < filesId.length && this.gono; ++i) {
            this.deleteFile(filesId[i]);
        }
        for (i = 0; i < foldersId.length && this.gono; ++i) {
            this.deleteFolder(foldersId[i]);
        }
        return this.gono;
    }

    public boolean exportTo(String[] foldersId, String[] nodesId, File path, String type) throws Exception {
        int i;
        this.gono = true;
        for (i = 0; i < nodesId.length && this.gono; ++i) {
            this.exportNode(nodesId[i], path, type);
        }
        for (i = 0; i < foldersId.length && this.gono; ++i) {
            this.exportFolder(foldersId[i], path, type);
        }
        return this.gono;
    }

    public int hasExistsFilesOrFolders(File[] files, String folderId) throws SQLException {
        int result = 0;
        List<Folder> folders = this.getFoldersByParentId(folderId);
        List<Node> nodes = this.selectNodesByFolderId(folderId);
        for (File f : files) {
            if (f.isDirectory() && folders.parallelStream().anyMatch(e -> e.getFolderName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) {
                ++result;
                continue;
            }
            if (!nodes.parallelStream().anyMatch(e -> e.getFileName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) continue;
            ++result;
        }
        return result;
    }

    public int hasExistsFilesOrFolders(String[] foldersId, String[] filesId, File path) throws Exception {
        if (path.isDirectory()) {
            int c = 0;
            ArrayList<Folder> folders = new ArrayList<Folder>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String fid : foldersId) {
                folders.add(this.selectFolderById(fid));
            }
            for (String nid : filesId) {
                nodes.add(this.selectNodeById(nid));
            }
            for (File f : path.listFiles()) {
                if (f.isDirectory() && folders.parallelStream().anyMatch(e -> e.getFolderName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) {
                    ++c;
                    continue;
                }
                if (!nodes.parallelStream().anyMatch(e -> e.getFileName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) continue;
                ++c;
            }
            return c;
        }
        throw new IllegalArgumentException();
    }

    public boolean importFrom(File[] files, String folderId, String type) throws Exception {
        this.gono = true;
        for (int i = 0; i < files.length && this.gono; ++i) {
            if (files[i].isDirectory()) {
                this.importFolderInto(files[i], folderId, type);
                continue;
            }
            this.importFileInto(files[i], folderId, type);
        }
        return this.gono;
    }

    public List<Folder> getFoldersByParentId(String folderId) throws SQLException {
        this.selectFoldersByParentFolderId.setString(1, folderId);
        ResultSet r = this.selectFoldersByParentFolderId.executeQuery();
        ArrayList<Folder> folders = new ArrayList<Folder>();
        while (r.next()) {
            folders.add(this.resultSetAccessFolder(r));
        }
        return folders;
    }

    public Folder selectFolderById(String folderId) throws SQLException {
        this.selectFolderById.setString(1, folderId);
        ResultSet r = this.selectFolderById.executeQuery();
        if (r.next()) {
            return this.resultSetAccessFolder(r);
        }
        return null;
    }

    private Node selectNodeById(String nodeId) throws SQLException {
        this.selectNodeById.setString(1, nodeId);
        ResultSet r = this.selectNodeById.executeQuery();
        if (r.next()) {
            return this.resultSetAccessNode(r);
        }
        return null;
    }

    public List<Node> selectNodesByFolderId(String folderId) throws SQLException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.selectNodesByFolderId.setString(1, folderId);
        ResultSet r = this.selectNodesByFolderId.executeQuery();
        while (r.next()) {
            nodes.add(this.resultSetAccessNode(r));
        }
        return nodes;
    }

    private List<Node> selectNodesByPathExcludeById(String path, String fileId) throws SQLException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.selectNodesByPathExcludeById.setString(1, path);
        this.selectNodesByPathExcludeById.setString(2, fileId);
        ResultSet r = this.selectNodesByPathExcludeById.executeQuery();
        while (r.next()) {
            nodes.add(this.resultSetAccessNode(r));
        }
        return nodes;
    }

    private int insertNode(Node n) throws SQLException {
        this.insertNode.setString(1, n.getFileId());
        this.insertNode.setString(2, n.getFileName());
        this.insertNode.setString(3, n.getFileSize());
        this.insertNode.setString(4, n.getFileParentFolder());
        this.insertNode.setString(5, n.getFileCreationDate());
        this.insertNode.setString(6, n.getFileCreator());
        this.insertNode.setString(7, n.getFilePath());
        this.insertNode.execute();
        return this.insertNode.getUpdateCount();
    }

    private int insertFolder(Folder f) throws SQLException {
        this.insertFolder.setString(1, f.getFolderId());
        this.insertFolder.setString(2, f.getFolderName());
        this.insertFolder.setString(3, f.getFolderCreationDate());
        this.insertFolder.setString(4, f.getFolderCreator());
        this.insertFolder.setString(5, f.getFolderParent());
        this.insertFolder.setInt(6, f.getFolderConstraint());
        this.insertFolder.execute();
        return this.insertFolder.getUpdateCount();
    }

    private Node resultSetAccessNode(ResultSet r) throws SQLException {
        Node node = new Node();
        node.setFileId(r.getString("file_id"));
        node.setFileName(r.getString("file_name"));
        node.setFileSize(r.getString("file_size"));
        node.setFileParentFolder(r.getString("file_parent_folder"));
        node.setFileCreationDate(r.getString("file_creation_date"));
        node.setFileCreator(r.getString("file_creator"));
        node.setFilePath(r.getString("file_path"));
        return node;
    }

    private Folder resultSetAccessFolder(ResultSet r) throws SQLException {
        Folder folder = new Folder();
        folder.setFolderId(r.getString("folder_id"));
        folder.setFolderName(r.getString("folder_name"));
        folder.setFolderParent(r.getString("folder_parent"));
        folder.setFolderCreationDate(r.getString("folder_creation_date"));
        folder.setFolderCreator(r.getString("folder_creator"));
        folder.setFolderConstraint(r.getInt("folder_constraint"));
        return folder;
    }

    private void importFileInto(File f, String folderId, String type) throws Exception {
        if (f.isFile()) {
            String name;
            String newName = name = f.getName();
            per = 0;
            message = "\u6b63\u5728\u5bfc\u5165\u6587\u4ef6\uff1a" + name;
            long size = f.length();
            List<Node> nodes = this.selectNodesByFolderId(folderId);
            if (nodes.parallelStream().anyMatch(e -> e.getFileName().equals(name))) {
                switch (type) {
                    case "COVER": {
                        Node node = nodes.parallelStream().filter(e -> e.getFileName().equals(f.getName())).findFirst().get();
                        this.deleteFile(node.getFileId());
                        if (this.selectNodeById(node.getFileId()) == null) break;
                        throw new IOException();
                    }
                    case "BOTH": {
                        newName = FileNodeUtil.getNewNodeName(name, nodes);
                        break;
                    }
                    default: {
                        per = 100;
                        return;
                    }
                }
            }
            if (this.getFilesTotalNumByFoldersId(folderId) >= Integer.MAX_VALUE) {
                throw new FilesTotalOutOfLimitException();
            }
            Node node = new Node();
            node.setFileName(newName);
            node.setFileId(UUID.randomUUID().toString());
            node.setFileParentFolder(folderId);
            node.setFileCreationDate(ServerTimeUtil.accurateToDay());
            node.setFileCreator(ConfigureReader.instance().getImportAccount());
            node.setFileSize(Long.toString(size));
            File block = this.saveToFileBlocks(f);
            if (block == null) {
                throw new IOException();
            }
            node.setFilePath(block.getName());
            int i = 0;
            while (true) {
                try {
                    if (this.insertNode(node) > 0 && this.selectFolderById(folderId) != null) {
                        return;
                    }
                }
                catch (Exception e2) {
                    node.setFileId(UUID.randomUUID().toString());
                    if (++i < 10) continue;
                }
                break;
            }
            block.delete();
            this.deleteNodeById(node.getFileId());
            throw new SQLException();
        }
        throw new IllegalArgumentException();
    }

    private void importFolderInto(File f, String folderId, String type) throws Exception {
        if (f.isDirectory()) {
            int i;
            kohgylw.kiftd.server.model.Folder folder;
            block22: {
                String name;
                String newName = name = f.getName();
                per = 0;
                message = "\u6b63\u5728\u5bfc\u5165\u6587\u4ef6\u5939\uff1a" + name;
                Folder parent = this.selectFolderById(folderId);
                List<Folder> folders = this.getFoldersByParentId(folderId);
                folder = null;
                if (folders.parallelStream().anyMatch(e -> e.getFolderName().equals(name))) {
                    switch (type) {
                        case "COVER": {
                            folder = folders.parallelStream().filter(e -> e.getFolderName().equals(name)).findFirst().get();
                            break;
                        }
                        case "BOTH": {
                            newName = FileNodeUtil.getNewFolderName(name, folders);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                per = 50;
                if (folder == null) {
                    if (this.getFoldersTotalNumByFoldersId(folderId) >= Integer.MAX_VALUE) {
                        throw new FoldersTotalOutOfLimitException();
                    }
                    folder = new Folder();
                    String nFolderId = UUID.randomUUID().toString();
                    folder.setFolderId(nFolderId);
                    folder.setFolderName(newName);
                    folder.setFolderConstraint(parent.getFolderConstraint());
                    folder.setFolderParent(folderId);
                    if ("root".equals(parent.getFolderId())) {
                        folder.setFolderCreator(ConfigureReader.instance().getImportAccount());
                    } else {
                        folder.setFolderCreator(parent.getFolderCreator());
                    }
                    folder.setFolderCreationDate(ServerTimeUtil.accurateToDay());
                    i = 0;
                    while (true) {
                        try {
                            if (this.insertFolder((Folder)folder) == 0 || this.selectFolderById(folderId) == null) {
                                this.deleteFolderById(folder.getFolderId());
                                throw new SQLException();
                            }
                            break block22;
                        }
                        catch (Exception e2) {
                            folder.setFolderId(UUID.randomUUID().toString());
                            if (++i < 10) continue;
                        }
                        break;
                    }
                }
                folder.setFolderCreationDate(ServerTimeUtil.accurateToDay());
                if (this.updateFolder((Folder)folder) == 0 || this.selectFolderById(folderId) == null) {
                    this.deleteFolderById(folder.getFolderId());
                    throw new SQLException();
                }
            }
            per = 100;
            File[] childs = f.listFiles();
            for (i = 0; i < childs.length && this.gono; ++i) {
                if (childs[i].isDirectory()) {
                    this.importFolderInto(childs[i], folder.getFolderId(), type);
                    continue;
                }
                this.importFileInto(childs[i], folder.getFolderId(), type);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private int deleteNodeById(String nodeId) throws SQLException {
        this.deleteNodeById.setString(1, nodeId);
        this.deleteNodeById.execute();
        return this.deleteNodeById.getUpdateCount();
    }

    private int deleteFolderById(String folderId) throws SQLException {
        this.deleteFolderById.setString(1, folderId);
        this.deleteFolderById.execute();
        return this.deleteFolderById.getUpdateCount();
    }

    private int updateFolder(Folder f) throws SQLException {
        this.updateFolderById.setString(1, f.getFolderName());
        this.updateFolderById.setString(2, f.getFolderCreationDate());
        this.updateFolderById.setString(3, f.getFolderCreator());
        this.updateFolderById.setString(4, f.getFolderParent());
        this.updateFolderById.setInt(5, f.getFolderConstraint());
        this.updateFolderById.setString(6, f.getFolderId());
        this.updateFolderById.execute();
        return this.updateFolderById.getUpdateCount();
    }

    private void deleteFolder(String folderId) throws Exception {
        Folder f = this.selectFolderById(folderId);
        List<Node> nodes = this.selectNodesByFolderId(folderId);
        int size = nodes.size();
        if (f == null) {
            return;
        }
        per = 0;
        message = "\u6b63\u5728\u5220\u9664\u6587\u4ef6\u5939\uff1a" + f.getFolderName();
        for (int i = 0; i < size && this.gono; ++i) {
            this.deleteFile(nodes.get(i).getFileId());
        }
        List<Folder> folders = this.getFoldersByParentId(folderId);
        size = folders.size();
        for (int i = 0; i < size && this.gono; ++i) {
            this.deleteFolder(folders.get(i).getFolderId());
        }
        per = 50;
        if (this.deleteFolderById(folderId) > 0) {
            per = 100;
            return;
        }
        throw new SQLException();
    }

    private void deleteFile(String nodeId) throws SQLException, IOException {
        Node n = this.selectNodeById(nodeId);
        per = 50;
        message = "\u6b63\u5728\u5220\u9664\u6587\u4ef6\uff1a" + n.getFileName();
        if (n != null) {
            if (this.deleteNodeById(nodeId) > 0) {
                per = 80;
                List<Node> nodes = this.selectNodesByPathExcludeById(n.getFilePath(), n.getFileId());
                String recycleBinPath = ConfigureReader.instance().getRecycleBinPath();
                File block = this.getFileFormBlocks(n);
                if (nodes == null || nodes.isEmpty()) {
                    if (block != null) {
                        if (recycleBinPath != null) {
                            if (this.saveToRecycleBin(block, recycleBinPath, n.getFileName(), false)) {
                                per = 100;
                                return;
                            }
                        } else if (block.delete()) {
                            per = 100;
                            return;
                        }
                    }
                } else if (block != null) {
                    if (recycleBinPath != null) {
                        if (this.saveToRecycleBin(block, recycleBinPath, n.getFileName(), true)) {
                            per = 100;
                            return;
                        }
                    } else {
                        per = 100;
                        return;
                    }
                }
            }
            throw new SQLException();
        }
    }

    private boolean saveToRecycleBin(File block, String recycleBinPath, String originalName, boolean isCopy) throws IOException {
        File dateDir;
        File recycleBinDir = new File(recycleBinPath);
        if (recycleBinDir.isDirectory() && ((dateDir = new File(recycleBinDir, ServerTimeUtil.accurateToLogName())).isDirectory() || dateDir.mkdir())) {
            int i = 0;
            List<String> fileNames = Arrays.asList(dateDir.list());
            String newName = originalName;
            while (fileNames.contains(newName)) {
                ++i;
                if (originalName.indexOf(".") >= 0) {
                    newName = originalName.substring(0, originalName.lastIndexOf(".")) + " (" + i + ")" + originalName.substring(originalName.lastIndexOf("."));
                    continue;
                }
                newName = originalName + " (" + i + ")";
            }
            File saveFile = new File(dateDir, newName);
            if (isCopy) {
                Files.copy(block.toPath(), saveFile.toPath(), new CopyOption[0]);
            } else {
                Files.move(block.toPath(), saveFile.toPath(), new CopyOption[0]);
            }
            return true;
        }
        return false;
    }

    private void exportNode(String nodeId, File path, String type) throws Exception {
        Node node = this.selectNodeById(nodeId);
        File target = null;
        if (node != null && path != null && path.isDirectory()) {
            per = 0;
            message = "\u6b63\u5728\u5bfc\u51fa\u6587\u4ef6\uff1a" + node.getFileName();
            if (((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isFile()).anyMatch(f -> new String(f.getName().getBytes()).equals(node.getFileName()))) {
                switch (type) {
                    case "COVER": {
                        target = ((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isFile()).filter(e -> new String(e.getName().getBytes()).equals(node.getFileName())).findFirst().get();
                        break;
                    }
                    case "BOTH": {
                        target = new File(path, new String(FileNodeUtil.getNewNodeName(node, path).getBytes()));
                        target.createNewFile();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (target == null) {
                target = new File(path, new String(node.getFileName().getBytes()));
                target.createNewFile();
            }
            File block = this.getFileFormBlocks(node);
            long size = block.length();
            FileInputStream in = new FileInputStream(block);
            FileOutputStream out = new FileOutputStream(target);
            FileChannel fci = in.getChannel();
            FileChannel fco = out.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            int length = 0;
            long finishLength = 0L;
            while ((length = fci.read(buffer)) != -1 && this.gono) {
                buffer.flip();
                fco.write(buffer);
                buffer.clear();
                per = (int)((double)(finishLength += (long)length) / (double)size * 100.0);
            }
            fci.close();
            fco.close();
            in.close();
            out.close();
            return;
        }
        throw new IllegalArgumentException();
    }

    private void exportFolder(String folderId, File path, String type) throws Exception {
        Folder folder = this.selectFolderById(folderId);
        File target = null;
        per = 0;
        message = "\u6b63\u5728\u5bfc\u51fa\u6587\u4ef6\u5939\uff1a" + folder.getFolderName();
        if (folder != null && path != null && path.isDirectory()) {
            if (((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isDirectory()).anyMatch(f -> new String(f.getName().getBytes()).equals(folder.getFolderName()))) {
                switch (type) {
                    case "COVER": {
                        target = ((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isDirectory()).filter(e -> new String(e.getName().getBytes()).equals(folder.getFolderName())).findFirst().get();
                        break;
                    }
                    case "BOTH": {
                        target = new File(path, new String(FileNodeUtil.getNewFolderName(folder, path).getBytes()));
                        target.mkdir();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isFile()).anyMatch(e -> new String(e.getName().getBytes()).equals(folder.getFolderName()))) {
                target = new File(path, new String(folder.getFolderName().getBytes()) + "_\u4e0e\u6587\u4ef6\u540c\u540d" + UUID.randomUUID().toString().replaceAll("-", ""));
                target.mkdir();
            }
            if (target == null) {
                target = new File(path, new String(folder.getFolderName().getBytes()));
                target.mkdir();
            }
            per = 100;
            List<Node> nodes = this.selectNodesByFolderId(folderId);
            List<Folder> folders = this.getFoldersByParentId(folderId);
            int size = 0;
            int i = 0;
            size = nodes.size();
            for (i = 0; i < size && this.gono; ++i) {
                this.exportNode(nodes.get(i).getFileId(), target, type);
            }
            size = folders.size();
            for (i = 0; i < size && this.gono; ++i) {
                this.exportFolder(folders.get(i).getFolderId(), target, type);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void cannel() {
        message = "\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u5019...";
        this.gono = false;
    }

    private File getFileFormBlocks(Node f) {
        try {
            File file = null;
            if (f.getFilePath().startsWith("file_")) {
                file = new File(ConfigureReader.instance().getFileBlockPath(), f.getFilePath());
            } else {
                short index = Short.parseShort(f.getFilePath().substring(0, f.getFilePath().indexOf(95)));
                file = new File(ConfigureReader.instance().getExtendStores().parallelStream().filter(e -> e.getIndex() == index).findAny().get().getPath(), f.getFilePath());
            }
            if (file.isFile()) {
                return file;
            }
        }
        catch (Exception e2) {
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u6570\u636e\u8bfb\u53d6\u5931\u8d25\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e2.getMessage());
        }
        return null;
    }

    public File saveToFileBlocks(File f) {
        List<ExtendStores> ess = ConfigureReader.instance().getExtendStores();
        if (ess.size() > 0) {
            Collections.sort(ess, new Comparator<ExtendStores>(){

                @Override
                public int compare(ExtendStores o1, ExtendStores o2) {
                    try {
                        return o1.getPath().list().length - o2.getPath().list().length;
                    }
                    catch (Exception e) {
                        try {
                            long dValue = Files.list(o1.getPath().toPath()).count() - Files.list(o2.getPath().toPath()).count();
                            return dValue > 0L ? 1 : (dValue == 0L ? 0 : -1);
                        }
                        catch (IOException e1) {
                            return 0;
                        }
                    }
                }
            });
            for (ExtendStores es : ess) {
                if (es.getPath().getFreeSpace() <= f.length()) continue;
                try {
                    File file = this.createNewBlock(es.getIndex() + "_", es.getPath());
                    if (file == null) continue;
                    this.transferFile(f, file);
                    return file;
                }
                catch (IOException e) {
                }
                catch (Exception e) {
                    Printer.instance.print(e.getMessage());
                }
            }
        }
        try {
            File target = this.createNewBlock("file_", new File(ConfigureReader.instance().getFileBlockPath()));
            if (target != null) {
                this.transferFile(f, target);
                return target;
            }
        }
        catch (Exception e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u5757\u751f\u6210\u5931\u8d25\uff0c\u65e0\u6cd5\u5b58\u5165\u65b0\u7684\u6587\u4ef6\u6570\u636e\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return null;
    }

    private File createNewBlock(String prefix, File parent) throws IOException {
        int appendIndex = 0;
        int retryNum = 0;
        String newName = prefix + UUID.randomUUID().toString().replace("-", "");
        File newBlock = new File(parent, newName + ".block");
        while (!newBlock.createNewFile()) {
            if (appendIndex >= 0 && appendIndex < Integer.MAX_VALUE) {
                newBlock = new File(parent, newName + "_" + appendIndex + ".block");
                ++appendIndex;
                continue;
            }
            if (retryNum >= 5) {
                return null;
            }
            newName = prefix + UUID.randomUUID().toString().replace("-", "");
            newBlock = new File(parent, newName + ".block");
            ++retryNum;
        }
        return newBlock;
    }

    private void transferFile(File f, File target) throws Exception {
        long size = f.length();
        FileInputStream fileInputStream = new FileInputStream(f);
        FileOutputStream fileOutputStream = new FileOutputStream(target);
        BufferedInputStream in = new BufferedInputStream(fileInputStream);
        BufferedOutputStream out = new BufferedOutputStream(fileOutputStream);
        byte[] buffer = new byte[4096];
        int length = 0;
        long finishLength = 0L;
        while ((length = in.read(buffer)) != -1 && this.gono) {
            out.write(buffer, 0, length);
            per = (int)((double)(finishLength += (long)length) / (double)size * 100.0);
        }
        in.close();
        out.flush();
        out.close();
    }

    public long getFilesTotalNumByFoldersId(String pfId) throws SQLException {
        if (pfId != null) {
            this.countNodesByFolderId.setString(1, pfId);
            ResultSet rs = this.countNodesByFolderId.executeQuery();
            if (rs.next()) {
                return rs.getLong(1);
            }
        }
        return 0L;
    }

    public long getFoldersTotalNumByFoldersId(String pfId) throws SQLException {
        if (pfId != null) {
            this.countFoldersByParentFolderId.setString(1, pfId);
            ResultSet rs = this.countFoldersByParentFolderId.executeQuery();
            if (rs.next()) {
                return rs.getLong(1);
            }
        }
        return 0L;
    }

    public boolean transferExtendStore(short index, File reservePath) throws SQLException, IOException {
        List<Node> nodes = this.selectNodesByExtendStoreIndex(index);
        int total = nodes.size();
        if (reservePath != null && reservePath.isDirectory()) {
            per = 0;
            message = "\u6b63\u5728\u79fb\u51fa\u6570\u636e...";
            this.gono = true;
            for (int i = 0; i < total && this.gono; ++i) {
                message = "\u6b63\u5728\u79fb\u51fa\u6570\u636e(" + i + "/" + total + ")...";
                per = (int)((double)i / (double)total * 100.0);
                Node n = nodes.get(i);
                File b = this.getFileFormBlocks(n);
                File parentFolder = new File(reservePath, this.getNativePath(n));
                if (!parentFolder.isDirectory() && !parentFolder.mkdirs()) {
                    return false;
                }
                File target = new File(parentFolder, n.getFileName());
                Files.move(b.toPath(), target.toPath(), new CopyOption[0]);
                this.deleteNodeById(n.getFileId());
            }
            return this.gono;
        }
        return false;
    }

    public long getTotalOfNodesAtExtendStore(short index) throws SQLException {
        return this.countNodesByExtendStoreIndex(index);
    }

    private long countNodesByExtendStoreIndex(short index) throws SQLException {
        this.countNodesByExtendStoreIndex.setString(1, index + "\\_%");
        ResultSet rs = this.countNodesByExtendStoreIndex.executeQuery();
        if (rs.first()) {
            return rs.getLong(1);
        }
        return 0L;
    }

    private List<Node> selectNodesByExtendStoreIndex(short index) throws SQLException {
        this.selectNodesByExtendStoreIndex.setString(1, index + "\\_%");
        ArrayList<Node> nodes = new ArrayList<Node>();
        ResultSet rs = this.selectNodesByExtendStoreIndex.executeQuery();
        while (rs.next()) {
            nodes.add(this.resultSetAccessNode(rs));
        }
        return nodes;
    }

    private String getNativePath(Node n) throws SQLException {
        ArrayList<String> parentList = new ArrayList<String>();
        Folder f = this.selectFolderById(n.getFileParentFolder());
        while (f != null) {
            parentList.add(f.getFolderName());
            if (f.getFolderParent().equals("null")) break;
            f = this.selectFolderById(f.getFolderParent());
        }
        StringBuffer np = new StringBuffer();
        for (int i = parentList.size() - 1; i >= 0; --i) {
            np.append((String)parentList.get(i));
            np.append(File.separator);
        }
        return np.toString();
    }
}

