/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.util;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kohgylw.kiftd.ui.pojo.FileSystemPath;

public class PathsTable
extends JTable {
    private static final String[] columns = new String[]{"\u7c7b\u578b\uff08\u7f16\u53f7\uff09", "\u8def\u5f84"};
    float[] columnWidthPercentage = new float[]{20.0f, 80.0f};
    private static final Map<Integer, Short> shownFileSystemPath = new HashMap<Integer, Short>();
    private static final long serialVersionUID = -3436472714356711024L;

    public PathsTable() {
        super(new Object[0][], columns);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                PathsTable.this.resizeColumns();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void updateValues(final List<FileSystemPath> paths) {
        Runnable doUpdate = new Runnable(){

            @Override
            public void run() {
                shownFileSystemPath.clear();
                try {
                    PathsTable.this.setModel(new TableModel(){

                        @Override
                        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                        }

                        @Override
                        public void removeTableModelListener(TableModelListener l) {
                        }

                        @Override
                        public boolean isCellEditable(int rowIndex, int columnIndex) {
                            return false;
                        }

                        @Override
                        public Object getValueAt(int rowIndex, int columnIndex) {
                            switch (columnIndex) {
                                case 0: {
                                    shownFileSystemPath.put(rowIndex, ((FileSystemPath)paths.get(rowIndex)).getIndex());
                                    return ((FileSystemPath)paths.get(rowIndex)).getType() + "\uff08" + ((FileSystemPath)paths.get(rowIndex)).getIndex() + "\uff09";
                                }
                                case 1: {
                                    return ((FileSystemPath)paths.get(rowIndex)).getPath().getAbsoluteFile();
                                }
                            }
                            return "--";
                        }

                        @Override
                        public int getRowCount() {
                            return paths.size();
                        }

                        @Override
                        public String getColumnName(int columnIndex) {
                            return columns[columnIndex];
                        }

                        @Override
                        public int getColumnCount() {
                            return columns.length;
                        }

                        @Override
                        public Class<?> getColumnClass(int columnIndex) {
                            return String.class;
                        }

                        @Override
                        public void addTableModelListener(TableModelListener l) {
                        }
                    });
                    PathsTable.this.resizeColumns();
                    PathsTable.this.validate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(() -> SwingUtilities.invokeLater(doUpdate));
        t.start();
    }

    public short getSelectFileSystemIndex() {
        if (this.getSelectedRow() >= 0) {
            return shownFileSystemPath.get(this.getSelectedRow());
        }
        return -1;
    }

    private void resizeColumns() {
        int tW = this.getWidth();
        TableColumnModel jTableColumnModel = this.getColumnModel();
        int cantCols = jTableColumnModel.getColumnCount();
        for (int i = 0; i < cantCols; ++i) {
            TableColumn column = jTableColumnModel.getColumn(i);
            int pWidth = Math.round(this.columnWidthPercentage[i] * (float)tW);
            column.setPreferredWidth(pWidth);
        }
    }
}

