/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.util;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.util.file_system_manager.pojo.Folder;

public class FilesTable
extends JTable {
    private static final String[] columns = new String[]{"\u540d\u79f0", "\u521b\u5efa\u65e5\u671f", "\u5927\u5c0f", "\u521b\u5efa\u8005"};
    private static List<Folder> folders;
    private static List<Node> files;
    public static final int MAX_LIST_LIMIT = Integer.MAX_VALUE;
    private int sortByName = 1;
    private int sortByDate = 1;
    private static SimpleDateFormat cdf;
    private int sortBySize = 1;
    private int sortByCreator = 1;
    private static final long serialVersionUID = -3436472714356711024L;

    public FilesTable() {
        super(new Object[0][], columns);
        final JTableHeader filesTableHeader = this.getTableHeader();
        filesTableHeader.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = filesTableHeader.columnAtPoint(e.getPoint());
                switch (col) {
                    case 0: {
                        files.sort((e1, e2) -> FilesTable.this.sortByName * e1.getFileName().compareTo(e2.getFileName()));
                        folders.sort((e1, e2) -> FilesTable.this.sortByName * e1.getFolderName().compareTo(e2.getFolderName()));
                        FilesTable.this.sortByName = FilesTable.this.sortByName * -1;
                        FilesTable.this.sortByDate = 1;
                        FilesTable.this.sortBySize = 1;
                        FilesTable.this.sortByCreator = 1;
                        break;
                    }
                    case 1: {
                        files.sort((e1, e2) -> {
                            try {
                                return FilesTable.this.sortByDate * cdf.parse(e1.getFileCreationDate()).compareTo(cdf.parse(e2.getFileCreationDate()));
                            }
                            catch (ParseException e3) {
                                Printer.instance.print(e3.toString());
                                return 0;
                            }
                        });
                        folders.sort((e1, e2) -> {
                            try {
                                return FilesTable.this.sortByDate * cdf.parse(e1.getFolderCreationDate()).compareTo(cdf.parse(e2.getFolderCreationDate()));
                            }
                            catch (ParseException e3) {
                                Printer.instance.print(e3.toString());
                                return 0;
                            }
                        });
                        FilesTable.this.sortByDate = FilesTable.this.sortByDate * -1;
                        FilesTable.this.sortByName = 1;
                        FilesTable.this.sortBySize = 1;
                        FilesTable.this.sortByCreator = 1;
                        break;
                    }
                    case 2: {
                        files.sort((e1, e2) -> FilesTable.this.sortBySize * Long.compare(Long.parseLong(e1.getFileSize()), Long.parseLong(e2.getFileSize())));
                        FilesTable.this.sortBySize = FilesTable.this.sortBySize * -1;
                        FilesTable.this.sortByName = 1;
                        FilesTable.this.sortByDate = 1;
                        FilesTable.this.sortByCreator = 1;
                        break;
                    }
                    case 3: {
                        files.sort((e1, e2) -> FilesTable.this.sortByCreator * e1.getFileCreator().compareTo(e2.getFileCreator()));
                        folders.sort((e1, e2) -> FilesTable.this.sortByCreator * e1.getFolderCreator().compareTo(e2.getFolderCreator()));
                        FilesTable.this.sortByCreator = FilesTable.this.sortByCreator * -1;
                        FilesTable.this.sortByName = 1;
                        FilesTable.this.sortByDate = 1;
                        FilesTable.this.sortBySize = 1;
                        break;
                    }
                }
                FilesTable.this.updateValues(folders, files);
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void updateValues(final List<Folder> folders, final List<Node> files) {
        try {
            this.setModel(new TableModel(){

                @Override
                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                }

                @Override
                public void removeTableModelListener(TableModelListener l) {
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return rowIndex < folders.size() ? "/" + ((Folder)folders.get(rowIndex)).getFolderName() : ((Node)files.get(rowIndex - folders.size())).getFileName();
                        }
                        case 1: {
                            return rowIndex < folders.size() ? ((Folder)folders.get(rowIndex)).getFolderCreationDate() : ((Node)files.get(rowIndex - folders.size())).getFileCreationDate();
                        }
                        case 2: {
                            return rowIndex < folders.size() ? "--" : ((Node)files.get(rowIndex - folders.size())).getFileSize();
                        }
                        case 3: {
                            return rowIndex < folders.size() ? ((Folder)folders.get(rowIndex)).getFolderCreator() : ((Node)files.get(rowIndex - folders.size())).getFileCreator();
                        }
                    }
                    return "--";
                }

                @Override
                public int getRowCount() {
                    long totalSize = folders.size() + files.size();
                    return totalSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalSize;
                }

                @Override
                public String getColumnName(int columnIndex) {
                    return columns[columnIndex];
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return Object.class;
                }

                @Override
                public void addTableModelListener(TableModelListener l) {
                }
            });
            this.setRowFontColor();
            this.validate();
            FilesTable.folders = folders;
            FilesTable.files = files;
        }
        catch (Exception e) {
            Printer.instance.print(e.toString());
        }
    }

    private void setRowFontColor() {
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 5132133158132959506L;

            @Override
            protected void setValue(Object value) {
                if (value instanceof String && ((String)value).startsWith("/")) {
                    this.setForeground(Color.BLUE);
                } else {
                    this.setForeground(Color.black);
                }
                this.setText((String)value);
            }
        };
        DefaultTableCellRenderer dtcr2 = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 5132133158132959506L;

            @Override
            protected void setValue(Object value) {
                if (!"--".equals(value) && value instanceof String) {
                    String unit;
                    double convertSize;
                    long size = Long.parseLong((String)value);
                    if (size < 1024L) {
                        convertSize = size;
                        unit = "B";
                    } else if (size < 0x100000L) {
                        convertSize = (double)size / 1024.0;
                        unit = "KB";
                    } else if (size < 0x40000000L) {
                        convertSize = (double)size / 1048576.0;
                        unit = "MB";
                    } else if (size < 0x10000000000L) {
                        convertSize = (double)size / 1.073741824E9;
                        unit = "GB";
                    } else {
                        convertSize = (double)size / 1.099511627776E12;
                        unit = "TB";
                    }
                    this.setText(String.format("%.1f", convertSize) + " " + unit);
                    return;
                }
                this.setText((String)value);
            }
        };
        this.getColumn(columns[0]).setCellRenderer(dtcr);
        this.getColumn(columns[2]).setCellRenderer(dtcr2);
    }

    public Object getDoubleClickItem(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            int row = this.rowAtPoint(e.getPoint());
            if (row >= 0 && row < folders.size()) {
                return folders.get(row);
            }
            if (row >= folders.size() && row < folders.size() + files.size()) {
                return files.get(row - folders.size());
            }
        }
        return null;
    }

    static {
        cdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    }
}

