/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.module;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.enumeration.LogLevel;
import kohgylw.kiftd.server.enumeration.VCLevel;
import kohgylw.kiftd.server.pojo.ExtendStores;
import kohgylw.kiftd.server.pojo.ServerSetting;
import kohgylw.kiftd.ui.callback.GetServerStatus;
import kohgylw.kiftd.ui.callback.UpdateSetting;
import kohgylw.kiftd.ui.module.FileSystemPathViewer;
import kohgylw.kiftd.ui.module.KiftdDynamicWindow;
import kohgylw.kiftd.ui.module.ServerUIModule;
import kohgylw.kiftd.ui.pojo.FileSystemPath;

public class SettingWindow
extends KiftdDynamicWindow {
    protected static JDialog window;
    private static JTextField portinput;
    private static JTextField bufferinput;
    private static JComboBox<String> mlinput;
    private static JComboBox<String> vcinput;
    private static JComboBox<String> logLevelinput;
    private static JComboBox<String> changePwdinput;
    private static JComboBox<String> showChaininput;
    private static JButton cancel;
    private static JButton update;
    private static JButton changeFileSystemPath;
    protected static File chooserPath;
    protected static List<FileSystemPath> extendStores;
    private static SettingWindow sw;
    private static final String ML_OPEN = "\u662f(YES)";
    private static final String ML_CLOSE = "\u5426(CLOSE)";
    private static final String VC_STANDARD = "\u6807\u51c6(STANDARD)";
    private static final String VC_SIMP = "\u7b80\u5316(SIMPLIFIED)";
    private static final String VC_CLOSE = "\u5173\u95ed(CLOSE)";
    private static final String CHANGE_PWD_OPEN = "\u542f\u7528(ALLOW)";
    private static final String CHANGE_PWD_CLOSE = "\u7981\u7528(PROHIBIT)";
    private static final String SHOW_CHAIN_OPEN = "\u542f\u7528(OPEN)";
    private static final String SHOW_CHAIN_CLOSE = "\u7981\u7528(CLOSE)";
    protected static GetServerStatus st;
    protected static UpdateSetting us;
    private static FileSystemPathViewer fspv;

    private SettingWindow() {
        this.setUIFont();
        window = new JDialog((Frame)ServerUIModule.window, "kiftd-\u8bbe\u7f6e");
        window.setModal(true);
        window.setSize(420, 425);
        window.setLocation(150, 150);
        window.setDefaultCloseOperation(1);
        window.setResizable(false);
        window.setLayout(new BoxLayout(window.getContentPane(), 3));
        JPanel titlebox = new JPanel(new FlowLayout(1));
        titlebox.setBorder(new EmptyBorder(0, 0, (int)(7.0 * this.proportion), 0));
        JLabel title = new JLabel("\u670d\u52a1\u5668\u8bbe\u7f6e Server Setting");
        title.setFont(new Font("\u5b8b\u4f53", 1, (int)(20.0 * this.proportion)));
        titlebox.add(title);
        window.add(titlebox);
        JPanel settingbox = new JPanel(new GridLayout(8, 1, 0, 0));
        settingbox.setBorder(new EtchedBorder());
        boolean interval = false;
        JPanel mlbox = new JPanel(new FlowLayout(1));
        mlbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel mltitle = new JLabel("\u5fc5\u987b\u767b\u5165(must login)\uff1a");
        mlinput = new JComboBox<String>();
        mlinput.addItem(ML_OPEN);
        mlinput.addItem(ML_CLOSE);
        mlinput.setPreferredSize(new Dimension((int)(170.0 * this.proportion), (int)(20.0 * this.proportion)));
        mlbox.add(mltitle);
        mlbox.add(mlinput);
        JPanel vcbox = new JPanel(new FlowLayout(1));
        vcbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel vctitle = new JLabel("\u767b\u5f55\u9a8c\u8bc1\u7801(VC type)\uff1a");
        vcinput = new JComboBox<String>();
        vcinput.addItem(VC_STANDARD);
        vcinput.addItem(VC_SIMP);
        vcinput.addItem(VC_CLOSE);
        mlinput.setPreferredSize(new Dimension((int)(170.0 * this.proportion), (int)(20.0 * this.proportion)));
        vcbox.add(vctitle);
        vcbox.add(vcinput);
        JPanel portbox = new JPanel(new FlowLayout(1));
        portbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel porttitle = new JLabel("\u7aef\u53e3(port)\uff1a");
        portinput = new JTextField();
        portinput.setPreferredSize(new Dimension((int)(120.0 * this.proportion), (int)(25.0 * this.proportion)));
        portbox.add(porttitle);
        portbox.add(portinput);
        JPanel bufferbox = new JPanel(new FlowLayout(1));
        bufferbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel buffertitle = new JLabel("\u7f13\u5b58\u5927\u5c0f(buffer)\uff1a");
        bufferinput = new JTextField();
        bufferinput.setPreferredSize(new Dimension((int)(170.0 * this.proportion), (int)(25.0 * this.proportion)));
        JLabel bufferUnit = new JLabel("KB");
        bufferbox.add(buffertitle);
        bufferbox.add(bufferinput);
        bufferbox.add(bufferUnit);
        JPanel logbox = new JPanel(new FlowLayout(1));
        logbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel logtitle = new JLabel("\u65e5\u5fd7\u7b49\u7ea7(port)\uff1a");
        logLevelinput = new JComboBox<String>();
        logLevelinput.addItem("\u8bb0\u5f55\u5168\u90e8(ALL)");
        logLevelinput.addItem("\u4ec5\u5f02\u5e38(EXCEPTION)");
        logLevelinput.addItem("\u4e0d\u8bb0\u5f55(NONE)");
        logLevelinput.setPreferredSize(new Dimension((int)(170.0 * this.proportion), (int)(20.0 * this.proportion)));
        logbox.add(logtitle);
        logbox.add(logLevelinput);
        JPanel cpbox = new JPanel(new FlowLayout(1));
        cpbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel cptitle = new JLabel("\u7528\u6237\u4fee\u6539\u5bc6\u7801(change password)\uff1a");
        changePwdinput = new JComboBox<String>();
        changePwdinput.addItem(CHANGE_PWD_CLOSE);
        changePwdinput.addItem(CHANGE_PWD_OPEN);
        changePwdinput.setPreferredSize(new Dimension((int)(170.0 * this.proportion), (int)(20.0 * this.proportion)));
        cpbox.add(cptitle);
        cpbox.add(changePwdinput);
        JPanel scbox = new JPanel(new FlowLayout(1));
        cpbox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel sctitle = new JLabel("\u6c38\u4e45\u8d44\u6e90\u94fe\u63a5(file chain)\uff1a");
        showChaininput = new JComboBox<String>();
        showChaininput.addItem(SHOW_CHAIN_CLOSE);
        showChaininput.addItem(SHOW_CHAIN_OPEN);
        showChaininput.setPreferredSize(new Dimension((int)(170.0 * this.proportion), (int)(20.0 * this.proportion)));
        scbox.add(sctitle);
        scbox.add(showChaininput);
        JPanel filePathBox = new JPanel(new FlowLayout(1));
        filePathBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel filePathtitle = new JLabel("\u6587\u4ef6\u7cfb\u7edf\u8def\u5f84(file system path)\uff1a");
        changeFileSystemPath = new JButton("\u7ba1\u7406(Manage)");
        changeFileSystemPath.setPreferredSize(new Dimension((int)(170.0 * this.proportion), (int)(32.0 * this.proportion)));
        filePathBox.add(filePathtitle);
        filePathBox.add(changeFileSystemPath);
        settingbox.add(portbox);
        settingbox.add(mlbox);
        settingbox.add(vcbox);
        settingbox.add(bufferbox);
        settingbox.add(logbox);
        settingbox.add(cpbox);
        settingbox.add(scbox);
        settingbox.add(filePathBox);
        window.add(settingbox);
        JPanel buttonbox = new JPanel(new FlowLayout(1));
        buttonbox.setBorder(new EmptyBorder((int)(0.0 * this.proportion), 0, (int)(5.0 * this.proportion), 0));
        update = new JButton("\u5e94\u7528(Update)");
        cancel = new JButton("\u53d6\u6d88(Cancel)");
        update.setPreferredSize(new Dimension((int)(155.0 * this.proportion), (int)(32.0 * this.proportion)));
        cancel.setPreferredSize(new Dimension((int)(155.0 * this.proportion), (int)(32.0 * this.proportion)));
        buttonbox.add(update);
        buttonbox.add(cancel);
        window.add(buttonbox);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.setVisible(false);
            }
        });
        update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (st.getServerStatus()) {
                    SettingWindow.this.getServerStatus();
                } else {
                    Thread t = new Thread(() -> {
                        if (us != null) {
                            try {
                                ServerSetting ss = new ServerSetting();
                                ss.setPort(Integer.parseInt(portinput.getText()));
                                ss.setBuffSize(Integer.parseInt(bufferinput.getText()) * 1024);
                                ss.setFsPath(chooserPath.getAbsolutePath());
                                ArrayList<ExtendStores> ess = new ArrayList<ExtendStores>();
                                for (FileSystemPath fsp : extendStores) {
                                    ExtendStores es = new ExtendStores();
                                    es.setIndex(fsp.getIndex());
                                    es.setPath(fsp.getPath());
                                    ess.add(es);
                                }
                                ss.setExtendStores(ess);
                                switch (logLevelinput.getSelectedIndex()) {
                                    case 0: {
                                        ss.setLog(LogLevel.Event);
                                        break;
                                    }
                                    case 1: {
                                        ss.setLog(LogLevel.Runtime_Exception);
                                        break;
                                    }
                                    case 2: {
                                        ss.setLog(LogLevel.None);
                                        break;
                                    }
                                }
                                switch (mlinput.getSelectedIndex()) {
                                    case 0: {
                                        ss.setMustLogin(true);
                                        break;
                                    }
                                    case 1: {
                                        ss.setMustLogin(false);
                                        break;
                                    }
                                }
                                switch (changePwdinput.getSelectedIndex()) {
                                    case 0: {
                                        ss.setChangePassword(false);
                                        break;
                                    }
                                    case 1: {
                                        ss.setChangePassword(true);
                                        break;
                                    }
                                }
                                switch (showChaininput.getSelectedIndex()) {
                                    case 0: {
                                        ss.setFileChain(false);
                                        break;
                                    }
                                    case 1: {
                                        ss.setFileChain(true);
                                        break;
                                    }
                                }
                                switch (vcinput.getSelectedIndex()) {
                                    case 0: {
                                        ss.setVc(VCLevel.Standard);
                                        break;
                                    }
                                    case 1: {
                                        ss.setVc(VCLevel.Simplified);
                                        break;
                                    }
                                    case 2: {
                                        ss.setVc(VCLevel.Close);
                                        break;
                                    }
                                }
                                if (us.update(ss)) {
                                    ServerUIModule.getInsatnce().updateServerStatus();
                                    window.setVisible(false);
                                }
                            }
                            catch (Exception exc) {
                                Printer.instance.print(exc.getMessage());
                                Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u66f4\u65b0\u670d\u52a1\u5668\u8bbe\u7f6e");
                            }
                        } else {
                            window.setVisible(false);
                        }
                    });
                    t.start();
                }
            }
        });
        changeFileSystemPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fspv = FileSystemPathViewer.getInstance();
                fspv.show();
            }
        });
        this.modifyComponentSize(window);
    }

    protected void show() {
        this.getServerStatus();
        window.setVisible(true);
    }

    private void getServerStatus() {
        Thread t = new Thread(() -> {
            if (st != null) {
                bufferinput.setText(st.getBufferSize() == 0 ? st.getInitBufferSize() : st.getBufferSize() / 1024 + "");
                portinput.setText(st.getPort() == 0 ? st.getInitProt() + "" : st.getPort() + "");
                chooserPath = st.getFileSystemPath() != null ? new File(st.getFileSystemPath()) : new File(st.getInitFileSystemPath());
                extendStores = st.getExtendStores();
                if (st.getLogLevel() != null) {
                    switch (st.getLogLevel()) {
                        case Event: {
                            logLevelinput.setSelectedIndex(0);
                            break;
                        }
                        case Runtime_Exception: {
                            logLevelinput.setSelectedIndex(1);
                            break;
                        }
                        case None: {
                            logLevelinput.setSelectedIndex(2);
                        }
                    }
                } else {
                    switch (st.getInitLogLevel()) {
                        case Event: {
                            logLevelinput.setSelectedIndex(0);
                            break;
                        }
                        case Runtime_Exception: {
                            logLevelinput.setSelectedIndex(1);
                            break;
                        }
                        case None: {
                            logLevelinput.setSelectedIndex(2);
                        }
                    }
                }
                if (st.getMustLogin()) {
                    mlinput.setSelectedIndex(0);
                } else {
                    mlinput.setSelectedIndex(1);
                }
                if (st.isAllowChangePassword()) {
                    changePwdinput.setSelectedIndex(1);
                } else {
                    changePwdinput.setSelectedIndex(0);
                }
                if (st.isOpenFileChain()) {
                    showChaininput.setSelectedIndex(1);
                } else {
                    showChaininput.setSelectedIndex(0);
                }
                if (st.getVCLevel() != null) {
                    switch (st.getVCLevel()) {
                        case Standard: {
                            vcinput.setSelectedIndex(0);
                            break;
                        }
                        case Simplified: {
                            vcinput.setSelectedIndex(1);
                            break;
                        }
                        case Close: {
                            vcinput.setSelectedIndex(2);
                        }
                    }
                } else {
                    switch (st.getInitVCLevel()) {
                        case Standard: {
                            vcinput.setSelectedIndex(0);
                            break;
                        }
                        case Simplified: {
                            vcinput.setSelectedIndex(1);
                            break;
                        }
                        case Close: {
                            vcinput.setSelectedIndex(2);
                        }
                    }
                }
            }
        });
        t.start();
    }

    protected static SettingWindow getInstance() {
        if (sw == null) {
            sw = new SettingWindow();
        }
        return sw;
    }
}

