/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.module;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.UIManager;

public class KiftdDynamicWindow {
    private final int OriginResolution_W = 1440;
    private final int OriginResolution_H = 900;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private double proportionW = this.screenSize.getWidth() / 1440.0;
    private double proportionH = this.screenSize.getHeight() / 900.0;
    protected double proportion = this.proportionW > this.proportionH ? this.proportionH : this.proportionW;
    protected Dimension fileChooerSize;

    public KiftdDynamicWindow() {
        File f;
        String path = System.getProperty("user.dir");
        String classPath = System.getProperty("java.class.path");
        if (classPath.indexOf(File.pathSeparator) < 0 && (classPath = (f = new File(classPath)).getAbsolutePath()).endsWith(".jar")) {
            path = classPath.substring(0, classPath.lastIndexOf(File.separator));
        }
        String confdir = path + File.separator + "conf" + File.separator;
        File settingFile = new File(confdir, "init.txt");
        Properties settingp = new Properties();
        try {
            settingp.load(new FileInputStream(settingFile));
            String udp = settingp.getProperty("scale");
            if (udp != null) {
                double udpi = Double.parseDouble(udp);
                if (udpi > 10.0) {
                    udpi = 10.0;
                }
                this.proportion = udpi;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.proportion < 1.0) {
            this.proportion = 1.0;
        }
        this.fileChooerSize = new Dimension((int)(570.0 * this.proportion), (int)(300.0 * this.proportion));
    }

    protected void modifyComponentSize(Container c) {
        c.setSize((int)((double)c.getWidth() * this.proportion), (int)((double)c.getHeight() * this.proportion));
    }

    public int getOriginResolution_W() {
        return 1440;
    }

    public int getOriginResolution_H() {
        return 900;
    }

    protected void setUIFont() {
        String[] names;
        Font f = new Font("\u5b8b\u4f53", 0, (int)(13.0 * this.proportion));
        for (String item : names = new String[]{"Label", "CheckBox", "PopupMenu", "MenuItem", "CheckBoxMenuItem", "JRadioButtonMenuItem", "ComboBox", "Button", "Tree", "ScrollPane", "TabbedPane", "EditorPane", "TitledBorder", "Menu", "TextArea", "OptionPane", "MenuBar", "ToolBar", "ToggleButton", "ToolTip", "ProgressBar", "TableHeader", "Panel", "List", "ColorChooser", "PasswordField", "TextField", "Table", "Label", "Viewport", "RadioButtonMenuItem", "RadioButton", "DesktopPane", "InternalFrame"}) {
            UIManager.put(item + ".font", f);
        }
    }
}

