/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.module;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.ui.module.FSProgressDialog;
import kohgylw.kiftd.ui.module.KiftdDynamicWindow;
import kohgylw.kiftd.ui.module.SettingWindow;
import kohgylw.kiftd.ui.pojo.FileSystemPath;
import kohgylw.kiftd.ui.util.PathsTable;
import kohgylw.kiftd.util.file_system_manager.FileSystemManager;

public class FileSystemPathViewer
extends KiftdDynamicWindow {
    protected static JDialog window;
    private JButton addBtn;
    private JButton changeBtn;
    private JButton removeBtn;
    private PathsTable pathsTable;
    private int maxExtendStoresNum;
    private static FileSystemPathViewer fsv;
    private static List<FileSystemPath> paths;
    private static ExecutorService worker;
    private CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
    private static final String INVALID_PATH_ALTER = "\u9519\u8bef\uff1a\u8be5\u8def\u5f84\u4e2d\u542b\u6709\u7a0b\u5e8f\u65e0\u6cd5\u8bc6\u522b\u7684\u5b57\u7b26\uff0c\u8bf7\u4f7f\u7528\u5176\u4ed6\u8def\u5f84\uff08\u63a8\u8350\u4f7f\u7528\u7eaf\u82f1\u6587\u8def\u5f84\uff09\u3002";

    private FileSystemPathViewer() {
        this.setUIFont();
        worker = Executors.newSingleThreadExecutor();
        window = new JDialog((Dialog)SettingWindow.window, "\u7ba1\u7406\u6587\u4ef6\u7cfb\u7edf\u8def\u5f84");
        window.setModal(true);
        window.setSize(600, 240);
        window.setDefaultCloseOperation(1);
        window.setLocation(200, 200);
        window.setResizable(false);
        paths = new ArrayList<FileSystemPath>();
        Container c = window.getContentPane();
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.addBtn = new JButton("\u65b0\u5efa \u6269\u5c55\u5b58\u50a8\u533a[Add]");
        this.changeBtn = new JButton("\u4fee\u6539\u8def\u5f84[Change]");
        this.removeBtn = new JButton("\u79fb\u9664\u8def\u5f84[Remove]");
        this.addBtn.setPreferredSize(new Dimension((int)(110.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.changeBtn.setPreferredSize(new Dimension((int)(110.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.changeBtn.setEnabled(false);
        this.removeBtn.setPreferredSize(new Dimension((int)(105.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.removeBtn.setEnabled(false);
        toolBar.add(this.addBtn);
        toolBar.addSeparator();
        toolBar.add(this.changeBtn);
        toolBar.add(this.removeBtn);
        toolBar.addSeparator();
        c.add((Component)toolBar, "North");
        this.maxExtendStoresNum = SettingWindow.st == null ? 0 : SettingWindow.st.getMaxExtendStoresNum();
        this.addBtn.addActionListener(e -> {
            this.disableAllButtons();
            if (SettingWindow.extendStores.size() < this.maxExtendStoresNum) {
                JFileChooser addExtendStoresChooer = new JFileChooser();
                addExtendStoresChooer.setFileSelectionMode(1);
                addExtendStoresChooer.setPreferredSize(this.fileChooerSize);
                addExtendStoresChooer.setDialogTitle("\u8bf7\u9009\u62e9\u5b58\u50a8\u8def\u5f84...");
                if (addExtendStoresChooer.showOpenDialog(null) == 0) {
                    File newExtendStores = addExtendStoresChooer.getSelectedFile();
                    if (newExtendStores.isDirectory() && newExtendStores.canRead() && newExtendStores.canWrite()) {
                        if (SettingWindow.extendStores.parallelStream().anyMatch(f -> f.getPath().equals(newExtendStores))) {
                            JOptionPane.showMessageDialog(window, "\u9519\u8bef\uff1a\u8be5\u8def\u5f84\u5df2\u88ab\u5176\u4ed6\u6269\u5c55\u5b58\u50a8\u533a\u5360\u7528\u3002", "\u9519\u8bef", 2);
                        } else {
                            String pathName = newExtendStores.getAbsolutePath();
                            if (this.encoder.canEncode(pathName) && pathName.indexOf("\\:") < 0 && pathName.indexOf("\\\\") < 0) {
                                Object[] indexs = (Short[])SettingWindow.extendStores.parallelStream().map(s -> s.getIndex()).toArray(Short[]::new);
                                short index = 1;
                                while (Arrays.binarySearch(indexs, (Object)index) >= 0) {
                                    index = (short)(index + 1);
                                }
                                FileSystemPath nfsp = new FileSystemPath();
                                nfsp.setIndex(index);
                                nfsp.setType("\u6269\u5c55\u5b58\u50a8\u533a");
                                nfsp.setPath(addExtendStoresChooer.getSelectedFile());
                                SettingWindow.extendStores.add(nfsp);
                            } else {
                                JOptionPane.showMessageDialog(window, INVALID_PATH_ALTER, "\u9519\u8bef", 2);
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(window, "\u9519\u8bef\uff1a\u8be5\u8def\u5f84\u4e0d\u53ef\u7528\uff0c\u5fc5\u987b\u9009\u62e9\u53ef\u8bfb\u5199\u7684\u6587\u4ef6\u5939\u3002", "\u9519\u8bef", 2);
                    }
                }
            }
            this.enableAllButtons();
            this.refresh();
        });
        this.changeBtn.addActionListener(e -> {
            block11: {
                short index;
                block12: {
                    File fileSystemPath;
                    this.disableAllButtons();
                    if (JOptionPane.showConfirmDialog(window, "\u786e\u8ba4\u8981\u4fee\u6539\u8be5\u5b58\u50a8\u533a\u8def\u5f84\u4e48\uff1f\u8b66\u544a\uff1a\u5982\u9700\u4fdd\u7559\u8be5\u5b58\u50a8\u533a\u5185\u7684\u5168\u90e8\u6570\u636e\uff0c\u5e94\u5148\u5c06\u8be5\u5b58\u50a8\u533a\u539f\u8def\u5f84\u6307\u5b9a\u7684\u6587\u4ef6\u5939\u79fb\u52a8\u5230\u65b0\u4f4d\u7f6e\uff0c\u518d\u5c06\u79fb\u52a8\u540e\u7684\u6587\u4ef6\u5939\u8bbe\u7f6e\u4e3a\u8be5\u5b58\u50a8\u533a\u7684\u65b0\u8def\u5f84\u3002\u5426\u5219\uff0c\u8be5\u5b58\u50a8\u533a\u5185\u7684\u6570\u636e\u5c06\u5168\u90e8\u4e22\u5931\u3002", "\u4fee\u6539\u8def\u5f84", 0) != 0) break block11;
                    index = this.pathsTable.getSelectFileSystemIndex();
                    if (index != 0) break block12;
                    JFileChooser mainFileSystemPathChooer = new JFileChooser();
                    mainFileSystemPathChooer.setFileSelectionMode(1);
                    mainFileSystemPathChooer.setPreferredSize(this.fileChooerSize);
                    if (SettingWindow.st != null && (fileSystemPath = new File(SettingWindow.st.getFileSystemPath())).isDirectory()) {
                        mainFileSystemPathChooer.setCurrentDirectory(fileSystemPath);
                    }
                    mainFileSystemPathChooer.setDialogTitle("\u8bf7\u9009\u62e9\u4e3b\u6587\u4ef6\u7cfb\u7edf\u5b58\u50a8\u8def\u5f84");
                    if (mainFileSystemPathChooer.showOpenDialog(null) != 0) break block11;
                    File selectPath = mainFileSystemPathChooer.getSelectedFile();
                    if (selectPath.isDirectory() && selectPath.canWrite() && selectPath.canRead()) {
                        if (!SettingWindow.extendStores.parallelStream().anyMatch(f -> f.getPath().equals(selectPath))) {
                            String pathName = selectPath.getAbsolutePath();
                            if (new File(ConfigureReader.instance().getInitFileSystemPath()).equals(selectPath) || this.encoder.canEncode(pathName) && pathName.indexOf("\\:") < 0 && pathName.indexOf("\\\\") < 0) {
                                SettingWindow.chooserPath = mainFileSystemPathChooer.getSelectedFile();
                            } else {
                                JOptionPane.showMessageDialog(window, INVALID_PATH_ALTER, "\u9519\u8bef", 2);
                            }
                        } else {
                            JOptionPane.showMessageDialog(window, "\u9519\u8bef\uff1a\u8be5\u8def\u5f84\u5df2\u88ab\u67d0\u4e2a\u6269\u5c55\u5b58\u50a8\u533a\u5360\u7528\u3002", "\u9519\u8bef", 2);
                        }
                    } else {
                        JOptionPane.showMessageDialog(window, "\u9519\u8bef\uff1a\u8be5\u8def\u5f84\u4e0d\u53ef\u7528\uff0c\u5fc5\u987b\u9009\u62e9\u53ef\u8bfb\u5199\u7684\u6587\u4ef6\u5939\u3002", "\u9519\u8bef", 2);
                    }
                    break block11;
                }
                JFileChooser mainFileSystemPathChooer = new JFileChooser();
                mainFileSystemPathChooer.setFileSelectionMode(1);
                mainFileSystemPathChooer.setPreferredSize(this.fileChooerSize);
                FileSystemPath fsp = null;
                for (int i = 0; i < SettingWindow.extendStores.size(); ++i) {
                    if (SettingWindow.extendStores.get(i).getIndex() != index) continue;
                    fsp = SettingWindow.extendStores.get(i);
                    mainFileSystemPathChooer.setCurrentDirectory(fsp.getPath());
                    mainFileSystemPathChooer.setDialogTitle("\u8bf7\u9009\u62e9\u6269\u5c55\u5b58\u50a8\u533a\u8def\u5f84");
                    if (mainFileSystemPathChooer.showOpenDialog(null) != 0) break;
                    this.disableAllButtons();
                    File selectPath = mainFileSystemPathChooer.getSelectedFile();
                    if (selectPath.isDirectory() && selectPath.canWrite() && selectPath.canRead()) {
                        if (fsp.getPath().equals(selectPath) || !SettingWindow.extendStores.parallelStream().anyMatch(f -> f.getPath().equals(selectPath))) {
                            String pathName = selectPath.getAbsolutePath();
                            if (this.encoder.canEncode(pathName) && pathName.indexOf("\\:") < 0 && pathName.indexOf("\\\\") < 0) {
                                fsp.setPath(mainFileSystemPathChooer.getSelectedFile());
                                break;
                            }
                            JOptionPane.showMessageDialog(window, INVALID_PATH_ALTER, "\u9519\u8bef", 2);
                            break;
                        }
                        JOptionPane.showMessageDialog(window, "\u9519\u8bef\uff1a\u8be5\u8def\u5f84\u5df2\u88ab\u5176\u4ed6\u6269\u5c55\u5b58\u50a8\u533a\u5360\u7528\u3002", "\u9519\u8bef", 2);
                        break;
                    }
                    JOptionPane.showMessageDialog(window, "\u9519\u8bef\uff1a\u8be5\u8def\u5f84\u4e0d\u53ef\u7528\uff0c\u5fc5\u987b\u9009\u62e9\u53ef\u8bfb\u5199\u7684\u6587\u4ef6\u5939\u3002", "\u9519\u8bef", 2);
                    break;
                }
            }
            this.enableAllButtons();
            this.refresh();
        });
        this.removeBtn.addActionListener(e -> {
            this.disableAllButtons();
            if (JOptionPane.showConfirmDialog(window, "\u786e\u8ba4\u8981\u79fb\u9664\u8be5\u6269\u5c55\u5b58\u50a8\u533a\u4e48\uff1f\u8b66\u544a\uff1a\u79fb\u9664\u540e\uff0c\u8be5\u5b58\u50a8\u533a\u5185\u539f\u5148\u5b58\u653e\u7684\u6570\u636e\u5c06\u4e22\u5931\uff0c\u4e14\u8bbe\u7f6e\u751f\u6548\u540e\u4e0d\u53ef\u6062\u590d\u3002", "\u79fb\u9664\u6269\u5c55\u5b58\u50a8\u533a", 0) == 0) {
                short index = this.pathsTable.getSelectFileSystemIndex();
                block6: for (int i = 0; i < SettingWindow.extendStores.size(); ++i) {
                    if (SettingWindow.extendStores.get(i).getIndex() != index) continue;
                    int removeItemIndex = i;
                    try {
                        long total = FileSystemManager.getInstance().getTotalOfNodesAtExtendStore(index);
                        if (total > 0L) {
                            switch (JOptionPane.showConfirmDialog(window, "\u662f\u5426\u7acb\u5373\u5c06\u8be5\u6269\u5c55\u5b58\u50a8\u533a\u5185\u7684\u6570\u636e\u5168\u90e8\u79fb\u51fa\u4ee5\u4fbf\u7559\u6863\uff1f\u5982\u679c\u60a8\u786e\u5b9a\u8981\u79fb\u9664\u8be5\u6269\u5c55\u5b58\u50a8\u533a\uff0c\u63a8\u8350\u6267\u884c\u8be5\u64cd\u4f5c\u3002\u6ce8\u610f\uff1a\u8be5\u64cd\u4f5c\u5373\u65f6\u751f\u6548\uff0c\u65e0\u8bba\u662f\u5426\u5e94\u7528\u65b0\u8bbe\u7f6e\u5747\u65e0\u6cd5\u56de\u9000\u3002", "\u79fb\u51fa", 1)) {
                                case 0: {
                                    JFileChooser transferDirChooer = new JFileChooser();
                                    transferDirChooer.setFileSelectionMode(1);
                                    transferDirChooer.setPreferredSize(this.fileChooerSize);
                                    transferDirChooer.setDialogTitle("\u8bf7\u9009\u62e9\u79fb\u51fa\u6570\u636e\u7684\u4fdd\u5b58\u8def\u5f84...");
                                    if (transferDirChooer.showOpenDialog(null) != 0) break block6;
                                    File transferDir = transferDirChooer.getSelectedFile();
                                    worker.execute(() -> {
                                        FSProgressDialog fsd = FSProgressDialog.getNewInstance(window);
                                        Thread t = new Thread(() -> fsd.show());
                                        t.start();
                                        try {
                                            boolean r = FileSystemManager.getInstance().transferExtendStore(index, transferDir);
                                            SwingUtilities.invokeLater(() -> {
                                                fsd.close();
                                                if (r) {
                                                    SettingWindow.extendStores.remove(removeItemIndex);
                                                    this.refresh();
                                                } else {
                                                    JOptionPane.showMessageDialog(window, "\u79fb\u51fa\u6587\u4ef6\u65f6\u5931\u8d25\uff0c\u8be5\u64cd\u4f5c\u5df2\u88ab\u4e2d\u65ad\uff0c\u672a\u80fd\u79fb\u51fa\u5168\u90e8\u6570\u636e\u3002", "\u9519\u8bef", 0);
                                                }
                                            });
                                        }
                                        catch (FileAlreadyExistsException e1) {
                                            SwingUtilities.invokeLater(() -> {
                                                fsd.close();
                                                JOptionPane.showMessageDialog(window, "\u76ee\u6807\u6587\u4ef6\u5939\u5185\u5b58\u5728\u540c\u540d\u6587\u4ef6\uff0c\u5efa\u8bae\u9009\u62e9\u4e00\u4e2a\u7a7a\u6587\u4ef6\u5939\u4f5c\u4e3a\u79fb\u51fa\u6570\u636e\u7684\u4fdd\u5b58\u8def\u5f84\u3002", "\u9519\u8bef", 0);
                                            });
                                        }
                                        catch (Exception e1) {
                                            SwingUtilities.invokeLater(() -> {
                                                fsd.close();
                                                JOptionPane.showMessageDialog(window, "\u51fa\u73b0\u610f\u5916\u9519\u8bef\uff0c\u65e0\u6cd5\u7edf\u8ba1\u6269\u5c55\u5b58\u50a8\u533a\u6570\u636e\uff0c\u8bf7\u91cd\u542f\u5e94\u7528\u540e\u91cd\u8bd5\u3002", "\u9519\u8bef", 0);
                                            });
                                        }
                                    });
                                    break;
                                }
                                case 1: {
                                    SettingWindow.extendStores.remove(i);
                                    break;
                                }
                            }
                            break;
                        }
                        SettingWindow.extendStores.remove(i);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(window, "\u51fa\u73b0\u610f\u5916\u9519\u8bef\uff0c\u65e0\u6cd5\u7edf\u8ba1\u6269\u5c55\u5b58\u50a8\u533a\u6570\u636e\uff0c\u8bf7\u91cd\u542f\u5e94\u7528\u540e\u91cd\u8bd5\u3002", "\u9519\u8bef", 0);
                    }
                    break;
                }
            }
            this.enableAllButtons();
            this.refresh();
        });
        this.pathsTable = new PathsTable();
        this.pathsTable.setRowHeight((int)(16.0 * this.proportion));
        this.pathsTable.setSelectionMode(0);
        JScrollPane mianPane = new JScrollPane(this.pathsTable);
        this.pathsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                short index = FileSystemPathViewer.this.pathsTable.getSelectFileSystemIndex();
                if (index < 0) {
                    FileSystemPathViewer.this.changeBtn.setEnabled(false);
                    FileSystemPathViewer.this.removeBtn.setEnabled(false);
                } else {
                    if (index == 0) {
                        FileSystemPathViewer.this.removeBtn.setEnabled(false);
                    } else {
                        FileSystemPathViewer.this.removeBtn.setEnabled(true);
                    }
                    FileSystemPathViewer.this.changeBtn.setEnabled(true);
                }
            }
        });
        c.add(mianPane);
        this.modifyComponentSize(window);
    }

    private void refresh() {
        paths.clear();
        FileSystemPath mainfsp = new FileSystemPath();
        mainfsp.setType("\u4e3b\u6587\u4ef6\u7cfb\u7edf");
        mainfsp.setPath(SettingWindow.chooserPath);
        mainfsp.setIndex((short)0);
        paths.add(mainfsp);
        if (SettingWindow.extendStores != null) {
            paths.addAll(SettingWindow.extendStores);
        }
        this.pathsTable.updateValues(paths);
    }

    public void show() {
        this.disableAllButtons();
        this.refresh();
        if (paths == null || paths.size() == 0) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u7cfb\u7edf\u8bbe\u7f6e\uff0c\u8bf7\u624b\u52a8\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u5e76\u91cd\u542f\u5e94\u7528\u3002");
        } else {
            this.enableAllButtons();
            window.setVisible(true);
        }
    }

    public static FileSystemPathViewer getInstance() {
        if (fsv == null) {
            fsv = new FileSystemPathViewer();
        }
        return fsv;
    }

    private void disableAllButtons() {
        this.addBtn.setEnabled(false);
        this.changeBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
    }

    private void enableAllButtons() {
        if (SettingWindow.extendStores.size() < this.maxExtendStoresNum) {
            this.addBtn.setEnabled(true);
        } else {
            this.addBtn.setEnabled(false);
        }
        short index = this.pathsTable.getSelectFileSystemIndex();
        if (index < 0) {
            this.changeBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        } else {
            if (index == 0) {
                this.removeBtn.setEnabled(false);
            } else {
                this.removeBtn.setEnabled(true);
            }
            this.changeBtn.setEnabled(true);
        }
    }
}

