/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.webdav.util;

import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import kohgylw.kiftd.server.exception.FoldersTotalOutOfLimitException;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.webdav.pojo.KiftdWebDAVResource;
import org.springframework.stereotype.Component;

@Component
public class KiftdWebDAVResourcesUtil {
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper nm;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private FolderUtil fu;
    @Resource
    private LogUtil lu;

    public Folder getFolderByPath(String path) {
        if (path != null && path.startsWith("/")) {
            String currentPath = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.lastIndexOf(47)) : path;
            currentPath = currentPath.substring(1);
            String[] folders = currentPath.split("/");
            Folder currentFolder = this.fm.queryById("root");
            for (String f : folders) {
                if (f.isEmpty()) continue;
                HashMap<String, String> queryMap = new HashMap<String, String>();
                queryMap.put("parentId", currentFolder.getFolderId());
                queryMap.put("folderName", f);
                currentFolder = this.fm.queryByParentIdAndFolderName(queryMap);
                if (currentFolder != null) continue;
                return null;
            }
            return currentFolder;
        }
        return null;
    }

    public Node getNodeByPath(String path) {
        String parentPath;
        Folder parentFolder;
        if (path != null && path.startsWith("/") && (parentFolder = this.getFolderByPath(parentPath = path.substring(0, path.lastIndexOf(47) + 1))) != null) {
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            try {
                Node file = this.nm.queryByParentFolderId(parentFolder.getFolderId()).parallelStream().filter(e -> e.getFileName().equals(fileName)).findAny().get();
                return file;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return null;
    }

    public KiftdWebDAVResource getResource(String path) {
        Node node;
        if (path != null && !path.endsWith("/") && (node = this.getNodeByPath(path)) != null) {
            return new KiftdWebDAVResource(path, node, this.fbu.getFileFromBlocks(node));
        }
        Folder folder = this.getFolderByPath(path);
        return new KiftdWebDAVResource(path, folder);
    }

    public String[] list(String path, String account) {
        Folder f = this.getFolderByPath(path);
        if (f != null && ConfigureReader.instance().accessFolder(f, account)) {
            String[] folders = (String[])this.fm.queryByParentId(f.getFolderId()).parallelStream().filter(e -> ConfigureReader.instance().accessFolder((Folder)e, account)).map(e -> e.getFolderName() + "/").toArray(String[]::new);
            String[] files = (String[])this.nm.queryByParentFolderId(f.getFolderId()).parallelStream().map(e -> e.getFileName()).toArray(String[]::new);
            String[] result = new String[folders.length + files.length];
            System.arraycopy(folders, 0, result, 0, folders.length);
            System.arraycopy(files, 0, result, folders.length, files.length);
            return result;
        }
        return new String[0];
    }

    public Folder mkdir(String folderName, Folder parentFolder, String account) {
        if (parentFolder != null) {
            try {
                return this.fu.createNewFolder(parentFolder.getFolderId(), account, folderName, "" + parentFolder.getFolderConstraint());
            }
            catch (FoldersTotalOutOfLimitException foldersTotalOutOfLimitException) {
                // empty catch block
            }
        }
        return null;
    }
}

