/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.webdav.pojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.server.webdav.date.FastHttpDateFormat;
import kohgylw.kiftd.server.webdav.url.HttpPathUtil;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;

public class KiftdWebDAVResource
implements WebResource {
    private String path;
    private boolean isExists;
    private boolean isDirectory;
    private long creation;
    private String name;
    private String mimeType;
    private volatile String weakETag;
    private Node node;
    private File fileBlock;
    private Folder folder;

    public KiftdWebDAVResource(String path, Folder folder) {
        this.path = path;
        this.folder = folder;
        if (this.path != null && this.folder != null) {
            if (!path.endsWith("/")) {
                this.path = path + "/";
            }
            this.isExists = true;
            this.isDirectory = true;
            this.name = folder.getFolderName();
            this.creation = ServerTimeUtil.getTimeFromDateAccurateToDay(this.folder.getFolderCreationDate());
        } else {
            this.name = HttpPathUtil.getResourceName(this.path);
        }
    }

    public KiftdWebDAVResource(String path, Node node, File block) {
        this.path = path;
        this.node = node;
        this.fileBlock = block;
        if (this.path != null && this.node != null && this.fileBlock != null) {
            this.isExists = true;
            this.name = this.node.getFileName();
            try {
                BasicFileAttributes attrs = Files.readAttributes(this.fileBlock.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                this.creation = attrs.creationTime().toMillis();
            }
            catch (IOException iOException) {}
        } else {
            this.name = HttpPathUtil.getResourceName(this.path);
        }
    }

    public long getLastModified() {
        return this.creation;
    }

    public String getLastModifiedHttp() {
        return FastHttpDateFormat.formatDate(this.getLastModified());
    }

    public boolean exists() {
        return this.isExists;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return this.isExists && !this.isDirectory;
    }

    public boolean delete() {
        if (this.isExists) {
            if (this.isDirectory) {
                return true;
            }
            return this.fileBlock.delete();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public long getContentLength() {
        if (this.isExists) {
            if (this.isDirectory) {
                return -1L;
            }
            return this.fileBlock.length();
        }
        return 0L;
    }

    public String getCanonicalPath() {
        return this.path;
    }

    public boolean canRead() {
        if (this.isExists) {
            if (this.isDirectory) {
                return true;
            }
            return this.fileBlock.canRead();
        }
        return false;
    }

    public String getWebappPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getETag() {
        if (this.weakETag == null) {
            KiftdWebDAVResource kiftdWebDAVResource = this;
            synchronized (kiftdWebDAVResource) {
                if (this.weakETag == null) {
                    long contentLength = this.getContentLength();
                    long lastModified = this.getLastModified();
                    if (contentLength >= 0L || lastModified >= 0L) {
                        this.weakETag = "W/\"" + contentLength + "-" + lastModified + "\"";
                    }
                }
            }
        }
        return this.weakETag;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() {
        if (this.isDirectory) {
            return null;
        }
        try {
            return new FileInputStream(this.fileBlock);
        }
        catch (IOException | NullPointerException e) {
            return null;
        }
    }

    public byte[] getContent() {
        long len = this.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.isDirectory || len < 0L) {
            return null;
        }
        int size = (int)len;
        byte[] result = new byte[size];
        try (FileInputStream is = new FileInputStream(this.fileBlock);){
            int n;
            for (int pos = 0; pos < size; pos += n) {
                n = ((InputStream)is).read(result, pos, size - pos);
                if (n >= 0) continue;
                break;
            }
        }
        catch (IOException | NullPointerException e) {
            return null;
        }
        return result;
    }

    public long getCreation() {
        return this.creation;
    }

    public URL getURL() {
        if (this.isExists) {
            try {
                return new URI("file:" + this.path).toURL();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getCodeBase() {
        return this.getURL();
    }

    public WebResourceRoot getWebResourceRoot() {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public Manifest getManifest() {
        return null;
    }

    public Node getNode() {
        return this.node;
    }

    public Folder getFolder() {
        return this.folder;
    }
}

