/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.webdav;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.UUID;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.exception.FoldersTotalOutOfLimitException;
import kohgylw.kiftd.server.listener.ServerInitListener;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.IpAddrGetter;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.RangeFileStreamWriter;
import kohgylw.kiftd.server.webdav.date.ConcurrentDateFormat;
import kohgylw.kiftd.server.webdav.date.FastHttpDateFormat;
import kohgylw.kiftd.server.webdav.dom.DOMWriter;
import kohgylw.kiftd.server.webdav.exception.UnAuthorizedException;
import kohgylw.kiftd.server.webdav.pojo.KiftdWebDAVResource;
import kohgylw.kiftd.server.webdav.range.ContentRange;
import kohgylw.kiftd.server.webdav.url.HttpPathUtil;
import kohgylw.kiftd.server.webdav.url.URLEncoder;
import kohgylw.kiftd.server.webdav.util.KiftdWebDAVResourcesUtil;
import org.apache.catalina.WebResource;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.XMLWriter;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.apache.tomcat.util.security.MD5Encoder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class KiftdWebDAVServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final URLEncoder URL_ENCODER_XML = (URLEncoder)URLEncoder.DEFAULT.clone();
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    private int maxDepth = 3;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    protected static final String REALM_NAME = "kiftd webdav";
    protected static final String AUTH_CHARSET_NAME = "UTF-8";
    protected static final ConcurrentDateFormat creationDateFormat;
    private static final String CONTENT_STREAM = "application/octet-stream";
    private static final Range IGNORE;
    private static File tempDir;
    protected static final int BUFFER_SIZE = 4096;
    private final Hashtable<String, LockInfo> resourceLocks = new Hashtable();
    private final Hashtable<String, Vector<String>> lockNullResources = new Hashtable();
    private final Vector<LockInfo> collectionLocks = new Vector();
    private String secret = "catalina";
    private LogUtil lu;
    private KiftdWebDAVResourcesUtil resources;
    private FolderMapper fm;
    private NodeMapper nm;
    private IpAddrGetter idg;
    private FolderUtil fu;
    private FileBlockUtil fbu;

    public void init(ServletConfig config) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        this.lu = (LogUtil)context.getBean(LogUtil.class);
        this.resources = (KiftdWebDAVResourcesUtil)context.getBean(KiftdWebDAVResourcesUtil.class);
        this.fm = (FolderMapper)context.getBean(FolderMapper.class);
        this.idg = (IpAddrGetter)context.getBean(IpAddrGetter.class);
        this.fu = (FolderUtil)context.getBean(FolderUtil.class);
        this.nm = (NodeMapper)context.getBean(NodeMapper.class);
        this.fbu = (FileBlockUtil)context.getBean(FileBlockUtil.class);
        tempDir = new File(ConfigureReader.instance().getTemporaryfilePath());
        super.init(config);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method;
        if (!ConfigureReader.instance().isEnableWebDAV()) {
            resp.setStatus(403);
            return;
        }
        switch (method = req.getMethod()) {
            case "OPTIONS": {
                this.doOptions(req, resp);
                break;
            }
            case "PROPFIND": {
                this.doPropfind(req, resp);
                break;
            }
            case "PROPPATCH": {
                this.doProppatch(req, resp);
                break;
            }
            case "GET": 
            case "POST": {
                this.doGet(req, resp);
                break;
            }
            case "HEAD": {
                this.doHead(req, resp);
                break;
            }
            case "PUT": {
                this.doPut(req, resp);
                break;
            }
            case "DELETE": {
                this.doDelete(req, resp);
                break;
            }
            case "MKCOL": {
                this.doMkcol(req, resp);
                break;
            }
            case "COPY": {
                this.doCopy(req, resp);
                break;
            }
            case "MOVE": {
                this.doMove(req, resp);
                break;
            }
            case "LOCK": {
                this.doLock(req, resp);
                break;
            }
            case "UNLOCK": {
                this.doUnlock(req, resp);
                break;
            }
            default: {
                super.service(req, resp);
            }
        }
    }

    private String getAccountFromRequestHeader(HttpServletRequest req) throws UnAuthorizedException, IllegalArgumentException {
        String account = (String)req.getSession().getAttribute("ACCOUNT");
        if (account != null) {
            return account;
        }
        String authHeader = req.getHeader("authorization");
        if (authHeader != null) {
            if (authHeader.toLowerCase().startsWith("basic ")) {
                String base64Auth = authHeader.substring(6);
                Base64.Decoder decoder = Base64.getUrlDecoder();
                String authMsg = new String(decoder.decode(base64Auth), Charset.forName(AUTH_CHARSET_NAME));
                int index = authMsg.indexOf(58);
                if (index >= 0) {
                    String userName = authMsg.substring(0, index);
                    String userPwd = authMsg.substring(index + 1);
                    if (ConfigureReader.instance().foundAccount(userName)) {
                        if (ConfigureReader.instance().checkAccountPwd(userName, userPwd)) {
                            req.getSession().setAttribute("ACCOUNT", (Object)userName);
                            return userName;
                        }
                        throw new UnAuthorizedException();
                    }
                    if ("".equals(userPwd)) {
                        return null;
                    }
                    throw new UnAuthorizedException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
        throw new UnAuthorizedException();
    }

    private void needAuthorizationByBasic(HttpServletResponse resp) throws IOException {
        StringBuilder value = new StringBuilder(16);
        value.append("Basic realm=\"");
        value.append(REALM_NAME);
        value.append('\"');
        resp.setHeader(AUTH_HEADER_NAME, value.toString());
        resp.setStatus(401);
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver());
        }
        catch (ParserConfigurationException e) {
            throw new ServletException();
        }
        return documentBuilder;
    }

    protected String rewriteUrl(String path) {
        return URL_ENCODER_XML.encode(path, StandardCharsets.UTF_8);
    }

    protected String getRelativePath(HttpServletRequest request) {
        return this.getRelativePath(request, false);
    }

    protected String getRelativePath(HttpServletRequest request, boolean allowEmptyPath) {
        String pathInfo = request.getAttribute("javax.servlet.include.request_uri") != null ? (String)request.getAttribute("javax.servlet.include.path_info") : request.getPathInfo();
        StringBuilder result = new StringBuilder();
        if (pathInfo != null) {
            result.append(pathInfo);
        }
        if (result.length() == 0) {
            result.append('/');
        }
        return result.toString();
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("DAV", "1,2");
        resp.addHeader("Allow", this.determineMethodsAllowed(req));
        resp.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String parentPath;
        Vector<String> currentLockNullResources;
        KiftdWebDAVResource resource;
        String account;
        String path = this.getRelativePath(req);
        try {
            account = this.getAccountFromRequestHeader(req);
        }
        catch (IllegalArgumentException | UnAuthorizedException e) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        Vector<String> properties = null;
        int depth = this.maxDepth;
        int type = 1;
        String depthStr = req.getHeader("Depth");
        if (depthStr == null) {
            depth = this.maxDepth;
        } else if (depthStr.equals("0")) {
            depth = 0;
        } else if (depthStr.equals("1")) {
            depth = 1;
        } else if (depthStr.equals("infinity")) {
            depth = this.maxDepth;
        }
        org.w3c.dom.Node propNode = null;
        if (req.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                Element rootElement = document.getDocumentElement();
                NodeList childList = rootElement.getChildNodes();
                block12: for (int i = 0; i < childList.getLength(); ++i) {
                    org.w3c.dom.Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block12;
                        }
                        case 1: {
                            if (currentNode.getNodeName().endsWith("prop")) {
                                type = 0;
                                propNode = currentNode;
                            }
                            if (currentNode.getNodeName().endsWith("propname")) {
                                type = 2;
                            }
                            if (!currentNode.getNodeName().endsWith("allprop")) continue block12;
                            type = 1;
                        }
                    }
                }
            }
            catch (IOException | SAXException e) {
                this.lu.writeException(e);
                resp.setStatus(400);
                return;
            }
        }
        if (type == 0) {
            properties = new Vector<String>();
            NodeList childList = propNode.getChildNodes();
            block13: for (int i = 0; i < childList.getLength(); ++i) {
                org.w3c.dom.Node currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block13;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        String propertyName = null;
                        propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                        properties.addElement(propertyName);
                    }
                }
            }
        }
        if (!(resource = this.resources.getResource(path)).exists() && (currentLockNullResources = this.lockNullResources.get(parentPath = HttpPathUtil.getParentPath(path))) != null) {
            Enumeration<String> lockNullResourcesList = currentLockNullResources.elements();
            while (lockNullResourcesList.hasMoreElements()) {
                String lockNullPath = lockNullResourcesList.nextElement();
                if (!lockNullPath.equals(path)) continue;
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                XMLWriter generatedXML = new XMLWriter((Writer)resp.getWriter());
                generatedXML.writeXMLHeader();
                generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                generatedXML.writeElement("D", "multistatus", 1);
                generatedXML.sendData();
                return;
            }
        }
        if (!resource.exists()) {
            resp.setStatus(404);
            return;
        }
        KiftdWebDAVResource kiftdWebDAVResource = resource;
        if (resource.isDirectory()) {
            Folder target = kiftdWebDAVResource.getFolder();
            if (!ConfigureReader.instance().accessFolder(target, account)) {
                this.needAuthorizationByBasic(resp);
                return;
            }
        } else {
            Node node = kiftdWebDAVResource.getNode();
            if (node != null) {
                Folder parentFolder = this.fm.queryById(node.getFileParentFolder());
                if (!ConfigureReader.instance().accessFolder(parentFolder, account)) {
                    this.needAuthorizationByBasic(resp);
                    return;
                }
            } else {
                resp.setStatus(404);
                return;
            }
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter((Writer)resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (depth == 0) {
            this.parseProperties(req, generatedXML, path, resource, type, properties);
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(path);
            Stack<String> stackBelow = new Stack<String>();
            while (!stack.isEmpty() && depth >= 0) {
                String currentPath = (String)stack.pop();
                resource = this.resources.getResource(currentPath);
                this.parseProperties(req, generatedXML, currentPath, resource, type, properties);
                if (resource.isDirectory() && depth > 0) {
                    String[] entries;
                    for (String entry : entries = this.resources.list(currentPath, account)) {
                        String newPath = currentPath;
                        if (!newPath.endsWith("/")) {
                            newPath = newPath + "/";
                        }
                        newPath = newPath + entry;
                        stackBelow.push(newPath);
                    }
                    String lockPath = currentPath;
                    Vector<String> currentLockNullResources2 = this.lockNullResources.get(lockPath);
                    if (currentLockNullResources2 != null) {
                        Enumeration<String> lockNullResourcesList = currentLockNullResources2.elements();
                        while (lockNullResourcesList.hasMoreElements()) {
                            String lockNullPath = lockNullResourcesList.nextElement();
                            this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new Stack();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement("D", "multistatus", 1);
        generatedXML.sendData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        if (req.getContentLengthLong() <= 0L) return;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            NodeList rootChildList = rootElement.getChildNodes();
            org.w3c.dom.Node operationNode = null;
            block14: for (int i = 0; i < rootChildList.getLength(); ++i) {
                org.w3c.dom.Node currentNode = rootChildList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        if (currentNode.getNodeName().endsWith(":set")) {
                            operationNode = currentNode;
                            break block14;
                        }
                        if (!currentNode.getNodeName().endsWith(":remove")) break;
                        operationNode = currentNode;
                        break block14;
                    }
                }
            }
            org.w3c.dom.Node propNode = null;
            if (operationNode != null) {
                NodeList setChildList = operationNode.getChildNodes();
                block15: for (int i = 0; i < setChildList.getLength(); ++i) {
                    org.w3c.dom.Node currentNode = setChildList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            if (!currentNode.getNodeName().endsWith(":prop")) break;
                            propNode = currentNode;
                            break block15;
                        }
                    }
                }
            }
            resp.setStatus(207);
            resp.setContentType("text/xml; charset=UTF-8");
            XMLWriter generatedXML = new XMLWriter((Writer)resp.getWriter());
            generatedXML.writeXMLHeader();
            generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
            generatedXML.writeElement("D", "response", 0);
            generatedXML.writeElement("D", "href", 0);
            String path = this.getRelativePath(req);
            KiftdWebDAVResource resource = this.resources.getResource(path);
            String href = req.getContextPath() + req.getServletPath();
            href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
            if (resource.isDirectory() && !href.endsWith("/")) {
                href = href + "/";
            }
            String rewrittenUrl = this.rewriteUrl(href);
            generatedXML.writeText(rewrittenUrl);
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "propstat", 0);
            generatedXML.writeElement("D", "prop", 0);
            if (propNode != null) {
                NodeList propChildList = propNode.getChildNodes();
                block16: for (int i = 0; i < propChildList.getLength(); ++i) {
                    org.w3c.dom.Node currentNode = propChildList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block16;
                        }
                        case 1: {
                            String propName = currentNode.getNodeName();
                            if (propName.indexOf(58) != -1) {
                                propName = propName.substring(propName.indexOf(58) + 1);
                            }
                            generatedXML.writeElement(currentNode.getPrefix(), currentNode.getNamespaceURI(), propName, 2);
                            continue block16;
                        }
                    }
                }
            }
            generatedXML.writeElement("D", "prop", 1);
            generatedXML.writeElement("D", "status", 0);
            StringBuffer status = new StringBuffer("HTTP/1.1 ");
            if (resource.exists()) {
                status.append(403);
                status.append(" Forbidden");
            } else {
                status.append(404);
                status.append(" Not Found");
            }
            generatedXML.writeText(status.toString());
            generatedXML.writeElement("D", "status", 1);
            generatedXML.writeElement("D", "propstat", 1);
            generatedXML.writeElement("D", "response", 1);
            generatedXML.writeElement("D", "multistatus", 1);
            generatedXML.sendData();
            return;
        }
        catch (IOException | SAXException e) {
            this.lu.writeException(e);
            resp.setStatus(400);
            return;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Folder accessFolder;
        String account;
        String path = this.getRelativePath(request);
        try {
            account = this.getAccountFromRequestHeader(request);
        }
        catch (IllegalArgumentException | UnAuthorizedException e) {
            this.needAuthorizationByBasic(response);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(response);
            return;
        }
        KiftdWebDAVResource resource = this.resources.getResource(path);
        if (!resource.exists()) {
            response.setStatus(404);
            return;
        }
        if (!resource.canRead()) {
            response.setStatus(403);
            return;
        }
        KiftdWebDAVResource kiftdWebDAVResource = resource;
        Folder folder = accessFolder = kiftdWebDAVResource.isDirectory() ? kiftdWebDAVResource.getFolder() : this.fm.queryById(kiftdWebDAVResource.getNode().getFileParentFolder());
        if (!ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(accessFolder.getFolderId())) || !ConfigureReader.instance().accessFolder(accessFolder, account)) {
            this.needAuthorizationByBasic(response);
            return;
        }
        if (resource.isFile()) {
            Node n = resource.getNode();
            File fo = this.fbu.getFileFromBlocks(n);
            String ip = this.idg.getIpAddr(request);
            String range = request.getHeader("Range");
            if (fo != null) {
                int status = RangeFileStreamWriter.writeRangeFileStream(request, response, fo, n.getFileName(), CONTENT_STREAM, ConfigureReader.instance().getDownloadMaxRate(account), this.fbu.getETag(fo), true);
                if (status == 200 || range != null && range.startsWith("bytes=0-")) {
                    this.lu.writeDownloadFileEvent(account, ip, n);
                }
                return;
            }
            response.setStatus(500);
            return;
        }
        this.sendNotAllowed(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Folder accessFolder;
        String account;
        String path = this.getRelativePath(request);
        try {
            account = this.getAccountFromRequestHeader(request);
        }
        catch (IllegalArgumentException | UnAuthorizedException e) {
            this.needAuthorizationByBasic(response);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(response);
            return;
        }
        KiftdWebDAVResource resource = this.resources.getResource(path);
        if (!resource.exists()) {
            response.setStatus(404);
            return;
        }
        if (!resource.canRead()) {
            response.setStatus(403);
            return;
        }
        KiftdWebDAVResource kiftdWebDAVResource = resource;
        Folder folder = accessFolder = kiftdWebDAVResource.isDirectory() ? kiftdWebDAVResource.getFolder() : this.fm.queryById(kiftdWebDAVResource.getNode().getFileParentFolder());
        if (!ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(accessFolder.getFolderId())) || !ConfigureReader.instance().accessFolder(accessFolder, account)) {
            this.needAuthorizationByBasic(response);
            return;
        }
        if (resource.isFile()) {
            Node n = resource.getNode();
            File fo = this.fbu.getFileFromBlocks(n);
            if (fo != null) {
                RangeFileStreamWriter.writeRangeFileHead(request, response, fo, n.getFileName(), CONTENT_STREAM, this.fbu.getETag(fo), true);
                return;
            }
            response.setStatus(500);
            return;
        }
        this.sendNotAllowed(request, response);
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String account;
        String path = this.getRelativePath(req);
        KiftdWebDAVResource resource = this.resources.getResource(path);
        if (resource.exists() && resource.isDirectory()) {
            this.sendNotAllowed(req, resp);
            return;
        }
        if (this.isLocked(req)) {
            resp.setStatus(423);
            return;
        }
        if (req.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                resp.setStatus(501);
                return;
            }
            catch (SAXException saxe) {
                resp.setStatus(415);
                return;
            }
        }
        try {
            account = this.getAccountFromRequestHeader(req);
        }
        catch (IllegalArgumentException | UnAuthorizedException e) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        Folder parentFolder = this.resources.getFolderByPath(HttpPathUtil.getParentPath(path));
        if (!ConfigureReader.instance().accessFolder(parentFolder, account) || !ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(parentFolder.getFolderId()))) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        String folderName = HttpPathUtil.getResourceName(path);
        Folder newFolder = this.resources.mkdir(folderName, parentFolder, account);
        if (newFolder != null) {
            this.lu.writeCreateFolderEvent(account, this.idg.getIpAddr(req), newFolder);
            resp.setStatus(201);
            this.lockNullResources.remove(path);
        } else {
            resp.setStatus(409);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocked(req)) {
            resp.setStatus(423);
            return;
        }
        String path = this.getRelativePath(req);
        this.receiveResource(req, resp, path);
        this.lockNullResources.remove(path);
    }

    private void receiveResource(HttpServletRequest req, HttpServletResponse resp, String path) throws ServletException, IOException {
        File tempFile;
        String account;
        try {
            account = this.getAccountFromRequestHeader(req);
        }
        catch (IllegalArgumentException | UnAuthorizedException e) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        Folder parentFolder = this.resources.getFolderByPath(HttpPathUtil.getParentPath(path));
        if (parentFolder == null) {
            resp.setStatus(400);
            return;
        }
        if (!ConfigureReader.instance().accessFolder(parentFolder, account)) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        List<String> parentFoldersId = this.fu.getAllFoldersId(parentFolder.getFolderId());
        if (!ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES, parentFoldersId)) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        String pathFileName = HttpPathUtil.getResourceName(path);
        if (pathFileName.isEmpty()) {
            resp.setStatus(400);
            return;
        }
        Node originNode = this.resources.getNodeByPath(path);
        File originBlock = null;
        if (originNode != null && (originBlock = this.fbu.getFileFromBlocks(originNode)) != null && originBlock.length() > 0L && !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, parentFoldersId)) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        long maxSize = ConfigureReader.instance().getUploadFileSize(account);
        Range range = this.parseContentRange(req, resp);
        if (range == null) {
            return;
        }
        if (range == IGNORE) {
            tempFile = this.saveToTempFile(req, null, range, maxSize);
        } else if (originNode != null) {
            if (originBlock == null) {
                resp.setStatus(500);
                return;
            }
            tempFile = this.saveToTempFile(req, originBlock, range, maxSize);
        } else if (range.start == 0L) {
            tempFile = this.saveToTempFile(req, null, range, maxSize);
        } else {
            resp.setStatus(404);
            return;
        }
        if (tempFile == null) {
            resp.setStatus(413);
            return;
        }
        if (originNode != null && !this.fbu.deleteNode(originNode)) {
            resp.setStatus(409);
            return;
        }
        File block = this.fbu.saveToFileBlocks(tempFile);
        if (block == null) {
            tempFile.delete();
            resp.setStatus(409);
            return;
        }
        Node node = this.fbu.insertNewNode(pathFileName, account, block.getName(), this.fbu.getFileSize(block.length()), parentFolder.getFolderId());
        if (node == null) {
            block.delete();
            resp.setStatus(409);
            return;
        }
        resp.setStatus(201);
        this.lu.writeUploadFileEvent(req, node, account);
    }

    public File saveToTempFile(HttpServletRequest req, File oldBlock, Range range, long maxSize) throws IOException {
        File tempFile;
        if (tempDir.isDirectory() && (tempFile = new File(tempDir, "temp_" + UUID.randomUUID().toString().replace("-", "") + ".block")).createNewFile()) {
            long size = 0L;
            if (oldBlock != null && oldBlock.isFile()) {
                int numBytesRead;
                Files.copy(oldBlock.toPath(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                RandomAccessFile randAccessTempFile = new RandomAccessFile(tempFile, "rw");
                if (maxSize >= 0L && range.length > maxSize) {
                    randAccessTempFile.close();
                    tempFile.delete();
                    return null;
                }
                randAccessTempFile.setLength(range.length);
                randAccessTempFile.seek(range.start);
                byte[] transferBuffer = new byte[4096];
                ServletInputStream in = req.getInputStream();
                BufferedInputStream bufIn = new BufferedInputStream((InputStream)in, 4096);
                while ((numBytesRead = bufIn.read(transferBuffer)) != -1) {
                    randAccessTempFile.write(transferBuffer, 0, numBytesRead);
                    size += (long)numBytesRead;
                }
                randAccessTempFile.close();
            } else {
                int numBytesRead;
                FileOutputStream out = new FileOutputStream(tempFile);
                byte[] copyBuffer = new byte[4096];
                ServletInputStream in = req.getInputStream();
                BufferedInputStream bufIn = new BufferedInputStream((InputStream)in, 4096);
                while ((numBytesRead = bufIn.read(copyBuffer)) != -1) {
                    out.write(copyBuffer, 0, numBytesRead);
                    if (maxSize < 0L || (size += (long)numBytesRead) <= maxSize) continue;
                    out.close();
                    tempFile.delete();
                    return null;
                }
                bufIn.close();
                out.flush();
                out.close();
            }
            return tempFile;
        }
        throw new IOException();
    }

    protected Range parseContentRange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contentRangeHeader = request.getHeader("Content-Range");
        if (contentRangeHeader == null) {
            return IGNORE;
        }
        ContentRange contentRange = ContentRange.parse(new StringReader(contentRangeHeader));
        if (contentRange == null) {
            response.setStatus(400);
            return null;
        }
        if (!contentRange.getUnits().equals("bytes")) {
            response.setStatus(400);
            return null;
        }
        Range range = new Range();
        range.start = contentRange.getStart();
        range.end = contentRange.getEnd();
        range.length = contentRange.getLength();
        if (!range.validate()) {
            response.setStatus(400);
            return null;
        }
        return range;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String account;
        String lockTokenHeader;
        if (this.isLocked(req)) {
            resp.setStatus(423);
            return;
        }
        String path = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        if (this.isLocked(path, ifHeader + lockTokenHeader)) {
            resp.setStatus(423);
            return;
        }
        String depthStr = req.getHeader("Depth");
        if (depthStr != null && !depthStr.equals("infinity")) {
            resp.setStatus(400);
            return;
        }
        try {
            account = this.getAccountFromRequestHeader(req);
        }
        catch (IllegalArgumentException | UnAuthorizedException e) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        KiftdWebDAVResource resource = this.resources.getResource(path);
        if (!resource.exists()) {
            resp.setStatus(404);
            return;
        }
        if (resource.isFile()) {
            Node node = resource.getNode();
            if (node != null) {
                Folder parentFolder = this.fm.queryById(node.getFileParentFolder());
                if (!ConfigureReader.instance().accessFolder(parentFolder, account) || !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(parentFolder.getFolderId()))) {
                    this.needAuthorizationByBasic(resp);
                    return;
                }
                if (this.fbu.deleteNode(node)) {
                    this.lu.writeDeleteFileEvent(req, node);
                    resp.setStatus(204);
                    return;
                }
            }
            resp.setStatus(500);
            return;
        }
        Folder folder = resource.getFolder();
        if (folder != null) {
            Folder parentFolder = this.fm.queryById(folder.getFolderParent());
            if (!ConfigureReader.instance().accessFolder(parentFolder, account) || !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(parentFolder.getFolderId()))) {
                this.needAuthorizationByBasic(resp);
                return;
            }
            List<Folder> l = this.fu.getParentList(folder.getFolderId());
            if (this.fm.deleteById(folder.getFolderId()) > 0) {
                this.fu.deleteAllChildFolder(folder.getFolderId());
                this.lu.writeDeleteFolderEvent(req, folder, l);
                ServerInitListener.needCheck = true;
                resp.setStatus(204);
                return;
            }
        }
        resp.setStatus(500);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isLocked(req)) {
            resp.setStatus(423);
            return;
        }
        this.doMoveOrCopy(req, resp, true);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isLocked(req)) {
            resp.setStatus(423);
            return;
        }
        this.doMoveOrCopy(req, resp, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doMoveOrCopy(HttpServletRequest req, HttpServletResponse resp, boolean isCopy) throws IOException {
        String originPath;
        Folder originFolder;
        String newName;
        Folder parentFolder;
        Folder targetFolder;
        String destinationPath;
        KiftdWebDAVResource resource;
        String account;
        block59: {
            block60: {
                Folder conflictFolder;
                block58: {
                    block61: {
                        String depthStr = req.getHeader("Depth");
                        boolean copyAll = true;
                        if (depthStr != null && !depthStr.equals("infinity")) {
                            if (depthStr.equals("infinity")) {
                                copyAll = true;
                            } else {
                                if (!depthStr.equals("0")) {
                                    resp.setStatus(400);
                                    return;
                                }
                                if (!isCopy) {
                                    resp.setStatus(400);
                                    return;
                                }
                                copyAll = false;
                            }
                        }
                        try {
                            account = this.getAccountFromRequestHeader(req);
                        }
                        catch (IllegalArgumentException | UnAuthorizedException e2) {
                            this.needAuthorizationByBasic(resp);
                            return;
                        }
                        if (ConfigureReader.instance().mustLogin() && account == null) {
                            this.needAuthorizationByBasic(resp);
                            return;
                        }
                        String path = this.getRelativePath(req);
                        resource = this.resources.getResource(path);
                        if (!resource.exists()) {
                            resp.setStatus(404);
                            return;
                        }
                        destinationPath = this.getDestinationPath(req);
                        if (destinationPath == null) {
                            resp.setStatus(400);
                            return;
                        }
                        if (destinationPath.equals(path)) {
                            resp.sendError(403);
                            return;
                        }
                        targetFolder = this.resources.getFolderByPath(HttpPathUtil.getParentPath(destinationPath));
                        parentFolder = null;
                        parentFolder = resource.isDirectory() ? this.fm.queryById(resource.getFolder().getFolderParent()) : this.fm.queryById(resource.getNode().getFileParentFolder());
                        if (!ConfigureReader.instance().accessFolder(parentFolder, account) || !ConfigureReader.instance().accessFolder(targetFolder, account)) {
                            this.needAuthorizationByBasic(resp);
                            return;
                        }
                        newName = HttpPathUtil.getResourceName(destinationPath);
                        if (newName.isEmpty()) {
                            resp.setStatus(400);
                            return;
                        }
                        if (!newName.equals(resource.getName()) && !ConfigureReader.instance().authorized(account, AccountAuth.RENAME_FILE_OR_FOLDER, this.fu.getAllFoldersId(targetFolder.getFolderId()))) {
                            this.needAuthorizationByBasic(resp);
                            return;
                        }
                        if (!(parentFolder.getFolderId().equals(targetFolder.getFolderId()) || ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(parentFolder.getFolderId())) && ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(targetFolder.getFolderId())))) {
                            this.needAuthorizationByBasic(resp);
                            return;
                        }
                        boolean overwrite = true;
                        String overwriteHeader = req.getHeader("Overwrite");
                        if (overwriteHeader != null) {
                            overwrite = overwriteHeader.equalsIgnoreCase("T");
                        }
                        if (overwrite && !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(targetFolder.getFolderId()))) {
                            this.needAuthorizationByBasic(resp);
                            return;
                        }
                        if (resource.isFile()) {
                            Node originNode = resource.getNode();
                            String originPath2 = this.fbu.getNodePath(originNode);
                            if (this.nm.queryByParentFolderId(targetFolder.getFolderId()).parallelStream().anyMatch(e -> e.getFileName().equals(newName))) {
                                if (!overwrite) {
                                    resp.setStatus(412);
                                    return;
                                }
                                Node conflictNode = this.nm.queryByParentFolderId(targetFolder.getFolderId()).parallelStream().filter(e -> e.getFileName().equals(newName)).findFirst().get();
                                if (conflictNode.getFileId().equals(originNode.getFileId())) {
                                    resp.setStatus(204);
                                    return;
                                }
                                if (this.fbu.deleteNode(conflictNode)) {
                                    if (isCopy) {
                                        Node copyNode = this.fbu.insertNewNode(newName, account, originNode.getFilePath(), originNode.getFileSize(), targetFolder.getFolderId());
                                        if (copyNode != null) {
                                            this.lu.writeMoveFileEvent(account, this.idg.getIpAddr(req), originPath2, this.fbu.getNodePath(copyNode), true);
                                            resp.setStatus(204);
                                            return;
                                        }
                                    } else {
                                        originNode.setFileName(newName);
                                        originNode.setFileParentFolder(targetFolder.getFolderId());
                                        if (this.nm.update(originNode) > 0) {
                                            if (targetFolder.getFolderId().equals(parentFolder.getFolderId())) {
                                                this.lu.writeRenameFileEvent(account, this.idg.getIpAddr(req), targetFolder.getFolderId(), resource.getName(), newName);
                                            } else {
                                                this.lu.writeMoveFileEvent(account, this.idg.getIpAddr(req), originPath2, this.fbu.getNodePath(originNode), false);
                                            }
                                            resp.setStatus(204);
                                            return;
                                        }
                                    }
                                }
                                resp.setStatus(500);
                                return;
                            }
                            if (!parentFolder.getFolderId().equals(targetFolder.getFolderId()) && this.nm.countByParentFolderId(targetFolder.getFolderId()) >= Integer.MAX_VALUE) {
                                resp.setStatus(403);
                                return;
                            }
                            if (isCopy) {
                                Node newNode = this.fbu.insertNewNode(newName, account, originNode.getFilePath(), originNode.getFileSize(), targetFolder.getFolderId());
                                if (newNode != null) {
                                    this.lu.writeMoveFileEvent(account, this.idg.getIpAddr(req), originPath2, this.fbu.getNodePath(newNode), true);
                                    resp.setStatus(201);
                                    this.lockNullResources.remove(destinationPath);
                                    return;
                                }
                            } else {
                                originNode.setFileName(newName);
                                originNode.setFileParentFolder(targetFolder.getFolderId());
                                if (this.nm.update(originNode) > 0) {
                                    if (targetFolder.getFolderId().equals(parentFolder.getFolderId())) {
                                        this.lu.writeRenameFileEvent(account, this.idg.getIpAddr(req), targetFolder.getFolderId(), resource.getName(), newName);
                                    } else {
                                        this.lu.writeMoveFileEvent(account, this.idg.getIpAddr(req), originPath2, this.fbu.getNodePath(originNode), false);
                                    }
                                    resp.setStatus(201);
                                    this.lockNullResources.remove(destinationPath);
                                    return;
                                }
                            }
                            resp.setStatus(500);
                            return;
                        }
                        originFolder = resource.getFolder();
                        originPath = this.fu.getFolderPath(originFolder);
                        if (!isCopy && (originFolder.getFolderId().equals(targetFolder.getFolderId()) || this.fu.getParentList(targetFolder.getFolderId()).parallelStream().anyMatch(e -> e.getFolderId().equals(originFolder.getFolderId())))) {
                            resp.setStatus(403);
                            return;
                        }
                        if (!this.fm.queryByParentId(targetFolder.getFolderId()).parallelStream().anyMatch(e -> e.getFolderName().equals(newName))) break block59;
                        if (!overwrite) {
                            resp.setStatus(412);
                            return;
                        }
                        conflictFolder = this.fm.queryByParentId(targetFolder.getFolderId()).parallelStream().filter(e -> e.getFolderName().equals(newName)).findFirst().get();
                        if (this.fm.deleteById(conflictFolder.getFolderId()) <= 0) break block60;
                        if (!isCopy) break block61;
                        if (copyAll) {
                            Folder newFolder = this.fu.copyFolderByNewNameToPath(conflictFolder, account, targetFolder, newName);
                            if (newFolder != null) {
                                this.lu.writeMoveFolderEvent(account, this.idg.getIpAddr(req), originPath, this.fu.getFolderPath(newFolder), true);
                                resp.setStatus(204);
                                this.lockNullResources.remove(destinationPath);
                                return;
                            }
                            break block58;
                        } else {
                            int constraint = originFolder.getFolderConstraint();
                            if (originFolder.getFolderConstraint() < targetFolder.getFolderConstraint()) {
                                constraint = targetFolder.getFolderConstraint();
                            }
                            try {
                                Folder newFolder = this.fu.createNewFolder(targetFolder.getFolderId(), account, newName, "" + constraint);
                                if (newFolder != null && this.fu.isValidFolder(newFolder)) {
                                    this.lu.writeCreateFolderEvent(account, this.idg.getIpAddr(req), newFolder);
                                    resp.setStatus(204);
                                    this.lockNullResources.remove(destinationPath);
                                    return;
                                }
                                break block58;
                            }
                            catch (FoldersTotalOutOfLimitException newFolder) {}
                        }
                        break block58;
                    }
                    originFolder.setFolderParent(targetFolder.getFolderId());
                    originFolder.setFolderName(newName);
                    int originConstraint = originFolder.getFolderConstraint();
                    boolean needChangeChildsConstranint = false;
                    if (originFolder.getFolderConstraint() < targetFolder.getFolderConstraint()) {
                        originFolder.setFolderConstraint(targetFolder.getFolderConstraint());
                        needChangeChildsConstranint = true;
                    }
                    if (this.fm.update(originFolder) > 0) {
                        if (needChangeChildsConstranint) {
                            this.fu.changeChildFolderConstraint(originFolder.getFolderId(), targetFolder.getFolderConstraint());
                        }
                        if (parentFolder.getFolderId().equals(targetFolder.getFolderId())) {
                            this.lu.writeRenameFolderEvent(account, this.idg.getIpAddr(req), originFolder.getFolderId(), resource.getName(), newName, "" + originConstraint, "" + originFolder.getFolderConstraint());
                        } else {
                            this.lu.writeMoveFolderEvent(account, this.idg.getIpAddr(req), originPath, this.fu.getFolderPath(originFolder), false);
                        }
                        resp.setStatus(204);
                        this.lockNullResources.remove(destinationPath);
                        return;
                    }
                }
                ServerInitListener.needCheck = true;
                this.fu.deleteAllChildFolder(conflictFolder.getFolderId());
            }
            resp.setStatus(500);
            return;
        }
        if (!parentFolder.getFolderId().equals(targetFolder.getFolderId()) && this.fm.countByParentId(targetFolder.getFolderId()) >= Integer.MAX_VALUE) {
            resp.setStatus(403);
            return;
        }
        if (isCopy) {
            Folder newFolder = this.fu.copyFolderByNewNameToPath(originFolder, account, parentFolder, newName);
            if (newFolder != null) {
                this.lu.writeMoveFolderEvent(account, this.idg.getIpAddr(req), originPath, this.fu.getFolderPath(newFolder), true);
                resp.setStatus(204);
                this.lockNullResources.remove(destinationPath);
                return;
            }
        } else {
            originFolder.setFolderParent(targetFolder.getFolderId());
            originFolder.setFolderName(newName);
            int originConstraint = originFolder.getFolderConstraint();
            boolean needChangeChildsConstranint = false;
            if (originFolder.getFolderConstraint() < targetFolder.getFolderConstraint()) {
                originFolder.setFolderConstraint(targetFolder.getFolderConstraint());
                needChangeChildsConstranint = true;
            }
            if (this.fm.update(originFolder) > 0) {
                if (needChangeChildsConstranint) {
                    this.fu.changeChildFolderConstraint(originFolder.getFolderId(), targetFolder.getFolderConstraint());
                }
                if (parentFolder.getFolderId().equals(targetFolder.getFolderId())) {
                    this.lu.writeRenameFolderEvent(account, this.idg.getIpAddr(req), originFolder.getFolderId(), resource.getName(), newName, "" + originConstraint, "" + originFolder.getFolderConstraint());
                } else {
                    this.lu.writeMoveFolderEvent(account, this.idg.getIpAddr(req), originPath, this.fu.getFolderPath(originFolder), false);
                }
                resp.setStatus(201);
                this.lockNullResources.remove(destinationPath);
                return;
            }
        }
        resp.setStatus(500);
    }

    private String getDestinationPath(HttpServletRequest req) {
        String reqContextPath;
        URI destinationUri;
        String destinationHeader = req.getHeader("Destination");
        if (destinationHeader == null || destinationHeader.isEmpty()) {
            return null;
        }
        try {
            destinationUri = new URI(destinationHeader);
        }
        catch (URISyntaxException e) {
            return null;
        }
        String destinationPath = destinationUri.getPath();
        if (!destinationPath.equals(RequestUtil.normalize((String)destinationPath))) {
            return null;
        }
        if (destinationUri.isAbsolute()) {
            if (!req.getScheme().equals(destinationUri.getScheme()) || !req.getServerName().equals(destinationUri.getHost())) {
                return null;
            }
            if (!(req.getServerPort() == destinationUri.getPort() || destinationUri.getPort() == -1 && ("http".equals(req.getScheme()) && req.getServerPort() == 80 || "https".equals(req.getScheme()) && req.getServerPort() == 443))) {
                return null;
            }
        }
        if (!destinationPath.startsWith((reqContextPath = req.getContextPath()) + "/")) {
            return null;
        }
        destinationPath = destinationPath.substring(reqContextPath.length() + req.getServletPath().length());
        return destinationPath;
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path;
        String account;
        if (this.isLocked(req)) {
            resp.setStatus(423);
            return;
        }
        try {
            account = this.getAccountFromRequestHeader(req);
        }
        catch (IllegalArgumentException | UnAuthorizedException e1) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        String AuthFolderPath = path = this.getRelativePath(req);
        Folder parentFolder = null;
        while (parentFolder == null && !AuthFolderPath.isEmpty()) {
            AuthFolderPath = HttpPathUtil.getParentPath(AuthFolderPath);
            parentFolder = this.resources.getFolderByPath(AuthFolderPath);
        }
        if (parentFolder == null) {
            resp.setStatus(400);
            return;
        }
        if (!ConfigureReader.instance().accessFolder(parentFolder, account) || !ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES, this.fu.getAllFoldersId(parentFolder.getFolderId()))) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        LockInfo lock = new LockInfo(this.maxDepth);
        String depthStr = req.getHeader("Depth");
        lock.depth = depthStr == null ? this.maxDepth : (depthStr.equals("0") ? 0 : this.maxDepth);
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            int commaPos = lockDurationStr.indexOf(44);
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = Integer.parseInt(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = Integer.parseInt(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock.expiresAt = System.currentTimeMillis() + (long)(lockDuration * 1000);
        boolean lockRequestType = false;
        org.w3c.dom.Node lockInfoNode = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            lockInfoNode = rootElement;
        }
        catch (IOException | SAXException e) {
            lockRequestType = true;
        }
        if (lockInfoNode != null) {
            org.w3c.dom.Node currentNode;
            int i;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            org.w3c.dom.Node lockScopeNode = null;
            org.w3c.dom.Node lockTypeNode = null;
            org.w3c.dom.Node lockOwnerNode = null;
            block23: for (i = 0; i < childList.getLength(); ++i) {
                currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block23;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        if (nodeName.endsWith("lockscope")) {
                            lockScopeNode = currentNode;
                        }
                        if (nodeName.endsWith("locktype")) {
                            lockTypeNode = currentNode;
                        }
                        if (!nodeName.endsWith("owner")) continue block23;
                        lockOwnerNode = currentNode;
                    }
                }
            }
            if (lockScopeNode != null) {
                childList = lockScopeNode.getChildNodes();
                block24: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block24;
                        }
                        case 1: {
                            String tempScope = currentNode.getNodeName();
                            lock.scope = tempScope.indexOf(58) != -1 ? tempScope.substring(tempScope.indexOf(58) + 1) : tempScope;
                        }
                    }
                }
                if (lock.scope == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockTypeNode != null) {
                childList = lockTypeNode.getChildNodes();
                block25: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block25;
                        }
                        case 1: {
                            String tempType = currentNode.getNodeName();
                            lock.type = tempType.indexOf(58) != -1 ? tempType.substring(tempType.indexOf(58) + 1) : tempType;
                        }
                    }
                }
                if (lock.type == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                block26: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            lock.owner = lock.owner + currentNode.getNodeValue();
                            continue block26;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter(strWriter);
                            domWriter.print(currentNode);
                            lock.owner = lock.owner + strWriter.toString();
                        }
                    }
                }
                if (lock.owner == null) {
                    resp.setStatus(400);
                }
            } else {
                lock.owner = "";
            }
        }
        KiftdWebDAVResource resource = this.resources.getResource(path);
        lock.path = path;
        Enumeration<LockInfo> locksList = null;
        if (!lockRequestType) {
            String lockTokenStr = req.getServletPath() + "-" + lock.type + "-" + lock.scope + "-" + account + "-" + lock.depth + "-" + lock.owner + "-" + lock.tokens + "-" + lock.expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            String lockToken = MD5Encoder.encode((byte[])ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{lockTokenStr.getBytes(StandardCharsets.ISO_8859_1)}));
            if (resource.isDirectory() && lock.depth == this.maxDepth) {
                LockInfo currentLock;
                Vector<String> lockPaths = new Vector<String>();
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                locksList = this.resourceLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                if (!lockPaths.isEmpty()) {
                    Enumeration lockPathsList = lockPaths.elements();
                    resp.setStatus(409);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    while (lockPathsList.hasMoreElements()) {
                        generatedXML.writeElement("D", "response", 0);
                        generatedXML.writeElement("D", "href", 0);
                        generatedXML.writeText((String)lockPathsList.nextElement());
                        generatedXML.writeElement("D", "href", 1);
                        generatedXML.writeElement("D", "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 ");
                        generatedXML.writeElement("D", "status", 1);
                        generatedXML.writeElement("D", "response", 1);
                    }
                    generatedXML.writeElement("D", "multistatus", 1);
                    PrintWriter writer = resp.getWriter();
                    ((Writer)writer).write(generatedXML.toString());
                    ((Writer)writer).close();
                    return;
                }
                boolean addLock = true;
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock2 = locksList.nextElement();
                    if (!currentLock2.path.equals(lock.path)) continue;
                    if (currentLock2.isExclusive()) {
                        resp.setStatus(423);
                        return;
                    }
                    if (lock.isExclusive()) {
                        resp.setStatus(423);
                        return;
                    }
                    currentLock2.tokens.addElement(lockToken);
                    lock = currentLock2;
                    addLock = false;
                }
                if (addLock) {
                    lock.tokens.addElement(lockToken);
                    this.collectionLocks.addElement(lock);
                }
            } else {
                LockInfo presentLock = this.resourceLocks.get(lock.path);
                if (presentLock != null) {
                    if (presentLock.isExclusive() || lock.isExclusive()) {
                        resp.setStatus(412);
                        return;
                    }
                    presentLock.tokens.addElement(lockToken);
                    lock = presentLock;
                } else {
                    lock.tokens.addElement(lockToken);
                    this.resourceLocks.put(lock.path, lock);
                    if (!resource.exists()) {
                        int slash = lock.path.lastIndexOf(47);
                        String parentPath = lock.path.substring(0, slash);
                        Vector<String> lockNulls = this.lockNullResources.get(parentPath);
                        if (lockNulls == null) {
                            lockNulls = new Vector();
                            this.lockNullResources.put(parentPath, lockNulls);
                        }
                        lockNulls.addElement(lock.path);
                    }
                    resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
                }
            }
        }
        if (lockRequestType) {
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                ifHeader = "";
            }
            LockInfo toRenew = this.resourceLocks.get(path);
            Enumeration<String> tokenList = null;
            if (toRenew != null) {
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (!ifHeader.contains(token)) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
            Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
            while (collectionLocksList.hasMoreElements()) {
                toRenew = collectionLocksList.nextElement();
                if (!path.equals(toRenew.path)) continue;
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (!ifHeader.contains(token)) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        generatedXML.writeElement("D", "lockdiscovery", 0);
        lock.toXML(generatedXML);
        generatedXML.writeElement("D", "lockdiscovery", 1);
        generatedXML.writeElement("D", "prop", 1);
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path;
        String account;
        if (this.isLocked(req)) {
            resp.setStatus(423);
            return;
        }
        try {
            account = this.getAccountFromRequestHeader(req);
        }
        catch (IllegalArgumentException | UnAuthorizedException e1) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        if (ConfigureReader.instance().mustLogin() && account == null) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        String AuthFolderPath = path = this.getRelativePath(req);
        Folder parentFolder = null;
        while (parentFolder == null && !AuthFolderPath.isEmpty()) {
            AuthFolderPath = HttpPathUtil.getParentPath(AuthFolderPath);
            parentFolder = this.resources.getFolderByPath(AuthFolderPath);
        }
        if (parentFolder == null) {
            resp.setStatus(400);
            return;
        }
        if (!ConfigureReader.instance().accessFolder(parentFolder, account) || !ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES, this.fu.getAllFoldersId(parentFolder.getFolderId()))) {
            this.needAuthorizationByBasic(resp);
            return;
        }
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            lockTokenHeader = "";
        }
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null) {
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (!lockTokenHeader.contains(token)) continue;
                lock.tokens.removeElement(token);
            }
            if (lock.tokens.isEmpty()) {
                this.resourceLocks.remove(path);
                this.lockNullResources.remove(path);
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (!path.equals(lock.path)) continue;
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (!lockTokenHeader.contains(token)) continue;
                lock.tokens.removeElement(token);
                break;
            }
            if (!lock.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lock);
            this.lockNullResources.remove(path);
        }
        resp.setStatus(204);
    }

    private boolean isLocked(HttpServletRequest req) {
        String lockTokenHeader;
        String path = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        return this.isLocked(path, ifHeader + lockTokenHeader);
    }

    private boolean isLocked(String path, String ifHeader) {
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null && lock.hasExpired()) {
            this.resourceLocks.remove(path);
        } else if (lock != null) {
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (!ifHeader.contains(token)) continue;
                tokenMatch = true;
                break;
            }
            if (!tokenMatch) {
                return true;
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (lock.hasExpired()) {
                this.collectionLocks.removeElement(lock);
                continue;
            }
            if (!path.startsWith(lock.path)) continue;
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (!ifHeader.contains(token)) continue;
                tokenMatch = true;
                break;
            }
            if (tokenMatch) continue;
            return true;
        }
        return false;
    }

    private void parseProperties(HttpServletRequest req, XMLWriter generatedXML, String path, WebResource resource, int type, Vector<String> propertiesVector) {
        if (!resource.exists()) {
            return;
        }
        String href = req.getContextPath() + req.getServletPath();
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (resource.isDirectory() && !href.endsWith("/")) {
            href = href + "/";
        }
        String rewrittenUrl = this.rewriteUrl(href);
        this.generatePropFindResponse(generatedXML, rewrittenUrl, path, type, propertiesVector, resource.isFile(), false, resource.getCreation(), resource.getLastModified(), resource.getContentLength(), this.getServletContext().getMimeType(resource.getName()), this.generateETag(resource));
    }

    private void parseLockNullProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        LockInfo lock = this.resourceLocks.get(path);
        if (lock == null) {
            return;
        }
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        String toAppend = path.substring(relativePath.length());
        if (!toAppend.startsWith("/")) {
            toAppend = "/" + toAppend;
        }
        String rewrittenUrl = this.rewriteUrl(RequestUtil.normalize((String)(absoluteUri + toAppend)));
        this.generatePropFindResponse(generatedXML, rewrittenUrl, path, type, propertiesVector, true, true, lock.creationDate.getTime(), lock.creationDate.getTime(), 0L, "", "");
    }

    private void generatePropFindResponse(XMLWriter generatedXML, String rewrittenUrl, String path, int propFindType, Vector<String> propertiesVector, boolean isFile, boolean isLockNull, long created, long lastModified, long contentLength, String contentType, String eTag) {
        generatedXML.writeElement("D", "response", 0);
        String status = "HTTP/1.1 200 ";
        generatedXML.writeElement("D", "href", 0);
        generatedXML.writeText(rewrittenUrl);
        generatedXML.writeElement("D", "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (propFindType) {
            case 1: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(created));
                generatedXML.writeElement("D", "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("D", "displayname", 1);
                if (isFile) {
                    generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                    generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                    if (contentType != null) {
                        generatedXML.writeProperty("D", "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty("D", "getetag", eTag);
                    if (isLockNull) {
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "lock-null", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                    } else {
                        generatedXML.writeElement("D", "resourcetype", 2);
                    }
                } else {
                    generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                    generatedXML.writeElement("D", "resourcetype", 0);
                    generatedXML.writeElement("D", "collection", 2);
                    generatedXML.writeElement("D", "resourcetype", 1);
                }
                generatedXML.writeProperty("D", "source", "");
                String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                generatedXML.writeElement("D", "displayname", 2);
                if (isFile) {
                    generatedXML.writeElement("D", "getcontentlanguage", 2);
                    generatedXML.writeElement("D", "getcontentlength", 2);
                    generatedXML.writeElement("D", "getcontenttype", 2);
                    generatedXML.writeElement("D", "getetag", 2);
                    generatedXML.writeElement("D", "getlastmodified", 2);
                }
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "source", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(created));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement("D", "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (isFile) {
                            generatedXML.writeElement("D", "getcontentlanguage", 2);
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getcontenttype", contentType);
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getetag", eTag);
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (isFile) {
                            if (isLockNull) {
                                generatedXML.writeElement("D", "resourcetype", 0);
                                generatedXML.writeElement("D", "lock-null", 2);
                                generatedXML.writeElement("D", "resourcetype", 1);
                                continue;
                            }
                            generatedXML.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "collection", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty("D", "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = "HTTP/1.1 404 ";
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement("D", (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String path, XMLWriter generatedXML) {
        LockInfo resourceLock = this.resourceLocks.get(path);
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        boolean wroteStart = false;
        if (resourceLock != null) {
            wroteStart = true;
            generatedXML.writeElement("D", "lockdiscovery", 0);
            resourceLock.toXML(generatedXML);
        }
        while (collectionLocksList.hasMoreElements()) {
            LockInfo currentLock = collectionLocksList.nextElement();
            if (!path.startsWith(currentLock.path)) continue;
            if (!wroteStart) {
                wroteStart = true;
                generatedXML.writeElement("D", "lockdiscovery", 0);
            }
            currentLock.toXML(generatedXML);
        }
        if (!wroteStart) {
            return false;
        }
        generatedXML.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long creationDate) {
        return creationDateFormat.format(new Date(creationDate));
    }

    protected String determineMethodsAllowed(HttpServletRequest req) {
        KiftdWebDAVResource resource = this.resources.getResource(this.getRelativePath(req));
        StringBuilder methodsAllowed = new StringBuilder("OPTIONS, DELETE, LOCK, UNLOCK, PROPPATCH, COPY, MOVE, PROPFIND");
        if (!resource.isDirectory()) {
            methodsAllowed.append(", PUT, GET, POST, HEAD");
        }
        if (req instanceof RequestFacade && ((RequestFacade)req).getAllowTrace()) {
            methodsAllowed.append(", TRACE");
        }
        if (!resource.exists()) {
            methodsAllowed.append(", MKCOL");
        }
        return methodsAllowed.toString();
    }

    protected void sendNotAllowed(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.addHeader("Allow", this.determineMethodsAllowed(req));
        resp.setStatus(405);
    }

    protected String generateETag(WebResource resource) {
        return resource.getETag();
    }

    static {
        URL_ENCODER_XML.removeSafeCharacter('&');
        creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
        IGNORE = new Range();
    }

    protected static class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }
    }

    private static class WebdavResolver
    implements EntityResolver {
        private WebdavResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    private static class LockInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int maxDepth;
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector<String> tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public LockInfo(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Type:");
            result.append(this.type);
            result.append("\nScope:");
            result.append(this.scope);
            result.append("\nDepth:");
            result.append(this.depth);
            result.append("\nOwner:");
            result.append(this.owner);
            result.append("\nExpiration:");
            result.append(FastHttpDateFormat.formatDate(this.expiresAt));
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                result.append("\nToken:");
                result.append(tokensList.nextElement());
            }
            result.append("\n");
            return result.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter generatedXML) {
            generatedXML.writeElement("D", "activelock", 0);
            generatedXML.writeElement("D", "locktype", 0);
            generatedXML.writeElement("D", this.type, 2);
            generatedXML.writeElement("D", "locktype", 1);
            generatedXML.writeElement("D", "lockscope", 0);
            generatedXML.writeElement("D", this.scope, 2);
            generatedXML.writeElement("D", "lockscope", 1);
            generatedXML.writeElement("D", "depth", 0);
            if (this.depth == this.maxDepth) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText("0");
            }
            generatedXML.writeElement("D", "depth", 1);
            generatedXML.writeElement("D", "owner", 0);
            generatedXML.writeText(this.owner);
            generatedXML.writeElement("D", "owner", 1);
            generatedXML.writeElement("D", "timeout", 0);
            long timeout = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            generatedXML.writeText("Second-" + timeout);
            generatedXML.writeElement("D", "timeout", 1);
            generatedXML.writeElement("D", "locktoken", 0);
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                generatedXML.writeElement("D", "href", 0);
                generatedXML.writeText("opaquelocktoken:" + tokensList.nextElement());
                generatedXML.writeElement("D", "href", 1);
            }
            generatedXML.writeElement("D", "locktoken", 1);
            generatedXML.writeElement("D", "activelock", 1);
        }
    }
}

