/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Random;
import kohgylw.kiftd.server.util.VerificationCode;

public class VerificationCodeFactory {
    private char[] alternative;
    private static final Random RANDOM = new Random();
    private int width;
    private int height;
    private int maxLine;
    private int maxOval;
    private int charSize;

    public VerificationCodeFactory(int charSize, int maxLine, int maxOval, char ... alternative) {
        if (alternative == null || alternative.length == 0 || charSize <= 0 || maxLine < 0 || maxOval < 0) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u5de5\u5382\uff1a\u53c2\u6570\u6709\u8bef\uff0c\u5b57\u4f53\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0\uff0c\u6700\u5927\u884c\u6570\u548c\u6700\u5927\u692d\u5706\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff0c\u81f3\u5c11\u63d0\u4f9b\u4e00\u4e2a\u5019\u9009\u5b57\u7b26\u3002");
        }
        this.alternative = alternative;
        this.charSize = charSize;
        this.maxLine = maxLine;
        this.maxOval = maxOval;
        this.height = charSize + 10;
    }

    public VerificationCode next(int length) {
        int end_y;
        int end_x;
        int start_y;
        int start_x;
        int i;
        if (length <= 0) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u5de5\u5382\uff1alength\u5fc5\u987b\u5927\u4e8e0\uff0c\u4f46\u662f\u4f20\u5165length=" + length);
        }
        StringBuffer codeBuffer = new StringBuffer();
        VerificationCode result = new VerificationCode();
        this.width = (length + 1) * this.charSize;
        for (int i2 = 0; i2 < length; ++i2) {
            codeBuffer.append(this.alternative[RANDOM.nextInt(this.alternative.length)]);
        }
        result.setCode(codeBuffer.toString());
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        for (i = 0; i < this.maxLine; ++i) {
            graphics.setColor(VerificationCodeFactory.getRandomColor());
            graphics.setStroke(new BasicStroke(RANDOM.nextInt(this.charSize) / 2 + 1));
            start_x = RANDOM.nextInt(this.width);
            start_y = RANDOM.nextInt(this.height);
            end_x = RANDOM.nextInt(this.width);
            end_y = RANDOM.nextInt(this.height);
            graphics.drawLine(start_x, start_y, end_x, end_y);
        }
        for (i = 0; i < this.maxOval; ++i) {
            graphics.setColor(VerificationCodeFactory.getRandomColor());
            graphics.setStroke(new BasicStroke(RANDOM.nextInt(this.charSize) / 2 + 1));
            start_x = RANDOM.nextInt(this.width);
            start_y = RANDOM.nextInt(this.height);
            end_x = RANDOM.nextInt(this.width);
            end_y = RANDOM.nextInt(this.height);
            graphics.drawOval(start_x, start_y, end_x, end_y);
        }
        Font font = new Font("songti", 1, this.charSize);
        for (int i3 = 0; i3 < codeBuffer.length(); ++i3) {
            graphics.setColor(VerificationCodeFactory.getRandomColor());
            graphics.setFont(font.deriveFont(AffineTransform.getRotateInstance(Math.toRadians(RANDOM.nextInt(90)), 0.0, -this.charSize / 2)));
            graphics.drawString(String.valueOf(codeBuffer.charAt(i3)), (i3 + 1) * this.charSize, this.charSize);
        }
        result.setImage(image);
        return result;
    }

    private static Color getRandomColor() {
        int r = RANDOM.nextInt(255);
        int g = RANDOM.nextInt(255);
        int b = RANDOM.nextInt(255);
        while (r > 200 && g > 200 && b > 200) {
            r = RANDOM.nextInt(255);
            g = RANDOM.nextInt(255);
            b = RANDOM.nextInt(255);
        }
        return new Color(r, g, b);
    }
}

