/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpSession;

public class VariableSpeedBufferedOutputStream
extends BufferedOutputStream {
    private long maxRate;
    private HttpSession session;
    private long writtenLength;
    private long startTime;

    public VariableSpeedBufferedOutputStream(OutputStream out, long maxRate, HttpSession session) {
        super(out);
        this.maxRate = maxRate;
        this.session = session;
        this.writtenLength = 0L;
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.maxRate > 0L) {
            int startIndex = off;
            int surplusLength = len;
            while (surplusLength > 0) {
                HttpSession httpSession = this.session;
                synchronized (httpSession) {
                    long shouldWriteLength;
                    if (this.writtenLength == 0L) {
                        this.startTime = System.currentTimeMillis();
                    }
                    if ((long)surplusLength > (shouldWriteLength = this.maxRate - this.writtenLength)) {
                        super.write(b, startIndex, (int)shouldWriteLength);
                        startIndex = (int)((long)startIndex + shouldWriteLength);
                        this.writtenLength += shouldWriteLength;
                        surplusLength = (int)((long)surplusLength - shouldWriteLength);
                    } else {
                        super.write(b, startIndex, surplusLength);
                        startIndex += surplusLength;
                        this.writtenLength += (long)surplusLength;
                        surplusLength -= surplusLength;
                    }
                    if (this.writtenLength >= this.maxRate) {
                        long consumeTime = System.currentTimeMillis() - this.startTime;
                        if (consumeTime < 1000L) {
                            try {
                                Thread.sleep(1000L - consumeTime);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        this.writtenLength = 0L;
                    }
                }
            }
        } else if (this.maxRate < 0L) {
            super.write(b, off, len);
        } else {
            throw new IllegalArgumentException("Error:invalid maximum download rate value.");
        }
    }
}

