/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Arrays;
import kohgylw.kiftd.server.util.CharsetDetectionObserverImpl;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;
import org.springframework.stereotype.Component;

@Component
public class TxtCharsetGetter {
    public String getTxtCharset(InputStream in) throws Exception {
        int len;
        int lang = 2;
        nsDetector det = new nsDetector(lang);
        CharsetDetectionObserverImpl cdoi = new CharsetDetectionObserverImpl();
        det.Init((nsICharsetDetectionObserver)cdoi);
        BufferedInputStream imp = new BufferedInputStream(in);
        byte[] buf = new byte[1024];
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || !det.DoIt(buf, len, false)) continue;
        }
        imp.close();
        in.close();
        det.DataEnd();
        if (isAscii) {
            return "ASCII";
        }
        if (cdoi.getCharset() != null) {
            return cdoi.getCharset();
        }
        String[] prob = det.getProbableCharsets();
        if (prob != null && prob.length > 0) {
            return prob[0];
        }
        return "GBK";
    }

    public String getTxtCharset(byte[] buf, int offset, int length) throws Exception {
        int lang = 2;
        nsDetector det = new nsDetector(lang);
        CharsetDetectionObserverImpl cdoi = new CharsetDetectionObserverImpl();
        det.Init((nsICharsetDetectionObserver)cdoi);
        boolean isAscii = true;
        byte[] array = Arrays.copyOfRange(buf, offset, offset + length);
        if (isAscii) {
            isAscii = det.isAscii(array, length);
        }
        if (!isAscii) {
            det.DoIt(array, length, false);
        }
        det.DataEnd();
        if (isAscii) {
            return "ASCII";
        }
        if (cdoi.getCharset() != null) {
            return cdoi.getCharset();
        }
        String[] prob = det.getProbableCharsets();
        if (prob != null && prob.length > 0) {
            return prob[0];
        }
        return "GBK";
    }
}

