/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.annotation.Resource;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.TxtCharsetGetter;
import org.springframework.stereotype.Component;

@Component
public class Txt2PDFUtil {
    @Resource
    private TxtCharsetGetter tcg;

    public void convertPdf(File in, OutputStream out) throws Exception {
        Rectangle rect = new Rectangle(PageSize.A4);
        Document doc = new Document(rect);
        PdfWriter pw = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        doc.open();
        BaseFont songFont = BaseFont.createFont((String)(ConfigureReader.instance().getPath() + File.separator + "fonts/wqy-zenhei.ttc,0"), (String)"Identity-H", (boolean)false);
        Font font = new Font(songFont, 12.0f, 0);
        Paragraph paragraph = new Paragraph();
        paragraph.setFont(font);
        String charset = this.tcg.getTxtCharset(new FileInputStream(in));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), charset));
        String line = null;
        while ((line = reader.readLine()) != null) {
            paragraph.add((Object)(line + "\n"));
        }
        reader.close();
        if (paragraph.isEmpty()) {
            paragraph.add((Object)"");
        }
        doc.add((Element)paragraph);
        doc.close();
        pw.flush();
        pw.close();
    }
}

