/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.Locale;

public class ServerTimeUtil {
    public static String accurateToSecond() {
        LocalDateTime ldt = LocalDateTime.now();
        DateTimeFormatter dtfDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        return dtfDateTimeFormatter.format(ldt);
    }

    public static String accurateToMinute() {
        LocalDateTime ldt = LocalDateTime.now();
        DateTimeFormatter dtfDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
        return dtfDateTimeFormatter.format(ldt);
    }

    public static String accurateToDay() {
        LocalDateTime ldt = LocalDateTime.now();
        DateTimeFormatter dtfDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return dtfDateTimeFormatter.format(ldt);
    }

    public static String accurateToLogName() {
        LocalDateTime ldt = LocalDateTime.now();
        DateTimeFormatter dtfDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy_MM_dd");
        return dtfDateTimeFormatter.format(ldt);
    }

    public static Date getServerTime() {
        return new Date();
    }

    public static String getLastModifiedFormBlock(File block) {
        ZonedDateTime longToTime = block != null && block.exists() ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(block.lastModified()), ZoneId.of("GMT")) : ZonedDateTime.now(ZoneId.of("GMT"));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).withZone(ZoneId.of("GMT"));
        return longToTime.format(dtf);
    }

    public static long getTimeFromDateAccurateToDay(String date) {
        try {
            DateTimeFormatter dtfDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
            LocalDate ld = dtfDateTimeFormatter.parse((CharSequence)date, TemporalQueries.localDate());
            Instant instant = ld.atTime(LocalTime.MIDNIGHT).atZone(ZoneId.systemDefault()).toInstant();
            return instant.toEpochMilli();
        }
        catch (DateTimeParseException e) {
            return 0L;
        }
    }
}

