/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.EncodeUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.server.util.VariableSpeedBufferedOutputStream;

public class RangeFileStreamWriter {
    private static final long DOWNLOAD_CACHE_MAX_AGE = 1800L;

    public static int writeRangeFileStream(HttpServletRequest request, HttpServletResponse response, File fo, String fname, String contentType, long maxRate, String eTag, boolean isAttachment) {
        return RangeFileStreamWriter.writeRangeFile(request, response, fo, fname, contentType, maxRate, eTag, isAttachment, true);
    }

    public static int writeRangeFileHead(HttpServletRequest request, HttpServletResponse response, File fo, String fname, String contentType, String eTag, boolean isAttachment) {
        return RangeFileStreamWriter.writeRangeFile(request, response, fo, fname, contentType, -1L, eTag, isAttachment, false);
    }

    private static int writeRangeFile(HttpServletRequest request, HttpServletResponse response, File fo, String fname, String contentType, long maxRate, String eTag, boolean isAttachment, boolean sendBody) {
        String ifUnmodifiedSince;
        long fileLength = fo.length();
        long startOffset = 0L;
        boolean hasEnd = false;
        long endOffset = 0L;
        long contentLength = 0L;
        String rangeBytes = "";
        int status = 200;
        String lastModified = ServerTimeUtil.getLastModifiedFormBlock(fo);
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (ifModifiedSince != null || ifNoneMatch != null) {
            if (ifNoneMatch != null) {
                if (ifNoneMatch.trim().equals(eTag)) {
                    status = 304;
                    response.setStatus(status);
                    return status;
                }
            } else if (ifModifiedSince.trim().equals(lastModified)) {
                status = 304;
                response.setStatus(status);
                return status;
            }
        }
        if ((ifUnmodifiedSince = request.getHeader("If-Unmodified-Since")) != null && !ifUnmodifiedSince.trim().equals(lastModified)) {
            status = 412;
            response.setStatus(status);
            return status;
        }
        String ifMatch = request.getHeader("If-Match");
        if (ifMatch != null && !ifMatch.trim().equals(eTag)) {
            status = 412;
            response.setStatus(status);
            return status;
        }
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        if (isAttachment) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + EncodeUtil.getFileNameByUTF8(fname) + "\"; filename*=utf-8''" + EncodeUtil.getFileNameByUTF8(fname));
        } else {
            response.setHeader("Content-Disposition", "inline");
        }
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("ETag", eTag);
        response.setHeader("Last-Modified", ServerTimeUtil.getLastModifiedFormBlock(fo));
        response.setHeader("Cache-Control", "max-age=1800");
        String rangeTag = request.getHeader("Range");
        String ifRange = request.getHeader("If-Range");
        if (rangeTag != null && rangeTag.startsWith("bytes=") && (ifRange == null || ifRange.trim().equals(eTag) || ifRange.trim().equals(lastModified))) {
            rangeBytes = rangeTag.replaceAll("bytes=", "");
            if (rangeBytes.indexOf("-") < 0) {
                status = 400;
                response.setStatus(status);
                return status;
            }
            if (rangeBytes.endsWith("-")) {
                try {
                    startOffset = Long.parseLong(rangeBytes.substring(0, rangeBytes.indexOf(45)).trim());
                }
                catch (NumberFormatException e) {
                    status = 400;
                    response.setStatus(status);
                    return status;
                }
                contentLength = fileLength - startOffset;
            } else {
                hasEnd = true;
                try {
                    if (rangeBytes.startsWith("-")) {
                        startOffset = fileLength - Long.parseLong(rangeBytes.substring(rangeBytes.indexOf(45) + 1).trim());
                        endOffset = fileLength - 1L;
                    } else {
                        startOffset = Long.parseLong(rangeBytes.substring(0, rangeBytes.indexOf(45)).trim());
                        endOffset = Long.parseLong(rangeBytes.substring(rangeBytes.indexOf(45) + 1).trim());
                    }
                }
                catch (NumberFormatException e) {
                    status = 400;
                    response.setStatus(status);
                    return status;
                }
                contentLength = endOffset - startOffset + 1L;
            }
            if (contentLength > fileLength || contentLength <= 0L) {
                status = 416;
                response.setStatus(status);
                return status;
            }
            status = 206;
            response.setStatus(status);
            String contentRange = !hasEnd ? new StringBuffer("bytes ").append("" + startOffset).append("-").append("" + (fileLength - 1L)).append("/").append("" + fileLength).toString() : new StringBuffer("bytes ").append(rangeBytes).append("/").append("" + fileLength).toString();
            response.setHeader("Content-Range", contentRange);
        } else {
            contentLength = fileLength;
        }
        if (sendBody) {
            response.setHeader("Content-Length", "" + contentLength);
        } else {
            response.setHeader("Content-Length", "0");
        }
        if (sendBody) {
            byte[] buf = new byte[ConfigureReader.instance().getBuffSize()];
            try (RandomAccessFile raf = new RandomAccessFile(fo, "r");){
                BufferedOutputStream out = maxRate >= 0L ? new VariableSpeedBufferedOutputStream((OutputStream)response.getOutputStream(), maxRate, request.getSession()) : new BufferedOutputStream((OutputStream)response.getOutputStream());
                raf.seek(startOffset);
                if (!hasEnd) {
                    int n = 0;
                    while ((n = raf.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                } else {
                    int n = 0;
                    long readLength = 0L;
                    while (readLength < contentLength) {
                        n = raf.read(buf);
                        out.write(buf, 0, (int)((readLength += (long)n) <= contentLength ? (long)n : (long)n - (readLength - contentLength)));
                    }
                }
                out.flush();
                out.close();
            }
            catch (IOException | IndexOutOfBoundsException ex) {
                status = 500;
            }
            catch (IllegalArgumentException e) {
                status = 500;
                try {
                    response.sendError(status);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return status;
    }
}

