/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import kohgylw.kiftd.printer.Printer;
import org.springframework.stereotype.Component;

@Component
public class RSAKeyUtil {
    private static final int KEY_SIZE = 1024;
    private Key publicKey;
    private Key privateKey;
    private Base64.Encoder encoder = Base64.getEncoder();
    private String publicKeyStr;
    private String privateKeyStr;

    public RSAKeyUtil() {
        try {
            KeyPairGenerator g = KeyPairGenerator.getInstance("RSA");
            g.initialize(1024);
            KeyPair pair = g.genKeyPair();
            this.publicKey = pair.getPublic();
            this.privateKey = pair.getPrivate();
            this.publicKeyStr = new String(this.encoder.encode(this.publicKey.getEncoded()), StandardCharsets.UTF_8);
            this.privateKeyStr = new String(this.encoder.encode(this.privateKey.getEncoded()), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            Printer.instance.print(e.getMessage());
            Printer.instance.print("\u9519\u8bef\uff1aRSA\u5bc6\u94a5\u751f\u6210\u5931\u8d25\u3002");
        }
    }

    public String getPublicKey() {
        return this.publicKeyStr;
    }

    public String getPrivateKey() {
        return this.privateKeyStr;
    }

    public int getKeySize() {
        return 1024;
    }
}

