/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kohgylw.kiftd.server.enumeration.PowerPointType;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.RichTextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.springframework.stereotype.Component;

@Component
public class PowerPoint2PDFUtil {
    public void convertPdf(InputStream in, OutputStream out, PowerPointType type) throws Exception {
        Object graphics;
        double zoom = 2.0;
        AffineTransform at = new AffineTransform();
        at.setToScale(zoom, zoom);
        Document pdfDocument = new Document();
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)pdfDocument, (OutputStream)out);
        PdfPTable table = new PdfPTable(1);
        pdfWriter.open();
        pdfDocument.open();
        Dimension pgsize = null;
        com.lowagie.text.Image slideImage = null;
        BufferedImage img = null;
        if (type.equals((Object)PowerPointType.PPT)) {
            SlideShow ppt = new SlideShow(in);
            in.close();
            pgsize = ppt.getPageSize();
            Slide[] slide = ppt.getSlides();
            pdfDocument.setPageSize(new Rectangle((float)pgsize.getWidth(), (float)pgsize.getHeight()));
            pdfWriter.open();
            pdfDocument.open();
            for (int i = 0; i < slide.length; ++i) {
                TextRun[] truns = slide[i].getTextRuns();
                for (int k = 0; k < truns.length; ++k) {
                    RichTextRun[] rtruns = truns[k].getRichTextRuns();
                    for (int l = 0; l < rtruns.length; ++l) {
                        if (Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()).contains(rtruns[l].getFontName())) continue;
                        rtruns[l].setFontIndex(1);
                        rtruns[l].setFontName("WenQuanYi Zen Hei");
                    }
                }
                img = new BufferedImage((int)Math.ceil((double)pgsize.width * zoom), (int)Math.ceil((double)pgsize.height * zoom), 1);
                graphics = img.createGraphics();
                ((Graphics2D)graphics).setTransform(at);
                ((Graphics2D)graphics).setPaint(Color.white);
                ((Graphics2D)graphics).fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
                slide[i].draw((Graphics2D)graphics);
                ((Graphics2D)graphics).getPaint();
                slideImage = com.lowagie.text.Image.getInstance((Image)img, null);
                table.addCell(new PdfPCell(slideImage, true));
            }
        }
        if (type.equals((Object)PowerPointType.PPTX)) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            XMLSlideShow ppt = new XMLSlideShow(in);
            pgsize = ppt.getPageSize();
            XSLFSlide[] slide = ppt.getSlides();
            pdfDocument.setPageSize(new Rectangle((float)pgsize.getWidth(), (float)pgsize.getHeight()));
            pdfWriter.open();
            pdfDocument.open();
            for (int i = 0; i < slide.length; ++i) {
                for (XSLFShape shape : slide[i].getShapes()) {
                    if (!(shape instanceof XSLFTextShape)) continue;
                    XSLFTextShape txtshape = (XSLFTextShape)shape;
                    for (XSLFTextParagraph textPara : txtshape.getTextParagraphs()) {
                        List textRunList = textPara.getTextRuns();
                        for (XSLFTextRun textRun : textRunList) {
                            if (((Stream)Arrays.stream(ge.getAvailableFontFamilyNames()).parallel()).anyMatch(e -> e.equals(textRun.getFontFamily()))) continue;
                            textRun.setFontFamily("WenQuanYi Zen Hei");
                        }
                    }
                }
                img = new BufferedImage((int)Math.ceil((double)pgsize.width * zoom), (int)Math.ceil((double)pgsize.height * zoom), 1);
                graphics = img.createGraphics();
                ((Graphics2D)graphics).setTransform(at);
                ((Graphics2D)graphics).setPaint(Color.white);
                ((Graphics2D)graphics).fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
                slide[i].draw((Graphics2D)graphics);
                ((Graphics2D)graphics).getPaint();
                slideImage = com.lowagie.text.Image.getInstance((Image)img, null);
                table.addCell(new PdfPCell(slideImage, true));
            }
        }
        pdfDocument.add((Element)table);
        pdfDocument.close();
        pdfWriter.close();
    }
}

