/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.annotation.Resource;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.TxtCharsetGetter;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;

@Component
public class NoticeUtil {
    private String md5;
    private MutableDataHolder options = new MutableDataSet();
    public static final String NOTICE_FILE_NAME = "notice.md";
    public static final String NOTICE_OUTPUT_NAME = "notice.html";
    @Resource
    private LogUtil lu;
    @Resource
    private TxtCharsetGetter tcg;

    public NoticeUtil() {
        this.options.setFrom((MutableDataSetter)ParserEmulationProfile.MARKDOWN);
    }

    public void loadNotice() {
        File noticeMD = new File(ConfigureReader.instance().getPath(), NOTICE_FILE_NAME);
        File noticeHTML = new File(ConfigureReader.instance().getTemporaryfilePath(), NOTICE_OUTPUT_NAME);
        if (noticeMD.isFile() && noticeMD.canRead()) {
            Printer.instance.print("\u6b63\u5728\u8f7d\u5165\u516c\u544a\u4fe1\u606f...");
            try {
                String inputFileEncode = this.tcg.getTxtCharset(new FileInputStream(noticeMD));
                Parser parser = Parser.builder((DataHolder)this.options).build();
                HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)this.options).build();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(noticeMD), inputFileEncode));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(noticeHTML), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String html = renderer.render((Node)parser.parse(line));
                    writer.write(html);
                    writer.newLine();
                }
                reader.close();
                writer.flush();
                writer.close();
                this.md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(noticeMD));
                Printer.instance.print("\u516c\u544a\u4fe1\u606f\u8f7d\u5165\u5b8c\u6210\u3002");
                return;
            }
            catch (Exception e) {
                Printer.instance.print("\u9519\u8bef\uff1a\u516c\u544a\u6587\u4ef6\u8f7d\u5165\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5c06\u65e0\u6cd5\u4e3a\u7528\u6237\u663e\u793a\u516c\u544a\u5185\u5bb9\u3002");
            }
        }
        this.md5 = null;
    }

    public String getMd5() {
        return this.md5;
    }
}

