/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.enumeration.LogLevel;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.IpAddrGetter;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import org.springframework.stereotype.Component;

@Component
public class LogUtil {
    @Resource
    private FolderUtil fu;
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper fim;
    @Resource
    private IpAddrGetter idg;
    @Resource
    private FileBlockUtil fbu;
    private ExecutorService writerThread;
    private FileWriter writer;
    private String logName;
    private String sep = File.separator;
    private String logs = ConfigureReader.instance().getPath() + this.sep + "logs";

    public LogUtil() {
        this.writerThread = Executors.newSingleThreadExecutor();
        File l = new File(this.logs);
        if (!l.exists()) {
            l.mkdir();
        } else if (!l.isDirectory()) {
            l.delete();
            l.mkdir();
        }
    }

    public void writeException(Exception e) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Runtime_Exception)) {
            StringBuffer exceptionInfo = new StringBuffer(e.toString());
            StackTraceElement[] stes = e.getStackTrace();
            for (int i = 0; i < stes.length && i < 10; ++i) {
                StackTraceElement ste = stes[i];
                exceptionInfo.append("\r\n\tat " + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")");
            }
            if (stes.length > 10) {
                exceptionInfo.append("\r\n......");
            }
            this.writeToLog("Exception", exceptionInfo.toString());
        }
    }

    public void writeCreateFolderEvent(String account, String ip, Folder f) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            this.writerThread.execute(() -> {
                List<Folder> l = this.fu.getParentList(f.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Create new folder]\r\n>PATH [" + pl + "]\r\n>NAME [" + f.getFolderName() + "],CONSTRAINT [" + f.getFolderConstraint() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeRenameFolderEvent(String account, String ip, String folderId, String oldName, String newName, String oldConstraint, String newConstraint) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            this.writerThread.execute(() -> {
                List<Folder> l = this.fu.getParentList(folderId);
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Edit folder]\r\n>PATH [" + pl + "]\r\n>NAME [" + oldName + "]->[" + newName + "],CONSTRAINT [" + oldConstraint + "]->[" + newConstraint + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeDeleteFolderEvent(HttpServletRequest request, Folder f, List<Folder> l) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Delete folder]\r\n>PATH [" + pl + "]\r\n>NAME [" + f.getFolderName() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeDeleteFileEvent(HttpServletRequest request, Node f) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                Folder folder = this.fm.queryById(f.getFileParentFolder());
                List<Folder> l = this.fu.getParentList(folder.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Delete file]\r\n>PATH [" + pl + folder.getFolderName() + "]\r\n>NAME [" + f.getFileName() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeUploadFileEvent(HttpServletRequest request, Node f, String account) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                Folder folder = this.fm.queryById(f.getFileParentFolder());
                if (folder == null) {
                    return;
                }
                List<Folder> l = this.fu.getParentList(folder.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Upload file]\r\n>PATH [" + pl + folder.getFolderName() + "]\r\n>NAME [" + f.getFileName() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeDownloadFileEvent(String account, String ip, Node f) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            this.writerThread.execute(() -> {
                Folder folder = this.fm.queryById(f.getFileParentFolder());
                List<Folder> l = this.fu.getParentList(folder.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Download file]\r\n>PATH [" + pl + folder.getFolderName() + "]\r\n>NAME [" + f.getFileName() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeChainEvent(HttpServletRequest request, Node f) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                Folder folder = this.fm.queryById(f.getFileParentFolder());
                List<Folder> l = this.fu.getParentList(folder.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>OPERATE [Request Chain]\r\n>PATH [" + pl + folder.getFolderName() + "]\r\n>NAME [" + f.getFileName() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeDownloadFileByKeyEvent(HttpServletRequest request, Node f) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                Folder folder = this.fm.queryById(f.getFileParentFolder());
                List<Folder> l = this.fu.getParentList(folder.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>OPERATE [Download file By Shared URL]\r\n>PATH [" + pl + folder.getFolderName() + "]\r\n>NAME [" + f.getFileName() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeShareFileURLEvent(HttpServletRequest request, Node f) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                Folder folder = this.fm.queryById(f.getFileParentFolder());
                List<Folder> l = this.fu.getParentList(folder.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Share Download file URL]\r\n>PATH [" + pl + folder.getFolderName() + "]\r\n>NAME [" + f.getFileName() + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeRenameFileEvent(String account, String ip, String parentFolderId, String oldName, String newName) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            this.writerThread.execute(() -> {
                Folder folder = this.fm.queryById(parentFolderId);
                List<Folder> l = this.fu.getParentList(folder.getFolderId());
                String pl = new String();
                for (Folder i : l) {
                    pl = pl + i.getFolderName() + "/";
                }
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Rename file]\r\n>PATH [" + pl + folder.getFolderName() + "]\r\n>NAME [" + oldName + "]->[" + newName + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeMoveFileEvent(String account, String ip, String originPath, String finalPath, boolean isCopy) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            this.writerThread.execute(() -> {
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [" + (isCopy ? "Copy file" : "Move file") + "]\r\n>FROM [" + originPath + "]\r\n>TO   [" + finalPath + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeMoveFolderEvent(String account, String ip, String originPath, String finalPath, boolean isCopy) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            this.writerThread.execute(() -> {
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [" + (isCopy ? "Copy Folder" : "Move Folder") + "]\r\n>FROM [" + originPath + "]\r\n>TO   [" + finalPath + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    private void writeToLog(String type, String content) {
        String t = ServerTimeUtil.accurateToLogName();
        String finalContent = "\r\n\r\nTIME:\r\n" + ServerTimeUtil.accurateToSecond() + "\r\nTYPE:\r\n" + type + "\r\nCONTENT:\r\n" + content;
        try {
            if (t.equals(this.logName) && this.writer != null) {
                this.writer.write(finalContent);
                this.writer.flush();
            } else {
                File f = new File(this.logs, t + ".klog");
                this.logName = t;
                if (this.writer != null) {
                    this.writer.close();
                }
                this.writer = new FileWriter(f, true);
                this.writer.write(finalContent);
                this.writer.flush();
            }
        }
        catch (Exception e1) {
            if (Printer.instance != null) {
                Printer.instance.print("KohgylwIFT:[Log]Cannt write to file,message:" + e1.getMessage());
            }
            System.out.println("KohgylwIFT:[Log]Cannt write to file,message:" + e1.getMessage());
        }
    }

    public void writeDownloadCheckedFileEvent(HttpServletRequest request, List<String> idList, List<String> fidList) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            if (account == null || account.length() == 0) {
                account = "Anonymous";
            }
            String a = account;
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                StringBuffer content = new StringBuffer(">IP [" + ip + "]\r\n>ACCOUNT [" + a + "]\r\n>OPERATE [Download package]\r\n----------------\r\n");
                for (String fid : idList) {
                    Node f = this.fim.queryById(fid);
                    if (f == null) continue;
                    content.append(">File [" + this.fbu.getNodePath(f) + "]\r\n");
                }
                for (String ffid : fidList) {
                    Folder fl = this.fm.queryById(ffid);
                    if (fl == null) continue;
                    content.append(">Folder [" + this.fu.getFolderPath(fl) + "]\r\n");
                }
                content.append("----------------");
                this.writeToLog("Event", content.toString());
            });
        }
    }

    public void writeChangePasswordEvent(HttpServletRequest request, String account, String newPassword) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                String content = ">IP [" + ip + "]\r\n>ACCOUNT [" + account + "]\r\n>OPERATE [Change Password]\r\n>NEW PASSWORD [" + newPassword + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    public void writeSignUpEvent(HttpServletRequest request, String account, String password) {
        if (ConfigureReader.instance().inspectLogLevel(LogLevel.Event)) {
            String ip = this.idg.getIpAddr(request);
            this.writerThread.execute(() -> {
                String content = ">IP [" + ip + "]\r\n>OPERATE [Sign Up]\r\n>NEW ACCOUNT [" + account + "]\r\n>PASSWORD [" + password + "]";
                this.writeToLog("Event", content);
            });
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.writer != null) {
            this.writer.close();
        }
        this.writerThread.shutdown();
    }
}

