/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KiftdProperties {
    private List<LineContext> contexts = new ArrayList<LineContext>();
    private Map<String, String> properties = new HashMap<String, String>();

    public String getProperty(String key) {
        if (key != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    public void setProperty(String key, String value) {
        if (key != null) {
            this.properties.put(key, value);
            for (LineContext lc : this.contexts) {
                if (!key.equals(lc.key)) continue;
                lc.value = value;
                return;
            }
            this.contexts.add(new LineContext(key, value, null));
        }
    }

    public void load(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "8859_1"));
        String lineStr = null;
        this.clear();
        while ((lineStr = reader.readLine()) != null && this.contexts.size() < Integer.MAX_VALUE) {
            if (lineStr.startsWith("#")) {
                this.contexts.add(new LineContext(null, null, lineStr));
                continue;
            }
            int delimit0 = lineStr.indexOf("=");
            int delimit1 = lineStr.indexOf(":");
            int delimitIndex = -1;
            if (delimit0 >= 0) {
                delimitIndex = delimit0;
            }
            if (delimit1 >= 0 && delimit1 < delimit0) {
                delimitIndex = delimit1;
            }
            if (delimitIndex >= 0) {
                this.setProperty(lineStr.substring(0, delimitIndex), lineStr.substring(delimitIndex + 1));
                continue;
            }
            this.contexts.add(new LineContext(null, null, lineStr));
        }
        reader.close();
    }

    public void store(OutputStream out, String header) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            writer.write("#" + header);
            writer.newLine();
            writer.write("#" + new Date().toString());
            writer.newLine();
        }
        for (LineContext line : this.contexts) {
            if (line.key != null) {
                writer.write(line.key + "=" + line.value);
                writer.newLine();
                continue;
            }
            writer.write(line.text);
            writer.newLine();
        }
        writer.close();
    }

    public Set<String> stringPropertieNames() {
        return this.properties.keySet();
    }

    public void removeProperty(String key) {
        if (key != null) {
            this.properties.remove(key);
            Iterator<LineContext> itor = this.contexts.iterator();
            while (itor.hasNext()) {
                if (!key.equals(itor.next().key)) continue;
                itor.remove();
            }
        }
    }

    public void clear() {
        this.contexts.clear();
        this.properties.clear();
    }

    private class LineContext {
        private String key;
        private String value;
        private String text;

        private LineContext(String key, String value, String text) {
            this.key = key;
            this.value = value;
            this.text = text;
        }

        public boolean equals(Object obj) {
            if (this.key == null) {
                return false;
            }
            return this.key.equals(obj);
        }
    }
}

