/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.springframework.stereotype.Component;
import ws.schild.jave.Version;
import ws.schild.jave.process.ProcessLocator;
import ws.schild.jave.process.ProcessWrapper;
import ws.schild.jave.process.ffmpeg.FFMPEGProcess;

@Component
public class KiftdFFMPEGLocator
implements ProcessLocator {
    private boolean enableFFmpeg;
    private String suffix;
    private String arch;
    private boolean isWindows;

    public KiftdFFMPEGLocator() {
        String os = System.getProperty("os.name").toLowerCase();
        this.isWindows = os.contains("windows");
        boolean isMac = os.contains("mac");
        this.suffix = this.isWindows ? ".exe" : (isMac ? "-osx" : "");
        this.arch = System.getProperty("os.arch");
        this.initFFMPEGExecutablePath();
    }

    public String getExecutablePath() {
        return this.initFFMPEGExecutablePath();
    }

    private String initFFMPEGExecutablePath() {
        File ffmpegFile;
        if (!ConfigureReader.instance().isEnableFFMPEG()) {
            this.enableFFmpeg = false;
            return null;
        }
        File dirFolder = new File(System.getProperty("java.io.tmpdir"), "jave/");
        if (!dirFolder.exists() && !dirFolder.mkdirs()) {
            Printer.instance.print("\u8b66\u544a\uff1a\u65e0\u6cd5\u5728\u4e34\u65f6\u6587\u4ef6\u5939\u5185\u751f\u6210ffmpeg\u5f15\u64ce\u53ef\u6267\u884c\u6587\u4ef6\uff0c\u89c6\u9891\u64ad\u653e\u7684\u5728\u7ebf\u89e3\u7801\u529f\u80fd\u5c06\u4e0d\u53ef\u7528\u3002");
            this.enableFFmpeg = false;
            return null;
        }
        File customFFMPEGexef = new File(ConfigureReader.instance().getPath(), this.isWindows ? "ffmpeg.exe" : "ffmpeg");
        if (customFFMPEGexef.isFile() && customFFMPEGexef.canRead()) {
            ffmpegFile = new File(dirFolder, customFFMPEGexef.getName());
            if (!ffmpegFile.exists()) {
                try {
                    Files.copy(customFFMPEGexef.toPath(), ffmpegFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    Printer.instance.print(e.toString());
                    Printer.instance.print("\u8b66\u544a\uff1a\u81ea\u5b9a\u4e49\u7684ffmpeg\u5f15\u64ce\u53ef\u6267\u884c\u6587\u4ef6\u65e0\u6cd5\u8bfb\u53d6\uff0c\u89c6\u9891\u64ad\u653e\u7684\u5728\u7ebf\u89e3\u7801\u529f\u80fd\u5c06\u4e0d\u53ef\u7528\u3002");
                    this.enableFFmpeg = false;
                    return null;
                }
            }
        } else {
            ffmpegFile = new File(dirFolder, "ffmpeg-" + this.arch + "-" + Version.getVersion() + this.suffix);
            if (!ffmpegFile.exists() && !this.copyFile("ffmpeg-" + this.arch + this.suffix, ffmpegFile)) {
                Printer.instance.print("\u8b66\u544a\uff1a\u672a\u80fd\u627e\u5230\u9002\u5408\u6b64\u64cd\u4f5c\u7cfb\u7edf\u7684ffmpeg\u5f15\u64ce\u53ef\u6267\u884c\u6587\u4ef6\uff0c\u89c6\u9891\u64ad\u653e\u7684\u5728\u7ebf\u89e3\u7801\u529f\u80fd\u5c06\u4e0d\u53ef\u7528\u3002");
                this.enableFFmpeg = false;
                return null;
            }
        }
        if (!this.isWindows && !ffmpegFile.canExecute()) {
            try {
                Runtime.getRuntime().exec(new String[]{"/bin/chmod", "755", ffmpegFile.getAbsolutePath()});
            }
            catch (IOException e) {
                Printer.instance.print(e.toString());
                Printer.instance.print("\u8b66\u544a\uff1a\u65e0\u6cd5\u4e3affmpeg\u5f15\u64ce\u53ef\u6267\u884c\u6587\u4ef6\u6388\u4e88\u6267\u884c\u6743\u9650\uff0c\u89c6\u9891\u64ad\u653e\u7684\u5728\u7ebf\u89e3\u7801\u529f\u80fd\u5c06\u4e0d\u53ef\u7528\u3002");
                this.enableFFmpeg = false;
                return null;
            }
        }
        this.enableFFmpeg = true;
        return ffmpegFile.getAbsolutePath();
    }

    private boolean copyFile(String path, File dest) {
        String resourceName = "nativebin/" + path;
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is == null) {
            resourceName = "ws/schild/jave/nativebin/" + path;
            is = ClassLoader.getSystemResourceAsStream(resourceName);
        }
        if (is == null) {
            resourceName = "ws/schild/jave/nativebin/" + path;
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            is = classloader.getResourceAsStream(resourceName);
        }
        if (is != null) {
            boolean copyResult = this.copy(is, dest.getAbsolutePath());
            try {
                is.close();
                return copyResult;
            }
            catch (IOException ioex) {
                Printer.instance.print(ioex.toString());
                Printer.instance.print("\u8b66\u544a\uff1a\u65e0\u6cd5\u5728\u4e34\u65f6\u6587\u4ef6\u5939\u5185\u751f\u6210ffmpeg\u5f15\u64ce\u53ef\u6267\u884c\u6587\u4ef6\uff0c\u89c6\u9891\u64ad\u653e\u7684\u5728\u7ebf\u89e3\u7801\u529f\u80fd\u5c06\u4e0d\u53ef\u7528\u3002");
            }
        }
        return false;
    }

    private boolean copy(InputStream source, String destination) {
        boolean success = true;
        try {
            Files.copy(source, Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            success = false;
        }
        return success;
    }

    public boolean isEnableFFmpeg() {
        if (this.enableFFmpeg) {
            this.initFFMPEGExecutablePath();
        }
        return this.enableFFmpeg;
    }

    public ProcessWrapper createExecutor() {
        return new FFMPEGProcess(this.getExecutablePath());
    }
}

