/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import javax.servlet.http.HttpServletRequest;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.springframework.stereotype.Component;

@Component
public class IpAddrGetter {
    private String[] ipAddrHeaders = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public String getIpAddr(HttpServletRequest request) {
        String remoteAddr;
        if (ConfigureReader.instance().isIpXFFAnalysis()) {
            for (String ipAddrHeader : this.ipAddrHeaders) {
                String ipAddress = request.getHeader(ipAddrHeader);
                if (ipAddress == null || ipAddress.length() <= 0 || "unknown".equalsIgnoreCase(ipAddress)) continue;
                int indexOfIpSeparator = ipAddress.indexOf(",");
                if (indexOfIpSeparator >= 0) {
                    return ipAddress.substring(0, indexOfIpSeparator).trim();
                }
                return ipAddress.trim();
            }
        }
        if ((remoteAddr = request.getRemoteAddr()) != null) {
            return request.getRemoteAddr().trim();
        }
        return "\u83b7\u53d6\u5931\u8d25";
    }
}

