/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.exception.FoldersTotalOutOfLimitException;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import org.springframework.stereotype.Component;

@Component
public class FolderUtil {
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper fim;
    @Resource
    private FileBlockUtil fbu;

    public List<Folder> getParentList(String fid) {
        Folder f = this.fm.queryById(fid);
        ArrayList<Folder> folderList = new ArrayList<Folder>();
        if (f != null) {
            while (!f.getFolderParent().equals("null") && folderList.size() < Integer.MAX_VALUE) {
                f = this.fm.queryById(f.getFolderParent());
                folderList.add(f);
            }
        }
        Collections.reverse(folderList);
        return folderList;
    }

    public List<String> getAllFoldersId(String fid) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.addAll(this.getParentList(fid).parallelStream().map(e -> e.getFolderId()).collect(Collectors.toList()));
        idList.add(fid);
        return idList;
    }

    public void deleteAllChildFolder(String folderId) {
        Thread deleteChildFolderThread = new Thread(() -> this.iterationDeleteFolder(folderId));
        deleteChildFolderThread.start();
    }

    private void iterationDeleteFolder(String folderId) {
        List<Folder> cf = this.fm.queryByParentId(folderId);
        for (Folder f : cf) {
            this.iterationDeleteFolder(f.getFolderId());
        }
        List<Node> files = this.fim.queryByParentFolderId(folderId);
        for (Node f2 : files) {
            this.fbu.deleteNode(f2);
        }
        this.fm.deleteById(folderId);
    }

    public Folder createNewFolder(String parentId, String account, String folderName, String folderConstraint) throws FoldersTotalOutOfLimitException {
        if (!ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.getAllFoldersId(parentId))) {
            return null;
        }
        if (parentId == null || folderName == null || parentId.length() <= 0 || folderName.length() <= 0) {
            return null;
        }
        if (folderName.equals(".") || folderName.equals("..")) {
            return null;
        }
        Folder parentFolder = this.fm.queryById(parentId);
        if (parentFolder == null) {
            return null;
        }
        if (!ConfigureReader.instance().accessFolder(parentFolder, account)) {
            return null;
        }
        if (this.fm.queryByParentId(parentId).parallelStream().anyMatch(e -> e.getFolderName().equals(folderName))) {
            return null;
        }
        if (this.fm.countByParentId(parentId) >= Integer.MAX_VALUE) {
            throw new FoldersTotalOutOfLimitException();
        }
        Folder f = new Folder();
        int pc = parentFolder.getFolderConstraint();
        if (folderConstraint != null) {
            try {
                int ifc = Integer.parseInt(folderConstraint);
                if (ifc > 0 && account == null) {
                    return null;
                }
                if (ifc < pc) {
                    return null;
                }
                f.setFolderConstraint(ifc);
            }
            catch (Exception e2) {
                return null;
            }
        } else {
            return null;
        }
        f.setFolderId(UUID.randomUUID().toString());
        f.setFolderName(folderName);
        f.setFolderCreationDate(ServerTimeUtil.accurateToDay());
        if (account != null) {
            f.setFolderCreator(account);
        } else {
            f.setFolderCreator("\u533f\u540d\u7528\u6237");
        }
        f.setFolderParent(parentId);
        int i = 0;
        while (true) {
            try {
                int r = this.fm.insertNewFolder(f);
                if (r > 0) {
                    return f;
                }
            }
            catch (Exception e3) {
                f.setFolderId(UUID.randomUUID().toString());
                if (++i < 10) continue;
            }
            break;
        }
        return null;
    }

    public boolean isValidFolder(Folder f) {
        Folder[] repeats = (Folder[])this.fm.queryByParentId(f.getFolderParent()).parallelStream().filter(e -> e.getFolderName().equals(f.getFolderName())).toArray(Folder[]::new);
        if (this.fm.queryById(f.getFolderParent()) == null || repeats.length > 1) {
            this.deleteAllChildFolder(f.getFolderId());
            return false;
        }
        return true;
    }

    private Folder copyFolderByNewNameToPath(Folder prototype, String account, Folder parentFolder, String newName, String excludeFolderId) {
        if (prototype == null || parentFolder == null) {
            return null;
        }
        try {
            Folder newFolder = this.createNewFolder(parentFolder.getFolderId(), account, newName == null ? prototype.getFolderName() : newName, "" + (prototype.getFolderConstraint() < parentFolder.getFolderConstraint() ? parentFolder.getFolderConstraint() : prototype.getFolderConstraint()));
            if (newFolder == null) {
                return null;
            }
            if (excludeFolderId == null) {
                excludeFolderId = newFolder.getFolderId();
            }
            List<Folder> childs = this.fm.queryByParentId(prototype.getFolderId());
            for (Folder c : childs) {
                if (c.getFolderId().equals(excludeFolderId) || c.getFolderId().equals(newFolder.getFolderId()) || this.copyFolderByNewNameToPath(c, account, newFolder, null, excludeFolderId) != null) continue;
                return null;
            }
            List<Node> nodes = this.fim.queryByParentFolderId(prototype.getFolderId());
            for (Node n : nodes) {
                Node newNode = this.fbu.insertNewNode(n.getFileName(), account, n.getFilePath(), n.getFileSize(), newFolder.getFolderId());
                if (newNode != null) continue;
                return null;
            }
            return newFolder;
        }
        catch (FoldersTotalOutOfLimitException e) {
            return null;
        }
    }

    public Folder copyFolderByNewNameToPath(Folder prototype, String account, Folder parentFolder, String newName) {
        return this.copyFolderByNewNameToPath(prototype, account, parentFolder, newName, null);
    }

    public String getFolderPath(Folder f) {
        List<Folder> l = this.getParentList(f.getFolderId());
        StringBuffer pl = new StringBuffer();
        for (Folder i : l) {
            pl.append(i.getFolderName() + "/");
        }
        pl.append(f.getFolderName());
        return pl.toString();
    }

    public void changeChildFolderConstraint(String folderId, int c) {
        List<Folder> cfs = this.fm.queryByParentId(folderId);
        for (Folder cf : cfs) {
            if (cf.getFolderConstraint() < c) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("newConstraint", c);
                map.put("folderId", cf.getFolderId());
                this.fm.updateFolderConstraintById(map);
            }
            this.changeChildFolderConstraint(cf.getFolderId(), c);
        }
    }
}

