/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;

public class FileNodeUtil {
    private static Connection conn;
    private static String url;
    public static final int MAXIMUM_NUM_OF_SINGLE_FOLDER = Integer.MAX_VALUE;

    private FileNodeUtil() {
    }

    public static void initNodeTableToDataBase() {
        Printer.instance.print("\u521d\u59cb\u5316\u6587\u4ef6\u8282\u70b9...");
        try {
            if (conn == null) {
                Class.forName(ConfigureReader.instance().getFileNodePathDriver()).newInstance();
            }
            String newUrl = ConfigureReader.instance().getFileNodePathURL();
            if (url == null || !url.equals(newUrl)) {
                Statement state4;
                conn = DriverManager.getConnection(newUrl, ConfigureReader.instance().getFileNodePathUserName(), ConfigureReader.instance().getFileNodePathPassWord());
                url = newUrl;
                File upgradeFile = new File(ConfigureReader.instance().getFileNodePath() + "upgrade.sql");
                if (upgradeFile.isFile()) {
                    Printer.instance.print("\u6b63\u5728\u4ece\u65e7\u7248\u672c\u5bfc\u5165\u6570\u636e...");
                    Statement state0 = conn.createStatement();
                    state0.execute("RUNSCRIPT FROM '" + upgradeFile.getAbsolutePath() + "' FROM_1X");
                    state0.close();
                    if (!upgradeFile.delete()) {
                        throw new IOException("\u9519\u8bef\uff1a\u65e7\u5f52\u6863\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + upgradeFile.getAbsolutePath());
                    }
                }
                Statement state1 = conn.createStatement();
                state1.execute("CREATE TABLE IF NOT EXISTS FOLDER(folder_id VARCHAR(128) PRIMARY KEY,  folder_name VARCHAR(128) NOT NULL,folder_creation_date VARCHAR(128) NOT NULL,  folder_creator VARCHAR(128) NOT NULL,folder_parent VARCHAR(128) NOT NULL,folder_constraint INT NOT NULL)");
                state1.executeQuery("SELECT count(*) FROM FOLDER WHERE folder_id = 'root'");
                ResultSet rs = state1.getResultSet();
                if (rs.next() && rs.getInt(1) == 0) {
                    Statement state11 = conn.createStatement();
                    state11.execute("INSERT INTO FOLDER VALUES('root', 'ROOT', '--', '--', 'null', 0)");
                }
                state1.close();
                Statement state2 = conn.createStatement();
                state2.execute("CREATE TABLE IF NOT EXISTS FILE(file_id VARCHAR(128) PRIMARY KEY,file_name VARCHAR(128) NOT NULL,file_size VARCHAR(128) NOT NULL,file_parent_folder varchar(128) NOT NULL,file_creation_date varchar(128) NOT NULL,file_creator varchar(128) NOT NULL,file_path varchar(128) NOT NULL)");
                state2.close();
                if (ConfigureReader.instance().useMySQL()) {
                    state4 = conn.createStatement();
                    ResultSet indexCount = state4.executeQuery("SHOW INDEX FROM FILE WHERE Key_name = 'file_index'");
                    if (!indexCount.next()) {
                        Statement state41 = conn.createStatement();
                        state41.execute("CREATE INDEX file_index ON FILE (file_name)");
                        state41.close();
                    }
                    state4.close();
                } else {
                    state4 = conn.createStatement();
                    state4.execute("CREATE INDEX IF NOT EXISTS file_index ON FILE (file_name)");
                    state4.close();
                }
                Statement state5 = conn.createStatement();
                state5.execute("CREATE TABLE IF NOT EXISTS PROPERTIES(propertie_key VARCHAR(128) PRIMARY KEY,propertie_value VARCHAR(128) NOT NULL)");
                state5.close();
            }
            Printer.instance.print("\u6587\u4ef6\u8282\u70b9\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        }
        catch (Exception e) {
            Printer.instance.print(e.getMessage());
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u8282\u70b9\u521d\u59cb\u5316\u5931\u8d25\u3002");
        }
    }

    public static Connection getNodeDBConnection() {
        return conn;
    }

    public static String getNewNodeName(String originalName, List<Node> nodes) {
        int i = 0;
        List fileNames = Arrays.asList(((Stream)nodes.stream().parallel()).map(t -> t.getFileName()).toArray(String[]::new));
        String newName = originalName;
        while (fileNames.contains(newName)) {
            ++i;
            if (originalName.indexOf(".") >= 0) {
                newName = originalName.substring(0, originalName.lastIndexOf(".")) + " (" + i + ")" + originalName.substring(originalName.lastIndexOf("."));
                continue;
            }
            newName = originalName + " (" + i + ")";
        }
        return newName;
    }

    public static String getNewFolderName(String originalName, List<? extends Folder> folders) {
        int i = 0;
        List fileNames = Arrays.asList(((Stream)folders.stream().parallel()).map(t -> t.getFolderName()).toArray(String[]::new));
        String newName = originalName;
        while (fileNames.contains(newName)) {
            newName = originalName + " " + ++i;
        }
        return newName;
    }

    public static String getNewFolderName(Folder folder, File parentfolder) {
        int i = 0;
        List fileNames = Arrays.asList(((Stream)Arrays.stream(parentfolder.listFiles()).parallel()).filter(e -> e.isDirectory()).map(t -> t.getName()).toArray(String[]::new));
        String newName = folder.getFolderName();
        while (fileNames.contains(newName)) {
            newName = folder.getFolderName() + " " + ++i;
        }
        return newName;
    }

    public static String getNewNodeName(Node n, File folder) {
        int i = 0;
        List fileNames = Arrays.asList(((Stream)Arrays.stream(folder.listFiles()).parallel()).filter(e -> e.isFile()).map(t -> t.getName()).toArray(String[]::new));
        String newName = n.getFileName();
        while (fileNames.contains(newName)) {
            ++i;
            if (n.getFileName().indexOf(".") >= 0) {
                newName = n.getFileName().substring(0, n.getFileName().lastIndexOf(".")) + " (" + i + ")" + n.getFileName().substring(n.getFileName().lastIndexOf("."));
                continue;
            }
            newName = n.getFileName() + " (" + i + ")";
        }
        return newName;
    }
}

