/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import javax.annotation.Resource;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.ExtendStores;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipUtil;

@Component
public class FileBlockUtil {
    @Resource
    private NodeMapper fm;
    @Resource
    private FolderMapper flm;
    @Resource
    @Lazy
    private LogUtil lu;
    @Resource
    @Lazy
    private FolderUtil fu;

    public void initTempDir() {
        File f = new File(ConfigureReader.instance().getTemporaryfilePath());
        if (f.isDirectory()) {
            try {
                Iterator<Path> listFiles = Files.newDirectoryStream(f.toPath()).iterator();
                while (listFiles.hasNext()) {
                    File tempFile = listFiles.next().toFile();
                    if (!tempFile.isFile() || tempFile.getName().startsWith(".")) continue;
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                Printer.instance.print(e.toString());
                Printer.instance.print("\u9519\u8bef\uff1a\u4e34\u65f6\u6587\u4ef6\u5b58\u653e\u533a[" + f.getAbsolutePath() + "]\u6e05\u7406\u5931\u8d25\uff0c\u60a8\u53ef\u4ee5\u5728\u7a0b\u5e8f\u9000\u51fa\u540e\u624b\u52a8\u6e05\u7406\u6b64\u6587\u4ef6\u5939\u3002");
            }
        } else if (!f.mkdir()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5b58\u653e\u533a[" + f.getAbsolutePath() + "]\uff0c\u8bf7\u9000\u51fa\u7a0b\u5e8f\u5e76\u68c0\u67e5\u64cd\u4f5c\u7cfb\u7edf\u7684\u6743\u9650\u8bbe\u7f6e\u3002");
        }
    }

    public File saveToFileBlocks(MultipartFile f) {
        List<ExtendStores> ess = this.getExtendStoresBySort();
        if (ess.size() > 0) {
            for (ExtendStores es : ess) {
                if (es.getPath().getFreeSpace() <= f.getSize()) continue;
                File file = null;
                try {
                    file = this.createNewBlock(es.getIndex() + "_", es.getPath());
                    if (file == null) continue;
                    f.transferTo(file);
                    return file;
                }
                catch (IOException e) {
                    if (file == null) continue;
                    file.delete();
                }
                catch (Exception e) {
                    this.lu.writeException(e);
                    Printer.instance.print(e.getMessage());
                }
            }
        }
        File file = null;
        try {
            file = this.createNewBlock("file_", new File(ConfigureReader.instance().getFileBlockPath()));
            if (file != null) {
                f.transferTo(file);
                return file;
            }
        }
        catch (Exception e) {
            if (file != null) {
                file.delete();
            }
            this.lu.writeException(e);
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u5757\u751f\u6210\u5931\u8d25\uff0c\u65e0\u6cd5\u5b58\u5165\u65b0\u7684\u6587\u4ef6\u6570\u636e\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return null;
    }

    public File saveToFileBlocks(File f) {
        List<ExtendStores> ess = this.getExtendStoresBySort();
        if (ess.size() > 0) {
            for (ExtendStores es : ess) {
                if (es.getPath().getFreeSpace() <= f.length()) continue;
                File file = null;
                try {
                    file = this.createNewBlock(es.getIndex() + "_", es.getPath());
                    if (file == null) continue;
                    Files.move(f.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    return file;
                }
                catch (IOException e) {
                    if (file == null) continue;
                    file.delete();
                }
                catch (Exception e) {
                    this.lu.writeException(e);
                    Printer.instance.print(e.getMessage());
                }
            }
        }
        File file = null;
        try {
            file = this.createNewBlock("file_", new File(ConfigureReader.instance().getFileBlockPath()));
            if (file != null) {
                Files.move(f.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return file;
            }
        }
        catch (Exception e) {
            if (file != null) {
                file.delete();
            }
            this.lu.writeException(e);
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u5757\u751f\u6210\u5931\u8d25\uff0c\u65e0\u6cd5\u5b58\u5165\u65b0\u7684\u6587\u4ef6\u6570\u636e\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return null;
    }

    private List<ExtendStores> getExtendStoresBySort() {
        List<ExtendStores> ess = ConfigureReader.instance().getExtendStores();
        if (ess.size() > 0) {
            Collections.sort(ess, new Comparator<ExtendStores>(){

                @Override
                public int compare(ExtendStores o1, ExtendStores o2) {
                    try {
                        return o1.getPath().list().length - o2.getPath().list().length;
                    }
                    catch (Exception e) {
                        try {
                            long dValue = Files.list(o1.getPath().toPath()).count() - Files.list(o2.getPath().toPath()).count();
                            return dValue > 0L ? 1 : (dValue == 0L ? 0 : -1);
                        }
                        catch (IOException e1) {
                            return 0;
                        }
                    }
                }
            });
        }
        return ess;
    }

    private File createNewBlock(String prefix, File parent) throws IOException {
        int appendIndex = 0;
        int retryNum = 0;
        String newName = prefix + UUID.randomUUID().toString().replace("-", "");
        File newBlock = new File(parent, newName + ".block");
        while (!newBlock.createNewFile()) {
            if (appendIndex >= 0 && appendIndex < Integer.MAX_VALUE) {
                newBlock = new File(parent, newName + "_" + appendIndex + ".block");
                ++appendIndex;
                continue;
            }
            if (retryNum >= 5) {
                return null;
            }
            newName = prefix + UUID.randomUUID().toString().replace("-", "");
            newBlock = new File(parent, newName + ".block");
            ++retryNum;
        }
        return newBlock;
    }

    public String getFileSize(long size) {
        return Long.toString(size);
    }

    public boolean deleteNode(Node f) {
        if (f != null && this.fm.deleteById(f.getFileId()) > 0) {
            return this.clearFileBlock(f) || this.fm.insert(f) <= 0;
        }
        return false;
    }

    private boolean clearFileBlock(Node n) {
        String recycleBinPath = ConfigureReader.instance().getRecycleBinPath();
        File file = this.getFileFromBlocks(n);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", n.getFilePath());
        map.put("fileId", n.getFileId());
        List<Node> nodes = this.fm.queryByPathExcludeById(map);
        if (nodes == null || nodes.isEmpty()) {
            if (file != null) {
                if (recycleBinPath != null && !this.saveToRecycleBin(file, recycleBinPath, n.getFileName(), false)) {
                    return false;
                }
                if (!file.delete() && file.exists()) {
                    return false;
                }
            } else if (recycleBinPath != null) {
                return false;
            }
        } else if (recycleBinPath != null && !this.saveToRecycleBin(file, recycleBinPath, n.getFileName(), true)) {
            return false;
        }
        return true;
    }

    private boolean saveToRecycleBin(File block, String recycleBinPath, String originalName, boolean isCopy) {
        File dateDir;
        File recycleBinDir = new File(recycleBinPath);
        if (recycleBinDir.isDirectory() && ((dateDir = new File(recycleBinDir, ServerTimeUtil.accurateToLogName())).isDirectory() || dateDir.mkdir())) {
            int i = 0;
            List<String> fileNames = Arrays.asList(dateDir.list());
            String newName = originalName;
            while (fileNames.contains(newName)) {
                ++i;
                if (originalName.indexOf(".") >= 0) {
                    newName = originalName.substring(0, originalName.lastIndexOf(".")) + " (" + i + ")" + originalName.substring(originalName.lastIndexOf("."));
                    continue;
                }
                newName = originalName + " (" + i + ")";
            }
            File saveFile = new File(dateDir, newName);
            try {
                if (isCopy) {
                    Files.copy(block.toPath(), saveFile.toPath(), new CopyOption[0]);
                } else {
                    Files.move(block.toPath(), saveFile.toPath(), new CopyOption[0]);
                }
                return true;
            }
            catch (Exception e) {
                this.lu.writeException(e);
            }
        }
        return false;
    }

    public File getFileFromBlocks(Node f) {
        try {
            File file = null;
            if (f.getFilePath().startsWith("file_")) {
                file = new File(ConfigureReader.instance().getFileBlockPath(), f.getFilePath());
            } else {
                short index = Short.parseShort(f.getFilePath().substring(0, f.getFilePath().indexOf(95)));
                file = new File(ConfigureReader.instance().getExtendStores().parallelStream().filter(e -> e.getIndex() == index).findAny().get().getPath(), f.getFilePath());
            }
            if (file.isFile()) {
                return file;
            }
        }
        catch (Exception e2) {
            this.lu.writeException(e2);
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u6570\u636e\u8bfb\u53d6\u5931\u8d25\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e2.getMessage());
        }
        return null;
    }

    public void checkFileBlocks() {
        Thread checkThread = new Thread(() -> {
            this.checkNodes("root");
            ArrayList<File> paths = new ArrayList<File>();
            paths.add(new File(ConfigureReader.instance().getFileBlockPath()));
            for (ExtendStores es : ConfigureReader.instance().getExtendStores()) {
                paths.add(es.getPath());
            }
            for (File path : paths) {
                try {
                    DirectoryStream<Path> ds = Files.newDirectoryStream(path.toPath());
                    Throwable throwable = null;
                    try {
                        Iterator<Path> blocks = ds.iterator();
                        while (blocks.hasNext()) {
                            List<Node> nodes;
                            File testBlock = blocks.next().toFile();
                            if (!testBlock.isFile() || testBlock.getName().startsWith(".") || (nodes = this.fm.queryByPath(testBlock.getName())) != null && !nodes.isEmpty()) continue;
                            testBlock.delete();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ds == null) continue;
                        if (throwable != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ds.close();
                    }
                }
                catch (IOException e) {
                    Printer.instance.print("\u8b66\u544a\uff1a\u6587\u4ef6\u8282\u70b9\u6548\u9a8c\u65f6\u53d1\u751f\u610f\u5916\u9519\u8bef\uff0c\u53ef\u80fd\u672a\u80fd\u6b63\u786e\u5b8c\u6210\u6587\u4ef6\u8282\u70b9\u6548\u9a8c\u3002\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
                    this.lu.writeException(e);
                }
            }
        });
        checkThread.start();
    }

    private void checkNodes(String fid) {
        List<Node> nodes = this.fm.queryByParentFolderId(fid);
        for (Node node : nodes) {
            File block = this.getFileFromBlocks(node);
            if (block == null) {
                this.fm.deleteById(node.getFileId());
                continue;
            }
            String correctSize = this.getFileSize(block.length());
            if (node.getFileSize().equals(correctSize)) continue;
            node.setFileSize(correctSize);
            this.fm.update(node);
        }
        List<Folder> folders = this.flm.queryByParentId(fid);
        for (Folder fl : folders) {
            this.checkNodes(fl.getFolderId());
        }
    }

    public String createZip(List<String> idList, List<String> fidList, String account) {
        String zipname = "tf_" + UUID.randomUUID().toString() + ".zip";
        String tempPath = ConfigureReader.instance().getTemporaryfilePath();
        File f = new File(tempPath, zipname);
        try {
            ArrayList<ZipEntrySource> zs = new ArrayList<ZipEntrySource>();
            ArrayList<Folder> folders = new ArrayList<Folder>();
            for (String fid : fidList) {
                Folder fo = this.flm.queryById(fid);
                if (!ConfigureReader.instance().accessFolder(fo, account) || !ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(fo.getFolderParent())) || fo == null) continue;
                folders.add(fo);
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String id : idList) {
                Node n = this.fm.queryById(id);
                if (!ConfigureReader.instance().accessFolder(this.flm.queryById(n.getFileParentFolder()), account) || !ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(n.getFileParentFolder())) || n == null) continue;
                nodes.add(n);
            }
            for (Folder fo : folders) {
                int i = 1;
                String flname = fo.getFolderName();
                while (folders.parallelStream().filter(e -> e.getFolderName().equals(fo.getFolderName())).count() > 1L) {
                    fo.setFolderName(flname + " " + i);
                    ++i;
                }
                this.addFoldersToZipEntrySourceArray(fo, zs, account, "");
            }
            for (Node node : nodes) {
                if (!ConfigureReader.instance().accessFolder(this.flm.queryById(node.getFileParentFolder()), account)) continue;
                int i = 1;
                String fname = node.getFileName();
                while (nodes.parallelStream().filter(e -> e.getFileName().equals(node.getFileName())).count() > 1L || folders.parallelStream().filter(e -> e.getFolderName().equals(node.getFileName())).count() > 0L) {
                    if (fname.indexOf(".") >= 0) {
                        node.setFileName(fname.substring(0, fname.lastIndexOf(".")) + " (" + i + ")" + fname.substring(fname.lastIndexOf(".")));
                    } else {
                        node.setFileName(fname + " (" + i + ")");
                    }
                    ++i;
                }
                zs.add((ZipEntrySource)new FileSource(node.getFileName(), this.getFileFromBlocks(node)));
            }
            ZipUtil.pack((ZipEntrySource[])zs.toArray(new ZipEntrySource[0]), (File)f);
            return zipname;
        }
        catch (Exception e2) {
            this.lu.writeException(e2);
            Printer.instance.print(e2.getMessage());
            return null;
        }
    }

    private void addFoldersToZipEntrySourceArray(Folder f, List<ZipEntrySource> zs, String account, String parentPath) {
        if (f != null && ConfigureReader.instance().accessFolder(f, account)) {
            String folderName = f.getFolderName();
            final String thisPath = parentPath + folderName + "/";
            zs.add(new ZipEntrySource(){

                public String getPath() {
                    return thisPath;
                }

                public InputStream getInputStream() throws IOException {
                    return null;
                }

                public ZipEntry getEntry() {
                    return new ZipEntry(thisPath);
                }
            });
            List<Folder> folders = this.flm.queryByParentId(f.getFolderId());
            for (Folder fo : folders) {
                int i = 1;
                String flname = fo.getFolderName();
                while (folders.parallelStream().filter(e -> e.getFolderName().equals(fo.getFolderName())).count() > 1L) {
                    fo.setFolderName(flname + " " + i);
                    ++i;
                }
                this.addFoldersToZipEntrySourceArray(fo, zs, account, thisPath);
            }
            List<Node> nodes = this.fm.queryByParentFolderId(f.getFolderId());
            for (Node node : nodes) {
                int i = 1;
                String fname = node.getFileName();
                while (nodes.parallelStream().filter(e -> e.getFileName().equals(node.getFileName())).count() > 1L || folders.parallelStream().filter(e -> e.getFolderName().equals(node.getFileName())).count() > 0L) {
                    if (fname.indexOf(".") >= 0) {
                        node.setFileName(fname.substring(0, fname.lastIndexOf(".")) + " (" + i + ")" + fname.substring(fname.lastIndexOf(".")));
                    } else {
                        node.setFileName(fname + " (" + i + ")");
                    }
                    ++i;
                }
                zs.add((ZipEntrySource)new FileSource(thisPath + node.getFileName(), this.getFileFromBlocks(node)));
            }
        }
    }

    public String getETag(File block) {
        if (block != null && block.exists()) {
            StringBuffer sb = new StringBuffer();
            sb.append("W\"");
            sb.append(block.length());
            sb.append("-");
            sb.append(block.lastModified());
            sb.append("\"");
            return sb.toString();
        }
        return "W\"0-0\"";
    }

    public Node insertNewNode(String fileName, String account, String filePath, String fileSize, String fileParentFolder) {
        Node f2 = new Node();
        f2.setFileId(UUID.randomUUID().toString());
        if (account != null) {
            f2.setFileCreator(account);
        } else {
            f2.setFileCreator("\u533f\u540d\u7528\u6237");
        }
        f2.setFileCreationDate(ServerTimeUtil.accurateToDay());
        f2.setFileName(fileName);
        f2.setFileParentFolder(fileParentFolder);
        f2.setFilePath(filePath);
        f2.setFileSize(fileSize);
        int i = 0;
        while (true) {
            try {
                if (this.fm.insert(f2) > 0 && this.isValidNode(f2)) {
                    return f2;
                }
            }
            catch (Exception e) {
                f2.setFileId(UUID.randomUUID().toString());
                if (++i < 10) continue;
            }
            break;
        }
        return null;
    }

    public boolean isValidNode(Node n) {
        Node[] repeats = (Node[])this.fm.queryByParentFolderId(n.getFileParentFolder()).parallelStream().filter(e -> e.getFileName().equals(n.getFileName())).toArray(Node[]::new);
        if (this.flm.queryById(n.getFileParentFolder()) == null || repeats.length > 1) {
            this.fm.deleteById(n.getFileId());
            return false;
        }
        return true;
    }

    public String getNodePath(Node n) {
        Folder folder = this.flm.queryById(n.getFileParentFolder());
        List<Folder> l = this.fu.getParentList(folder.getFolderId());
        StringBuffer pl = new StringBuffer();
        for (Folder i : l) {
            pl.append(i.getFolderName() + "/");
        }
        pl.append(folder.getFolderName());
        pl.append("/");
        pl.append(n.getFileName());
        return pl.toString();
    }
}

