/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.enumeration.LogLevel;
import kohgylw.kiftd.server.enumeration.VCLevel;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.pojo.ExtendStores;
import kohgylw.kiftd.server.pojo.ServerSetting;
import kohgylw.kiftd.server.util.KiftdProperties;

public class ConfigureReader {
    public static final int INVALID_DOWNLOAD_ZIP_SETTING = 15;
    private static ConfigureReader cr;
    private KiftdProperties serverp;
    private KiftdProperties accountp;
    private int propertiesStatus = -1;
    private String path = System.getProperty("user.dir");
    private String fileSystemPath;
    private String confdir;
    private String mustLogin;
    private int port;
    private String log;
    private String vc;
    private String FSPath;
    private List<ExtendStores> extendStores;
    private int bufferSize;
    private String fileBlockPath;
    private String fileNodePath;
    private String TFPath;
    private String dbURL;
    private String dbDriver;
    private String dbUser;
    private String dbPwd;
    private boolean allowChangePassword;
    private boolean openFileChain;
    private boolean allowSignUp;
    private String signUpAuth;
    private String signUpGroup;
    private final String ACCOUNT_PROPERTIES_FILE = "account.properties";
    private final String SERVER_PROPERTIES_FILE = "server.properties";
    private final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final int DEFAULT_PORT = 8080;
    private final String DEFAULT_LOG_LEVEL = "E";
    private final String DEFAULT_VC_LEVEL = "STANDARD";
    private final String DEFAULT_MUST_LOGIN = "O";
    private final String DEFAULT_FILE_SYSTEM_PATH;
    private final String DEFAULT_FILE_SYSTEM_PATH_SETTING = "DEFAULT";
    private final String DEFAULT_ACCOUNT_ID = "admin";
    private final String DEFAULT_ACCOUNT_PWD = "000000";
    private final String DEFAULT_ACCOUNT_AUTH = "cudrm";
    private final String DEFAULT_AUTH_OVERALL = "l";
    private final String DEFAULT_PASSWORD_CHANGE_SETTING = "N";
    private final String DEFAULT_FILE_CHAIN_SETTING = "CLOSE";
    public static final int INVALID_PORT = 1;
    public static final int INVALID_LOG = 2;
    public static final int INVALID_FILE_SYSTEM_PATH = 3;
    public static final int INVALID_BUFFER_SIZE = 4;
    public static final int CANT_CREATE_FILE_BLOCK_PATH = 5;
    public static final int CANT_CREATE_FILE_NODE_PATH = 6;
    public static final int CANT_CREATE_TF_PATH = 7;
    public static final int CANT_CONNECT_DB = 8;
    public static final int HTTPS_SETTING_ERROR = 9;
    public static final int INVALID_VC = 10;
    public static final int INVALID_CHANGE_PASSWORD_SETTING = 11;
    public static final int INVALID_FILE_CHAIN_SETTING = 12;
    public static final int INVALID_IP_XFF_SETTING = 13;
    public static final int INVALID_FFMPEG_SETTING = 14;
    public static final int INVALID_MUST_LOGIN_SETTING = 15;
    public static final int INVALID_WEBDAV_SETTING = 16;
    public static final int INVALID_RECYCLE_BIN_PATH = 17;
    public static final int LEGAL_PROPERTIES = 0;
    private static Thread accountPropertiesUpdateDaemonThread;
    private String timeZone;
    private boolean openHttps;
    private String httpsKeyFile;
    private String httpsKeyType;
    private String httpsKeyPass;
    private int httpsPort;
    private Set<String> ipRoster;
    private boolean ipAllowOrBanned;
    private boolean enableIPRule;
    private boolean ipXFFAnalysis = true;
    private boolean enableFFMPEG = true;
    private boolean enableDownloadByZip = true;
    private boolean enableWebDAV = true;
    private String recycleBinPath;
    private static final int MAX_EXTENDSTORES_NUM = 255;
    private static final String DEFAULT_IMPORT_ACCOUNT = "SYS_IN";
    private static final String[] SYS_ACCOUNTS;

    private ConfigureReader() {
        File accountProp;
        File f;
        String classPath = System.getProperty("java.class.path");
        if (classPath.indexOf(File.pathSeparator) < 0 && (classPath = (f = new File(classPath)).getAbsolutePath()).endsWith(".jar")) {
            this.path = classPath.substring(0, classPath.lastIndexOf(File.separator));
        }
        this.DEFAULT_FILE_SYSTEM_PATH = this.path + File.separator + "filesystem" + File.separator;
        this.confdir = this.path + File.separator + "conf" + File.separator;
        this.serverp = new KiftdProperties();
        this.accountp = new KiftdProperties();
        this.extendStores = new ArrayList<ExtendStores>();
        this.ipRoster = new TreeSet<String>();
        File serverProp = new File(this.confdir + "server.properties");
        if (!serverProp.isFile()) {
            Printer.instance.print("\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521d\u59cb\u5316\u670d\u52a1\u5668\u914d\u7f6e\u3002");
            this.createDefaultServerPropertiesFile();
        }
        if (!(accountProp = new File(this.confdir + "account.properties")).isFile()) {
            Printer.instance.print("\u7528\u6237\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521d\u59cb\u5316\u8d26\u6237\u914d\u7f6e\u3002");
            this.createDefaultAccountPropertiesFile();
        }
        try {
            Printer.instance.print("\u6b63\u5728\u8f7d\u5165\u914d\u7f6e\u6587\u4ef6...");
            FileInputStream serverPropIn = new FileInputStream(serverProp);
            this.serverp.load(serverPropIn);
            FileInputStream accountPropIn = new FileInputStream(accountProp);
            this.accountp.load(accountPropIn);
            this.initIPRules();
            this.initSignUpRules();
            Printer.instance.print("\u914d\u7f6e\u6587\u4ef6\u8f7d\u5165\u5b8c\u6bd5\u3002\u6b63\u5728\u68c0\u67e5\u914d\u7f6e...");
            this.propertiesStatus = this.testServerPropertiesAndEffect();
            if (this.propertiesStatus == 0) {
                Printer.instance.print("\u51c6\u5907\u5c31\u7eea\u3002");
                this.startAccountRealTimeUpdateListener();
            }
        }
        catch (Exception e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u52a0\u8f7d\u4e00\u4e2a\u6216\u591a\u4e2a\u914d\u7f6e\u6587\u4ef6\uff08\u4f4d\u4e8e" + this.confdir + "\u8def\u5f84\u4e0b\uff09\uff0c\u8bf7\u5c1d\u8bd5\u5220\u9664\u65e7\u7684\u914d\u7f6e\u6587\u4ef6\u5e76\u91cd\u65b0\u542f\u52a8\u672c\u5e94\u7528\u6216\u67e5\u770b\u5b89\u88c5\u8def\u5f84\u7684\u6743\u9650\uff08\u5fc5\u987b\u53ef\u8bfb\u5199\uff09\u3002");
        }
    }

    public static ConfigureReader instance() {
        if (cr == null) {
            cr = new ConfigureReader();
        }
        return cr;
    }

    public boolean foundAccount(String account) {
        if (account == null) {
            return false;
        }
        for (String sysAccount : SYS_ACCOUNTS) {
            if (!sysAccount.equals(account)) continue;
            return true;
        }
        if (this.getImportAccount().equals(account)) {
            return true;
        }
        String accountPwd = this.accountp.getProperty(account + ".pwd");
        return accountPwd != null && accountPwd.length() > 0;
    }

    public boolean checkAccountPwd(String account, String pwd) {
        String apwd = this.accountp.getProperty(account + ".pwd");
        return apwd != null && apwd.equals(pwd);
    }

    public boolean authorized(String account, AccountAuth auth, List<String> folders) {
        if (this.hasSuperAuth(account)) {
            return true;
        }
        if (account != null && account.length() > 0) {
            StringBuffer auths = new StringBuffer();
            for (String id : folders) {
                String addedAuth = this.accountp.getProperty(account + ".auth." + id);
                if (addedAuth == null) continue;
                auths.append(addedAuth);
            }
            String accauth = this.accountp.getProperty(account + ".auth");
            String overall = this.accountp.getProperty("authOverall");
            if (accauth != null) {
                auths.append(accauth);
            }
            if (overall != null) {
                auths.append(overall);
            }
            switch (auth) {
                case CREATE_NEW_FOLDER: {
                    return auths.indexOf("c") >= 0;
                }
                case UPLOAD_FILES: {
                    return auths.indexOf("u") >= 0;
                }
                case DELETE_FILE_OR_FOLDER: {
                    return auths.indexOf("d") >= 0;
                }
                case RENAME_FILE_OR_FOLDER: {
                    return auths.indexOf("r") >= 0;
                }
                case DOWNLOAD_FILES: {
                    return auths.indexOf("l") >= 0;
                }
                case MOVE_FILES: {
                    return auths.indexOf("m") >= 0;
                }
            }
            return false;
        }
        String overall2 = this.accountp.getProperty("authOverall");
        if (overall2 == null) {
            return false;
        }
        switch (auth) {
            case CREATE_NEW_FOLDER: {
                return overall2.indexOf("c") >= 0;
            }
            case UPLOAD_FILES: {
                return overall2.indexOf("u") >= 0;
            }
            case DELETE_FILE_OR_FOLDER: {
                return overall2.indexOf("d") >= 0;
            }
            case RENAME_FILE_OR_FOLDER: {
                return overall2.indexOf("r") >= 0;
            }
            case DOWNLOAD_FILES: {
                return overall2.indexOf("l") >= 0;
            }
            case MOVE_FILES: {
                return overall2.indexOf("m") >= 0;
            }
        }
        return false;
    }

    public int getBuffSize() {
        return this.bufferSize;
    }

    public String getInitBuffSize() {
        if (this.serverp != null && this.serverp.getProperty("buff.size") != null) {
            return this.serverp.getProperty("buff.size");
        }
        return "1048576";
    }

    public boolean inspectLogLevel(LogLevel l) {
        String log;
        int o = 0;
        int m = 0;
        if (l == null) {
            return false;
        }
        switch (l) {
            case None: {
                m = 0;
                break;
            }
            case Runtime_Exception: {
                m = 1;
            }
            case Event: {
                m = 2;
                break;
            }
            default: {
                m = 0;
            }
        }
        if (this.log == null) {
            this.log = "";
        }
        switch (log = this.log) {
            case "N": {
                o = 0;
                break;
            }
            case "R": {
                o = 1;
                break;
            }
            case "E": {
                o = 2;
                break;
            }
            default: {
                o = 1;
            }
        }
        return o >= m;
    }

    public boolean mustLogin() {
        return this.mustLogin != null && this.mustLogin.equals("N");
    }

    public String getFileSystemPath() {
        return this.fileSystemPath;
    }

    public String getInitFileSystemPath() {
        if (this.serverp != null && this.serverp.getProperty("FS.path") != null) {
            return this.serverp.getProperty("FS.path").equals("DEFAULT") ? this.DEFAULT_FILE_SYSTEM_PATH : this.serverp.getProperty("FS.path");
        }
        return this.DEFAULT_FILE_SYSTEM_PATH;
    }

    public String getFileBlockPath() {
        return this.fileBlockPath;
    }

    public List<ExtendStores> getExtendStores() {
        return this.extendStores;
    }

    public String getFileNodePath() {
        return this.fileNodePath;
    }

    public String getTemporaryfilePath() {
        return this.TFPath;
    }

    public String getPath() {
        return this.path;
    }

    public LogLevel getLogLevel() {
        String log;
        if (this.log == null) {
            this.log = "";
        }
        switch (log = this.log) {
            case "N": {
                return LogLevel.None;
            }
            case "R": {
                return LogLevel.Runtime_Exception;
            }
            case "E": {
                return LogLevel.Event;
            }
        }
        return null;
    }

    public LogLevel getInitLogLevel() {
        if (this.serverp != null && this.serverp.getProperty("log") != null) {
            switch (this.serverp.getProperty("log")) {
                case "N": {
                    return LogLevel.None;
                }
                case "R": {
                    return LogLevel.Runtime_Exception;
                }
                case "E": {
                    return LogLevel.Event;
                }
            }
            return LogLevel.Event;
        }
        return LogLevel.Event;
    }

    public VCLevel getVCLevel() {
        String vc;
        if (this.vc == null) {
            this.vc = "";
        }
        switch (vc = this.vc) {
            case "STANDARD": {
                return VCLevel.Standard;
            }
            case "SIMP": {
                return VCLevel.Simplified;
            }
            case "CLOSE": {
                return VCLevel.Close;
            }
        }
        return null;
    }

    public VCLevel getInitVCLevel() {
        if (this.serverp != null && this.serverp.getProperty("VC.level") != null) {
            switch (this.serverp.getProperty("VC.level")) {
                case "STANDARD": {
                    return VCLevel.Standard;
                }
                case "SIMP": {
                    return VCLevel.Simplified;
                }
                case "CLOSE": {
                    return VCLevel.Close;
                }
            }
            return VCLevel.Standard;
        }
        return VCLevel.Standard;
    }

    public int getPort() {
        return this.port;
    }

    public String getInitPort() {
        if (this.serverp != null && this.serverp.getProperty("port") != null) {
            return this.serverp.getProperty("port");
        }
        return "8080";
    }

    public int getPropertiesStatus() {
        return this.propertiesStatus;
    }

    public void reTestServerPropertiesAndEffect() {
        this.propertiesStatus = this.testServerPropertiesAndEffect();
    }

    public boolean doUpdate(ServerSetting ss) {
        if (ss != null) {
            Printer.instance.print("\u6b63\u5728\u66f4\u65b0\u670d\u52a1\u5668\u914d\u7f6e...");
            this.serverp.setProperty("mustLogin", ss.isMustLogin() ? "N" : "O");
            this.serverp.setProperty("buff.size", ss.getBuffSize() + "");
            this.serverp.setProperty("password.change", ss.isAllowChangePassword() ? "Y" : "N");
            this.serverp.setProperty("openFileChain", ss.isOpenFileChain() ? "OPEN" : "CLOSE");
            String loglevelCode = "E";
            switch (ss.getLog()) {
                case Event: {
                    loglevelCode = "E";
                    break;
                }
                case Runtime_Exception: {
                    loglevelCode = "R";
                    break;
                }
                case None: {
                    loglevelCode = "N";
                }
            }
            this.serverp.setProperty("log", loglevelCode);
            switch (ss.getVc()) {
                case Standard: {
                    this.serverp.setProperty("VC.level", "STANDARD");
                    break;
                }
                case Close: {
                    this.serverp.setProperty("VC.level", "CLOSE");
                    break;
                }
                case Simplified: {
                    this.serverp.setProperty("VC.level", "SIMP");
                }
            }
            this.serverp.setProperty("port", ss.getPort() + "");
            this.serverp.setProperty("FS.path", (ss.getFsPath() + File.separator).equals(this.DEFAULT_FILE_SYSTEM_PATH) ? "DEFAULT" : ss.getFsPath());
            for (int i = 1; i < 255; i = (int)((short)(i + 1))) {
                this.serverp.removeProperty("FS.extend." + i);
            }
            for (ExtendStores es : ss.getExtendStores()) {
                this.serverp.setProperty("FS.extend." + es.getIndex(), es.getPath().getAbsolutePath());
            }
            if (this.testServerPropertiesAndEffect() == 0) {
                try {
                    this.serverp.store(new FileOutputStream(this.confdir + "server.properties"), null);
                    Printer.instance.print("\u914d\u7f6e\u66f4\u65b0\u5b8c\u6bd5\uff0c\u51c6\u5907\u5c31\u7eea\u3002");
                    return true;
                }
                catch (Exception e) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u66f4\u65b0\u8bbe\u7f6e\u5931\u8d25\uff0c\u65e0\u6cd5\u5b58\u5165\u8bbe\u7f6e\u6587\u4ef6\u3002");
                }
            }
        }
        return false;
    }

    private int testServerPropertiesAndEffect() {
        String xffConf;
        String enableHttps;
        Printer.instance.print("\u6b63\u5728\u68c0\u67e5\u670d\u52a1\u5668\u914d\u7f6e...");
        String pMustLogin = this.serverp.getProperty("mustLogin");
        if (pMustLogin == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u662f\u5426\u5fc5\u987b\u767b\u5f55\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08O\uff09\u3002");
            this.mustLogin = "O";
        } else {
            if (!"N".equals(pMustLogin) && !"O".equals(pMustLogin)) {
                Printer.instance.print("\u9519\u8bef\uff1a\u5fc5\u987b\u767b\u5165\u529f\u80fd\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cO\u201d\u6216\u201cN\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                return 15;
            }
            this.mustLogin = pMustLogin;
        }
        String ports = this.serverp.getProperty("port");
        if (ports == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u7aef\u53e3\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff088080\uff09\u3002");
            this.port = 8080;
        } else {
            try {
                this.port = Integer.parseInt(ports);
                if (this.port <= 0 || this.port > 65535) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u7aef\u53e3\u53f7\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4f7f\u75281-65535\u4e4b\u95f4\u7684\u6574\u6570\u3002");
                    return 1;
                }
            }
            catch (Exception e) {
                Printer.instance.print("\u9519\u8bef\uff1a\u7aef\u53e3\u53f7\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4f7f\u75281-65535\u4e4b\u95f4\u7684\u6574\u6570\u3002");
                return 1;
            }
        }
        String logs = this.serverp.getProperty("log");
        if (logs == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u65e5\u5fd7\u7b49\u7ea7\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08E\uff09\u3002");
            this.log = "E";
        } else {
            if (!(logs.equals("N") || logs.equals("R") || logs.equals("E"))) {
                Printer.instance.print("\u9519\u8bef\uff1a\u65e5\u5fd7\u7b49\u7ea7\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cN\u201d\u3001\u201cR\u201d\u6216\u201cE\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                return 2;
            }
            this.log = logs;
        }
        String vcl = this.serverp.getProperty("VC.level");
        if (vcl == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u767b\u5f55\u9a8c\u8bc1\u7801\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08STANDARD\uff09\u3002");
            this.vc = "STANDARD";
        } else {
            switch (vcl) {
                case "STANDARD": 
                case "SIMP": 
                case "CLOSE": {
                    this.vc = vcl;
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1a\u767b\u5f55\u9a8c\u8bc1\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cSTANDARD\u201d\u3001\u201cSIMP\u201d\u6216\u201cCLOSE\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                    return 10;
                }
            }
        }
        String changePassword = this.serverp.getProperty("password.change");
        if (changePassword == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u7528\u6237\u4fee\u6539\u5bc6\u7801\u529f\u80fd\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08\u7981\u7528\uff09\u3002");
            this.allowChangePassword = false;
        } else {
            switch (changePassword) {
                case "Y": {
                    this.allowChangePassword = true;
                    break;
                }
                case "N": {
                    this.allowChangePassword = false;
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1a\u7528\u6237\u4fee\u6539\u8d26\u6237\u5bc6\u7801\u529f\u80fd\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cY\u201d\u6216\u201cN\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                    return 11;
                }
            }
        }
        String fileChain = this.serverp.getProperty("openFileChain");
        if (fileChain == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u6c38\u4e45\u8d44\u6e90\u94fe\u63a5\u529f\u80fd\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08\u7981\u7528\uff09\u3002");
            this.openFileChain = false;
        } else {
            switch (fileChain) {
                case "OPEN": {
                    this.openFileChain = true;
                    break;
                }
                case "CLOSE": {
                    this.openFileChain = false;
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1a\u6c38\u4e45\u8d44\u6e90\u94fe\u63a5\u529f\u80fd\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cOPEN\u201d\u6216\u201cCLOSE\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                    return 12;
                }
            }
        }
        String bufferSizes = this.serverp.getProperty("buff.size");
        if (bufferSizes == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u7f13\u51b2\u5927\u5c0f\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff081048576\uff09\u3002");
            this.bufferSize = 0x100000;
        } else {
            try {
                this.bufferSize = Integer.parseInt(bufferSizes);
                if (this.bufferSize <= 0) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u7f13\u51b2\u533a\u5927\u5c0f\u8bbe\u7f6e\u65e0\u6548\u3002");
                    return 4;
                }
            }
            catch (Exception e2) {
                Printer.instance.print("\u9519\u8bef\uff1a\u7f13\u51b2\u533a\u5927\u5c0f\u8bbe\u7f6e\u65e0\u6548\u3002");
                return 4;
            }
        }
        this.FSPath = this.serverp.getProperty("FS.path");
        if (this.FSPath == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u4e3b\u6587\u4ef6\u7cfb\u7edf\u8def\u5f84\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\u3002");
            this.fileSystemPath = this.DEFAULT_FILE_SYSTEM_PATH;
        } else {
            this.fileSystemPath = this.FSPath.equals("DEFAULT") ? this.DEFAULT_FILE_SYSTEM_PATH : this.FSPath.replaceAll("\\\\:", ":").replaceAll("\\\\\\\\", "\\\\");
        }
        if (!this.fileSystemPath.endsWith(File.separator)) {
            this.fileSystemPath = this.fileSystemPath + File.separator;
        }
        this.extendStores.clear();
        for (short i = 1; i < 256; i = (short)((short)(i + 1))) {
            if (this.serverp.getProperty("FS.extend." + i) == null) continue;
            ExtendStores es = new ExtendStores();
            es.setPath(new File(this.serverp.getProperty("FS.extend." + i).replaceAll("\\\\:", ":").replaceAll("\\\\\\\\", "\\\\")));
            es.setIndex(i);
            this.extendStores.add(es);
        }
        File fsFile = new File(this.fileSystemPath);
        if (!(fsFile.isDirectory() && fsFile.canRead() && fsFile.canWrite())) {
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u7cfb\u7edf\u8def\u5f84[" + this.fileSystemPath + "]\u65e0\u6548\uff0c\u8be5\u8def\u5f84\u5fc5\u987b\u6307\u5411\u4e00\u4e2a\u5177\u5907\u8bfb\u5199\u6743\u9650\u7684\u6587\u4ef6\u5939\u3002");
            return 3;
        }
        for (ExtendStores es : this.extendStores) {
            if (es.getPath().isDirectory() && es.getPath().canRead() && es.getPath().canWrite()) continue;
            Printer.instance.print("\u9519\u8bef\uff1a\u6269\u5c55\u5b58\u50a8\u533a\u8def\u5f84[" + es.getPath().getAbsolutePath() + "]\u65e0\u6548\uff0c\u8be5\u8def\u5f84\u5fc5\u987b\u6307\u5411\u4e00\u4e2a\u5177\u5907\u8bfb\u5199\u6743\u9650\u7684\u6587\u4ef6\u5939\u3002");
            return 3;
        }
        for (int i = 0; i < this.extendStores.size() - 1; ++i) {
            for (int j = i + 1; j < this.extendStores.size(); ++j) {
                if (!this.extendStores.get(i).getPath().equals(this.extendStores.get(j).getPath())) continue;
                Printer.instance.print("\u9519\u8bef\uff1a\u6269\u5c55\u5b58\u50a8\u533a\u8def\u5f84[" + this.extendStores.get(j).getPath().getAbsolutePath() + "]\u65e0\u6548\uff0c\u8be5\u8def\u5f84\u5df2\u88ab\u5176\u4ed6\u6269\u5c55\u5b58\u50a8\u533a\u5360\u7528\u3002");
                return 3;
            }
        }
        this.fileBlockPath = this.fileSystemPath + "fileblocks" + File.separator;
        File fbFile = new File(this.fileBlockPath);
        if (!fbFile.isDirectory() && !fbFile.mkdirs()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u5757\u5b58\u653e\u533a[" + this.fileBlockPath + "]\u3002");
            return 5;
        }
        this.fileNodePath = this.fileSystemPath + "filenodes" + File.separator;
        File fnFile = new File(this.fileNodePath);
        if (!fnFile.isDirectory() && !fnFile.mkdirs()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u8282\u70b9\u5b58\u653e\u533a[" + this.fileNodePath + "]\u3002");
            return 6;
        }
        this.TFPath = this.fileSystemPath + "temporaryfiles" + File.separator;
        File tpFile = new File(this.TFPath);
        if (!tpFile.isDirectory() && !tpFile.mkdirs()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5b58\u653e\u533a[" + this.TFPath + "]\u3002");
            return 7;
        }
        if ("true".equals(this.serverp.getProperty("mysql.enable"))) {
            this.dbDriver = "com.mysql.cj.jdbc.Driver";
            String url = this.serverp.getProperty("mysql.url", "127.0.0.1/kift");
            if (url.indexOf("/") <= 0 || url.substring(url.indexOf("/")).length() == 1) {
                Printer.instance.print("\u9519\u8bef\uff1a\u81ea\u5b9a\u4e49\u6570\u636e\u5e93\u7684URL\u4e2d\u5fc5\u987b\u6307\u5b9a\u6570\u636e\u5e93\u540d\u79f0\u3002");
                return 8;
            }
            this.dbURL = "jdbc:mysql://" + url + "?useUnicode=true&characterEncoding=utf8";
            this.dbUser = this.serverp.getProperty("mysql.user", "root");
            this.dbPwd = this.serverp.getProperty("mysql.password", "");
            this.timeZone = this.serverp.getProperty("mysql.timezone");
            if (this.timeZone != null) {
                this.dbURL = this.dbURL + "&serverTimezone=" + this.timeZone;
            }
            try {
                Class.forName(this.dbDriver).newInstance();
                Connection testConn = DriverManager.getConnection(this.dbURL, this.dbUser, this.dbPwd);
                testConn.close();
            }
            catch (Exception e) {
                Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u8fde\u63a5\u81f3\u81ea\u5b9a\u4e49\u6570\u636e\u5e93\uff1a" + this.dbURL + "\uff08user=" + this.dbUser + ",password=" + this.dbPwd + "\uff09\uff0c\u8bf7\u786e\u91cd\u65b0\u914d\u7f6eMySQL\u6570\u636e\u5e93\u76f8\u5173\u9879\u3002");
                return 8;
            }
        } else {
            this.dbDriver = "org.h2.Driver";
            this.dbURL = "jdbc:h2:file:" + this.fileNodePath + "kift";
            this.dbUser = "root";
            this.dbPwd = "301537gY";
        }
        if ((enableHttps = this.serverp.getProperty("https.enable")) != null) {
            if ("true".equals(enableHttps)) {
                File keyFile = new File(this.path, "https.p12");
                if (keyFile.isFile()) {
                    this.httpsKeyType = "PKCS12";
                } else {
                    keyFile = new File(this.path, "https.jks");
                    if (keyFile.isFile()) {
                        this.httpsKeyType = "JKS";
                    } else {
                        Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u542f\u7528https\u652f\u6301\uff0c\u56e0\u4e3akiftd\u672a\u80fd\u627e\u5230https\u8bc1\u4e66\u6587\u4ef6\u3002\u60a8\u5fc5\u987b\u5728\u5e94\u7528\u4e3b\u76ee\u5f55\u5185\u653e\u7f6ePKCS12\uff08\u5fc5\u987b\u547d\u540d\u4e3ahttps.p12\uff09\u6216JKS\uff08\u5fc5\u987b\u547d\u540d\u4e3ahttps.jks\uff09\u8bc1\u4e66\u3002");
                        return 9;
                    }
                }
                this.httpsKeyFile = keyFile.getAbsolutePath();
                this.httpsKeyPass = this.serverp.getProperty("https.keypass", "");
                String httpsports = this.serverp.getProperty("https.port");
                if (httpsports == null) {
                    Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230https\u7aef\u53e3\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08443\uff09\u3002");
                    this.httpsPort = 443;
                } else {
                    try {
                        this.httpsPort = Integer.parseInt(httpsports);
                        if (this.httpsPort <= 0 || this.httpsPort > 65535) {
                            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u542f\u7528https\u652f\u6301\uff0chttps\u8bbf\u95ee\u7aef\u53e3\u53f7\u914d\u7f6e\u4e0d\u6b63\u786e\u3002");
                            return 9;
                        }
                    }
                    catch (Exception e) {
                        Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u542f\u7528https\u652f\u6301\uff0chttps\u8bbf\u95ee\u7aef\u53e3\u53f7\u914d\u7f6e\u4e0d\u6b63\u786e\u3002");
                        return 9;
                    }
                }
                this.openHttps = true;
            } else if (!"false".equals(enableHttps)) {
                Printer.instance.print("\u9519\u8bef\uff1ahttps\u652f\u6301\u529f\u80fd\u7684\u542f\u7528\u9879\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201ctrue\u201d\u6216\u201cfalse\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                return 9;
            }
        }
        if ((xffConf = this.serverp.getProperty("IP.xff")) != null) {
            switch (xffConf) {
                case "disable": {
                    this.ipXFFAnalysis = false;
                    break;
                }
                case "enable": {
                    this.ipXFFAnalysis = true;
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1aIP\u5730\u5740xff\u89e3\u6790\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cdisable\u201d\u6216\u201cenable\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                    return 13;
                }
            }
        } else {
            this.ipXFFAnalysis = true;
        }
        String ffmpegConf = this.serverp.getProperty("video.ffmpeg");
        if (ffmpegConf != null) {
            switch (ffmpegConf) {
                case "disable": {
                    this.enableFFMPEG = false;
                    break;
                }
                case "enable": {
                    this.enableFFMPEG = true;
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1a\u89c6\u9891\u64ad\u653e\u529f\u80fd\u7684\u5728\u7ebf\u89e3\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cdisable\u201d\u6216\u201cenable\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                    return 14;
                }
            }
        } else {
            this.enableFFMPEG = true;
        }
        String downloadZipConf = this.serverp.getProperty("download.zip");
        if (downloadZipConf != null) {
            switch (downloadZipConf) {
                case "disable": {
                    this.enableDownloadByZip = false;
                    break;
                }
                case "enable": {
                    this.enableDownloadByZip = true;
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1a\u201c\u6253\u5305\u4e0b\u8f7d\u201d\u529f\u80fd\u7684\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cdisable\u201d\u6216\u201cenable\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                    return 15;
                }
            }
        } else {
            this.enableDownloadByZip = true;
        }
        String webdavConf = this.serverp.getProperty("webdav");
        if (webdavConf != null) {
            switch (webdavConf) {
                case "disable": {
                    this.enableWebDAV = false;
                    break;
                }
                case "enable": {
                    this.enableWebDAV = true;
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1aWebDAV\u529f\u80fd\u7684\u914d\u7f6e\u4e0d\u6b63\u786e\uff08\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u201cdisable\u201d\u6216\u201cenable\u201d\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
                    return 16;
                }
            }
        } else {
            this.enableWebDAV = true;
        }
        String recycleBinPathProp = this.serverp.getProperty("recyclebin");
        if (recycleBinPathProp != null && !recycleBinPathProp.isEmpty()) {
            File recycleBin;
            if (!(recycleBinPathProp = recycleBinPathProp.replaceAll("\\\\:", ":").replaceAll("\\\\\\\\", "\\\\")).endsWith(File.separator)) {
                recycleBinPathProp = recycleBinPathProp + File.separator;
            }
            if (!((recycleBin = new File(recycleBinPathProp)).isDirectory() && recycleBin.canWrite() && recycleBin.canRead())) {
                Printer.instance.print("\u9519\u8bef\uff1a\u5220\u9664\u7559\u6863\u529f\u80fd\u7684\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662f\u4e00\u4e2a\u53ef\u8bfb\u5199\u7684\u6587\u4ef6\u5939\u3002");
                return 17;
            }
            this.recycleBinPath = recycleBin.getAbsolutePath();
        }
        Printer.instance.print("\u68c0\u67e5\u5b8c\u6bd5\u3002");
        return 0;
    }

    public void createDefaultServerPropertiesFile() {
        Printer.instance.print("\u6b63\u5728\u751f\u6210\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\uff08" + this.confdir + "server.properties" + "\uff09...");
        Properties dsp = new Properties();
        dsp.setProperty("mustLogin", "O");
        dsp.setProperty("port", "8080");
        dsp.setProperty("log", "E");
        dsp.setProperty("VC.level", "STANDARD");
        dsp.setProperty("FS.path", "DEFAULT");
        dsp.setProperty("buff.size", "1048576");
        dsp.setProperty("password.change", "N");
        dsp.setProperty("openFileChain", "CLOSE");
        try {
            dsp.store(new FileOutputStream(this.confdir + "server.properties"), "<This is the default kiftd server setting file. >");
            Printer.instance.print("\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\u751f\u6210\u5b8c\u6bd5\u3002");
        }
        catch (FileNotFoundException e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\uff0c\u5b58\u50a8\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
        }
        catch (IOException e2) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\uff0c\u5199\u5165\u5931\u8d25\u3002");
        }
    }

    private void createDefaultAccountPropertiesFile() {
        Printer.instance.print("\u6b63\u5728\u751f\u6210\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\uff08" + this.confdir + "account.properties" + "\uff09...");
        Properties dap = new Properties();
        dap.setProperty("admin.pwd", "000000");
        dap.setProperty("admin.auth", "cudrm");
        dap.setProperty("authOverall", "l");
        try (FileOutputStream accountSettingOut = new FileOutputStream(this.confdir + "account.properties");){
            dap.store(accountSettingOut, "<This is the default kiftd account setting file. >");
            Printer.instance.print("\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\u751f\u6210\u5b8c\u6bd5\u3002");
        }
        catch (FileNotFoundException e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\uff0c\u5b58\u50a8\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
        }
        catch (IOException e2) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\uff0c\u5199\u5165\u5931\u8d25\u3002");
        }
    }

    public boolean useMySQL() {
        return this.serverp == null ? false : "true".equals(this.serverp.getProperty("mysql.enable"));
    }

    public String getFileNodePathURL() {
        return this.dbURL;
    }

    public String getFileNodePathDriver() {
        return this.dbDriver;
    }

    public String getFileNodePathUserName() {
        return this.dbUser;
    }

    public String getFileNodePathPassWord() {
        return this.dbPwd;
    }

    public boolean accessFolder(Folder f, String account) {
        if (f == null) {
            return false;
        }
        if (this.hasSuperAuth(account)) {
            return true;
        }
        int cl = f.getFolderConstraint();
        if (cl == 0) {
            return true;
        }
        if (account != null) {
            if (cl == 1) {
                if (f.getFolderCreator().equals(account)) {
                    return true;
                }
                String vGroup = this.accountp.getProperty(account + ".group");
                String cGroup = this.accountp.getProperty(f.getFolderCreator() + ".group");
                if (vGroup != null && cGroup != null) {
                    if ("*".equals(vGroup) || "*".equals(cGroup)) {
                        return true;
                    }
                    String[] vgs = vGroup.split(";");
                    String[] cgs = cGroup.split(";");
                    for (String vs : vgs) {
                        for (String cs : cgs) {
                            if (!vs.equals(cs)) continue;
                            return true;
                        }
                    }
                }
            }
            if (cl == 2 && f.getFolderCreator().equals(account)) {
                return true;
            }
        }
        return false;
    }

    public void startAccountRealTimeUpdateListener() {
        if (accountPropertiesUpdateDaemonThread == null) {
            Path confPath = Paths.get(this.confdir, new String[0]);
            accountPropertiesUpdateDaemonThread = new Thread(() -> {
                try {
                    block5: while (true) {
                        WatchService ws = confPath.getFileSystem().newWatchService();
                        confPath.register(ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE);
                        WatchKey wk = ws.take();
                        List<WatchEvent<?>> es = wk.pollEvents();
                        Iterator<WatchEvent<?>> iterator = es.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block5;
                            WatchEvent<?> we = iterator.next();
                            if (!"account.properties".equals(we.context().toString())) continue;
                            Printer.instance.print("\u6b63\u5728\u66f4\u65b0\u8d26\u6237\u914d\u7f6e\u4fe1\u606f...");
                            File accountProp = new File(this.confdir + "account.properties");
                            if (accountProp.isFile() && accountProp.canRead()) {
                                FileInputStream accountPropIn = new FileInputStream(accountProp);
                                KiftdProperties kiftdProperties = this.accountp;
                                synchronized (kiftdProperties) {
                                    this.accountp.load(accountPropIn);
                                }
                                this.initIPRules();
                                this.initSignUpRules();
                                Printer.instance.print("\u8d26\u6237\u914d\u7f6e\u66f4\u65b0\u5b8c\u6210\uff0c\u5df2\u52a0\u8f7d\u6700\u65b0\u914d\u7f6e\u3002");
                                continue;
                            }
                            this.accountp.clear();
                            Printer.instance.print("\u8b66\u544a\uff1a\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\u5df2\u88ab\u5220\u9664\u6216\u65e0\u6cd5\u8bfb\u53d6\uff0c\u8d26\u6237\u4fe1\u606f\u5df2\u6e05\u7a7a\u3002");
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u66f4\u6539\u76d1\u542c\u5931\u8d25\uff0c\u8be5\u529f\u80fd\u5df2\u5931\u6548\uff0ckiftd\u65e0\u6cd5\u5b9e\u65f6\u66f4\u65b0\u7528\u6237\u914d\u7f6e\uff08\u53ef\u5c1d\u8bd5\u91cd\u542f\u7a0b\u5e8f\u4ee5\u6062\u590d\u8be5\u529f\u80fd\uff09\u3002");
                    return;
                }
            });
            accountPropertiesUpdateDaemonThread.setDaemon(true);
            accountPropertiesUpdateDaemonThread.start();
        }
    }

    public boolean openHttps() {
        return this.openHttps;
    }

    public String getHttpsKeyType() {
        return this.httpsKeyType;
    }

    public String getHttpsKeyFile() {
        return this.httpsKeyFile;
    }

    public String getHttpsKeyPass() {
        return this.httpsKeyPass;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public long getUploadFileSize(String account) {
        String defaultMaxSizeP = this.accountp.getProperty("defaultMaxSize");
        if (account == null) {
            return this.getMaxSizeByString(defaultMaxSizeP);
        }
        String accountMaxSizeP = this.accountp.getProperty(account + ".maxSize");
        return accountMaxSizeP == null ? this.getMaxSizeByString(defaultMaxSizeP) : this.getMaxSizeByString(accountMaxSizeP);
    }

    private long getMaxSizeByString(String in) {
        long r = 0L;
        if (in == null || in.length() <= 0) {
            return -1L;
        }
        try {
            if (in.length() > 1) {
                String value = in.substring(0, in.length() - 1).trim();
                String unit = in.substring(in.length() - 1).toLowerCase();
                if (in.length() > 2 && in.toLowerCase().charAt(in.length() - 1) == 'b') {
                    unit = in.substring(in.length() - 2, in.length() - 1).toLowerCase();
                    value = in.substring(0, in.length() - 2).trim();
                }
                switch (unit) {
                    case "k": {
                        r = (long)Integer.parseInt(value) * 1024L;
                        break;
                    }
                    case "m": {
                        r = (long)Integer.parseInt(value) * 0x100000L;
                        break;
                    }
                    case "g": {
                        r = (long)Integer.parseInt(value) * 0x40000000L;
                        break;
                    }
                    default: {
                        r = Integer.parseInt(in.trim());
                        break;
                    }
                }
            } else {
                r = Integer.parseInt(in.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public long getDownloadMaxRate(String account) {
        String defaultMaxRateP = this.accountp.getProperty("defaultMaxRate");
        if (account == null) {
            return this.getMaxRateByString(defaultMaxRateP);
        }
        String accountMaxRateP = this.accountp.getProperty(account + ".maxRate");
        return accountMaxRateP == null ? this.getMaxRateByString(defaultMaxRateP) : this.getMaxRateByString(accountMaxRateP);
    }

    private long getMaxRateByString(String in) {
        long r = 0L;
        if (in == null || in.length() <= 0) {
            return -1L;
        }
        try {
            if (in.length() > 1) {
                String value = in.substring(0, in.length() - 1).trim();
                String unit = in.substring(in.length() - 1).toLowerCase();
                if (in.length() > 2 && in.toLowerCase().charAt(in.length() - 1) == 'b') {
                    unit = in.substring(in.length() - 2, in.length() - 1).toLowerCase();
                    value = in.substring(0, in.length() - 2).trim();
                }
                switch (unit) {
                    case "k": {
                        r = (long)Integer.parseInt(value) * 1024L;
                        break;
                    }
                    case "m": {
                        r = (long)Integer.parseInt(value) * 0x100000L;
                        break;
                    }
                    case "g": {
                        r = (long)Integer.parseInt(value) * 0x40000000L;
                        break;
                    }
                    default: {
                        r = (long)Integer.parseInt(in.trim()) * 1024L;
                        break;
                    }
                }
            } else {
                r = (long)Integer.parseInt(in.trim()) * 1024L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public List<String> getAllAddedAuthFoldersId() {
        ArrayList<String> foldersId = new ArrayList<String>();
        for (String config : this.accountp.stringPropertieNames()) {
            int index = config.lastIndexOf(".auth.");
            if (index < 0) continue;
            foldersId.add(config.substring(index + 6));
        }
        return foldersId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeAddedAuthByFolderId(List<String> fIds) {
        if (fIds == null || fIds.size() == 0) {
            return false;
        }
        Set<String> configs = this.accountp.stringPropertieNames();
        ArrayList<String> invalidConfigs = new ArrayList<String>();
        for (String string : fIds) {
            for (String config : configs) {
                if (!config.endsWith(".auth." + string)) continue;
                invalidConfigs.add(config);
            }
        }
        KiftdProperties kiftdProperties = this.accountp;
        synchronized (kiftdProperties) {
            for (String config : invalidConfigs) {
                this.accountp.removeProperty(config);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.confdir + "account.properties");
                Object object = null;
                try {
                    this.accountp.store(fileOutputStream, null);
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (fileOutputStream != null) {
                        if (object != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            fileOutputStream.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                Printer.instance.print("\u9519\u8bef\uff1a\u66f4\u65b0\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u7acb\u5373\u68c0\u67e5\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\u3002");
                return false;
            }
        }
    }

    public boolean isAllowChangePassword() {
        return this.allowChangePassword;
    }

    public boolean isOpenFileChain() {
        return this.openFileChain;
    }

    public boolean isAllowSignUp() {
        return this.allowSignUp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changePassword(String account, String newPassword) throws Exception {
        if (account != null && newPassword != null && this.accountp.getProperty(account + ".pwd") != null) {
            KiftdProperties kiftdProperties = this.accountp;
            synchronized (kiftdProperties) {
                this.accountp.setProperty(account + ".pwd", newPassword);
                try (FileOutputStream accountSettingOut = new FileOutputStream(this.confdir + "account.properties");){
                    this.accountp.store(accountSettingOut, null);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean filterAccessIP(String ipAddr) {
        return this.enableIPRule ? this.ipAllowOrBanned ^ this.ipRoster.contains(ipAddr) : false;
    }

    public boolean enableIPRule() {
        return this.enableIPRule;
    }

    private void initIPRules() {
        this.ipRoster.clear();
        String ipRosterSetting = this.accountp.getProperty("IP.allow");
        if (ipRosterSetting != null && ipRosterSetting.length() > 0) {
            this.ipAllowOrBanned = false;
            this.enableIPRule = true;
            this.ipRoster.addAll(Arrays.asList(ipRosterSetting.split(";")));
            return;
        }
        ipRosterSetting = this.accountp.getProperty("IP.banned");
        if (ipRosterSetting != null && ipRosterSetting.length() > 0) {
            this.ipAllowOrBanned = true;
            this.enableIPRule = true;
            this.ipRoster.addAll(Arrays.asList(ipRosterSetting.split(";")));
            return;
        }
        this.enableIPRule = false;
    }

    private void initSignUpRules() {
        String signUpAuth = this.accountp.getProperty("authSignup");
        String signUpGroup = this.accountp.getProperty("groupSignup");
        if (signUpAuth != null || signUpGroup != null) {
            this.allowSignUp = true;
            this.signUpAuth = signUpAuth;
            this.signUpGroup = signUpGroup;
        } else {
            this.allowSignUp = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createNewAccount(String newAccount, String newPassword) throws Exception {
        if (newAccount != null && newPassword != null && this.accountp.getProperty(newAccount + ".pwd") == null) {
            KiftdProperties kiftdProperties = this.accountp;
            synchronized (kiftdProperties) {
                this.accountp.setProperty(newAccount + ".pwd", newPassword);
                if (this.signUpAuth != null) {
                    this.accountp.setProperty(newAccount + ".auth", this.signUpAuth);
                }
                if (this.signUpGroup != null) {
                    this.accountp.setProperty(newAccount + ".group", this.signUpGroup);
                }
                try (FileOutputStream accountSettingOut = new FileOutputStream(this.confdir + "account.properties");){
                    this.accountp.store(accountSettingOut, null);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public int getMaxExtendstoresNum() {
        return 255;
    }

    public boolean isIpXFFAnalysis() {
        return this.ipXFFAnalysis;
    }

    public boolean isEnableFFMPEG() {
        return this.enableFFMPEG;
    }

    public boolean isEnableDownloadByZip() {
        return this.enableDownloadByZip;
    }

    public boolean isEnableWebDAV() {
        return this.enableWebDAV;
    }

    public String getRecycleBinPath() {
        return this.recycleBinPath;
    }

    private boolean hasSuperAuth(String account) {
        return account != null && "S".equals(this.accountp.getProperty(account + ".privilege"));
    }

    public String getImportAccount() {
        String importAccount = this.accountp.getProperty("import.account");
        if (importAccount != null && importAccount.length() > 0) {
            return importAccount;
        }
        return DEFAULT_IMPORT_ACCOUNT;
    }

    static {
        SYS_ACCOUNTS = new String[]{DEFAULT_IMPORT_ACCOUNT, "Anonymous", "\u533f\u540d\u7528\u6237"};
    }
}

