/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.AudioInfo;
import kohgylw.kiftd.server.pojo.AudioInfoList;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.TxtCharsetGetter;
import org.springframework.stereotype.Component;

@Component
public class AudioInfoUtil {
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private LogUtil lu;
    @Resource
    private TxtCharsetGetter tcg;
    private static final String ERROR_ARTIST = "\u7fa4\u661f";
    private static final String DEFAULT_LRC = "css/audio_default.lrc";
    private static final String DEFAULT_COVER = "css/audio_default.png";

    public AudioInfoList transformToAudioInfoList(List<Node> nodes, String fileId) {
        AudioInfoList ail = new AudioInfoList();
        ArrayList<AudioInfo> as = new ArrayList<AudioInfo>();
        int index = 0;
        for (Node n : nodes) {
            String suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".") + 1);
            if (!suffix.equalsIgnoreCase("mp3") && !suffix.equalsIgnoreCase("ogg") && !suffix.equalsIgnoreCase("wav")) continue;
            AudioInfo ai = new AudioInfo();
            ai.setUrl("resourceController/getResource/" + n.getFileId());
            ai.setLrc(DEFAULT_LRC);
            ai.setArtist(ERROR_ARTIST);
            ai.setCover(DEFAULT_COVER);
            this.getAudioArtistAndName(ai, n);
            this.getLrcAndCover(ai, n, nodes);
            as.add(ai);
            if (!fileId.equals(n.getFileId())) continue;
            index = as.size() - 1;
        }
        ail.setAs(as);
        ail.setIndex(index);
        return ail;
    }

    private void getAudioArtistAndName(AudioInfo ai, Node n) {
        File f = this.fbu.getFileFromBlocks(n);
        ai.setName(this.getFileName(n.getFileName()).trim());
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            String artist;
            byte[] buf = new byte[128];
            raf.seek(raf.length() - 128L);
            raf.read(buf);
            if ("TAG".equalsIgnoreCase(new String(buf, 0, 3)) && (artist = this.transformCharsetEncoding(buf, 33, 30)).length() > 0) {
                ai.setArtist(artist);
                if (artist.length() > 0) {
                    return;
                }
            }
            byte[] buf2 = new byte[10];
            raf.seek(0L);
            raf.read(buf2);
            if ("ID3".equalsIgnoreCase(new String(buf2, 0, 3))) {
                int length = (buf2[6] & 0x7F) * 0x200000 + (buf2[7] & 0x7F) * 16384 + (buf2[8] & 0x7F) * 128 + (buf2[9] & 0x7F);
                byte[] buf3 = new byte[length];
                raf.seek(10L);
                raf.read(buf3);
                int count = 0;
                while (count < length - 1) {
                    String artist2;
                    String ftitle = new String(buf3, count, 4);
                    int flength = buf3[count + 4] * 0x1000000 + buf3[count + 5] * 65536 + buf3[count + 6] * 256 + buf3[count + 7];
                    if (ftitle.equalsIgnoreCase("TPE1") && flength != 0 && (artist2 = this.transformCharsetEncoding(buf3, count + 11, flength - 1)).length() > 0) {
                        ai.setArtist(artist2);
                    }
                    count = count + 10 + flength;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getLrcAndCover(AudioInfo ai, Node n, List<Node> ns) {
        for (Node e : ns) {
            String suffix = e.getFileName().substring(e.getFileName().lastIndexOf(".") + 1);
            String nName = this.getFileName(n.getFileName());
            if (this.getFileName(e.getFileName()).equals(nName) && suffix.equalsIgnoreCase("lrc")) {
                ai.setLrc("resourceController/getLRContext/" + e.getFileId());
            }
            if (!this.getFileName(e.getFileName()).equals(nName) && !ai.getArtist().equals(this.getFileName(e.getFileName())) || !suffix.equals("jpg") && !suffix.equals("jpeg") && !suffix.equals("gif") && !suffix.equals("bmp") && !suffix.equals("png")) continue;
            ai.setCover("resourceController/getResource/" + e.getFileId());
        }
    }

    private String getFileName(String originName) {
        return originName.indexOf(".") != -1 ? originName.substring(0, originName.indexOf(".")) : originName;
    }

    private String transformCharsetEncoding(byte[] buf, int offset, int length) {
        try {
            return new String(buf, offset, length, this.tcg.getTxtCharset(buf, offset, length)).trim();
        }
        catch (Exception ex) {
            this.lu.writeException(ex);
            return "";
        }
    }
}

