/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.stereotype.Component;

@Component
public class AESCipher {
    private static final String CIPHER_TYPE = "AES";
    private Base64.Encoder encoder = Base64.getEncoder();
    private Base64.Decoder decoder = Base64.getDecoder();

    public String generateRandomKey() throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(CIPHER_TYPE);
        kg.init(128);
        return this.encoder.encodeToString(kg.generateKey().getEncoded());
    }

    public String encrypt(String base64Key, String content) throws Exception {
        SecretKeySpec key = new SecretKeySpec(this.decoder.decode(base64Key), CIPHER_TYPE);
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        cipher.init(1, key);
        return this.encoder.encodeToString(cipher.doFinal(content.getBytes(StandardCharsets.UTF_8)));
    }

    public String decrypt(String base64Key, String ciphertext) throws Exception {
        SecretKeySpec key = new SecretKeySpec(this.decoder.decode(base64Key), CIPHER_TYPE);
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        cipher.init(2, key);
        return new String(cipher.doFinal(this.decoder.decode(ciphertext)), StandardCharsets.UTF_8);
    }
}

