/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.PictureInfo;
import kohgylw.kiftd.server.pojo.PictureViewList;
import kohgylw.kiftd.server.service.ShowPictureService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.LogUtil;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.stereotype.Service;

@Service
public class ShowPictureServiceImpl
implements ShowPictureService {
    @Resource
    private NodeMapper fm;
    @Resource
    private Gson gson;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private FolderUtil fu;
    @Resource
    private FolderMapper flm;
    @Resource
    private LogUtil lu;

    private PictureViewList foundPictures(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        if (fileId != null && fileId.length() > 0) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            Node p = this.fm.queryById(fileId);
            if (p != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(p.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.flm.queryById(p.getFileParentFolder()), account)) {
                List<Node> nodes = this.fm.queryBySomeFolder(fileId);
                ArrayList<PictureInfo> pictureViewList = new ArrayList<PictureInfo>();
                int index = 0;
                for (Node n : nodes) {
                    String suffix;
                    String fileName = n.getFileName();
                    switch (suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) {
                        case "jpg": 
                        case "jpeg": 
                        case "bmp": 
                        case "png": 
                        case "gif": {
                            PictureInfo pi = new PictureInfo();
                            pi.setFileName(fileName);
                            int pSize = Integer.parseInt(n.getFileSize());
                            File block = this.fbu.getFileFromBlocks(n);
                            long lastModified = block.lastModified();
                            if (pSize > 1 && !suffix.equals("gif")) {
                                pi.setUrl("homeController/showCondensedPicture.do?fileId=" + n.getFileId() + "&lastmodified=" + lastModified);
                            } else {
                                pi.setUrl("resourceController/getResource/" + n.getFileId() + "?lastmodified=" + lastModified);
                            }
                            pictureViewList.add(pi);
                            if (!n.getFileId().equals(fileId)) break;
                            index = pictureViewList.size() - 1;
                            break;
                        }
                    }
                }
                PictureViewList pvl = new PictureViewList();
                pvl.setIndex(index);
                pvl.setPictureViewList(pictureViewList);
                return pvl;
            }
        }
        return null;
    }

    @Override
    public String getPreviewPictureJson(HttpServletRequest request) {
        PictureViewList pvl = this.foundPictures(request);
        if (pvl != null) {
            return this.gson.toJson((Object)pvl);
        }
        return "ERROR";
    }

    @Override
    public void getCondensedPicture(HttpServletRequest request, HttpServletResponse response) {
        File pBlock;
        Node node;
        String fileId = request.getParameter("fileId");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (fileId != null && (node = this.fm.queryById(fileId)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(node.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.flm.queryById(node.getFileParentFolder()), account) && (pBlock = this.fbu.getFileFromBlocks(node)) != null && pBlock.exists()) {
            try {
                int pSize = Integer.parseInt(node.getFileSize());
                String format = "JPG";
                if (pSize < 3) {
                    Thumbnails.of((File[])new File[]{pBlock}).size(1080, 1080).outputFormat(format).toOutputStream((OutputStream)response.getOutputStream());
                } else if (pSize < 5) {
                    Thumbnails.of((File[])new File[]{pBlock}).size(1440, 1440).outputFormat(format).toOutputStream((OutputStream)response.getOutputStream());
                } else {
                    Thumbnails.of((File[])new File[]{pBlock}).size(1680, 1680).outputFormat(format).toOutputStream((OutputStream)response.getOutputStream());
                }
            }
            catch (IOException e) {
                try {
                    Files.copy(pBlock.toPath(), (OutputStream)response.getOutputStream());
                }
                catch (IOException e1) {
                    this.lu.writeException(e1);
                }
            }
        }
    }
}

