/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.enumeration.PowerPointType;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.VideoTranscodeThread;
import kohgylw.kiftd.server.service.ResourceService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.ContentTypeMap;
import kohgylw.kiftd.server.util.Docx2PDFUtil;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.IpAddrGetter;
import kohgylw.kiftd.server.util.KiftdFFMPEGLocator;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.NoticeUtil;
import kohgylw.kiftd.server.util.PowerPoint2PDFUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.server.util.Txt2PDFUtil;
import kohgylw.kiftd.server.util.TxtCharsetGetter;
import kohgylw.kiftd.server.util.VideoTranscodeUtil;
import org.springframework.stereotype.Service;

@Service
public class ResourceServiceImpl
implements ResourceService {
    @Resource
    private NodeMapper nm;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private LogUtil lu;
    @Resource
    private Docx2PDFUtil d2pu;
    @Resource
    private Txt2PDFUtil t2pu;
    @Resource
    private VideoTranscodeUtil vtu;
    @Resource
    private PowerPoint2PDFUtil p2pu;
    @Resource
    private FolderUtil fu;
    @Resource
    private FolderMapper fm;
    @Resource
    private TxtCharsetGetter tcg;
    @Resource
    private NoticeUtil nu;
    @Resource
    private ContentTypeMap ctm;
    @Resource
    private KiftdFFMPEGLocator kfl;
    @Resource
    private IpAddrGetter idg;
    private static final long RESOURCE_CACHE_MAX_AGE = 1800L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getResource(String fid, HttpServletRequest request, HttpServletResponse response) {
        Node n;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (fid != null && (n = this.nm.queryById(fid)) != null) {
            if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(n.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.fm.queryById(n.getFileParentFolder()), account)) {
                File file = this.fbu.getFileFromBlocks(n);
                if (file != null && file.isFile()) {
                    String suffix = "";
                    if (n.getFileName().indexOf(".") >= 0) {
                        suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
                    }
                    String contentType = this.ctm.getContentType(suffix);
                    switch (suffix) {
                        case ".mp4": 
                        case ".webm": 
                        case ".mov": 
                        case ".avi": 
                        case ".wmv": 
                        case ".mkv": 
                        case ".flv": {
                            if (!this.kfl.isEnableFFmpeg()) break;
                            contentType = "video/mp4";
                            Map<String, VideoTranscodeThread> map = VideoTranscodeUtil.videoTranscodeThreads;
                            synchronized (map) {
                                VideoTranscodeThread vtt = VideoTranscodeUtil.videoTranscodeThreads.get(fid);
                                if (vtt != null) {
                                    File f = new File(ConfigureReader.instance().getTemporaryfilePath(), vtt.getOutputFileName());
                                    if (f.isFile() && vtt.getProgress().equals("FIN")) {
                                        file = f;
                                    } else {
                                        try {
                                            response.sendError(500);
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    String ip = this.idg.getIpAddr(request);
                    String range = request.getHeader("Range");
                    int status = this.sendResource(file, n.getFileName(), contentType, request, response);
                    if (status == 200 || range != null && range.startsWith("bytes=0-")) {
                        this.lu.writeDownloadFileEvent(account, ip, n);
                    }
                    return;
                }
            } else {
                try {
                    response.sendError(401);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            response.sendError(404);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int sendResource(File resource, String fname, String contentType, HttpServletRequest request, HttpServletResponse response) {
        int status = 200;
        try (RandomAccessFile randomFile = new RandomAccessFile(resource, "r");){
            String ifUnmodifiedSince;
            long contentLength = randomFile.length();
            String lastModified = ServerTimeUtil.getLastModifiedFormBlock(resource);
            String eTag = this.fbu.getETag(resource);
            String ifModifiedSince = request.getHeader("If-Modified-Since");
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifModifiedSince != null || ifNoneMatch != null) {
                if (ifNoneMatch != null) {
                    if (ifNoneMatch.trim().equals(eTag)) {
                        status = 304;
                        response.setStatus(status);
                        int n = status;
                        return n;
                    }
                } else if (ifModifiedSince.trim().equals(lastModified)) {
                    status = 304;
                    response.setStatus(status);
                    int n = status;
                    return n;
                }
            }
            if ((ifUnmodifiedSince = request.getHeader("If-Unmodified-Since")) != null && !ifUnmodifiedSince.trim().equals(lastModified)) {
                status = 412;
                response.setStatus(status);
                int n = status;
                return n;
            }
            String ifMatch = request.getHeader("If-Match");
            if (ifMatch != null && !ifMatch.trim().equals(eTag)) {
                status = 412;
                response.setStatus(status);
                int n = status;
                return n;
            }
            String range = request.getHeader("Range");
            long start = 0L;
            long end = 0L;
            if (range != null && range.startsWith("bytes=")) {
                String[] values = range.split("=")[1].split("-");
                start = Long.parseLong(values[0]);
                if (values.length > 1) {
                    end = Long.parseLong(values[1]);
                }
            }
            long requestSize = 0L;
            requestSize = end != 0L && end > start ? end - start + 1L : Long.MAX_VALUE;
            byte[] buffer = new byte[ConfigureReader.instance().getBuffSize()];
            response.setContentType(contentType);
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", this.fbu.getETag(resource));
            response.setHeader("Last-Modified", ServerTimeUtil.getLastModifiedFormBlock(resource));
            response.setHeader("Cache-Control", "max-age=1800");
            String ifRange = request.getHeader("If-Range");
            if (range != null && range.startsWith("bytes=") && (ifRange == null || ifRange.trim().equals(eTag) || ifRange.trim().equals(lastModified))) {
                status = 206;
                response.setStatus(status);
                long requestStart = 0L;
                long requestEnd = 0L;
                String[] ranges = range.split("=");
                if (ranges.length > 1) {
                    String[] rangeDatas = ranges[1].split("-");
                    requestStart = Long.parseLong(rangeDatas[0]);
                    if (rangeDatas.length > 1) {
                        requestEnd = Long.parseLong(rangeDatas[1]);
                    }
                }
                long length = 0L;
                if (requestEnd > 0L) {
                    length = requestEnd - requestStart + 1L;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + contentLength);
                } else {
                    length = contentLength - requestStart;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + (contentLength - 1L) + "/" + contentLength);
                }
            } else {
                response.setHeader("Content-length", contentLength + "");
            }
            ServletOutputStream out = response.getOutputStream();
            randomFile.seek(start);
            for (long needSize = requestSize; needSize > 0L; needSize -= (long)buffer.length) {
                int len = randomFile.read(buffer);
                if (needSize < (long)buffer.length) {
                    out.write(buffer, 0, (int)needSize);
                    continue;
                }
                out.write(buffer, 0, len);
                if (len < buffer.length) break;
            }
            out.close();
            int n = status;
            return n;
        }
        catch (Exception e) {
            return 500;
        }
    }

    @Override
    public void getWordView(String fileId, HttpServletRequest request, HttpServletResponse response) {
        File file;
        Node n;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (fileId != null && (n = this.nm.queryById(fileId)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(n.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.fm.queryById(n.getFileParentFolder()), account) && (file = this.fbu.getFileFromBlocks(n)) != null && file.isFile()) {
            String suffix = "";
            if (n.getFileName().indexOf(".") >= 0) {
                suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
            }
            if (".docx".equals(suffix)) {
                String contentType = this.ctm.getContentType(".pdf");
                response.setContentType(contentType);
                String ip = this.idg.getIpAddr(request);
                try {
                    this.d2pu.convertPdf(new FileInputStream(file), (OutputStream)response.getOutputStream());
                    this.lu.writeDownloadFileEvent(account, ip, n);
                    return;
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    Printer.instance.print(e.getMessage());
                    this.lu.writeException(e);
                }
            }
        }
        try {
            response.sendError(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void getTxtView(String fileId, HttpServletRequest request, HttpServletResponse response) {
        File file;
        Node n;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (fileId != null && (n = this.nm.queryById(fileId)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(n.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.fm.queryById(n.getFileParentFolder()), account) && (file = this.fbu.getFileFromBlocks(n)) != null && file.isFile()) {
            String suffix = "";
            if (n.getFileName().indexOf(".") >= 0) {
                suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
            }
            if (".txt".equals(suffix)) {
                String contentType = this.ctm.getContentType(".pdf");
                response.setContentType(contentType);
                String ip = this.idg.getIpAddr(request);
                try {
                    this.t2pu.convertPdf(file, (OutputStream)response.getOutputStream());
                    this.lu.writeDownloadFileEvent(account, ip, n);
                    return;
                }
                catch (Exception e) {
                    Printer.instance.print(e.getMessage());
                    this.lu.writeException(e);
                }
            }
        }
        try {
            response.sendError(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getVideoTranscodeStatus(HttpServletRequest request) {
        String fId;
        if (this.kfl.isEnableFFmpeg() && (fId = request.getParameter("fileId")) != null) {
            try {
                return this.vtu.getTranscodeProcess(fId);
            }
            catch (Exception e) {
                Printer.instance.print("\u9519\u8bef\uff1a\u89c6\u9891\u8f6c\u7801\u529f\u80fd\u51fa\u73b0\u610f\u5916\u9519\u8bef\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
                this.lu.writeException(e);
            }
        }
        return "ERROR";
    }

    @Override
    public void getPPTView(String fileId, HttpServletRequest request, HttpServletResponse response) {
        File file;
        Node n;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (fileId != null && (n = this.nm.queryById(fileId)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(n.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.fm.queryById(n.getFileParentFolder()), account) && (file = this.fbu.getFileFromBlocks(n)) != null && file.isFile()) {
            String suffix = "";
            if (n.getFileName().indexOf(".") >= 0) {
                suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
            }
            switch (suffix) {
                case ".ppt": 
                case ".pptx": {
                    String contentType = this.ctm.getContentType(".pdf");
                    response.setContentType(contentType);
                    String ip = this.idg.getIpAddr(request);
                    try {
                        this.p2pu.convertPdf(new FileInputStream(file), (OutputStream)response.getOutputStream(), ".ppt".equals(suffix) ? PowerPointType.PPT : PowerPointType.PPTX);
                        this.lu.writeDownloadFileEvent(account, ip, n);
                        return;
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    catch (Exception e) {
                        Printer.instance.print(e.getMessage());
                        this.lu.writeException(e);
                        break;
                    }
                }
            }
        }
        try {
            response.sendError(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void getLRContextByUTF8(String fileId, HttpServletRequest request, HttpServletResponse response) {
        File file;
        Node n;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        String ip = this.idg.getIpAddr(request);
        if (fileId != null && (n = this.nm.queryById(fileId)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(n.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.fm.queryById(n.getFileParentFolder()), account) && (file = this.fbu.getFileFromBlocks(n)) != null && file.isFile()) {
            String ifModifiedSince = request.getHeader("If-Modified-Since");
            if (ifModifiedSince != null && ifModifiedSince.trim().equals(ServerTimeUtil.getLastModifiedFormBlock(file))) {
                response.setStatus(304);
                return;
            }
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null && ifNoneMatch.trim().equals(this.fbu.getETag(file))) {
                response.setStatus(304);
                return;
            }
            String suffix = "";
            if (n.getFileName().indexOf(".") >= 0) {
                suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
            }
            if (".lrc".equals(suffix)) {
                String contentType = "text/plain";
                response.setContentType(contentType);
                response.setCharacterEncoding("UTF-8");
                response.setHeader("ETag", this.fbu.getETag(file));
                response.setHeader("Last-Modified", ServerTimeUtil.getLastModifiedFormBlock(file));
                response.setHeader("Cache-Control", "max-age=1800");
                try {
                    String line;
                    String inputFileEncode = this.tcg.getTxtCharset(new FileInputStream(file));
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), inputFileEncode));
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
                    while ((line = bufferedReader.readLine()) != null) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.close();
                    bufferedReader.close();
                    this.lu.writeDownloadFileEvent(account, ip, n);
                    return;
                }
                catch (IOException inputFileEncode) {
                }
                catch (Exception e) {
                    Printer.instance.print(e.getMessage());
                    this.lu.writeException(e);
                }
            }
        }
        try {
            response.sendError(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void getNoticeContext(HttpServletRequest request, HttpServletResponse response) {
        File noticeHTML = new File(ConfigureReader.instance().getTemporaryfilePath(), "notice.html");
        String contentType = "text/html";
        if (noticeHTML.isFile() && noticeHTML.canRead()) {
            this.sendResource(noticeHTML, "notice.md", contentType, request, response);
        } else {
            try {
                response.setContentType(contentType);
                response.setCharacterEncoding("UTF-8");
                PrintWriter writer = response.getWriter();
                writer.write("<p class=\"lead\">\u6682\u65e0\u65b0\u516c\u544a\u3002</p>");
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getNoticeMD5() {
        return this.nu.getMd5();
    }
}

