/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.io.File;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.VideoInfo;
import kohgylw.kiftd.server.service.PlayVideoService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.KiftdFFMPEGLocator;
import kohgylw.kiftd.server.util.LogUtil;
import org.springframework.stereotype.Service;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.process.ProcessLocator;

@Service
public class PlayVideoServiceImpl
implements PlayVideoService {
    @Resource
    private NodeMapper fm;
    @Resource
    private Gson gson;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private LogUtil lu;
    @Resource
    private FolderMapper flm;
    @Resource
    private FolderUtil fu;
    @Resource
    private KiftdFFMPEGLocator kfl;

    private VideoInfo foundVideo(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        if (fileId != null && fileId.length() > 0) {
            Node f = this.fm.queryById(fileId);
            VideoInfo vi = new VideoInfo(f);
            if (f != null) {
                String account = (String)request.getSession().getAttribute("ACCOUNT");
                if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(f.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.flm.queryById(f.getFileParentFolder()), account)) {
                    String suffix;
                    String fileName = f.getFileName();
                    switch (suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) {
                        case "mp4": {
                            if (this.kfl.isEnableFFmpeg()) {
                                File target = this.fbu.getFileFromBlocks(f);
                                if (target == null || !target.isFile()) {
                                    return null;
                                }
                                MultimediaObject mo = new MultimediaObject(target, (ProcessLocator)this.kfl);
                                try {
                                    if (mo.getInfo().getVideo().getDecoder().indexOf("h264") >= 0) {
                                        vi.setNeedEncode("N");
                                        return vi;
                                    }
                                }
                                catch (Exception e) {
                                    Printer.instance.print("\u9519\u8bef\uff1a\u89c6\u9891\u6587\u4ef6\u201c" + f.getFileName() + "\u201d\u5728\u89e3\u6790\u65f6\u51fa\u73b0\u610f\u5916\u9519\u8bef\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
                                    this.lu.writeException(e);
                                }
                                vi.setNeedEncode("Y");
                            } else {
                                vi.setNeedEncode("N");
                            }
                            return vi;
                        }
                        case "mkv": 
                        case "mov": 
                        case "webm": 
                        case "avi": 
                        case "wmv": 
                        case "flv": {
                            if (this.kfl.isEnableFFmpeg()) {
                                vi.setNeedEncode("Y");
                            } else {
                                vi.setNeedEncode("N");
                            }
                            return vi;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getPlayVideoJson(HttpServletRequest request) {
        VideoInfo v = this.foundVideo(request);
        if (v != null) {
            return this.gson.toJson((Object)v);
        }
        return "ERROR";
    }
}

