/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.AudioInfoList;
import kohgylw.kiftd.server.service.PlayAudioService;
import kohgylw.kiftd.server.util.AudioInfoUtil;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FolderUtil;
import org.springframework.stereotype.Service;

@Service
public class PlayAudioServiceImpl
implements PlayAudioService {
    @Resource
    private NodeMapper fm;
    @Resource
    private AudioInfoUtil aiu;
    @Resource
    private Gson gson;
    @Resource
    private FolderUtil fu;
    @Resource
    private FolderMapper flm;

    private AudioInfoList foundAudios(HttpServletRequest request) {
        Node targetNode;
        String fileId = request.getParameter("fileId");
        if (fileId != null && fileId.length() > 0 && (targetNode = this.fm.queryById(fileId)) != null) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(targetNode.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.flm.queryById(targetNode.getFileParentFolder()), account)) {
                List<Node> blocks = this.fm.queryBySomeFolder(fileId);
                return this.aiu.transformToAudioInfoList(blocks, fileId);
            }
        }
        return null;
    }

    @Override
    public String getAudioInfoListByJson(HttpServletRequest request) {
        AudioInfoList ail = this.foundAudios(request);
        if (ail != null) {
            return this.gson.toJson((Object)ail);
        }
        return "ERROR";
    }
}

