/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.FolderView;
import kohgylw.kiftd.server.pojo.RemainingFolderView;
import kohgylw.kiftd.server.pojo.SreachView;
import kohgylw.kiftd.server.service.FolderViewService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.KiftdFFMPEGLocator;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import org.springframework.stereotype.Service;

@Service
public class FolderViewServiceImpl
implements FolderViewService {
    private static int SELECT_STEP = 256;
    @Resource
    private FolderUtil fu;
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper flm;
    @Resource
    private Gson gson;
    @Resource
    private KiftdFFMPEGLocator kfl;

    @Override
    public String getFolderViewToJson(String fid, HttpSession session, HttpServletRequest request) {
        ConfigureReader cr = ConfigureReader.instance();
        if (fid == null || fid.length() == 0) {
            return "ERROR";
        }
        Folder vf = this.fm.queryById(fid);
        if (vf == null) {
            return "NOT_FOUND";
        }
        String account = (String)session.getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().accessFolder(vf, account)) {
            return "notAccess";
        }
        FolderView fv = new FolderView();
        fv.setSelectStep(SELECT_STEP);
        fv.setFolder(vf);
        fv.setParentList(this.fu.getParentList(fid));
        long foldersOffset = this.fm.countByParentId(fid);
        fv.setFoldersOffset(foldersOffset);
        HashMap<String, Object> keyMap1 = new HashMap<String, Object>();
        keyMap1.put("pid", fid);
        long fOffset = foldersOffset - (long)SELECT_STEP;
        keyMap1.put("offset", fOffset > 0L ? fOffset : 0L);
        keyMap1.put("rows", SELECT_STEP);
        List<Folder> folders = this.fm.queryByParentIdSection(keyMap1);
        LinkedList<Folder> fs = new LinkedList<Folder>();
        for (Folder f : folders) {
            if (!ConfigureReader.instance().accessFolder(f, account)) continue;
            fs.add(f);
        }
        fv.setFolderList(fs);
        long filesOffset = this.flm.countByParentFolderId(fid);
        fv.setFilesOffset(filesOffset);
        HashMap<String, Object> keyMap2 = new HashMap<String, Object>();
        keyMap2.put("pfid", fid);
        long fiOffset = filesOffset - (long)SELECT_STEP;
        keyMap2.put("offset", fiOffset > 0L ? fiOffset : 0L);
        keyMap2.put("rows", SELECT_STEP);
        fv.setFileList(this.flm.queryByParentFolderIdSection(keyMap2));
        if (account != null) {
            fv.setAccount(account);
        }
        if (ConfigureReader.instance().isAllowChangePassword()) {
            fv.setAllowChangePassword("true");
        } else {
            fv.setAllowChangePassword("false");
        }
        if (ConfigureReader.instance().isAllowSignUp()) {
            fv.setAllowSignUp("true");
        } else {
            fv.setAllowSignUp("false");
        }
        ArrayList<String> authList = new ArrayList<String>();
        if (cr.authorized(account, AccountAuth.UPLOAD_FILES, this.fu.getAllFoldersId(fid))) {
            authList.add("U");
        }
        if (cr.authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(fid))) {
            authList.add("C");
        }
        if (cr.authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(fid))) {
            authList.add("D");
        }
        if (cr.authorized(account, AccountAuth.RENAME_FILE_OR_FOLDER, this.fu.getAllFoldersId(fid))) {
            authList.add("R");
        }
        if (cr.authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(fid))) {
            authList.add("L");
            if (cr.isOpenFileChain()) {
                fv.setShowFileChain("true");
            } else {
                fv.setShowFileChain("false");
            }
        }
        if (cr.authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(fid))) {
            authList.add("M");
        }
        fv.setAuthList(authList);
        fv.setPublishTime(ServerTimeUtil.accurateToMinute());
        fv.setEnableFFMPEG(this.kfl.isEnableFFmpeg());
        fv.setEnableDownloadZip(ConfigureReader.instance().isEnableDownloadByZip());
        return this.gson.toJson((Object)fv);
    }

    @Override
    public String getSreachViewToJson(HttpServletRequest request) {
        ConfigureReader cr = ConfigureReader.instance();
        String fid = request.getParameter("fid");
        String keyWorld = request.getParameter("keyworld");
        if (fid == null || fid.length() == 0 || keyWorld == null) {
            return "ERROR";
        }
        if (keyWorld.length() == 0) {
            return this.getFolderViewToJson(fid, request.getSession(), request);
        }
        Folder vf = this.fm.queryById(fid);
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().accessFolder(vf, account)) {
            return "notAccess";
        }
        SreachView sv = new SreachView();
        Folder sf = new Folder();
        sf.setFolderId(vf.getFolderId());
        sf.setFolderName("\u5728\u201c" + vf.getFolderName() + "\u201d\u5185\u641c\u7d22\u201c" + keyWorld + "\u201d\u7684\u7ed3\u679c...");
        sf.setFolderParent(vf.getFolderId());
        sf.setFolderCreator("--");
        sf.setFolderCreationDate("--");
        sf.setFolderConstraint(vf.getFolderConstraint());
        sv.setFolder(sf);
        List<Folder> pl = this.fu.getParentList(fid);
        pl.add(vf);
        sv.setParentList(pl);
        LinkedList<Node> ns = new LinkedList<Node>();
        LinkedList<Folder> fs = new LinkedList<Folder>();
        this.sreachFilesAndFolders(fid, keyWorld.toUpperCase(), account, ns, fs);
        sv.setFileList(ns);
        sv.setFolderList(fs);
        sv.setFoldersOffset(0L);
        sv.setFilesOffset(0L);
        sv.setSelectStep(SELECT_STEP);
        if (account != null) {
            sv.setAccount(account);
        }
        if (ConfigureReader.instance().isAllowChangePassword()) {
            sv.setAllowChangePassword("true");
        } else {
            sv.setAllowChangePassword("false");
        }
        ArrayList<String> authList = new ArrayList<String>();
        if (cr.authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(fid))) {
            authList.add("L");
            if (cr.isOpenFileChain()) {
                sv.setShowFileChain("true");
            } else {
                sv.setShowFileChain("false");
            }
        }
        authList.add("O");
        sv.setAuthList(authList);
        sv.setPublishTime(ServerTimeUtil.accurateToMinute());
        sv.setKeyWorld(keyWorld);
        sv.setEnableFFMPEG(this.kfl.isEnableFFmpeg());
        sv.setEnableDownloadZip(ConfigureReader.instance().isEnableDownloadByZip());
        return this.gson.toJson((Object)sv);
    }

    private void sreachFilesAndFolders(String fid, String key, String account, List<Node> ns, List<Folder> fs) {
        for (Folder f : this.fm.queryByParentId(fid)) {
            if (!ConfigureReader.instance().accessFolder(f, account)) continue;
            if (f.getFolderName().toUpperCase().indexOf(key) >= 0) {
                f.setFolderName(f.getFolderName());
                fs.add(f);
            }
            this.sreachFilesAndFolders(f.getFolderId(), key, account, ns, fs);
        }
        for (Node n : this.flm.queryByParentFolderId(fid)) {
            if (n.getFileName().toUpperCase().indexOf(key) < 0) continue;
            n.setFileName(n.getFileName());
            ns.add(n);
        }
    }

    @Override
    public String getRemainingFolderViewToJson(HttpServletRequest request) {
        String fid = request.getParameter("fid");
        String foldersOffset = request.getParameter("foldersOffset");
        String filesOffset = request.getParameter("filesOffset");
        if (fid == null || fid.length() == 0) {
            return "ERROR";
        }
        Folder vf = this.fm.queryById(fid);
        if (vf == null) {
            return "NOT_FOUND";
        }
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().accessFolder(vf, account)) {
            return "notAccess";
        }
        RemainingFolderView fv = new RemainingFolderView();
        if (foldersOffset != null) {
            try {
                long newFoldersOffset = Long.parseLong(foldersOffset);
                if (newFoldersOffset > 0L) {
                    HashMap<String, Object> keyMap1 = new HashMap<String, Object>();
                    keyMap1.put("pid", fid);
                    long nfOffset = newFoldersOffset - (long)SELECT_STEP;
                    keyMap1.put("offset", nfOffset > 0L ? nfOffset : 0L);
                    keyMap1.put("rows", nfOffset > 0L ? (long)SELECT_STEP : newFoldersOffset);
                    List<Folder> folders = this.fm.queryByParentIdSection(keyMap1);
                    LinkedList<Folder> fs = new LinkedList<Folder>();
                    for (Folder f : folders) {
                        if (!ConfigureReader.instance().accessFolder(f, account)) continue;
                        fs.add(f);
                    }
                    fv.setFolderList(fs);
                }
            }
            catch (NumberFormatException e) {
                return "ERROR";
            }
        }
        if (filesOffset != null) {
            try {
                long newFilesOffset = Long.parseLong(filesOffset);
                if (newFilesOffset > 0L) {
                    HashMap<String, Object> keyMap2 = new HashMap<String, Object>();
                    keyMap2.put("pfid", fid);
                    long nfiOffset = newFilesOffset - (long)SELECT_STEP;
                    keyMap2.put("offset", nfiOffset > 0L ? nfiOffset : 0L);
                    keyMap2.put("rows", nfiOffset > 0L ? (long)SELECT_STEP : newFilesOffset);
                    fv.setFileList(this.flm.queryByParentFolderIdSection(keyMap2));
                }
            }
            catch (NumberFormatException e) {
                return "ERROR";
            }
        }
        return this.gson.toJson((Object)fv);
    }
}

